// Copyright 2022 The Flutter Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file or at https://developers.google.com/open-source/licenses/bsd.

import 'package:devtools_app/devtools.dart' as devtools;
import 'package:devtools_app/devtools_app.dart';
import 'package:devtools_app/src/framework/scaffold/about_dialog.dart';
import 'package:devtools_app_shared/ui.dart';
import 'package:devtools_app_shared/utils.dart';
import 'package:devtools_test/devtools_test.dart';
import 'package:devtools_test/helpers.dart';
import 'package:flutter_test/flutter_test.dart';
import 'package:mockito/mockito.dart';

void main() {
  late DevToolsAboutDialog aboutDialog;

  group('About Dialog', () {
    setUp(() {
      aboutDialog = DevToolsAboutDialog(ReleaseNotesController());
      final fakeServiceConnection = FakeServiceConnectionManager();
      when(fakeServiceConnection.serviceManager.vm.version).thenReturn('1.9.1');
      when(
        fakeServiceConnection.serviceManager.vm.targetCPU,
      ).thenReturn('arm64');
      when(
        fakeServiceConnection.serviceManager.vm.architectureBits,
      ).thenReturn(64);
      when(
        fakeServiceConnection.serviceManager.vm.operatingSystem,
      ).thenReturn('android');

      mockConnectedApp(fakeServiceConnection.serviceManager.connectedApp!);
      setGlobal(ServiceConnectionManager, fakeServiceConnection);
      setGlobal(
        DevToolsEnvironmentParameters,
        ExternalDevToolsEnvironmentParameters(),
      );
      setGlobal(IdeTheme, IdeTheme());
    });

    testWidgets('builds dialog', (WidgetTester tester) async {
      await tester.pumpWidget(wrap(aboutDialog));
      expect(find.text('About DevTools'), findsOneWidget);
      expect(find.text('VIEW LICENSES'), findsOneWidget);
    });

    testWidgets('content renders correctly', (WidgetTester tester) async {
      await tester.pumpWidget(wrap(aboutDialog));
      expect(find.text('About DevTools'), findsOneWidget);
      expect(find.textContaining(devtools.version), findsOneWidget);
      expect(find.text('release notes'), findsOneWidget);
      expect(find.textContaining('Encountered an issue?'), findsOneWidget);
      expect(
        findSubstring('github.com/flutter/devtools/issues/new'),
        findsOneWidget,
      );
      expect(find.text('Contributing'), findsOneWidget);
      expect(
        find.textContaining('Want to contribute to DevTools?'),
        findsOneWidget,
      );
      expect(findSubstring('CONTRIBUTING'), findsOneWidget);
      expect(find.textContaining('connect with us on'), findsOneWidget);
      expect(findSubstring('Discord'), findsOneWidget);
    });
  });
}
