// Copyright 2020 The Flutter Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file or at https://developers.google.com/open-source/licenses/bsd.

/// About a 30 second run starting at 08:45:10 till 08:45:39
/// Contains 1 manual snapshot, 2 auto snapshots, 3 manual GCs,
/// Also contains, 3 allocation profiles (81 total allocation events):
///     - 2 allocation monitors followed
///     - 1 allocation reset
/// 46 VM GC events
/// Dart Heap capacity ~423 MB, Used ~52 MB, External 357 MB, and RSS 735 MB
/// 104 samples
///
/// How to create a new test data set. Run DevTools collecting stats then press
/// the Export button. Then copy the contents of the exported file and assign to
/// testHeapSampleData.
const testHeapSampleData = r'''
{"samples": {"version": 1, "dartDevToolsScreen": "memory", "data": [
{"timestamp":1611247510202,"rss":345870336,"capacity":129779464,"used":44373280,"external":77395720,"gc":false,"adb_memoryInfo":{"Realtime":600008716,"Java Heap":7794688,"Native Heap":94666752,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":139309056,"System":5227520,"Total":265864192},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":0}},
{"timestamp":1611247510833,"rss":345952256,"capacity":129779464,"used":44373280,"external":77395720,"gc":false,"adb_memoryInfo":{"Realtime":600009387,"Java Heap":7786496,"Native Heap":94760960,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":139304960,"System":5227520,"Total":265946112},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":0}},
{"timestamp":1611247511463,"rss":345948160,"capacity":129779464,"used":44373280,"external":77395720,"gc":false,"adb_memoryInfo":{"Realtime":600010018,"Java Heap":7786496,"Native Heap":94851072,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":139304960,"System":5227520,"Total":266036224},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":0}},
{"timestamp":1611247512097,"rss":346210304,"capacity":129779464,"used":44373280,"external":77395720,"gc":false,"adb_memoryInfo":{"Realtime":600010654,"Java Heap":7786496,"Native Heap":95019008,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":139304960,"System":5227520,"Total":266204160},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":0}},
{"timestamp":1611247512730,"rss":346415104,"capacity":129779464,"used":44373280,"external":77395720,"gc":false,"adb_memoryInfo":{"Realtime":600011281,"Java Heap":7786496,"Native Heap":95182848,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":139304960,"System":5227520,"Total":266368000},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":0}},
{"timestamp":1611247513365,"rss":346411008,"capacity":129779464,"used":44373280,"external":77395720,"gc":false,"adb_memoryInfo":{"Realtime":600011919,"Java Heap":7786496,"Native Heap":95330304,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":139304960,"System":5227520,"Total":266515456},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":0}},
{"timestamp":1611247513721,"rss":346411008,"capacity":129776440,"used":41857920,"external":77392696,"gc":true,"adb_memoryInfo":{"Realtime":600011919,"Java Heap":7786496,"Native Heap":95330304,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":139304960,"System":5227520,"Total":266515456},"memory_eventInfo":{"timestamp":1611247513721,"gcEvent":true,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":null,"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":0}},
{"timestamp":1611247513723,"rss":346411008,"capacity":129650912,"used":41696968,"external":77267168,"gc":true,"adb_memoryInfo":{"Realtime":600011919,"Java Heap":7786496,"Native Heap":95330304,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":139304960,"System":5227520,"Total":266515456},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":0}},
{"timestamp":1611247513992,"rss":348868608,"capacity":129650912,"used":42221256,"external":77267168,"gc":false,"adb_memoryInfo":{"Realtime":600012547,"Java Heap":7786496,"Native Heap":97558528,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":139456512,"System":5227520,"Total":268895232},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":0}},
{"timestamp":1611247514732,"rss":348868608,"capacity":129650912,"used":41697192,"external":77267168,"gc":true,"adb_memoryInfo":{"Realtime":600013167,"Java Heap":7786496,"Native Heap":97701888,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":139460608,"System":5227520,"Total":269042688},"memory_eventInfo":{"timestamp":1611247514732,"gcEvent":true,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":null,"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":0}},
{"timestamp":1611247514733,"rss":348868608,"capacity":129650912,"used":41696968,"external":77267168,"gc":true,"adb_memoryInfo":{"Realtime":600013167,"Java Heap":7786496,"Native Heap":97701888,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":139460608,"System":5227520,"Total":269042688},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":0}},
{"timestamp":1611247514747,"rss":349745152,"capacity":129650912,"used":42221256,"external":77267168,"gc":false,"adb_memoryInfo":{"Realtime":600013167,"Java Heap":7786496,"Native Heap":97701888,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":139460608,"System":5227520,"Total":269042688},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":0}},
{"timestamp":1611247515391,"rss":349782016,"capacity":129650912,"used":42221256,"external":77267168,"gc":false,"adb_memoryInfo":{"Realtime":600013936,"Java Heap":7786496,"Native Heap":98533376,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":139456512,"System":5227520,"Total":269870080},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":0}},
{"timestamp":1611247515644,"rss":349782016,"capacity":129650912,"used":41697192,"external":77267168,"gc":true,"adb_memoryInfo":{"Realtime":600013936,"Java Heap":7786496,"Native Heap":98533376,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":139456512,"System":5227520,"Total":269870080},"memory_eventInfo":{"timestamp":1611247515644,"gcEvent":true,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":null,"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":0}},
{"timestamp":1611247515645,"rss":349782016,"capacity":129650912,"used":41696968,"external":77267168,"gc":true,"adb_memoryInfo":{"Realtime":600013936,"Java Heap":7786496,"Native Heap":98533376,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":139456512,"System":5227520,"Total":269870080},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":0}},
{"timestamp":1611247516025,"rss":351879168,"capacity":129650912,"used":42221256,"external":77267168,"gc":false,"adb_memoryInfo":{"Realtime":600014575,"Java Heap":7786496,"Native Heap":100405248,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":139460608,"System":5227520,"Total":271746048},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":0}},
{"timestamp":1611247516687,"rss":351879168,"capacity":130732976,"used":43488960,"external":77300656,"gc":true,"adb_memoryInfo":{"Realtime":600015215,"Java Heap":7794688,"Native Heap":100368384,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":139862016,"System":5227520,"Total":272118784},"memory_eventInfo":{"timestamp":1611247516687,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":null,"extensionEvents":{"0":{"timestamp":1611247516734,"eventKind":"Flutter.ImageSizesForFrame","data":{"https://www.nasa.gov/sites/default/files/styles/full_width_feature/public/thumbnails/image/iss063e012660.jpg":{"source":"https://www.nasa.gov/sites/default/files/styles/full_width_feature/public/thumbnails/image/iss063e012660.jpg","displaySize":{"width":411.42857142857144,"height":500.0},"imageSize":{"width":1041.0,"height":694.0},"displaySizeInBytes":1097142,"decodedSizeInBytes":3853088}},"customEventName":null}}},"raster_cache":{"layerBytes":0,"pictureBytes":0}},
{"timestamp":1611247516894,"rss":351985664,"capacity":130205200,"used":43214608,"external":77297168,"gc":false,"adb_memoryInfo":{"Realtime":600015215,"Java Heap":7794688,"Native Heap":100368384,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":139862016,"System":5227520,"Total":272118784},"memory_eventInfo":{"timestamp":1611247516894,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":null,"extensionEvents":{"0":{"timestamp":1611247516874,"eventKind":"Flutter.ImageSizesForFrame","data":{"https://www.nasa.gov/sites/default/files/styles/full_width_feature/public/thumbnails/image/iss059e072286.jpg":{"source":"https://www.nasa.gov/sites/default/files/styles/full_width_feature/public/thumbnails/image/iss059e072286.jpg","displaySize":{"width":411.42857142857144,"height":500.0},"imageSize":{"width":1041.0,"height":694.0},"displaySizeInBytes":1097142,"decodedSizeInBytes":3853088}},"customEventName":null}}},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247517590,"rss":352251904,"capacity":131261464,"used":44568568,"external":77829144,"gc":false,"adb_memoryInfo":{"Realtime":600016068,"Java Heap":7843840,"Native Heap":99991552,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":140111872,"System":5227520,"Total":272040960},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247518323,"rss":378310656,"capacity":134018352,"used":46863608,"external":80586032,"gc":false,"adb_memoryInfo":{"Realtime":600016790,"Java Heap":7835648,"Native Heap":121569280,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":141045760,"System":5227520,"Total":294544384},"memory_eventInfo":{"timestamp":1611247518323,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":null,"extensionEvents":{"0":{"timestamp":1611247518083,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://www.nasa.gov/sites/default/files/styles/full_width_feature/public/thumbnails/image/iss063e009965.jpg"},"customEventName":"MyFirstApp"},"1":{"timestamp":1611247518132,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://www.nasa.gov/sites/default/files/styles/full_width_feature/public/thumbnails/image/iss063e009535.jpg"},"customEventName":"MyFirstApp"},"2":{"timestamp":1611247518297,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://www.nasa.gov/sites/default/files/styles/full_width_feature/public/thumbnails/image/iss063e006714.jpg"},"customEventName":"MyFirstApp"}}},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247518509,"rss":378310656,"capacity":153625464,"used":44384952,"external":100193144,"gc":true,"adb_memoryInfo":{"Realtime":600016790,"Java Heap":7835648,"Native Heap":121569280,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":141045760,"System":5227520,"Total":294544384},"memory_eventInfo":{"timestamp":1611247518509,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":null,"extensionEvents":{"0":{"timestamp":1611247518479,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://www.nasa.gov/sites/default/files/styles/full_width_feature/public/thumbnails/image/iss063e006674.jpg"},"customEventName":"MyFirstApp"}}},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247518514,"rss":378310656,"capacity":153071176,"used":43980568,"external":100163144,"gc":true,"adb_memoryInfo":{"Realtime":600016790,"Java Heap":7835648,"Native Heap":121569280,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":141045760,"System":5227520,"Total":294544384},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247519060,"rss":375541760,"capacity":157881656,"used":44555192,"external":104973624,"gc":false,"adb_memoryInfo":{"Realtime":600017510,"Java Heap":7798784,"Native Heap":128946176,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":140419072,"System":5227520,"Total":301257728},"memory_eventInfo":{"timestamp":1611247519060,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":null,"extensionEvents":{"0":{"timestamp":1611247518917,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/jsc2020e016257/jsc2020e016257~orig.jpg"},"customEventName":"MyFirstApp"},"1":{"timestamp":1611247518945,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/jsc2020e016257/jsc2020e016257~orig.jpg"},"customEventName":"MyFirstApp"},"2":{"timestamp":1611247518946,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/S67-50903/S67-50903~orig.jpg"},"customEventName":"MyFirstApp"},"3":{"timestamp":1611247518977,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/S67-50903/S67-50903~orig.jpg"},"customEventName":"MyFirstApp"},"4":{"timestamp":1611247518977,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/jsc2020e016257/jsc2020e016257~orig.jpg"},"customEventName":"MyFirstApp"},"5":{"timestamp":1611247518978,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/PIA23872/PIA23872~orig.jpg"},"customEventName":"MyFirstApp"},"6":{"timestamp":1611247519008,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/S67-50903/S67-50903~orig.jpg"},"customEventName":"MyFirstApp"},"7":{"timestamp":1611247519009,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/PIA23872/PIA23872~orig.jpg"},"customEventName":"MyFirstApp"},"8":{"timestamp":1611247519009,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/jsc2020e016257/jsc2020e016257~orig.jpg"},"customEventName":"MyFirstApp"},"9":{"timestamp":1611247519071,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/PIA23872/PIA23872~orig.jpg"},"customEventName":"MyFirstApp"},"10":{"timestamp":1611247519071,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/S67-50903/S67-50903~orig.jpg"},"customEventName":"MyFirstApp"},"11":{"timestamp":1611247519072,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/jsc2020e016257/jsc2020e016257~orig.jpg"},"customEventName":"MyFirstApp"}}},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247519346,"rss":375541760,"capacity":158914240,"used":45216848,"external":105125568,"gc":true,"adb_memoryInfo":{"Realtime":600017510,"Java Heap":7798784,"Native Heap":128946176,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":140419072,"System":5227520,"Total":301257728},"memory_eventInfo":{"timestamp":1611247519346,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":null,"extensionEvents":{"0":{"timestamp":1611247519157,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/S67-50903/S67-50903~orig.jpg"},"customEventName":"MyFirstApp"},"1":{"timestamp":1611247519157,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/jsc2020e016257/jsc2020e016257~orig.jpg"},"customEventName":"MyFirstApp"},"2":{"timestamp":1611247519157,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/PIA23872/PIA23872~orig.jpg"},"customEventName":"MyFirstApp"},"3":{"timestamp":1611247519186,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/S67-50903/S67-50903~orig.jpg"},"customEventName":"MyFirstApp"},"4":{"timestamp":1611247519187,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/jsc2020e016257/jsc2020e016257~orig.jpg"},"customEventName":"MyFirstApp"},"5":{"timestamp":1611247519187,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/PIA23872/PIA23872~orig.jpg"},"customEventName":"MyFirstApp"},"6":{"timestamp":1611247519209,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/PIA23872/PIA23872~orig.jpg"},"customEventName":"MyFirstApp"},"7":{"timestamp":1611247519210,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/S67-50903/S67-50903~orig.jpg"},"customEventName":"MyFirstApp"},"8":{"timestamp":1611247519210,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/jsc2020e016257/jsc2020e016257~orig.jpg"},"customEventName":"MyFirstApp"},"9":{"timestamp":1611247519263,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/PIA23872/PIA23872~orig.jpg"},"customEventName":"MyFirstApp"},"10":{"timestamp":1611247519264,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/S67-50903/S67-50903~orig.jpg"},"customEventName":"MyFirstApp"},"11":{"timestamp":1611247519264,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/jsc2020e016257/jsc2020e016257~orig.jpg"},"customEventName":"MyFirstApp"},"12":{"timestamp":1611247519318,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/jsc2020e016257/jsc2020e016257~orig.jpg"},"customEventName":"MyFirstApp"},"13":{"timestamp":1611247519319,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/PIA23872/PIA23872~orig.jpg"},"customEventName":"MyFirstApp"},"14":{"timestamp":1611247519319,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/S67-50903/S67-50903~orig.jpg"},"customEventName":"MyFirstApp"},"15":{"timestamp":1611247519391,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/PIA23872/PIA23872~orig.jpg"},"customEventName":"MyFirstApp"},"16":{"timestamp":1611247519392,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/jsc2020e016257/jsc2020e016257~orig.jpg"},"customEventName":"MyFirstApp"}}},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247519452,"rss":375541760,"capacity":192828608,"used":46313280,"external":137016512,"gc":true,"adb_memoryInfo":{"Realtime":600017510,"Java Heap":7798784,"Native Heap":128946176,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":140419072,"System":5227520,"Total":301257728},"memory_eventInfo":{"timestamp":1611247519452,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":null,"extensionEvents":{"0":{"timestamp":1611247519449,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/jsc2020e016257/jsc2020e016257~orig.jpg"},"customEventName":"MyFirstApp"},"1":{"timestamp":1611247519452,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/6900556/6900556~orig.jpg"},"customEventName":"MyFirstApp"},"2":{"timestamp":1611247519453,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/as17-152-23392/as17-152-23392~orig.jpg"},"customEventName":"MyFirstApp"},"3":{"timestamp":1611247519454,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/as10-34-5026/as10-34-5026~orig.jpg"},"customEventName":"MyFirstApp"},"4":{"timestamp":1611247519463,"eventKind":"Flutter.ImageSizesForFrame","data":{"https://images-assets.nasa.gov/image/PIA23872/PIA23872~orig.jpg":{"source":"https://images-assets.nasa.gov/image/PIA23872/PIA23872~orig.jpg","displaySize":{"width":411.42857142857144,"height":500.0},"imageSize":{"width":1275.0,"height":1282.0},"displaySizeInBytes":1097142,"decodedSizeInBytes":8717600}},"customEventName":null},"5":{"timestamp":1611247519492,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/6900556/6900556~orig.jpg"},"customEventName":"MyFirstApp"},"6":{"timestamp":1611247519496,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/as17-152-23392/as17-152-23392~orig.jpg"},"customEventName":"MyFirstApp"},"7":{"timestamp":1611247519496,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/jsc2020e016257/jsc2020e016257~orig.jpg"},"customEventName":"MyFirstApp"},"8":{"timestamp":1611247519496,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/as10-34-5026/as10-34-5026~orig.jpg"},"customEventName":"MyFirstApp"},"9":{"timestamp":1611247519522,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/6900556/6900556~orig.jpg"},"customEventName":"MyFirstApp"},"10":{"timestamp":1611247519523,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/as17-152-23392/as17-152-23392~orig.jpg"},"customEventName":"MyFirstApp"},"11":{"timestamp":1611247519523,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/as10-34-5026/as10-34-5026~orig.jpg"},"customEventName":"MyFirstApp"}}},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247519688,"rss":375541760,"capacity":193366632,"used":47784248,"external":137030248,"gc":true,"adb_memoryInfo":{"Realtime":600017510,"Java Heap":7798784,"Native Heap":128946176,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":140419072,"System":5227520,"Total":301257728},"memory_eventInfo":{"timestamp":1611247519688,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":null,"extensionEvents":{"0":{"timestamp":1611247519529,"eventKind":"Flutter.ImageSizesForFrame","data":{"https://images-assets.nasa.gov/image/S67-50903/S67-50903~orig.jpg":{"source":"https://images-assets.nasa.gov/image/S67-50903/S67-50903~orig.jpg","displaySize":{"width":411.42857142857144,"height":500.0},"imageSize":{"width":1387.0,"height":3000.0},"displaySizeInBytes":1097142,"decodedSizeInBytes":22192000}},"customEventName":null},"1":{"timestamp":1611247519611,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/as10-34-5026/as10-34-5026~orig.jpg"},"customEventName":"MyFirstApp"},"2":{"timestamp":1611247519611,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/6900556/6900556~orig.jpg"},"customEventName":"MyFirstApp"},"3":{"timestamp":1611247519612,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/as17-152-23392/as17-152-23392~orig.jpg"},"customEventName":"MyFirstApp"},"4":{"timestamp":1611247519629,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/as10-34-5026/as10-34-5026~orig.jpg"},"customEventName":"MyFirstApp"},"5":{"timestamp":1611247519630,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/6900556/6900556~orig.jpg"},"customEventName":"MyFirstApp"},"6":{"timestamp":1611247519630,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/as17-152-23392/as17-152-23392~orig.jpg"},"customEventName":"MyFirstApp"},"7":{"timestamp":1611247519684,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/6900556/6900556~orig.jpg"},"customEventName":"MyFirstApp"},"8":{"timestamp":1611247519685,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/as17-152-23392/as17-152-23392~orig.jpg"},"customEventName":"MyFirstApp"},"9":{"timestamp":1611247519685,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/as10-34-5026/as10-34-5026~orig.jpg"},"customEventName":"MyFirstApp"},"10":{"timestamp":1611247519722,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/as10-34-5026/as10-34-5026~orig.jpg"},"customEventName":"MyFirstApp"},"11":{"timestamp":1611247519723,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/as17-152-23392/as17-152-23392~orig.jpg"},"customEventName":"MyFirstApp"},"12":{"timestamp":1611247519723,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/6900556/6900556~orig.jpg"},"customEventName":"MyFirstApp"},"13":{"timestamp":1611247519723,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/0201587/0201587~orig.jpg"},"customEventName":"MyFirstApp"},"14":{"timestamp":1611247519770,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/as17-152-23392/as17-152-23392~orig.jpg"},"customEventName":"MyFirstApp"},"15":{"timestamp":1611247519771,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/as10-34-5026/as10-34-5026~orig.jpg"},"customEventName":"MyFirstApp"},"16":{"timestamp":1611247519771,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/6900556/6900556~orig.jpg"},"customEventName":"MyFirstApp"},"17":{"timestamp":1611247519772,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/0201587/0201587~orig.jpg"},"customEventName":"MyFirstApp"}}},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247519880,"rss":375541760,"capacity":250110968,"used":49679568,"external":191448056,"gc":true,"adb_memoryInfo":{"Realtime":600018337,"Java Heap":7823360,"Native Heap":211734528,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":143507456,"System":5227520,"Total":387159040},"memory_eventInfo":{"timestamp":1611247519880,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":null,"extensionEvents":{"0":{"timestamp":1611247519796,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/as10-34-5026/as10-34-5026~orig.jpg"},"customEventName":"MyFirstApp"},"1":{"timestamp":1611247519796,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/6900556/6900556~orig.jpg"},"customEventName":"MyFirstApp"},"2":{"timestamp":1611247519796,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/0201587/0201587~orig.jpg"},"customEventName":"MyFirstApp"},"3":{"timestamp":1611247519797,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/as17-152-23392/as17-152-23392~orig.jpg"},"customEventName":"MyFirstApp"},"4":{"timestamp":1611247519831,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/0201587/0201587~orig.jpg"},"customEventName":"MyFirstApp"},"5":{"timestamp":1611247519831,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/as17-152-23392/as17-152-23392~orig.jpg"},"customEventName":"MyFirstApp"},"6":{"timestamp":1611247519832,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/as10-34-5026/as10-34-5026~orig.jpg"},"customEventName":"MyFirstApp"},"7":{"timestamp":1611247519832,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/6900556/6900556~orig.jpg"},"customEventName":"MyFirstApp"},"8":{"timestamp":1611247519949,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/6900556/6900556~orig.jpg"},"customEventName":"MyFirstApp"},"9":{"timestamp":1611247519949,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/0201587/0201587~orig.jpg"},"customEventName":"MyFirstApp"},"10":{"timestamp":1611247519950,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/as17-152-23392/as17-152-23392~orig.jpg"},"customEventName":"MyFirstApp"},"11":{"timestamp":1611247519950,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/as10-34-5026/as10-34-5026~orig.jpg"},"customEventName":"MyFirstApp"},"12":{"timestamp":1611247519953,"eventKind":"Flutter.ImageSizesForFrame","data":{"https://images-assets.nasa.gov/image/jsc2020e016257/jsc2020e016257~orig.jpg":{"source":"https://images-assets.nasa.gov/image/jsc2020e016257/jsc2020e016257~orig.jpg","displaySize":{"width":411.42857142857144,"height":500.0},"imageSize":{"width":3840.0,"height":2621.0},"displaySizeInBytes":1097142,"decodedSizeInBytes":53678080}},"customEventName":null}}},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247519892,"rss":375541760,"capacity":250640032,"used":48949120,"external":191452832,"gc":true,"adb_memoryInfo":{"Realtime":600018337,"Java Heap":7823360,"Native Heap":211734528,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":143507456,"System":5227520,"Total":387159040},"memory_eventInfo":{"timestamp":1611247519892,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":true,"allocationAccumulatorEvent":null,"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247520130,"rss":546459648,"capacity":194293816,"used":48574352,"external":137957432,"gc":false,"adb_memoryInfo":{"Realtime":600018337,"Java Heap":7823360,"Native Heap":211734528,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":143507456,"System":5227520,"Total":387159040},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247521081,"rss":546459648,"capacity":183060144,"used":46588312,"external":127530672,"gc":true,"adb_memoryInfo":{"Realtime":600018337,"Java Heap":7823360,"Native Heap":211734528,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":143507456,"System":5227520,"Total":387159040},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247521082,"rss":546459648,"capacity":275231520,"used":47197104,"external":217637664,"gc":true,"adb_memoryInfo":{"Realtime":600018337,"Java Heap":7823360,"Native Heap":211734528,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":143507456,"System":5227520,"Total":387159040},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247521082,"rss":546459648,"capacity":313835816,"used":48837664,"external":255717672,"gc":true,"adb_memoryInfo":{"Realtime":600018337,"Java Heap":7823360,"Native Heap":211734528,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":143507456,"System":5227520,"Total":387159040},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247521082,"rss":546459648,"capacity":314884432,"used":49459512,"external":255717712,"gc":true,"adb_memoryInfo":{"Realtime":600018337,"Java Heap":7823360,"Native Heap":211734528,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":143507456,"System":5227520,"Total":387159040},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247521082,"rss":546459648,"capacity":368852200,"used":52560152,"external":305437928,"gc":true,"adb_memoryInfo":{"Realtime":600018337,"Java Heap":7823360,"Native Heap":211734528,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":143507456,"System":5227520,"Total":387159040},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247521082,"rss":546459648,"capacity":368811712,"used":46982288,"external":305397440,"gc":true,"adb_memoryInfo":{"Realtime":600018337,"Java Heap":7823360,"Native Heap":211734528,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":143507456,"System":5227520,"Total":387159040},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247521112,"rss":546459648,"capacity":422794056,"used":51565800,"external":357446472,"gc":true,"adb_memoryInfo":{"Realtime":600018337,"Java Heap":7823360,"Native Heap":211734528,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":143507456,"System":5227520,"Total":387159040},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247522136,"rss":635043840,"capacity":422794096,"used":52467056,"external":357446512,"gc":true,"adb_memoryInfo":{"Realtime":600019820,"Java Heap":7794688,"Native Heap":448196608,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":151392256,"System":5227520,"Total":631477248},"memory_eventInfo":{"timestamp":1611247522136,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":true,"allocationAccumulatorEvent":null,"extensionEvents":{"0":{"timestamp":1611247522035,"eventKind":"Flutter.ImageSizesForFrame","data":{"https://images-assets.nasa.gov/image/as17-152-23392/as17-152-23392~orig.jpg":{"source":"https://images-assets.nasa.gov/image/as17-152-23392/as17-152-23392~orig.jpg","displaySize":{"width":411.42857142857144,"height":500.0},"imageSize":{"width":3000.0,"height":3006.0},"displaySizeInBytes":1097142,"decodedSizeInBytes":48096000}},"customEventName":null},"1":{"timestamp":1611247522088,"eventKind":"Flutter.ImageSizesForFrame","data":{"https://images-assets.nasa.gov/image/6900556/6900556~orig.jpg":{"source":"https://images-assets.nasa.gov/image/6900556/6900556~orig.jpg","displaySize":{"width":411.42857142857144,"height":500.0},"imageSize":{"width":3000.0,"height":2380.0},"displaySizeInBytes":1097142,"decodedSizeInBytes":38080000}},"customEventName":null}}},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247522190,"rss":635043840,"capacity":422794056,"used":51565864,"external":357446472,"gc":false,"adb_memoryInfo":{"Realtime":600019820,"Java Heap":7794688,"Native Heap":448196608,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":151392256,"System":5227520,"Total":631477248},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247522994,"rss":546189312,"capacity":211974384,"used":53001944,"external":146626800,"gc":false,"adb_memoryInfo":{"Realtime":600021383,"Java Heap":7864320,"Native Heap":371781632,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":151764992,"System":5227520,"Total":555504640},"memory_eventInfo":{"timestamp":1611247522994,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":null,"extensionEvents":{"0":{"timestamp":1611247522317,"eventKind":"Flutter.ImageSizesForFrame","data":{"https://images-assets.nasa.gov/image/0201587/0201587~orig.jpg":{"source":"https://images-assets.nasa.gov/image/0201587/0201587~orig.jpg","displaySize":{"width":411.42857142857144,"height":500.0},"imageSize":{"width":3000.0,"height":3000.0},"displaySizeInBytes":1097142,"decodedSizeInBytes":48000000}},"customEventName":null},"1":{"timestamp":1611247522947,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/sts119-s-005/sts119-s-005~orig.jpg"},"customEventName":"MyFirstApp"}}},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247523326,"rss":546189312,"capacity":172633448,"used":53242688,"external":106790248,"gc":true,"adb_memoryInfo":{"Realtime":600021383,"Java Heap":7864320,"Native Heap":371781632,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":151764992,"System":5227520,"Total":555504640},"memory_eventInfo":{"timestamp":1611247523326,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":null,"extensionEvents":{"0":{"timestamp":1611247523089,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/NM21-396-024/NM21-396-024~orig.jpg"},"customEventName":"MyFirstApp"},"1":{"timestamp":1611247523091,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/sts119-s-005/sts119-s-005~orig.jpg"},"customEventName":"MyFirstApp"},"2":{"timestamp":1611247523091,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/9258803/9258803~orig.jpg"},"customEventName":"MyFirstApp"},"3":{"timestamp":1611247523376,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/41G-121-099/41G-121-099~orig.jpg"},"customEventName":"MyFirstApp"}}},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247523686,"rss":546189312,"capacity":211294448,"used":57122936,"external":143714544,"gc":true,"adb_memoryInfo":{"Realtime":600021383,"Java Heap":7864320,"Native Heap":371781632,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":151764992,"System":5227520,"Total":555504640},"memory_eventInfo":{"timestamp":1611247523686,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":null,"extensionEvents":{"0":{"timestamp":1611247523601,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/sts066-63-006/sts066-63-006~orig.jpg"},"customEventName":"MyFirstApp"},"1":{"timestamp":1611247523602,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/PIA02708/PIA02708~orig.jpg"},"customEventName":"MyFirstApp"},"2":{"timestamp":1611247523603,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/9261132/9261132~orig.jpg"},"customEventName":"MyFirstApp"}}},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247523689,"rss":546189312,"capacity":211296408,"used":56841264,"external":143716504,"gc":true,"adb_memoryInfo":{"Realtime":600021383,"Java Heap":7864320,"Native Heap":371781632,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":151764992,"System":5227520,"Total":555504640},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247523725,"rss":546189312,"capacity":212016976,"used":57151432,"external":143912784,"gc":true,"adb_memoryInfo":{"Realtime":600021383,"Java Heap":7864320,"Native Heap":371781632,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":151764992,"System":5227520,"Total":555504640},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247523758,"rss":546189312,"capacity":197347472,"used":44312560,"external":142866576,"gc":true,"adb_memoryInfo":{"Realtime":600022311,"Java Heap":7831552,"Native Heap":415641600,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":156090368,"System":5227520,"Total":603657216},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247523762,"rss":546189312,"capacity":253570608,"used":44836848,"external":199089712,"gc":true,"adb_memoryInfo":{"Realtime":600022311,"Java Heap":7831552,"Native Heap":415641600,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":156090368,"System":5227520,"Total":603657216},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247523777,"rss":546189312,"capacity":257939680,"used":45373080,"external":202934496,"gc":true,"adb_memoryInfo":{"Realtime":600022311,"Java Heap":7831552,"Native Heap":415641600,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":156090368,"System":5227520,"Total":603657216},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247523778,"rss":546189312,"capacity":257939680,"used":45369032,"external":202934496,"gc":true,"adb_memoryInfo":{"Realtime":600022311,"Java Heap":7831552,"Native Heap":415641600,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":156090368,"System":5227520,"Total":603657216},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247523846,"rss":669450240,"capacity":211296408,"used":56841264,"external":143716504,"gc":false,"adb_memoryInfo":{"Realtime":600022311,"Java Heap":7831552,"Native Heap":415641600,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":156090368,"System":5227520,"Total":603657216},"memory_eventInfo":{"timestamp":1611247523846,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":null,"extensionEvents":{"0":{"timestamp":1611247523883,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/S65-34635/S65-34635~orig.jpg"},"customEventName":"MyFirstApp"},"1":{"timestamp":1611247523884,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/PIA09113/PIA09113~orig.jpg"},"customEventName":"MyFirstApp"},"2":{"timestamp":1611247523900,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/PIA09113/PIA09113~orig.jpg"},"customEventName":"MyFirstApp"},"3":{"timestamp":1611247523901,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/S65-34635/S65-34635~orig.jpg"},"customEventName":"MyFirstApp"},"4":{"timestamp":1611247523916,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/PIA09113/PIA09113~orig.jpg"},"customEventName":"MyFirstApp"},"5":{"timestamp":1611247523916,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/S65-34635/S65-34635~orig.jpg"},"customEventName":"MyFirstApp"}}},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247524180,"rss":669450240,"capacity":191897352,"used":47363880,"external":133713672,"gc":true,"adb_memoryInfo":{"Realtime":600022311,"Java Heap":7831552,"Native Heap":415641600,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":156090368,"System":5227520,"Total":603657216},"memory_eventInfo":{"timestamp":1611247524180,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":null,"extensionEvents":{"0":{"timestamp":1611247523949,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/S65-34635/S65-34635~orig.jpg"},"customEventName":"MyFirstApp"},"1":{"timestamp":1611247524016,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/S65-34635/S65-34635~orig.jpg"},"customEventName":"MyFirstApp"},"2":{"timestamp":1611247524017,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/PIA09113/PIA09113~orig.jpg"},"customEventName":"MyFirstApp"},"3":{"timestamp":1611247524050,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/PIA09113/PIA09113~orig.jpg"},"customEventName":"MyFirstApp"},"4":{"timestamp":1611247524050,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/S65-34635/S65-34635~orig.jpg"},"customEventName":"MyFirstApp"},"5":{"timestamp":1611247524092,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/S65-34635/S65-34635~orig.jpg"},"customEventName":"MyFirstApp"},"6":{"timestamp":1611247524123,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/S65-34635/S65-34635~orig.jpg"},"customEventName":"MyFirstApp"},"7":{"timestamp":1611247524125,"eventKind":"Flutter.ImageSizesForFrame","data":{"https://images-assets.nasa.gov/image/PIA09113/PIA09113~orig.jpg":{"source":"https://images-assets.nasa.gov/image/PIA09113/PIA09113~orig.jpg","displaySize":{"width":411.42857142857144,"height":500.0},"imageSize":{"width":1920.0,"height":1080.0},"displaySizeInBytes":1097142,"decodedSizeInBytes":11059200}},"customEventName":null},"8":{"timestamp":1611247524168,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/S65-63189/S65-63189~orig.jpg"},"customEventName":"MyFirstApp"},"9":{"timestamp":1611247524169,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://www.nasa.gov/sites/default/files/styles/full_width_feature/public/thumbnails/image/redspot.jpg"},"customEventName":"MyFirstApp"},"10":{"timestamp":1611247524219,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/S65-63189/S65-63189~orig.jpg"},"customEventName":"MyFirstApp"},"11":{"timestamp":1611247524221,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://www.nasa.gov/sites/default/files/styles/full_width_feature/public/thumbnails/image/redspot.jpg"},"customEventName":"MyFirstApp"},"12":{"timestamp":1611247524251,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/S65-63189/S65-63189~orig.jpg"},"customEventName":"MyFirstApp"},"13":{"timestamp":1611247524253,"eventKind":"Flutter.ImageSizesForFrame","data":{"https://www.nasa.gov/sites/default/files/styles/full_width_feature/public/thumbnails/image/redspot.jpg":{"source":"https://www.nasa.gov/sites/default/files/styles/full_width_feature/public/thumbnails/image/redspot.jpg","displaySize":{"width":411.42857142857144,"height":500.0},"imageSize":{"width":1041.0,"height":882.0},"displaySizeInBytes":1097142,"decodedSizeInBytes":4896864}},"customEventName":null}}},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247524208,"rss":669450240,"capacity":239668848,"used":48421072,"external":181485168,"gc":true,"adb_memoryInfo":{"Realtime":600022311,"Java Heap":7831552,"Native Heap":415641600,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":156090368,"System":5227520,"Total":603657216},"memory_eventInfo":{"timestamp":1611247524208,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":null,"extensionEvents":{"0":{"timestamp":1611247524288,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/S65-63189/S65-63189~orig.jpg"},"customEventName":"MyFirstApp"}}},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247524208,"rss":669450240,"capacity":239672264,"used":48475744,"external":181488584,"gc":true,"adb_memoryInfo":{"Realtime":600022311,"Java Heap":7831552,"Native Heap":415641600,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":156090368,"System":5227520,"Total":603657216},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247524604,"rss":669450240,"capacity":212310288,"used":52575080,"external":152148240,"gc":true,"adb_memoryInfo":{"Realtime":600023048,"Java Heap":7839744,"Native Heap":391090176,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145809408,"System":5227520,"Total":568833024},"memory_eventInfo":{"timestamp":1611247524604,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":null,"extensionEvents":{"0":{"timestamp":1611247524296,"eventKind":"Flutter.ImageSizesForFrame","data":{"https://images-assets.nasa.gov/image/S65-34635/S65-34635~orig.jpg":{"source":"https://images-assets.nasa.gov/image/S65-34635/S65-34635~orig.jpg","displaySize":{"width":411.42857142857144,"height":500.0},"imageSize":{"width":2984.0,"height":3000.0},"displaySizeInBytes":1097142,"decodedSizeInBytes":47744000}},"customEventName":null},"1":{"timestamp":1611247524379,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/S65-63189/S65-63189~orig.jpg"},"customEventName":"MyFirstApp"},"2":{"timestamp":1611247524422,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/S65-63189/S65-63189~orig.jpg"},"customEventName":"MyFirstApp"},"3":{"timestamp":1611247524509,"eventKind":"DevTools.Event","data":{"method":"recordLoadedImage","param":"https://images-assets.nasa.gov/image/S65-63189/S65-63189~orig.jpg"},"customEventName":"MyFirstApp"}}},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247524605,"rss":669450240,"capacity":204511872,"used":49869808,"external":147409536,"gc":true,"adb_memoryInfo":{"Realtime":600023048,"Java Heap":7839744,"Native Heap":391090176,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145809408,"System":5227520,"Total":568833024},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247524674,"rss":635228160,"capacity":254385032,"used":48490016,"external":195185544,"gc":true,"adb_memoryInfo":{"Realtime":600023048,"Java Heap":7839744,"Native Heap":391090176,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145809408,"System":5227520,"Total":568833024},"memory_eventInfo":{"timestamp":1611247524674,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":null,"extensionEvents":{"0":{"timestamp":1611247524726,"eventKind":"Flutter.ImageSizesForFrame","data":{"https://images-assets.nasa.gov/image/S65-63189/S65-63189~orig.jpg":{"source":"https://images-assets.nasa.gov/image/S65-63189/S65-63189~orig.jpg","displaySize":{"width":411.42857142857144,"height":500.0},"imageSize":{"width":3000.0,"height":2986.0},"displaySizeInBytes":1097142,"decodedSizeInBytes":47776000}},"customEventName":null}}},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247524678,"rss":635228160,"capacity":211947904,"used":51598152,"external":153276800,"gc":false,"adb_memoryInfo":{"Realtime":600023048,"Java Heap":7839744,"Native Heap":391090176,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145809408,"System":5227520,"Total":568833024},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247524689,"rss":635228160,"capacity":254385032,"used":47361432,"external":195185544,"gc":true,"adb_memoryInfo":{"Realtime":600023048,"Java Heap":7839744,"Native Heap":391090176,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145809408,"System":5227520,"Total":568833024},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247524689,"rss":635228160,"capacity":293320336,"used":48410736,"external":233596560,"gc":true,"adb_memoryInfo":{"Realtime":600023048,"Java Heap":7839744,"Native Heap":391090176,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145809408,"System":5227520,"Total":568833024},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247524691,"rss":635228160,"capacity":293323640,"used":48462408,"external":233599864,"gc":true,"adb_memoryInfo":{"Realtime":600023048,"Java Heap":7839744,"Native Heap":391090176,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145809408,"System":5227520,"Total":568833024},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247524747,"rss":635228160,"capacity":228900528,"used":49219640,"external":168431280,"gc":true,"adb_memoryInfo":{"Realtime":600023048,"Java Heap":7839744,"Native Heap":391090176,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145809408,"System":5227520,"Total":568833024},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247524751,"rss":635228160,"capacity":224300880,"used":48198408,"external":166674256,"gc":true,"adb_memoryInfo":{"Realtime":600023048,"Java Heap":7839744,"Native Heap":391090176,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145809408,"System":5227520,"Total":568833024},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247524813,"rss":635228160,"capacity":237329096,"used":50678272,"external":177257160,"gc":true,"adb_memoryInfo":{"Realtime":600023048,"Java Heap":7839744,"Native Heap":391090176,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145809408,"System":5227520,"Total":568833024},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247524820,"rss":635228160,"capacity":237325608,"used":46625416,"external":177253672,"gc":true,"adb_memoryInfo":{"Realtime":600023048,"Java Heap":7839744,"Native Heap":391090176,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145809408,"System":5227520,"Total":568833024},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247525100,"rss":635228160,"capacity":306125456,"used":49415920,"external":244943504,"gc":true,"adb_memoryInfo":{"Realtime":600023048,"Java Heap":7839744,"Native Heap":391090176,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145809408,"System":5227520,"Total":568833024},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247525139,"rss":635228160,"capacity":377057264,"used":48369144,"external":315875312,"gc":true,"adb_memoryInfo":{"Realtime":600023048,"Java Heap":7839744,"Native Heap":391090176,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145809408,"System":5227520,"Total":568833024},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247525142,"rss":635228160,"capacity":377057264,"used":43325088,"external":315875312,"gc":true,"adb_memoryInfo":{"Realtime":600023048,"Java Heap":7839744,"Native Heap":391090176,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145809408,"System":5227520,"Total":568833024},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247525294,"rss":717799424,"capacity":374550512,"used":43849440,"external":315875312,"gc":false,"adb_memoryInfo":{"Realtime":600023846,"Java Heap":7794688,"Native Heap":478261248,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145342464,"System":5227520,"Total":655492096},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247525947,"rss":622518272,"capacity":374550512,"used":43849440,"external":315875312,"gc":false,"adb_memoryInfo":{"Realtime":600024485,"Java Heap":7786496,"Native Heap":460255232,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145338368,"System":5227520,"Total":637473792},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247526589,"rss":622219264,"capacity":374550512,"used":43849440,"external":315875312,"gc":false,"adb_memoryInfo":{"Realtime":600025138,"Java Heap":7786496,"Native Heap":364982272,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145338368,"System":5227520,"Total":542200832},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247527235,"rss":622215168,"capacity":374550512,"used":43849440,"external":315875312,"gc":false,"adb_memoryInfo":{"Realtime":600025783,"Java Heap":7786496,"Native Heap":364691456,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145342464,"System":5227520,"Total":541914112},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247528373,"rss":616337408,"capacity":374550512,"used":43849440,"external":315875312,"gc":false,"adb_memoryInfo":{"Realtime":600026915,"Java Heap":7786496,"Native Heap":363626496,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145375232,"System":5227520,"Total":540881920},"memory_eventInfo":{"timestamp":1611247528373,"gcEvent":false,"snapshotEvent":true,"snapshotAutoEvent":false,"allocationAccumulatorEvent":null,"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247529014,"rss":595578880,"capacity":374550512,"used":43849440,"external":315875312,"gc":false,"adb_memoryInfo":{"Realtime":600027553,"Java Heap":7786496,"Native Heap":358617088,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145375232,"System":5227520,"Total":535872512},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247529640,"rss":595619840,"capacity":374550512,"used":43849440,"external":315875312,"gc":false,"adb_memoryInfo":{"Realtime":600028193,"Java Heap":7786496,"Native Heap":338022400,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145375232,"System":5227520,"Total":515277824},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247530281,"rss":595615744,"capacity":374550512,"used":43849440,"external":315875312,"gc":false,"adb_memoryInfo":{"Realtime":600028830,"Java Heap":7786496,"Native Heap":338071552,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145375232,"System":5227520,"Total":515326976},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247531123,"rss":598179840,"capacity":374550512,"used":43849440,"external":315875312,"gc":false,"adb_memoryInfo":{"Realtime":600029481,"Java Heap":7786496,"Native Heap":339210240,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145375232,"System":5227520,"Total":516465664},"memory_eventInfo":{"timestamp":1611247531123,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":true,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247531759,"rss":597340160,"capacity":374550512,"used":43849440,"external":315875312,"gc":false,"adb_memoryInfo":{"Realtime":600030306,"Java Heap":7786496,"Native Heap":340434944,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145457152,"System":5227520,"Total":517772288},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247532078,"rss":597340160,"capacity":374550512,"used":43849440,"external":315875312,"gc":false,"adb_memoryInfo":{"Realtime":600030306,"Java Heap":7786496,"Native Heap":340434944,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145457152,"System":5227520,"Total":517772288},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247532372,"rss":597573632,"capacity":374550512,"used":43849440,"external":315875312,"gc":false,"adb_memoryInfo":{"Realtime":600030934,"Java Heap":7786496,"Native Heap":339750912,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145461248,"System":5227520,"Total":517092352},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247532693,"rss":597573632,"capacity":374550512,"used":43849440,"external":315875312,"gc":false,"adb_memoryInfo":{"Realtime":600030934,"Java Heap":7786496,"Native Heap":339750912,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145461248,"System":5227520,"Total":517092352},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247533014,"rss":597569536,"capacity":374550512,"used":43849440,"external":315875312,"gc":false,"adb_memoryInfo":{"Realtime":600031565,"Java Heap":7786496,"Native Heap":339988480,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145461248,"System":5227520,"Total":517329920},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247533017,"rss":597569536,"capacity":374550512,"used":43849440,"external":315875312,"gc":false,"adb_memoryInfo":{"Realtime":600031565,"Java Heap":7786496,"Native Heap":339988480,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145461248,"System":5227520,"Total":517329920},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247533404,"rss":597569536,"capacity":374550512,"used":43849440,"external":315875312,"gc":false,"adb_memoryInfo":{"Realtime":600031565,"Java Heap":7786496,"Native Heap":339988480,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145461248,"System":5227520,"Total":517329920},"memory_eventInfo":{"timestamp":1611247533404,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":true,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247533732,"rss":599937024,"capacity":374550512,"used":43850504,"external":315875312,"gc":false,"adb_memoryInfo":{"Realtime":600032254,"Java Heap":7786496,"Native Heap":342122496,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145461248,"System":5227520,"Total":519463936},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247534053,"rss":599937024,"capacity":374550512,"used":43850504,"external":315875312,"gc":false,"adb_memoryInfo":{"Realtime":600032254,"Java Heap":7786496,"Native Heap":342122496,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145461248,"System":5227520,"Total":519463936},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247534370,"rss":599388160,"capacity":374550512,"used":43850504,"external":315875312,"gc":false,"adb_memoryInfo":{"Realtime":600032925,"Java Heap":7786496,"Native Heap":342364160,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145461248,"System":5227520,"Total":519705600},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247534375,"rss":599388160,"capacity":374550512,"used":43850504,"external":315875312,"gc":false,"adb_memoryInfo":{"Realtime":600032925,"Java Heap":7786496,"Native Heap":342364160,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145461248,"System":5227520,"Total":519705600},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247534697,"rss":599388160,"capacity":374550512,"used":43850504,"external":315875312,"gc":false,"adb_memoryInfo":{"Realtime":600032925,"Java Heap":7786496,"Native Heap":342364160,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145461248,"System":5227520,"Total":519705600},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247535007,"rss":599650304,"capacity":374550512,"used":43850504,"external":315875312,"gc":false,"adb_memoryInfo":{"Realtime":600033561,"Java Heap":7786496,"Native Heap":341901312,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145461248,"System":5227520,"Total":519242752},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247535030,"rss":599650304,"capacity":374550512,"used":43850504,"external":315875312,"gc":false,"adb_memoryInfo":{"Realtime":600033561,"Java Heap":7786496,"Native Heap":341901312,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145461248,"System":5227520,"Total":519242752},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247535352,"rss":599650304,"capacity":374550512,"used":43850504,"external":315875312,"gc":false,"adb_memoryInfo":{"Realtime":600033561,"Java Heap":7786496,"Native Heap":341901312,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145461248,"System":5227520,"Total":519242752},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247535648,"rss":599990272,"capacity":374550512,"used":43850504,"external":315875312,"gc":false,"adb_memoryInfo":{"Realtime":600034196,"Java Heap":7786496,"Native Heap":342228992,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145461248,"System":5227520,"Total":519570432},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247535970,"rss":599990272,"capacity":374550512,"used":43850504,"external":315875312,"gc":false,"adb_memoryInfo":{"Realtime":600034196,"Java Heap":7786496,"Native Heap":342228992,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145461248,"System":5227520,"Total":519570432},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247536308,"rss":599990272,"capacity":374550512,"used":43850504,"external":315875312,"gc":false,"adb_memoryInfo":{"Realtime":600034196,"Java Heap":7786496,"Native Heap":342228992,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145461248,"System":5227520,"Total":519570432},"memory_eventInfo":{"timestamp":1611247536308,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":true},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247536408,"rss":601706496,"capacity":374550512,"used":43850504,"external":315875312,"gc":false,"adb_memoryInfo":{"Realtime":600034968,"Java Heap":7786496,"Native Heap":343953408,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145461248,"System":5227520,"Total":521294848},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247536728,"rss":601706496,"capacity":374550512,"used":43850504,"external":315875312,"gc":false,"adb_memoryInfo":{"Realtime":600034968,"Java Heap":7786496,"Native Heap":343953408,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145461248,"System":5227520,"Total":521294848},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247537038,"rss":601657344,"capacity":374550512,"used":43850504,"external":315875312,"gc":false,"adb_memoryInfo":{"Realtime":600035598,"Java Heap":7786496,"Native Heap":344117248,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145457152,"System":5227520,"Total":521454592},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247537042,"rss":601657344,"capacity":374550512,"used":43850504,"external":315875312,"gc":false,"adb_memoryInfo":{"Realtime":600035598,"Java Heap":7786496,"Native Heap":344117248,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145457152,"System":5227520,"Total":521454592},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247537362,"rss":601657344,"capacity":374550512,"used":43850504,"external":315875312,"gc":false,"adb_memoryInfo":{"Realtime":600035598,"Java Heap":7786496,"Native Heap":344117248,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145457152,"System":5227520,"Total":521454592},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247537665,"rss":601972736,"capacity":374550512,"used":43850504,"external":315875312,"gc":false,"adb_memoryInfo":{"Realtime":600036221,"Java Heap":7786496,"Native Heap":344203264,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145461248,"System":5227520,"Total":521544704},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247537674,"rss":601972736,"capacity":374550512,"used":43850504,"external":315875312,"gc":false,"adb_memoryInfo":{"Realtime":600036221,"Java Heap":7786496,"Native Heap":344203264,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145461248,"System":5227520,"Total":521544704},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247537995,"rss":601972736,"capacity":374550512,"used":43850504,"external":315875312,"gc":false,"adb_memoryInfo":{"Realtime":600036221,"Java Heap":7786496,"Native Heap":344203264,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145461248,"System":5227520,"Total":521544704},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247538298,"rss":602284032,"capacity":374550512,"used":43850568,"external":315875312,"gc":false,"adb_memoryInfo":{"Realtime":600036854,"Java Heap":7786496,"Native Heap":344526848,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145461248,"System":5227520,"Total":521868288},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247538619,"rss":602284032,"capacity":374550512,"used":43850568,"external":315875312,"gc":false,"adb_memoryInfo":{"Realtime":600036854,"Java Heap":7786496,"Native Heap":344526848,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145461248,"System":5227520,"Total":521868288},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247538986,"rss":602284032,"capacity":374550512,"used":43850568,"external":315875312,"gc":false,"adb_memoryInfo":{"Realtime":600036854,"Java Heap":7786496,"Native Heap":344526848,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145461248,"System":5227520,"Total":521868288},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}},
{"timestamp":1611247539162,"rss":602599424,"capacity":374550512,"used":43850632,"external":315875312,"gc":false,"adb_memoryInfo":{"Realtime":600037662,"Java Heap":7786496,"Native Heap":344834048,"Code":18812928,"Stack":53248,"Graphics":0,"Private Other":145461248,"System":5227520,"Total":522175488},"memory_eventInfo":{"timestamp":-1,"gcEvent":false,"snapshotEvent":false,"snapshotAutoEvent":false,"allocationAccumulatorEvent":{"start":false,"continues":false,"reset":false},"extensionEvents":null},"raster_cache":{"layerBytes":0,"pictureBytes":2513592}}
]
}}
''';
