<!--
Copyright 2025 The Flutter Authors
Use of this source code is governed by a BSD-style license that can be
found in the LICENSE file or at https://developers.google.com/open-source/licenses/bsd.
-->
## DevTools Documentation - How To Guide

The documentation for Dart & Flutter DevTools lives on [flutter.dev](https://docs.flutter.dev/tools/devtools).

Our docs are written and pushed up to the [flutter/website](https://docs.flutter.dev/tools/devtools)
repo by the Flutter DevRel team. Developers working on DevTools should collaborate with Flutter tech writers by following
the below workflow.

## How to request documentation updates

### For simple updates:
Some examples of "simple" updates include updating screenshots, glossary terms, coding recipes, etc. For this type of documentation request, you can include all the relevant information in a GitHub issue. Please follow
the [guidance below](#file-an-issue-on-the-flutterwebsite-repo) to create this issue.

### For feature updates that can be shown in a demo video:

1. Create a [Screencast](chrome://extensions/?id=ccbdlfckiiklnpopmgihhnegpbcgceja) (preferred) or a Google Drive video
explaining the new feature or functionality changes that require docs updates. If the feature is quick to document, you
can include a rough draft of the documentation you think should be written, but where possible, we should leave the
writing to our talented tech writers.
2. Create a Go Link pointed at your demo video.
3. Follow
the [guidance below](#file-an-issue-on-the-flutterwebsite-repo) to create a GitHub issue.

### File an issue on the flutter/website repo:

Create an [new issue](https://github.com/flutter/website/issues/new) on the flutter/website repository.
- Add a descriptive title for your request.
- Add the `devtools-request` label.
- Add relevant information to the issue description. This may include
a Go Link to your demo video or doc, a screenshot, a short description,
or any other relevant context that our tech writers may need to fulfill
your request.
