% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/generateROCRCurves.R
\name{generateROCRCurvesData}
\alias{generateROCRCurvesData}
\title{Generate binary classification predictions via ROCR ROC curves.}
\usage{
generateROCRCurvesData(obj, meas1 = "tpr", meas2 = "fpr",
  avg = "threshold", perf.args = list(), task.id = NULL)
}
\arguments{
\item{obj}{[(list of) \code{\link{Prediction}} | (list of) \code{\link{ResampleResult}} | \code{\link{BenchmarkResult}}]\cr
Single prediction object, list of them, single resample result, list of them, or a benchmark result.
In case of a list probably produced by different learners you want to compare, then
name the list with the names you want to see in the plots, probably
learner shortnames or ids.}

\item{meas1}{[\code{character(1)}]\cr
Measure on x-axis. Note that this is a measure name from *ROCR* and not from mlr!
Default is \dQuote{tpr}.}

\item{meas2}{[\code{character(1)}]\cr
Measure on y-axis. Note that this is a measure name from *ROCR* and not from mlr!
Default is \dQuote{fpr}.}

\item{avg}{[\code{chracter(1)}]\cr
If \code{obj} is of class \code{ResampleResult} or \code{BenchmarkResult}, how are
the predictions to be combined (by learner)?
If \code{obj} is not one of these classes, this argument is ignored.
Possibilities are \dQuote{threshold}, \dQuote{horizontal}, \dQuote{vertical}, and \dQuote{none}.
Default is \dQuote{threshold}.}

\item{perf.args}{[named \code{list}]\cr
Further arguments passed to ROCR's \code{\link[ROCR]{performance}}.
Usually not needed and \code{meas1} and \code{meas2} are set internally.
Default is an empty list.}

\item{task.id}{[\code{character(1)}]\cr
  Selected task in \code{\link{BenchmarkResult}} to do plots for, ignored otherwise.
  Default is first task.}
}
\value{
A \code{ROCRCurvesData} object, a \code{list} with elements giving the data output from
  \code{\link[ROCR]{performance}} and the input arguments.
}
\description{
Data is generated by calling \code{\link{asROCRPrediction}},
and then ROCR's \code{\link[ROCR]{performance}}.

See these methods in ROCR for further info.
}
\seealso{
Other generate_plot_data: \code{\link{generateFilterValuesData}};
  \code{\link{generateLearningCurveData}};
  \code{\link{generateThreshVsPerfData}};
  \code{\link{getFilterValues}}

Other predict: \code{\link{asROCRPrediction}};
  \code{\link{getProbabilities}};
  \code{\link{plotROCRCurvesGGVIS}};
  \code{\link{plotROCRCurves}};
  \code{\link{plotViperCharts}};
  \code{\link{predict.WrappedModel}};
  \code{\link{setPredictThreshold}};
  \code{\link{setPredictType}}

Other roc: \code{\link{asROCRPrediction}};
  \code{\link{plotROCRCurvesGGVIS}};
  \code{\link{plotROCRCurves}};
  \code{\link{plotViperCharts}}
}

