/*
 * Copyright 2024 EPAM Systems, Inc
 *
 * See the NOTICE file distributed with this work for additional information
 * regarding copyright ownership. Licensed under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.epam.deltix.qsrv.hf.tickdb.impl.topic.topicregistry;

import com.epam.deltix.qsrv.hf.pub.md.RecordClassDescriptor;
import com.epam.deltix.qsrv.hf.tickdb.impl.topic.CommunicationPipe;
import com.epam.deltix.qsrv.hf.tickdb.pub.Messages;
import com.epam.deltix.qsrv.hf.tickdb.pub.topic.MessageProcessor;
import com.epam.deltix.qsrv.hf.tickdb.pub.topic.settings.TopicType;
import com.epam.deltix.qsrv.hf.topic.consumer.DirectReaderFactory;
import com.epam.deltix.qsrv.hf.topic.consumer.SubscriptionWorker;
import com.epam.deltix.qsrv.hf.topic.loader.DirectLoaderFactory;
import com.epam.deltix.streaming.MessageChannel;
import com.epam.deltix.timebase.messages.ConstantIdentityKey;
import com.epam.deltix.timebase.messages.InstrumentMessage;
import com.epam.deltix.timebase.messages.service.ErrorMessage;
import com.epam.deltix.timebase.messages.service.EventMessage;
import com.epam.deltix.util.concurrent.QuickExecutor;
import com.epam.deltix.util.time.TimeKeeper;
import io.aeron.Aeron;
import org.junit.Test;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * Note: this test requires running Aeron driver (see deltix.util.io.aeron.AeronDriver).
 * TODO: Make this test independent of external driver.
 *
 * Stress test. Does not stops itself.
 *
 * @author Alexei Osipov
 */
public class DirectChannelWithServerTest {
    static {
        System.setProperty("deltix.qsrv.hf.RatePrinter.enabled", "true");
    }

    @Test
    public void run() throws Exception {
        TopicTestUtils.initTempQSHome();

        Aeron aeron = TopicTestUtils.createAeron();

        DirectTopicRegistry directTopicRegistry = new DirectTopicRegistry();
        List<RecordClassDescriptor> types = Collections.singletonList(StubData.makeErrorMessageDescriptor());

        String topicName = "testTopic";
        AtomicInteger streamIdGenerator = new AtomicInteger(new Random().nextInt());

        directTopicRegistry.createDirectTopic(topicName, types, null, streamIdGenerator::incrementAndGet, TopicType.IPC, null, null, null);

        LoaderSubscriptionResult loaderSubscriptionResult = directTopicRegistry.addLoader(topicName, true, null);


        Thread loaderThread = new Thread(() -> {
            MessageChannel<InstrumentMessage> channel = new DirectLoaderFactory().create(aeron, false, loaderSubscriptionResult.getPublisherChannel(), loaderSubscriptionResult.getDataStreamId(), loaderSubscriptionResult.getTypes(), null, null, null, false);

            ErrorMessage msg = new ErrorMessage();
            msg.setSymbol("ABC");
            msg.setSeqNum(234567890);

            while (true) {
                msg.setTimeStampMs(TimeKeeper.currentTime);
                channel.send(msg);
            }
        });
        loaderThread.setName("SENDER");
        loaderThread.start();

        ReaderSubscriptionResult readerSubscriptionResult = directTopicRegistry.addReader(topicName, true, null, null);

        RatePrinter ratePrinter = new RatePrinter("Listener");
        SubscriptionWorker directMessageListener = new DirectReaderFactory().createListener(aeron, false, readerSubscriptionResult.getSubscriberChannel(), readerSubscriptionResult.getDataStreamId(), readerSubscriptionResult.getTypes(),
                message -> {
                    ratePrinter.inc();
                }, null, null);
        ratePrinter.start();
        directMessageListener.processMessagesUntilStopped();
    }
}
