/*
 * Copyright 2024 EPAM Systems, Inc
 *
 * See the NOTICE file distributed with this work for additional information
 * regarding copyright ownership. Licensed under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.epam.deltix.qsrv.hf.tickdb.http.stream;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name = "lockStream")
public class LockStreamRequest extends StreamRequest {
    /*
        Lock type. If true - request for "WRITE" lock, otherwise "READ".
     */
    @XmlElement(name = "write")
    public boolean      write;

    @XmlElement(name = "startTime")
    public long         startTime = Long.MIN_VALUE;

    @XmlElement(name = "endTime")
    public long         endTime = Long.MAX_VALUE;

    /*
        if timeout > 0, the server "tryLock" operation will be used.
     */
    @XmlElement(name = "timeout")
    public long         timeout;

    /*
     *  Session identifier
     */
    @XmlElement(name = "sid")
    public String        sid;
}