/*
 * Copyright 2024 EPAM Systems, Inc
 *
 * See the NOTICE file distributed with this work for additional information
 * regarding copyright ownership. Licensed under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.epam.deltix.qsrv.hf.tickdb.http.stream;


import com.epam.deltix.qsrv.hf.tickdb.pub.BackgroundProcessInfo;
import com.epam.deltix.util.progress.ExecutionStatus;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name = "BgProcess")
public class GetBGProcessResponse {

    @XmlElement()
    public String name;

    @XmlElement()
    public ExecutionStatus status = ExecutionStatus.None;

    @XmlElement()
    public double progress = 0;

    @XmlElement()
    public long startTime;

    @XmlElement()
    public long endTime;

    public GetBGProcessResponse() {
    }

    public GetBGProcessResponse(BackgroundProcessInfo info) {
        if (info != null) {
            this.name = info.getName();
            this.status = info.status;
            this.progress = info.progress;
            this.startTime = info.startTime;
            this.endTime = info.endTime;
        }
    }

}