/*
 * Copyright 2024 EPAM Systems, Inc
 *
 * See the NOTICE file distributed with this work for additional information
 * regarding copyright ownership. Licensed under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.epam.deltix.computations.functions;

import com.epam.deltix.computations.api.annotations.Compute;
import com.epam.deltix.computations.api.annotations.Function;
import com.epam.deltix.computations.api.annotations.GenericParameter;
import com.epam.deltix.computations.api.annotations.Reset;
import com.epam.deltix.computations.api.annotations.Result;
import com.epam.deltix.computations.api.annotations.Type;
import com.epam.deltix.qsrv.hf.pub.md.TimebaseTypes;
import com.epam.deltix.qsrv.hf.tickdb.lang.runtime.selectors.Instance;
import com.epam.deltix.qsrv.hf.tickdb.lang.runtime.selectors.InstancePool;
import com.epam.deltix.util.collections.generated.ObjectArrayList;

@Function("COLLECT")
@GenericParameter(name = "T")
public class CollectObjects implements ObjectArrayStatefulFunction {

    protected ObjectArrayList<Instance> value = null;
    protected final ObjectArrayList<Instance> buffer = new ObjectArrayList<>();

    private final InstancePool instancePool = new InstancePool();

    @Compute
    public void compute(@Type("T?") Instance v) {
        if (TimebaseTypes.isNull(v) || v.isNull())
            return;
        if (value == null) {
            value = buffer;
        }
        Instance instance = instancePool.borrow();
        instance.copyFrom(v);
        buffer.add(instance);
    }

    @Reset
    @Override
    public void reset() {
        value = null;
        buffer.clear();
        instancePool.reset();
    }

    @Result
    @Type("ARRAY(T?)?")
    @Override
    public ObjectArrayList<Instance> get() {
        return value;
    }
}
