/*
 * Copyright 2024 EPAM Systems, Inc
 *
 * See the NOTICE file distributed with this work for additional information
 * regarding copyright ownership. Licensed under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.epam.deltix.qsrv.hf.pub.codec.validerrors;

import com.epam.deltix.qsrv.hf.pub.codec.NonStaticFieldInfo;

/**
 *
 */
public final class FloatFieldOutOfRange extends ValidationError {
    public final double               value;
    public final double               min;
    public final double               max;
    
    public FloatFieldOutOfRange (
        int                         atOffset,        
        NonStaticFieldInfo          fieldInfo,
        double                      value,
        double                      min,
        double                      max
    )
    {
        super (atOffset, fieldInfo);
        
        this.value = value;
        this.min = min;
        this.max = max;
    }        
}