/*
 * Copyright 2023 EPAM Systems, Inc
 *
 * See the NOTICE file distributed with this work for additional information
 * regarding copyright ownership. Licensed under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.epam.deltix.snmp.parser;

import java.util.*;
import java_cup.runtime.*;
import com.epam.deltix.util.parsers.*;
import com.epam.deltix.util.lang.*;

/** CUP v0.10k generated parser.
  * @version Fri Jul 20 15:04:57 EDT 2012
  */
public class Parser extends java_cup.runtime.lr_parser {

  /** Default constructor. */
  public Parser() {super();}

  /** Constructor which sets the default scanner. */
  public Parser(java_cup.runtime.Scanner s) {super(s);}

  /** Production table. */
  protected static final short _production_table[][] = 
    unpackFromStrings(new String[] {
    "\000\263\000\002\061\003\000\002\061\002\000\002\063" +
    "\002\000\002\062\005\000\002\062\002\000\002\004\011" +
    "\000\002\002\004\000\002\065\002\000\002\064\005\000" +
    "\002\064\002\000\002\005\005\000\002\006\005\000\002" +
    "\007\003\000\002\007\005\000\002\010\003\000\002\010" +
    "\003\000\002\010\003\000\002\003\003\000\002\003\003" +
    "\000\002\003\003\000\002\003\003\000\002\003\003\000" +
    "\002\003\003\000\002\003\003\000\002\003\003\000\002" +
    "\003\003\000\002\013\003\000\002\013\003\000\002\013" +
    "\003\000\002\013\003\000\002\013\003\000\002\013\003" +
    "\000\002\013\003\000\002\013\003\000\002\013\003\000" +
    "\002\013\003\000\002\067\002\000\002\066\005\000\002" +
    "\066\002\000\002\011\017\000\002\012\006\000\002\014" +
    "\007\000\002\070\004\000\002\070\002\000\002\014\013" +
    "\000\002\072\002\000\002\071\005\000\002\071\002\000" +
    "\002\036\005\000\002\035\003\000\002\035\003\000\002" +
    "\035\006\000\002\073\004\000\002\073\002\000\002\074" +
    "\004\000\002\074\002\000\002\075\003\000\002\075\002" +
    "\000\002\015\021\000\002\016\006\000\002\016\006\000" +
    "\002\017\003\000\002\017\004\000\002\017\005\000\002" +
    "\020\003\000\002\020\005\000\002\020\006\000\002\021" +
    "\003\000\002\021\005\000\002\022\006\000\002\023\005" +
    "\000\002\024\003\000\002\024\006\000\002\024\003\000" +
    "\002\024\004\000\002\024\004\000\002\024\003\000\002" +
    "\024\006\000\002\024\003\000\002\024\006\000\002\024" +
    "\006\000\002\076\004\000\002\076\002\000\002\077\004" +
    "\000\002\077\002\000\002\037\013\000\002\042\004\000" +
    "\002\042\005\000\002\042\005\000\002\043\006\000\002" +
    "\044\003\000\002\044\003\000\002\044\003\000\002\044" +
    "\002\000\002\025\006\000\002\025\003\000\002\101\002" +
    "\000\002\100\006\000\002\100\002\000\002\026\004\000" +
    "\002\026\005\000\002\027\003\000\002\027\003\000\002" +
    "\030\003\000\002\030\003\000\002\031\003\000\002\031" +
    "\005\000\002\032\006\000\002\033\003\000\002\033\004" +
    "\000\002\034\006\000\002\034\004\000\002\102\004\000" +
    "\002\102\002\000\002\045\017\000\002\054\003\000\002" +
    "\054\005\000\002\103\006\000\002\103\002\000\002\104" +
    "\004\000\002\104\002\000\002\046\014\000\002\105\004" +
    "\000\002\105\002\000\002\047\017\000\002\106\004\000" +
    "\002\106\002\000\002\110\002\000\002\107\005\000\002" +
    "\107\002\000\002\050\014\000\002\111\006\000\002\111" +
    "\002\000\002\113\002\000\002\112\005\000\002\112\002" +
    "\000\002\055\005\000\002\056\003\000\002\056\003\000" +
    "\002\052\006\000\002\114\004\000\002\114\002\000\002" +
    "\115\004\000\002\115\002\000\002\116\004\000\002\116" +
    "\002\000\002\053\011\000\002\117\004\000\002\117\002" +
    "\000\002\121\002\000\002\120\005\000\002\120\002\000" +
    "\002\051\016\000\002\123\002\000\002\122\005\000\002" +
    "\122\002\000\002\057\011\000\002\124\004\000\002\124" +
    "\002\000\002\125\004\000\002\125\002\000\002\126\004" +
    "\000\002\126\002\000\002\127\006\000\002\127\002\000" +
    "\002\060\012\000\002\131\002\000\002\130\005\000\002" +
    "\130\002\000\002\040\010\000\002\041\003\000\002\041" +
    "\003\000\002\041\003\000\002\041\003\000\002\041\003" +
    "\000\002\041\003\000\002\041\003\000\002\041\003\000" +
    "\002\041\003" });

  /** Access to production table. */
  public short[][] production_table() {return _production_table;}

  /** Parse-action table. */
  protected static final short[][] _action_table = 
    unpackFromStrings(new String[] {
    "\000\u016d\000\004\004\005\001\002\000\004\002\u016f\001" +
    "\002\000\004\063\006\001\002\000\004\010\007\001\002" +
    "\000\004\047\010\001\002\000\034\004\000\005\000\043" +
    "\000\067\000\103\012\120\000\121\000\122\000\123\000" +
    "\127\000\130\000\131\000\156\000\001\002\000\032\004" +
    "\ufffd\005\ufffd\043\ufffd\067\ufffd\120\ufffd\121\ufffd\122\ufffd" +
    "\123\ufffd\127\ufffd\130\ufffd\131\ufffd\156\ufffd\001\002\000" +
    "\032\004\ufff8\005\ufff8\034\ufff8\043\ufff8\120\ufff8\121\ufff8" +
    "\122\ufff8\123\ufff8\127\ufff8\130\ufff8\131\ufff8\156\ufff8\001" +
    "\002\000\032\004\001\005\001\043\001\067\001\120\001" +
    "\121\001\122\001\123\001\127\001\130\001\131\001\156" +
    "\001\001\002\000\032\004\ufffa\005\ufffa\034\016\043\ufffa" +
    "\120\ufffa\121\ufffa\122\ufffa\123\ufffa\127\ufffa\130\ufffa\131" +
    "\ufffa\156\ufffa\001\002\000\030\004\021\005\027\043\032" +
    "\120\035\121\022\122\033\123\030\127\020\130\031\131" +
    "\025\156\024\001\002\000\032\004\ufff7\005\ufff7\043\ufff7" +
    "\067\ufff7\120\ufff7\121\ufff7\122\ufff7\123\ufff7\127\ufff7\130" +
    "\ufff7\131\ufff7\156\ufff7\001\002\000\032\004\ufff9\005\ufff9" +
    "\034\ufff9\043\ufff9\120\ufff9\121\ufff9\122\ufff9\123\ufff9\127" +
    "\ufff9\130\ufff9\131\ufff9\156\ufff9\001\002\000\010\021\uffed" +
    "\076\uffed\110\uffed\001\002\000\006\021\ufff2\076\ufff2\001" +
    "\002\000\010\021\uffef\076\uffef\110\uffef\001\002\000\006" +
    "\021\ufff1\076\ufff1\001\002\000\010\021\uffe8\076\uffe8\110" +
    "\uffe8\001\002\000\010\021\ufff0\076\ufff0\110\ufff0\001\002" +
    "\000\006\021\ufff5\076\ufff5\001\002\000\006\021\ufff3\076" +
    "\ufff3\001\002\000\010\021\uffee\076\uffee\110\uffee\001\002" +
    "\000\010\021\uffec\076\uffec\110\uffec\001\002\000\010\021" +
    "\uffe9\076\uffe9\110\uffe9\001\002\000\010\021\uffeb\076\uffeb" +
    "\110\uffeb\001\002\000\006\021\036\076\037\001\002\000" +
    "\010\021\uffea\076\uffea\110\uffea\001\002\000\030\004\021" +
    "\005\027\043\032\120\035\121\022\122\033\123\030\127" +
    "\020\130\031\131\025\156\024\001\002\000\004\004\040" +
    "\001\002\000\032\004\ufff6\005\ufff6\034\ufff6\043\ufff6\120" +
    "\ufff6\121\ufff6\122\ufff6\123\ufff6\127\ufff6\130\ufff6\131\ufff6" +
    "\156\ufff6\001\002\000\006\021\ufff4\076\ufff4\001\002\000" +
    "\032\004\uffff\005\uffff\043\uffff\067\044\120\uffff\121\uffff" +
    "\122\uffff\123\uffff\127\uffff\130\uffff\131\uffff\156\uffff\001" +
    "\002\000\030\004\045\005\056\043\032\120\035\121\022" +
    "\122\033\123\030\127\020\130\031\131\025\156\024\001" +
    "\002\000\004\002\ufffc\001\002\000\004\010\u016d\001\002" +
    "\000\032\004\uffe1\005\uffe1\043\uffe1\067\uffe1\120\uffe1\121" +
    "\uffe1\122\uffe1\123\uffe1\127\uffe1\130\uffe1\131\uffe1\156\uffe1" +
    "\001\002\000\032\004\uffe2\005\uffe2\043\uffe2\067\uffe2\120" +
    "\uffe2\121\uffe2\122\uffe2\123\uffe2\127\uffe2\130\uffe2\131\uffe2" +
    "\156\uffe2\001\002\000\032\004\uffe6\005\uffe6\043\uffe6\067" +
    "\uffe6\120\uffe6\121\uffe6\122\uffe6\123\uffe6\127\uffe6\130\uffe6" +
    "\131\uffe6\156\uffe6\001\002\000\032\004\uffe0\005\uffe0\043" +
    "\uffe0\067\uffe0\120\uffe0\121\uffe0\122\uffe0\123\uffe0\127\uffe0" +
    "\130\uffe0\131\uffe0\156\uffe0\001\002\000\032\004\uffe7\005" +
    "\uffe7\043\uffe7\067\uffe7\120\uffe7\121\uffe7\122\uffe7\123\uffe7" +
    "\127\uffe7\130\uffe7\131\uffe7\156\uffe7\001\002\000\032\004" +
    "\uffe5\005\uffe5\043\uffe5\067\uffe5\120\uffe5\121\uffe5\122\uffe5" +
    "\123\uffe5\127\uffe5\130\uffe5\131\uffe5\156\uffe5\001\002\000" +
    "\004\110\u015d\001\002\000\032\004\uffe4\005\uffe4\043\uffe4" +
    "\067\uffe4\120\uffe4\121\uffe4\122\uffe4\123\uffe4\127\uffe4\130" +
    "\uffe4\131\uffe4\156\uffe4\001\002\000\024\043\072\120\073" +
    "\121\065\122\071\123\067\126\064\127\063\130\070\131" +
    "\066\001\002\000\032\004\ufffe\005\ufffe\043\ufffe\067\ufffe" +
    "\120\ufffe\121\ufffe\122\ufffe\123\ufffe\127\ufffe\130\ufffe\131" +
    "\ufffe\156\ufffe\001\002\000\032\004\uffde\005\uffde\043\uffde" +
    "\067\uffde\120\uffde\121\uffde\122\uffde\123\uffde\127\uffde\130" +
    "\uffde\131\uffde\156\uffde\001\002\000\032\004\uffdf\005\uffdf" +
    "\043\uffdf\067\uffdf\120\uffdf\121\uffdf\122\uffdf\123\uffdf\127" +
    "\uffdf\130\uffdf\131\uffdf\156\uffdf\001\002\000\032\004\uffe3" +
    "\005\uffe3\043\uffe3\067\uffe3\120\uffe3\121\uffe3\122\uffe3\123" +
    "\uffe3\127\uffe3\130\uffe3\131\uffe3\156\uffe3\001\002\000\004" +
    "\132\u0150\001\002\000\004\100\u014d\001\002\000\004\107" +
    "\u013c\001\002\000\004\154\u011d\001\002\000\006\132\u010f" +
    "\151\uff8b\001\002\000\004\151\u0106\001\002\000\004\124" +
    "\371\001\002\000\004\142\320\001\002\000\004\151\074" +
    "\001\002\000\004\005\075\001\002\000\004\065\076\001" +
    "\002\000\004\007\077\001\002\000\010\010\uff83\117\uff83" +
    "\144\101\001\002\000\006\010\uff80\117\uff80\001\002\000" +
    "\004\007\102\001\002\000\006\010\uff84\117\uff84\001\002" +
    "\000\006\010\105\117\uff82\001\002\000\004\117\121\001" +
    "\002\000\004\015\107\001\002\000\032\004\uff7f\005\uff7f" +
    "\043\uff7f\067\uff7f\120\uff7f\121\uff7f\122\uff7f\123\uff7f\127" +
    "\uff7f\130\uff7f\131\uff7f\156\uff7f\001\002\000\010\005\uffd2" +
    "\006\uffd2\016\uffd2\001\002\000\010\005\uffd4\006\uffd4\016" +
    "\112\001\002\000\006\005\115\006\113\001\002\000\032" +
    "\004\uffd1\005\uffd1\043\uffd1\067\uffd1\120\uffd1\121\uffd1\122" +
    "\uffd1\123\uffd1\127\uffd1\130\uffd1\131\uffd1\156\uffd1\001\002" +
    "\000\010\005\uffcf\006\uffcf\016\uffcf\001\002\000\010\005" +
    "\uffd3\006\uffd3\016\uffd3\001\002\000\012\005\uffd0\006\uffd0" +
    "\016\uffd0\023\116\001\002\000\004\006\117\001\002\000" +
    "\004\024\120\001\002\000\010\005\uffce\006\uffce\016\uffce" +
    "\001\002\000\014\010\uff7d\077\uff7d\111\123\117\uff7d\126" +
    "\uff7d\001\002\000\006\010\uff81\117\uff81\001\002\000\004" +
    "\015\312\001\002\000\012\010\uff7a\077\uff7a\117\uff7a\126" +
    "\uff7a\001\002\000\012\010\uff79\077\uff7c\117\uff79\126\uff7c" +
    "\001\002\000\006\077\132\126\130\001\002\000\012\010" +
    "\uff7b\077\uff7b\117\uff7b\126\uff7b\001\002\000\004\005\137" +
    "\001\002\000\012\010\uff78\077\uff78\117\uff78\126\uff78\001" +
    "\002\000\004\005\134\001\002\000\012\010\uff77\077\uff77" +
    "\117\uff77\126\uff77\001\002\000\004\065\135\001\002\000" +
    "\004\007\136\001\002\000\012\010\uff76\077\uff76\117\uff76" +
    "\126\uff76\001\002\000\012\065\uff74\115\uff74\154\140\166" +
    "\uff74\001\002\000\024\004\157\025\165\051\166\054\153" +
    "\106\154\126\160\133\155\146\163\156\161\001\002\000" +
    "\010\065\uff72\115\uff72\166\142\001\002\000\024\004\157" +
    "\025\165\051\166\054\153\106\154\126\160\133\155\146" +
    "\163\156\161\001\002\000\006\065\uff70\115\144\001\002" +
    "\000\004\005\150\001\002\000\004\065\146\001\002\000" +
    "\004\007\147\001\002\000\012\010\uff6f\077\uff6f\117\uff6f" +
    "\126\uff6f\001\002\000\004\065\uff71\001\002\000\026\004" +
    "\157\025\165\054\153\072\306\101\305\106\154\126\160" +
    "\133\155\146\215\156\161\001\002\000\054\004\uffc1\005" +
    "\uffc1\016\uffc1\021\uffc1\023\216\043\uffc1\060\uffc1\065\uffc1" +
    "\067\uffc1\113\uffc1\115\uffc1\120\uffc1\121\uffc1\122\uffc1\123" +
    "\uffc1\127\uffc1\130\uffc1\131\uffc1\156\uffc1\161\uffc1\166\uffc1" +
    "\001\002\000\004\015\301\001\002\000\056\004\uffba\005" +
    "\uffba\015\267\016\uffba\021\uffba\023\uffba\043\uffba\060\uffba" +
    "\065\uffba\067\uffba\113\uffba\115\uffba\120\uffba\121\uffba\122" +
    "\uffba\123\uffba\127\uffba\130\uffba\131\uffba\156\uffba\161\uffba" +
    "\166\uffba\001\002\000\004\152\266\001\002\000\054\004" +
    "\uffb8\005\uffb8\016\uffb8\021\uffb8\023\uffb8\043\uffb8\060\uffb8" +
    "\065\uffb8\067\uffb8\113\uffb8\115\uffb8\120\uffb8\121\uffb8\122" +
    "\uffb8\123\uffb8\127\uffb8\130\uffb8\131\uffb8\156\uffb8\161\uffb8" +
    "\166\uffb8\001\002\000\054\004\uffb5\005\uffb5\016\uffb5\021" +
    "\uffb5\023\uffb5\043\uffb5\060\uffb5\065\uffb5\067\uffb5\113\uffb5" +
    "\115\uffb5\120\uffb5\121\uffb5\122\uffb5\123\uffb5\127\uffb5\130" +
    "\uffb5\131\uffb5\156\uffb5\161\uffb5\166\uffb5\001\002\000\004" +
    "\100\265\001\002\000\006\066\252\151\uffaf\001\002\000" +
    "\054\004\uffb3\005\uffb3\016\uffb3\021\uffb3\023\uffb3\043\uffb3" +
    "\060\uffb3\065\uffb3\067\uffb3\113\uffb3\115\uffb3\120\uffb3\121" +
    "\uffb3\122\uffb3\123\uffb3\127\uffb3\130\uffb3\131\uffb3\156\uffb3" +
    "\161\uffb3\166\uffb3\001\002\000\006\015\207\134\210\001" +
    "\002\000\006\065\uff73\115\uff73\001\002\000\012\006\uffa4" +
    "\045\203\141\204\162\202\001\002\000\004\015\167\001" +
    "\002\000\004\005\170\001\002\000\004\015\176\001\002" +
    "\000\006\016\uffbe\021\uffbe\001\002\000\006\016\174\021" +
    "\173\001\002\000\004\005\170\001\002\000\054\004\uffbf" +
    "\005\uffbf\016\uffbf\021\uffbf\023\uffbf\043\uffbf\060\uffbf\065" +
    "\uffbf\067\uffbf\113\uffbf\115\uffbf\120\uffbf\121\uffbf\122\uffbf" +
    "\123\uffbf\127\uffbf\130\uffbf\131\uffbf\156\uffbf\161\uffbf\166" +
    "\uffbf\001\002\000\006\016\uffbd\021\uffbd\001\002\000\004" +
    "\006\177\001\002\000\004\016\200\001\002\000\006\016" +
    "\uffbc\021\uffbc\001\002\000\004\006\205\001\002\000\004" +
    "\006\uffa7\001\002\000\004\006\uffa6\001\002\000\004\006" +
    "\uffa5\001\002\000\004\026\206\001\002\000\026\004\uffa8" +
    "\025\uffa8\054\uffa8\072\uffa8\101\uffa8\106\uffa8\126\uffa8\133" +
    "\uffa8\146\uffa8\156\uffa8\001\002\000\004\005\213\001\002" +
    "\000\004\004\211\001\002\000\054\004\uffc0\005\uffc0\016" +
    "\uffc0\021\uffc0\023\uffc0\043\uffc0\060\uffc0\065\uffc0\067\uffc0" +
    "\113\uffc0\115\uffc0\120\uffc0\121\uffc0\122\uffc0\123\uffc0\127" +
    "\uffc0\130\uffc0\131\uffc0\156\uffc0\161\uffc0\166\uffc0\001\002" +
    "\000\006\016\246\021\245\001\002\000\022\004\157\025" +
    "\165\054\153\106\154\126\160\133\155\146\215\156\161" +
    "\001\002\000\010\016\uff92\021\uff92\023\216\001\002\000" +
    "\004\015\207\001\002\000\012\006\225\027\224\114\220" +
    "\150\226\001\002\000\004\024\uffa2\001\002\000\004\011" +
    "\uff9b\001\002\000\004\011\240\001\002\000\004\011\uff9c" +
    "\001\002\000\004\024\237\001\002\000\004\006\236\001" +
    "\002\000\010\011\uff95\024\uff9f\036\uff9f\001\002\000\004" +
    "\023\227\001\002\000\010\006\225\027\224\114\220\001" +
    "\002\000\004\024\231\001\002\000\004\024\uffa3\001\002" +
    "\000\006\024\uff9e\036\uffa1\001\002\000\004\036\234\001" +
    "\002\000\004\006\235\001\002\000\006\024\uffa0\036\uffa0" +
    "\001\002\000\006\011\uff94\024\uff94\001\002\000\054\004" +
    "\uffb4\005\uffb4\016\uffb4\021\uffb4\023\uffb4\043\uffb4\060\uffb4" +
    "\065\uffb4\067\uffb4\113\uffb4\115\uffb4\120\uffb4\121\uffb4\122" +
    "\uffb4\123\uffb4\127\uffb4\130\uffb4\131\uffb4\156\uffb4\161\uffb4" +
    "\166\uffb4\001\002\000\010\006\242\027\224\112\244\001" +
    "\002\000\004\024\uff9a\001\002\000\004\024\uff95\001\002" +
    "\000\004\024\uff9d\001\002\000\004\024\uff99\001\002\000" +
    "\004\005\247\001\002\000\054\004\uffb2\005\uffb2\016\uffb2" +
    "\021\uffb2\023\uffb2\043\uffb2\060\uffb2\065\uffb2\067\uffb2\113" +
    "\uffb2\115\uffb2\120\uffb2\121\uffb2\122\uffb2\123\uffb2\127\uffb2" +
    "\130\uffb2\131\uffb2\156\uffb2\161\uffb2\166\uffb2\001\002\000" +
    "\022\004\157\025\165\054\153\106\154\126\160\133\155" +
    "\146\215\156\161\001\002\000\010\016\uff93\021\uff93\023" +
    "\216\001\002\000\004\151\254\001\002\000\004\007\253" +
    "\001\002\000\004\151\uffb0\001\002\000\004\005\255\001" +
    "\002\000\004\065\256\001\002\000\004\007\257\001\002" +
    "\000\006\144\260\154\uffad\001\002\000\004\007\264\001" +
    "\002\000\004\154\262\001\002\000\024\004\157\025\165" +
    "\051\166\054\153\106\154\126\160\133\155\146\163\156" +
    "\161\001\002\000\054\004\uffac\005\uffac\016\uffac\021\uffac" +
    "\023\uffac\043\uffac\060\uffac\065\uffac\067\uffac\113\uffac\115" +
    "\uffac\120\uffac\121\uffac\122\uffac\123\uffac\127\uffac\130\uffac" +
    "\131\uffac\156\uffac\161\uffac\166\uffac\001\002\000\004\154" +
    "\uffae\001\002\000\054\004\uffb6\005\uffb6\016\uffb6\021\uffb6" +
    "\023\uffb6\043\uffb6\060\uffb6\065\uffb6\067\uffb6\113\uffb6\115" +
    "\uffb6\120\uffb6\121\uffb6\122\uffb6\123\uffb6\127\uffb6\130\uffb6" +
    "\131\uffb6\156\uffb6\161\uffb6\166\uffb6\001\002\000\054\004" +
    "\uffb7\005\uffb7\016\uffb7\021\uffb7\023\uffb7\043\uffb7\060\uffb7" +
    "\065\uffb7\067\uffb7\113\uffb7\115\uffb7\120\uffb7\121\uffb7\122" +
    "\uffb7\123\uffb7\127\uffb7\130\uffb7\131\uffb7\156\uffb7\161\uffb7" +
    "\166\uffb7\001\002\000\004\005\272\001\002\000\006\016" +
    "\uff98\021\uff98\001\002\000\006\016\277\021\276\001\002" +
    "\000\004\023\273\001\002\000\006\006\242\027\224\001" +
    "\002\000\004\024\275\001\002\000\006\016\uff96\021\uff96" +
    "\001\002\000\004\005\272\001\002\000\054\004\uffb9\005" +
    "\uffb9\016\uffb9\021\uffb9\023\uffb9\043\uffb9\060\uffb9\065\uffb9" +
    "\067\uffb9\113\uffb9\115\uffb9\120\uffb9\121\uffb9\122\uffb9\123" +
    "\uffb9\127\uffb9\130\uffb9\131\uffb9\156\uffb9\161\uffb9\166\uffb9" +
    "\001\002\000\006\016\uff97\021\uff97\001\002\000\004\005" +
    "\213\001\002\000\006\016\303\021\245\001\002\000\054" +
    "\004\uffb1\005\uffb1\016\uffb1\021\uffb1\023\uffb1\043\uffb1\060" +
    "\uffb1\065\uffb1\067\uffb1\113\uffb1\115\uffb1\120\uffb1\121\uffb1" +
    "\122\uffb1\123\uffb1\127\uffb1\130\uffb1\131\uffb1\156\uffb1\161" +
    "\uffb1\166\uffb1\001\002\000\054\004\uffab\005\uffab\016\uffab" +
    "\021\uffab\023\216\043\uffab\060\uffab\065\uffab\067\uffab\113" +
    "\uffab\115\uffab\120\uffab\121\uffab\122\uffab\123\uffab\127\uffab" +
    "\130\uffab\131\uffab\156\uffab\161\uffab\166\uffab\001\002\000" +
    "\022\004\157\025\165\054\153\106\154\126\160\133\155" +
    "\146\215\156\161\001\002\000\022\004\157\025\165\054" +
    "\153\106\154\126\160\133\155\146\215\156\161\001\002" +
    "\000\054\004\uffa9\005\uffa9\016\uffa9\021\uffa9\023\216\043" +
    "\uffa9\060\uffa9\065\uffa9\067\uffa9\113\uffa9\115\uffa9\120\uffa9" +
    "\121\uffa9\122\uffa9\123\uffa9\127\uffa9\130\uffa9\131\uffa9\156" +
    "\uffa9\161\uffa9\166\uffa9\001\002\000\054\004\uffaa\005\uffaa" +
    "\016\uffaa\021\uffaa\023\216\043\uffaa\060\uffaa\065\uffaa\067" +
    "\uffaa\113\uffaa\115\uffaa\120\uffaa\121\uffaa\122\uffaa\123\uffaa" +
    "\127\uffaa\130\uffaa\131\uffaa\156\uffaa\161\uffaa\166\uffaa\001" +
    "\002\000\010\065\uff75\115\uff75\166\uff75\001\002\000\004" +
    "\005\314\001\002\000\006\016\316\021\315\001\002\000" +
    "\006\016\uff8e\021\uff8e\001\002\000\004\005\317\001\002" +
    "\000\012\010\uff7e\077\uff7e\117\uff7e\126\uff7e\001\002\000" +
    "\006\016\uff8d\021\uff8d\001\002\000\004\007\321\001\002" +
    "\000\004\151\322\001\002\000\004\005\323\001\002\000" +
    "\004\065\324\001\002\000\004\007\325\001\002\000\010" +
    "\010\uff6d\144\327\153\uff6d\001\002\000\006\010\uff6a\153" +
    "\uff6a\001\002\000\004\007\330\001\002\000\006\010\uff6e" +
    "\153\uff6e\001\002\000\006\010\333\153\uff6c\001\002\000" +
    "\004\153\336\001\002\000\004\015\107\001\002\000\032" +
    "\004\uff69\005\uff69\043\uff69\067\uff69\120\uff69\121\uff69\122" +
    "\uff69\123\uff69\127\uff69\130\uff69\131\uff69\156\uff69\001\002" +
    "\000\006\010\uff6b\153\uff6b\001\002\000\004\004\337\001" +
    "\002\000\004\104\340\001\002\000\004\015\341\001\002" +
    "\000\004\005\314\001\002\000\006\016\343\021\315\001" +
    "\002\000\010\010\uff66\153\uff66\164\uff66\001\002\000\010" +
    "\010\uff65\153\uff65\164\uff68\001\002\000\004\164\346\001" +
    "\002\000\004\005\350\001\002\000\010\010\uff67\153\uff67" +
    "\164\uff67\001\002\000\014\060\uff63\065\uff63\115\uff63\154" +
    "\351\166\uff63\001\002\000\024\004\157\025\165\051\166" +
    "\054\153\106\154\126\160\133\155\146\163\156\161\001" +
    "\002\000\012\060\uff61\065\uff61\115\uff61\166\354\001\002" +
    "\000\010\060\uff5f\065\uff5f\115\357\001\002\000\024\004" +
    "\157\025\165\051\166\054\153\106\154\126\160\133\155" +
    "\146\163\156\161\001\002\000\010\060\uff62\065\uff62\115" +
    "\uff62\001\002\000\006\060\362\065\uff5d\001\002\000\004" +
    "\005\360\001\002\000\006\060\uff60\065\uff60\001\002\000" +
    "\004\065\366\001\002\000\004\015\363\001\002\000\004" +
    "\005\314\001\002\000\006\016\365\021\315\001\002\000" +
    "\004\065\uff5e\001\002\000\004\007\367\001\002\000\010" +
    "\010\uff5c\153\uff5c\164\uff5c\001\002\000\012\060\uff64\065" +
    "\uff64\115\uff64\166\uff64\001\002\000\004\015\372\001\002" +
    "\000\004\005\314\001\002\000\006\016\374\021\315\001" +
    "\002\000\004\151\375\001\002\000\004\005\376\001\002" +
    "\000\004\065\377\001\002\000\004\007\u0100\001\002\000" +
    "\006\010\uff86\144\u0102\001\002\000\004\010\u0104\001\002" +
    "\000\004\007\u0103\001\002\000\004\010\uff87\001\002\000" +
    "\004\015\107\001\002\000\032\004\uff85\005\uff85\043\uff85" +
    "\067\uff85\120\uff85\121\uff85\122\uff85\123\uff85\127\uff85\130" +
    "\uff85\131\uff85\156\uff85\001\002\000\004\005\u0107\001\002" +
    "\000\004\065\u0108\001\002\000\004\007\u0109\001\002\000" +
    "\006\010\uffd6\144\u010b\001\002\000\004\010\u010d\001\002" +
    "\000\004\007\u010c\001\002\000\004\010\uffd7\001\002\000" +
    "\004\015\107\001\002\000\032\004\uffd5\005\uffd5\043\uffd5" +
    "\067\uffd5\120\uffd5\121\uffd5\122\uffd5\123\uffd5\127\uffd5\130" +
    "\uffd5\131\uffd5\156\uffd5\001\002\000\004\015\u011a\001\002" +
    "\000\004\151\u0111\001\002\000\004\005\u0112\001\002\000" +
    "\004\065\u0113\001\002\000\004\007\u0114\001\002\000\006" +
    "\010\uff89\144\u0116\001\002\000\004\010\u0118\001\002\000" +
    "\004\007\u0117\001\002\000\004\010\uff8a\001\002\000\004" +
    "\015\107\001\002\000\032\004\uff88\005\uff88\043\uff88\067" +
    "\uff88\120\uff88\121\uff88\122\uff88\123\uff88\127\uff88\130\uff88" +
    "\131\uff88\156\uff88\001\002\000\004\005\314\001\002\000" +
    "\006\016\u011c\021\315\001\002\000\004\151\uff8c\001\002" +
    "\000\024\004\157\025\165\051\166\054\153\106\154\126" +
    "\160\133\155\146\163\156\161\001\002\000\006\113\uffcc" +
    "\161\u0120\001\002\000\004\113\u0122\001\002\000\004\007" +
    "\u0121\001\002\000\004\113\uffcd\001\002\000\004\005\u0123" +
    "\001\002\000\004\151\u0124\001\002\000\004\005\u0125\001" +
    "\002\000\004\065\u0126\001\002\000\004\007\u0127\001\002" +
    "\000\012\010\uffca\046\uffca\105\uffca\144\u0129\001\002\000" +
    "\010\010\uffc8\046\u012c\105\u012b\001\002\000\004\007\u012a" +
    "\001\002\000\010\010\uffcb\046\uffcb\105\uffcb\001\002\000" +
    "\004\015\u0134\001\002\000\004\015\u0131\001\002\000\004" +
    "\010\uffc9\001\002\000\004\010\u012f\001\002\000\004\015" +
    "\107\001\002\000\032\004\uffc7\005\uffc7\043\uffc7\067\uffc7" +
    "\120\uffc7\121\uffc7\122\uffc7\123\uffc7\127\uffc7\130\uffc7\131" +
    "\uffc7\156\uffc7\001\002\000\004\005\u0132\001\002\000\004" +
    "\016\u0133\001\002\000\004\010\uffc5\001\002\000\006\005" +
    "\u0137\102\u0136\001\002\000\004\016\u013b\001\002\000\004" +
    "\005\u013a\001\002\000\006\016\uffc4\021\u0138\001\002\000" +
    "\006\005\u0137\102\u0136\001\002\000\004\016\uffc2\001\002" +
    "\000\004\016\uffc3\001\002\000\004\010\uffc6\001\002\000" +
    "\004\007\u013d\001\002\000\004\136\u013e\001\002\000\004" +
    "\007\u013f\001\002\000\004\057\u0140\001\002\000\004\007" +
    "\u0141\001\002\000\004\065\u0142\001\002\000\004\007\u0143" +
    "\001\002\000\006\010\uffdb\145\uffdb\001\002\000\006\010" +
    "\u0146\145\uffdd\001\002\000\004\145\u0148\001\002\000\004" +
    "\015\107\001\002\000\032\004\uffda\005\uffda\043\uffda\067" +
    "\uffda\120\uffda\121\uffda\122\uffda\123\uffda\127\uffda\130\uffda" +
    "\131\uffda\156\uffda\001\002\000\004\007\u014a\001\002\000" +
    "\006\010\uffdc\145\uffdc\001\002\000\004\065\u014b\001\002" +
    "\000\004\007\u014c\001\002\000\006\010\uffd9\145\uffd9\001" +
    "\002\000\004\010\u014e\001\002\000\004\015\107\001\002" +
    "\000\032\004\uffd8\005\uffd8\043\uffd8\067\uffd8\120\uffd8\121" +
    "\uffd8\122\uffd8\123\uffd8\127\uffd8\130\uffd8\131\uffd8\156\uffd8" +
    "\001\002\000\004\015\u0151\001\002\000\004\005\314\001" +
    "\002\000\006\016\u0153\021\315\001\002\000\004\151\u0154" +
    "\001\002\000\004\005\u0155\001\002\000\004\065\u0156\001" +
    "\002\000\004\007\u0157\001\002\000\006\010\uff90\144\u0159" +
    "\001\002\000\004\010\u015b\001\002\000\004\007\u015a\001" +
    "\002\000\004\010\uff91\001\002\000\004\015\107\001\002" +
    "\000\032\004\uff8f\005\uff8f\043\uff8f\067\uff8f\120\uff8f\121" +
    "\uff8f\122\uff8f\123\uff8f\127\uff8f\130\uff8f\131\uff8f\156\uff8f" +
    "\001\002\000\004\010\u015e\001\002\000\004\047\u015f\001" +
    "\002\000\026\004\uff59\005\uff59\007\uff59\010\uff59\023\uff59" +
    "\024\uff59\036\uff59\067\uff59\100\uff59\126\uff59\001\002\000" +
    "\026\004\uff5b\005\uff5b\007\uff5b\010\uff5b\023\uff5b\024\uff5b" +
    "\036\uff5b\067\u0162\100\uff5b\126\uff5b\001\002\000\024\004" +
    "\u0165\005\u0167\007\u0169\010\u0168\023\u0163\024\u016b\036\u0164" +
    "\100\u016a\126\u0166\001\002\000\032\004\uff58\005\uff58\043" +
    "\uff58\067\uff58\120\uff58\121\uff58\122\uff58\123\uff58\127\uff58" +
    "\130\uff58\131\uff58\156\uff58\001\002\000\026\004\uff55\005" +
    "\uff55\007\uff55\010\uff55\023\uff55\024\uff55\036\uff55\067\uff55" +
    "\100\uff55\126\uff55\001\002\000\026\004\uff53\005\uff53\007" +
    "\uff53\010\uff53\023\uff53\024\uff53\036\uff53\067\uff53\100\uff53" +
    "\126\uff53\001\002\000\026\004\uff56\005\uff56\007\uff56\010" +
    "\uff56\023\uff56\024\uff56\036\uff56\067\uff56\100\uff56\126\uff56" +
    "\001\002\000\026\004\uff50\005\uff50\007\uff50\010\uff50\023" +
    "\uff50\024\uff50\036\uff50\067\uff50\100\uff50\126\uff50\001\002" +
    "\000\026\004\uff57\005\uff57\007\uff57\010\uff57\023\uff57\024" +
    "\uff57\036\uff57\067\uff57\100\uff57\126\uff57\001\002\000\026" +
    "\004\uff52\005\uff52\007\uff52\010\uff52\023\uff52\024\uff52\036" +
    "\uff52\067\uff52\100\uff52\126\uff52\001\002\000\026\004\uff51" +
    "\005\uff51\007\uff51\010\uff51\023\uff51\024\uff51\036\uff51\067" +
    "\uff51\100\uff51\126\uff51\001\002\000\026\004\uff4f\005\uff4f" +
    "\007\uff4f\010\uff4f\023\uff4f\024\uff4f\036\uff4f\067\uff4f\100" +
    "\uff4f\126\uff4f\001\002\000\026\004\uff54\005\uff54\007\uff54" +
    "\010\uff54\023\uff54\024\uff54\036\uff54\067\uff54\100\uff54\126" +
    "\uff54\001\002\000\026\004\uff5a\005\uff5a\007\uff5a\010\uff5a" +
    "\023\uff5a\024\uff5a\036\uff5a\067\uff5a\100\uff5a\126\uff5a\001" +
    "\002\000\022\004\157\025\165\054\153\106\154\126\160" +
    "\133\155\146\215\156\161\001\002\000\034\004\uffbb\005" +
    "\uffbb\023\216\043\uffbb\067\uffbb\120\uffbb\121\uffbb\122\uffbb" +
    "\123\uffbb\127\uffbb\130\uffbb\131\uffbb\156\uffbb\001\002\000" +
    "\004\002\ufffb\001\002" });

  /** Access to parse-action table. */
  public short[][] action_table() {return _action_table;}

  /** <code>reduce_goto</code> table. */
  protected static final short[][] _reduce_table = 
    unpackFromStrings(new String[] {
    "\000\u016d\000\004\004\003\001\001\000\002\001\001\000" +
    "\002\001\001\000\002\001\001\000\002\001\001\000\006" +
    "\005\012\061\010\001\001\000\004\062\041\001\001\000" +
    "\004\064\013\001\001\000\002\001\001\000\004\065\014" +
    "\001\001\000\012\003\022\006\016\007\033\010\025\001" +
    "\001\000\002\001\001\000\002\001\001\000\002\001\001" +
    "\000\002\001\001\000\002\001\001\000\002\001\001\000" +
    "\002\001\001\000\002\001\001\000\002\001\001\000\002" +
    "\001\001\000\002\001\001\000\002\001\001\000\002\001" +
    "\001\000\002\001\001\000\002\001\001\000\002\001\001" +
    "\000\006\003\022\010\040\001\001\000\002\001\001\000" +
    "\002\001\001\000\002\001\001\000\004\063\042\001\001" +
    "\000\032\003\053\011\051\013\056\014\052\015\047\023" +
    "\054\040\057\045\061\046\046\047\045\050\050\051\060" +
    "\001\001\000\002\001\001\000\002\001\001\000\002\001" +
    "\001\000\002\001\001\000\002\001\001\000\002\001\001" +
    "\000\002\001\001\000\002\001\001\000\002\001\001\000" +
    "\002\001\001\000\002\001\001\000\002\001\001\000\002" +
    "\001\001\000\002\001\001\000\002\001\001\000\002\001" +
    "\001\000\002\001\001\000\002\001\001\000\002\001\001" +
    "\000\004\103\u010f\001\001\000\002\001\001\000\002\001" +
    "\001\000\002\001\001\000\002\001\001\000\002\001\001" +
    "\000\002\001\001\000\002\001\001\000\004\106\077\001" +
    "\001\000\004\107\102\001\001\000\002\001\001\000\002" +
    "\001\001\000\004\110\103\001\001\000\004\055\121\001" +
    "\001\000\004\036\105\001\001\000\002\001\001\000\004" +
    "\071\107\001\001\000\004\072\110\001\001\000\004\035" +
    "\113\001\001\000\002\001\001\000\002\001\001\000\002" +
    "\001\001\000\002\001\001\000\002\001\001\000\002\001" +
    "\001\000\002\001\001\000\004\111\123\001\001\000\002" +
    "\001\001\000\002\001\001\000\004\112\124\001\001\000" +
    "\004\113\125\001\001\000\010\052\130\053\132\056\126" +
    "\001\001\000\002\001\001\000\002\001\001\000\002\001" +
    "\001\000\002\001\001\000\002\001\001\000\002\001\001" +
    "\000\002\001\001\000\002\001\001\000\004\114\140\001" +
    "\001\000\014\020\310\024\151\037\161\042\155\043\150" +
    "\001\001\000\004\115\142\001\001\000\014\020\163\024" +
    "\151\037\161\042\155\043\150\001\001\000\004\116\144" +
    "\001\001\000\002\001\001\000\002\001\001\000\002\001" +
    "\001\000\002\001\001\000\002\001\001\000\012\024\303" +
    "\037\161\042\155\043\150\001\001\000\002\001\001\000" +
    "\002\001\001\000\002\001\001\000\002\001\001\000\002" +
    "\001\001\000\002\001\001\000\002\001\001\000\004\076" +
    "\250\001\001\000\002\001\001\000\002\001\001\000\002" +
    "\001\001\000\004\044\200\001\001\000\002\001\001\000" +
    "\006\021\171\022\170\001\001\000\002\001\001\000\002" +
    "\001\001\000\002\001\001\000\004\022\174\001\001\000" +
    "\002\001\001\000\002\001\001\000\002\001\001\000\002" +
    "\001\001\000\002\001\001\000\002\001\001\000\002\001" +
    "\001\000\002\001\001\000\002\001\001\000\002\001\001" +
    "\000\002\001\001\000\004\034\211\001\001\000\002\001" +
    "\001\000\002\001\001\000\002\001\001\000\012\024\213" +
    "\037\161\042\155\043\150\001\001\000\002\001\001\000" +
    "\002\001\001\000\012\025\222\026\216\027\220\033\221" +
    "\001\001\000\002\001\001\000\002\001\001\000\002\001" +
    "\001\000\002\001\001\000\002\001\001\000\002\001\001" +
    "\000\004\100\231\001\001\000\002\001\001\000\010\026" +
    "\227\027\220\033\221\001\001\000\002\001\001\000\002" +
    "\001\001\000\004\101\232\001\001\000\002\001\001\000" +
    "\002\001\001\000\002\001\001\000\002\001\001\000\002" +
    "\001\001\000\006\030\242\033\240\001\001\000\002\001" +
    "\001\000\002\001\001\000\002\001\001\000\002\001\001" +
    "\000\002\001\001\000\002\001\001\000\012\024\247\037" +
    "\161\042\155\043\150\001\001\000\002\001\001\000\002" +
    "\001\001\000\002\001\001\000\002\001\001\000\002\001" +
    "\001\000\002\001\001\000\002\001\001\000\004\077\260" +
    "\001\001\000\002\001\001\000\002\001\001\000\014\020" +
    "\262\024\151\037\161\042\155\043\150\001\001\000\002" +
    "\001\001\000\002\001\001\000\002\001\001\000\002\001" +
    "\001\000\006\031\270\032\267\001\001\000\002\001\001" +
    "\000\002\001\001\000\002\001\001\000\004\033\273\001" +
    "\001\000\002\001\001\000\002\001\001\000\004\032\277" +
    "\001\001\000\002\001\001\000\002\001\001\000\004\034" +
    "\301\001\001\000\002\001\001\000\002\001\001\000\002" +
    "\001\001\000\012\024\307\037\161\042\155\043\150\001" +
    "\001\000\012\024\306\037\161\042\155\043\150\001\001" +
    "\000\002\001\001\000\002\001\001\000\002\001\001\000" +
    "\004\054\312\001\001\000\002\001\001\000\002\001\001" +
    "\000\002\001\001\000\002\001\001\000\002\001\001\000" +
    "\002\001\001\000\002\001\001\000\002\001\001\000\002" +
    "\001\001\000\002\001\001\000\004\117\325\001\001\000" +
    "\004\120\330\001\001\000\002\001\001\000\002\001\001" +
    "\000\004\121\331\001\001\000\004\057\334\001\001\000" +
    "\004\036\333\001\001\000\002\001\001\000\002\001\001" +
    "\000\002\001\001\000\002\001\001\000\002\001\001\000" +
    "\004\054\341\001\001\000\002\001\001\000\004\122\343" +
    "\001\001\000\004\123\344\001\001\000\004\060\346\001" +
    "\001\000\002\001\001\000\002\001\001\000\004\124\351" +
    "\001\001\000\014\020\367\024\151\037\161\042\155\043" +
    "\150\001\001\000\004\125\352\001\001\000\004\126\355" +
    "\001\001\000\014\020\354\024\151\037\161\042\155\043" +
    "\150\001\001\000\002\001\001\000\004\127\360\001\001" +
    "\000\002\001\001\000\002\001\001\000\002\001\001\000" +
    "\002\001\001\000\004\054\363\001\001\000\002\001\001" +
    "\000\002\001\001\000\002\001\001\000\002\001\001\000" +
    "\002\001\001\000\002\001\001\000\004\054\372\001\001" +
    "\000\002\001\001\000\002\001\001\000\002\001\001\000" +
    "\002\001\001\000\002\001\001\000\004\105\u0100\001\001" +
    "\000\002\001\001\000\002\001\001\000\002\001\001\000" +
    "\004\036\u0104\001\001\000\002\001\001\000\002\001\001" +
    "\000\002\001\001\000\002\001\001\000\004\070\u0109\001" +
    "\001\000\002\001\001\000\002\001\001\000\002\001\001" +
    "\000\004\036\u010d\001\001\000\002\001\001\000\002\001" +
    "\001\000\002\001\001\000\002\001\001\000\002\001\001" +
    "\000\002\001\001\000\004\104\u0114\001\001\000\002\001" +
    "\001\000\002\001\001\000\002\001\001\000\004\036\u0118" +
    "\001\001\000\002\001\001\000\004\054\u011a\001\001\000" +
    "\002\001\001\000\002\001\001\000\014\020\u011d\024\151" +
    "\037\161\042\155\043\150\001\001\000\004\073\u011e\001" +
    "\001\000\002\001\001\000\002\001\001\000\002\001\001" +
    "\000\002\001\001\000\002\001\001\000\002\001\001\000" +
    "\002\001\001\000\002\001\001\000\004\074\u0127\001\001" +
    "\000\006\016\u012c\075\u012d\001\001\000\002\001\001\000" +
    "\002\001\001\000\002\001\001\000\002\001\001\000\002" +
    "\001\001\000\002\001\001\000\004\036\u012f\001\001\000" +
    "\002\001\001\000\002\001\001\000\002\001\001\000\002" +
    "\001\001\000\004\017\u0134\001\001\000\002\001\001\000" +
    "\002\001\001\000\002\001\001\000\004\017\u0138\001\001" +
    "\000\002\001\001\000\002\001\001\000\002\001\001\000" +
    "\002\001\001\000\002\001\001\000\002\001\001\000\002" +
    "\001\001\000\002\001\001\000\002\001\001\000\002\001" +
    "\001\000\004\066\u0143\001\001\000\004\067\u0144\001\001" +
    "\000\004\012\u0148\001\001\000\004\036\u0146\001\001\000" +
    "\002\001\001\000\002\001\001\000\002\001\001\000\002" +
    "\001\001\000\002\001\001\000\002\001\001\000\002\001" +
    "\001\000\004\036\u014e\001\001\000\002\001\001\000\002" +
    "\001\001\000\004\054\u0151\001\001\000\002\001\001\000" +
    "\002\001\001\000\002\001\001\000\002\001\001\000\002" +
    "\001\001\000\004\102\u0157\001\001\000\002\001\001\000" +
    "\002\001\001\000\002\001\001\000\004\036\u015b\001\001" +
    "\000\002\001\001\000\002\001\001\000\002\001\001\000" +
    "\004\130\u015f\001\001\000\004\131\u0160\001\001\000\004" +
    "\041\u016b\001\001\000\002\001\001\000\002\001\001\000" +
    "\002\001\001\000\002\001\001\000\002\001\001\000\002" +
    "\001\001\000\002\001\001\000\002\001\001\000\002\001" +
    "\001\000\002\001\001\000\002\001\001\000\012\024\u016d" +
    "\037\161\042\155\043\150\001\001\000\002\001\001\000" +
    "\002\001\001" });

  /** Access to <code>reduce_goto</code> table. */
  public short[][] reduce_table() {return _reduce_table;}

  /** Instance of action encapsulation class. */
  protected CUP$Parser$actions action_obj;

  /** Action encapsulation object initializer. */
  protected void init_actions()
    {
      action_obj = new CUP$Parser$actions(this);
    }

  /** Invoke a user supplied parse action. */
  public java_cup.runtime.Symbol do_action(
    int                        act_num,
    java_cup.runtime.lr_parser parser,
    java.util.Stack            stack,
    int                        top)
    throws java.lang.Exception
  {
    /* call code in generated class */
    return action_obj.CUP$Parser$do_action(act_num, parser, stack, top);
  }

  /** Indicates start state. */
  public int start_state() {return 0;}
  /** Indicates start production. */
  public int start_production() {return 6;}

  /** <code>EOF</code> Symbol index. */
  public int EOF_sym() {return 0;}

  /** <code>error</code> Symbol index. */
  public int error_sym() {return 1;}



    @Override
    public void     syntax_error (Symbol token) {
        throw new SyntaxErrorException (Location.combine (token.left, token.right));
    }

    @Override
    public void     unrecovered_syntax_error (Symbol token) {
        syntax_error (token);
    }

}

/** Cup generated class to encapsulate user supplied action code.*/
@SuppressWarnings ("unchecked") class CUP$Parser$actions {


    private static class IndexColumns {
        final ArrayList <String> names = new ArrayList <String> ();
        final boolean lastIsImplied;

        IndexColumns (String name, boolean lastIsImplied) {
            this.lastIsImplied = lastIsImplied;
            names.add (name);
        }

        String []       getColumns () {
            return (names.toArray (new String [names.size ()]));
        }
    }

    private static long lx (long a, long b) { return (Location.combine (a, b)); }

  private final Parser parser;

  /** Constructor */
  CUP$Parser$actions(Parser parser) {
    this.parser = parser;
  }

  /** Method with the actual generated action code. */
  public final java_cup.runtime.Symbol CUP$Parser$do_action(
    int                        CUP$Parser$act_num,
    java_cup.runtime.lr_parser CUP$Parser$parser,
    java.util.Stack            CUP$Parser$stack,
    int                        CUP$Parser$top)
    throws java.lang.Exception
    {
      /* Symbol object for return from actions */
      java_cup.runtime.Symbol CUP$Parser$result;

      /* select the action based on the action number */
      switch (CUP$Parser$act_num)
        {
          /*. . . . . . . . . . . . . . . . . . . .*/
          case 178: // MacroContent ::= IDENTIFIER 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(31/*MacroContent*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 177: // MacroContent ::= OBJECT 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(31/*MacroContent*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 176: // MacroContent ::= CharString 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(31/*MacroContent*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 175: // MacroContent ::= ASSIGN 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(31/*MacroContent*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 174: // MacroContent ::= PIPE 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(31/*MacroContent*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 173: // MacroContent ::= RP 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(31/*MacroContent*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 172: // MacroContent ::= LP 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(31/*MacroContent*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 171: // MacroContent ::= TypeId 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(31/*MacroContent*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 170: // MacroContent ::= ValueId 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(31/*MacroContent*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 169: // MacroDefinition ::= MacroName MACRO ASSIGN BEGIN _aux_31 END 
            {
              MacroDefinition RESULT = null;
		int idleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-5)).left;
		int idright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-5)).right;
		String id = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-5)).value;
		int eleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int eright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Object e = (Object)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 
            RESULT = new MacroDefinition (lx (idleft, eright), id); 
        
              CUP$Parser$result = new java_cup.runtime.Symbol(30/*MacroDefinition*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-5)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 168: // _aux_31 ::= 
            {
              java.util.List <Object> RESULT = null;
		RESULT=new java.util.ArrayList <Object> ();
              CUP$Parser$result = new java_cup.runtime.Symbol(86/*_aux_31*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 167: // _aux_31 ::= _aux_31 NT$9 MacroContent 
            {
              java.util.List <Object> RESULT = null;
              // propagate RESULT from NT$9
              if ( ((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-1)).value != null )
                RESULT = (java.util.List <Object>) ((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-1)).value;
		int _list_left = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left;
		int _list_right = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).right;
		java.util.List <Object> _list_ = (java.util.List <Object>)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-2)).value;

              CUP$Parser$result = new java_cup.runtime.Symbol(86/*_aux_31*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 166: // NT$9 ::= 
            {
              Object RESULT = null;
		int _list_left = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int _list_right = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		java.util.List <Object> _list_ = (java.util.List <Object>)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
RESULT = _list_;
              CUP$Parser$result = new java_cup.runtime.Symbol(87/*NT$9*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 165: // Variation ::= VARIATION ValueId _aux_27 _aux_28 _aux_29 _aux_30 DESCRIPTION CharString 
            {
              Element RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(46/*Variation*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-7)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 164: // _aux_30 ::= 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(85/*_aux_30*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 163: // _aux_30 ::= CREATION_REQUIRES LCB ValueIdList RCB 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(85/*_aux_30*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 162: // _aux_29 ::= 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(84/*_aux_29*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 161: // _aux_29 ::= MIN_ACCESS ValueId 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(84/*_aux_29*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 160: // _aux_28 ::= 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(83/*_aux_28*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 159: // _aux_28 ::= WRITE_SYNTAX Syntax 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(83/*_aux_28*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 158: // _aux_27 ::= 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(82/*_aux_27*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 157: // _aux_27 ::= SYNTAX Syntax 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(82/*_aux_27*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 156: // ACModule ::= SUPPORTS TypeId INCLUDES LCB ValueIdList RCB _aux_26 
            {
              Element RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(45/*ACModule*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-6)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 155: // _aux_26 ::= 
            {
              java.util.List <Object> RESULT = null;
		RESULT=new java.util.ArrayList <Object> ();
              CUP$Parser$result = new java_cup.runtime.Symbol(80/*_aux_26*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 154: // _aux_26 ::= _aux_26 NT$8 Variation 
            {
              java.util.List <Object> RESULT = null;
              // propagate RESULT from NT$8
              if ( ((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-1)).value != null )
                RESULT = (java.util.List <Object>) ((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-1)).value;
		int _list_left = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left;
		int _list_right = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).right;
		java.util.List <Object> _list_ = (java.util.List <Object>)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-2)).value;

              CUP$Parser$result = new java_cup.runtime.Symbol(80/*_aux_26*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 153: // NT$8 ::= 
            {
              Object RESULT = null;
		int _list_left = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int _list_right = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		java.util.List <Object> _list_ = (java.util.List <Object>)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
RESULT = _list_;
              CUP$Parser$result = new java_cup.runtime.Symbol(81/*NT$8*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 152: // AgentCapabilitiesDefinition ::= ValueId AGENT_CAPABILITIES PRODUCT_RELEASE CharString STATUS ValueId DESCRIPTION CharString _aux_24 _aux_25 ASSIGN ObjectIdentifierValue 
            {
              Definition RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(39/*AgentCapabilitiesDefinition*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-11)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 151: // _aux_25 ::= 
            {
              java.util.List <Object> RESULT = null;
		RESULT=new java.util.ArrayList <Object> ();
              CUP$Parser$result = new java_cup.runtime.Symbol(78/*_aux_25*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 150: // _aux_25 ::= _aux_25 NT$7 ACModule 
            {
              java.util.List <Object> RESULT = null;
              // propagate RESULT from NT$7
              if ( ((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-1)).value != null )
                RESULT = (java.util.List <Object>) ((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-1)).value;
		int _list_left = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left;
		int _list_right = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).right;
		java.util.List <Object> _list_ = (java.util.List <Object>)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-2)).value;

              CUP$Parser$result = new java_cup.runtime.Symbol(78/*_aux_25*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 149: // NT$7 ::= 
            {
              Object RESULT = null;
		int _list_left = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int _list_right = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		java.util.List <Object> _list_ = (java.util.List <Object>)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
RESULT = _list_;
              CUP$Parser$result = new java_cup.runtime.Symbol(79/*NT$7*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 148: // _aux_24 ::= 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(77/*_aux_24*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 147: // _aux_24 ::= REFERENCE CharString 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(77/*_aux_24*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 146: // ComplianceObject ::= OBJECT ValueId _aux_21 _aux_22 _aux_23 DESCRIPTION CharString 
            {
              Element RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(41/*ComplianceObject*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-6)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 145: // _aux_23 ::= 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(76/*_aux_23*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 144: // _aux_23 ::= MIN_ACCESS ValueId 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(76/*_aux_23*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 143: // _aux_22 ::= 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(75/*_aux_22*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 142: // _aux_22 ::= WRITE_SYNTAX Syntax 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(75/*_aux_22*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 141: // _aux_21 ::= 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(74/*_aux_21*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 140: // _aux_21 ::= SYNTAX Syntax 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(74/*_aux_21*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 139: // ComplianceGroup ::= GROUP ValueId DESCRIPTION CharString 
            {
              Element RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(40/*ComplianceGroup*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 138: // Compliance ::= ComplianceObject 
            {
              Element RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(44/*Compliance*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 137: // Compliance ::= ComplianceGroup 
            {
              Element RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(44/*Compliance*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 136: // ComplianceModule ::= MODULE _aux_19 _aux_20 
            {
              Element RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(43/*ComplianceModule*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 135: // _aux_20 ::= 
            {
              java.util.List <Object> RESULT = null;
		RESULT=new java.util.ArrayList <Object> ();
              CUP$Parser$result = new java_cup.runtime.Symbol(72/*_aux_20*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 134: // _aux_20 ::= _aux_20 NT$6 Compliance 
            {
              java.util.List <Object> RESULT = null;
              // propagate RESULT from NT$6
              if ( ((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-1)).value != null )
                RESULT = (java.util.List <Object>) ((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-1)).value;
		int _list_left = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left;
		int _list_right = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).right;
		java.util.List <Object> _list_ = (java.util.List <Object>)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-2)).value;

              CUP$Parser$result = new java_cup.runtime.Symbol(72/*_aux_20*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 133: // NT$6 ::= 
            {
              Object RESULT = null;
		int _list_left = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int _list_right = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		java.util.List <Object> _list_ = (java.util.List <Object>)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
RESULT = _list_;
              CUP$Parser$result = new java_cup.runtime.Symbol(73/*NT$6*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 132: // _aux_19 ::= 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(71/*_aux_19*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 131: // _aux_19 ::= MANDATORY_GROUPS LCB ValueIdList RCB 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(71/*_aux_19*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 130: // ModuleComplianceDefinition ::= ValueId MODULE_COMPLIANCE STATUS ValueId DESCRIPTION CharString _aux_17 _aux_18 ASSIGN ObjectIdentifierValue 
            {
              Definition RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(38/*ModuleComplianceDefinition*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-9)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 129: // _aux_18 ::= 
            {
              java.util.List <Object> RESULT = null;
		RESULT=new java.util.ArrayList <Object> ();
              CUP$Parser$result = new java_cup.runtime.Symbol(69/*_aux_18*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 128: // _aux_18 ::= _aux_18 NT$5 ComplianceModule 
            {
              java.util.List <Object> RESULT = null;
              // propagate RESULT from NT$5
              if ( ((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-1)).value != null )
                RESULT = (java.util.List <Object>) ((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-1)).value;
		int _list_left = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left;
		int _list_right = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).right;
		java.util.List <Object> _list_ = (java.util.List <Object>)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-2)).value;

              CUP$Parser$result = new java_cup.runtime.Symbol(69/*_aux_18*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 127: // NT$5 ::= 
            {
              Object RESULT = null;
		int _list_left = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int _list_right = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		java.util.List <Object> _list_ = (java.util.List <Object>)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
RESULT = _list_;
              CUP$Parser$result = new java_cup.runtime.Symbol(70/*NT$5*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 126: // _aux_17 ::= 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(68/*_aux_17*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 125: // _aux_17 ::= REFERENCE CharString 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(68/*_aux_17*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 124: // NotificationGroupDefinition ::= ValueId NOTIFICATION_GROUP NOTIFICATIONS LCB ValueIdList RCB STATUS ValueId DESCRIPTION CharString _aux_16 ASSIGN ObjectIdentifierValue 
            {
              Definition RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(37/*NotificationGroupDefinition*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-12)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 123: // _aux_16 ::= 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(67/*_aux_16*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 122: // _aux_16 ::= REFERENCE CharString 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(67/*_aux_16*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 121: // NotificationTypeDefinition ::= ValueId NOTIFICATION_TYPE _aux_14 STATUS ValueId DESCRIPTION CharString _aux_15 ASSIGN ObjectIdentifierValue 
            {
              Definition RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(36/*NotificationTypeDefinition*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-9)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 120: // _aux_15 ::= 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(66/*_aux_15*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 119: // _aux_15 ::= REFERENCE CharString 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(66/*_aux_15*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 118: // _aux_14 ::= 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(65/*_aux_14*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 117: // _aux_14 ::= OBJECTS LCB ValueIdList RCB 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(65/*_aux_14*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 116: // ValueIdList ::= ValueIdList COMMA ValueId 
            {
              Element RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(42/*ValueIdList*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 115: // ValueIdList ::= ValueId 
            {
              Element RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(42/*ValueIdList*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 114: // ObjectGroupDefinition ::= ValueId OBJECT_GROUP OBJECTS LCB ValueIdList RCB STATUS ValueId DESCRIPTION CharString _aux_13 ASSIGN ObjectIdentifierValue 
            {
              Definition RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(35/*ObjectGroupDefinition*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-12)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 113: // _aux_13 ::= 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(64/*_aux_13*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 112: // _aux_13 ::= REFERENCE CharString 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(64/*_aux_13*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 111: // SequenceElementList ::= ValueId Type 
            {
              ArrayList<Field> RESULT = null;
		int idleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left;
		int idright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).right;
		String id = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-1)).value;
		int tleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int tright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Type t = (Type)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 
            RESULT = new ArrayList (); 
            RESULT.add (new Field (lx (idleft, tright), id, t)); 
        
              CUP$Parser$result = new java_cup.runtime.Symbol(26/*SequenceElementList*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 110: // SequenceElementList ::= SequenceElementList COMMA ValueId Type 
            {
              ArrayList<Field> RESULT = null;
		int listleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).left;
		int listright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).right;
		ArrayList<Field> list = (ArrayList<Field>)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-3)).value;
		int idleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left;
		int idright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).right;
		String id = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-1)).value;
		int tleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int tright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Type t = (Type)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		
            list.add (new Field (lx (idleft, tright), id, t));
            RESULT = list;
        
              CUP$Parser$result = new java_cup.runtime.Symbol(26/*SequenceElementList*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 109: // SignedNumber ::= HYPHEN Number 
            {
              Number RESULT = null;
		int nleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int nright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Number n = (Number)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = MathUtil.negate (n); 
              CUP$Parser$result = new java_cup.runtime.Symbol(25/*SignedNumber*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 108: // SignedNumber ::= Number 
            {
              Number RESULT = null;
		int nleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int nright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Number n = (Number)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = n; 
              CUP$Parser$result = new java_cup.runtime.Symbol(25/*SignedNumber*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 107: // NamedNumber ::= ValueId LP SignedNumber RP 
            {
              NameNumberPair RESULT = null;
		int idleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).left;
		int idright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).right;
		String id = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-3)).value;
		int nleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left;
		int nright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).right;
		Number n = (Number)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-1)).value;
		int eleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int eright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Object e = (Object)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = new NameNumberPair (lx (idleft, eright), id, n); 
              CUP$Parser$result = new java_cup.runtime.Symbol(24/*NamedNumber*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 106: // NamedNumberList ::= NamedNumberList COMMA NamedNumber 
            {
              ArrayList<NameNumberPair> RESULT = null;
		int listleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left;
		int listright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).right;
		ArrayList<NameNumberPair> list = (ArrayList<NameNumberPair>)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-2)).value;
		int nnleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int nnright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		NameNumberPair nn = (NameNumberPair)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 list.add (nn); RESULT = list; 
              CUP$Parser$result = new java_cup.runtime.Symbol(23/*NamedNumberList*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 105: // NamedNumberList ::= NamedNumber 
            {
              ArrayList<NameNumberPair> RESULT = null;
		int nnleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int nnright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		NameNumberPair nn = (NameNumberPair)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = new ArrayList (); RESULT.add (nn); 
              CUP$Parser$result = new java_cup.runtime.Symbol(23/*NamedNumberList*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 104: // UpperEnd ::= MAX 
            {
              Number RESULT = null;
		 RESULT = null; 
              CUP$Parser$result = new java_cup.runtime.Symbol(22/*UpperEnd*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 103: // UpperEnd ::= SignedNumber 
            {
              Number RESULT = null;
		int nleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int nright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Number n = (Number)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = n; 
              CUP$Parser$result = new java_cup.runtime.Symbol(22/*UpperEnd*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 102: // LowerEnd ::= MIN 
            {
              Number RESULT = null;
		 RESULT = null; 
              CUP$Parser$result = new java_cup.runtime.Symbol(21/*LowerEnd*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 101: // LowerEnd ::= SignedNumber 
            {
              Number RESULT = null;
		int nleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int nright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Number n = (Number)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = n; 
              CUP$Parser$result = new java_cup.runtime.Symbol(21/*LowerEnd*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 100: // NumConstraint ::= LowerEnd RANGESEP UpperEnd 
            {
              Constraint RESULT = null;
		int loleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left;
		int loright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).right;
		Number lo = (Number)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-2)).value;
		int hileft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int hiright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Number hi = (Number)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = new RangeConstraint (lx (loleft, hiright), lo, hi); 
              CUP$Parser$result = new java_cup.runtime.Symbol(20/*NumConstraint*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 99: // NumConstraint ::= Number _aux_12 
            {
              Constraint RESULT = null;
		int nleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left;
		int nright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).right;
		Number n = (Number)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-1)).value;
		int tleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int tright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		java.util.List <Object> t = (java.util.List <Object>)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 
            t.add (0, n); 
            RESULT = 
                new ValueListConstraint (
                    lx (nleft, tright),
                    t.toArray (new Number [t.size ()])
                ); 
        
              CUP$Parser$result = new java_cup.runtime.Symbol(20/*NumConstraint*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 98: // _aux_12 ::= 
            {
              java.util.List <Object> RESULT = null;
		RESULT=new java.util.ArrayList <Object> ();
              CUP$Parser$result = new java_cup.runtime.Symbol(62/*_aux_12*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 97: // _aux_12 ::= _aux_12 NT$4 PIPE Number 
            {
              java.util.List <Object> RESULT = null;
              // propagate RESULT from NT$4
              if ( ((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-2)).value != null )
                RESULT = (java.util.List <Object>) ((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-2)).value;
		int _list_left = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).left;
		int _list_right = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).right;
		java.util.List <Object> _list_ = (java.util.List <Object>)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-3)).value;
		int nleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int nright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Number n = (Number)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 _list_.add (n); 
              CUP$Parser$result = new java_cup.runtime.Symbol(62/*_aux_12*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 96: // NT$4 ::= 
            {
              Object RESULT = null;
		int _list_left = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int _list_right = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		java.util.List <Object> _list_ = (java.util.List <Object>)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
RESULT = _list_;
              CUP$Parser$result = new java_cup.runtime.Symbol(63/*NT$4*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 95: // Constraint ::= NumConstraint 
            {
              Constraint RESULT = null;
		int cleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int cright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Constraint c = (Constraint)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = c; 
              CUP$Parser$result = new java_cup.runtime.Symbol(19/*Constraint*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 94: // Constraint ::= SIZE LP NumConstraint RP 
            {
              Constraint RESULT = null;
		int aleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).left;
		int aright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).right;
		Object a = (Object)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-3)).value;
		int cleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left;
		int cright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).right;
		Constraint c = (Constraint)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-1)).value;
		int bleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int bright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Object b = (Object)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = new SizeConstraint (lx (aleft, bright), c); 
              CUP$Parser$result = new java_cup.runtime.Symbol(19/*Constraint*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 93: // TagClass ::= 
            {
              Element RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(34/*TagClass*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 92: // TagClass ::= PRIVATE 
            {
              Element RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(34/*TagClass*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 91: // TagClass ::= APPLICATION 
            {
              Element RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(34/*TagClass*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 90: // TagClass ::= UNIVERSAL 
            {
              Element RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(34/*TagClass*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 89: // Tag ::= LBKT TagClass Number RBKT 
            {
              Element RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(33/*Tag*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 88: // TaggedType ::= Tag EXPLICIT Type 
            {
              Type RESULT = null;
		int tleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int tright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Type t = (Type)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = t; 
              CUP$Parser$result = new java_cup.runtime.Symbol(32/*TaggedType*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 87: // TaggedType ::= Tag IMPLICIT Type 
            {
              Type RESULT = null;
		int tleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int tright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Type t = (Type)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = t; 
              CUP$Parser$result = new java_cup.runtime.Symbol(32/*TaggedType*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 86: // TaggedType ::= Tag Type 
            {
              Type RESULT = null;
		int tleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int tright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Type t = (Type)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = t; 
              CUP$Parser$result = new java_cup.runtime.Symbol(32/*TaggedType*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 85: // TextualConvention ::= TEXTUAL_CONVENTION _aux_10 STATUS ValueId DESCRIPTION CharString _aux_11 SYNTAX Syntax 
            {
              TextualConvention RESULT = null;
		int tleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-8)).left;
		int tright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-8)).right;
		String t = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-8)).value;
		int hintleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-7)).left;
		int hintright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-7)).right;
		Object hint = (Object)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-7)).value;
		int statusleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-5)).left;
		int statusright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-5)).right;
		String status = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-5)).value;
		int descleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).left;
		int descright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).right;
		String desc = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-3)).value;
		int refleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left;
		int refright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).right;
		Object ref = (Object)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-2)).value;
		int syntaxleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int syntaxright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Type syntax = (Type)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		
            RESULT = 
                new TextualConvention (
                    lx (tleft, syntaxright),
                    (String) hint, status, desc, (String) ref, syntax
                );
        
              CUP$Parser$result = new java_cup.runtime.Symbol(29/*TextualConvention*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-8)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 84: // _aux_11 ::= 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(61/*_aux_11*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 83: // _aux_11 ::= REFERENCE CharString 
            {
              Object RESULT = null;
		int rleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int rright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		String r = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = r; 
              CUP$Parser$result = new java_cup.runtime.Symbol(61/*_aux_11*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 82: // _aux_10 ::= 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(60/*_aux_10*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 81: // _aux_10 ::= DISPLAY_HINT CharString 
            {
              Object RESULT = null;
		int hleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int hright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		String h = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = h; 
              CUP$Parser$result = new java_cup.runtime.Symbol(60/*_aux_10*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 80: // Type ::= CHOICE LCB SequenceElementList RCB 
            {
              Type RESULT = null;
		int aleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).left;
		int aright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).right;
		Object a = (Object)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-3)).value;
		int listleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left;
		int listright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).right;
		ArrayList<Field> list = (ArrayList<Field>)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-1)).value;
		int bleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int bright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Object b = (Object)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		
            RESULT =
                new ChoiceType (
                    lx (aleft, bright),
                    list.toArray (new Field [list.size ()])
                );
        
              CUP$Parser$result = new java_cup.runtime.Symbol(18/*Type*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 79: // Type ::= SEQUENCE LCB SequenceElementList RCB 
            {
              Type RESULT = null;
		int aleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).left;
		int aright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).right;
		Object a = (Object)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-3)).value;
		int listleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left;
		int listright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).right;
		ArrayList<Field> list = (ArrayList<Field>)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-1)).value;
		int bleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int bright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Object b = (Object)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		
            RESULT =
                new StructureType (
                    lx (aleft, bright),
                    list.toArray (new Field [list.size ()])
                );
        
              CUP$Parser$result = new java_cup.runtime.Symbol(18/*Type*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 78: // Type ::= TextualConvention 
            {
              Type RESULT = null;
		int tcleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int tcright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		TextualConvention tc = (TextualConvention)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = tc; 
              CUP$Parser$result = new java_cup.runtime.Symbol(18/*Type*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 77: // Type ::= Type LP Constraint RP 
            {
              Type RESULT = null;
		int tleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).left;
		int tright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).right;
		Type t = (Type)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-3)).value;
		int consleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left;
		int consright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).right;
		Constraint cons = (Constraint)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-1)).value;
		int eleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int eright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Object e = (Object)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 
            RESULT = new ConstrainedType (lx (tleft, eright), t, cons ); 
        
              CUP$Parser$result = new java_cup.runtime.Symbol(18/*Type*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 76: // Type ::= TypeId 
            {
              Type RESULT = null;
		int tleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int tright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		String t = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = new NamedType (lx (tleft, tright), t); 
              CUP$Parser$result = new java_cup.runtime.Symbol(18/*Type*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 75: // Type ::= OBJECT IDENTIFIER 
            {
              Type RESULT = null;
		int aleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left;
		int aright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).right;
		Object a = (Object)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-1)).value;
		int bleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int bright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Object b = (Object)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = new NamedType (lx (aleft, bright), "OBJECT IDENTIFIER"); 
              CUP$Parser$result = new java_cup.runtime.Symbol(18/*Type*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 74: // Type ::= OCTET STRING 
            {
              Type RESULT = null;
		int aleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left;
		int aright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).right;
		Object a = (Object)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-1)).value;
		int bleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int bright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Object b = (Object)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = new NamedType (lx (aleft, bright), "OCTET STRING"); 
              CUP$Parser$result = new java_cup.runtime.Symbol(18/*Type*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 73: // Type ::= TaggedType 
            {
              Type RESULT = null;
		int tleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int tright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Type t = (Type)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = t; 
              CUP$Parser$result = new java_cup.runtime.Symbol(18/*Type*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 72: // Type ::= INTEGER LCB NamedNumberList RCB 
            {
              Type RESULT = null;
		int aleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).left;
		int aright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).right;
		Object a = (Object)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-3)).value;
		int listleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left;
		int listright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).right;
		ArrayList<NameNumberPair> list = (ArrayList<NameNumberPair>)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-1)).value;
		int bleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int bright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Object b = (Object)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		
            RESULT = 
                new EnumeratedType (
                    lx (aleft, bright),
                    list.toArray (new NameNumberPair [list.size ()])
                );
        
              CUP$Parser$result = new java_cup.runtime.Symbol(18/*Type*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 71: // Type ::= INTEGER 
            {
              Type RESULT = null;
		int tleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int tright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Object t = (Object)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = new NamedType (lx (tleft, tright), "INTEGER"); 
              CUP$Parser$result = new java_cup.runtime.Symbol(18/*Type*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 70: // TypeAssignment ::= TypeId ASSIGN Type 
            {
              TypeAssignment RESULT = null;
		int idleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left;
		int idright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).right;
		String id = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-2)).value;
		int tleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int tright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Type t = (Type)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = new TypeAssignment (lx (idleft, tright), id, t); 
              CUP$Parser$result = new java_cup.runtime.Symbol(17/*TypeAssignment*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 69: // NamedBit ::= ValueId LCB Number RCB 
            {
              NameNumberPair RESULT = null;
		int nameleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).left;
		int nameright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).right;
		String name = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-3)).value;
		int numleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left;
		int numright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).right;
		Number num = (Number)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-1)).value;
		int eleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int eright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Object e = (Object)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = new NameNumberPair (lx (nameleft, eleft), name, num); 
              CUP$Parser$result = new java_cup.runtime.Symbol(16/*NamedBit*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 68: // NamedBits ::= NamedBits COMMA NamedBit 
            {
              ArrayList<NameNumberPair> RESULT = null;
		int aleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left;
		int aright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).right;
		ArrayList<NameNumberPair> a = (ArrayList<NameNumberPair>)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-2)).value;
		int bleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int bright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		NameNumberPair b = (NameNumberPair)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 a.add (b); RESULT = a; 
              CUP$Parser$result = new java_cup.runtime.Symbol(15/*NamedBits*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 67: // NamedBits ::= NamedBit 
            {
              ArrayList<NameNumberPair> RESULT = null;
		int bleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int bright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		NameNumberPair b = (NameNumberPair)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = new ArrayList (); RESULT.add (b); 
              CUP$Parser$result = new java_cup.runtime.Symbol(15/*NamedBits*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 66: // Syntax ::= BITS LCB NamedBits RCB 
            {
              Type RESULT = null;
		int aleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).left;
		int aright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).right;
		Object a = (Object)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-3)).value;
		int bitsleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left;
		int bitsright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).right;
		ArrayList<NameNumberPair> bits = (ArrayList<NameNumberPair>)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-1)).value;
		int bleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int bright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Object b = (Object)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 
            RESULT = 
                new BitsType (
                    lx (aleft, bright), 
                    bits.toArray (new NameNumberPair [bits.size ()])
                ); 
        
              CUP$Parser$result = new java_cup.runtime.Symbol(14/*Syntax*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 65: // Syntax ::= SEQUENCE OF TypeId 
            {
              Type RESULT = null;
		int sleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left;
		int sright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).right;
		Object s = (Object)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-2)).value;
		int idleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int idright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		String id = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = new SequenceOfType (lx (sleft, idright), id); 
              CUP$Parser$result = new java_cup.runtime.Symbol(14/*Syntax*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 64: // Syntax ::= Type 
            {
              Type RESULT = null;
		int tleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int tright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Type t = (Type)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = t; 
              CUP$Parser$result = new java_cup.runtime.Symbol(14/*Syntax*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 63: // IndexTypes ::= ValueId COMMA IndexTypes 
            {
              IndexColumns RESULT = null;
		int idleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left;
		int idright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).right;
		String id = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-2)).value;
		int itleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int itright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		IndexColumns it = (IndexColumns)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 it.names.add (0, id); RESULT = it; 
              CUP$Parser$result = new java_cup.runtime.Symbol(13/*IndexTypes*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 62: // IndexTypes ::= IMPLIED ValueId 
            {
              IndexColumns RESULT = null;
		int idleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int idright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		String id = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = new IndexColumns (id, true); 
              CUP$Parser$result = new java_cup.runtime.Symbol(13/*IndexTypes*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 61: // IndexTypes ::= ValueId 
            {
              IndexColumns RESULT = null;
		int idleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int idright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		String id = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = new IndexColumns (id, false); 
              CUP$Parser$result = new java_cup.runtime.Symbol(13/*IndexTypes*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 60: // IndexPart ::= AUGMENTS LCB ValueId RCB 
            {
              IndexInfo RESULT = null;
		int aleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).left;
		int aright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).right;
		Object a = (Object)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-3)).value;
		int idleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left;
		int idright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).right;
		String id = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-1)).value;
		int bleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int bright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Object b = (Object)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = new AugmentedIndexInfo (lx (aleft, bright), id); 
              CUP$Parser$result = new java_cup.runtime.Symbol(12/*IndexPart*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 59: // IndexPart ::= INDEX LCB IndexTypes RCB 
            {
              IndexInfo RESULT = null;
		int aleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).left;
		int aright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).right;
		Object a = (Object)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-3)).value;
		int itleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left;
		int itright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).right;
		IndexColumns it = (IndexColumns)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-1)).value;
		int bleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int bright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Object b = (Object)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 
            RESULT = 
                new PrimaryIndexInfo (
                    lx (aleft, bright), 
                    it.getColumns (),
                    it.lastIsImplied
                );
        
              CUP$Parser$result = new java_cup.runtime.Symbol(12/*IndexPart*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 58: // ObjectTypeDefinition ::= ValueId OBJECT_TYPE SYNTAX Syntax _aux_7 MAX_ACCESS ValueId STATUS ValueId DESCRIPTION CharString _aux_8 _aux_9 ASSIGN ObjectIdentifierValue 
            {
              ObjectTypeDefinition RESULT = null;
		int idleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-14)).left;
		int idright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-14)).right;
		String id = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-14)).value;
		int synleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-11)).left;
		int synright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-11)).right;
		Type syn = (Type)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-11)).value;
		int uleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-10)).left;
		int uright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-10)).right;
		Object u = (Object)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-10)).value;
		int maxleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-8)).left;
		int maxright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-8)).right;
		String max = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-8)).value;
		int statusleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-6)).left;
		int statusright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-6)).right;
		String status = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-6)).value;
		int descleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-4)).left;
		int descright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-4)).right;
		String desc = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-4)).value;
		int refleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).left;
		int refright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).right;
		Object ref = (Object)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-3)).value;
		int ipleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left;
		int ipright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).right;
		Object ip = (Object)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-2)).value;
		int oidleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int oidright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		OIDValue oid = (OIDValue)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		   
            RESULT = 
                new ObjectTypeDefinition (
                    lx (idleft, oidright),
                    id, syn, (String) u, max, status, 
                    desc, (String) ref, (IndexInfo) ip, oid
                );
        
              CUP$Parser$result = new java_cup.runtime.Symbol(11/*ObjectTypeDefinition*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-14)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 57: // _aux_9 ::= 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(59/*_aux_9*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 56: // _aux_9 ::= IndexPart 
            {
              Object RESULT = null;
		int ipleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int ipright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		IndexInfo ip = (IndexInfo)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = ip; 
              CUP$Parser$result = new java_cup.runtime.Symbol(59/*_aux_9*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 55: // _aux_8 ::= 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(58/*_aux_8*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 54: // _aux_8 ::= REFERENCE CharString 
            {
              Object RESULT = null;
		int refleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int refright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		String ref = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = ref; 
              CUP$Parser$result = new java_cup.runtime.Symbol(58/*_aux_8*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 53: // _aux_7 ::= 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(57/*_aux_7*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 52: // _aux_7 ::= UNITS CharString 
            {
              Object RESULT = null;
		int uleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int uright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		String u = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = u; 
              CUP$Parser$result = new java_cup.runtime.Symbol(57/*_aux_7*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 51: // ObjIdComponents ::= ValueId LP Number RP 
            {
              NameNumberPair RESULT = null;
		int idleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).left;
		int idright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).right;
		String id = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-3)).value;
		int nleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left;
		int nright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).right;
		Number n = (Number)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-1)).value;
		int pleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int pright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Object p = (Object)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = new NameNumberPair (lx (idleft, pright), id, null); 
              CUP$Parser$result = new java_cup.runtime.Symbol(27/*ObjIdComponents*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 50: // ObjIdComponents ::= Number 
            {
              NameNumberPair RESULT = null;
		int nleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int nright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Number n = (Number)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = new NameNumberPair (lx (nleft, nright), null, n); 
              CUP$Parser$result = new java_cup.runtime.Symbol(27/*ObjIdComponents*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 49: // ObjIdComponents ::= ValueId 
            {
              NameNumberPair RESULT = null;
		int idleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int idright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		String id = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = new NameNumberPair (lx (idleft, idright), id, null); 
              CUP$Parser$result = new java_cup.runtime.Symbol(27/*ObjIdComponents*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 48: // ObjectIdentifierValue ::= LCB _aux_6 RCB 
            {
              OIDValue RESULT = null;
		int aleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left;
		int aright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).right;
		Object a = (Object)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-2)).value;
		int ccleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left;
		int ccright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).right;
		java.util.List <Object> cc = (java.util.List <Object>)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-1)).value;
		int bleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int bright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Object b = (Object)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 
            RESULT = 
                new OIDValue (
                    lx (aleft, bright), 
                    cc.toArray (new NameNumberPair [cc.size ()])
                ); 
        
              CUP$Parser$result = new java_cup.runtime.Symbol(28/*ObjectIdentifierValue*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 47: // _aux_6 ::= 
            {
              java.util.List <Object> RESULT = null;
		RESULT=new java.util.ArrayList <Object> ();
              CUP$Parser$result = new java_cup.runtime.Symbol(55/*_aux_6*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 46: // _aux_6 ::= _aux_6 NT$3 ObjIdComponents 
            {
              java.util.List <Object> RESULT = null;
              // propagate RESULT from NT$3
              if ( ((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-1)).value != null )
                RESULT = (java.util.List <Object>) ((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-1)).value;
		int _list_left = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left;
		int _list_right = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).right;
		java.util.List <Object> _list_ = (java.util.List <Object>)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-2)).value;
		int cleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int cright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		NameNumberPair c = (NameNumberPair)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 _list_.add (c); 
              CUP$Parser$result = new java_cup.runtime.Symbol(55/*_aux_6*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 45: // NT$3 ::= 
            {
              Object RESULT = null;
		int _list_left = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int _list_right = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		java.util.List <Object> _list_ = (java.util.List <Object>)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
RESULT = _list_;
              CUP$Parser$result = new java_cup.runtime.Symbol(56/*NT$3*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 44: // ObjectIdDefinition ::= ValueId OBJECT_IDENTITY STATUS ValueId DESCRIPTION CharString _aux_5 ASSIGN ObjectIdentifierValue 
            {
              ObjectIdDefinition RESULT = null;
		int idleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-8)).left;
		int idright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-8)).right;
		String id = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-8)).value;
		int statusleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-5)).left;
		int statusright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-5)).right;
		String status = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-5)).value;
		int descleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).left;
		int descright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).right;
		String desc = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-3)).value;
		int refleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left;
		int refright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).right;
		Object ref = (Object)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-2)).value;
		int oidleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int oidright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		OIDValue oid = (OIDValue)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 
            RESULT = 
                new ObjectIdDefinition (
                    lx (idleft, oidright), 
                    id, status, desc, (String) ref, oid
                ); 
        
              CUP$Parser$result = new java_cup.runtime.Symbol(10/*ObjectIdDefinition*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-8)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 43: // _aux_5 ::= 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(54/*_aux_5*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 42: // _aux_5 ::= REFERENCE CharString 
            {
              Object RESULT = null;
		int refleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int refright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		String ref = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = ref; 
              CUP$Parser$result = new java_cup.runtime.Symbol(54/*_aux_5*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 41: // ObjectIdDefinition ::= ValueId OBJECT IDENTIFIER ASSIGN ObjectIdentifierValue 
            {
              ObjectIdDefinition RESULT = null;
		int idleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-4)).left;
		int idright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-4)).right;
		String id = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-4)).value;
		int oidleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int oidright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		OIDValue oid = (OIDValue)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 
            RESULT = 
                new ObjectIdDefinition (
                    lx (idleft, oidright), 
                    id, null, null, null, oid
                ); 
        
              CUP$Parser$result = new java_cup.runtime.Symbol(10/*ObjectIdDefinition*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-4)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 40: // Revision ::= REVISION CharString DESCRIPTION CharString 
            {
              Revision RESULT = null;
		int rleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).left;
		int rright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).right;
		Object r = (Object)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-3)).value;
		int dateleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left;
		int dateright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).right;
		String date = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-2)).value;
		int descleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int descright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		String desc = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = new Revision (lx (rleft, descright), date, desc); 
              CUP$Parser$result = new java_cup.runtime.Symbol(8/*Revision*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 39: // ModuleIdentityDefinition ::= ValueId MODULE_IDENTITY LAST_UPDATED CharString ORGANIZATION CharString CONTACT_INFO CharString DESCRIPTION CharString _aux_4 ASSIGN ObjectIdentifierValue 
            {
              ModuleIdentityDefinition RESULT = null;
		int idleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-12)).left;
		int idright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-12)).right;
		String id = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-12)).value;
		int luleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-9)).left;
		int luright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-9)).right;
		String lu = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-9)).value;
		int orgleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-7)).left;
		int orgright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-7)).right;
		String org = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-7)).value;
		int cinfoleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-5)).left;
		int cinforight = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-5)).right;
		String cinfo = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-5)).value;
		int descleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).left;
		int descright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-3)).right;
		String desc = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-3)).value;
		int revsleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left;
		int revsright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).right;
		java.util.List <Object> revs = (java.util.List <Object>)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-2)).value;
		int oidleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int oidright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		OIDValue oid = (OIDValue)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		
            RESULT = 
                new ModuleIdentityDefinition (
                    lx (idleft, oidright),
                    id, lu, org, cinfo, desc, 
                    revs.toArray (new Revision [revs.size ()]), 
                    oid
                );
        
              CUP$Parser$result = new java_cup.runtime.Symbol(7/*ModuleIdentityDefinition*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-12)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 38: // _aux_4 ::= 
            {
              java.util.List <Object> RESULT = null;
		RESULT=new java.util.ArrayList <Object> ();
              CUP$Parser$result = new java_cup.runtime.Symbol(52/*_aux_4*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 37: // _aux_4 ::= _aux_4 NT$2 Revision 
            {
              java.util.List <Object> RESULT = null;
              // propagate RESULT from NT$2
              if ( ((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-1)).value != null )
                RESULT = (java.util.List <Object>) ((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-1)).value;
		int _list_left = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left;
		int _list_right = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).right;
		java.util.List <Object> _list_ = (java.util.List <Object>)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-2)).value;
		int rleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int rright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Revision r = (Revision)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 _list_.add (r); 
              CUP$Parser$result = new java_cup.runtime.Symbol(52/*_aux_4*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 36: // NT$2 ::= 
            {
              Object RESULT = null;
		int _list_left = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int _list_right = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		java.util.List <Object> _list_ = (java.util.List <Object>)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
RESULT = _list_;
              CUP$Parser$result = new java_cup.runtime.Symbol(53/*NT$2*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 35: // Definition ::= MacroDefinition 
            {
              Definition RESULT = null;
		int vleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int vright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		MacroDefinition v = (MacroDefinition)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = v; 
              CUP$Parser$result = new java_cup.runtime.Symbol(9/*Definition*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 34: // Definition ::= AgentCapabilitiesDefinition 
            {
              Definition RESULT = null;
		int vleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int vright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Definition v = (Definition)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = v; 
              CUP$Parser$result = new java_cup.runtime.Symbol(9/*Definition*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 33: // Definition ::= ModuleComplianceDefinition 
            {
              Definition RESULT = null;
		int vleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int vright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Definition v = (Definition)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = v; 
              CUP$Parser$result = new java_cup.runtime.Symbol(9/*Definition*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 32: // Definition ::= NotificationGroupDefinition 
            {
              Definition RESULT = null;
		int vleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int vright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Definition v = (Definition)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = v; 
              CUP$Parser$result = new java_cup.runtime.Symbol(9/*Definition*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 31: // Definition ::= NotificationTypeDefinition 
            {
              Definition RESULT = null;
		int vleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int vright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Definition v = (Definition)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = v; 
              CUP$Parser$result = new java_cup.runtime.Symbol(9/*Definition*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 30: // Definition ::= ObjectGroupDefinition 
            {
              Definition RESULT = null;
		int vleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int vright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Definition v = (Definition)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = v; 
              CUP$Parser$result = new java_cup.runtime.Symbol(9/*Definition*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 29: // Definition ::= TypeAssignment 
            {
              Definition RESULT = null;
		int vleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int vright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		TypeAssignment v = (TypeAssignment)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = v; 
              CUP$Parser$result = new java_cup.runtime.Symbol(9/*Definition*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 28: // Definition ::= ObjectIdDefinition 
            {
              Definition RESULT = null;
		int vleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int vright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		ObjectIdDefinition v = (ObjectIdDefinition)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = v; 
              CUP$Parser$result = new java_cup.runtime.Symbol(9/*Definition*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 27: // Definition ::= ObjectTypeDefinition 
            {
              Definition RESULT = null;
		int vleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int vright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		ObjectTypeDefinition v = (ObjectTypeDefinition)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = v; 
              CUP$Parser$result = new java_cup.runtime.Symbol(9/*Definition*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 26: // Definition ::= ModuleIdentityDefinition 
            {
              Definition RESULT = null;
		int vleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int vright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		ModuleIdentityDefinition v = (ModuleIdentityDefinition)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = v; 
              CUP$Parser$result = new java_cup.runtime.Symbol(9/*Definition*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 25: // MacroName ::= TEXTUAL_CONVENTION 
            {
              String RESULT = null;
		int vleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int vright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		String v = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = v; 
              CUP$Parser$result = new java_cup.runtime.Symbol(1/*MacroName*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 24: // MacroName ::= AGENT_CAPABILITIES 
            {
              String RESULT = null;
		int vleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int vright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		String v = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = v; 
              CUP$Parser$result = new java_cup.runtime.Symbol(1/*MacroName*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 23: // MacroName ::= MODULE_COMPLIANCE 
            {
              String RESULT = null;
		int vleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int vright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		String v = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = v; 
              CUP$Parser$result = new java_cup.runtime.Symbol(1/*MacroName*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 22: // MacroName ::= NOTIFICATION_GROUP 
            {
              String RESULT = null;
		int vleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int vright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		String v = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = v; 
              CUP$Parser$result = new java_cup.runtime.Symbol(1/*MacroName*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 21: // MacroName ::= OBJECT_IDENTITY 
            {
              String RESULT = null;
		int vleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int vright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		String v = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = v; 
              CUP$Parser$result = new java_cup.runtime.Symbol(1/*MacroName*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 20: // MacroName ::= OBJECT_GROUP 
            {
              String RESULT = null;
		int vleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int vright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		String v = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = v; 
              CUP$Parser$result = new java_cup.runtime.Symbol(1/*MacroName*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 19: // MacroName ::= NOTIFICATION_TYPE 
            {
              String RESULT = null;
		int vleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int vright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		String v = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = v; 
              CUP$Parser$result = new java_cup.runtime.Symbol(1/*MacroName*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 18: // MacroName ::= MODULE_IDENTITY 
            {
              String RESULT = null;
		int vleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int vright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		String v = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = v; 
              CUP$Parser$result = new java_cup.runtime.Symbol(1/*MacroName*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 17: // MacroName ::= OBJECT_TYPE 
            {
              String RESULT = null;
		int vleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int vright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		String v = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = v; 
              CUP$Parser$result = new java_cup.runtime.Symbol(1/*MacroName*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 16: // Symbol ::= MacroName 
            {
              String RESULT = null;
		int vleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int vright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		String v = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = v; 
              CUP$Parser$result = new java_cup.runtime.Symbol(6/*Symbol*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 15: // Symbol ::= TypeId 
            {
              String RESULT = null;
		int vleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int vright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		String v = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = v; 
              CUP$Parser$result = new java_cup.runtime.Symbol(6/*Symbol*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 14: // Symbol ::= ValueId 
            {
              String RESULT = null;
		int vleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int vright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		String v = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = v; 
              CUP$Parser$result = new java_cup.runtime.Symbol(6/*Symbol*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 13: // SymbolList ::= SymbolList COMMA Symbol 
            {
              ArrayList<String> RESULT = null;
		int slleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left;
		int slright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).right;
		ArrayList<String> sl = (ArrayList<String>)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-2)).value;
		int symleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int symright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		String sym = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 sl.add (sym); RESULT = sl; 
              CUP$Parser$result = new java_cup.runtime.Symbol(5/*SymbolList*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 12: // SymbolList ::= Symbol 
            {
              ArrayList<String> RESULT = null;
		int sleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int sright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		String s = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = new ArrayList (); RESULT.add (s); 
              CUP$Parser$result = new java_cup.runtime.Symbol(5/*SymbolList*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 11: // SymbolsFromModule ::= SymbolList FROM TypeId 
            {
              Import RESULT = null;
		int slleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left;
		int slright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).right;
		ArrayList<String> sl = (ArrayList<String>)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-2)).value;
		int tidleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int tidright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		String tid = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = new Import (lx (slleft, tidright), tid, sl); 
              CUP$Parser$result = new java_cup.runtime.Symbol(4/*SymbolsFromModule*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 10: // Imports ::= IMPORTS _aux_3 SEMIC 
            {
              Import[] RESULT = null;
		int sleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left;
		int sright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).right;
		java.util.List <Object> s = (java.util.List <Object>)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-1)).value;
		 RESULT = s.toArray (new Import [s.size ()]); 
              CUP$Parser$result = new java_cup.runtime.Symbol(3/*Imports*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 9: // _aux_3 ::= 
            {
              java.util.List <Object> RESULT = null;
		RESULT=new java.util.ArrayList <Object> ();
              CUP$Parser$result = new java_cup.runtime.Symbol(50/*_aux_3*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 8: // _aux_3 ::= _aux_3 NT$1 SymbolsFromModule 
            {
              java.util.List <Object> RESULT = null;
              // propagate RESULT from NT$1
              if ( ((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-1)).value != null )
                RESULT = (java.util.List <Object>) ((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-1)).value;
		int _list_left = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left;
		int _list_right = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).right;
		java.util.List <Object> _list_ = (java.util.List <Object>)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-2)).value;
		int sleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int sright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Import s = (Import)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 _list_.add (s); 
              CUP$Parser$result = new java_cup.runtime.Symbol(50/*_aux_3*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 7: // NT$1 ::= 
            {
              Object RESULT = null;
		int _list_left = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int _list_right = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		java.util.List <Object> _list_ = (java.util.List <Object>)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
RESULT = _list_;
              CUP$Parser$result = new java_cup.runtime.Symbol(51/*NT$1*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 6: // $START ::= ASNModule EOF 
            {
              Object RESULT = null;
		int start_valleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left;
		int start_valright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).right;
		Module start_val = (Module)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-1)).value;
		RESULT = start_val;
              CUP$Parser$result = new java_cup.runtime.Symbol(0/*$START*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          /* ACCEPT */
          CUP$Parser$parser.done_parsing();
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 5: // ASNModule ::= TypeId DEFINITIONS ASSIGN BEGIN _aux_1 _aux_2 END 
            {
              Module RESULT = null;
		int tidleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-6)).left;
		int tidright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-6)).right;
		String tid = (String)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-6)).value;
		int impsleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left;
		int impsright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).right;
		Object imps = (Object)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-2)).value;
		int defsleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).left;
		int defsright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-1)).right;
		java.util.List <Object> defs = (java.util.List <Object>)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-1)).value;
		int eleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int eright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Object e = (Object)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		
            RESULT = 
                new Module (
                    lx (tidleft, eright), tid, (Import []) imps, 
                    defs.toArray (new Definition [defs.size ()])
                );
        
              CUP$Parser$result = new java_cup.runtime.Symbol(2/*ASNModule*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-6)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 4: // _aux_2 ::= 
            {
              java.util.List <Object> RESULT = null;
		RESULT=new java.util.ArrayList <Object> ();
              CUP$Parser$result = new java_cup.runtime.Symbol(48/*_aux_2*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 3: // _aux_2 ::= _aux_2 NT$0 Definition 
            {
              java.util.List <Object> RESULT = null;
              // propagate RESULT from NT$0
              if ( ((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-1)).value != null )
                RESULT = (java.util.List <Object>) ((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-1)).value;
		int _list_left = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left;
		int _list_right = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).right;
		java.util.List <Object> _list_ = (java.util.List <Object>)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-2)).value;
		int dleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int dright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Definition d = (Definition)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 if (d != null) _list_.add (d); 
              CUP$Parser$result = new java_cup.runtime.Symbol(48/*_aux_2*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-2)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 2: // NT$0 ::= 
            {
              Object RESULT = null;
		int _list_left = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int _list_right = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		java.util.List <Object> _list_ = (java.util.List <Object>)((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
RESULT = _list_;
              CUP$Parser$result = new java_cup.runtime.Symbol(49/*NT$0*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 1: // _aux_1 ::= 
            {
              Object RESULT = null;

              CUP$Parser$result = new java_cup.runtime.Symbol(47/*_aux_1*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /*. . . . . . . . . . . . . . . . . . . .*/
          case 0: // _aux_1 ::= Imports 
            {
              Object RESULT = null;
		int impsleft = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left;
		int impsright = ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right;
		Import[] imps = (Import[])((java_cup.runtime.Symbol) CUP$Parser$stack.elementAt(CUP$Parser$top-0)).value;
		 RESULT = imps; 
              CUP$Parser$result = new java_cup.runtime.Symbol(47/*_aux_1*/, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).left, ((java_cup.runtime.Symbol)CUP$Parser$stack.elementAt(CUP$Parser$top-0)).right, RESULT);
            }
          return CUP$Parser$result;

          /* . . . . . .*/
          default:
            throw new Exception(
               "Invalid action number found in internal parse table");

        }
    }
}