/*
 * Copyright 2024 EPAM Systems, Inc
 *
 * See the NOTICE file distributed with this work for additional information
 * regarding copyright ownership. Licensed under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.epam.deltix.qsrv.dtb.store.dataacc;

/**
 *  Thrown when a writer attempts to insert into a block, but there is no room.
 *  By the time this exception is thrown, the previous time slice has been 
 *  checked in (for the accessor), and a new time slice, contained in this
 *  exception, has been checked out to the accessor.
 */
public class SwitchTimeSliceException extends RuntimeException {
    public final TimeSlice          newTimeSlice;

    public SwitchTimeSliceException (TimeSlice newTimeSlice) {
        this.newTimeSlice = newTimeSlice;
    }
        
    @Override
    public Throwable                fillInStackTrace () {
        return (null);
    }
}