/*
 * Copyright 2024 EPAM Systems, Inc
 *
 * See the NOTICE file distributed with this work for additional information
 * regarding copyright ownership. Licensed under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.epam.deltix.computations.stateful;

import com.epam.deltix.computations.api.annotations.*;
import com.epam.deltix.computations.api.generated.LongStatefulFunctionBase;

@Function("SEQUENCE")
public class Sequence extends LongStatefulFunctionBase {

    private long start;
    private boolean reset = false;

    @Init
    public void init(@Arg(name = "start", defaultValue = "0") long start, @Arg(name = "reset", defaultValue = "false") boolean reset) {
        this.start = start;
        this.reset = reset;
        this.value = start - 1;
    }

    @Compute
    public void next() {
        value++;
    }

    @Reset
    @Override
    public void reset() {
        if (reset) {
            value = start - 1;
        }
    }
}