/*
 * Copyright 2024 EPAM Systems, Inc
 *
 * See the NOTICE file distributed with this work for additional information
 * regarding copyright ownership. Licensed under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.epam.deltix.qsrv.hf.tickdb.schema;

/**
 * Container class for Stream Schema Changes
 */
public interface SchemaChange {

    public Impact getChangeImpact();

    // do not change - order is important
    public enum Impact {

        /**
         * No changes impacting data
         */
        None,

        /**
         * Indicates that change can be applied to stream schema with data conversion.
         */
        DataConvert,
        /**
         * Indicates that change cannot be applied to stream schema.
         */
        DataLoss,
    }
}