/*
 * Copyright 2024 EPAM Systems, Inc
 *
 * See the NOTICE file distributed with this work for additional information
 * regarding copyright ownership. Licensed under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.epam.deltix.qsrv.hf.tickdb.pub.mon;

/**
 *
 */
public interface TBMonitor {
    public boolean                  getTrackMessages ();

    public void                     setTrackMessages (boolean value);

    public TBCursor []              getOpenCursors ();

    public TBLoader []              getOpenLoaders ();

    public TBLock[]                 getLocks();

    public TBObject                 getObjectById (long id);

    public void                     addObjectMonitor(TBObjectMonitor monitor);

    public void                     removeObjectMonitor(TBObjectMonitor monitor);

    public void                     addPropertyMonitor(String component, PropertyMonitor monitor);

    int                             cursorsCount();

    int                             loadersCount();
}