/*
Copyright 2020 The kconnect Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package rancher

type listClustersResponse struct {
	Clusters []clusterDetails `json:"data"`
}

type clusterDetails struct {
	ID           string                  `json:"id"`
	Name         string                  `json:"name"`
	Description  string                  `json:"description"`
	EngineConfig *kubernetesEngineConfig `json:"rancherKuernetesEngineConfig,omitempty"`
	Actions      map[string]string       `json:"actions"`
}

type kubernetesEngineConfig struct {
	Version string `json:"kubernetesVersion"`
}

type generateKubeConfigResponse struct {
	Config string `json:"config"`
}
