---
title: kconnect history
authors:
  - "@richardcase"
reviewers:
  - "@richardcase"
creation-date: 2020-08-27
last-updated: 2020-08-27
status: provisional
see-also:
    - "/docs/proposals/20200607-initial-design.md"
replaces:
superseded-by:
---

# kconnect - history

## Summary

This proposal includes a proposal for introducing **history** of connections into kconnect

## Motivation

To aid the utility of kconnect a history of connections will be kept. This history can then be used at a later date to generate the kubeconfig quicker and with less information. This is to make the tool more useful to its users.

### Goals

* Demonstrate how `kconnect ls` will be used
* Demonstrate how `kconnect to` will be used
* Demonstrate how `kconnect use` will be updated
* Aid refinement of the initial design

### Non-goals/Future Work

*

## Proposal/Design

A new `ls` command will be introduced which will show the history of the connections you have made to clusters. You can see further details of a selected history item (i.e. its flags). Then based on a history entry you can re-generate a kubeconfig using a new `to` command without having to re-enter all the flag values. The only values that aren't saved are values for flags that are deemed sensitive such as `--password` (these flags will need to be marked declarative way).

The following sections summarise the proposal for implementing the history in kconnect.

### History file

#### Location & format

Its proposed the history of connections be held in the following file: `$HOME/.kconnect/history`. The format of the file is undecided but a textual format such as YAML will likely be used initially. We will consider binary formats as well.

#### When will history be stored

Every time `kconnect use` is invoked and a kubeconfig file is created a history item will be created. If all the history entry values are the same as an existing entry (excluding date/time) then the existing entry will have its date/time updated.

#### Data stored

The data stored in the history file will be an entry for each successful `kconnect use` invocation. Each entry will store the following:

* Discovery provider used (i.e. eks)
* Identity provider used (i.e. saml)
* Date/time (ISO 8601 format) of when the entry was added or last updated
* Unique history entry id
* Unique discovery provider specific identifier for that cluster. For example, with the EKS provider we might store the AWs account ID and EKS cluster name. This identifier must be unique and stable.
* Alias - optional name that can be used
* Flags and flag values - except flags deemed sensitive
* Location of the kubeconfig file that was written to

As an example (if we where using YAML as the format):

```yaml
-
id: 1234567890 # this is the id of the history item
provider: eks
identity: saml
providerId: MTIzNDU2Nzg5L215Y2x1c3RlcjE  # base 64 url safe encoding of 123456789/mycluster1
datetime: 2020-08-27T16:06:08.180856
flags:
    username: bob@someone.com
    idp-provider: GoogleApps
    idp-endpoint: https://accounts.google.com/o/saml2/initsso?idpid=
    profile: g-saml
    role: arn:aws:iam::123456789:role/TestAccess
config: ~/.kube/config
alias: dev-eks-cluster
```

#### Data retention

The history file will not be written to without any form of record limit. Its proposed that we include a 'maximum history count' configuration option that defaults to a sensible number. We will allow this configuration option to be overwritten by a flag on the root command called `--max-history`.

When writing a history entry a check will be performed to see if the number of entries will exceed the `--max-history`. If it does then the oldest entries from the history file will be trimmed.

### User Experience

#### Showing the history

First showing help for the `ls` command

```bash
kconnect ls -h

shows the history of the connections you have made using kconnect

Usage:

kconnect ls [FLAGS] e.g ./kconnect ls --provider eks

flags:

-p  --provider         [optional]    used to filter history items based on a specific cluster provider (e.g. eks)
-i  --identity         [optional]    used to filter history items based on a specific identity provider (e.g. saml)
    --id               [optional]    used to filter history items for a cluster with the specified id
-a  --alias            [optional]    used to filter history items for a cluster with a specific alias. It supports wildcards.
-f  --flag             [optional]    used to filter history items based on a flag and its value
-k  --kubeconfig       [optional]    used to filter history items that where written to the specified kubeconfig
-o  --output           [optional]    used to specify the output format of the history. Defaults to yaml. Options are [yaml,json,table]

Example usage:

    kconnect ls --flag username=bob@somewhere.com

```

When using the command to filter connections made to EKS you might do the following:

```bash
kconnect ls --provider eks -o table

|ID | ProviderID                | Providers | Identity | Alias       | Config     | Flags                      |
|===|===========================|===========|==========|=============|============|============================|
| 1 |MTIzNDU2Nzg5L215Y2x1c3RlcjE| EKS       | SAML     | dev-eks     | (default)  | username=bob@somewhere.com |
|   |                           |           |          |             |            | idp-provider=GoogleApps    |
|---|---------------------------|-----------|----------|-------------|------------|----------------------------|

```

#### Using the history

Using a history item will require implementing a new `to` command. Its proposed that the `to` command work in the following way:

```bash
# One of the following 2 commands would be used
kconnect to --id 123456
kconnect to --alias dev-eks

Using history item 1 (eks/saml, MTIzNDU2Nzg5L215Y2x1c3RlcjE)

Enter your password: *******************

saving your settings to $HOME/.kconnect/config.yaml

you can run kubectl commands now!

```

We also want to support an interactive mode and its proposed that it will work like the following:

```bash
# If no --id or --alias is supplied then its assumed interactive
kconnect to

Do you want to filter your connection history? Yes
Do you want to filter by provider? Yes
Select provider: eks
Do you want to filter by a flag? No


History:
1 - eks/saml MTIzNDU2Nzg5L215Y2x1c3RlcjE (dev-eks) - username=bob@somewhere.com,idp-provider=GoogleApps...
2 - eks/saml MTIzNDU2Nzg5L215Y2x1c3RlcCV (uat-eks) - username=bob@somewhere.com,idp-provider=GoogleApps...

Select a history item to connect: 1

Using history item 1 (eks/saml, MTIzNDU2Nzg5L215Y2x1c3RlcjE)

Enter your password: *******************

saving your settings to $HOME/.kconnect/config.yaml

you can run kubectl commands now!
```

### Changes to `kconnect use`

To support the alias functionality we will need to make some changes to the `use` command to allow the user to optionally enter an alias.Its proposed that an additional flag be included `-a/--alias` that the user can specify when running the command. If the flag isn't specified and we are running in interactive mode then the user will be asked to enter an alias.

If an alias is specified via flag or user entry then the history will be checked to see if the alias has already been used. If it has already been used then an error will be returned to the user.

When using the `use` command a history item will be written prior to generating kubeconfig for a selected cluster. The `id` of this history entry will be embedded in the generated kubeconfig as an **Extension**. This will allow us to tie back a kubeconfig to the `use` command that generated it.

Additionally on successful generation of a kubeconfig a new history entry will be written. We will also write the history id

### Changes to providers

The existing providers will need to be changed so that they return a unique identifier for a cluster than is accessible via that provider. As an example a EKS cluster in AWS can be uniquely identified via its ARN or via a account number/cluster name combination. It would be up to the provider to return this provider unique identifier in the [Cluster.ID](https://github.com/fidelity/kconnect/blob/main/pkg/provider/types.go#L85) field.

### Maintaining aliases

A new command will be created called `alias` that has an number of subcommands to allow the user to maintain the aliases. For example:

```bash
# Add an alias to a history item based on history id
kconnect alias add --id 12345 --alias dev-eks

# Add an alias to a history item based on provider id in the history
kconnect alias add --provider-id MTIzNDU2Nzg5L215Y2x1c3RlcjE --alias dev-eks

# Delete an alias from a history item
kconnect alias rm --id MTIzNDU2Nzg5L215Y2x1c3RlcjE

# Delete all aliases
kconnect alias rm --all

# List all the aliases an their history ids
kconnect alias ls
```

### Additional Details

Once history has been implemented we will consider the following:

* Introducing a command that will **trim/truncate** the history file.
* Updating `ls` so that it adds an indicator to the history item if its the current kubeconfig context
* Updating `ls` so that it adds an indicator if the credentials for a item have expired
