---
title: kconnect CLI UX
authors:
  - "@rajarajanpsj"
  - "@richardcase"
reviewers:
  - "@richardcase"
creation-date: 2020-06-30
last-updated: 2020-7-01
status: provisional
see-also:
    - "/docs/proposals/20200607-initial-design.md"
replaces:
superseded-by:
---

# kconnect - CLI User Experience (UX)

## Summary

This proposal includes a walkthrough of the cli user experience.

## Motivation

We need to get the UX experience correct when using kconnect otherwise it will not be adopted.

### Goals

* Demonstrate how the tool may be used
* Aid refinement of the initial design

### Non-goals/Future Work

*

## Proposal/Design

### Configuration file

Contents of $HOME/.kconnect/config

```yaml
proxy:
  http_proxy:   http.proxy.company.com
  https_proxy:  http.proxy.company.com
  no_proxy:     *company.com

defaults:
  user: joe@blogs.com
  password: $PASSWORD     #password is always recommended to point to an ENV variable. $, %% are use to detect env variables
  platform: eks
  cluster: pe1
  kubeconfig: $HOME/.kube/config

platforms:
  # initially supported platforms will be eks | aks | rancher

  eks:
    # aws defaults used by kconnect
    aws:
      alias : pe-3-cluster
      region:  us-east-1
      cluster: eks-cluster-1
      account: 1234567890
      iam:
          role:    EKS_ADMIN
          # roleFilter is used while displaying list of IAM roles to select
          roleFilter: *EKS*
      awsProfile: kconnect
    idp:
      protocol:     saml
      provider:     ping
      endpoint:     https://my.idp.com/idp/startSSO.ping?PartnerSpId=urn:amazon:webservices
```

### `help` command

```bash
./kconnect -h [--help] or ./kconnect help

kconnect is a kubernetes connection manager CLI that helps sets up a connection to a k8s cluster using your identity provider credentials. Currently supports eks, aks and rancher more platforms.

You can find detailed documentation at https://fidelity.github.io/kconnect/

Usage:

kconnect COMMAND [FLAGS]

Available commands:

use             connects you to a specific platform. Supported platforms are eks, aks & rancher e.g. ./kconnect platform eks
ls              lists clusters that you can connect to, based on your connection history
configure       sets up your default configurations at $HOME/.kconnect/config.yaml
to              shortcut to connect to clusters using aliases e.g. kconnect to eks-cluster-1

Common flags:

-u --user             [required]    username used for logging into the identity provider
-p --password         [required]    password for the user
   --config           [optional]    use this for kconnect default configurations instead of the default $HOME/.kconnect/config.yaml
-k --kubeconfig       [optional]    write kubeconfig to this location. Defaults to $HOME/.kube/config
```

Supports autocomplete. Refer to autocomplete setups instructions at https://fidelity.github.io/kconnect/

### `use` Command

#### EKS Example

```bash
./kconnect use -h

sets up connection to clusters in specific platforms. Currently supported platforms are eks, rancher and aks

Usage:

kconnect use [eks | aks | rancher] [FLAGS] e.g ./kconnect use eks -u user@domain.com -p password

eks flags:

-c  --cluster          [optional]    if not provided, will try to discover all the clusters
-r  --region           [required]    aws region where to discover clusters
    --profile          [optional]    name used while writing to aws profile, defaults to kconnect
-n  --namespace        [optional]    when present, sets the kubeconfig namespace context
-r  --role             [required]    aws iam role that will be assumed by the user, which is used to authenticate with the cluster
    -x-role            [optional]    support form cross account
-a  --alias            [optional]    unique alias that will be used as a shortcut to connect to. e.g  kconnect to <ALIAS>
    --idp-protocol     [required]    valid values are saml | oidc
    --idp-provider     [required]    valid values are ping | okta | adfs
    --idp-endpoint     [required]    identity provider endpoint provided by your IT team.

Example usage:

    kconnect platform eks -u axyz123@company.com -p $PASSWORD --region us-east-1 --account 1234567890 --cluster eks-cluster1-east1 --role EKS_IAM_ROLE --alias env1

Second time you can connect to above cluster as "kconnect to env1" where env1 is coming from --alias.

Common flags:

-u --user             [required]    username used for logging into the identity provider. e.g domain\username
-p --password         [required]    password for the user
   --config  [optional]    use this for kconnect default configurations instead of the default $HOME/.kconnect/config
-k --kubeconfig   [optional]    write kubeconfig to this location. Defaults to $HOME/.kube/config
```

Supports autocomplete. Refer to autocomplete setups instructions at https://fidelity.github.io/kconnect/

#### AKS Example

```bash
./kconnect use -h

sets up connection to clusters in specific platforms. Currently supported platforms are eks, rancher and aks

Usage:

kconnect use [eks | aks | rancher] [FLAGS] e.g ./kconnect use eks -u user@domain.com -p password

eks flags:

-c  --cluster          [optional]    if not provided, will try to discover all the clusters
    --resource-group   [optional]    azure resource group to discover clusters in
    --subscription     [optional]    azure subscription to use to discover clusters in. This can be id or name. If not
                                     provided a list subscriptions will be presented to choose from
    --tenant           [optional]    azure tenant id to use.
-n  --namespace        [optional]    when present, sets the kubeconfig namespace context
-a  --alias            [optional]    unique alias that will be used as a shortcut to connect to. e.g  kconnect to <ALIAS>

Example usage:

    kconnect platform aks -u axyz123@company.com -p $PASSWORD --resource-group 12345 --subscription my-sub-1 --tenant 243546 --cluster aks-cluster1-east1 --alias env1

Second time you can connect to above cluster as "kconnect to env1" where env1 is coming from --alias.

Common flags:

-u --user             [required]    username used for logging into the identity provider. e.g domain\username
-p --password         [required]    password for the user
   --config           [optional]    use this for kconnect default configurations instead of the default $HOME/.kconnect/config
-k --kubeconfig       [optional]    write kubeconfig to this location. Defaults to $HOME/.kube/config
```

Supports autocomplete. Refer to autocomplete setups instructions at https://fidelity.github.io/kconnect/


### UX for first time user

#### EKS Example

```bash
./kconnect

config not found at $HOME/.kconnect/config

Looks like a first time user, lets set you up interactively

Alternatively if you have kconnect-config handy, you can run "kconnect configure -f /path/to/kconnect-config.yaml". More info at https://fidelity.github.io/kconnect/

Choose a platform
(1) eks
(2) aks
(3) rancher
1

setting up eks as the default platform at $HOME/kconnect/config.yaml

select your idp protocol
(1) saml
(2) oidc
1

select your idp provider
(1) ping
(2) okta
(3) adfs
1

provide your idp endpoint
[url]: https://idp.company.com/saml/endpoint

checking connectivity to https://idp.company.com/saml/endpoint, looks good.

do1 you want to configure proxy? [http_proxy, https_proxy, no_proxy]
[no]:

no proxy configured

user: axyz123@company.com
password: ********
#region defaults to us-east-1

region:
region set to us-east-1

fetching the iam roles via saml

---------------------------------------

platform-eng  7654321098

---------------------------------------

    [ 0 ]       EKS_Deployment

    [ 1 ]       EKS_Master

    [ 2 ]       EKS_NetworkingAdmin

    [ 3 ]       EKS_NodeDeployment

---------------------------------------

production-cluster1  43817294371

---------------------------------------

    [ 4 ]       EKS_Deployment

    [ 5 ]       EKS_Master

    [ 6 ]       EKS_NetworkingAdmin

    [ 7 ]       EKS_NodeDeployment


choose an IAM role from the above list which will be used to discover eks clusters in that account

role no [0]:

assuming arn:aws:iam::1234567890:role/EKS_Deployment via aws sts

list of clusters in us-east-1 0987654321
    [ 0 ]       cluster-1
    [ 1 ]       cluster-2
    [ 2 ]       cluster-3
    [ 3 ]       cluster-4
#press enter if you want to select ALL clusters

cluster no [0]:

do you want to set an unique alias for this cluster? e.g my-test-cluster1.

You can later use the command "kconnect to my-test-cluster1" to connect to this cluster as a shortcut

#press enter to SKIP

alias:

do you want to connect to a specific namespace?

#press enter to SKIP

namespace:

generating kubeconfig at $HOME/.kube/config

setting namespace to default

saving your settings to $HOME/.kconnect/config.yaml

you can run kubectl commands now!
```

#### AKS Example

NOTE: we could possibly list clusters grouped by resource group, subscription when running interactively.


```bash
./kconnect

config not found at $HOME/.kconnect/config

Looks like a first time user, lets set you up interactively

Alternatively if you have kconnect-config handy, you can run "kconnect configure -f /path/to/kconnect-config.yaml". More info at https://fidelity.github.io/kconnect/

Choose a platform
(1) eks
(2) aks
(3) rancher
2

setting up eks as the default platform at $HOME/kconnect/config.yaml

do1 you want to configure proxy? [http_proxy, https_proxy, no_proxy]
[no]:

no proxy configured

Please login to Azure using the browser window thats opened.


fetching subscriptions

[0] Azure Subscription 1 (1234567890)
[1] Azure Subscription 2 (7565839308)

subscription[0]:
0

Getting resource groups for subscription 1234567890

[0] rg-dev
[1] rg-staging

resource group[0]:
1

Getting clusters in resource group rg-staging


list of clusters in rg-staging (sub 1234567890) 0
    [ 0 ]       cluster-1
    [ 1 ]       cluster-2
    [ 2 ]       cluster-3
    [ 3 ]       cluster-4
#press enter if you want to select ALL clusters

cluster no [0]:

do you want to set an unique alias for this cluster? e.g my-test-cluster1.

You can later use the command "kconnect to my-test-cluster1" to connect to this cluster as a shortcut

#press enter to SKIP

alias:

do you want to connect to a specific namespace?

#press enter to SKIP

namespace:

generating kubeconfig at $HOME/.kube/config

setting namespace to default

saving your settings to $HOME/.kconnect/config.yaml

you can run kubectl commands now!
```


### Additional Details

Add anything else relevant here
