/*  -*-  mode: c; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4; coding: utf-8  -*-  */
#ifndef __WATERFALL_COLOURS_H
#define __WATERFALL_COLOURS_H

// Color palattes for waterfall displays
//
// Derived with the help of:  http://www.perbang.dk/rgbgradient/    (Using the "gradient maker")
//
// NOTES:
//
//  - The waterfall palettes range from [0] = weakest signal to [63] for the strongest signal
//
//	- The last entry [64] (the 65th) is always reserved for the vertical line color.  It is included in the table as a placeholder, but its value will always be overwritten.
//
//  - The LCD uses a 16 bit (5,6,5) RGB palette where there are 5 Blue, 6 Green and 5 Red bits of color resolution, produced by the macro "RGB", below
//
//
#define RGB(red,green,blue)(uint16_t)(((red>>3)<<11)|((green>>2)<<5)|(blue>> 3))
//
//
// Waterfall Gray Colors:  Weak = dark, strongest = white
//
const ushort waterfall_grey[] =
{
    RGB(0x00,0x00,0x00),
    RGB(0x04,0x04,0x04),
    RGB(0x08,0x08,0x08),
    RGB(0x0c,0x0c,0x0c),
    RGB(0x10,0x10,0x10),
    RGB(0x14,0x14,0x14),
    RGB(0x18,0x18,0x18),
    RGB(0x1c,0x1c,0x1c),
    RGB(0x20,0x20,0x20),
    RGB(0x24,0x24,0x24),
    RGB(0x28,0x28,0x28),
    RGB(0x2c,0x2c,0x2c),
    RGB(0x30,0x30,0x30),
    RGB(0x34,0x34,0x34),
    RGB(0x38,0x38,0x38),
    RGB(0x3c,0x3c,0x3c),
    RGB(0x40,0x40,0x40),
    RGB(0x44,0x44,0x44),
    RGB(0x48,0x48,0x48),
    RGB(0x4c,0x4c,0x4c),
    RGB(0x50,0x50,0x50),
    RGB(0x54,0x54,0x54),
    RGB(0x59,0x59,0x59),
    RGB(0x5d,0x5d,0x5d),
    RGB(0x61,0x61,0x61),
    RGB(0x65,0x65,0x65),
    RGB(0x69,0x69,0x69),
    RGB(0x6d,0x6d,0x6d),
    RGB(0x71,0x71,0x71),
    RGB(0x75,0x75,0x75),
    RGB(0x79,0x79,0x79),
    RGB(0x7d,0x7d,0x7d),
    RGB(0x81,0x81,0x81),
    RGB(0x85,0x85,0x85),
    RGB(0x89,0x89,0x89),
    RGB(0x8d,0x8d,0x8d),
    RGB(0x91,0x91,0x91),
    RGB(0x95,0x95,0x95),
    RGB(0x99,0x99,0x99),
    RGB(0x9d,0x9d,0x9d),
    RGB(0xa1,0xa1,0xa1),
    RGB(0xa5,0xa5,0xa5),
    RGB(0xa9,0xa9,0xa9),
    RGB(0xae,0xae,0xae),
    RGB(0xb2,0xb2,0xb2),
    RGB(0xb6,0xb6,0xb6),
    RGB(0xba,0xba,0xba),
    RGB(0xbe,0xbe,0xbe),
    RGB(0xc2,0xc2,0xc2),
    RGB(0xc6,0xc6,0xc6),
    RGB(0xca,0xca,0xca),
    RGB(0xce,0xce,0xce),
    RGB(0xd2,0xd2,0xd2),
    RGB(0xd6,0xd6,0xd6),
    RGB(0xda,0xda,0xda),
    RGB(0xde,0xde,0xde),
    RGB(0xe2,0xe2,0xe2),
    RGB(0xe6,0xe6,0xe6),
    RGB(0xea,0xea,0xea),
    RGB(0xee,0xee,0xee),
    RGB(0xf2,0xf2,0xf2),
    RGB(0xf6,0xf6,0xf6),
    RGB(0xfa,0xfa,0xfa),
    RGB(0xff,0xff,0xff),
    RGB(0xff,0xff,0xff)
};

// Waterfall Gray Colors - inverse (weak = light, strong = dark)
//
const ushort waterfall_grey_inverse[] =
{
    RGB(0xff,0xff,0xff),
    RGB(0xfa,0xfa,0xfa),
    RGB(0xf6,0xf6,0xf6),
    RGB(0xf2,0xf2,0xf2),
    RGB(0xee,0xee,0xee),
    RGB(0xea,0xea,0xea),
    RGB(0xe6,0xe6,0xe6),
    RGB(0xe2,0xe2,0xe2),
    RGB(0xde,0xde,0xde),
    RGB(0xda,0xda,0xda),
    RGB(0xd6,0xd6,0xd6),
    RGB(0xd2,0xd2,0xd2),
    RGB(0xce,0xce,0xce),
    RGB(0xca,0xca,0xca),
    RGB(0xc6,0xc6,0xc6),
    RGB(0xc2,0xc2,0xc2),
    RGB(0xbe,0xbe,0xbe),
    RGB(0xba,0xba,0xba),
    RGB(0xb6,0xb6,0xb6),
    RGB(0xb2,0xb2,0xb2),
    RGB(0xae,0xae,0xae),
    RGB(0xa9,0xa9,0xa9),
    RGB(0xa5,0xa5,0xa5),
    RGB(0xa1,0xa1,0xa1),
    RGB(0x9d,0x9d,0x9d),
    RGB(0x99,0x99,0x99),
    RGB(0x95,0x95,0x95),
    RGB(0x91,0x91,0x91),
    RGB(0x8d,0x8d,0x8d),
    RGB(0x89,0x89,0x89),
    RGB(0x85,0x85,0x85),
    RGB(0x81,0x81,0x81),
    RGB(0x7d,0x7d,0x7d),
    RGB(0x79,0x79,0x79),
    RGB(0x75,0x75,0x75),
    RGB(0x71,0x71,0x71),
    RGB(0x6d,0x6d,0x6d),
    RGB(0x69,0x69,0x69),
    RGB(0x65,0x65,0x65),
    RGB(0x61,0x61,0x61),
    RGB(0x5d,0x5d,0x5d),
    RGB(0x59,0x59,0x59),
    RGB(0x54,0x54,0x54),
    RGB(0x50,0x50,0x50),
    RGB(0x4c,0x4c,0x4c),
    RGB(0x48,0x48,0x48),
    RGB(0x44,0x44,0x44),
    RGB(0x40,0x40,0x40),
    RGB(0x3c,0x3c,0x3c),
    RGB(0x38,0x38,0x38),
    RGB(0x34,0x34,0x34),
    RGB(0x30,0x30,0x30),
    RGB(0x2c,0x2c,0x2c),
    RGB(0x28,0x28,0x28),
    RGB(0x24,0x24,0x24),
    RGB(0x20,0x20,0x20),
    RGB(0x1c,0x1c,0x1c),
    RGB(0x18,0x18,0x18),
    RGB(0x14,0x14,0x14),
    RGB(0x10,0x10,0x10),
    RGB(0x0c,0x0c,0x0c),
    RGB(0x08,0x08,0x08),
    RGB(0x04,0x04,0x04),
    RGB(0x00,0x00,0x00),
    RGB(0xff,0xff,0xff)
};


// This palette has weak signals as "cold" (blue) and strong signals as hot (red)
//
const ushort waterfall_cold_hot[] =
{
    RGB(0x00,0x00,0x22),	//div 4	RGB(0x00,0x02,0x8a),  - make the first few colors darker/"redder"
    RGB(0x01,0x00,0x23),	//div 3.8 RGB(0x04,0x02,0x87),
    RGB(0x02,0x00,0x25),	//div 3.6 RGB(0x08,0x02,0x85),
    RGB(0x04,0x00,0x27),	//div 3.4 RGB(0x0c,0x02,0x83),
    RGB(0x05,0x00,0x28),	//div 3.2 RGB(0x10,0x02,0x81),
    RGB(0x07,0x00,0x2a),	//div 3.0 RGB(0x14,0x02,0x7f),
    RGB(0x09,0x01,0x2d),	//div 2.8 RGB(0x18,0x03,0x7d),
    RGB(0x0a,0x01,0x2f),	//div 2.6 RGB(0x1c,0x03,0x7b),
    RGB(0x0d,0x01,0x32),	//div 2.4 RGB(0x20,0x03,0x79),
    RGB(0x10,0x02,0x36),	//div 2.2 RGB(0x24,0x03,0x77),
    RGB(0x14,0x02,0x3b),	//div 2.0 RGB(0x28,0x03,0x75),
    RGB(0x18,0x02,0x40),	//div 1.8 RGB(0x2c,0x04,0x73),
    RGB(0x1e,0x02,0x47),	//div 1.6 RGB(0x30,0x04,0x71),
    RGB(0x25,0x02,0x4f),	//div 1.4 RGB(0x34,0x04,0x6f),
    RGB(0x2f,0x03,0x5b),	//div 1.2 RGB(0x38,0x04,0x6d),
    RGB(0x3c,0x04,0x6b),
    RGB(0x40,0x05,0x69),
    RGB(0x44,0x05,0x67),
    RGB(0x48,0x05,0x65),
    RGB(0x4c,0x05,0x63),
    RGB(0x50,0x05,0x61),
    RGB(0x55,0x06,0x5f),
    RGB(0x59,0x06,0x5d),
    RGB(0x5d,0x06,0x5b),
    RGB(0x61,0x06,0x59),
    RGB(0x65,0x06,0x57),
    RGB(0x69,0x06,0x55),
    RGB(0x6d,0x07,0x53),
    RGB(0x71,0x07,0x51),
    RGB(0x75,0x07,0x4f),
    RGB(0x79,0x07,0x4d),
    RGB(0x7d,0x07,0x4b),
    RGB(0x81,0x08,0x48),
    RGB(0x85,0x08,0x46),
    RGB(0x89,0x08,0x44),
    RGB(0x8d,0x08,0x42),
    RGB(0x91,0x08,0x40),
    RGB(0x95,0x09,0x3d),
    RGB(0x99,0x09,0x3c),
    RGB(0x9d,0x09,0x3a),
    RGB(0xa1,0x09,0x38),
    RGB(0xa5,0x09,0x36),
    RGB(0xaa,0x0a,0x34),
    RGB(0xae,0x0a,0x32),
    RGB(0xb2,0x0a,0x30),
    RGB(0xb6,0x0a,0x2e),
    RGB(0xba,0x0a,0x2c),
    RGB(0xbe,0x0a,0x2a),
    RGB(0xc2,0x0b,0x28),
    RGB(0xc6,0x0b,0x26),
    RGB(0xca,0x0b,0x24),
    RGB(0xce,0x0b,0x22),
    RGB(0xd2,0x0b,0x20),
    RGB(0xd6,0x0c,0x1e),
    RGB(0xda,0x0c,0x1c),
    RGB(0xde,0x0c,0x1a),
    RGB(0xe2,0x0c,0x18),
    RGB(0xe6,0x0c,0x16),
    RGB(0xea,0x0d,0x14),
    RGB(0xee,0x0d,0x12),
    RGB(0xf2,0x0d,0x10),
    RGB(0xf6,0x0d,0x0e),
    RGB(0xfa,0x0d,0x0c),
    RGB(0xff,0x0d,0x0a),
    RGB(0xff,0xff,0xff),
};
//
// Waterfall Blue Colors:  Weak = dark, strongest = white
//
const ushort waterfall_blue[] =
{
    RGB(0x00,0x00,0x2e),
    RGB(0x02,0x02,0x31),
    RGB(0x05,0x05,0x34),
    RGB(0x07,0x08,0x37),
    RGB(0x0a,0x0b,0x3b),
    RGB(0x0c,0x0d,0x3e),
    RGB(0x0f,0x10,0x41),
    RGB(0x12,0x13,0x45),
    RGB(0x14,0x16,0x48),
    RGB(0x17,0x19,0x4b),
    RGB(0x19,0x1b,0x4f),
    RGB(0x1c,0x1e,0x52),
    RGB(0x1f,0x21,0x55),
    RGB(0x21,0x24,0x59),
    RGB(0x24,0x27,0x5c),
    RGB(0x26,0x29,0x5f),
    RGB(0x29,0x2c,0x63),
    RGB(0x2b,0x2f,0x66),
    RGB(0x2e,0x32,0x69),
    RGB(0x31,0x35,0x6d),
    RGB(0x33,0x37,0x70),
    RGB(0x36,0x3a,0x73),
    RGB(0x38,0x3d,0x76),
    RGB(0x3b,0x40,0x7a),
    RGB(0x3e,0x43,0x7d),
    RGB(0x40,0x45,0x80),
    RGB(0x43,0x48,0x84),
    RGB(0x45,0x4b,0x87),
    RGB(0x48,0x4e,0x8a),
    RGB(0x4b,0x51,0x8e),
    RGB(0x4d,0x53,0x91),
    RGB(0x50,0x56,0x94),
    RGB(0x52,0x59,0x98),
    RGB(0x55,0x5c,0x9b),
    RGB(0x57,0x5e,0x9e),
    RGB(0x5a,0x61,0xa2),
    RGB(0x5d,0x64,0xa5),
    RGB(0x5f,0x67,0xa8),
    RGB(0x62,0x6a,0xac),
    RGB(0x64,0x6c,0xaf),
    RGB(0x67,0x6f,0xb2),
    RGB(0x6a,0x72,0xb6),
    RGB(0x6c,0x75,0xb9),
    RGB(0x6f,0x78,0xbc),
    RGB(0x71,0x7a,0xbf),
    RGB(0x74,0x7d,0xc3),
    RGB(0x77,0x80,0xc6),
    RGB(0x79,0x83,0xc9),
    RGB(0x7c,0x86,0xcd),
    RGB(0x7e,0x88,0xd0),
    RGB(0x81,0x8d,0xd3),
    RGB(0x83,0x8e,0xd7),
    RGB(0x86,0x91,0xda),
    RGB(0x89,0x94,0xdd),
    RGB(0x8b,0x96,0xe1),
    RGB(0x8e,0x99,0xe4),
    RGB(0x90,0x9c,0xe7),
    RGB(0x93,0x9f,0xeb),
    RGB(0x96,0xa2,0xee),
    RGB(0x98,0xa4,0xf1),
    RGB(0x9b,0xa7,0xf5),
    RGB(0x9d,0xda,0xf8),
    RGB(0xa0,0xdf,0xfb),
    RGB(0xa3,0xe5,0xff),
    RGB(0xff,0xff,0xff)
};
const ushort waterfall_rainbow[] =
{
    RGB(0x00,0x00,0x0b),	//div 4.0	RGB(0x00,0x01,0x2d),	// Make the first few colors "bluer"
    RGB(0x00,0x01,0x0d),	//div 3.8	RGB(0x00,0x04,0x30),
    RGB(0x00,0x02,0x0e),	//div 3.6	RGB(0x00,0x07,0x33),
    RGB(0x00,0x03,0x10),	//div 3.4	RGB(0x00,0x0b,0x37),
    RGB(0x00,0x05,0x12),	//div 3.2	RGB(0x00,0x10,0x3a),
    RGB(0x00,0x07,0x14),	//div 3.0	RGB(0x00,0x14,0x3d),
    RGB(0x00,0x09,0x1b),	//div 2.8	RGB(0x00,0x1a,0x4a),
    RGB(0x00,0x0c,0x1a),	//div 2.6	RGB(0x00,0x1f,0x44),
    RGB(0x00,0x0f,0x1e),	//div 2.4	RGB(0x00,0x25,0x47),
    RGB(0x00,0x14,0x22),	//div 2.2	RGB(0x00,0x2c,0x4b),
    RGB(0x00,0x1a,0x27),	//div 2.0	RGB(0x00,0x33,0x4e),
    RGB(0x00,0x20,0x2d),	//div 1.8	RGB(0x00,0x3a,0x51),
    RGB(0x00,0x29,0x35),	//div 1.6	RGB(0x00,0x42,0x54),
    RGB(0x00,0x35,0x3f),	//div 1.4	RGB(0x00,0x4a,0x58),
    RGB(0x00,0x44,0x4c),	//div 1.2	RGB(0x00,0x52,0x5b),
    RGB(0x00,0x5b,0x5e),
    RGB(0x00,0x62,0x5f),
    RGB(0x01,0x65,0x5c),
    RGB(0x01,0x68,0x59),
    RGB(0x01,0x6c,0x55),
    RGB(0x01,0x6f,0x50),
    RGB(0x01,0x72,0x4c),
    RGB(0x01,0x76,0x46),
    RGB(0x01,0x79,0x41),
    RGB(0x01,0x7c,0x3b),
    RGB(0x01,0x80,0x35),
    RGB(0x02,0x83,0x2e),
    RGB(0x02,0x87,0x27),
    RGB(0x02,0x8a,0x1f),
    RGB(0x02,0x8d,0x18),
    RGB(0x02,0x91,0x0f),
    RGB(0x02,0x94,0x07),
    RGB(0x08,0x97,0x03),
    RGB(0x11,0x9b,0x03),
    RGB(0x1c,0x9e,0x03),
    RGB(0x26,0xa1,0x03),
    RGB(0x31,0xa4,0x03),
    RGB(0x3d,0xa8,0x03),
    RGB(0x49,0xab,0x04),
    RGB(0x55,0xaf,0x04),
    RGB(0x61,0xb2,0x04),
    RGB(0x6e,0xb5,0x04),
    RGB(0x7c,0xb8,0x04),
    RGB(0x8a,0xbc,0x05),
    RGB(0x98,0xbf,0x05),
    RGB(0xa6,0xc3,0x05),
    RGB(0xb5,0xc6,0x05),
    RGB(0xc5,0xc9,0x05),
    RGB(0xcc,0xc4,0x06),
    RGB(0xd0,0xbb,0x06),
    RGB(0xd3,0xb1,0x06),
    RGB(0xd7,0xa7,0x06),
    RGB(0xda,0x9c,0x07),
    RGB(0xdd,0x91,0x07),
    RGB(0xe0,0x86,0x07),
    RGB(0xe4,0x7a,0x07),
    RGB(0xe7,0x6e,0x08),
    RGB(0xeb,0x61,0x08),
    RGB(0xee,0x54,0x08),
    RGB(0xf1,0x47,0x08),
    RGB(0xf4,0x39,0x09),
    RGB(0xf8,0x2b,0x09),
    RGB(0xfb,0x1c,0x09),
    RGB(0xff,0x0e,0x09),
    RGB(0xff,0xff,0xff),
};
#endif