/*  -*-  mode: c; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4; coding: utf-8  -*-  */
/************************************************************************************
**                                                                                 **
**                               mcHF QRP Transceiver                              **
**                             K Atanassov - M0NKA 2014                            **
**                                                                                 **
**---------------------------------------------------------------------------------**
**                                                                                 **
**  File name:                                                                     **
**  Description:                                                                   **
**  Last Modified:                                                                 **
**  Licence:		CC BY-NC-SA 3.0                                                **
************************************************************************************/

#include "filters.h"

/*
 	 * Hilbert 0 Degree, "Phase-added" bandpass filter
     * Kaiser Window FIR Filter, Beta = 3.25, Raised Cosine = 9.30
     * Fc = 5.23 kHz
     * BW = 9.50 kHz
     * 89 Taps
     *
     * 20140926 by KA7OEI using Iowa Hills Hilbert Filter Designer
*/

const float i_rx_coeffs[I_NUM_TAPS] =
{
    0.000101250517153683,
    -0.000515927338247317,
    -0.00176919806883,
    -0.001893116080949,
    -0.000577659000336806,
    3.550079658197940E-6,
    -0.00172963585657513,
    -0.0038100999663584,
    -0.0031472032338157,
    -0.000586333586637393,
    -0.000494536851592284,
    -0.00415653740435641,
    -0.00680718523656846,
    -0.00429325456879721,
    -0.000273434114376999,
    -0.00181389209595478,
    -0.0082208278123836,
    -0.0105062537188667,
    -0.00469751224581168,
    0.000452038013830452,
    -0.00454071945888382,
    -0.0142111518079221,
    -0.0142255278253247,
    -0.00344416232313822,
    0.001565954170156727,
    -0.00947713768589062,
    -0.0222735621260352,
    -0.0167608122370822,
    0.000803648164899460,
    0.002905223684809450,
    -0.0179852797068097,
    -0.0327457542271941,
    -0.0160524441181231,
    0.010701868004134297,
    0.004196449024939201,
    -0.0338893802111143,
    -0.0479948819717114,
    -0.00683680444677724,
    0.036441721082929118,
    0.005133250668784600,
    -0.0804182627087614,
    -0.0919356431907568,
    0.060333107936900596,
    0.291908298625711771,
    0.404029117624692125,
    0.291908298625728535,
    0.060333107936918977,
    -0.0919356431907509,
    -0.0804182627087674,
    0.005133250668778217,
    0.036441721082930000,
    -0.00683680444677221,
    -0.0479948819717094,
    -0.033889380211117,
    0.004196449024936275,
    0.010701868004134651,
    -0.016052444118121,
    -0.0327457542271935,
    -0.0179852797068109,
    0.002905223684808852,
    0.000803648164900392,
    -0.0167608122370813,
    -0.0222735621260356,
    -0.00947713768589167,
    0.001565954170156743,
    -0.00344416232313721,
    -0.0142255278253243,
    -0.0142111518079231,
    -0.00454071945888512,
    0.000452038013830350,
    -0.00469751224581064,
    -0.0105062537188658,
    -0.00822082781238365,
    -0.0018138920959553,
    -0.000273434114377146,
    -0.00429325456879692,
    -0.0068071852365683,
    -0.00415653740435665,
    -0.000494536851592651,
    -0.000586333586637503,
    -0.00314720323381554,
    -0.00381009996635821,
    -0.00172963585657509,
    3.550079658144650E-6,
    -0.000577659000336875,
    -0.00189311608094905,
    -0.00176919806883003,
    -0.000515927338247313,
    0.000101250517153702
};

const float q_rx_coeffs[Q_NUM_TAPS] =
{
    0.000344914318465872,
    0.001232705528752468,
    0.000944100782885026,
    -0.000373513290057777,
    -0.000696848846812344,
    0.000867087438645400,
    0.002144828909072224,
    0.000801938000274561,
    -0.00162900365360321,
    -0.00135050947432204,
    0.001735480576860600,
    0.002902894907756880,
    -0.000514482236669199,
    -0.00408390144313164,
    -0.00214047204883299,
    0.002895860450918038,
    0.002787523104742692,
    -0.00393491877494282,
    -0.00805973561226184,
    -0.00288287943428056,
    0.004054650295992699,
    0.000625965609562838,
    -0.010618675078802,
    -0.0137682376952537,
    -0.00334152729361202,
    0.004534947238988187,
    -0.00542579685174649,
    -0.0221939015821796,
    -0.0214720818837083,
    -0.00330493087662929,
    0.002966766270241431,
    -0.0188306615843171,
    -0.0421097245423961,
    -0.032297456691877,
    -0.00266967518669887,
    -0.00406851387698861,
    -0.0498846435725893,
    -0.0835255465990852,
    -0.0529683656275652,
    -0.00149470600381967,
    -0.0342346563886709,
    -0.175133004530271,
    -0.296357122291255,
    -0.238667384668651,
    -11.00502419074730E-15,
    0.238667384668637877,
    0.296357122291259212,
    0.175133004530283742,
    0.034234656388678494,
    0.001494706003817782,
    0.052968365627560861,
    0.083525546599085732,
    0.049884643572593541,
    0.004068513876990715,
    0.002669675186696901,
    0.032297456691874740,
    0.042109724542396962,
    0.018830661584319623,
    -0.00296676627024075,
    0.003304930876627653,
    0.021472081883707091,
    0.022193901582180590,
    0.005425796851748176,
    -0.00453494723898796,
    0.003341527293610915,
    0.013768237695253149,
    0.010618675078802686,
    -0.000625965609562042,
    -0.00405465029599303,
    0.002882879434279615,
    0.008059735612261585,
    0.003934918774943465,
    -0.00278752310474217,
    -0.00289586045091835,
    0.002140472048832366,
    0.004083901443131590,
    0.000514482236669776,
    -0.0029028949077564,
    -0.00173548057686072,
    0.001350509474321610,
    0.001629003653603014,
    -0.000801938000274391,
    -0.00214482890907199,
    -0.000867087438645351,
    0.000696848846812240,
    0.000373513290057688,
    -0.000944100782885024,
    -0.0012327055287524,
    -0.00034491431846579
};
#if 0
//
// Same as above, but set to 89.50 degrees
//
const float q_rx_coeffs_minus[Q_NUM_TAPS] =
{
    0.000345785684615153,
    0.001228151699489135,
    0.000928609842354247,
    -0.000390036613399047,
    -0.000701868547077255,
    0.000867085470047767,
    0.002129637897587250,
    0.000768623936932851,
    -0.00165643444349555,
    -0.00135558008964599,
    0.001731094482962856,
    0.002866474588417179,
    -0.000573927606884969,
    -0.0041212503195128,
    -0.00214277924812288,
    0.002879904843097448,
    0.002715603103600132,
    -0.00402654767723954,
    -0.00810046470178972,
    -0.00287882095109734,
    0.004014830102304475,
    0.000501798670783072,
    -0.0107425398973817,
    -0.0137978008744989,
    -0.00332772062420192,
    0.004451986134975294,
    -0.00562016370473348,
    -0.0223394733877002,
    -0.021464244807311,
    -0.00327942625837146,
    0.002809540973692196,
    -0.019115999589606,
    -0.0422483507953672,
    -0.0322027408364947,
    -0.00263291508566302,
    -0.00436440365302093,
    -0.0503020108880629,
    -0.0835820932848714,
    -0.0526480101213734,
    -0.0014498070570843,
    -0.034935857092474,
    -0.175929457378993,
    -0.295818803277577,
    -0.236108308594669,
    0.003529442209628497,
    0.241208304736372586,
    0.296872896700565492,
    0.174323228889556564,
    0.033530851371612519,
    0.001539491244645685,
    0.053284691701835890,
    0.083462645922585635,
    0.049463481411411839,
    0.003772314599249648,
    0.002706232199072596,
    0.032389715601469069,
    0.041967894900647146,
    0.018543891084976949,
    -0.00312376587769128,
    0.003330184080785761,
    0.021478285526808173,
    0.022046641432790341,
    0.005231017245247858,
    -0.00461756335857612,
    0.003355079764943195,
    0.013737627132805703,
    0.010494002471880374,
    -0.00075008492962116,
    -0.00409416204260874,
    0.002886718609838992,
    0.008018393399116761,
    0.003842990533841140,
    -0.00285923105224792,
    -0.0029115957636177,
    0.002138002018647314,
    0.004046241894472272,
    0.000454997728543658,
    -0.0029390943968467,
    -0.00173973464854587,
    0.001345336122469638,
    0.001601448941455631,
    -0.000835191058249309,
    -0.00215985675822488,
    -0.000867023445800554,
    0.000691776135567074,
    0.000356961552655413,
    -0.000959519903381672,
    -0.00123716558311929,
    -0.000344016713848569
};
//
//
// Same as above, but set to 90.50 degrees
//
const float q_rx_coeffs_plus[Q_NUM_TAPS] =
{
    0.000344016713848422,
    0.001237165583119233,
    0.000959519903381830,
    -0.000356961552655221,
    -0.000691776135567152,
    0.000867023445800239,
    0.002159856758224740,
    0.000835191058249567,
    -0.0016014489414553,
    -0.00134533612246971,
    0.001739734648545488,
    0.002939094396846569,
    -0.00045499772854331,
    -0.00404624189447194,
    -0.00213800201864746,
    0.002911595763617357,
    0.002859231052247991,
    -0.0038429905338407,
    -0.00801839339911664,
    -0.00288671860983938,
    0.004094162042608576,
    0.000750084929621739,
    -0.0104940024718798,
    -0.013737627132806,
    -0.00335507976494403,
    0.00461756335857628,
    -0.00523101724524657,
    -0.0220466414327896,
    -0.0214782855268092,
    -0.00333018408078714,
    0.003123765877691971,
    -0.0185438910849747,
    -0.0419678949006465,
    -0.0323897156014713,
    -0.00270623219907439,
    -0.00377231459924747,
    -0.0494634814114077,
    -0.0834626459225853,
    -0.0532846917018405,
    -0.00153949124464774,
    -0.0335308513716049,
    -0.174323228889544,
    -0.296872896700561,
    -0.241208304736386,
    -0.00352944220965053,
    0.236108308594655258,
    0.295818803277580589,
    0.175929457379005394,
    0.034935857092481731,
    0.001449807057082345,
    0.052648010121368764,
    0.083582093284871553,
    0.050302010888066989,
    0.004364403653023157,
    0.002632915085661265,
    0.032202740836492459,
    0.042248350795367859,
    0.019115999589608253,
    -0.00280954097369148,
    0.003279426258370093,
    0.021464244807309917,
    0.022339473387700919,
    0.005620163704734763,
    -0.00445198613497516,
    0.003327720624201085,
    0.013797800874498599,
    0.010742539897382350,
    -0.000501798670782488,
    -0.00401483010230463,
    0.002878820951096947,
    0.008100464701789833,
    0.004026547677239973,
    -0.00271560310360006,
    -0.00287990484309779,
    0.002142779248122731,
    0.004121250319513134,
    0.000573927606885321,
    -0.0028664745884173,
    -0.00173109448296324,
    0.001355580089645912,
    0.001656434443495877,
    -0.000768623936932588,
    -0.00212963789758739,
    -0.000867085470048082,
    0.000701868547077172,
    0.000390036613399236,
    -0.000928609842354086,
    -0.00122815169948919,
    -0.0003457857
};
#endif

/*
     * Hilbert 0 Degree, "Phase-added" bandpass filter
     * Kaiser Window FIR Filter, Beta = 5.00, Raised Cosine = 0.90
     * Fc = 1.97 kHz
     * BW = 3.74 kHz
     * 89 Taps
     *
     * 20141203 by KA7OEI using Iowa Hills Hilbert Filter Designer
     *
     * This filter used in the "3.6 kHz" and narrower RX filter position of the mcHF
*/

const float i_rx_3k6_coeffs[I_NUM_TAPS] =
{
    -0.000181752008817777,
    -0.00019812444299558,
    -0.000173915580313638,
    -0.000106975730010085,
    -0.0000174463735378,
    0.000049667546759971,
    0.000032561004630231,
    -0.000127681493947272,
    -0.000459708207577463,
    -0.000935771201527816,
    -0.00145865712043841,
    -0.00187227346724911,
    -0.00200036401889901,
    -0.00170780689629204,
    -0.000967958368014592,
    0.000088289293095689,
    0.001166623215145986,
    0.001862531622450524,
    0.001771946721352388,
    0.000635741675713185,
    -0.00152451719575799,
    -0.00433057882661493,
    -0.00707443210838268,
    -0.00886614749018614,
    -0.00888315684570901,
    -0.00666207782636225,
    -0.0023460199801576,
    0.003204723474564544,
    0.008506335530971061,
    0.011765956147501436,
    0.011367103182967093,
    0.006413424630698947,
    -0.00282047953175066,
    -0.0146812039524101,
    -0.0262751422843746,
    -0.0339730971952901,
    -0.0341994964523126,
    -0.0243347165617545,
    -0.00350726050818481,
    0.026942155121425213,
    0.063476622132557281,
    0.100898465799951861,
    0.133312097666693830,
    0.155307720769003010,
    0.163093615613067344,
    0.155307720769004343,
    0.133312097666696161,
    0.100898465799954873,
    0.063476622132560459,
    0.026942155121428071,
    -0.00350726050818265,
    -0.0243347165617533,
    -0.0341994964523123,
    -0.0339730971952905,
    -0.0262751422843754,
    -0.0146812039524111,
    -0.00282047953175152,
    0.006413424630698421,
    0.011367103182966964,
    0.011765956147501661,
    0.008506335530971517,
    0.003204723474565072,
    -0.00234601998015715,
    -0.00666207782636198,
    -0.00888315684570896,
    -0.00886614749018627,
    -0.00707443210838294,
    -0.00433057882661522,
    -0.00152451719575822,
    0.000635741675713052,
    0.001771946721352369,
    0.001862531622450603,
    0.001166623215146122,
    0.000088289293095838,
    -0.00096795836801447,
    -0.00170780689629197,
    -0.002000364018899,
    -0.00187227346724914,
    -0.00145865712043846,
    -0.000935771201527874,
    -0.000459708207577509,
    -0.000127681493947298,
    0.000032561004630225,
    0.000049667546759980,
    -0.000017446373537785,
    -0.00010697573001007,
    -0.000173915580313629,
    -0.000198124442995578,
    -0.000181752
};

/*
     * Hilbert -90 Degree, "Phase-added" bandpass filter
     * Kaiser Window FIR Filter, Beta = 5.00, Raised Cosine = 0.90
     * Fc = 1.97 kHz
     * BW = 3.74 kHz
     * 89 Taps
     *
     * 20141203 by KA7OEI using Iowa Hills Hilbert Filter Designer
     *
     * This filter used in the "3.6 kHz" and narrower RX filter positions of the mcHF
*/

const float q_rx_3k6_coeffs[Q_NUM_TAPS] =
{
    -0.000294806871446761,
    -0.000430038513938049,
    -0.00057577635651954,
    -0.000701452460068679,
    -0.000773483568490036,
    -0.000770724776536896,
    -0.000701666832263429,
    -0.000616113554803381,
    -0.000603644067469941,
    -0.00077404001429163,
    -0.00122090559459946,
    -0.00197736129120186,
    -0.00297920572331694,
    -0.00405321865749724,
    -0.00494407320037525,
    -0.00538239440020133,
    -0.00518124403535075,
    -0.00433349474961163,
    -0.00307403519977391,
    -0.00187345276484406,
    -0.00134566807456456,
    -0.00207838789258401,
    -0.00442514292801338,
    -0.00832115293523963,
    -0.0131925136715957,
    -0.0180131059057811,
    -0.0215266256625295,
    -0.0226003081681251,
    -0.0206265730133377,
    -0.0158556828219807,
    -0.00954049290906044,
    -0.00380949445236171,
    -0.00125158785236759,
    -0.00427935828129978,
    -0.0144137579244869,
    -0.0316779221618311,
    -0.0542839354303643,
    -0.0787391229290012,
    -0.100398818306822,
    -0.114375118099481,
    -0.116607805332378,
    -0.104844680649768,
    -0.0792835060106304,
    -0.0426990455969243,
    -1.802423033856850E-15,
    0.042699045596920997,
    0.079283506010627697,
    0.104844680649766375,
    0.116607805332377912,
    0.114375118099481379,
    0.100398818306823789,
    0.078739122929003105,
    0.054283935430366234,
    0.031677922161832718,
    0.014413757924488018,
    0.004279358281300266,
    0.001251587852367549,
    0.003809494452361318,
    0.009540492909059896,
    0.015855682821980240,
    0.020626573013337410,
    0.022600308168125034,
    0.021526625662529674,
    0.018013105905781469,
    0.013192513671596058,
    0.008321152935239943,
    0.004425142928013570,
    0.002078387892584060,
    0.001345668074564481,
    0.001873452764843904,
    0.003074035199773733,
    0.004333494749611476,
    0.005181244035350659,
    0.005382394400201308,
    0.004944073200375284,
    0.004053218657497318,
    0.002979205723317022,
    0.001977361291201922,
    0.001220905594599500,
    0.000774040014291644,
    0.000603644067469934,
    0.000616113554803364,
    0.000701666832263413,
    0.000770724776536887,
    0.000773483568490036,
    0.000701452460068687,
    0.000575776356519553,
    0.000430038513938061,
    0.000294806871446770
};
#if 0
//
// Same as above, but set to -89.50 degrees
//
const float q_rx_3k6_coeffs_minus[Q_NUM_TAPS] =
{
    -0.000296380721462183,
    -0.000431750013359223,
    -0.000577271201466755,
    -0.000702358759671733,
    -0.000773606358243193,
    -0.000770262377749341,
    -0.000701356238932302,
    -0.000617203666244525,
    -0.000607630221322245,
    -0.000782171394601014,
    -0.00123358004541336,
    -0.00199361413363922,
    -0.00299653760381988,
    -0.00406795841390126,
    -0.00495232700454705,
    -0.00538142014572859,
    -0.00517087338199056,
    -0.0043170873311676,
    -0.00305846556626572,
    -0.00186783742193235,
    -0.00135891214852496,
    -0.00211607551610032,
    -0.00448667032679334,
    -0.00839815781424639,
    -0.0132694819909666,
    -0.0180705214653967,
    -0.0215462679892084,
    -0.0225715023079523,
    -0.0205516072815124,
    -0.0157524713736376,
    -0.00944099951243712,
    -0.00375341907618676,
    -0.00127613744482971,
    -0.00440722904942769,
    -0.0146423535178151,
    -0.0319729955136686,
    -0.0545801251563832,
    -0.0789483547584795,
    -0.100425594029681,
    -0.114135817274525,
    -0.11604980662169,
    -0.103960776559558,
    -0.0781178963313035,
    -0.0413430030557385,
    0.001422321813111582,
    0.044051846785323458,
    0.080443097152319953,
    0.105720625812728841,
    0.117156952158226857,
    0.114605736526452867,
    0.100364421149232066,
    0.078523913886879862,
    0.053983624924064215,
    0.031380444088303247,
    0.014184068159762866,
    0.004151162660246889,
    0.001226943249871537,
    0.003865280643724892,
    0.009639262071620981,
    0.015957690640103335,
    0.020699972949044482,
    0.022627398402789923,
    0.021505349215297679,
    0.017954322942512063,
    0.013114543887430948,
    0.008243516384216850,
    0.004363279609562653,
    0.002040542495321605,
    0.001332321848790194,
    0.001878925890962495,
    0.003089371478357671,
    0.004349573205544231,
    0.005191221372196609,
    0.005382960068514172,
    0.004935444083706319,
    0.004038171214788057,
    0.002961647686546919,
    0.001960958344109158,
    0.001208138462890931,
    0.000765849875367875,
    0.000599612090031858,
    0.000614976673197738,
    0.000701924160944054,
    0.000771128668375053,
    0.000773302062363184,
    0.000700492912088482,
    0.000574237803469036,
    0.000428294369606101,
    0.000293210642170642
};
//
//
// Same as above, but set to -90.50 degrees
//
const float q_rx_3k6_coeffs_plus[Q_NUM_TAPS] =
{
    -0.000293210642170637,
    -0.000428294369606096,
    -0.000574237803469034,
    -0.000700492912088486,
    -0.000773302062363194,
    -0.00077112866837507,
    -0.000701924160944074,
    -0.000614976673197755,
    -0.000599612090031863,
    -0.000765849875367862,
    -0.00120813846289089,
    -0.0019609583441091,
    -0.00296164768654685,
    -0.004038171214788,
    -0.00493544408370629,
    -0.00538296006851418,
    -0.00519122137219667,
    -0.00434957320554433,
    -0.00308937147835778,
    -0.00187892589096257,
    -0.00133232184879019,
    -0.00204054249532148,
    -0.0043632796095624,
    -0.00824351638421651,
    -0.0131145438874306,
    -0.0179543229425118,
    -0.0215053492152976,
    -0.02262739840279,
    -0.0206999729490448,
    -0.0159576906401039,
    -0.00963926207162155,
    -0.00386528064372531,
    -0.00122694324987159,
    -0.00415116266024643,
    -0.0141840681597618,
    -0.0313804440883017,
    -0.0539836249240624,
    -0.0785239138868781,
    -0.100364421149231,
    -0.114605736526452,
    -0.117156952158227,
    -0.10572062581273,
    -0.0804430971523225,
    -0.0440518467853267,
    -0.00142232181311506,
    0.041343003055735225,
    0.078117896331300937,
    0.103960776559556239,
    0.116049806621689372,
    0.114135817274525875,
    0.100425594029682583,
    0.078948354758481304,
    0.054580125156385072,
    0.031972995513670166,
    0.014642353517816205,
    0.004407229049428166,
    0.001276137444829668,
    0.003753419076186360,
    0.009440999512436554,
    0.015752471373637049,
    0.020551607281512018,
    0.022571502307952233,
    0.021546267989208483,
    0.018070521465396977,
    0.013269481990966999,
    0.008398157814246731,
    0.004486670326793598,
    0.002116075516100453,
    0.001358912148524973,
    0.001867837421932283,
    0.003058465566265609,
    0.004317087331167497,
    0.005170873381990497,
    0.005381420145728581,
    0.004952327004547082,
    0.004067958413901318,
    0.002996537603819948,
    0.001993614133639282,
    0.001233580045413398,
    0.000782171394601029,
    0.000607630221322240,
    0.000617203666244509,
    0.000701356238932283,
    0.000770262377749325,
    0.000773606358243183,
    0.000702358759671730,
    0.000577271201466757,
    0.000431750013359228,
    0.000296380721462188
};
#endif

/*
     * Hilbert 0 Degree. "Phase-added" bandpass filter
     * Kaiser Window FIR Filter. Beta = 3.60. Raised Cosine = 0.900
     * Fc = 2.26 kHz (0.094)
     * BW = 4.22 kHz (0.176)
     * 89 Taps
     * -6dB @ 4.5kHz
     * -20dB @ 5.0kHz
     * 2015_03_25 using Iowa Hills Hilbert Filter Designer
     *
     * alternative 5k filter to prevent heterodynes from broadcast stations
*/

const float i_rx_4k5_coeffs[I_NUM_TAPS] =
{
    -0.000114684476611150,
    -0.000262026463852400,
    -0.000525079926366648,
    -0.000856895401357901,
    -0.001155346066789558,
    -0.001291412809444851,
    -0.001162461699167819,
    -0.000752859143356339,
    -0.000174526350995810,
    0.000339209274693749,
    0.000499091989579864,
    0.000073046133119666,
    -0.000990692558959441,
    -0.002483730068330094,
    -0.003949697866924680,
    -0.004809200839481030,
    -0.004573567863659000,
    -0.003078011202014869,
    -0.000638626685125715,
    0.001953234817610510,
    0.003637209015720170,
    0.003452946429967226,
    0.000957265431653208,
    -0.003470989783383569,
    -0.008588055227867054,
    -0.012579847423775045,
    -0.013649920003274866,
    -0.010731018466373097,
    -0.004067797998680700,
    0.004581360716053101,
    0.012278059716614777,
    0.015754672994053639,
    0.012568743010528889,
    0.002200133195956026,
    -0.013308468167863059,
    -0.029468141633492831,
    -0.040299609990182284,
    -0.039936386122568675,
    -0.024443035202845947,
    0.006703267809696158,
    0.049967108367624413,
    0.098223404077723703,
    0.142291077462080584,
    0.173150725191446780,
    0.184237040208864111,
    0.173150725191419053,
    0.142291077462031068,
    0.098223404077662682,
    0.049967108367563948,
    0.006703267809647070,
    -0.024443035202876579,
    -0.039936386122578854,
    -0.040299609990174963,
    -0.029468141633474526,
    -0.013308468167841675,
    0.002200133195973488,
    0.012568743010538024,
    0.015754672994053375,
    0.012278059716607056,
    0.004581360716041745,
    -0.004067797998691490,
    -0.010731018466380082,
    -0.013649920003276582,
    -0.012579847423771943,
    -0.008588055227860981,
    -0.003470989783376950,
    0.000957265431658244,
    0.003452946429969460,
    0.003637209015719496,
    0.001953234817607744,
    -0.000638626685129280,
    -0.003078011202017972,
    -0.004573567863660808,
    -0.004809200839481303,
    -0.003949697866923710,
    -0.002483730068328492,
    -0.000990692558957855,
    0.000073046133120763,
    0.000499091989580280,
    0.000339209274693558,
    -0.000174526350996367,
    -0.000752859143356981,
    -0.001162461699168330,
    -0.001291412809445128,
    -0.001155346066789606,
    -0.000856895401357789,
    -0.000525079926366464,
    -0.000262026463852214,
    -0.000114684476610995

};

/*
     * Hilbert -90 Degree. "Phase-added" bandpass filter
     * Kaiser Window FIR Filter. Beta = 3.60. Raised Cosine = 0.900
     * Fc = 2.26 kHz (0.094)
     * BW = 4.22 kHz (0.176)
     * 89 Taps
     * -6dB @ 4.5kHz
     * -20dB @ 5.0kHz
     * 2015_03_25 using Iowa Hills Hilbert Filter Designer
     *
     * alternative 5k filter to prevent heterodynes from broadcast stations
*/
// -90.0 degrees
const float q_rx_4k5_coeffs[Q_NUM_TAPS] =
{

    -0.000419720771966234,
    -0.000507736016752144,
    -0.000628986065032672,
    -0.000806340154215481,
    -0.001052420191683845,
    -0.001355059091748089,
    -0.001669612675501608,
    -0.001926445969230747,
    -0.002056955255256146,
    -0.002032444228802870,
    -0.001900507875122028,
    -0.001798356589528849,
    -0.001926201642715454,
    -0.002477717988189657,
    -0.003545137297251056,
    -0.005035589477636542,
    -0.006642952616459500,
    -0.007908293224513731,
    -0.008371486246934122,
    -0.007775365758175711,
    -0.006247796195788404,
    -0.004374325227038194,
    -0.003096698076281785,
    -0.003429821370672838,
    -0.006065585254040566,
    -0.010998160042716644,
    -0.017331496876893077,
    -0.023395531214150060,
    -0.027203677808302417,
    -0.027156037201637225,
    -0.022774664728007547,
    -0.015197922985859799,
    -0.007194449407226034,
    -0.002587289494344928,
    -0.005172396244934549,
    -0.017410999849618827,
    -0.039300991517181465,
    -0.067833551537801171,
    -0.097301733336284196,
    -0.120480457933574786,
    -0.130416909319684693,
    -0.122349549616864547,
    -0.095192329425517419,
    -0.052115037194887040,
    34.05164165195360E-15,
    0.052115037194949337,
    0.095192329425563646,
    0.122349549616888209,
    0.130416909319684471,
    0.120480457933554330,
    0.097301733336251056,
    0.067833551537764436,
    0.039300991517149483,
    0.017410999849597254,
    0.005172396244925385,
    0.002587289494346653,
    0.007194449407234675,
    0.015197922985870478,
    0.022774664728016009,
    0.027156037201640927,
    0.027203677808300887,
    0.023395531214144585,
    0.017331496876885927,
    0.010998160042710155,
    0.006065585254036379,
    0.003429821370671529,
    0.003096698076282913,
    0.004374325227040662,
    0.006247796195790963,
    0.007775365758177394,
    0.008371486246934498,
    0.007908293224512924,
    0.006642952616458002,
    0.005035589477634966,
    0.003545137297249898,
    0.002477717988189151,
    0.001926201642715555,
    0.001798356589529323,
    0.001900507875122576,
    0.002032444228803252,
    0.002056955255256247,
    0.001926445969230584,
    0.001669612675501290,
    0.001355059091747750,
    0.001052420191683593,
    0.000806340154215362,
    0.000628986065032676,
    0.000507736016752222,
    0.000419720771966330



};

#if 0
// -89.5 degrees
const float q_rx_4k5_coeffs_minus[Q_NUM_TAPS] =
{
    -0.000419784959544359,
    -0.000508085077057665,
    -0.000629837142251098,
    -0.000807790972510875,
    -0.001054290516976973,
    -0.001356804583537386,
    -0.001670408590706369,
    -0.001925487061952287,
    -0.002053915313618948,
    -0.002027920650195713,
    -0.001896203184651432,
    -0.001796778081251007,
    -0.001929817210316381,
    -0.002487757486379345,
    -0.003560480869512413,
    -0.005052311251361515,
    -0.006654984454615627,
    -0.007909311931496077,
    -0.008357597053273292,
    -0.007747649898183128,
    -0.006213550866306101,
    -0.004346036540092592,
    -0.003088485538866142,
    -0.003452102862526508,
    -0.006119679955447318,
    -0.011073048742014863,
    -0.017404666458043970,
    -0.023438671899350092,
    -0.027192248756705548,
    -0.027079939511956225,
    -0.022646158983728387,
    -0.015053070288189226,
    -0.007085932090695214,
    -0.002569156023012709,
    -0.005280275798949498,
    -0.017643605217081689,
    -0.039609346858449267,
    -0.068122888090054831,
    -0.097447629160526766,
    -0.120356480459316545,
    -0.129927099543871383,
    -0.121456900223181494,
    -0.093934813300509512,
    -0.050603788501179206,
    0.001600882948112015,
    0.053622363753682838,
    0.096442681453899601,
    0.123232991083771726,
    0.130896904025820882,
    0.120595368147320886,
    0.097148514663327648,
    0.067539109888033536,
    0.038989678415480067,
    0.017177084144559811,
    0.005064127420609669,
    0.002605228248392797,
    0.007302425275401372,
    0.015341631900316774,
    0.022901456469698923,
    0.027230091150225230,
    0.027213059533408069,
    0.023350629800445544,
    0.017257022941488842,
    0.010922443630903687,
    0.006011034061656158,
    0.003407281753273395,
    0.003104677558740120,
    0.004402284705855875,
    0.006281571321253669,
    0.007802496450517440,
    0.008384745409403512,
    0.007906679345865895,
    0.006630420835134002,
    0.005018488729574202,
    0.003529526920861944,
    0.002467492018974975,
    0.001922441110758153,
    0.001799799754964581,
    0.001904669534928577,
    0.002036814847323998,
    0.002059840392127275,
    0.001927259893764744,
    0.001668691106615358,
    0.001353211619322117,
    0.001050470662109638,
    0.000804828651421019,
    0.000628087650838655,
    0.000507348744650336,
    0.000419624996547005



};
// -90.5 degrees
const float q_rx_4k5_coeffs_plus[Q_NUM_TAPS] =
{
    -0.000419624996546979,
    -0.000507348744650320,
    -0.000628087650838679,
    -0.000804828651421107,
    -0.001050470662109791,
    -0.001353211619322298,
    -0.001668691106615494,
    -0.001927259893764746,
    -0.002059840392127081,
    -0.002036814847323626,
    -0.001904669534928149,
    -0.001799799754964314,
    -0.001922441110758297,
    -0.002467492018975700,
    -0.003529526920863238,
    -0.005018488729575793,
    -0.006630420835135394,
    -0.007906679345866502,
    -0.008384745409402891,
    -0.007802496450515542,
    -0.006281571321250987,
    -0.004402284705853413,
    -0.003104677558739140,
    -0.003407281753274969,
    -0.006011034061660676,
    -0.010922443630910507,
    -0.017257022941496246,
    -0.023350629800451134,
    -0.027213059533409540,
    -0.027230091150221278,
    -0.022901456469690024,
    -0.015341631900305547,
    -0.007302425275392158,
    -0.002605228248390573,
    -0.005064127420618521,
    -0.017177084144581339,
    -0.038989678415512298,
    -0.067539109888070811,
    -0.097148514663361565,
    -0.120595368147342175,
    -0.130896904025821853,
    -0.123232991083748647,
    -0.096442681453853638,
    -0.053622363753620506,
    -0.001600882948043591,
    0.050603788501241996,
    0.093934813300556266,
    0.121456900223205613,
    0.129927099543871383,
    0.120356480459296089,
    0.097447629160493404,
    0.068122888090017764,
    0.039609346858416952,
    0.017643605217059905,
    0.005280275798940312,
    0.002569156023014644,
    0.007085932090704262,
    0.015053070288200420,
    0.022646158983737369,
    0.027079939511960340,
    0.027192248756704229,
    0.023438671899344621,
    0.017404666458036608,
    0.011073048742008027,
    0.006119679955442734,
    0.003452102862524854,
    0.003088485538867054,
    0.004346036540095017,
    0.006213550866308783,
    0.007747649898185049,
    0.008357597053273951,
    0.007909311931495504,
    0.006654984454614260,
    0.005052311251359929,
    0.003560480869511112,
    0.002487757486378604,
    0.001929817210316224,
    0.001796778081251264,
    0.001896203184651856,
    0.002027920650196086,
    0.002053915313619146,
    0.001925487061952291,
    0.001670408590706237,
    0.001356804583537206,
    0.001054290516976820,
    0.000807790972510786,
    0.000629837142251073,
    0.000508085077057680,
    0.000419784959544385

};
#endif
/*
     * Hilbert 0 Degree, "Phase-added" bandpass filter
     * Kaiser Window FIR Filter, Beta = 5.75, Raised Cosine = 0.91
     * Fc = 2.26 kHz (0.094)
     * BW = 5.18 kHz (0.216)
     * 89 Taps
     *
     * 20140926 by KA7OEI using Iowa Hills Hilbert Filter Designer
     *
     * This filter used in the "5 kHz" RX filter position of the mcHF
*/

const float i_rx_5k_coeffs[I_NUM_TAPS] =
{
    -0.000043426876234221,
    -0.000002191990883891,
    0.000072100444851007,
    0.000146190293613914,
    0.000162704382674571,
    0.000066535363009479,
    -0.000155548384183247,
    -0.000442544978997593,
    -0.000659286380153237,
    -0.000644151194132718,
    -0.000295663946034226,
    0.000338912701649684,
    0.001026081281354910,
    0.001402678737462120,
    0.001129822554695560,
    0.000091825203377056,
    -0.001456726133406820,
    -0.002896198394872420,
    -0.003447955277936570,
    -0.002534414503289770,
    -0.000147860375526197,
    0.002965697373513680,
    0.005459552760619980,
    0.005894146203596460,
    0.003438147321799850,
    -0.001541483020624470,
    -0.007327786088968630,
    -0.011330883354589200,
    -0.011119371587417100,
    -0.005641858261680950,
    0.003903164621667750,
    0.014047162409269700,
    0.020090889315570000,
    0.017969387041418500,
    0.006287588083231960,
    -0.012331139064764000,
    -0.031298832636285500,
    -0.041758619925634300,
    -0.035513772267946100,
    -0.008218535082724620,
    0.038370728643609200,
    0.096051808777281600,
    0.152065307042769000,
    0.192718944802348000,
    0.207569195237242000,
    0.192718944802350000,
    0.152065307042773000,
    0.096051808777286500,
    0.038370728643613700,
    -0.008218535082721400,
    -0.035513772267944600,
    -0.041758619925634400,
    -0.031298832636286800,
    -0.012331139064765700,
    0.006287588083230530,
    0.017969387041417800,
    0.020090889315570100,
    0.014047162409270400,
    0.003903164621668730,
    -0.005641858261680100,
    -0.011119371587416700,
    -0.011330883354589200,
    -0.007327786088968960,
    -0.001541483020624950,
    0.003438147321799410,
    0.005894146203596200,
    0.005459552760619940,
    0.002965697373513800,
    -0.000147860375526001,
    -0.002534414503289590,
    -0.003447955277936450,
    -0.002896198394872390,
    -0.001456726133406850,
    0.000091825203377008,
    0.001129822554695520,
    0.001402678737462110,
    0.001026081281354920,
    0.000338912701649701,
    -0.000295663946034212,
    -0.000644151194132715,
    -0.000659286380153244,
    -0.000442544978997604,
    -0.000155548384183257,
    0.000066535363009474,
    0.000162704382674572,
    0.000146190293613918,
    0.000072100444851011,
    -0.000002191990883889,
    -0.000043426876234222
};

/*
     * Hilbert -90 Degree, "Phase-added" bandpass filter
     * Kaiser Window FIR Filter, Beta = 5.75, Raised Cosine = 0.91
     * Fc = 2.26 kHz (0.094)
     * BW = 5.18 kHz (0.216)
     * 89 Taps
     *
     * 20140926 by KA7OEI using Iowa Hills Hilbert Filter Designer
     *
     * This filter used in the "5 kHz" RX filter position of the mcHF
*/

const float q_rx_5k_coeffs[Q_NUM_TAPS] =
{
    -0.000244980985528691,
    -0.000347789813473586,
    -0.000425078153010145,
    -0.000448763158936282,
    -0.000420322539018952,
    -0.000389284931487302,
    -0.000448339897619816,
    -0.000696509734376426,
    -0.001179343074410010,
    -0.001834241072906750,
    -0.002477976837947990,
    -0.002862517423084040,
    -0.002793753579540190,
    -0.002267579471863340,
    -0.001550226963332890,
    -0.001135646391952200,
    -0.001559764996933380,
    -0.003125748151512350,
    -0.005662072484418450,
    -0.008456129976425170,
    -0.010454737653444400,
    -0.010706772492615500,
    -0.008887126448895160,
    -0.005652790230673340,
    -0.002600407049719820,
    -0.001737597830779160,
    -0.004604577313575180,
    -0.011393047427725000,
    -0.020496815351686600,
    -0.028822018101713000,
    -0.032894718996434200,
    -0.030432401608287900,
    -0.021754675464189900,
    -0.010349616956207100,
    -0.002154904176932250,
    -0.003597919311527080,
    -0.018986944853669100,
    -0.048223040884669100,
    -0.085820731021050400,
    -0.121831672840137000,
    -0.144578590842228000,
    -0.144383936275588000,
    -0.117013881754043000,
    -0.065562309685199800,
    -0.000000000000002786,
    0.065562309685194800,
    0.117013881754040000,
    0.144383936275587000,
    0.144578590842229000,
    0.121831672840140000,
    0.085820731021053400,
    0.048223040884671900,
    0.018986944853670900,
    0.003597919311527760,
    0.002154904176931900,
    0.010349616956206200,
    0.021754675464188900,
    0.030432401608287300,
    0.032894718996434200,
    0.028822018101713400,
    0.020496815351687300,
    0.011393047427725700,
    0.004604577313575620,
    0.001737597830779280,
    0.002600407049719650,
    0.005652790230673030,
    0.008887126448894850,
    0.010706772492615300,
    0.010454737653444300,
    0.008456129976425250,
    0.005662072484418580,
    0.003125748151512460,
    0.001559764996933430,
    0.001135646391952190,
    0.001550226963332840,
    0.002267579471863290,
    0.002793753579540160,
    0.002862517423084040,
    0.002477976837948020,
    0.001834241072906790,
    0.001179343074410040,
    0.000696509734376440,
    0.000448339897619815,
    0.000389284931487292,
    0.000420322539018941,
    0.000448763158936277,
    0.000425078153010148,
    0.000347789813473593,
    0.000244980985528699
};
#if 0
// -89.5 degrees
const float q_rx_5k_coeffs_minus[Q_NUM_TAPS] =
{
    -0.000245350075079331,
    -0.000347795713461264,
    -0.000424433794956601,
    -0.000447472342367739,
    -0.000418888911273699,
    -0.000388690421520361,
    -0.000449678206379025,
    -0.000700339283187546,
    -0.001185042809848820,
    -0.001839784077862940,
    -0.002480458973064010,
    -0.002859455771313040,
    -0.002784707100632570,
    -0.002255271593509290,
    -0.001540323760157880,
    -0.001134803200767200,
    -0.001572398546231340,
    -0.003150864677691160,
    -0.005691900320141490,
    -0.008477891909581240,
    -0.010455629213769400,
    -0.010680525438263900,
    -0.008839218994227760,
    -0.005601218825717410,
    -0.002570351096310890,
    -0.001750963134650860,
    -0.004668251022661230,
    -0.011491343286493200,
    -0.020592922761441300,
    -0.028870082888857800,
    -0.032859461529462900,
    -0.030308850915445600,
    -0.021578793909475900,
    -0.010192653316861700,
    -0.002100037385667660,
    -0.003705226437255490,
    -0.019258937233559700,
    -0.048585061912961300,
    -0.086126912544719800,
    -0.121898658837962000,
    -0.144238772008071000,
    -0.143541538076527000,
    -0.115684465520033000,
    -0.063880622881559600,
    0.001808591785932280,
    0.067239020067275900,
    0.118334416202056000,
    0.145215375200384000,
    0.144907435627121000,
    0.121755439368177000,
    0.085508035386790200,
    0.047857359549391400,
    0.018713511294508700,
    0.003490339090429200,
    0.002209607403007040,
    0.010505795021382500,
    0.021928905758651300,
    0.030553642369399100,
    0.032927479632687100,
    0.028771765616896700,
    0.020399152157911200,
    0.011293886794560300,
    0.004540554100057460,
    0.001724100636811750,
    0.002630265622624950,
    0.005703932567963280,
    0.008934359337826670,
    0.010732206863372900,
    0.010453052539900900,
    0.008433726191758400,
    0.005631814876472510,
    0.003100394369499240,
    0.001547013055708840,
    0.001136403383379810,
    0.001560012498553200,
    0.002279715232556680,
    0.002802588002228120,
    0.002865361799205570,
    0.002475306615233830,
    0.001828558842275610,
    0.001173553822474200,
    0.000692627317902864,
    0.000446967558205752,
    0.000389849893289518,
    0.000421724262730382,
    0.000450019912722868,
    0.000425690246061206,
    0.000347757514953983,
    0.000244593301016048
};
// -90.5 degrees
const float q_rx_5k_coeffs_plus[Q_NUM_TAPS] =
{
    -0.000244593301016044,
    -0.000347757514953983,
    -0.000425690246061212,
    -0.000450019912722880,
    -0.000421724262730398,
    -0.000389849893289530,
    -0.000446967558205751,
    -0.000692627317902845,
    -0.001173553822474160,
    -0.001828558842275570,
    -0.002475306615233800,
    -0.002865361799205570,
    -0.002802588002228160,
    -0.002279715232556760,
    -0.001560012498553270,
    -0.001136403383379820,
    -0.001547013055708770,
    -0.003100394369499090,
    -0.005631814876472300,
    -0.008433726191758220,
    -0.010453052539900900,
    -0.010732206863373000,
    -0.008934359337826910,
    -0.005703932567963560,
    -0.002630265622625130,
    -0.001724100636811690,
    -0.004540554100057090,
    -0.011293886794559600,
    -0.020399152157910500,
    -0.028771765616896300,
    -0.032927479632687100,
    -0.030553642369399700,
    -0.021928905758652200,
    -0.010505795021383400,
    -0.002209607403007430,
    -0.003490339090428610,
    -0.018713511294507000,
    -0.047857359549388800,
    -0.085508035386787300,
    -0.121755439368174000,
    -0.144907435627120000,
    -0.145215375200385000,
    -0.118334416202059000,
    -0.067239020067280800,
    -0.001808591785937680,
    0.063880622881554700,
    0.115684465520030000,
    0.143541538076525000,
    0.144238772008072000,
    0.121898658837964000,
    0.086126912544722800,
    0.048585061912964000,
    0.019258937233561500,
    0.003705226437256110,
    0.002100037385667290,
    0.010192653316860800,
    0.021578793909475000,
    0.030308850915445000,
    0.032859461529462900,
    0.028870082888858200,
    0.020592922761442000,
    0.011491343286493800,
    0.004668251022661610,
    0.001750963134650930,
    0.002570351096310710,
    0.005601218825717120,
    0.008839218994227520,
    0.010680525438263800,
    0.010455629213769400,
    0.008477891909581410,
    0.005691900320141690,
    0.003150864677691320,
    0.001572398546231410,
    0.001134803200767180,
    0.001540323760157820,
    0.002255271593509220,
    0.002784707100632520,
    0.002859455771313040,
    0.002480458973064040,
    0.001839784077862980,
    0.001185042809848850,
    0.000700339283187565,
    0.000449678206379026,
    0.000388690421520349,
    0.000418888911273683,
    0.000447472342367727,
    0.000424433794956595,
    0.000347795713461264,
    0.000245350075079334
};
#endif


/*
     * Hilbert 0 Degree, "Phase-added" bandpass filter
     * Kaiser Window FIR Filter, Beta = 5.75, Raised Cosine = 0.91
     * Fc = 2.26 kHz (0.094)
     * BW = 7.25 kHz (0.302)
     * 89 Taps
     *
     * 20140926 by KA7OEI using Iowa Hills Hilbert Filter Designer
     *
     * This filter used in the "6 kHz" RX filter position of the mcHF
*/

const float i_rx_6k_coeffs[I_NUM_TAPS] =
{
    -0.000022682373717438,
    0.000038238204564056,
    0.000106103474329490,
    0.000112588277224745,
    -0.000001044056524999,
    -0.000220094982327220,
    -0.000424274911375459,
    -0.000434788035699723,
    -0.000139453017934211,
    0.000375971408919194,
    0.000801147757062312,
    0.000749955332343770,
    0.000038057970465913,
    -0.001083544085482150,
    -0.001944999287130160,
    -0.001808699680722850,
    -0.000405941583674816,
    0.001688437310558100,
    0.003186391338558470,
    0.002794418308157900,
    0.000158741803918238,
    -0.003576377418073650,
    -0.006125801172151690,
    -0.005350680308136920,
    -0.000819334976691253,
    0.005395383587742980,
    0.009458815112605070,
    0.007953102693187210,
    0.000355148270524342,
    -0.009820167110937010,
    -0.016337096498702600,
    -0.013745297780700800,
    -0.001267420288973250,
    0.015418941709472400,
    0.026187850069946600,
    0.021884307313133900,
    0.000547853915223056,
    -0.029198332931040700,
    -0.050220164915604400,
    -0.044280778159989200,
    -0.001564103360239580,
    0.072560909705731900,
    0.157505034279737000,
    0.224922981969257000,
    0.250563014502060000,
    0.224922981969261000,
    0.157505034279743000,
    0.072560909705738800,
    -0.001564103360234500,
    -0.044280778159987100,
    -0.050220164915605100,
    -0.029198332931042900,
    0.000547853915220766,
    0.021884307313132800,
    0.026187850069946800,
    0.015418941709473600,
    -0.001267420288971990,
    -0.013745297780700100,
    -0.016337096498702700,
    -0.009820167110937610,
    0.000355148270523721,
    0.007953102693186970,
    0.009458815112605290,
    0.005395383587743470,
    -0.000819334976690837,
    -0.005350680308136820,
    -0.006125801172151940,
    -0.003576377418074090,
    0.000158741803917861,
    0.002794418308157760,
    0.003186391338558600,
    0.001688437310558400,
    -0.000405941583674517,
    -0.001808699680722680,
    -0.001944999287130150,
    -0.001083544085482270,
    0.000038057970465767,
    0.000749955332343670,
    0.000801147757062286,
    0.000375971408919226,
    -0.000139453017934159,
    -0.000434788035699684,
    -0.000424274911375447,
    -0.000220094982327228,
    -0.000001044056525015,
    0.000112588277224733,
    0.000106103474329485,
    0.000038238204564058,
    -0.000022682373717435
};

/*
     * Hilbert -90 Degree, "Phase-added" bandpass filter
     * Kaiser Window FIR Filter, Beta = 5.75, Raised Cosine = 0.91
     * Fc = 2.26 kHz (0.094)
     * BW = 7.25 kHz (0.302)
     * 89 Taps
     *
     * 2015024 by KA7OEI using Iowa Hills Hilbert Filter Designer
     *
     * This filter used in the "6 kHz" RX filter position of the mcHF
*/

const float q_rx_6k_coeffs[Q_NUM_TAPS] =
{
    -0.000251931484270499,
    -0.000330908629757323,
    -0.000355443802758868,
    -0.000326647521596476,
    -0.000313056072482740,
    -0.000429999933656398,
    -0.000761888781710813,
    -0.001268763017888730,
    -0.001753908973141430,
    -0.001951950810461460,
    -0.001718905571331460,
    -0.001209709663176470,
    -0.000889821694094009,
    -0.001301280134404110,
    -0.002671986166595300,
    -0.004617141299020820,
    -0.006201300063194040,
    -0.006443887420058640,
    -0.005037296305177990,
    -0.002807028332953210,
    -0.001485414108910350,
    -0.002748574672629210,
    -0.006995936221018900,
    -0.012682276326935200,
    -0.016844647126325300,
    -0.016787345388718400,
    -0.012052658960439200,
    -0.005370615878111070,
    -0.001655153218315580,
    -0.005231374836071520,
    -0.016740015287944800,
    -0.031739396789423500,
    -0.042370369607316100,
    -0.041739570722183300,
    -0.028820366700062200,
    -0.010846846796045200,
    -0.001106937113796690,
    -0.012453220056498800,
    -0.049497158956864000,
    -0.103757451754876000,
    -0.155023969685509000,
    -0.179173770261190000,
    -0.159159400457769000,
    -0.093838603694072800,
    -0.000000000000004019,
    0.093838603694066000,
    0.159159400457765000,
    0.179173770261190000,
    0.155023969685512000,
    0.103757451754880000,
    0.049497158956867900,
    0.012453220056500900,
    0.001106937113796700,
    0.010846846796043900,
    0.028820366700060700,
    0.041739570722182600,
    0.042370369607316400,
    0.031739396789424500,
    0.016740015287945900,
    0.005231374836072130,
    0.001655153218315570,
    0.005370615878110630,
    0.012052658960438800,
    0.016787345388718200,
    0.016844647126325500,
    0.012682276326935600,
    0.006995936221019260,
    0.002748574672629360,
    0.001485414108910250,
    0.002807028332952960,
    0.005037296305177730,
    0.006443887420058500,
    0.006201300063194050,
    0.004617141299020940,
    0.002671986166595440,
    0.001301280134404200,
    0.000889821694094027,
    0.001209709663176440,
    0.001718905571331410,
    0.001951950810461430,
    0.001753908973141430,
    0.001268763017888750,
    0.000761888781710832,
    0.000429999933656409,
    0.000313056072482743,
    0.000326647521596474,
    0.000355443802758867,
    0.000330908629757325,
    0.000251931484270503
};
#if 0
// -89.5 degrees
const float q_rx_6k_coeffs_minus[Q_NUM_TAPS] =
{
    -0.000252119559524393,
    -0.000330562893588455,
    -0.000354505810723617,
    -0.000325654118935668,
    -0.000313053288650705,
    -0.000431901349565525,
    -0.000765556665694554,
    -0.001272503268394990,
    -0.001755057494010780,
    -0.001948600811246920,
    -0.001711859763358530,
    -0.001203129230539380,
    -0.000889456316800921,
    -0.001310671902121530,
    -0.002688831958909410,
    -0.004632725662095390,
    -0.006204601771576450,
    -0.006428931147220710,
    -0.005009341418180730,
    -0.002782573433277790,
    -0.001483974583790400,
    -0.002779632107550740,
    -0.007049046141172680,
    -0.012728416647282000,
    -0.016851146890332900,
    -0.016739697145158900,
    -0.011969784850311300,
    -0.005301114957808450,
    -0.001651995919482920,
    -0.005316741530465360,
    -0.016881728623410900,
    -0.031857957976292400,
    -0.042379804897882500,
    -0.041603638084121000,
    -0.028591092544637400,
    -0.010655752456709900,
    -0.001102121534727870,
    -0.012707158806809600,
    -0.049932859589912200,
    -0.104139341976065000,
    -0.155031714675862000,
    -0.178534731518110000,
    -0.157780984823797000,
    -0.091875239968751500,
    0.002183209546739060,
    0.095794844803425300,
    0.160525735442180000,
    0.179799209207323000,
    0.155004457936518000,
    0.103367686049051000,
    0.049057701349178400,
    0.012198336071495000,
    0.001111668673201480,
    0.011037117828967000,
    0.029047453307975200,
    0.041872335208535800,
    0.042357718285617900,
    0.031618426492388800,
    0.016597031337877600,
    0.005145611065502340,
    0.001658184886328200,
    0.005439709153447610,
    0.012134618239594000,
    0.016833719425186700,
    0.016836868805862700,
    0.012635173385873600,
    0.006942295289479610,
    0.002717308613100630,
    0.001486740886889630,
    0.002831270171222710,
    0.005064868847109580,
    0.006458354583579070,
    0.006197527658562170,
    0.004601206481836660,
    0.002654937562958780,
    0.001291789595836720,
    0.000890119531398750,
    0.001216198275421750,
    0.001725820909500050,
    0.001955152651077570,
    0.001752627325610380,
    0.001264926464673720,
    0.000758163068209342,
    0.000428065879533683,
    0.000313035094471666,
    0.000327616130784664,
    0.000356354815602149,
    0.000331229249023390,
    0.000251724286702972
};
// -90.5 degrees
const float q_rx_6k_coeffs_plus[Q_NUM_TAPS] =
{
    -0.000251724286702971,
    -0.000331229249023393,
    -0.000356354815602158,
    -0.000327616130784674,
    -0.000313035094471670,
    -0.000428065879533675,
    -0.000758163068209321,
    -0.001264926464673700,
    -0.001752627325610380,
    -0.001955152651077590,
    -0.001725820909500100,
    -0.001216198275421790,
    -0.000890119531398752,
    -0.001291789595836650,
    -0.002654937562958660,
    -0.004601206481836540,
    -0.006197527658562120,
    -0.006458354583579150,
    -0.005064868847109760,
    -0.002831270171222870,
    -0.001486740886889640,
    -0.002717308613100390,
    -0.006942295289479190,
    -0.012635173385873200,
    -0.016836868805862600,
    -0.016833719425187000,
    -0.012134618239594600,
    -0.005439709153448130,
    -0.001658184886328270,
    -0.005145611065501760,
    -0.016597031337876600,
    -0.031618426492387800,
    -0.042357718285617600,
    -0.041872335208536500,
    -0.029047453307976600,
    -0.011037117828968300,
    -0.001111668673201590,
    -0.012198336071493100,
    -0.049057701349174600,
    -0.103367686049046000,
    -0.155004457936514000,
    -0.179799209207323000,
    -0.160525735442183000,
    -0.095794844803431900,
    -0.002183209546746930,
    0.091875239968744800,
    0.157780984823794000,
    0.178534731518110000,
    0.155031714675865000,
    0.104139341976070000,
    0.049932859589916000,
    0.012707158806811500,
    0.001102121534727800,
    0.010655752456708600,
    0.028591092544635900,
    0.041603638084120300,
    0.042379804897882800,
    0.031857957976293400,
    0.016881728623412000,
    0.005316741530465960,
    0.001651995919482860,
    0.005301114957807940,
    0.011969784850310700,
    0.016739697145158700,
    0.016851146890333000,
    0.012728416647282400,
    0.007049046141173090,
    0.002779632107550980,
    0.001483974583790400,
    0.002782573433277620,
    0.005009341418180540,
    0.006428931147220630,
    0.006204601771576490,
    0.004632725662095510,
    0.002688831958909540,
    0.001310671902121600,
    0.000889456316800921,
    0.001203129230539330,
    0.001711859763358480,
    0.001948600811246900,
    0.001755057494010780,
    0.001272503268395010,
    0.000765556665694575,
    0.000431901349565534,
    0.000313053288650701,
    0.000325654118935657,
    0.000354505810723609,
    0.000330562893588452,
    0.000252119559524394
};
#endif

/*
     * Hilbert 0 Degree, "Phase-added" bandpass filter
     * Kaiser Window FIR Filter, Beta = 5.75, Raised Cosine = 0.91
     * Fc = 2.26 kHz (0.094)
     * BW = 10.3 kHz (0.428)
     * 89 Taps
     *
     * 20140926 by KA7OEI using Iowa Hills Hilbert Filter Designer
     *
     * This filter used in the "7.5 kHz" RX filter position of the mcHF
*/

const float i_rx_7k5_coeffs[I_NUM_TAPS] =
{
    -0.000047152981653544,
    -0.000110026565186158,
    -0.000095405108317349,
    0.000037624035064354,
    0.000192202262504789,
    0.000171234872189907,
    -0.000122839931661074,
    -0.000499087466789727,
    -0.000554573184328879,
    -0.000060588292528025,
    0.000668772060340029,
    0.000888593187081358,
    0.000102515515551741,
    -0.001249921161362290,
    -0.001903095045735830,
    -0.000868621193042000,
    0.001346264630606470,
    0.002745142468753870,
    0.001509633500856800,
    -0.001948801772718740,
    -0.004687224218310920,
    -0.003581927332951620,
    0.001381645765114430,
    0.006138876544307210,
    0.005629613782664030,
    -0.001162538364411810,
    -0.008986602959997310,
    -0.010039404665373800,
    -0.001363884161919830,
    0.010763050651804400,
    0.014785374341762900,
    0.004299482561992500,
    -0.013990436914319800,
    -0.023502567244261900,
    -0.011858171107267000,
    0.015392025256479800,
    0.035034901926729100,
    0.023919333282717500,
    -0.018102510217819800,
    -0.059883515107186500,
    -0.056272796648812800,
    0.018325151509416600,
    0.144877690937171000,
    0.264565982473051000,
    0.313582971052170000,
    0.264565982473059000,
    0.144877690937182000,
    0.018325151509425500,
    -0.056272796648809600,
    -0.059883515107188600,
    -0.018102510217823600,
    0.023919333282715300,
    0.035034901926729700,
    0.015392025256481900,
    -0.011858171107265400,
    -0.023502567244262100,
    -0.013990436914321200,
    0.004299482561991270,
    0.014785374341762900,
    0.010763050651805400,
    -0.001363884161918720,
    -0.010039404665373400,
    -0.008986602959997760,
    -0.001162538364412480,
    0.005629613782663730,
    0.006138876544307410,
    0.001381645765114760,
    -0.003581927332951560,
    -0.004687224218311200,
    -0.001948801772719100,
    0.001509633500856680,
    0.002745142468754090,
    0.001346264630606850,
    -0.000868621193041729,
    -0.001903095045735810,
    -0.001249921161362460,
    0.000102515515551548,
    0.000888593187081267,
    0.000668772060340053,
    -0.000060588292527955,
    -0.000554573184328831,
    -0.000499087466789723,
    -0.000122839931661093,
    0.000171234872189892,
    0.000192202262504788,
    0.000037624035064360,
    -0.000095405108317345,
    -0.000110026565186159,
    -0.000047152981653547
};

/*
     * Hilbert -90 Degree, "Phase-added" bandpass filter
     * Kaiser Window FIR Filter, Beta = 5.75, Raised Cosine = 0.91
     * Fc = 2.26 kHz (0.094)
     * BW = 10.3 kHz (0.428)
     * 89 Taps
     *
     * 20140926 by KA7OEI using Iowa Hills Hilbert Filter Designer
     *
     * This filter used in the "7.5 kHz" RX filter position of the mcHF
*/

const float q_rx_7k5_coeffs[Q_NUM_TAPS] =
{
    -0.000133595279188198,
    -0.000253972242871366,
    -0.000442545455235918,
    -0.000592592284809786,
    -0.000587055756238391,
    -0.000457170027500299,
    -0.000440303172549739,
    -0.000798568465950172,
    -0.001501377028825590,
    -0.002106464668726340,
    -0.002090107815922980,
    -0.001437536607000670,
    -0.000898653089024334,
    -0.001455904767136920,
    -0.003296512147539410,
    -0.005281194636582230,
    -0.005712890873894510,
    -0.004021025686443730,
    -0.001799862475721100,
    -0.001819377846194110,
    -0.005416009112775160,
    -0.010590298464491200,
    -0.013102216019464600,
    -0.010305729741534800,
    -0.004435935421679130,
    -0.001691310784615620,
    -0.006883047317184000,
    -0.018038824577509000,
    -0.026587943020900400,
    -0.024440252192639000,
    -0.012481221311433700,
    -0.002135321175753430,
    -0.006594500183516430,
    -0.027916772436847000,
    -0.051907804110099400,
    -0.057941239196375800,
    -0.037989054141423800,
    -0.008835563742366440,
    -0.004078456301562180,
    -0.048153772208588900,
    -0.131295651447913000,
    -0.207233490631282000,
    -0.219903476590932000,
    -0.142459128885576000,
    -0.000000000000006192,
    0.142459128885566000,
    0.219903476590929000,
    0.207233490631286000,
    0.131295651447920000,
    0.048153772208594400,
    0.004078456301563800,
    0.008835563742364790,
    0.037989054141421400,
    0.057941239196375100,
    0.051907804110100700,
    0.027916772436849000,
    0.006594500183517550,
    0.002135321175753080,
    0.012481221311432500,
    0.024440252192638200,
    0.026587943020900600,
    0.018038824577509800,
    0.006883047317184820,
    0.001691310784615810,
    0.004435935421678740,
    0.010305729741534300,
    0.013102216019464400,
    0.010590298464491400,
    0.005416009112775470,
    0.001819377846194210,
    0.001799862475720930,
    0.004021025686443450,
    0.005712890873894360,
    0.005281194636582280,
    0.003296512147539580,
    0.001455904767137060,
    0.000898653089024365,
    0.001437536607000610,
    0.002090107815922920,
    0.002106464668726330,
    0.001501377028825620,
    0.000798568465950211,
    0.000440303172549752,
    0.000457170027500285,
    0.000587055756238372,
    0.000592592284809780,
    0.000442545455235928,
    0.000253972242871382,
    0.000133595279188209
};
#if 0
// -89.5 degrees
const float q_rx_7k5_coeffs_minus[Q_NUM_TAPS] =
{
    -0.000134001024940524,
    -0.000254921199404569,
    -0.000443359870591047,
    -0.000592242009892187,
    -0.000585358949866752,
    -0.000455660823996473,
    -0.000441356695083438,
    -0.000802886402021266,
    -0.001506151714670980,
    -0.002106912624599590,
    -0.002084201940823820,
    -0.001429740326723390,
    -0.000897725845247537,
    -0.001466739301382700,
    -0.003312967543520600,
    -0.005288562030468290,
    -0.005700945003578050,
    -0.003996956468819650,
    -0.001786641722089340,
    -0.001836287492596350,
    -0.005456640444551370,
    -0.010621103756696200,
    -0.013089681572959700,
    -0.010251854665998400,
    -0.004386719905426480,
    -0.001701375077883580,
    -0.006961080739467940,
    -0.018125607181637900,
    -0.026598817027985300,
    -0.024345553427801700,
    -0.012351932286375100,
    -0.002097781520891650,
    -0.006716139765437990,
    -0.028120476256430500,
    -0.052009147605571400,
    -0.057804940228451400,
    -0.037682376229559600,
    -0.008626834662089420,
    -0.004236017204200000,
    -0.048673672304265800,
    -0.131780939569822000,
    -0.207065973624334000,
    -0.218632907385753000,
    -0.140148729890875000,
    0.002732048389496730,
    0.144758719163609000,
    0.221157361190571000,
    0.207385284334998000,
    0.130800401609229000,
    0.047630218570432100,
    0.003920585956639520,
    0.009043622447175150,
    0.038292849732401600,
    0.058073142023159400,
    0.051802522244716200,
    0.027710950504613600,
    0.006472360261010290,
    0.002172698818662760,
    0.012609563356218600,
    0.024533096616774000,
    0.026575051722646700,
    0.017950673324385100,
    0.006804491661550330,
    0.001681118167531780,
    0.004484814372844550,
    0.010358822896574700,
    0.013113756369335100,
    0.010558689660877100,
    0.005374966855364830,
    0.001802330159220000,
    0.001812946669458800,
    0.004044789819179960,
    0.005724403293443320,
    0.005273426545760270,
    0.003279806637255140,
    0.001444959769895800,
    0.000899512149830445,
    0.001445223817918900,
    0.002095855109516330,
    0.002105856890313580,
    0.001496488429894920,
    0.000794189940569412,
    0.000439216243155622,
    0.000458644544414838,
    0.000588708021278182,
    0.000592897598325816,
    0.000441697462892989,
    0.000253004016853425,
    0.000133179397240816
};
// -90.5 degrees
const float q_rx_7k5_coeffs_plus[Q_NUM_TAPS] =
{
    -0.000133179397240812,
    -0.000253004016853418,
    -0.000441697462892984,
    -0.000592897598325822,
    -0.000588708021278203,
    -0.000458644544414859,
    -0.000439216243155620,
    -0.000794189940569378,
    -0.001496488429894880,
    -0.002105856890313570,
    -0.002095855109516380,
    -0.001445223817918970,
    -0.000899512149830458,
    -0.001444959769895710,
    -0.003279806637254990,
    -0.005273426545760190,
    -0.005724403293443410,
    -0.004044789819180170,
    -0.001812946669458930,
    -0.001802330159219850,
    -0.005374966855364440,
    -0.010558689660876700,
    -0.013113756369335100,
    -0.010358822896575100,
    -0.004484814372844990,
    -0.001681118167531720,
    -0.006804491661549630,
    -0.017950673324384200,
    -0.026575051722646500,
    -0.024533096616774800,
    -0.012609563356219700,
    -0.002172698818663180,
    -0.006472360261009240,
    -0.027710950504611600,
    -0.051802522244714800,
    -0.058073142023160100,
    -0.038292849732404000,
    -0.009043622447177020,
    -0.003920585956638160,
    -0.047630218570426700,
    -0.130800401609222000,
    -0.207385284334994000,
    -0.221157361190573000,
    -0.144758719163619000,
    -0.002732048389509060,
    0.140148729890866000,
    0.218632907385750000,
    0.207065973624338000,
    0.131780939569829000,
    0.048673672304271200,
    0.004236017204201430,
    0.008626834662087570,
    0.037682376229557100,
    0.057804940228450700,
    0.052009147605572700,
    0.028120476256432500,
    0.006716139765439060,
    0.002097781520891260,
    0.012351932286373900,
    0.024345553427800900,
    0.026598817027985500,
    0.018125607181638700,
    0.006961080739468650,
    0.001701375077883650,
    0.004386719905426040,
    0.010251854665997900,
    0.013089681572959700,
    0.010621103756696500,
    0.005456640444551760,
    0.001836287492596500,
    0.001786641722089220,
    0.003996956468819430,
    0.005700945003577960,
    0.005288562030468370,
    0.003312967543520750,
    0.001466739301382800,
    0.000897725845247525,
    0.001429740326723320,
    0.002084201940823770,
    0.002106912624599590,
    0.001506151714671020,
    0.000802886402021300,
    0.000441356695083440,
    0.000455660823996452,
    0.000585358949866732,
    0.000592242009892181,
    0.000443359870591052,
    0.000254921199404576,
    0.000134001024940527
};
#endif

/*
     * Hilbert 0 Degree, "Phase-added" bandpass filter
     * Kaiser Window FIR Filter, Beta = 5.75, Raised Cosine = 0.91
     * Fc = 2.26 kHz
     * BW = 15.5 kHz
     * 89 Taps
     *
     * 20140926 by KA7OEI using Iowa Hills Hilbert Filter Designer
     *
     * This filter used in the "10 kHz" RX filter position of the mcHF
*/

const float i_rx_10k_coeffs[I_NUM_TAPS] =
{
    0.000050167609691425,
    0.000025603407918848,
    -0.000118981585848916,
    -0.000170474191765324,
    0.000048296523157148,
    0.000256073107769974,
    727.2794187150840E-9,
    -0.000501261183059805,
    -0.000408327227464192,
    0.000402666023236487,
    0.000712863881140397,
    -0.0003308411712395,
    -0.0013996330569958,
    -0.000528641700743514,
    0.001455738736932886,
    0.001329912986372006,
    -0.00150961605426034,
    -0.00294679909039784,
    0.000076369628754364,
    0.003654850522527691,
    0.001577905576333736,
    -0.00432377051231776,
    -0.00486833805524385,
    0.002504357924698762,
    0.007219173741633013,
    0.000249124314985597,
    -0.00964993129867818,
    -0.00614913866004667,
    0.008394400456713639,
    0.011847880245809284,
    -0.00485256342855596,
    -0.018458064255265,
    -0.00458695963656225,
    0.020574362746561586,
    0.016624349270928814,
    -0.0185108281915374,
    -0.0333393467458619,
    0.005438341796513525,
    0.049039677508405620,
    0.020261414347031232,
    -0.0646569743752001,
    -0.0780052456437194,
    0.073784359346471568,
    0.307733691067162585,
    0.421541346382627025,
    0.307733691067179571,
    0.073784359346490025,
    -0.0780052456437136,
    -0.0646569743752061,
    0.020261414347025011,
    0.049039677508406654,
    0.005438341796518410,
    -0.0333393467458602,
    -0.01851082819154,
    0.016624349270926188,
    0.020574362746562019,
    -0.00458695963656039,
    -0.0184580642552646,
    -0.00485256342855692,
    0.011847880245808904,
    0.008394400456714472,
    -0.00614913866004598,
    -0.00964993129867861,
    0.000249124314984851,
    0.007219173741633126,
    0.002504357924699511,
    -0.00486833805524365,
    -0.00432377051231848,
    0.001577905576332938,
    0.003654850522527679,
    0.000076369628754987,
    -0.00294679909039735,
    -0.00150961605426035,
    0.001329912986371784,
    0.001455738736932826,
    -0.000528641700743405,
    -0.00139963305699574,
    -0.000330841171239577,
    0.000712863881140276,
    0.000402666023236442,
    -0.000408327227464152,
    -0.000501261183059743,
    727.2794187481990E-9,
    0.000256073107769969,
    0.000048296523157126,
    -0.000170474191765341,
    -0.000118981585848918,
    0.000025603407918855,
    0.000050167609691430
};

/*
     * Hilbert -90 Degree, "Phase-added" bandpass filter
     * Kaiser Window FIR Filter, Beta = 5.75, Raised Cosine = 0.91
     * Fc = 2.26 kHz
     * BW = 15.5 kHz
     * 89 Taps
     *
     * 20141203 by KA7OEI using Iowa Hills Hilbert Filter Designer
     *
     * This filter used in the "10 kHz" RX filter position of the mcHF
*/

const float q_rx_10k_coeffs[Q_NUM_TAPS] =
{
    -0.000202900475979562,
    -0.000173370254281575,
    -0.000251467848218534,
    -0.000530209040093422,
    -0.000755557012438407,
    -0.000632374975698963,
    -0.000435867293262139,
    -0.000804201474014394,
    -0.00164940424331115,
    -0.00193021734962449,
    -0.00121363387572673,
    -0.000827414291001747,
    -0.00214132611477666,
    -0.00398311091636951,
    -0.00375800964604182,
    -0.00170956409649301,
    -0.00159310443682755,
    -0.00512041852752827,
    -0.00810303580432126,
    -0.00596383822011149,
    -0.00184365603740688,
    -0.00353215000807175,
    -0.011105278808909,
    -0.0144091536349107,
    -0.00787569655878985,
    -0.00166604723989226,
    -0.00846845978512414,
    -0.0221224254196474,
    -0.023076026543239,
    -0.00860670786722982,
    -0.00220735820377942,
    -0.0202780169273636,
    -0.0419593783021394,
    -0.0347864243458702,
    -0.00746038335985415,
    -0.0070912420573716,
    -0.0499177285061674,
    -0.0837979289134878,
    -0.0556417465085305,
    -0.00435630169851503,
    -0.0347123686687518,
    -0.174525192240834,
    -0.297300969432227,
    -0.240504142849254,
    -11.10456311493300E-15,
    0.240504142849240932,
    0.297300969432230666,
    0.174525192240846311,
    0.034712368668759118,
    0.004356301698513016,
    0.055641746508526303,
    0.083797928913488418,
    0.049917728506171426,
    0.007091242057373439,
    0.007460383359852207,
    0.034786424345868192,
    0.041959378302140228,
    0.020278016927365760,
    0.002207358203779885,
    0.008606707867228393,
    0.023076026543238051,
    0.022122425419648251,
    0.008468459785125408,
    0.001666047239892347,
    0.007875696558789036,
    0.014409153634910375,
    0.011105278808909548,
    0.003532150008072225,
    0.001843656037406619,
    0.005963838220110922,
    0.008103035804321144,
    0.005120418527528628,
    0.001593104436827793,
    0.001709564096492843,
    0.003758009646041539,
    0.003983110916369502,
    0.002141326114776900,
    0.000827414291001932,
    0.001213633875726693,
    0.001930217349624349,
    0.001649404243311083,
    0.000804201474014432,
    0.000435867293262205,
    0.000632374975698988,
    0.000755557012438391,
    0.000530209040093399,
    0.000251467848218528,
    0.000173370254281586,
    0.000202900475979578,
};
#if 0
//
// Same as above, but set to -89.50 degrees
//
const float q_rx_10k_coeffs_minus[Q_NUM_TAPS] =
{
    -0.000202455664859704,
    -0.000173140592204385,
    -0.000252494994779958,
    -0.000531674265269795,
    -0.000755107532054849,
    -0.000630119807793623,
    -0.000435844416269303,
    -0.000808538456205254,
    -0.00165289941631983,
    -0.00192663566416262,
    -0.00120737662217022,
    -0.000830265518962948,
    -0.00215343989019978,
    -0.00398756583310063,
    -0.00374518315395325,
    -0.00169791166090659,
    -0.0016061973003426,
    -0.00514589974511933,
    -0.00810206290191975,
    -0.00593176711182757,
    -0.00182983774837564,
    -0.00356968907954881,
    -0.0111472753261672,
    -0.014386786313359,
    -0.00781249687222602,
    -0.00166381339141727,
    -0.00855221849211168,
    -0.0221751635049472,
    -0.0230020102615523,
    -0.00850315041764785,
    -0.0022495549325951,
    -0.0204380729464628,
    -0.0419977523187501,
    -0.0346058393982551,
    -0.00731525192982586,
    -0.00725225821850147,
    -0.0502063207098376,
    -0.0837473645759942,
    -0.0552123512270397,
    -0.00417959823251785,
    -0.0352744090683207,
    -0.175198230840336,
    -0.296646802759013,
    -0.23781372575567,
    0.003672899131290362,
    0.243176306751765409,
    0.297932572288734043,
    0.173838907958167449,
    0.034147693755331297,
    0.004532674540653624,
    0.056066918829789127,
    0.083842133362171958,
    0.049625347769692935,
    0.006929687702619956,
    0.007604948580079531,
    0.034964369159129032,
    0.041917819755983292,
    0.020116421897283545,
    0.002164993946328076,
    0.008709612106095409,
    0.023148291457499595,
    0.022068008340992647,
    0.008384058359835342,
    0.001668154642817476,
    0.007938298515133682,
    0.014430427366009982,
    0.011062439450553222,
    0.003494342862173716,
    0.001857334401172949,
    0.005995456699690846,
    0.008103393722469368,
    0.005094548693024019,
    0.001579890663796087,
    0.001721086783794211,
    0.003770550921970162,
    0.003978353699296656,
    0.002129049822258510,
    0.000824500265988833,
    0.001219799019888545,
    0.001933652540204042,
    0.001645783887881715,
    0.000799803456520885,
    0.000435857089872780,
    0.000634582149165994,
    0.000755949149416795,
    0.000528703574417232,
    0.000250421616369738,
    0.000173586758330236,
    0.000203329887858864
};
//
//
// Same as above, but set to -90.50 degrees
//
const float q_rx_10k_coeffs_plus[Q_NUM_TAPS] =
{
    -0.000203329887858879,
    -0.000173586758330246,
    -0.000250421616369715,
    -0.000528703574417194,
    -0.000755949149416803,
    -0.000634582149166068,
    -0.000435857089872831,
    -0.000799803456520821,
    -0.0016457838878816,
    -0.00193365254020404,
    -0.00121979901988869,
    -0.000824500265988919,
    -0.00212904982225838,
    -0.00397835369929647,
    -0.00377055092197019,
    -0.0017210867837944,
    -0.00157989066379611,
    -0.0050945486930238,
    -0.00810339372246924,
    -0.00599545669969104,
    -0.0018573344011731,
    -0.00349434286217341,
    -0.0110624394505528,
    -0.0144304273660101,
    -0.00793829851513429,
    -0.00166815464281749,
    -0.00838405835983441,
    -0.022068008340992,
    -0.0231482914575004,
    -0.00870961210609662,
    -0.00216499394632763,
    -0.0201164218972816,
    -0.0419178197559826,
    -0.034964369159131,
    -0.00760494858008132,
    -0.00692968770261807,
    -0.049625347769689,
    -0.0838421333621716,
    -0.0560669188297936,
    -0.00453267454065583,
    -0.0341476937553239,
    -0.173838907958155,
    -0.29793257228873,
    -0.243176306751779,
    -0.00367289913131262,
    0.237813725755656402,
    0.296646802759017059,
    0.175198230840349134,
    0.035274409068328134,
    0.004179598232515747,
    0.055212351227035175,
    0.083747364575994507,
    0.050206320709841545,
    0.007252258218503405,
    0.007315251929824108,
    0.034605839398253145,
    0.041997752318750713,
    0.020438072946464797,
    0.002249554932595578,
    0.008503150417646649,
    0.023002010261551485,
    0.022175163504947821,
    0.008552218492112613,
    0.001663813391417275,
    0.007812496872225425,
    0.014386786313358855,
    0.011147275326167612,
    0.003569689079549125,
    0.001829837748375495,
    0.005931767111827379,
    0.008102062901919874,
    0.005145899745119554,
    0.001606197300342580,
    0.001697911660906403,
    0.003745183153953228,
    0.003987565833100819,
    0.002153439890199912,
    0.000830265518962865,
    0.001207376622170074,
    0.001926635664162619,
    0.001652899416319948,
    0.000808538456205320,
    0.000435844416269254,
    0.000630119807793549,
    0.000755107532054840,
    0.000531674265269833,
    0.000252494994779981,
    0.000173140592204375,
    0.000202455664859689
};

#endif

