/*  -*-  mode: c; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4; coding: utf-8  -*-  */
/************************************************************************************
**                                                                                 **
**                               mcHF QRP Transceiver                              **
**                             K Atanassov - M0NKA 2014                            **
**                                                                                 **
**---------------------------------------------------------------------------------**
**                                                                                 **
**  File name:                                                                     **
**  Description:                                                                   **
**  Last Modified:                                                                 **
**  Licence:		CC BY-NC-SA 3.0                                                **
************************************************************************************/

#include "filters.h"
//
// Filter designed 20141202 by C. Turner, KA7OEI using MatLAB fdatools
//
// NOTE:
//	- IIR structure is Lattice Autoregressive Moving-Average (ARMA)
//	- ARM FIR/IIR algorithms require time reverse-order coefficients!!!
//
// *** 12 KSPS Sample Rate!
//
//	Nominal 750 Hz center-frequency Filter:
//
//	10th order Least pth Norm. bandpass filter
//	Fstop:  500, 990 Hz
//	Fpass:  613, 885 Hz
//	-6dB points:  600, 895 Hz
//	-20dB points:  577, 918
//	-40dB points:  529, 962
//	-55dB points:  500, 990
//
#define IIR_300hz_numStages 10
const arm_iir_lattice_instance_f32 IIR_300hz_750 =
{
    .numStages = IIR_300hz_numStages,
    .pkCoeffs  = (float*) (const float[])
    {
        0.8420268438333,
        -0.9187411389087,
        0.991915422724,
        -0.9269206024542,
        0.9959665495021,
        -0.9250959581619,
        0.9968373894352,
        -0.9220079563995,
        0.9954523801454,
        -0.9320568982728
    },

    .pvCoeffs = (float*) (const float[])
    {
        -2.528177681235e-05,
        -0.0001284428108467,
        -0.0001826561498698,
        -4.680324147403e-05,
        -1.767058952639e-05,
        2.328514864098e-05,
        7.242100694031e-06,
        9.825932471565e-07,
        -2.827695963598e-07,
        -2.141975226444e-07,
        9.808568488673e-09
    }
};
//
// 800 Hz center frequency
//
const arm_iir_lattice_instance_f32 IIR_300hz_800 =
{
    .numStages = IIR_300hz_numStages,
    .pkCoeffs  = (float*) (const float[])
    {
        0.8503130225593,
        -0.9089732054814,
        0.9923678320648,
        -0.9163668504916,
        0.9961126531134,
        -0.9147111704054,
        0.9969873803036,
        -0.9116164217019,
        0.9952780046244,
        -0.9213976892508
    },

    .pvCoeffs = (float*) (const float[])
    {
        1.33337610067e-06,
        7.453841937241e-05,
        0.0003852357535482,
        4.561173005598e-05,
        2.120264803625e-05,
        -2.713243679097e-05,
        -9.643727863849e-06,
        -9.410145539752e-07,
        3.219855720009e-07,
        2.507913128879e-07,
        -1.339507149753e-08
    }
};
//
// 850 Hz center frequency
//
const arm_iir_lattice_instance_f32 IIR_300hz_850 =
{
    .numStages = IIR_300hz_numStages,
    .pkCoeffs  = (float*) (const float[])
    {
        0.8619678311814,
        -0.8987132900478,
        0.9929800321291,
        -0.9050895035197,
        0.9962960753259,
        -0.9035803342684,
        0.9969741855608,
        -0.9009035751952,
        0.9955228844029,
        -0.9102181260169
    },

    .pvCoeffs = (float*) (const float[])
    {
        1.015803230667e-05,
        7.384809547778e-06,
        0.0001261434545558,
        2.625658957163e-05,
        2.179481057242e-05,
        -2.078867283811e-05,
        -8.609229801913e-06,
        -9.671863254622e-07,
        2.923861090205e-07,
        2.778278512409e-07,
        -1.585347732762e-08
    }
};
//
// 900 Hz center frequency
//
const arm_iir_lattice_instance_f32 IIR_300hz_900 =
{
    .numStages = IIR_300hz_numStages,
    .pkCoeffs  = (float*) (const float[])
    {
        0.866224538039,
        -0.887418184529,
        0.9931785952017,
        -0.8934071723653,
        0.9963609345788,
        -0.8919370163031,
        0.9969678377825,
        -0.8895111671316,
        0.9955938946628,
        -0.8983883276963
    },

    .pvCoeffs = (float*) (const float[])
    {
        1.027538145593e-11,
        4.674412003285e-09,
        8.524980293762e-06,
        2.781783244349e-05,
        4.556993427775e-05,
        7.93734646008e-06,
        -1.149365906393e-05,
        -1.373938907669e-06,
        -5.614114019155e-07,
        1.999172180075e-07,
        1.135790394447e-07
    }
};
//
// 950 Hz center frequency
//
const arm_iir_lattice_instance_f32 IIR_300hz_950 =
{
    .numStages = IIR_300hz_numStages,
    .pkCoeffs  = (float*) (const float[])
    {
        0.8663610198931,
        -0.8752991478672,
        0.9931648301256,
        -0.8812152134726,
        0.9963683212431,
        -0.8797440121644,
        0.9969724019188,
        -0.8774017131206,
        0.99556189371,
        -0.8860148099453
    },

    .pvCoeffs = (float*) (const float[])
    {
        1.712527337148e-07,
        -2.14605366217e-06,
        -1.282145120929e-06,
        5.302451577261e-07,
        3.408583271375e-05,
        1.981386748243e-05,
        -9.607488025739e-06,
        -9.045967855846e-07,
        -9.463603260528e-07,
        1.034195562155e-07,
        1.787682064218e-07
    }
};
//
// 700 Hz center frequency
//
const arm_iir_lattice_instance_f32 IIR_300hz_700 =
{
    .numStages = IIR_300hz_numStages,
    .pkCoeffs  = (float*) (const float[])
    {
        0.8591958395778,
        -0.9293736501052,
        0.9929514387125,
        -0.9360907399466,
        0.996226917283,
        -0.9346339462441,
        0.9969482667941,
        -0.931593651892,
        0.9956636725664,
        -0.9417304199344
    },

    .pvCoeffs = (float*) (const float[])
    {
        5.747022992099e-06,
        -7.971034438356e-05,
        0.0001584707032297,
        1.393289629595e-05,
        3.190407921738e-05,
        -1.005193057782e-05,
        -6.474066693983e-06,
        -7.589205344351e-07,
        -1.03047035546e-07,
        1.28510713565e-07,
        1.528611528166e-08
    }
};
//
// 650 Hz center frequency
//
const arm_iir_lattice_instance_f32 IIR_300hz_650 =
{
    .numStages = IIR_300hz_numStages,
    .pkCoeffs  = (float*) (const float[])
    {
        0.8688818948709,
        -0.9388764394749,
        0.9934909324643,
        -0.9448433355565,
        0.9963549863567,
        -0.9435572556818,
        0.9969138747979,
        -0.9403384327629,
        0.9961526396361,
        -0.9518730710222
    },

    .pvCoeffs = (float*) (const float[])
    {
        -2.242398187584e-07,
        -4.638289856856e-06,
        -2.352878220094e-05,
        -3.080709449559e-05,
        -1.553328321254e-07,
        1.417306554582e-05,
        5.642654818196e-07,
        4.823112320132e-07,
        -2.795709228696e-07,
        -6.539576902733e-08,
        1.737131589792e-08
    }
};
//
// 600 Hz center frequency
//
const arm_iir_lattice_instance_f32 IIR_300hz_600 =
{
    .numStages = IIR_300hz_numStages,
    .pkCoeffs  = (float*) (const float[])
    {
        0.8688147751404,
        -0.947241849841,
        0.9935473550788,
        -0.9532141766403,
        0.9963398104956,
        -0.9519739167724,
        0.996893229241,
        -0.9488062379632,
        0.9962691170584,
        -0.960137003826
    },

    .pvCoeffs = (float*) (const float[])
    {
        -1.162998232666e-08,
        2.073677729923e-07,
        3.52975766574e-06,
        1.439908057934e-05,
        1.523851473567e-05,
        -1.145419163814e-05,
        -1.088670924934e-06,
        -5.660706791281e-07,
        8.554810603011e-08,
        6.021304731304e-08,
        -6.066270009946e-09
    }
};
//
// 550 Hz center frequency
//
const arm_iir_lattice_instance_f32 IIR_300hz_550 =
{
    .numStages = IIR_300hz_numStages,
    .pkCoeffs  = (float*) (const float[])
    {
        0.8541670807411,
        -0.9541636396546,
        0.9929236629498,
        -0.9612744078615,
        0.9960967701838,
        -0.9599796643954,
        0.9968957501619,
        -0.956635152364,
        0.9959046900614,
        -0.9670787808963
    },

    .pvCoeffs = (float*) (const float[])
    {
        -2.136357455248e-05,
        0.0001768380226792,
        0.0002313081587989,
        4.090518305717e-05,
        2.238176395873e-05,
        -9.82968044721e-06,
        -3.425509918938e-06,
        -5.382859003672e-07,
        -2.942934157295e-08,
        5.198121348388e-08,
        4.257484469579e-09
    }
};
//
// 500 Hz center frequency
//
const arm_iir_lattice_instance_f32 IIR_300hz_500 =
{
    .numStages = IIR_300hz_numStages,
    .pkCoeffs  = (float*) (const float[])
    {
        0.8575481179465,
        -0.961400641792,
        0.9932114492888,
        -0.9681748236979,
        0.9961324948395,
        -0.9670693014466,
        0.9968413643764,
        -0.9634005824554,
        0.9964042135888,
        -0.9748600915123
    },

    .pvCoeffs = (float*) (const float[])
    {
        -2.891194366311e-07,
        0.0001916459337858,
        0.0002267903341803,
        5.926245389363e-05,
        2.256777174671e-05,
        -7.677432110101e-06,
        -2.587424315593e-06,
        -5.205542423312e-07,
        -2.808725036254e-08,
        3.187553831321e-08,
        2.504925658148e-09
    }
};

