/*  -*-  mode: c; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4; coding: utf-8  -*-  */
/************************************************************************************
 **                                                                                 **
 **                               mcHF QRP Transceiver                              **
 **                             K Atanassov - M0NKA 2014                            **
 **                                                                                 **
 **---------------------------------------------------------------------------------**
 **                                                                                 **
 **  File name:                                                                     **
 **  Description:                                                                   **
 **  Last Modified:                                                                 **
 **  Licence:		CC BY-NC-SA 3.0                                                **
 ************************************************************************************/

#include "filters.h"
#include "iq_tx_filter.h"

#if 1
/*
 * Hilbert 0/90 Degree, "Phase-added" bandpass filter
 * Kaiser Window FIR Filter, Beta = 3.25, Raised Cosine = 9.30
 * Fc = 1.68 kHz
 * BW = 2.40 kHz
 * 89 Taps
 * -1dB @ 809, 2570 Hz
 * -3dB @ 562, 2790 Hz
 * -6dB @ 363, 3000 Hz
 *
 * 20140926 by KA7OEI using Iowa Hills Hilbert Filter Designer
 */
const IQ_FilterDescriptor iq_tx_narrow =
{
        .num_taps = IQ_TX_NUM_TAPS,

        .i =
                (const float32_t[]){
            -0.00136963387867902,
            -0.00154698180275283,
            -0.00159163053382545,
            -0.00147741661877843,
            -0.00120882701502872,
            -0.000828478315201928,
            -0.000418097593646548,
            -0.000091320092875327,
            0.000021974130050419,
            -0.000201673787010635,
            -0.000852848114713485,
            -0.00196364687958346,
            -0.00348826112570551,
            -0.00529485706179518,
            -0.00717256931124521,
            -0.00885513209567824,
            -0.0100597130451815,
            -0.0105363454629951,
            -0.0101205604704021,
            -0.00877998921294567,
            -0.00664532045021418,
            -0.0040173326042396,
            -0.00134475617619414,
            0.000827871099573030,
            0.001938042460603026,
            0.001499434597820090,
            -0.000801076170127474,
            -0.00501923657539354,
            -0.010897625153546,
            -0.0178510089292003,
            -0.0250004081740564,
            -0.0312564601726055,
            -0.0354449414126899,
            -0.0364600276636809,
            -0.0334252713705447,
            -0.0258393894626836,
            -0.0136844336323678,
            0.002522103222162365,
            0.021742633556248399,
            0.042504479356303283,
            0.063046761438677143,
            0.081512148546264832,
            0.096159368648113891,
            0.105568648975492965,
            0.108812511216631644,
            0.105568648975493493,
            0.096159368648114876,
            0.081512148546266205,
            0.063046761438678753,
            0.042504479356305004,
            0.021742633556250075,
            0.002522103222163864,
            -0.0136844336323666,
            -0.0258393894626828,
            -0.0334252713705442,
            -0.0364600276636808,
            -0.0354449414126901,
            -0.0312564601726059,
            -0.0250004081740569,
            -0.0178510089292009,
            -0.0108976251535465,
            -0.00501923657539393,
            -0.000801076170127733,
            0.001499434597819978,
            0.001938042460603051,
            0.000827871099573164,
            -0.00134475617619393,
            -0.00401733260423937,
            -0.00664532045021396,
            -0.0087799892129455,
            -0.010120560470402,
            -0.0105363454629951,
            -0.0100597130451816,
            -0.00885513209567832,
            -0.00717256931124532,
            -0.00529485706179529,
            -0.00348826112570562,
            -0.00196364687958354,
            -0.000852848114713534,
            -0.000201673787010652,
            0.000021974130050428,
            -0.0000913200928753,
            -0.000418097593646515,
            -0.000828478315201898,
            -0.0012088270150287,
            -0.00147741661877842,
            -0.00159163053382547,
            -0.00154698180275285,
            -0.0013696339,
        },
        .q =
                (const float32_t[]){
            0.000350654345247197,
            0.000048495992345331,
            -0.00030269367796739,
            -0.0006372882859413,
            -0.00087509973453087,
            -0.000935438190780461,
            -0.000754786181251458,
            -0.000305076447746045,
            0.000391193062498882,
            0.001252872752221318,
            0.002142273501865866,
            0.002879164026692220,
            0.003266240907652578,
            0.003123269326812048,
            0.002324847939360293,
            0.000835123181875766,
            -0.00126781478075111,
            -0.00378440540018013,
            -0.00640742646669138,
            -0.0087583497543795,
            -0.0104434793669819,
            -0.0111230548367379,
            -0.0105831083580657,
            -0.0087978405775875,
            -0.00597016098432496,
            -0.00254008056502865,
            0.000845262048696830,
            0.003400500117241970,
            0.004304009856972469,
            0.002820955170573835,
            -0.00156939450577235,
            -0.00906140059757262,
            -0.0194448000601471,
            -0.0320759567220048,
            -0.0459079022907017,
            -0.0595802803158307,
            -0.0715613640600165,
            -0.0803259842254938,
            -0.084546832254861,
            -0.0832733068707249,
            -0.0760725082534,
            -0.0631112465220493,
            -0.0451655026636182,
            -0.0235536028957205,
            -971.5105807436250E-18,
            0.023553602895718607,
            0.045165502663616526,
            0.063111246522047970,
            0.076072508253399146,
            0.083273306870724484,
            0.084546832254861107,
            0.080325984225494251,
            0.071561364060017327,
            0.059580280315831659,
            0.045907902290702789,
            0.032075956722005861,
            0.019444800060148069,
            0.009061400597573368,
            0.001569394505772855,
            -0.00282095517057357,
            -0.00430400985697243,
            -0.0034005001172421,
            -0.000845262048697074,
            0.002540080565028352,
            0.005970160984324673,
            0.008797840577587255,
            0.010583108358065545,
            0.011123054836737856,
            0.010443479366981914,
            0.008758349754379589,
            0.006407426466691522,
            0.003784405400180281,
            0.001267814780751256,
            -0.000835123181875646,
            -0.00232484793936021,
            -0.00312326932681201,
            -0.00326624090765258,
            -0.00287916402669225,
            -0.00214227350186591,
            -0.00125287275222137,
            -0.000391193062498925,
            0.000305076447746017,
            0.000754786181251448,
            0.000935438190780470,
            0.000875099734530894,
            0.000637288285941334,
            0.000302693677967427,
            -0.000048495992345297,
            -0.0003506543
        }
};
#else
/*
 * Hilbert +/-45 Degree, "Phase-added" bandpass filter
 * Kaiser Window FIR Filter, Beta = 3.25, Raised Cosine = .880
 * Fc = 1.68 kHz
 * BW = 2.40 kHz
 * 89 Taps
 * using Iowa Hills Hilbert Filter Designer
 */

const IQ_FilterDescriptor iq_tx_narrow =
{
        .num_taps = IQ_TX_NUM_TAPS,

        .i =
                (const float32_t[]){
            -0.005381649710336490,
            -0.004659939534183143,
            -0.003563170167486065,
            -0.002252076155808977,
            -0.000944344193214500,
             0.000115851152874194,
             0.000696596348125298,
             0.000619564989868724,
            -0.000202861200701787,
            -0.001741482786390510,
            -0.003840856305049948,
            -0.006230010632119918,
            -0.008553745450836587,
            -0.010421555013253672,
            -0.011467980190740029,
            -0.011415660319047144,
            -0.010131015913926443,
            -0.007662670567637336,
            -0.004254520134603205,
            -0.000328628830607948,
             0.003562525924733149,
             0.006810129609162748,
             0.008840547400846851,
             0.009211847517901871,
             0.007700972448718596,
             0.004367326685186139,
            -0.000419140166066293,
            -0.005992980896583574,
            -0.011453291024326510,
            -0.015764143977589795,
            -0.017884590232838470,
            -0.016912324925384050,
            -0.012222048431605894,
            -0.003579010512589831,
             0.008789548442317831,
             0.024177552291167963,
             0.041443541609488925,
             0.059112221245929797,
             0.075523964529109186,
             0.089015288990226538,
             0.098108559524848607,
             0.101687230336017079,
             0.099134149190067203,
             0.090414717119419868,
             0.076093489271615411,
             0.057281219441507325,
             0.035518254227817729,
             0.012608357429393736,
            -0.009576627799057370,
            -0.029297254681059322,
            -0.045127637653721665,
            -0.056095660063876895,
            -0.061766192548932668,
            -0.062258913075961028,
            -0.058200881188968982,
            -0.050622336416697458,
            -0.040811139772666198,
            -0.030145950884033382,
            -0.019930066165499152,
            -0.011246683807296194,
            -0.004852480987082319,
            -0.001120431225597448,
            -0.000035666033261743,
            -0.001240932859050485,
            -0.004121831827521144,
            -0.007917366348043747,
            -0.011838971620056246,
            -0.015181291957333802,
            -0.017410399221311615,
            -0.018219393837632457,
            -0.017546684882373952,
            -0.015557867711924755,
            -0.012597180731886251,
            -0.009118335449051013,
            -0.005606612821961777,
            -0.002504324453121383,
            -0.000150162070902860,
             0.001260027662734500,
             0.001687350388603957,
             0.001239221827530125,
             0.000137996593314624,
            -0.001324384768255993,
            -0.002837517357477661,
            -0.004121120112879119,
            -0.004963972612369489,
            -0.005248247246125872,
            -0.004957009084156489,
            -0.004165469852849983,
            -0.003019038782580419,        },
        .q =
                (const float32_t[]){
                -0.003019038782580419,
                -0.004165469852849983,
                -0.004957009084156489,
                -0.005248247246125872,
                -0.004963972612369489,
                -0.004121120112879119,
                -0.002837517357477661,
                -0.001324384768255993,
                 0.000137996593314624,
                 0.001239221827530125,
                 0.001687350388603957,
                 0.001260027662734500,
                -0.000150162070902860,
                -0.002504324453121383,
                -0.005606612821961777,
                -0.009118335449051013,
                -0.012597180731886251,
                -0.015557867711924755,
                -0.017546684882373952,
                -0.018219393837632457,
                -0.017410399221311615,
                -0.015181291957333802,
                -0.011838971620056246,
                -0.007917366348043747,
                -0.004121831827521144,
                -0.001240932859050485,
                -0.000035666033261743,
                -0.001120431225597448,
                -0.004852480987082319,
                -0.011246683807296194,
                -0.019930066165499152,
                -0.030145950884033382,
                -0.040811139772666198,
                -0.050622336416697458,
                -0.058200881188968982,
                -0.062258913075961028,
                -0.061766192548932668,
                -0.056095660063876895,
                -0.045127637653721665,
                -0.029297254681059322,
                -0.009576627799057370,
                 0.012608357429393736,
                 0.035518254227817729,
                 0.057281219441507325,
                 0.076093489271615411,
                 0.090414717119419868,
                 0.099134149190067203,
                 0.101687230336017079,
                 0.098108559524848607,
                 0.089015288990226538,
                 0.075523964529109186,
                 0.059112221245929797,
                 0.041443541609488925,
                 0.024177552291167963,
                 0.008789548442317831,
                -0.003579010512589831,
                -0.012222048431605894,
                -0.016912324925384050,
                -0.017884590232838470,
                -0.015764143977589795,
                -0.011453291024326510,
                -0.005992980896583574,
                -0.000419140166066293,
                 0.004367326685186139,
                 0.007700972448718596,
                 0.009211847517901871,
                 0.008840547400846851,
                 0.006810129609162748,
                 0.003562525924733149,
                -0.000328628830607948,
                -0.004254520134603205,
                -0.007662670567637336,
                -0.010131015913926443,
                -0.011415660319047144,
                -0.011467980190740029,
                -0.010421555013253672,
                -0.008553745450836587,
                -0.006230010632119918,
                -0.003840856305049948,
                -0.001741482786390510,
                -0.000202861200701787,
                 0.000619564989868724,
                 0.000696596348125298,
                 0.000115851152874194,
                -0.000944344193214500,
                -0.002252076155808977,
                -0.003563170167486065,
                -0.004659939534183143,
                -0.005381649710336490,
        }
};
#endif

#if 1
// trial with +/-45 degrees!!!
// phase added, 48000 sampling frequency
// Fc=1.50kHz, BW=2.70kHz
// Kaiser, Beta = 3.650, Raised Cosine 0.910
// Iowa Hills Hilbert Filter Designer Version 3.0
// DD4WH, 2016_07_24

const IQ_FilterDescriptor iq_tx_wide =
{
        .num_taps = IQ_TX_NUM_TAPS_WIDE,

        .i = (const float32_t[])
        {
            -0.000110171112837058,
            -0.000215191676106024,
            -0.000349404033716016,
            -0.000496951746094190,
            -0.000637115651709324,
            -0.000747336640415393,
            -0.000807001210118930,
            -0.000801400114963688,
            -0.000725164708732548,
            -0.000584494175355709,
            -0.000397621019065366,
            -0.000193211657284225,
            -6.731480373302180E-6,
            0.000124831265731249,
            0.000169152629565774,
            0.000104697245724197,
            -0.000074292912637529,
            -0.000354939210586125,
            -0.000705729393731337,
            -0.001079699782698907,
            -0.001420598860001278,
            -0.001671301059874509,
            -0.001783277746026863,
            -0.001725628885472922,
            -0.001492101415996081,
            -0.001104703813899759,
            -0.000612964396330499,
            -0.000088522768269239,
            0.000384500540237483,
            0.000722159397614641,
            0.000854544998949087,
            0.000738666366568531,
            0.000368118465545143,
            -0.000222362933209255,
            -0.000958685009193057,
            -0.001735806314542762,
            -0.002431986456578192,
            -0.002927060659140451,
            -0.003122100716888928,
            -0.002957366391184722,
            -0.002425464411957004,
            -0.001577152712160757,
            -0.000518211398253738,
            0.000602874422036065,
            0.001615200699433123,
            0.002351084212928152,
            0.002673356919585794,
            0.002500044722247771,
            0.001822235291716940,
            0.000711698392249346,
            -0.000683804743772797,
            -0.002157773305786353,
            -0.003473035374927932,
            -0.004397017985558934,
            -0.004739167257486619,
            -0.004384726505971721,
            -0.003319205664526024,
            -0.001638911085429426,
            0.000455246396374910,
            0.002681018366088089,
            0.004712846192293575,
            0.006229830588165904,
            0.006966890480278101,
            0.006761336787794098,
            0.005587203265857816,
            0.003570994150065774,
            0.000984907660613053,
            -0.001783219282335870,
            -0.004280462349942326,
            -0.006053704386701811,
            -0.006720045103649730,
            -0.006032371940927658,
            -0.003929671876394201,
            -0.000563165775618498,
            0.003707704003290906,
            0.008351350932807226,
            0.012729482477129751,
            0.016184648966684857,
            0.018138857370352073,
            0.018189761228878235,
            0.016190286058037750,
            0.012298889831410701,
            0.006990913948433064,
            0.001026294370149727,
            -0.004625323241644382,
            -0.008895051261285708,
            -0.010748461471684751,
            -0.009326243981895398,
            -0.004073641409469179,
            0.005159055689068004,
            0.018059786439140576,
            0.033851609217688650,
            0.051346528754005590,
            0.069052380559209328,
            0.085321938965670419,
            0.098527650095919780,
            0.107241613104364406,
            0.110399189880406076,
            0.107426132449888842,
            0.098313230288092343,
            0.083628697746030919,
            0.064466058948901367,
            0.042333175031220437,
            0.018995274586969532,
            -0.003709544175785423,
            -0.024060597134652702,
            -0.040628416865048686,
            -0.052412083218987278,
            -0.058924848579470578,
            -0.060219420607372891,
            -0.056851821845366309,
            -0.049790270526443803,
            -0.040282049358040938,
            -0.029696029207309495,
            -0.019360831602198387,
            -0.010418315895665185,
            -0.003709284676449769,
            0.000296536964195334,
            0.001520369759393477,
            0.000244872198212814,
            -0.002957730720030519,
            -0.007327854240209992,
            -0.012035886094829340,
            -0.016298421211522331,
            -0.019478361596522272,
            -0.021156958377630559,
            -0.021170395594245318,
            -0.019608758592464137,
            -0.016780441299653556,
            -0.013149516262532890,
            -0.009256748582560672,
            -0.005636421543896653,
            -0.002740851541915539,
            -0.000882550728394041,
            -0.000200815520129123,
            -0.000655602105927875,
            -0.002047494260227691,
            -0.004058956516116312,
            -0.006309381620576754,
            -0.008415008029277367,
            -0.010044724981282397,
            -0.010964018193722168,
            -0.011061575734036889,
            -0.010355975806581812,
            -0.008982953406087438,
            -0.007166532628799022,
            -0.005179428417921703,
            -0.003299301522811309,
            -0.001767583834310825,
            -0.000756729367970240,
            -0.000350083616969358,
            -0.000536400790861641,
            -0.001218728772099963,
            -0.002235277697461324,
            -0.003388287881854928,
            -0.004476019145966429,
            -0.005322880049650393,
            -0.005803361780652197,
            -0.005856687675122848,
            -0.005490706080302640,
            -0.004775272359132256,
            -0.003826919781512536,
            -0.002787786895091998,
            -0.001802402923937431,
            -0.000995976427007529,
            -0.000457323050545061,
            -0.000228624209408082,
            -0.000303005837526218,
            -0.000629667288270294,
            -0.001125170919207243,
            -0.001688682726272838,
            -0.002218535544559282,
            -0.002627501438172705,
            -0.002854572422980392,
            -0.002871763742314763,
            -0.002685337454483747,
            -0.002331746541649206,
            -0.001869380504742496,
            -0.001367741970733447,
            -0.000895934671193270,
            -0.000512282356362102,
            -0.000256561584565188,
            -0.000145794764945257,
            -0.000173914155402102,
            -0.000314980583202455,
            -0.000529119767637795,
            -0.000769996538033533,
            -0.000992520819123322,
            -0.001159569364704958,
            -0.001246779863546185,
            -0.001244869234892962,
            -0.001159371545637672,
            -0.001008107863716669,
            -0.000817026508314411,
            -0.000615244043722063,
            -0.000430157157095143,
            -0.000283391698705431,
            -0.000188138600992614,
            -0.000148143491709299,
            -0.000158320335099411,
            -0.000206699262770281
        },

        .q = (const float32_t[])
        {
            0.000350654345247197,
            0.000048495992345331,
            -0.00030269367796739,
            -0.0006372882859413,
            -0.00087509973453087,
            -0.000935438190780461,
            -0.000754786181251458,
            -0.000305076447746045,
            0.000391193062498882,
            0.001252872752221318,
            0.002142273501865866,
            0.002879164026692220,
            0.003266240907652578,
            0.003123269326812048,
            0.002324847939360293,
            0.000835123181875766,
            -0.00126781478075111,
            -0.00378440540018013,
            -0.00640742646669138,
            -0.0087583497543795,
            -0.0104434793669819,
            -0.0111230548367379,
            -0.0105831083580657,
            -0.0087978405775875,
            -0.00597016098432496,
            -0.00254008056502865,
            0.000845262048696830,
            0.003400500117241970,
            0.004304009856972469,
            0.002820955170573835,
            -0.00156939450577235,
            -0.00906140059757262,
            -0.0194448000601471,
            -0.0320759567220048,
            -0.0459079022907017,
            -0.0595802803158307,
            -0.0715613640600165,
            -0.0803259842254938,
            -0.084546832254861,
            -0.0832733068707249,
            -0.0760725082534,
            -0.0631112465220493,
            -0.0451655026636182,
            -0.0235536028957205,
            -971.5105807436250E-18,
            0.023553602895718607,
            0.045165502663616526,
            0.063111246522047970,
            0.076072508253399146,
            0.083273306870724484,
            0.084546832254861107,
            0.080325984225494251,
            0.071561364060017327,
            0.059580280315831659,
            0.045907902290702789,
            0.032075956722005861,
            0.019444800060148069,
            0.009061400597573368,
            0.001569394505772855,
            -0.00282095517057357,
            -0.00430400985697243,
            -0.0034005001172421,
            -0.000845262048697074,
            0.002540080565028352,
            0.005970160984324673,
            0.008797840577587255,
            0.010583108358065545,
            0.011123054836737856,
            0.010443479366981914,
            0.008758349754379589,
            0.006407426466691522,
            0.003784405400180281,
            0.001267814780751256,
            -0.000835123181875646,
            -0.00232484793936021,
            -0.00312326932681201,
            -0.00326624090765258,
            -0.00287916402669225,
            -0.00214227350186591,
            -0.00125287275222137,
            -0.000391193062498925,
            0.000305076447746017,
            0.000754786181251448,
            0.000935438190780470,
            0.000875099734530894,
            0.000637288285941334,
            0.000302693677967427,
            -0.000048495992345297,
            -0.0003506543
        }
};
#else
    // trial with 0 degrees and 201 taps
    // phase added, 48000 sampling frequency
    // Fc=1.54kHz, BW=2.76kHz
    // Kaiser, Beta = 5.050, Raised Cosine 0.910
    // Iowa Hills Hilbert Filter Designer Version 3.0
    // DD4WH, 2016_07_28
    const IQ_FilterDescriptor iq_tx_wide =
    {
            .num_taps = IQ_TX_NUM_TAPS_WIDE,

            .i = (const float32_t[])
            {
                -0.000015911433738947,
                -0.000019959728028938,
                -0.000023891471599754,
                -0.000027119763124069,
                -0.000029087039705292,
                -0.000029431397715954,
                -0.000028148219961633,
                -0.000025702247123746,
                -0.000023048146401552,
                -0.000021532467002145,
                -0.000022675017711946,
                -0.000027858477628481,
                -0.000037984418906156,
                -0.000053173935947263,
                -0.000072594827015540,
                -0.000094480871554435,
                -0.000116372847662635,
                -0.000135561336982947,
                -0.000149658359810178,
                -0.000157181343994879,
                -0.000158011427902595,
                -0.000153597634188139,
                -0.000146821594676398,
                -0.000141508706977174,
                -0.000141657313079918,
                -0.000150538332814799,
                -0.000169872539761493,
                -0.000199303342326905,
                -0.000236339821701096,
                -0.000276850226155669,
                -0.000316055860965538,
                -0.000349836665758744,
                -0.000376046667777827,
                -0.000395483070998372,
                -0.000412180921252682,
                -0.000432823344456314,
                -0.000465251321301123,
                -0.000516291531622259,
                -0.000589344418113810,
                -0.000682329334357383,
                -0.000786618128311585,
                -0.000887471604155052,
                -0.000966224936321975,
                -0.001004084647738534,
                -0.000986971617519555,
                -0.000910465431454767,
                -0.000783674244635495,
                -0.000630853460997997,
                -0.000489869695624849,
                -0.000407142410379079,
                -0.000429421385599579,
                -0.000593545407736026,
                -0.000916011846980452,
                -0.001384598358663629,
                -0.001954277926711752,
                -0.002549184202610570,
                -0.003071435226054831,
                -0.003416332297185353,
                -0.003492031457300130,
                -0.003240513223388775,
                -0.002655839887826624,
                -0.001795531271501309,
                -0.000781549566761797,
                0.000211143419483594,
                0.000978377875720550,
                0.001320403087257693,
                0.001080515967568864,
                0.000182121345956079,
                -0.001343074868529297,
                -0.003342478753804935,
                -0.005550446581697207,
                -0.007618265957299014,
                -0.009164142003551838,
                -0.009837061742258062,
                -0.009385008993095094,
                -0.007715887072085315,
                -0.004939218878809190,
                -0.001378502462245723,
                0.002452076537338900,
                0.005907488065309155,
                0.008302997095508243,
                0.009025375745234239,
                0.007648260210940124,
                0.004033210841998318,
                -0.001601654938770521,
                -0.008660246045580289,
                -0.016203010335164171,
                -0.023038057426319945,
                -0.027860750884303231,
                -0.029425395934213904,
                -0.026726377512887117,
                -0.019162929429234910,
                -0.006662334542242190,
                0.010259113968032065,
                0.030510126124987710,
                0.052515877605683242,
                0.074378297568183149,
                0.094086304242110563,
                0.109749301278724468,
                0.119823145137080742,
                0.123298109645664233,
                0.119823145137071957,
                0.109749301278707773,
                0.094086304242087637,
                0.074378297568156199,
                0.052515877605654772,
                0.030510126124960246,
                0.010259113968007870,
                -0.006662334542261386,
                -0.019162929429248053,
                -0.026726377512893910,
                -0.029425395934214775,
                -0.027860750884299197,
                -0.023038057426312451,
                -0.016203010335154873,
                -0.008660246045570802,
                -0.001601654938762230,
                0.004033210842004407,
                0.007648260210943465,
                0.009025375745234765,
                0.008302997095506299,
                0.005907488065305405,
                0.002452076537334174,
                -0.001378502462250567,
                -0.004939218878813399,
                -0.007715887072088339,
                -0.009385008993096640,
                -0.009837061742258109,
                -0.009164142003550596,
                -0.007618265957296863,
                -0.005550446581694617,
                -0.003342478753802375,
                -0.001343074868527162,
                0.000182121345957515,
                0.001080515967569481,
                0.001320403087257519,
                0.000978377875719736,
                0.000211143419482372,
                -0.000781549566763161,
                -0.001795531271502565,
                -0.002655839887827574,
                -0.003240513223389301,
                -0.003492031457300196,
                -0.003416332297185003,
                -0.003071435226054171,
                -0.002549184202609736,
                -0.001954277926710889,
                -0.001384598358662863,
                -0.000916011846979873,
                -0.000593545407735683,
                -0.000429421385599475,
                -0.000407142410379183,
                -0.000489869695625105,
                -0.000630853460998336,
                -0.000783674244635851,
                -0.000910465431455086,
                -0.000986971617519803,
                -0.001004084647738694,
                -0.000966224936322048,
                -0.000887471604155053,
                -0.000786618128311534,
                -0.000682329334357303,
                -0.000589344418113718,
                -0.000516291531622168,
                -0.000465251321301040,
                -0.000432823344456239,
                -0.000412180921252613,
                -0.000395483070998306,
                -0.000376046667777760,
                -0.000349836665758677,
                -0.000316055860965474,
                -0.000276850226155611,
                -0.000236339821701050,
                -0.000199303342326874,
                -0.000169872539761481,
                -0.000150538332814806,
                -0.000141657313079940,
                -0.000141508706977206,
                -0.000146821594676434,
                -0.000153597634188172,
                -0.000158011427902620,
                -0.000157181343994892,
                -0.000149658359810178,
                -0.000135561336982934,
                -0.000116372847662614,
                -0.000094480871554409,
                -0.000072594827015514,
                -0.000053173935947240,
                -0.000037984418906137,
                -0.000027858477628469,
                -0.000022675017711940,
                -0.000021532467002142,
                -0.000023048146401550,
                -0.000025702247123743,
                -0.000028148219961627,
                -0.000029431397715943,
                -0.000029087039705276,
                -0.000027119763124050,
                -0.000023891471599733,
                -0.000019959728028917,
                -0.000015911433738929
            },
            .q = (const float32_t[])
            {
                -0.000055876484573473,
                -0.000064501669527415,
                -0.000074738701316321,
                -0.000086507654429771,
                -0.000099410855699246,
                -0.000112742030021933,
                -0.000125581860328626,
                -0.000136976384505566,
                -0.000146171471747199,
                -0.000152855683517751,
                -0.000157351204077214,
                -0.000160693204323070,
                -0.000164554344882989,
                -0.000171001789764558,
                -0.000182113756522494,
                -0.000199522659221598,
                -0.000223982104007250,
                -0.000255065964662709,
                -0.000291093444701605,
                -0.000329333837166658,
                -0.000366484543520879,
                -0.000399347771170467,
                -0.000425571116339335,
                -0.000444281412941937,
                -0.000456442686257327,
                -0.000464813293654387,
                -0.000473459903203533,
                -0.000486891982756433,
                -0.000508986765583088,
                -0.000541954254458334,
                -0.000585620149319337,
                -0.000637266013271176,
                -0.000692159225019129,
                -0.000744745974185545,
                -0.000790300256973267,
                -0.000826662663506291,
                -0.000855608799816551,
                -0.000883393930312482,
                -0.000920144557182625,
                -0.000977999833391699,
                -0.001068208413135301,
                -0.001197698143396605,
                -0.001365882230232392,
                -0.001562573853813371,
                -0.001767799237590146,
                -0.001954010129822268,
                -0.002090729412517879,
                -0.002151093704598354,
                -0.002119197166650733,
                -0.001996721724352054,
                -0.001807182145055243,
                -0.001596303598977302,
                -0.001427605606562385,
                -0.001373133139886880,
                -0.001500318939184498,
                -0.001856985786393334,
                -0.002457280182694243,
                -0.003271661399515204,
                -0.004223805794000835,
                -0.005196381265502662,
                -0.006046183103054665,
                -0.006627310796927153,
                -0.006819219662039622,
                -0.006554969302166284,
                -0.005844167767895242,
                -0.004785243876864911,
                -0.003562886684106115,
                -0.002428691218878755,
                -0.001665958674417137,
                -0.001542756544570849,
                -0.002260180366086176,
                -0.003904692125323062,
                -0.006413957060137492,
                -0.009564477743523059,
                -0.012986526898586098,
                -0.016207713154723136,
                -0.018721568815726210,
                -0.020072626005615220,
                -0.019945430948836697,
                -0.018242650197742859,
                -0.015137438929630096,
                -0.011087811480348275,
                -0.006805694582534307,
                -0.003180041098991087,
                -0.001160864894184417,
                -0.001618136646873710,
                -0.005194938168183790,
                -0.012177070502025733,
                -0.022400779394307693,
                -0.035216238922248289,
                -0.049517325350430505,
                -0.063838956132037980,
                -0.076513206133968448,
                -0.085866090480225241,
                -0.090429824178616405,
                -0.089141744773038101,
                -0.081501626274434108,
                -0.067663896323307105,
                -0.048449702280469985,
                -0.025274673539499328,
                16.41584600088100E-15,
                0.025274673539530806,
                0.048449702280497546,
                0.067663896323328629,
                0.081501626274448152,
                0.089141744773044040,
                0.090429824178614490,
                0.085866090480216414,
                0.076513206133954376,
                0.063838956132020688,
                0.049517325350412138,
                0.035216238922230865,
                0.022400779394292886,
                0.012177070502014685,
                0.005194938168177043,
                0.001618136646871193,
                0.001160864894185542,
                0.003180041098994882,
                0.006805694582539598,
                0.011087811480353871,
                0.015137438929634959,
                0.018242650197746225,
                0.019945430948838137,
                0.020072626005614679,
                0.018721568815723948,
                0.016207713154719635,
                0.012986526898581976,
                0.009564477743518948,
                0.006413957060133944,
                0.003904692125320466,
                0.002260180366084725,
                0.001542756544570538,
                0.001665958674417785,
                0.002428691218880064,
                0.003562886684107731,
                0.004785243876866489,
                0.005844167767896496,
                0.006554969302167027,
                0.006819219662039779,
                0.006627310796926756,
                0.006046183103053836,
                0.005196381265501569,
                0.004223805793999667,
                0.003271661399514136,
                0.002457280182693402,
                0.001856985786392793,
                0.001500318939184273,
                0.001373133139886934,
                0.001427605606562642,
                0.001596303598977673,
                0.001807182145055637,
                0.001996721724352394,
                0.002119197166650973,
                0.002151093704598469,
                0.002090729412517876,
                0.001954010129822170,
                0.001767799237589989,
                0.001562573853813192,
                0.001365882230232221,
                0.001197698143396462,
                0.001068208413135197,
                0.000977999833391630,
                0.000920144557182582,
                0.000883393930312452,
                0.000855608799816521,
                0.000826662663506252,
                0.000790300256973217,
                0.000744745974185486,
                0.000692159225019068,
                0.000637266013271121,
                0.000585620149319296,
                0.000541954254458312,
                0.000508986765583088,
                0.000486891982756452,
                0.000473459903203566,
                0.000464813293654426,
                0.000456442686257364,
                0.000444281412941965,
                0.000425571116339349,
                0.000399347771170465,
                0.000366484543520863,
                0.000329333837166631,
                0.000291093444701573,
                0.000255065964662676,
                0.000223982104007221,
                0.000199522659221575,
                0.000182113756522479,
                0.000171001789764551,
                0.000164554344882987,
                0.000160693204323071,
                0.000157351204077214,
                0.000152855683517748,
                0.000146171471747192,
                0.000136976384505555,
                0.000125581860328611,
                0.000112742030021918,
                0.000099410855699231,
                0.000086507654429759,
                0.000074738701316315,
                0.000064501669527414,
                0.000055876484573478
            }
    };
#endif


    /*
// trial with 0 degrees!!!
// phase added, 48000 sampling frequency
// Fc=1.50kHz, BW=2.70kHz
// Kaiser, Beta = 3.650, Raised Cosine 0.910
// Iowa Hills Hilbert Filter Designer Version 3.0
// DD4WH, 2016_07_24
//const float i_tx_coeffs[I_NUM_TAPS] =
		const float i_tx_wide_coeffs[I_NUM_TAPS] =
{
		-0.000675829974580901,
		-0.000775321733206631,
		-0.000805271934889941,
		-0.000740609080216212,
		-0.000571424809863288,
		-0.000310812490280582,
		 488.9699404346010E-9,
		 0.000294703584162428,
		 0.000484214205902836,
		 0.000475465809656165,
		 0.000188165085459235,
		-0.000423194149580655,
		-0.001349687058284244,
		-0.002514970750248195,
		-0.003773366542757180,
		-0.004922025542628025,
		-0.005727860583686991,
		-0.005966986460872474,
		-0.005471367240494044,
		-0.004174838643172011,
		-0.002149262655069977,
		 0.000378246395424234,
		 0.003034088509181957,
		 0.005336300605019817,
		 0.006760456353567154,
		 0.006826352412897128,
		 0.005193570718607052,
		 0.001750569629993906,
		-0.003319169301624403,
		-0.009508737721896792,
		-0.016007441037782504,
		-0.021771957640371112,
		-0.025644303951367561,
		-0.026503648390737589,
		-0.023432144978397278,
		-0.015870758657540535,
		-0.003740460401229463,
		 0.012492452065518142,
		 0.031821099733789958,
		 0.052777245796880867,
		 0.073578365127334053,
		 0.092325368347023831,
		 0.107225454572517670,
		 0.116809887876610230,
		 0.120116333624982294,
		 0.116809887876602042,
		 0.107225454572502099,
		 0.092325368347002390,
		 0.073578365127308809,
		 0.052777245796854146,
		 0.031821099733764062,
		 0.012492452065495137,
		-0.003740460401247988,
		-0.015870758657553618,
		-0.023432144978404623,
		-0.026503648390739550,
		-0.025644303951365029,
		-0.021771957640365339,
		-0.016007441037774923,
		-0.009508737721888778,
		-0.003319169301617154,
		 0.001750569629999520,
		 0.005193570718610547,
		 0.006826352412898407,
		 0.006760456353566453,
		 0.005336300605017613,
		 0.003034088509178859,
		 0.000378246395420868,
		-0.002149262655073061,
		-0.004174838643174412,
		-0.005471367240495541,
		-0.005966986460873027,
		-0.005727860583686712,
		-0.004922025542627132,
		-0.003773366542755943,
		-0.002514970750246877,
		-0.001349687058283068,
		-0.000423194149579770,
		 0.000188165085459759,
		 0.000475465809656334,
		 0.000484214205902713,
		 0.000294703584162108,
		 488.9699400243500E-9,
		-0.000310812490280988,
		-0.000571424809863621,
		-0.000740609080216433,
		-0.000805271934890042,
		-0.000775321733206627,
		-0.000675829974580823
};
     */

    /*
//
// 0 degrees
// phase added, 48000 sampling frequency
// Fc=1.50kHz, BW=2.70kHz
// Kaiser, Beta = 3.650, Raised Cosine 0.910
// Iowa Hills Hilbert Filter Designer Version 3.0
// DD4WH, 2016_07_23

const float i_tx_wide_coeffs[I_NUM_TAPS] =
							 {
									 -0.000677103480385558,
									 -0.000780090493534493,
									 -0.000814190035208927,
									 -0.000753630467332200,
									 -0.000587590187077226,
									 -0.000328197121900482,
									 -0.000015387609888190,
									  0.000283472465160544,
									  0.000480590851789243,
									  0.000481549325951272,
									  0.000204532536166321,
									 -0.000397965458349166,
									 -0.001319175547417292,
									 -0.002484649001394270,
									 -0.003749900078371015,
									 -0.004912200344510958,
									 -0.005737297596068188,
									 -0.005998870760199724,
									 -0.005525450693709243,
									 -0.004246955929541380,
									 -0.002231529112179321,
									  0.000296501905426256,
									  0.002964742683216956,
									  0.005290432490315485,
									  0.006746256285973765,
									  0.006847330812018482,
									  0.005247436081126460,
									  0.001829052108313485,
									 -0.003229427830830281,
									 -0.009424298449721112,
									 -0.015945453077265786,
									 -0.021747235534664140,
									 -0.025666607989597402,
									 -0.026575674008559730,
									 -0.023548627412424115,
									 -0.016018916599795770,
									 -0.003901768455824901,
									  0.012339415457482095,
									  0.031697188609326056,
									  0.052699255918641857,
									  0.073556129349929431,
									  0.092359963475823911,
									  0.107308858507223409,
									  0.116926173245332360,
									  0.120244211522740271,
									  0.116926173245324130,
									  0.107308858507207769,
									  0.092359963475802415,
									  0.073556129349904104,
									  0.052699255918615059,
									  0.031697188609300112,
									  0.012339415457459063,
									 -0.003901768455843424,
									 -0.016018916599808818,
									 -0.023548627412431404,
									 -0.026575674008561631,
									 -0.025666607989594803,
									 -0.021747235534658314,
									 -0.015945453077258157,
									 -0.009424298449713079,
									 -0.003229427830823034,
									  0.001829052108319078,
									  0.005247436081129921,
									  0.006847330812019718,
									  0.006746256285973021,
									  0.005290432490313243,
									  0.002964742683213832,
									  0.000296501905422879,
									 -0.002231529112182403,
									 -0.004246955929543768,
									 -0.005525450693710718,
									 -0.005998870760200249,
									 -0.005737297596067882,
									 -0.004912200344510044,
									 -0.003749900078369763,
									 -0.002484649001392946,
									 -0.001319175547416117,
									 -0.000397965458348288,
									  0.000204532536166834,
									  0.000481549325951429,
									  0.000480590851789108,
									  0.000283472465160215,
									 -0.000015387609888606,
									 -0.000328197121900891,
									 -0.000587590187077558,
									 -0.000753630467332418,
									 -0.000814190035209023,
									 -0.000780090493534485,
									 -0.000677103480385476
							 };
     */

    /*
     * Hilbert 0 Degree, "Phase-added" bandpass filter
     * Kaiser Window FIR Filter, Beta = 4.50, Raised Cosine = 0.90
     * Fc = 1.34 kHz
     * BW = 2.59 kHz
     * 89 Taps
     * -1dB @ 586, 2262 Hz
     * -3dB @ 375, 2590 Hz
     * -6dB @ 281, 2801 Hz
     * -20dB >3350 Hz
     *
     * 20141203 by KA7OEI using Iowa Hills Hilbert Filter Designer
     */
    /*
const float i_tx_coeffs[I_NUM_TAPS] =
{
		-0.000192875376876728,
		-0.000182740263881208,
		-0.000140891715454915,
		-0.00006838009139126,
		 0.000023805288625652,
		 0.000113204625330436,
		 0.000166732821526421,
		 0.000144525647240612,
		 6.867219960430160E-6,
		-0.000276440128730619,
		-0.000715671112495218,
		-0.00129179592920764,
		-0.00195053373657144,
		-0.00260215863827949,
		-0.00312874866340919,
		-0.00339942340417407,
		-0.00329258338096766,
		-0.00272248284860552,
		-0.00166595472984103,
		-0.000184104091196061,
		 0.001566403782619490,
		 0.003337021727061818,
		 0.004808684980596975,
		 0.005630882640480853,
		 0.005475266742216030,
		 0.004097459914051238,
		 0.001398159252556323,
		-0.00252676885539993,
		-0.00735733549494755,
		-0.0125498193984163,
		-0.0173711247134924,
		-0.0209669219262358,
		-0.0224580250716578,
		-0.021054384563457,
		-0.0161721630791137,
		-0.00753736501650615,
		 0.004740100057217369,
		 0.020135096635881311,
		 0.037726671975072013,
		 0.056269419247174567,
		 0.074310657942761607,
		 0.090340451113308615,
		 0.102956241234166010,
		 0.111021125206319293,
		 0.113795008726467584,
		 0.111021125206319737,
		 0.102956241234166856,
		 0.090340451113309767,
		 0.074310657942762981,
		 0.056269419247176052,
		 0.037726671975073518,
		 0.020135096635882685,
		 0.004740100057218542,
		-0.00753736501650524,
		-0.0161721630791131,
		-0.0210543845634566,
		-0.0224580250716578,
		-0.020966921926236,
		-0.0173711247134927,
		-0.0125498193984166,
		-0.00735733549494792,
		-0.00252676885540028,
		 0.001398159252556051,
		 0.004097459914051059,
		 0.005475266742215946,
		 0.005630882640480855,
		 0.004808684980597044,
		 0.003337021727061931,
		 0.001566403782619622,
		-0.000184104091195931,
		-0.00166595472984091,
		-0.00272248284860544,
		-0.00329258338096761,
		-0.00339942340417405,
		-0.00312874866340919,
		-0.0026021586382795,
		-0.00195053373657147,
		-0.00129179592920766,
		-0.00071567111249524,
		-0.000276440128730636,
		 6.867219960419110E-6,
		 0.000144525647240606,
		 0.000166732821526418,
		 0.000113204625330434,
		 0.000023805288625650,
		-0.000068380091391264,
		-0.00014089171545492,
		-0.000182740263881214,
		-0.0001928754
};
     */


    /*
// -90 degrees - just for comparison!
// phase added, 48000 sampling frequency
// Fc=1.50kHz, BW=2.70kHz
// Kaiser, Beta = 3.650, Raised Cosine 0.910
// Iowa Hills Hilbert Filter Designer Version 3.0
// DD4WH, 2016_07_24
//const float q_tx_coeffs[HILBERT_NUM_TAPS] =
        const float q_tx_wide_coeffs[HILBERT_NUM_TAPS] =
{

        -0.000665402252765227,
        -0.000946615891901463,
        -0.001279743146323382,
        -0.001632231691405219,
        -0.001957091410171042,
        -0.002199821018029484,
        -0.002309411365769962,
        -0.002251921729689484,
        -0.002024108377662461,
        -0.001663922346580486,
        -0.001254620673304718,
        -0.000919897319300992,
        -0.000808841246681518,
        -0.001071506752387996,
        -0.001828111999092654,
        -0.003136926185249386,
        -0.004967285454085531,
        -0.007184472908921590,
        -0.009552148491012094,
        -0.011755599154613963,
        -0.013445558599443925,
        -0.014298246764502592,
        -0.014083328040602279,
        -0.012728486535297989,
        -0.010367994958213108,
        -0.007363509365021880,
        -0.004288496943417881,
        -0.001872913061386172,
        -0.000911281241705069,
        -0.002144158985981689,
        -0.006128888704080539,
        -0.013119373997572136,
        -0.022975488318414519,
        -0.035120170153940936,
        -0.048556414115171927,
        -0.061947953069820858,
        -0.073757672573667013,
        -0.082428255905694331,
        -0.086581840754246353,
        -0.085210973390320771,
        -0.077832793636941941,
        -0.064582435561975932,
        -0.046229613976335515,
        -0.024113137786770409,
         15.66146955733900E-15,
         0.024113137786800482,
         0.046229613976361959,
         0.064582435561996804,
         0.077832793636955874,
         0.085210973390327197,
         0.086581840754245451,
         0.082428255905687003,
         0.073757672573654773,
         0.061947953069805509,
         0.048556414115155412,
         0.035120170153925073,
         0.022975488318400805,
         0.013119373997561591,
         0.006128888704073664,
         0.002144158985978462,
         0.000911281241705025,
         0.001872913061388527,
         0.004288496943421690,
         0.007363509365026183,
         0.010367994958217068,
         0.012728486535300993,
         0.014083328040603967,
         0.014298246764502889,
         0.013445558599442973,
         0.011755599154612082,
         0.009552148491009688,
         0.007184472908919070,
         0.004967285454083249,
         0.003136926185247594,
         0.001828111999091482,
         0.001071506752387452,
         0.000808841246681517,
         0.000919897319301384,
         0.001254620673305327,
         0.001663922346581146,
         0.002024108377663038,
         0.002251921729689894,
         0.002309411365770169,
         0.002199821018029500,
         0.001957091410170907,
         0.001632231691404990,
         0.001279743146323119,
         0.000946615891901215,
         0.000665402252765026


};
     */

    /*
//
// -90 degrees
// phase added, 48000 sampling frequency
// Fc=1.50kHz, BW=2.70kHz
// Kaiser, Beta = 3.650, Raised Cosine 0.910
// Iowa Hills Hilbert Filter Designer Version 3.0
// DD4WH, 2016_07_23
const float q_tx_wide_coeffs[HILBERT_NUM_TAPS] =
{
        -0.000656076842600099,
        -0.000936223195209486,
        -0.001269775809502456,
        -0.001624570965759267,
        -0.001953674259359320,
        -0.002202197411670461,
        -0.002318271089646788,
        -0.002266695764611934,
        -0.002042755582304645,
        -0.001682992661310914,
        -0.001269641360739249,
        -0.000926064887392290,
        -0.000801930160945160,
        -0.001048841930007893,
        -0.001789411081735692,
        -0.003084812463147427,
        -0.004907309562409643,
        -0.007124558993482826,
        -0.009501487225684556,
        -0.011723126766972710,
        -0.013438264374083927,
        -0.014319617903475333,
        -0.014132252034559945,
        -0.012798878789591409,
        -0.010449307266789585,
        -0.007442119728321511,
        -0.004349810475224735,
        -0.001903850305917731,
        -0.000902726399570528,
        -0.002092911144815353,
        -0.006038715873267323,
        -0.013000907779068297,
        -0.022844895033853944,
        -0.034996757512673865,
        -0.048459539281931384,
        -0.061893747428638422,
        -0.073756158887492554,
        -0.082481389140056996,
        -0.086682858496950177,
        -0.085345219215171936,
        -0.077979916351990239,
        -0.064719616995672302,
        -0.046335285098226112,
        -0.024170544953130098,
         15.69913975808190E-15,
         0.024170544953160233,
         0.046335285098252611,
         0.064719616995693174,
         0.077979916352004172,
         0.085345219215178333,
         0.086682858496949233,
         0.082481389140049613,
         0.073756158887480244,
         0.061893747428623032,
         0.048459539281914835,
         0.034996757512657968,
         0.022844895033840230,
         0.013000907779057774,
         0.006038715873260491,
         0.002092911144812179,
         0.000902726399570537,
         0.001903850305920134,
         0.004349810475228577,
         0.007442119728325830,
         0.010449307266793547,
         0.012798878789594393,
         0.014132252034561602,
         0.014319617903475586,
         0.013438264374082937,
         0.011723126766970802,
         0.009501487225682130,
         0.007124558993480297,
         0.004907309562407365,
         0.003084812463145647,
         0.001789411081734536,
         0.001048841930007369,
         0.000801930160945178,
         0.000926064887392697,
         0.001269641360739868,
         0.001682992661311578,
         0.002042755582305221,
         0.002266695764612339,
         0.002318271089646988,
         0.002202197411670469,
         0.001953674259359178,
         0.001624570965759033,
         0.001269775809502190,
         0.000936223195209236,
         0.000656076842599899

};
     */

    // ******************************************************
    /*
     * Hilbert 90 Degree, "Phase-added" bandpass filter
     * Kaiser Window FIR Filter, Beta = 4.50, Raised Cosine = 0.90
     * Fc = 1.34 kHz
     * BW = 2.59 kHz
     * 89 Taps
     * -1dB @ 586, 2262 Hz
     * -3dB @ 375, 2590 Hz
     * -6dB @ 281, 2801 Hz
     * -20dB >3350 Hz
     *
     * 20141203 by KA7OEI using Iowa Hills Hilbert Filter Designer
     */
    // 90.00 degrees
    //
    /*
const float q_tx_coeffs[HILBERT_NUM_TAPS] =
{
        -0.000526928409407497,
        -0.000682168851958448,
        -0.000839767578541472,
        -0.000981498412862589,
        -0.00108769943509687,
        -0.00114219260999309,
        -0.00113825881575537,
        -0.00108453094116136,
        -0.00100932782529027,
        -0.00096187275813581,
        -0.00100910869681224,
        -0.00122746365506947,
        -0.00168987888293049,
        -0.00244954977667187,
        -0.00352293473620201,
        -0.00487541234223226,
        -0.00641327332564779,
        -0.00798534440534439,
        -0.0093963912970918,
        -0.0104326182261427,
        -0.0108973047564267,
        -0.0106522625924804,
        -0.00965879884616354,
        -0.00801068418291469,
        -0.00595160530612727,
        -0.00387092484966974,
        -0.00227424342160432,
        -0.00172897224095695,
        -0.00278936501052668,
        -0.00590954769707433,
        -0.0113562931550096,
        -0.0191349550525017,
        -0.0289416425545354,
        -0.0401522247733495,
        -0.0518542997346794,
        -0.0629223963586435,
        -0.0721302338128361,
        -0.0782878354349201,
        -0.0803866797961855,
        -0.0777336957317831,
        -0.0700552787875277,
        -0.0575557105123902,
        -0.040920032384147,
        -0.0212587852711883,
        -879.3219467956480E-18,
         0.021258785271186593,
         0.040920032384145433,
         0.057555710512388988,
         0.070055278787526834,
         0.077733695731782626,
         0.080386679796185356,
         0.078287835434920336,
         0.072130233812836633,
         0.062922396358644245,
         0.051854299734680302,
         0.040152224773350405,
         0.028941642554536236,
         0.019134955052502414,
         0.011356293155010121,
         0.005909547697074680,
         0.002789365010526848,
         0.001728972240956973,
         0.002274243421604222,
         0.003870924849669563,
         0.005951605306127063,
         0.008010684182914484,
         0.009658798846163363,
         0.010652262592480283,
         0.010897304756426593,
         0.010432618226142680,
         0.009396391297091819,
         0.007985344405344439,
         0.006413273325647856,
         0.004875412342232334,
         0.003522934736202069,
         0.002449549776671917,
         0.001689878882930529,
         0.001227463655069487,
         0.001009108696812252,
         0.000961872758135811,
         0.001009327825290265,
         0.001084530941161355,
         0.001138258815755372,
         0.001142192609993090,
         0.001087699435096872,
         0.000981498412862595,
         0.000839767578541479,
         0.000682168851958454,
         0.000526928409407502
};
     */
