/*  -*-  mode: c; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4; coding: utf-8  -*-  */
/************************************************************************************
**                                                                                 **
**                               mcHF QRP Transceiver                              **
**                             K Atanassov - M0NKA 2014                            **
**                                                                                 **
**---------------------------------------------------------------------------------**
**                                                                                 **
**  File name:                                                                     **
**  Description:                                                                   **
**  Last Modified:                                                                 **
**  Licence:		CC BY-NC-SA 3.0                                                **
************************************************************************************/

#include "filters.h"
//
// Filter designed 20141202 by C. Turner, KA7OEI using MatLAB fdatools
//
// NOTE:
//	- IIR structure is Lattice Autoregressive Moving-Average (ARMA)
//	- ARM FIR/IIR algorithms require time reverse-order coefficients!!!
//
// 12KSPS sample rate (e.g. 4x decimation)
//
//	Example of the nominal 1412 Hz center-frequency Filter:
//
//	10th order Elliptic bandpass filter,
//
//	Fpass:  320, 2480 Hz
//	-6dB points:  299, 2602 Hz
//	-20dB points:  264,2834
//	-40dB points:  218,3193
//	-60dB points:  194, 3424
//
#define IIR_2k3_numStages 10
//
const arm_iir_lattice_instance_f32 IIR_2k3_1k412 =
{
    .numStages = IIR_2k3_numStages,
    .pkCoeffs  = (float*) (const float[])
    {
        0.2701467400288,
        -0.5337350112524,
        0.6958962164633,
        -0.758453902622,
        0.7839709967998,
        -0.6094204682748,
        0.8900165832056,
        -0.9710784743018,
        0.9983628970738,
        -0.9859502653937
    },

    .pvCoeffs = (float*) (const float[])
    {
        -0.01711398845885,
        -0.07116858148666,
        -0.1254973880951,
        -0.06367087681021,
        0.08889589696012,
        0.1046947051957,
        0.01366010226719,
        -0.008501456104369,
        -0.003625645738643,
        -9.123722957357e-05,
        2.159311905e-05
    }
};
//
// 1275Hz Center Frequency (-150 Hz)
//
const arm_iir_lattice_instance_f32 IIR_2k3_1k275 =
{
    .numStages = IIR_2k3_numStages,
    .pkCoeffs  = (float*) (const float[])
    {
        0.2712876748428,
        -0.5735340804203,
        0.7173137797694,
        -0.8175461411882,
        0.7315460152375,
        -0.7167786129066,
        0.9767475626606,
        -0.9943753177254,
        0.9995379196189,
        -0.9965283982769
    },

    .pvCoeffs = (float*) (const float[])
    {
        -0.01695089378394,
        -0.0754815863035,
        -0.1545067828949,
        -0.1337099532882,
        0.01250868380934,
        0.08652620679791,
        0.03662597834324,
        0.002809508493456,
        -0.0003479014294362,
        -1.019626375571e-05,
        3.955657094032e-07
    }
};
//
// 1562Hz Center Frequency (+150 Hz)
//
const arm_iir_lattice_instance_f32 IIR_2k3_1k562 =
{
    .numStages = IIR_2k3_numStages,
    .pkCoeffs  = (float*) (const float[])
    {
        0.2704722354583,
        -0.4930194577195,
        0.6788797346477,
        -0.6985554426272,
        0.8006644381482,
        -0.5854106964209,
        0.7723103700212,
        -0.9113575606699,
        0.9964165920158,
        -0.9679083606539
    },

    .pvCoeffs = (float*) (const float[])
    {
        -0.01706725280562,
        -0.06549445078988,
        -0.09465636014278,
        -0.0006279147552571,
        0.1380031454132,
        0.08863098032502,
        -0.03386873453512,
        -0.03178190420391,
        -0.008447346315031,
        -3.073326593073e-05,
        0.0001862218852526
    }
};
//
// 1712Hz Center Frequency (+300 Hz)
//
const arm_iir_lattice_instance_f32 IIR_2k3_1k712 =
{
    .numStages = IIR_2k3_numStages,
    .pkCoeffs  = (float*) (const float[])
    {
        0.2717781074202,
        -0.4503076240765,
        0.6654292686672,
        -0.6366299962827,
        0.8010323775887,
        -0.5867121495116,
        0.6883638854733,
        -0.7934171013092,
        0.9929975817319,
        -0.9418087297114
    },

    .pvCoeffs = (float*) (const float[])
    {
        -0.01688140653005,
        -0.05893233949881,
        -0.06391130117223,
        0.05125151954747,
        0.1565612599346,
        0.0457952816904,
        -0.08390530500971,
        -0.04184467503704,
        -0.003607973662997,
        0.001058321053835,
        0.0006829825631745
    }
};


//
// low pass version
// DD4WH 2016-02-03
//
const arm_iir_lattice_instance_f32 IIR_2k3_LPF =
{
    .numStages = IIR_2k3_numStages,
    .pkCoeffs  = (float*) (const float[])
    {
        0.334304700393179,
        -0.637973146829989,
        0.767879751187593,
        -0.768295057186220,
        0.892741024882815,
        -0.599613288253562,
        0.988679362407979,
        -0.418706450963394,
        0.999461427988613,
        -0.366491706976845
    },

    .pvCoeffs = (float*) (const float[])
    {
        0.00941076764313990,
        0.0423681593287898,
        0.101315269975374,
        0.134840512300872,
        0.100835720101395,
        0.0295355484872365,
        -0.0131806481791514,
        -0.00292265408570726,
        -0.00146862219082368,
        -2.39931441286178e-05,
        5.02684297614079e-05
    }
};


