/*  -*-  mode: c; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4; coding: utf-8  -*-  */
/************************************************************************************
**                                                                                 **
**                               mcHF QRP Transceiver                              **
**                             K Atanassov - M0NKA 2014                            **
**                                                                                 **
**---------------------------------------------------------------------------------**
**                                                                                 **
**  File name:                                                                     **
**  Description:                                                                   **
**  Last Modified:                                                                 **
**  Licence:		CC BY-NC-SA 3.0                                                **
************************************************************************************/

#include "filters.h"

/*
 	 * Hilbert 0 Degree, "Phase-added" bandpass filter
     * Kaiser Window FIR Filter, Beta = 5.75, Raised Cosine = 0.91
     * Fc = 2.26 kHz (0.094)
     * BW = 5.18 kHz (0.216)
     * 89 Taps
     *
     * 20140926 by KA7OEI using Iowa Hills Hilbert Filter Designer
     *
     * This filter used in the "5 kHz" RX filter position of the mcHF
*/

const float i_rx_5k_coeffs[I_NUM_TAPS] =
{
    -0.000043426876234221,
    -0.000002191990883891,
    0.000072100444851007,
    0.000146190293613914,
    0.000162704382674571,
    0.000066535363009479,
    -0.000155548384183247,
    -0.000442544978997593,
    -0.000659286380153237,
    -0.000644151194132718,
    -0.000295663946034226,
    0.000338912701649684,
    0.001026081281354910,
    0.001402678737462120,
    0.001129822554695560,
    0.000091825203377056,
    -0.001456726133406820,
    -0.002896198394872420,
    -0.003447955277936570,
    -0.002534414503289770,
    -0.000147860375526197,
    0.002965697373513680,
    0.005459552760619980,
    0.005894146203596460,
    0.003438147321799850,
    -0.001541483020624470,
    -0.007327786088968630,
    -0.011330883354589200,
    -0.011119371587417100,
    -0.005641858261680950,
    0.003903164621667750,
    0.014047162409269700,
    0.020090889315570000,
    0.017969387041418500,
    0.006287588083231960,
    -0.012331139064764000,
    -0.031298832636285500,
    -0.041758619925634300,
    -0.035513772267946100,
    -0.008218535082724620,
    0.038370728643609200,
    0.096051808777281600,
    0.152065307042769000,
    0.192718944802348000,
    0.207569195237242000,
    0.192718944802350000,
    0.152065307042773000,
    0.096051808777286500,
    0.038370728643613700,
    -0.008218535082721400,
    -0.035513772267944600,
    -0.041758619925634400,
    -0.031298832636286800,
    -0.012331139064765700,
    0.006287588083230530,
    0.017969387041417800,
    0.020090889315570100,
    0.014047162409270400,
    0.003903164621668730,
    -0.005641858261680100,
    -0.011119371587416700,
    -0.011330883354589200,
    -0.007327786088968960,
    -0.001541483020624950,
    0.003438147321799410,
    0.005894146203596200,
    0.005459552760619940,
    0.002965697373513800,
    -0.000147860375526001,
    -0.002534414503289590,
    -0.003447955277936450,
    -0.002896198394872390,
    -0.001456726133406850,
    0.000091825203377008,
    0.001129822554695520,
    0.001402678737462110,
    0.001026081281354920,
    0.000338912701649701,
    -0.000295663946034212,
    -0.000644151194132715,
    -0.000659286380153244,
    -0.000442544978997604,
    -0.000155548384183257,
    0.000066535363009474,
    0.000162704382674572,
    0.000146190293613918,
    0.000072100444851011,
    -0.000002191990883889,
    -0.000043426876234222
};

/*
 	 * Hilbert -90 Degree, "Phase-added" bandpass filter
     * Kaiser Window FIR Filter, Beta = 5.75, Raised Cosine = 0.91
     * Fc = 2.26 kHz (0.094)
     * BW = 5.18 kHz (0.216)
     * 89 Taps
     *
     * 20140926 by KA7OEI using Iowa Hills Hilbert Filter Designer
     *
     * This filter used in the "5 kHz" RX filter position of the mcHF
*/

const float q_rx_5k_coeffs[Q_NUM_TAPS] =
{
    -0.000244980985528691,
    -0.000347789813473586,
    -0.000425078153010145,
    -0.000448763158936282,
    -0.000420322539018952,
    -0.000389284931487302,
    -0.000448339897619816,
    -0.000696509734376426,
    -0.001179343074410010,
    -0.001834241072906750,
    -0.002477976837947990,
    -0.002862517423084040,
    -0.002793753579540190,
    -0.002267579471863340,
    -0.001550226963332890,
    -0.001135646391952200,
    -0.001559764996933380,
    -0.003125748151512350,
    -0.005662072484418450,
    -0.008456129976425170,
    -0.010454737653444400,
    -0.010706772492615500,
    -0.008887126448895160,
    -0.005652790230673340,
    -0.002600407049719820,
    -0.001737597830779160,
    -0.004604577313575180,
    -0.011393047427725000,
    -0.020496815351686600,
    -0.028822018101713000,
    -0.032894718996434200,
    -0.030432401608287900,
    -0.021754675464189900,
    -0.010349616956207100,
    -0.002154904176932250,
    -0.003597919311527080,
    -0.018986944853669100,
    -0.048223040884669100,
    -0.085820731021050400,
    -0.121831672840137000,
    -0.144578590842228000,
    -0.144383936275588000,
    -0.117013881754043000,
    -0.065562309685199800,
    -0.000000000000002786,
    0.065562309685194800,
    0.117013881754040000,
    0.144383936275587000,
    0.144578590842229000,
    0.121831672840140000,
    0.085820731021053400,
    0.048223040884671900,
    0.018986944853670900,
    0.003597919311527760,
    0.002154904176931900,
    0.010349616956206200,
    0.021754675464188900,
    0.030432401608287300,
    0.032894718996434200,
    0.028822018101713400,
    0.020496815351687300,
    0.011393047427725700,
    0.004604577313575620,
    0.001737597830779280,
    0.002600407049719650,
    0.005652790230673030,
    0.008887126448894850,
    0.010706772492615300,
    0.010454737653444300,
    0.008456129976425250,
    0.005662072484418580,
    0.003125748151512460,
    0.001559764996933430,
    0.001135646391952190,
    0.001550226963332840,
    0.002267579471863290,
    0.002793753579540160,
    0.002862517423084040,
    0.002477976837948020,
    0.001834241072906790,
    0.001179343074410040,
    0.000696509734376440,
    0.000448339897619815,
    0.000389284931487292,
    0.000420322539018941,
    0.000448763158936277,
    0.000425078153010148,
    0.000347789813473593,
    0.000244980985528699
};
#if 0
// -89.5 degrees
const float q_rx_5k_coeffs_minus[Q_NUM_TAPS] =
{
    -0.000245350075079331,
    -0.000347795713461264,
    -0.000424433794956601,
    -0.000447472342367739,
    -0.000418888911273699,
    -0.000388690421520361,
    -0.000449678206379025,
    -0.000700339283187546,
    -0.001185042809848820,
    -0.001839784077862940,
    -0.002480458973064010,
    -0.002859455771313040,
    -0.002784707100632570,
    -0.002255271593509290,
    -0.001540323760157880,
    -0.001134803200767200,
    -0.001572398546231340,
    -0.003150864677691160,
    -0.005691900320141490,
    -0.008477891909581240,
    -0.010455629213769400,
    -0.010680525438263900,
    -0.008839218994227760,
    -0.005601218825717410,
    -0.002570351096310890,
    -0.001750963134650860,
    -0.004668251022661230,
    -0.011491343286493200,
    -0.020592922761441300,
    -0.028870082888857800,
    -0.032859461529462900,
    -0.030308850915445600,
    -0.021578793909475900,
    -0.010192653316861700,
    -0.002100037385667660,
    -0.003705226437255490,
    -0.019258937233559700,
    -0.048585061912961300,
    -0.086126912544719800,
    -0.121898658837962000,
    -0.144238772008071000,
    -0.143541538076527000,
    -0.115684465520033000,
    -0.063880622881559600,
    0.001808591785932280,
    0.067239020067275900,
    0.118334416202056000,
    0.145215375200384000,
    0.144907435627121000,
    0.121755439368177000,
    0.085508035386790200,
    0.047857359549391400,
    0.018713511294508700,
    0.003490339090429200,
    0.002209607403007040,
    0.010505795021382500,
    0.021928905758651300,
    0.030553642369399100,
    0.032927479632687100,
    0.028771765616896700,
    0.020399152157911200,
    0.011293886794560300,
    0.004540554100057460,
    0.001724100636811750,
    0.002630265622624950,
    0.005703932567963280,
    0.008934359337826670,
    0.010732206863372900,
    0.010453052539900900,
    0.008433726191758400,
    0.005631814876472510,
    0.003100394369499240,
    0.001547013055708840,
    0.001136403383379810,
    0.001560012498553200,
    0.002279715232556680,
    0.002802588002228120,
    0.002865361799205570,
    0.002475306615233830,
    0.001828558842275610,
    0.001173553822474200,
    0.000692627317902864,
    0.000446967558205752,
    0.000389849893289518,
    0.000421724262730382,
    0.000450019912722868,
    0.000425690246061206,
    0.000347757514953983,
    0.000244593301016048
};
// -90.5 degrees
const float q_rx_5k_coeffs_plus[Q_NUM_TAPS] =
{
    -0.000244593301016044,
    -0.000347757514953983,
    -0.000425690246061212,
    -0.000450019912722880,
    -0.000421724262730398,
    -0.000389849893289530,
    -0.000446967558205751,
    -0.000692627317902845,
    -0.001173553822474160,
    -0.001828558842275570,
    -0.002475306615233800,
    -0.002865361799205570,
    -0.002802588002228160,
    -0.002279715232556760,
    -0.001560012498553270,
    -0.001136403383379820,
    -0.001547013055708770,
    -0.003100394369499090,
    -0.005631814876472300,
    -0.008433726191758220,
    -0.010453052539900900,
    -0.010732206863373000,
    -0.008934359337826910,
    -0.005703932567963560,
    -0.002630265622625130,
    -0.001724100636811690,
    -0.004540554100057090,
    -0.011293886794559600,
    -0.020399152157910500,
    -0.028771765616896300,
    -0.032927479632687100,
    -0.030553642369399700,
    -0.021928905758652200,
    -0.010505795021383400,
    -0.002209607403007430,
    -0.003490339090428610,
    -0.018713511294507000,
    -0.047857359549388800,
    -0.085508035386787300,
    -0.121755439368174000,
    -0.144907435627120000,
    -0.145215375200385000,
    -0.118334416202059000,
    -0.067239020067280800,
    -0.001808591785937680,
    0.063880622881554700,
    0.115684465520030000,
    0.143541538076525000,
    0.144238772008072000,
    0.121898658837964000,
    0.086126912544722800,
    0.048585061912964000,
    0.019258937233561500,
    0.003705226437256110,
    0.002100037385667290,
    0.010192653316860800,
    0.021578793909475000,
    0.030308850915445000,
    0.032859461529462900,
    0.028870082888858200,
    0.020592922761442000,
    0.011491343286493800,
    0.004668251022661610,
    0.001750963134650930,
    0.002570351096310710,
    0.005601218825717120,
    0.008839218994227520,
    0.010680525438263800,
    0.010455629213769400,
    0.008477891909581410,
    0.005691900320141690,
    0.003150864677691320,
    0.001572398546231410,
    0.001134803200767180,
    0.001540323760157820,
    0.002255271593509220,
    0.002784707100632520,
    0.002859455771313040,
    0.002480458973064040,
    0.001839784077862980,
    0.001185042809848850,
    0.000700339283187565,
    0.000449678206379026,
    0.000388690421520349,
    0.000418888911273683,
    0.000447472342367727,
    0.000424433794956595,
    0.000347795713461264,
    0.000245350075079334
};
#endif
