/*  -*-  mode: c; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4; coding: utf-8  -*-  */
/************************************************************************************
**                                                                                 **
**                               mcHF QRP Transceiver                              **
**                             K Atanassov - M0NKA 2014                            **
**                                                                                 **
**---------------------------------------------------------------------------------**
**                                                                                 **
**  File name:                                                                     **
**  Description:                                                                   **
**  Last Modified:                                                                 **
**  Licence:		CC BY-NC-SA 3.0                                                **
************************************************************************************/

#include "filters.h"
/*
 	 * Hilbert 0 Degree, "Phase-added" bandpass filter
     * Kaiser Window FIR Filter, Beta = 5.75, Raised Cosine = 0.91
     * Fc = 2.26 kHz
     * BW = 15.5 kHz
     * 89 Taps
     *
     * 20140926 by KA7OEI using Iowa Hills Hilbert Filter Designer
     *
     * This filter used in the "10 kHz" RX filter position of the mcHF
*/

const float i_rx_10k_coeffs[I_NUM_TAPS] =
{
    0.000050167609691425,
    0.000025603407918848,
    -0.000118981585848916,
    -0.000170474191765324,
    0.000048296523157148,
    0.000256073107769974,
    727.2794187150840E-9,
    -0.000501261183059805,
    -0.000408327227464192,
    0.000402666023236487,
    0.000712863881140397,
    -0.0003308411712395,
    -0.0013996330569958,
    -0.000528641700743514,
    0.001455738736932886,
    0.001329912986372006,
    -0.00150961605426034,
    -0.00294679909039784,
    0.000076369628754364,
    0.003654850522527691,
    0.001577905576333736,
    -0.00432377051231776,
    -0.00486833805524385,
    0.002504357924698762,
    0.007219173741633013,
    0.000249124314985597,
    -0.00964993129867818,
    -0.00614913866004667,
    0.008394400456713639,
    0.011847880245809284,
    -0.00485256342855596,
    -0.018458064255265,
    -0.00458695963656225,
    0.020574362746561586,
    0.016624349270928814,
    -0.0185108281915374,
    -0.0333393467458619,
    0.005438341796513525,
    0.049039677508405620,
    0.020261414347031232,
    -0.0646569743752001,
    -0.0780052456437194,
    0.073784359346471568,
    0.307733691067162585,
    0.421541346382627025,
    0.307733691067179571,
    0.073784359346490025,
    -0.0780052456437136,
    -0.0646569743752061,
    0.020261414347025011,
    0.049039677508406654,
    0.005438341796518410,
    -0.0333393467458602,
    -0.01851082819154,
    0.016624349270926188,
    0.020574362746562019,
    -0.00458695963656039,
    -0.0184580642552646,
    -0.00485256342855692,
    0.011847880245808904,
    0.008394400456714472,
    -0.00614913866004598,
    -0.00964993129867861,
    0.000249124314984851,
    0.007219173741633126,
    0.002504357924699511,
    -0.00486833805524365,
    -0.00432377051231848,
    0.001577905576332938,
    0.003654850522527679,
    0.000076369628754987,
    -0.00294679909039735,
    -0.00150961605426035,
    0.001329912986371784,
    0.001455738736932826,
    -0.000528641700743405,
    -0.00139963305699574,
    -0.000330841171239577,
    0.000712863881140276,
    0.000402666023236442,
    -0.000408327227464152,
    -0.000501261183059743,
    727.2794187481990E-9,
    0.000256073107769969,
    0.000048296523157126,
    -0.000170474191765341,
    -0.000118981585848918,
    0.000025603407918855,
    0.000050167609691430
};

/*
 	 * Hilbert -90 Degree, "Phase-added" bandpass filter
     * Kaiser Window FIR Filter, Beta = 5.75, Raised Cosine = 0.91
     * Fc = 2.26 kHz
     * BW = 15.5 kHz
     * 89 Taps
     *
     * 20141203 by KA7OEI using Iowa Hills Hilbert Filter Designer
     *
     * This filter used in the "10 kHz" RX filter position of the mcHF
*/

const float q_rx_10k_coeffs[Q_NUM_TAPS] =
{
    -0.000202900475979562,
    -0.000173370254281575,
    -0.000251467848218534,
    -0.000530209040093422,
    -0.000755557012438407,
    -0.000632374975698963,
    -0.000435867293262139,
    -0.000804201474014394,
    -0.00164940424331115,
    -0.00193021734962449,
    -0.00121363387572673,
    -0.000827414291001747,
    -0.00214132611477666,
    -0.00398311091636951,
    -0.00375800964604182,
    -0.00170956409649301,
    -0.00159310443682755,
    -0.00512041852752827,
    -0.00810303580432126,
    -0.00596383822011149,
    -0.00184365603740688,
    -0.00353215000807175,
    -0.011105278808909,
    -0.0144091536349107,
    -0.00787569655878985,
    -0.00166604723989226,
    -0.00846845978512414,
    -0.0221224254196474,
    -0.023076026543239,
    -0.00860670786722982,
    -0.00220735820377942,
    -0.0202780169273636,
    -0.0419593783021394,
    -0.0347864243458702,
    -0.00746038335985415,
    -0.0070912420573716,
    -0.0499177285061674,
    -0.0837979289134878,
    -0.0556417465085305,
    -0.00435630169851503,
    -0.0347123686687518,
    -0.174525192240834,
    -0.297300969432227,
    -0.240504142849254,
    -11.10456311493300E-15,
    0.240504142849240932,
    0.297300969432230666,
    0.174525192240846311,
    0.034712368668759118,
    0.004356301698513016,
    0.055641746508526303,
    0.083797928913488418,
    0.049917728506171426,
    0.007091242057373439,
    0.007460383359852207,
    0.034786424345868192,
    0.041959378302140228,
    0.020278016927365760,
    0.002207358203779885,
    0.008606707867228393,
    0.023076026543238051,
    0.022122425419648251,
    0.008468459785125408,
    0.001666047239892347,
    0.007875696558789036,
    0.014409153634910375,
    0.011105278808909548,
    0.003532150008072225,
    0.001843656037406619,
    0.005963838220110922,
    0.008103035804321144,
    0.005120418527528628,
    0.001593104436827793,
    0.001709564096492843,
    0.003758009646041539,
    0.003983110916369502,
    0.002141326114776900,
    0.000827414291001932,
    0.001213633875726693,
    0.001930217349624349,
    0.001649404243311083,
    0.000804201474014432,
    0.000435867293262205,
    0.000632374975698988,
    0.000755557012438391,
    0.000530209040093399,
    0.000251467848218528,
    0.000173370254281586,
    0.000202900475979578,
};
#if 0
//
// Same as above, but set to -89.50 degrees
//
const float q_rx_10k_coeffs_minus[Q_NUM_TAPS] =
{
    -0.000202455664859704,
    -0.000173140592204385,
    -0.000252494994779958,
    -0.000531674265269795,
    -0.000755107532054849,
    -0.000630119807793623,
    -0.000435844416269303,
    -0.000808538456205254,
    -0.00165289941631983,
    -0.00192663566416262,
    -0.00120737662217022,
    -0.000830265518962948,
    -0.00215343989019978,
    -0.00398756583310063,
    -0.00374518315395325,
    -0.00169791166090659,
    -0.0016061973003426,
    -0.00514589974511933,
    -0.00810206290191975,
    -0.00593176711182757,
    -0.00182983774837564,
    -0.00356968907954881,
    -0.0111472753261672,
    -0.014386786313359,
    -0.00781249687222602,
    -0.00166381339141727,
    -0.00855221849211168,
    -0.0221751635049472,
    -0.0230020102615523,
    -0.00850315041764785,
    -0.0022495549325951,
    -0.0204380729464628,
    -0.0419977523187501,
    -0.0346058393982551,
    -0.00731525192982586,
    -0.00725225821850147,
    -0.0502063207098376,
    -0.0837473645759942,
    -0.0552123512270397,
    -0.00417959823251785,
    -0.0352744090683207,
    -0.175198230840336,
    -0.296646802759013,
    -0.23781372575567,
    0.003672899131290362,
    0.243176306751765409,
    0.297932572288734043,
    0.173838907958167449,
    0.034147693755331297,
    0.004532674540653624,
    0.056066918829789127,
    0.083842133362171958,
    0.049625347769692935,
    0.006929687702619956,
    0.007604948580079531,
    0.034964369159129032,
    0.041917819755983292,
    0.020116421897283545,
    0.002164993946328076,
    0.008709612106095409,
    0.023148291457499595,
    0.022068008340992647,
    0.008384058359835342,
    0.001668154642817476,
    0.007938298515133682,
    0.014430427366009982,
    0.011062439450553222,
    0.003494342862173716,
    0.001857334401172949,
    0.005995456699690846,
    0.008103393722469368,
    0.005094548693024019,
    0.001579890663796087,
    0.001721086783794211,
    0.003770550921970162,
    0.003978353699296656,
    0.002129049822258510,
    0.000824500265988833,
    0.001219799019888545,
    0.001933652540204042,
    0.001645783887881715,
    0.000799803456520885,
    0.000435857089872780,
    0.000634582149165994,
    0.000755949149416795,
    0.000528703574417232,
    0.000250421616369738,
    0.000173586758330236,
    0.000203329887858864
};
//
//
// Same as above, but set to -90.50 degrees
//
const float q_rx_10k_coeffs_plus[Q_NUM_TAPS] =
{
    -0.000203329887858879,
    -0.000173586758330246,
    -0.000250421616369715,
    -0.000528703574417194,
    -0.000755949149416803,
    -0.000634582149166068,
    -0.000435857089872831,
    -0.000799803456520821,
    -0.0016457838878816,
    -0.00193365254020404,
    -0.00121979901988869,
    -0.000824500265988919,
    -0.00212904982225838,
    -0.00397835369929647,
    -0.00377055092197019,
    -0.0017210867837944,
    -0.00157989066379611,
    -0.0050945486930238,
    -0.00810339372246924,
    -0.00599545669969104,
    -0.0018573344011731,
    -0.00349434286217341,
    -0.0110624394505528,
    -0.0144304273660101,
    -0.00793829851513429,
    -0.00166815464281749,
    -0.00838405835983441,
    -0.022068008340992,
    -0.0231482914575004,
    -0.00870961210609662,
    -0.00216499394632763,
    -0.0201164218972816,
    -0.0419178197559826,
    -0.034964369159131,
    -0.00760494858008132,
    -0.00692968770261807,
    -0.049625347769689,
    -0.0838421333621716,
    -0.0560669188297936,
    -0.00453267454065583,
    -0.0341476937553239,
    -0.173838907958155,
    -0.29793257228873,
    -0.243176306751779,
    -0.00367289913131262,
    0.237813725755656402,
    0.296646802759017059,
    0.175198230840349134,
    0.035274409068328134,
    0.004179598232515747,
    0.055212351227035175,
    0.083747364575994507,
    0.050206320709841545,
    0.007252258218503405,
    0.007315251929824108,
    0.034605839398253145,
    0.041997752318750713,
    0.020438072946464797,
    0.002249554932595578,
    0.008503150417646649,
    0.023002010261551485,
    0.022175163504947821,
    0.008552218492112613,
    0.001663813391417275,
    0.007812496872225425,
    0.014386786313358855,
    0.011147275326167612,
    0.003569689079549125,
    0.001829837748375495,
    0.005931767111827379,
    0.008102062901919874,
    0.005145899745119554,
    0.001606197300342580,
    0.001697911660906403,
    0.003745183153953228,
    0.003987565833100819,
    0.002153439890199912,
    0.000830265518962865,
    0.001207376622170074,
    0.001926635664162619,
    0.001652899416319948,
    0.000808538456205320,
    0.000435844416269254,
    0.000630119807793549,
    0.000755107532054840,
    0.000531674265269833,
    0.000252494994779981,
    0.000173140592204375,
    0.000202455664859689
};

#endif
