/*  -*-  mode: c; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4; coding: utf-8  -*-  */
/************************************************************************************
**                                                                                 **
**                               mcHF QRP Transceiver                              **
**                             K Atanassov - M0NKA 2014                            **
**                                                                                 **
**---------------------------------------------------------------------------------**
**                                                                                 **
**  File name:                                                                     **
**  Description:                                                                   **
**  Last Modified:                                                                 **
**  Licence:		CC BY-NC-SA 3.0                                                **
************************************************************************************/

#include "filters.h"
//
// Filter designed 20141202 by C. Turner, KA7OEI using MatLAB fdatools
//
// NOTE:
//	- IIR structure is Lattice Autoregressive Moving-Average (ARMA)
//	- ARM FIR/IIR algorithms require time reverse-order coefficients!!!
//
// *** 12 KSPS Sample Rate!
//
//	Nominal 1420 Hz center-frequency Filter:
//
//	10th order Elliptic bandpass filter, 0.5db ripple
//	Fpass:  582, 2250 Hz
//	-6dB points:  552, 2350 Hz
//	-20dB points:  500, 2525  500, 2519 Hz
//	-40dB points:  428, 2830
//	-60dB points:  384, 3030
//
#define IIR_1k8_numStages 10
const arm_iir_lattice_instance_f32 IIR_1k8_1k425 =
{
    .numStages = IIR_1k8_numStages,
    .pkCoeffs  = (float*) (const float[])
    {
        0.3633117201536,
        -0.6014671698188,
        0.790691903771,
        -0.7552408736771,
        0.8655745295849,
        -0.7100967246513,
        0.8371692151707,
        -0.858604704342,
        0.9948942198536,
        -0.9504411745978
    },

    .pvCoeffs = (float*) (const float[])
    {
        -0.008451821550603,
        -0.03028239739489,
        -0.04383575807689,
        -0.005801028198445,
        0.0552803520222,
        0.0409926115824,
        -0.009867881161988,
        -0.01912289835012,
        -0.003305206206671,
        0.0001846251381343,
        0.0001533411723535
    }
};
//
// -150 Hz, 1275 Hz center frequency
//
const arm_iir_lattice_instance_f32 IIR_1k8_1k275 =
{
    .numStages = IIR_1k8_numStages,
    .pkCoeffs  = (float*) (const float[])
    {
        0.3615632509154,
        -0.6426687049878,
        0.8022155117307,
        -0.8033168968408,
        0.8624152554717,
        -0.7373416322104,
        0.8853268131748,
        -0.9382217524638,
        0.9974058005444,
        -0.9743269012915
    },

    .pvCoeffs = (float*) (const float[])
    {
        -0.008554020969071,
        -0.03290507946195,
        -0.05669748976757,
        -0.03112515335395,
        0.03458656760459,
        0.04515075118067,
        0.009972736163013,
        -0.008871404867662,
        -0.002779915015395,
        -3.149002424411e-05,
        3.311102598764e-05
    }
};
//
// -300 Hz, 1125 Hz center frequency
//
const arm_iir_lattice_instance_f32 IIR_1k8_1k125 =
{
    .numStages = IIR_1k8_numStages,
    .pkCoeffs  = (float*) (const float[])
    {
        0.3613452928877,
        -0.6810107467819,
        0.8170984050044,
        -0.8463544066134,
        0.8511170107767,
        -0.7821275475669,
        0.9480716019822,
        -0.9808799929708,
        0.9989026674026,
        -0.9900683804108
    },

    .pvCoeffs = (float*) (const float[])
    {
        -0.008566871148577,
        -0.03494144528,
        -0.06850457739963,
        -0.05800592969749,
        0.004948888629599,
        0.03640087677665,
        0.0202191966789,
        -0.0005739689668037,
        -0.0007471474016795,
        -1.814984183384e-05,
        2.538959875177e-06
    }
};
//
// +150 Hz, 1575 Hz center frequency
//
const arm_iir_lattice_instance_f32 IIR_1k8_1k575 =
{
    .numStages = IIR_1k8_numStages,
    .pkCoeffs  = (float*) (const float[])
    {
        0.3613452928877,
        -0.5528878303048,
        0.7775941425073,
        -0.6999131353729,
        0.8628162750942,
        -0.6773588830313,
        0.8145733229607,
        -0.7494991964062,
        0.9906935090308,
        -0.919454179607
    },

    .pvCoeffs = (float*) (const float[])
    {
        -0.008566871148577,
        -0.02836768723528,
        -0.03226930906751,
        0.01640676037123,
        0.0677730883021,
        0.02700913837121,
        -0.03345776958501,
        -0.02430295670566,
        0.001987515414669,
        0.001005716985531,
        0.0003676617652895
    }
};
//
// +300 Hz, 1725 Hz center frequency
//
const arm_iir_lattice_instance_f32 IIR_1k8_1k725 =
{
    .numStages = IIR_1k8_numStages,
    .pkCoeffs  = (float*) (const float[])
    {
        0.3624364166222,
        -0.5040846071146,
        0.7692947989321,
        -0.6409554520074,
        0.8607689220576,
        -0.6376837263631,
        0.8178885035622,
        -0.6240753437248,
        0.9834623152838,
        -0.8795808576955
    },

    .pvCoeffs = (float*) (const float[])
    {
        -0.008502787721249,
        -0.02559366076952,
        -0.0200387077241,
        0.03413786956908,
        0.06758199161391,
        0.004017644116835,
        -0.05236928020393,
        -0.01897401359474,
        0.01339055818279,
        0.002528542455842,
        0.0004151390011982
    }
};
//
// low pass filter
// DD4WH 2016-02-03
//
const arm_iir_lattice_instance_f32 IIR_1k8_LPF =
{
    .numStages = IIR_1k8_numStages,
    .pkCoeffs  = (float*) (const float[])
    {
        0.424104469409253,
        -0.760957161720464,
        0.856135458808337,
        -0.865387150235557,
        0.919773037078837,
        -0.777255196618113,
        0.989521498539331,
        -0.637962725222723,
        0.999554271439240,
        -0.594257795338158
    },

    .pvCoeffs = (float*) (const float[])
    {
        0.00500807056613645,
        0.0194715681066562,
        0.0436864315353799,
        0.0548773806707592,
        0.0438480552375318,
        0.0181134030340657,
        0.00228635234567699,
        -9.48681761683695e-05,
        -0.000791691993306771,
        -1.47032013899616e-05,
        -2.00621568867149e-06
    }
};

