/*  -*-  mode: c; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4; coding: utf-8  -*-  */
/************************************************************************************
**                                                                                 **
**                               mcHF QRP Transceiver                              **
**                             K Atanassov - M0NKA 2014                            **
**                                                                                 **
**---------------------------------------------------------------------------------**
**                                                                                 **
**  File name:                                                                     **
**  Description:                                                                   **
**  Last Modified:                                                                 **
**  Licence:		CC BY-NC-SA 3.0                                                **
************************************************************************************/

#ifndef __I_TX_FILTER_H
#define __I_TX_FILTER_H

#define I_TX_BLOCK_SIZE		1
#define I_TX_NUM_TAPS			89


/*
 	 * Hilbert 0 Degree, "Phase-added" bandpass filter
     * Kaiser Window FIR Filter, Beta = 3.25, Raised Cosine = 9.30
     * Fc = 1.68 kHz
     * BW = 2.40 kHz
     * 89 Taps
     * -1dB @ 809, 2570 Hz
     * -3dB @ 562, 2790 Hz
     * -6dB @ 363, 3000 Hz
     *
     * 20140926 by KA7OEI using Iowa Hills Hilbert Filter Designer
*/

const float i_tx_coeffs[I_NUM_TAPS] =
{
    -0.00136963387867902,
    -0.00154698180275283,
    -0.00159163053382545,
    -0.00147741661877843,
    -0.00120882701502872,
    -0.000828478315201928,
    -0.000418097593646548,
    -0.000091320092875327,
    0.000021974130050419,
    -0.000201673787010635,
    -0.000852848114713485,
    -0.00196364687958346,
    -0.00348826112570551,
    -0.00529485706179518,
    -0.00717256931124521,
    -0.00885513209567824,
    -0.0100597130451815,
    -0.0105363454629951,
    -0.0101205604704021,
    -0.00877998921294567,
    -0.00664532045021418,
    -0.0040173326042396,
    -0.00134475617619414,
    0.000827871099573030,
    0.001938042460603026,
    0.001499434597820090,
    -0.000801076170127474,
    -0.00501923657539354,
    -0.010897625153546,
    -0.0178510089292003,
    -0.0250004081740564,
    -0.0312564601726055,
    -0.0354449414126899,
    -0.0364600276636809,
    -0.0334252713705447,
    -0.0258393894626836,
    -0.0136844336323678,
    0.002522103222162365,
    0.021742633556248399,
    0.042504479356303283,
    0.063046761438677143,
    0.081512148546264832,
    0.096159368648113891,
    0.105568648975492965,
    0.108812511216631644,
    0.105568648975493493,
    0.096159368648114876,
    0.081512148546266205,
    0.063046761438678753,
    0.042504479356305004,
    0.021742633556250075,
    0.002522103222163864,
    -0.0136844336323666,
    -0.0258393894626828,
    -0.0334252713705442,
    -0.0364600276636808,
    -0.0354449414126901,
    -0.0312564601726059,
    -0.0250004081740569,
    -0.0178510089292009,
    -0.0108976251535465,
    -0.00501923657539393,
    -0.000801076170127733,
    0.001499434597819978,
    0.001938042460603051,
    0.000827871099573164,
    -0.00134475617619393,
    -0.00401733260423937,
    -0.00664532045021396,
    -0.0087799892129455,
    -0.010120560470402,
    -0.0105363454629951,
    -0.0100597130451816,
    -0.00885513209567832,
    -0.00717256931124532,
    -0.00529485706179529,
    -0.00348826112570562,
    -0.00196364687958354,
    -0.000852848114713534,
    -0.000201673787010652,
    0.000021974130050428,
    -0.0000913200928753,
    -0.000418097593646515,
    -0.000828478315201898,
    -0.0012088270150287,
    -0.00147741661877842,
    -0.00159163053382547,
    -0.00154698180275285,
    -0.0013696339
};

//static float32_t 		FirState_I_TX[128];
//arm_fir_instance_f32 	FIR_I_TX;

// *****************************************


/*
 	 * Hilbert 0 Degree, "Phase-added" bandpass filter
     * Kaiser Window FIR Filter, Beta = 4.50, Raised Cosine = 0.90
     * Fc = 1.34 kHz
     * BW = 2.59 kHz
     * 89 Taps
     * -1dB @ 586, 2262 Hz
     * -3dB @ 375, 2590 Hz
     * -6dB @ 281, 2801 Hz
     * -20dB >3350 Hz
     *
     * 20141203 by KA7OEI using Iowa Hills Hilbert Filter Designer
*/
/*
const float i_tx_coeffs[I_NUM_TAPS] =
{
		-0.000192875376876728,
		-0.000182740263881208,
		-0.000140891715454915,
		-0.00006838009139126,
		 0.000023805288625652,
		 0.000113204625330436,
		 0.000166732821526421,
		 0.000144525647240612,
		 6.867219960430160E-6,
		-0.000276440128730619,
		-0.000715671112495218,
		-0.00129179592920764,
		-0.00195053373657144,
		-0.00260215863827949,
		-0.00312874866340919,
		-0.00339942340417407,
		-0.00329258338096766,
		-0.00272248284860552,
		-0.00166595472984103,
		-0.000184104091196061,
		 0.001566403782619490,
		 0.003337021727061818,
		 0.004808684980596975,
		 0.005630882640480853,
		 0.005475266742216030,
		 0.004097459914051238,
		 0.001398159252556323,
		-0.00252676885539993,
		-0.00735733549494755,
		-0.0125498193984163,
		-0.0173711247134924,
		-0.0209669219262358,
		-0.0224580250716578,
		-0.021054384563457,
		-0.0161721630791137,
		-0.00753736501650615,
		 0.004740100057217369,
		 0.020135096635881311,
		 0.037726671975072013,
		 0.056269419247174567,
		 0.074310657942761607,
		 0.090340451113308615,
		 0.102956241234166010,
		 0.111021125206319293,
		 0.113795008726467584,
		 0.111021125206319737,
		 0.102956241234166856,
		 0.090340451113309767,
		 0.074310657942762981,
		 0.056269419247176052,
		 0.037726671975073518,
		 0.020135096635882685,
		 0.004740100057218542,
		-0.00753736501650524,
		-0.0161721630791131,
		-0.0210543845634566,
		-0.0224580250716578,
		-0.020966921926236,
		-0.0173711247134927,
		-0.0125498193984166,
		-0.00735733549494792,
		-0.00252676885540028,
		 0.001398159252556051,
		 0.004097459914051059,
		 0.005475266742215946,
		 0.005630882640480855,
		 0.004808684980597044,
		 0.003337021727061931,
		 0.001566403782619622,
		-0.000184104091195931,
		-0.00166595472984091,
		-0.00272248284860544,
		-0.00329258338096761,
		-0.00339942340417405,
		-0.00312874866340919,
		-0.0026021586382795,
		-0.00195053373657147,
		-0.00129179592920766,
		-0.00071567111249524,
		-0.000276440128730636,
		 6.867219960419110E-6,
		 0.000144525647240606,
		 0.000166732821526418,
		 0.000113204625330434,
		 0.000023805288625650,
		-0.000068380091391264,
		-0.00014089171545492,
		-0.000182740263881214,
		-0.0001928754
};
*/


#endif
