/*  -*-  mode: c; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4; coding: utf-8  -*-  */
/************************************************************************************
**                                                                                 **
**                               mcHF QRP Transceiver                              **
**                             K Atanassov - M0NKA 2014                            **
**                                                                                 **
**---------------------------------------------------------------------------------**
**                                                                                 **
**  File name:                                                                     **
**  Description:                                                                   **
**  Last Modified:                                                                 **
**  Licence:		CC BY-NC-SA 3.0                                                **
************************************************************************************/

#include "filters.h"

/*
 	 * Hilbert 0 Degree. "Phase-added" bandpass filter
     * Kaiser Window FIR Filter. Beta = 3.60. Raised Cosine = 0.900
     * Fc = 2.26 kHz (0.094)
     * BW = 4.22 kHz (0.176)
     * 89 Taps
     * -6dB @ 4.5kHz
     * -20dB @ 5.0kHz
     * 2015_03_25 using Iowa Hills Hilbert Filter Designer
     *
     * alternative 5k filter to prevent heterodynes from broadcast stations
*/

const float i_rx_4k5_coeffs[I_NUM_TAPS] =
{
    -0.000114684476611150,
    -0.000262026463852400,
    -0.000525079926366648,
    -0.000856895401357901,
    -0.001155346066789558,
    -0.001291412809444851,
    -0.001162461699167819,
    -0.000752859143356339,
    -0.000174526350995810,
    0.000339209274693749,
    0.000499091989579864,
    0.000073046133119666,
    -0.000990692558959441,
    -0.002483730068330094,
    -0.003949697866924680,
    -0.004809200839481030,
    -0.004573567863659000,
    -0.003078011202014869,
    -0.000638626685125715,
    0.001953234817610510,
    0.003637209015720170,
    0.003452946429967226,
    0.000957265431653208,
    -0.003470989783383569,
    -0.008588055227867054,
    -0.012579847423775045,
    -0.013649920003274866,
    -0.010731018466373097,
    -0.004067797998680700,
    0.004581360716053101,
    0.012278059716614777,
    0.015754672994053639,
    0.012568743010528889,
    0.002200133195956026,
    -0.013308468167863059,
    -0.029468141633492831,
    -0.040299609990182284,
    -0.039936386122568675,
    -0.024443035202845947,
    0.006703267809696158,
    0.049967108367624413,
    0.098223404077723703,
    0.142291077462080584,
    0.173150725191446780,
    0.184237040208864111,
    0.173150725191419053,
    0.142291077462031068,
    0.098223404077662682,
    0.049967108367563948,
    0.006703267809647070,
    -0.024443035202876579,
    -0.039936386122578854,
    -0.040299609990174963,
    -0.029468141633474526,
    -0.013308468167841675,
    0.002200133195973488,
    0.012568743010538024,
    0.015754672994053375,
    0.012278059716607056,
    0.004581360716041745,
    -0.004067797998691490,
    -0.010731018466380082,
    -0.013649920003276582,
    -0.012579847423771943,
    -0.008588055227860981,
    -0.003470989783376950,
    0.000957265431658244,
    0.003452946429969460,
    0.003637209015719496,
    0.001953234817607744,
    -0.000638626685129280,
    -0.003078011202017972,
    -0.004573567863660808,
    -0.004809200839481303,
    -0.003949697866923710,
    -0.002483730068328492,
    -0.000990692558957855,
    0.000073046133120763,
    0.000499091989580280,
    0.000339209274693558,
    -0.000174526350996367,
    -0.000752859143356981,
    -0.001162461699168330,
    -0.001291412809445128,
    -0.001155346066789606,
    -0.000856895401357789,
    -0.000525079926366464,
    -0.000262026463852214,
    -0.000114684476610995

};

/*
 	 * Hilbert -90 Degree. "Phase-added" bandpass filter
     * Kaiser Window FIR Filter. Beta = 3.60. Raised Cosine = 0.900
     * Fc = 2.26 kHz (0.094)
     * BW = 4.22 kHz (0.176)
     * 89 Taps
     * -6dB @ 4.5kHz
     * -20dB @ 5.0kHz
     * 2015_03_25 using Iowa Hills Hilbert Filter Designer
     *
     * alternative 5k filter to prevent heterodynes from broadcast stations
*/
// -90.0 degrees
const float q_rx_4k5_coeffs[Q_NUM_TAPS] =
{

    -0.000419720771966234,
    -0.000507736016752144,
    -0.000628986065032672,
    -0.000806340154215481,
    -0.001052420191683845,
    -0.001355059091748089,
    -0.001669612675501608,
    -0.001926445969230747,
    -0.002056955255256146,
    -0.002032444228802870,
    -0.001900507875122028,
    -0.001798356589528849,
    -0.001926201642715454,
    -0.002477717988189657,
    -0.003545137297251056,
    -0.005035589477636542,
    -0.006642952616459500,
    -0.007908293224513731,
    -0.008371486246934122,
    -0.007775365758175711,
    -0.006247796195788404,
    -0.004374325227038194,
    -0.003096698076281785,
    -0.003429821370672838,
    -0.006065585254040566,
    -0.010998160042716644,
    -0.017331496876893077,
    -0.023395531214150060,
    -0.027203677808302417,
    -0.027156037201637225,
    -0.022774664728007547,
    -0.015197922985859799,
    -0.007194449407226034,
    -0.002587289494344928,
    -0.005172396244934549,
    -0.017410999849618827,
    -0.039300991517181465,
    -0.067833551537801171,
    -0.097301733336284196,
    -0.120480457933574786,
    -0.130416909319684693,
    -0.122349549616864547,
    -0.095192329425517419,
    -0.052115037194887040,
    34.05164165195360E-15,
    0.052115037194949337,
    0.095192329425563646,
    0.122349549616888209,
    0.130416909319684471,
    0.120480457933554330,
    0.097301733336251056,
    0.067833551537764436,
    0.039300991517149483,
    0.017410999849597254,
    0.005172396244925385,
    0.002587289494346653,
    0.007194449407234675,
    0.015197922985870478,
    0.022774664728016009,
    0.027156037201640927,
    0.027203677808300887,
    0.023395531214144585,
    0.017331496876885927,
    0.010998160042710155,
    0.006065585254036379,
    0.003429821370671529,
    0.003096698076282913,
    0.004374325227040662,
    0.006247796195790963,
    0.007775365758177394,
    0.008371486246934498,
    0.007908293224512924,
    0.006642952616458002,
    0.005035589477634966,
    0.003545137297249898,
    0.002477717988189151,
    0.001926201642715555,
    0.001798356589529323,
    0.001900507875122576,
    0.002032444228803252,
    0.002056955255256247,
    0.001926445969230584,
    0.001669612675501290,
    0.001355059091747750,
    0.001052420191683593,
    0.000806340154215362,
    0.000628986065032676,
    0.000507736016752222,
    0.000419720771966330



};

#if 0
// -89.5 degrees
const float q_rx_4k5_coeffs_minus[Q_NUM_TAPS] =
{
    -0.000419784959544359,
    -0.000508085077057665,
    -0.000629837142251098,
    -0.000807790972510875,
    -0.001054290516976973,
    -0.001356804583537386,
    -0.001670408590706369,
    -0.001925487061952287,
    -0.002053915313618948,
    -0.002027920650195713,
    -0.001896203184651432,
    -0.001796778081251007,
    -0.001929817210316381,
    -0.002487757486379345,
    -0.003560480869512413,
    -0.005052311251361515,
    -0.006654984454615627,
    -0.007909311931496077,
    -0.008357597053273292,
    -0.007747649898183128,
    -0.006213550866306101,
    -0.004346036540092592,
    -0.003088485538866142,
    -0.003452102862526508,
    -0.006119679955447318,
    -0.011073048742014863,
    -0.017404666458043970,
    -0.023438671899350092,
    -0.027192248756705548,
    -0.027079939511956225,
    -0.022646158983728387,
    -0.015053070288189226,
    -0.007085932090695214,
    -0.002569156023012709,
    -0.005280275798949498,
    -0.017643605217081689,
    -0.039609346858449267,
    -0.068122888090054831,
    -0.097447629160526766,
    -0.120356480459316545,
    -0.129927099543871383,
    -0.121456900223181494,
    -0.093934813300509512,
    -0.050603788501179206,
    0.001600882948112015,
    0.053622363753682838,
    0.096442681453899601,
    0.123232991083771726,
    0.130896904025820882,
    0.120595368147320886,
    0.097148514663327648,
    0.067539109888033536,
    0.038989678415480067,
    0.017177084144559811,
    0.005064127420609669,
    0.002605228248392797,
    0.007302425275401372,
    0.015341631900316774,
    0.022901456469698923,
    0.027230091150225230,
    0.027213059533408069,
    0.023350629800445544,
    0.017257022941488842,
    0.010922443630903687,
    0.006011034061656158,
    0.003407281753273395,
    0.003104677558740120,
    0.004402284705855875,
    0.006281571321253669,
    0.007802496450517440,
    0.008384745409403512,
    0.007906679345865895,
    0.006630420835134002,
    0.005018488729574202,
    0.003529526920861944,
    0.002467492018974975,
    0.001922441110758153,
    0.001799799754964581,
    0.001904669534928577,
    0.002036814847323998,
    0.002059840392127275,
    0.001927259893764744,
    0.001668691106615358,
    0.001353211619322117,
    0.001050470662109638,
    0.000804828651421019,
    0.000628087650838655,
    0.000507348744650336,
    0.000419624996547005



};
// -90.5 degrees
const float q_rx_4k5_coeffs_plus[Q_NUM_TAPS] =
{
    -0.000419624996546979,
    -0.000507348744650320,
    -0.000628087650838679,
    -0.000804828651421107,
    -0.001050470662109791,
    -0.001353211619322298,
    -0.001668691106615494,
    -0.001927259893764746,
    -0.002059840392127081,
    -0.002036814847323626,
    -0.001904669534928149,
    -0.001799799754964314,
    -0.001922441110758297,
    -0.002467492018975700,
    -0.003529526920863238,
    -0.005018488729575793,
    -0.006630420835135394,
    -0.007906679345866502,
    -0.008384745409402891,
    -0.007802496450515542,
    -0.006281571321250987,
    -0.004402284705853413,
    -0.003104677558739140,
    -0.003407281753274969,
    -0.006011034061660676,
    -0.010922443630910507,
    -0.017257022941496246,
    -0.023350629800451134,
    -0.027213059533409540,
    -0.027230091150221278,
    -0.022901456469690024,
    -0.015341631900305547,
    -0.007302425275392158,
    -0.002605228248390573,
    -0.005064127420618521,
    -0.017177084144581339,
    -0.038989678415512298,
    -0.067539109888070811,
    -0.097148514663361565,
    -0.120595368147342175,
    -0.130896904025821853,
    -0.123232991083748647,
    -0.096442681453853638,
    -0.053622363753620506,
    -0.001600882948043591,
    0.050603788501241996,
    0.093934813300556266,
    0.121456900223205613,
    0.129927099543871383,
    0.120356480459296089,
    0.097447629160493404,
    0.068122888090017764,
    0.039609346858416952,
    0.017643605217059905,
    0.005280275798940312,
    0.002569156023014644,
    0.007085932090704262,
    0.015053070288200420,
    0.022646158983737369,
    0.027079939511960340,
    0.027192248756704229,
    0.023438671899344621,
    0.017404666458036608,
    0.011073048742008027,
    0.006119679955442734,
    0.003452102862524854,
    0.003088485538867054,
    0.004346036540095017,
    0.006213550866308783,
    0.007747649898185049,
    0.008357597053273951,
    0.007909311931495504,
    0.006654984454614260,
    0.005052311251359929,
    0.003560480869511112,
    0.002487757486378604,
    0.001929817210316224,
    0.001796778081251264,
    0.001896203184651856,
    0.002027920650196086,
    0.002053915313619146,
    0.001925487061952291,
    0.001670408590706237,
    0.001356804583537206,
    0.001054290516976820,
    0.000807790972510786,
    0.000629837142251073,
    0.000508085077057680,
    0.000419784959544385

};
#endif
