/*
 ***** BEGIN LICENSE BLOCK *****
 * Version: EPL 1.0/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Eclipse Public
 * License Version 1.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.eclipse.org/legal/epl-v10.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * Copyright (C) 2013-2017 The JRuby Team (jruby@jruby.org)
 * 
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the EPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the EPL, the GPL or the LGPL.
 ***** END LICENSE BLOCK *****/
package org.jruby.ext.ripper;

public class YyTables {
   private static short[] combine(short[] t1, short[] t2, 
                                  short[] t3, short[] t4) {
      short[] t = new short[t1.length + t2.length + t3.length + t4.length];
      int index = 0;
      System.arraycopy(t1, 0, t, index, t1.length);
      index += t1.length;
      System.arraycopy(t2, 0, t, index, t2.length);
      index += t2.length;
      System.arraycopy(t3, 0, t, index, t3.length);
      index += t3.length;
      System.arraycopy(t4, 0, t, index, t4.length);
      return t;
   }

   public static final short[] yyTable() {
      return combine(yyTable1(), yyTable2(), yyTable3(), yyTable4());
   }

   public static final short[] yyCheck() {
      return combine(yyCheck1(), yyCheck2(), yyCheck3(), yyCheck4());
   }
   private static final short[] yyTable1() {
      return new short[] {

           88,   88,  134,  134,  381,  217,  468,  253,  253,  253, 
          579,  231,  279,  253,  253,  310,  421,  253,  423,  643, 
          308,  490,  311,  679,  717,  218,  218,  717,  355,  357, 
          233,  231,  775,  718,  327,  430,  291,  291,  699,  443, 
          291,  263,  107,   88,  295,  295,  218,  353,  295,  253, 
          233,  363,  529,  630,  643,  650,  531,    8,  644,  705, 
          633,  643,  641,  880,  570,  646,  637,    8,  643,  643, 
          305,  218,  718,  631,   83,  813,  334,  338,  433,  570, 
           75,  643,  379,  294,  294,   83,   83,  294,  579,  678, 
          292,  298,  833,  677,  299,  564,  878,  353,  133,  133, 
          390,   74,  275,  633,  663,  641,  842,   81,  133,  694, 
          643,  873,  438,  727,  517,  333,    8,  257,  260,  678, 
          277,  259,  313,  708,   73,   83,  253,  784,   88,   86, 
          643,   75,  434,  317,  263,   86,  764,  854,  602, 1037, 
          412,  307,  951,  133,  300,  564,   72,  383,  379,  570, 
          259,  948,   72,  678,  376,  436,  643,  526,   81,  106, 
          106,  786,  745,  503,  380,  867,  106,  106,  106,  379, 
          258,  415,  106,  106,  561,   71,  106,  412,  678,  562, 
          381,  464,  739,  570,  276,  643,  303,  259,  526,  894, 
          549,  525,  384,  133,  412,  643,  346,  906,  570,  258, 
          379,  579,  106,  913,  564,  382,  765,  478,  106,  303, 
          412,  638,  567,  568,  377,  380,  577,  439,  597,  378, 
          777,  657,  528,  554,  490,  452,  643, 1037,  555,  638, 
          380,  504,  505,  453,  469,   88,  258, 1019,  307,  549, 
          602,  779,  592,  512,  643,  346,  812,  593,  387,  388, 
          577,  380,  597,  564,  880,  579,  569,  818,  313,  717, 
          717,  578,  253,  253,   79,  577,  718,  597,  567,  568, 
          579,  589,  251,  251,  251,  780,  578,  389,  643,  643, 
          396,  537,  878,  318,  643,  106,  589,  106,  533,  602, 
          263,   92,   92,  135,  135,  951,  969,  519,  253,  878, 
          253,  253,  478,  280,  253,  873,  253,  478, 1051,  404, 
          327,   88,  564,  406,  407,   79,  368,   88,  579,   88, 
          307,  291,  826,  291,  291,  825,  370,  470,  253,  295, 
          965,  295,  836,  752,   92,  850,  374,  973,  354,  376, 
         1080,  921,  977,   83,   76,  828,  825,   84,  441,   75, 
          353,  520,  442,  263,  539,  540,  676,   53,  480,  821, 
          415,  542,  587,  480,   72,  425,  547,  426,  294,  432, 
          294,  473,  474,   77,  427,  491,   81,  494,  564,  570, 
          253,  253,  253,  253,   88,  253,  253,  878,  354,  643, 
          644,  440,  702,  644,  106,   76,  587,  431,   84,  575, 
          390,  643,  515,  647,  643,  651,   83,  459,  659,  661, 
          665,  587,   75,  643,  643,  304,  630,  327,  253,   92, 
            8,  106,  106,  253,   77,  253,   88,  353,  943,  253, 
          253,  650,   88,   74,  275,  455,  631,  275,  602,   81, 
          642,  291,  846,  642,  570,  253,  133,   88,  253,  839, 
           95,   95,  277,  852,  313,  277,   73,  106,   88,  106, 
          106,  253,  281,  106,  322,  106,   88,  642,  291,  600, 
          106, 1086,  306,  667,  533,  253,  106,  564,  106,  383, 
         1064,  570,  717,  642,  291,  549,  376,  106,  718,  596, 
          597,  598,  599,   95,  725,  656,  990,  642,  291,  656, 
          435,  539,  540,  704,  704,  253,  304,   88,  542, 1013, 
          231,  577,  381,  597,  570,  716,  276,   83,   88,  276, 
          752,  864,  549,  133,  384,  218,   92,  251,  251,  233, 
          435,  642,  379,   79,  253,  602,  353,  382,  700,  106, 
          106,  106,  106,  106,  106,  106,  377,  380,  577,  322, 
          597,  378,  102,  102,  735,  549,  642,  291,  564,  539, 
          540,  306,  643,  259,  579, 1042,  542,  597,   91,  500, 
          579,  502,  602,  846, 1011,   82,  578,  106,   95,   80, 
          396,  577,  106,  597,  106,  106,  589,  420,  106,  106, 
          756,  106,   83,  523,  533,  102,   79,  838,  643,  643, 
          387,  388,   92,  458,  106,  602,  106,  106,   92,  643, 
           92,  643,  258,   76,  501,  513,   84,  106,  444,  465, 
          106,  466,  785,   78,  742,  106,   82,  470,  564,  467, 
           80,  792,  133,  752,  106,  752,  521,  522,  768,  770, 
          472,  354,   77,  475,  479,  251,  251,  251,  251,  643, 
          601,  602,  447,  485,  486,  417,  353,  587,  643,  489, 
          509,  126,  418,  422,  106,  389,  106,  513,  514,  253, 
           88,  792,  853,  820,   78,   92,   76,  106, 1008,   84, 
          102,   88,  790,  819, 1010,   95,  288,  678,  792,  231, 
          796, 1073,  643,  106,  587,  799,  518,  532,  643,  643, 
          810,  447,  792,  218,  218,   77,  524,  816,  233,  253, 
          126,  587,  817,  680,  539,  540,  544,   92,  354,  752, 
         1021,  542,  530,   92,  538,  447,  549,  587,  553,   88, 
          914,  588,  510,  792,  353,  591,  660,  668,   92,  712, 
          322,  643,  316,  533,  806,  507,  643,  686,  643,   92, 
          847,  689,  133,  691,  656,  701,  720,   92,  721,  722, 
          728,   95,   88,   88,  731,  902,  904,   95,  736,   95, 
          726,  909,  911,  382,  383,  384,  385,  386,  811,  463, 
           88,  651,   88,  747,   88,  253,  253,  102,  752,  748, 
          752,  253,  253,  477,  757,  643,  758,  643,   92,  719, 
          116,  253,  759,  110,  614,  353,  761,  723,  724,   92, 
          767,   96,  769,  771,   83,  643,  773,  774,  843,  643, 
          459,  778,  752,   88,  417,  732,  253,  354,  106,  106, 
          133,  418,  419,  787,   95,  788,  793,   88,   88,   88, 
          106,  923,  643,  794,   82,  803,  643,  322,   80,  116, 
          804,  807,  513,  814,  825,  831,  332,  336,  643,  513, 
          513,  832,  837,  102,  834,  614,  643,  835,  106,  102, 
          849,  102,  643,  704,  865,  655,   95,  900,  907,  690, 
          908,  519,   95,  924,  926,  986,  614,  698,  106,  932, 
          928,  643,   78,  919,  936,  981,  937,   95,  944,   17, 
          938,  133,  643,  643,  884,  253,  643,   82,   95,  447, 
           16,   80,  945,  896,  949,  952,   95,  953,  126,   88, 
           88,  106,  106,  955,  956,  957, 1005,  958,  115,  954, 
           88,  643,  960, 1046,  251,  935,  102,  959,  961,  106, 
          963,  106,  964,  106,  106,  106,  643,  354,   17,  962, 
          106,  106,  966,  643,  967,   78,  970,   95,  643,   16, 
          106,   92,  417,  972, 1027,  805,  974,  976,   95,  418, 
          446,  982,   92,  863,  251,  983,  985,  115,  102,  316, 
         1014,  447,  106, 1015,  102,  106,  316,  316,  815,   88, 
         1018,  133,  618, 1038, 1030,   97,  106,  106,  106,  102, 
          643, 1040, 1041,  643, 1043,  643,   88,  643,   88,  518, 
          102, 1052, 1054,  876,   88,  879,  417, 1058,  102, 1060, 
           92, 1062,  133,  418,  462,  354,  886,  789,  117,   97, 
          417, 1065, 1087,  860,  848,  795, 1070,  418,  476, 1078, 
          795,  110,  851,  253, 1090,  630,   97,  643,   88,  643, 
          643,  643,  643,   92,   92,  632,  643,  116,  643,  102, 
          133,  632,  631,  866,  106,  642,  291,  792,  632,  789, 
          102,   92,  795,   92,  636,   92,  519,  117,  106,  106, 
          463,  539,  540,  541, 1053, 1055, 1056, 1057,  542,  106, 
          110,  251,  643,   91,  103,  636,  354,  638,  536,  632, 
          896,  643,  643,  896,  378, 1034,  483,  896,  366,  520, 
          590,  137,  496,  733,   92, 1077,  220,  800,  519,  991, 
           95,  889,  513, 1033,  925,  519,  519,   91,   92,   92, 
           92,   95,  539,  540,  544,  877, 1032,  293,  882,  542, 
          915,  437, 1088,  282,   91, 1076,  862,  293,  106,    0, 
          447,   17,   17,   17,  539,  540,  546,   17,   17,    0, 
           17,  542,   16,   16,   16,  106,  118,  106,   16,   16, 
          947,   16, 1045,  106,  513,  539,  540,  550, 1022,   95, 
            0,  288,  542,  874,  875,  115,  135,  113,    0,    0, 
           94,  896,    0,  896,    0,  896,  293,    0,  896,    0, 
            0,  898,  106,  899,    0,  901, 1024,  106,    0,    0, 
           92,   92,   95,   95,    0,  118, 1031, 1006,    0,   97, 
         1035,   92,  102,  896,   94,   61,   62,   63,   64,  496, 
           95,   17,   95,  102,   95,  749,  113,  557,  558,  559, 
          560,   94,   16,    0,  931,    0,  518,  521,    0,    0, 
            0,  655,   17,  518,  518,  135,  496,  643,  940,  941, 
          942,  643,  643,   16,   97,  687,  519,    0,  516,    0, 
            0,  516,  496,   95,  290,  290,    0,  124,  290,  123, 
           92,  102,    0,    0,   17,  117,  496,   95,   95,   95, 
            0,    0,    0,    0,   96,   16,    0,   92,  110,   92, 
          314,  316,    0,    0,    0,   92,  290,  290, 1083,  356, 
          358,  614,    0,  519,  102,  102,  120,  417,   96,    0, 
          519,  519,    0,    0,  418,  511,  124,   97,  123,  122, 
          437,    0,  102,    0,  102,  417,  102,    0,    0,   92, 
          989,  518,  418,  535,    0,  496,  520, 1020,    0,    0, 
            0, 1009,    0,  520,  520,  335,    0,    0,  621,  513, 
          617,    0,   91,  614,    0,  120,  513,  513,    0,   95, 
           95,    0,  614,    0,    0,  102, 1007,    0,  437,    0, 
           95,  539,  540,  589,  762,  437,  437,  417,  542,  102, 
          102,  102,    0,  614,  418, 1039,    0,  523,    0,  293, 
          293,  293,    0,  783,  783,  293,  293,    0,  293,  417, 
          389,  513,  437,  484,  484,  484,  418, 1044,  513,  513, 
          484,    0,    0,  118,  614,   91,  316, 1047,    0, 1048, 
          293,  293,  293,  293,  293, 1049,    0,    0,  783,   95, 
          643,  316,  404,   96,  113,  614,  406,  407,  408,  409, 
          798,    0,    0,    0,  116,  798,   95,  615,   95,   94, 
          615,    0,  856,  857,   95,  858,    0,    0,    0, 1079, 
            0,  102,  102,  316,    0,    0,  125,   96,    0,  293, 
            0,    0,  102,    0,  521,    0,    0,  798,    0,    0, 
            0,  521,  521,    0,   96,  824,    0,  827,   95,  827, 
          293,  122,    0,  519,    0,  516,    0,  827,  516,    0, 
          519,  519,  516,  516,    0,  516,  516,   43,  615,    0, 
            0,  615,   94,    0,  518,  125,    0,   43,    0,  115, 
           59,   60,  293,    0,  124,    0,  123,    0,    0,  615, 
           96,  102,  615,  290,  290,  290,  358,  621,  290,  617, 
          122,  870,    0,  557,  558,  559,  560,  618,  102,  290, 
          102,  290,  290,    0,  105,  762,  102,  466,  466,  466, 
          508,    0,    0,  120,  466,    0,   43,    0,  518,    0, 
          242,    0,  437,    0,    0,  518,  518,    0,    0,  762, 
          242,  480,  481,  482,    0,  621,  484,  617,  105,    0, 
          102,    0,  621,  621,  617,  617,    0,    0,  617,  749, 
          617,  557,  558,  559,  560,  105,    0,    0,  783,    0, 
          472,  472,  472,    0,  242,    0,  119,  472,    0,  621, 
            0,  617,  930,    0,  523,  934,    0,    0,  242,  242, 
            0,  523,  523,  242,    0,  621,    0,    0,  603,  604, 
          605,  606,  607,  608,  609,  610,  611,  612,  613,  614, 
          615,  616,  617,  618,  619,  620,  621,  622,  623,  624, 
          625,  626,  627,  628,    0,  119,    0,  389,    0,  290, 
            0,    0,    0,  121,  648,    0,  652,    0,    0,    0, 
          290,  666,    0,  402,  403,    0,  762,    0,    0,    0, 
            0,   51,    0,    0,    0,    0,  290,  522,  104,  404, 
          316,   51,   96,  406,  407,  408,  409,  316,  316,  106, 
            0,    0,  290,  618,  648,  697,  666,    0,    0,  290, 
            0,   98,  121,  125,  654,    0,  290,    0,  664,    0, 
            0,  316,  104,    0,  290,  290,  618,    0,  290,  827, 
            0,    0,    0,  106,    0,    0,    0,    0,  122,  104, 
           51,  518,    0,    0,  524,    0,    0,    0,  518,  518, 
          106,  437,  729,  730,  205,   96,    0,  654,  520,   43, 
           43,   43,    0,    0,  290,   43,   43,  290,   43,  617, 
            0,    0,  713,  715,  618,  290,  335,    0,    0,    0, 
          618,  618,  618,    0,    0,    0,    0,  618,    0,    0, 
           43,   43,   43,   43,   43,    0,    0,    0,    0,  437, 
            0,    0,    0,  205,    0,    0,  437,  437,  618,    0, 
            0,    0,  715,  105,  621,  335,    0,    0,    0,    0, 
            0,    0,  242,  242,  242,    0,  290,  242,  242,  242, 
          107,  242,    0,  437,  496,    0,  687,  827,  426,   43, 
            0,  242,  242,    0,    0,    0,    0,    0,  426,    0, 
          242,  242,    0,  242,  242,  242,  242,  242,    0,  112, 
           43,  107,  621,  119,    0,  242,    0,    0,    0,  621, 
          621,    0,    0,    0,  776,  617,  105,  316,  242,  242, 
          242,  242,  242,  242,  242,  242,  242,  242,  290,  242, 
          242,    0,   43,  242,  242,  107,  621,  426,    0,  242, 
            0,  307,  242,    0,    0,  242,    0,  242,  112,  242, 
            0,  242,  107,  242,  242,  242,  242,  242,  242,  242, 
          121,  242,    0,  242,  522,  290,    0,    0,    0,    0, 
            0,  522,  522,    0,    0,  242,  801,    0,    0,    0, 
          515,    0,  316,   51,   51,   51,  117,    0,   51,   51, 
           51,  290,   51,  290,  414,  242,    0,  104,  617,    0, 
          290,  290,   51,    0,    0,    0,    0,    0,  106,  618, 
            0,   51,   51,  822,   51,   51,   51,   51,   51,    0, 
            0,  524,    0,    0,    0,    0,    0,  290,  524,  524, 
            0,    0,    0,    0,  545,  520,  548,    0,  551,  844, 
            0,  845,  520,  520,  551,  513,  617,    0,  715,  335, 
            0,    0,    0,  617,  617,  513,    0,  618,    0,  617, 
          104,    0,    0,   51,  618,  618,  903,  905,    0,    0, 
          618,  106,  910,  912,    0,  861,    0,    0,    0,    0, 
          617,  916,  697,  290,   51,    0,    0,  920,    0,  513, 
          205,  618,  205,  205,  205,  205,  205,    0,    0,    0, 
            0,  205,    0,  513,  513,  126,  110,    0,  513,    0, 
          903,  905,  519,  910,  912,    0,   51,  290,    0,    0, 
          519,    0,    0,    0,  205,  205,    0,    0,    0,    0, 
            0,  918,  205,  205,  205,  205,  513,    0,    0,    0, 
          426,  426,  426,    0,    0,  426,  426,  426,    0,  426, 
            0,    0,  545,    0,  316,    0,  112,    0,    0,  426, 
            0,  316,  316,    0,    0,  939,  389,  618,  426,  426, 
          107,  426,  426,  426,  426,  426,    0,    0,  205,  984, 
            0,    0,  402,  403,  516,    0,  987,    0,  749,    0, 
          557,  558,  559,  560,  516,    0,  290,    0,  404,    0, 
          405,    0,  406,  407,  408,  409,  426,    0,  412,    0, 
          413,    0,    0,  426,  426,    0,  987,  515,    0,  316, 
          426,  746,  750,  290,  515,  515,  316,  316,  516,    0, 
          751,    0,  618,  107,  749,    0,  557,  558,  559,  560, 
            0,  426,  516,  516,  988,  113,    0,  516,  389,  390, 
          391,  392,  393,  394,  395,  396,  397,  398,  399,  746, 
          400,  401,    0,    0,  402,  403,    0,    0,  750,    0, 
            0,  335,    0,  426,    0,  516,  950,    0,    0,    0, 
          404,    0,  405,    0,  406,  407,  408,  409,  410,  411, 
          412,    0,  413,    0,    0,    0,  198,    0,    0,    0, 
            0,    0,  614,  614,  614,    0,  614,  513,  513,  513, 
          614,  614,  513,  513,  513,  614,  513,  614,  614,  614, 
          614,  614,  614,  614,  290,  614,  513,  513,  614,  614, 
          614,  614,  614,  614,  614,  513,  513,  614,  513,  513, 
          513,  513,  513,    0,  614,  198,    0,  614,  614,  614, 
          513,  614,  614,  614,  614,  614,  614,  614,  614,  614, 
          614,  614,  513,  513,  513,  513,  513,  513,  513,  513, 
          513,  513,  513,  513,  513,  513,    0,    0,  513,  513, 
          513,  513,  614,  525,  513,  614,  614,  513,  614,  614, 
          513,  614,  513,  614,  513,  614,  513,  614,  513,  513, 
          513,  513,  513,  513,  513,  614,  513,  614,  513,  761, 
          614,  614,  614,  614,  614,  614,    0,    0,    0,  614, 
          513,  614,  614,    0,  614,  614,  614,  614,    0,    0, 
            0,    0,    0,    0,    0,  111,    0,  614,  614,  614, 
          513,  615,  615,  615,    0,  615,  516,  516,  516,  615, 
          615,  516,  516,  516,  615,  516,  615,  615,  615,  615, 
          615,  615,  615,  897,  615,  516,  516,  615,  615,  615, 
          615,  615,  615,  615,  516,  516,  615,  516,  516,  516, 
          516,  516,    0,  615,  111,    0,  615,  615,  615,  516, 
          615,  615,  615,  615,  615,  615,  615,  615,  615,  615, 
          615,  516,  516,  516,  516,  516,  516,  516,  516,  516, 
          516,  516,  516,  516,  516,   99,  514,  516,  516,  516, 
          516,  615,  528,  516,  615,  615,  516,  615,  615,  516, 
          615,  516,  615,  516,  615,  516,  615,  516,  516,  516, 
          516,  516,  516,  516,  615,  516,  615,  516,    0,  615, 
          615,  615,  615,  615,  615,    0,    0,  621,  615,  516, 
          615,  615,  521,  615,  615,  615,  615,  621,  971,    0, 
            0,    0,  975,    0,    0,    0,  615,  615,  615,  516, 
            0,    0,    0,    0,  630,  630,  630,    0,    0,    0, 
          630,  630,  198,  630,  198,  198,  198,  198,  198,    0, 
            0,  621,    0,  198,  631,  631,  631,  389,    0,    0, 
          631,  631,    0,  631,  518,  621,  621,    0,  124,    0, 
          621,    0,  518,  402,  403,    0,  198,  198,    0,    0, 
            0,    0,    0,    0,  198,  198,  198,  198,    0,  404, 
            0,  405,    0,  406,  407,  408,  409,    0,  621,    0, 
          897,    0,    0,  897,    0,  897,  885,  897,  557,  558, 
          559,  560,  561,    0,  630,    0,    0,  562,  749,    0, 
          557,  558,  559,  560,    0,    0,    0,    0,    0,    0, 
          198,    0,    0,    0,  631,  630,    0,    0,    0,    0, 
          563,    0,  111,    0,    0,    0,  617,    0,  565,  566, 
          567,  568,  750,    0,    0,  631,  617,    0, 1059,    0, 
            0, 1061, 1063,    0,    0, 1066, 1067,  630,    0,    0, 
            0,    0,    0,    0,  556,    0,  557,  558,  559,  560, 
          561,    0,    0,    0,    0,  562,    0,  631,    0,    0, 
          617,  897,    0,  897,  569,  897,    0,    0,  897,    0, 
          118,    0,    0,  514,  617,  617,    0,  123,  563,  617, 
          514,  514, 1089, 1091, 1092, 1093,  565,  566,  567,  568, 
            0,    0,    0,  897, 1095,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  617,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  521, 
            0,    0,    0,    0,    0,    0,  521,  521,  208,    0, 
            0,    0,  569,    0,  617,  617,  617,    0,  617,  621, 
          621,  621,  617,  617,  621,  621,  621,  617,  621,  617, 
          617,  617,  617,  617,  617,  617,    0,  621,  621,  621, 
          617,  617,  617,  617,  617,  617,  617,  621,  621,  617, 
          621,  621,  621,  621,  621,    0,  617,  208,    0,  617, 
          617,  617,  621,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  621,  621,  621,  621,  621,  621, 
          621,  621,  621,  621,  621,  621,  621,  621,   94,    0, 
          621,  621,  621,  621,  617,  193,  621,  617,  617,  621, 
          617,  617,  621,  617,  621,  617,  621,  617,  621,  617, 
          621,  621,  621,  621,  621,  621,  621,  617,  621,  621, 
          621,    0,  617,  617,  617,  617,  617,  617,  101,    0, 
            0,  617,  621,  617,  617,  516,  617,  617,  617,  617, 
            0,    0,    0,    0,  193,    0,    0,  114,    0,  617, 
          617,  617,  621,  617,  617,  617,    0,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  523,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,    0,  617,  114,    0,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  100,  517,  617, 
          617,  617,  617,  617,    0,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
            0,  617,  617,  617,  617,  617,  617,    0,    0,  618, 
          617,  617,  617,  617,  522,  617,  617,  617,  617,  618, 
            0,    0,    0,    0,    0,    0,    0,    0,  617,  617, 
          617,  617,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  208,    0,  208,  208,  208,  208, 
          208,    0,    0,  618,    0,  208,    0,    0,    0,    0, 
            0,    0,    0,  113,  615,    0,  520,  618,  618,    0, 
          125,    0,  618,    0,  520,    0,    0,    0,  208,  208, 
            0,    0,    0,    0,    0,    0,  208,  208,  208,  208, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          618,    0,    0,  120,    0,  749,    0,  557,  558,  559, 
          560,  561,  516,    0,    0,    0,  562,    0,    0,  516, 
          516,    0,    0,    0,    0,  615,    0,    0,    0,    0, 
            0,  193,  208,  193,  193,  193,  193,  193,    0,  563, 
            0,    0,  193,    0,  114,    0,  615,    0,  307,  567, 
          568,    0,  523,  521,    0,    0,    0,    0,  307,  523, 
          523,  521,    0,    0,    0,  193,  193,    0,    0,    0, 
            0,    0,    0,  193,  193,  193,  193,    0,    0,    0, 
            0,    0,    0,    0,  389,    0,    0,    0,    0,  394, 
          395,    0,  307,  569,    0,    0,    0,    0,    0,    0, 
          402,  403,  119,    0,    0,  517,  307,  307,    0,    0, 
            0,  307,  517,  517,    0,    0,  404,    0,  405,  193, 
          406,  407,  408,  409,  410,  411,  412,    0,  413,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  307, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  522,    0,    0,    0,    0,    0,    0,  522,  522, 
          175,    0,    0,    0,    0,    0,  618,  618,  618,    0, 
          618,  618,  618,  618,  618,  618,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,  618,    0,  618, 
          618,  618,  618,  618,  618,  618,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,    0,  618,  175, 
            0,  618,  618,  618,  618,  618,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,  618,  618,  618, 
          105,    0,  618,  618,  618,  618,  618,  176,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,  618,  618,  618, 
          618,  618,  618,    0,  618,  618,  618,  618,  618,  618, 
          102,    0,    0,  618,  618,  618,  618,  621,  618,  618, 
          618,  618,    0,    0,    0,    0,  176,    0,    0,  128, 
            0,  618,  618,  618,  618,  616,  616,  616,    0,  616, 
          307,  307,  307,  616,  616,  307,  307,  307,  616,  307, 
          616,  616,  616,  616,  616,  616,  616,  524,  616,  307, 
          307,  616,  616,  616,  616,  616,  616,  616,  307,  307, 
          616,  307,  307,  307,  307,  307,    0,  616,  128,    0, 
          616,  616,  616,  307,  616,  616,  616,  616,  616,  616, 
          616,  616,  616,  616,  616,  307,  307,  307,  307,  307, 
          307,  307,  307,  307,  307,  307,  307,  307,  307,   93, 
          306,  307,  307,  307,  307,  616,    0,  307,  616,  616, 
          307,  616,  616,  307,  616,  307,  616,  307,  616,  307, 
          616,  307,  307,  307,  307,  307,  307,  307,  616,  307, 
          616,  307,    0,  616,  616,  616,  616,  616,  616,    0, 
            0,  622,  616,  307,  616,  616,  515,  616,  616,  616, 
          616,  622,    0,    0,    0,    0,    0,    0,    0,    0, 
          616,  616,  616,  307,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  175,    0,  175,  175, 
          175,  175,  175,    0,    0,  622,    0,  175,    0,    0, 
            0,    0,    0,    0,    0,  124,  621,    0,  523,  622, 
          622,    0,    0,    0,  622,    0,  523,    0,    0,    0, 
          175,  175,    0,    0,    0,    0,    0,    0,  175,  175, 
          175,  175,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  622,    0,    0,  121,    0,    0,    0,    0, 
            0,    0,    0,    0,  621,    0,    0,    0,    0,    0, 
            0,  621,  621,    0,    0,    0,    0,  617,    0,    0, 
            0,    0,    0,  176,  175,  176,  176,  176,  176,  176, 
            0,    0,    0,    0,  176,    0,  128,    0,  621,    0, 
          623,    0,    0,    0,  524,  522,    0,    0,    0,    0, 
          623,  524,  524,  522,    0,    0,    0,  176,  176,    0, 
            0,    0,    0,    0,    0,  176,  176,  176,  176,    0, 
            0,    0,    0,    0,    0,    0,  389,  390,  391,  392, 
          393,  394,  395,  396,  623,  398,  399,    0,    0,    0, 
            0,    0,  402,  403,  112,    0,    0,  306,  623,  623, 
            0,    0,    0,  623,  306,  306,    0,    0,  404,    0, 
          405,  176,  406,  407,  408,  409,  410,  411,  412,    0, 
          413,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  623,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  515,    0,    0,    0,    0,    0,    0, 
          515,  515,  177,    0,    0,    0,    0,    0,  619,  619, 
          619,    0,  619,  622,  622,  622,  619,  619,  622,  622, 
          622,  619,  622,  619,  619,  619,  619,  619,  619,  619, 
            0,  622,  622,  622,  619,  619,  619,  619,  619,  619, 
          619,  622,  622,  619,  622,  622,  622,  622,  622,    0, 
          619,  177,    0,  619,  619,  619,  622,  619,  619,  619, 
          619,  619,  619,  619,  619,  619,  619,  619,  622,  622, 
          622,  622,  622,  622,  622,  622,  622,  622,  622,  622, 
          622,  622,  104,    0,  622,  622,  622,  622,  619,  134, 
          622,  619,  619,  622,  619,  619,  622,  619,  622,  619, 
          622,  619,  622,  619,  622,  622,  622,  622,  622,  622, 
          622,  619,  622,  622,  622,    0,  619,  619,  619,  619, 
          619,  619,   92,    0,    0,  619,  622,  619,  619,  617, 
          619,  619,  619,  619,    0,    0,    0,    0,  134,    0, 
            0,  127,    0,  619,  619,  619,  622,  620,  620,  620, 
            0,  620,  623,  623,  623,  620,  620,  623,  623,  623, 
          620,  623,  620,  620,  620,  620,  620,  620,  620,  514, 
          623,  623,  623,  620,  620,  620,  620,  620,  620,  620, 
          623,  623,  620,  623,  623,  623,  623,  623,    0,  620, 
          127,    0,  620,  620,  620,  623,  620,  620,  620,  620, 
          620,  620,  620,  620,  620,  620,  620,  623,  623,  623, 
          623,  623,  623,  623,  623,  623,  623,  623,  623,  623, 
          623,   95,  317,  623,  623,  623,  623,  620,    0,  623, 
          620,  620,  623,  620,  620,  623,  620,  623,  620,  623, 
          620,  623,  620,  623,  623,  623,  623,  623,  623,  623, 
          620,  623,  623,  623,    0,  620,  620,  620,  620,  620, 
          620,    0,    0,  316,  620,  623,  620,  620,  517,  620, 
          620,  620,  620,  316,    0,    0,    0,    0,    0,    0, 
            0,    0,  620,  620,  620,  623,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  177,    0, 
          177,  177,  177,  177,  177,    0,    0,  316,    0,  177, 
            0,    0,    0,    0,    0,    0,    0,  123,  617,    0, 
          524,  316,  316,    0,  126,    0,  316,    0,  524,    0, 
            0,    0,  177,  177,    0,    0,    0,    0,    0,    0, 
          177,  177,  177,  177,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  316,    0,    0,  111,    0,    0, 
            0,    0,    0,    0,    0,    0,  617,    0,    0,    0, 
            0,    0,    0,  617,  617,    0,    0,    0,    0,  617, 
            0,    0,    0,    0,    0,  134,  177,  134,  134,  134, 
          134,  134,    0,    0,    0,    0,  134,    0,  127,    0, 
          617,    0,  436,    0,    0,    0,  514,  513,    0,    0, 
            0,    0,  436,  514,  514,  513,    0,    0,    0,  134, 
          134,    0,    0,    0,    0,    0,    0,  134,  134,  134, 
          134,    0,    0,    0,    0,    0,    0,    0,  389,  390, 
          391,  392,  393,  394,  395,    0,  436,  398,  399,    0, 
            0,    0,    0,    0,  402,  403,  114,    0,    0,  317, 
            0,  436,    0,    0,    0,  436,  317,  317,    0,    0, 
          404,    0,  405,  134,  406,  407,  408,  409,  410,  411, 
          412,    0,  413,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  436,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  517,    0,    0,    0,    0, 
            0,    0,  517,  517,  135,    0,    0,    0,    0,    0, 
          618,  618,  618,    0,  618,  316,  316,  316,  618,  618, 
          316,  316,  316,  618,  316,  618,  618,  618,  618,  618, 
          618,  618,    0,    0,  316,  316,  618,  618,  618,  618, 
          618,  618,  618,  316,  316,  618,  316,  316,  316,  316, 
          316,    0,  618,  135,    0,  618,  618,  618,  316,  618, 
          618,  618,  618,  618,  618,  618,  618,  618,  618,  618, 
          316,  316,  316,  316,  316,  316,  316,  316,  316,  316, 
          316,  316,  316,  316,    0,    0,  316,  316,  316,  316, 
          618,    0,  316,  618,  618,  316,  618,  618,  316,  618, 
          316,  618,  316,  618,  316,  618,  316,  316,  316,  316, 
          316,  316,  316,  618,  316,    0,  316,    0,  618,  618, 
          618,  618,  618,  618,    0,    0,    0,  618,  316,  618, 
          618,    0,  618,  618,  618,  618,  352,    0,    0,    0, 
            0,    0,    0,    0,    0,  618,  618,  618,  316,  283, 
          283,  283,    0,  283,  436,  436,  436,  283,  283,  436, 
          436,  436,  283,  436,  283,  283,  283,  283,  283,  283, 
          283,    0,  436,  436,  436,  283,  283,  283,  283,  283, 
          283,  283,  436,  436,  283,  436,  436,  436,  436,  436, 
            0,  283,    0,    0,  283,  283,  283,    0,  283,  283, 
          283,  283,  283,  283,  283,  283,  283,  283,  283,  436, 
          436,  436,  436,  436,  436,  436,  436,  436,  436,  436, 
          436,  436,  436,    0,    0,  436,  436,  436,  436,  283, 
            0,  436,  283,    0,  436,  283,  283,  436,  283,  436, 
          283,  436,  283,  436,  283,  436,  436,  436,  436,  436, 
          436,  436,  283,  436,  436,  436,    0,  283,  283,  283, 
          283,  283,  283,    0,    0,  643,  283,    0,  283,  283, 
            0,  283,  283,  283,  283,  643,    0,    0,    0,    0, 
            0,    0,    0,    0,  283,  283,  283,  436,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          135,    0,  135,  135,  135,  135,  135,    0,    0,  643, 
            0,  135,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  516,    0,  643,    0,    0,    0,  643,    0, 
          516,    0,    0,    0,  135,  135,    0,    0,    0,    0, 
            0,    0,  135,  135,  135,  135,    0,    0,    0,    4, 
            5,    6,    0,    8,    0,    0,  643,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,  108,  109,   17, 
           18,    0,    0,    0,    0,  110,  111,  112,  339,  340, 
          341,  342,    0,    0,  117,    0,    0,    0,  135,    0, 
            0,  118,    0,    0,  343,  344,  345,    0,  346,   35, 
          347,  348,  349,  350,  323,   40,    0,    0,  127,    0, 
            0,    0,    0,    0,  323,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  351, 
            0,    0,  130,    0,    0,   46,   47,    0,   48,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  323,    0, 
            0,    0,    0,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,  323,    0,    0,   58,  323,   59,   60, 
            0,   61,   62,   63,   64,  556,    0,  557,  558,  559, 
          560,  561,    0,    0,   65,   66,  562,    0,    0,    0, 
            0,    0,    0,    0,    0,  323,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  563, 
          564,    0,    0,    0,    0,    0,    0,  565,  566,  567, 
          568,    0,  283,  283,  283,    0,  283,  643,  643,  643, 
          283,  283,  643,  643,  643,  283,  643,  283,  283,  283, 
          283,  283,  283,  283,    0,  643,  643,  643,  283,  283, 
          283,  283,  283,  283,  283,  643,  643,  283,  643,  643, 
          643,  643,  643,  569,  283,    0,    0,  283,  283,  283, 
            0,  283,  283,  283,  283,  283,  283,  283,  283,  283, 
          283,  283,  643,  643,  643,  643,  643,  643,  643,  643, 
          643,  643,  643,  643,  643,  643,  262,    0,  643,  643, 
          643,  643,  283,    0,  643,  283,  262,  643,  283,  283, 
          643,  283,  643,  283,  643,  283,  643,  283,  643,  643, 
          643,  643,  643,  643,  643,  283,  643,  643,  643,    0, 
          283,  283,  283,  283,  283,  283,  513,    0,    0,  283, 
          262,  283,  283,    0,  283,  283,  283,  283,    0,    0, 
            0,  513,    0,    0,  262,  262,    0,  283,  283,  283, 
          643,  283,  283,  283,    0,  283,  323,  323,  323,  283, 
          283,  323,  323,  323,  283,  323,  283,  283,  283,  283, 
          283,  283,  283,  513,    0,  323,  323,  283,  283,  283, 
          283,  283,  283,  283,  323,  323,  283,  323,  323,  323, 
          323,  323,    0,  283,    0,    0,  283,  283,  283,    0, 
          283,  283,  283,  283,  283,  283,  283,  283,  283,  283, 
          283,  323,  323,  323,  323,  323,  323,  323,  323,  323, 
          323,  323,  323,  323,  323,    0,    0,  323,  323,  323, 
          323,  283,    0,  323,  283,    0,  323,  283,  283,  323, 
          283,  323,  283,  323,  283,  323,  283,  323,  323,  323, 
          323,  323,  323,  323,  283,  323,  513,  323,    0,  283, 
          283,  283,  283,  283,  283,    0,  513,    0,  283,    0, 
          283,  283,    0,  283,  283,  283,  283,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  283,  283,  283,  323, 
          556,    0,  557,  558,  559,  560,  561,    0,    0,    0, 
           91,  562,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  513,    0,  110,    0,  513, 
            0,    0,    0,    0,  563,  681,    0,    0,    0,    0, 
            0,    0,  565,  566,  567,  568,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  513,  262,  262, 
          262,    0,    0,  262,  262,  262,    0,  262,    0,    0, 
            0,    0,  614,    0,    0,    0,    0,  262,  262,    0, 
            0,    0,    0,    0,    0,    0,  262,  262,  569,  262, 
          262,  262,  262,  262,    0,    0,    0,    0,    0,    0, 
            0,  262,    0,    0,    0,  516,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  516,    0,    0,    0,    0, 
          513,    0,    0,    0,    0,    0,    0,  513,  513,    0, 
            0,    0,    0,  614,    0,  262,    0,    0,  262,    0, 
            0,  262,    0,  262,    0,    0,    0,    0,    0,   94, 
            0,  513,    0,    0,  614,    0,    0,    0,    0,  262, 
            0,    0,    0,    0,  516,    0,  113,    0,  516,    0, 
            0,  262,    0,    0,    0,    0,  885,    0,  557,  558, 
          559,  560,  561,    0,    0,    0,    0,  562,    0,    0, 
            0,  262,    0,    0,    0,    0,  516,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          563,    0,    0,    0,    0,    0,    0,    0,  565,  566, 
          567,  568,    0,  614,  614,  614,    0,  614,  513,  513, 
          513,  614,  614,    0,  513,  513,  614,  513,  614,  614, 
          614,  614,  614,  614,  614,    0,  614,    0,    0,  614, 
          614,  614,  614,  614,  614,  614,  513,  513,  614,  513, 
          513,  513,  513,  513,  569,  614,  106,    0,  614,  614, 
          614,    0,  614,  614,  614,  614,  614,  614,  614,  614, 
          614,  614,  614,  513,  513,  513,  513,  513,  513,  513, 
          513,  513,  513,  513,  513,  513,  513,    0,    0,  513, 
          513,  513,  513,  614,  525,  103,  614,  614,  513,  614, 
          614,    0,  614,  618,  614,  513,  614,  513,  614,  513, 
          513,  513,  513,  513,  513,  513,  614,  513,  614,  513, 
            0,  614,  614,  614,  614,  614,  614,  516,    0,  103, 
          614,    0,  614,  614,  868,  614,  614,  614,  614,    0, 
            0,    0,  516,    0,  881,    0,  103,    0,  614,  614, 
          614,  513,  615,  615,  615,  888,  615,  516,  516,  516, 
          615,  615,    0,  516,  516,  615,  516,  615,  615,  615, 
          615,  615,  615,  615,  516,  615,  437,    0,  615,  615, 
          615,  615,  615,  615,  615,  516,  516,  615,  516,  516, 
          516,  516,  516,    0,  615,    0,    0,  615,  615,  615, 
            0,  615,  615,  615,  615,  615,  615,  615,  615,  615, 
          615,  615,  516,  516,  516,  516,  516,  516,  516,  516, 
          516,  516,  516,  516,  516,  516,  414,    0,  516,  516, 
          516,  516,  615,  528,    0,  615,  615,  516,  615,  615, 
            0,  615,    0,  615,  516,  615,  516,  615,  516,  516, 
          516,  516,  516,  516,  516,  615,  516,  615,  516,    0, 
          615,  615,  615,  615,  615,  615,    0,    0,  621,  615, 
            0,  615,  615,    0,  615,  615,  615,  615,  621,    0, 
            0,   98,    0,    0,    0,    0,    0,  615,  615,  615, 
          516,  125,  618,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  105,    0,    0,   98,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  621,    0,  124, 
            0,  621,   98, 1023,    0, 1025,    0, 1026,    0,    0, 
          618,    0, 1028,    0,    0,    0,    0,  618,  618, 1036, 
            0,    0,    0,  618,    0,    0,    0,    0,    0,  621, 
            0,    0,  520,  615,  103,  437,    0,    0,    0,    0, 
            0,    0,    0,    0,  618,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  617,    0,    0, 
            0,  516,    0,  437,    0,    0,    0,  617,  516,  516, 
          437,  437,    0,    0,  615,    0,    0,  103,    0, 1081, 
            0,    0,    0,    0,    0, 1082,    0, 1084,    0,    0, 
         1085,    0,  516,    0,    0,  615,    0,  437,    0,    0, 
            0,  104,    0,    0,  109,    0,    0,    0,    0,    0, 
          802,    0,    0,    0,    0, 1094,  617,    0,  123,    0, 
          617,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          389,  390,  391,  392,  393,  394,  395,  396,  397,  398, 
          399,    0,  400,  401,    0,    0,  402,  403,  617,    0, 
            0,  306,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  404,    0,  405,    0,  406,  407,  408,  409, 
          410,  411,  412,    0,  413,  617,  617,  617,    0,  617, 
          621,  621,  621,  617,  617,    0,  621,  621,  617,  621, 
          617,  617,  617,  617,  617,  617,  617,    0,  621,    0, 
           98,  617,  617,  617,  617,  617,  617,  617,  621,  621, 
          617,  621,  621,  621,  621,  621,    0,  617,  108,    0, 
          617,  617,  617,    0,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  621,  621,  621,  621,  621, 
          621,  621,  621,  621,  621,  621,  621,  621,  621,  520, 
            0,  621,  621,  621,  621,  617,  520,  520,  617,  617, 
          621,  617,  617,   98,  617,  317,  617,  621,  617,  621, 
          617,  621,  621,  621,  621,  621,  621,  621,  617,  621, 
          621,  621,    0,  617,  617,  617,  617,  617,  617,    0, 
            0,    0,  617,    0,  617,  617,    0,  617,  617,  617, 
          617,  658,    0,    0,    0,    0,    0,    0,    0,    0, 
          617,  617,  617,  621,  617,  617,  617,    0,  617,  617, 
          617,  617,  617,  617,    0,  617,  617,  617,  617,  617, 
          617,  617, 
      };
   }

   private static final short[] yyTable2() {
      return new short[] {

          617,  617,  617,  617,    0,  617,    0,  128,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,    0,  617,    0,    0,  617,  617,  617, 
            0,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  306,    0,  617,  617, 
          617,  617,  617,  306,  306,  617,  617,  617,  617,  617, 
            0,  617,    0,  617,  617,  617,  617,  617,  617,  617, 
          617,  617,  617,  617,  617,  617,  617,  617,  617,    0, 
          617,  617,  617,  617,  617,  617,    0,    0,  618,  617, 
            0,  617,  617,    0,  617,  617,  617,  617,  618,    0, 
            0,   99,    0,    0,    0,    0,    0,  617,  617,  617, 
          617,  127,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  106,    0,    0,   99,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  618,    0,  125, 
            0,  618,   99,    0,    0,    0,    0,    0,    0,    0, 
          317,    0,    0,    0,    0,    0,    0,  317,  317,    0, 
            0,    0,    4,    5,    6,    0,    8,    0,    0,  618, 
            9,   10,  521,    0,    0,   11,    0,   12,   13,   14, 
          108,  109,   17,   18,    0,    0,    0,    0,  110,  111, 
          112,  339,  340,  341,  342,    0,    0,  117,    0,    0, 
            0,    0,    0,    0,  118,    0,    0,  343,  344,  345, 
            0,  346,   35,  347,  348,  349,  350,  316,   40,    0, 
            0,  127,    0,    0,    0,    0,    0,  316,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  351,    0,    0,  130,    0,    0,   46,   47, 
            0,   48,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  107,    0,    0,    0,    0,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,  316,    0,  126,   58, 
          316,   59,   60,    0,   61,   62,   63,   64,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   65,   66,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  316,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  618,  618,  618,    0,  618, 
          618,  618,  618,  618,  618,    0,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,    0,  618,    0, 
           99,  618,  618,  618,  618,  618,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,    0,  618,    0,    0, 
          618,  618,  618,    0,  618,  618,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,  618,  618,  521, 
            0,  618,  618,  618,  618,  618,  521,  521,  618,  618, 
          618,  618,  618,   99,  618,    0,  618,  618,  618,  618, 
          618,  618,  618,  618,  618,  618,  618,  618,  618,  618, 
          618,  618,    0,  618,  618,  618,  618,  618,  618,    0, 
            0,    0,  618,    0,  618,  618,  643,  618,  618,  618, 
          618,    0,    0,    0,    0,    0,  643,    0,    0,    0, 
          618,  618,  618,  618,  618,  618,  618,    0,  618,  316, 
          316,  316,  618,  618,    0,  316,  316,  618,  316,  618, 
          618,  618,  618,  618,  618,  618,    0,    0,    0,    0, 
          618,  618,  618,  618,  618,  618,  618,  316,  316,  618, 
          316,  316,  316,  316,  316,  643,  618,    0,    0,  618, 
          618,  618,    0,  618,  618,  618,  618,  618,  618,  618, 
          618,  618,  618,  618,  316,  316,  316,  316,  316,  316, 
          316,  316,  316,  316,  316,  316,  316,  316,    0,    0, 
          316,  316,  316,  316,  618,    0,    0,  618,  618,  316, 
          618,  618,    0,  618,    0,  618,  316,  618,  316,  618, 
          316,  316,  316,  316,  316,  316,  316,  618,  316,    0, 
          316,    0,  618,  618,  618,  618,  618,  618,    0,    0, 
          437,  618,    0,  618,  618,    0,  618,  618,  618,  618, 
          437,    0,    0,    0,    0,    0,    0,    0,    0,  618, 
          618,  618,  316,    0,    0,  630,  631,    0,    0,  632, 
            0,    0,    0,  187,  188,    0,  189,  190,  191,  192, 
          193,  194,  195,    0,  437,  196,  197,    0,    0,    0, 
          198,  199,  200,  201,    0,    0,    0,    0,  437,  437, 
          303,  122,    0,  437,    0,    0,    0,  203,  204,    0, 
          205,  206,  207,  208,  209,  210,  211,  212,  213,  214, 
          215,    0,    0,  216,    0,    0,    0,    0,    0,    0, 
            0,  437,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          883,    0,    0,  883,    0,    0,    0,    0,    0,  893, 
            0,    0,    0,  283,  283,  283,    0,  283,  643,  643, 
          643,  283,  283,  643,  643,  643,  283,  643,  283,  283, 
          283,  283,  283,  283,  283,    0,  643,  643,  643,  283, 
          283,  283,  283,  283,  283,  283,  643,  643,  283,  643, 
          643,  643,  643,  643,    0,  283,    0,    0,  283,  283, 
          283,    0,  283,  283,  283,  283,  283,  283,  283,  283, 
          283,  283,  283,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  643,    0,    0,    0,    0,    0, 
            0,  643,  643,  283,    0,    0,  283,  436,  643,  283, 
          283,    0,  283,    0,  283,    0,  283,  436,  283,    0, 
            0,    0,    0,    0,    0,    0,  283,    0,  643,  643, 
            0,  283,  283,  283,  283,  283,  283,    0,    0,    0, 
          283,    0,  283,  283,    0,  283,  283,  283,  283,    0, 
            0,  436,    0,    0,    0,    0,    0,    0,  283,  283, 
          283,  643,  437,  437,  437,  436,  436,  437,  437,  437, 
          436,  437,    0,    0,    0,    0,    0,    0,    0,    0, 
          437,  437,  437,    0,    0,    0,    0,    0,    0,    0, 
          437,  437,    0,  437,  437,  437,  437,  437,  436,    0, 
            0,    0,    0,    0,    0,  437,  893,    0,    0,  893, 
            0,  883,    0,  893,    0,    0,    0,  437,  437,  437, 
          437,  437,  437,  437,  437,  437,  437,  437,  437,  437, 
          437,    0,    0,  437,  437,  437,  437,    0,    0,  437, 
            0,    0,  437,    0,    0,  437,    0,  437,    0,  437, 
          519,  437,    0,  437,  437,  437,  437,  437,  437,  437, 
          519,  437,  437,  437,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  437,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  519,  437,    0,  893,    0,  893, 
            0,  893,    0,    0,  893,    0,    0,    0,  519,  519, 
            0,  116,  101,  519,    0,  389,  390,  391,  392,  393, 
          394,  395,  396,  397,  398,  399,    0,    0,    0,  893, 
            0,  402,  403,    0,    0,    0,    0,    0,    0,    0, 
            0,  519,    0,    0,    0,    0,  101,  404,    0,  405, 
            0,  406,  407,  408,  409,  410,  411,  412,   25,  413, 
            0,    0,    0,  101,    0,    0,    0,    0,   25,  436, 
          436,  436,    0,    0,  436,  436,  436,    0,  436,    0, 
            0,    0,    0,    0,    0,    0,    0,  436,  436,  436, 
            0,    0,    0,  523,    0,    0,    0,  436,  436,    0, 
          436,  436,  436,  436,  436,    0,    0,    0,    0,    0, 
            0,    0,  436,  518,    0,    0,    0,   25,    0,    0, 
            0,    0,    0,  518,  436,  436,  436,  436,  436,  436, 
          436,  436,  436,  436,  436,  436,  436,  436,    0,    0, 
          436,  436,  436,  436,    0,    0,  436,    0,    0,  436, 
            0,    0,  436,    0,  436,    0,  436,  518,  436,    0, 
          436,  436,  436,  436,  436,  436,  436,    0,  436,  436, 
          436,  518,  518,    0,  115,    0,  518,    0,    0,    0, 
            0,    0,  436,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  436,    0,  518,    0,    0,    0,    0,    0, 
            0,    0,  519,  519,  519,    0,    0,  519,  519,  519, 
            0,  519,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  519,  519,    0,    0,    0,    0,    0,    0,    0, 
          519,  519,    0,  519,  519,  519,  519,  519,    0,    0, 
            0,    0,    0,    0,    0,  519,  520,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  520,  519,  519,  519, 
          519,  519,  519,  519,  519,  519,  519,  519,  519,  519, 
          519,  101,    0,  519,  519,  519,  519,    0,  531,  519, 
            0,    0,  519,    0,    0,  519,    0,  519,    0,  519, 
          520,  519,    0,  519,  519,  519,  519,  519,  519,  519, 
            0,  519,    0,  519,  520,  520,    0,  117,    0,  520, 
           25,   25,   25,    0,    0,  519,   25,   25,    0,   25, 
          523,    0,    0,    0,    0,    0,    0,  523,  523,  100, 
            0,    0,    0,    0,  101,  519,    0,  520,    0,    0, 
            0,   25,   25,   25,   25,   25,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  100,    0,  518,  518,  518,    0,    0, 
          518,  518,  518,    0,  518,    0,    0,    0,    0,    0, 
          100,    0,    0,    0,  518,  518,    0,    0,    0,    0, 
           25,    0,    0,  518,  518,    0,  518,  518,  518,  518, 
          518,    0,    0,    0,    0,    0,    0,    0,  518,  521, 
          522,   25,    0,    0,    0,    0,    0,    0,    0,  521, 
          518,  518,  518,  518,  518,  518,  518,  518,  518,  518, 
          518,  518,  518,  518,    0,    0,  518,  518,  518,  518, 
            0,  530,  518,   25,    0,  518,    0,    0,  518,    0, 
          518,    0,  518,  521,  518,    0,  518,  518,  518,  518, 
          518,  518,  518,    0,  518,    0,  518,  521,  521,    0, 
          118,    0,  521,    0,    0,    0,    0,    0,  518,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  518,    0, 
          521,    0,    0,    0,    0,    0,    0,    0,  520,  520, 
          520,    0,    0,  520,  520,  520,    0,  520,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  520,  520,    0, 
            0,    0,    0,    0,    0,    0,  520,  520,    0,  520, 
          520,  520,  520,  520,    0,    0,    0,    0,    0,    0, 
            0,  520,  523,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  523,  520,  520,  520,  520,  520,  520,  520, 
          520,  520,  520,  520,  520,  520,  520,    0,    0,  520, 
          520,  520,  520,    0,  532,  520,    0,    0,  520,    0, 
            0,  520,    0,  520,    0,  520,  523,  520,  100,  520, 
          520,  520,  520,  520,  520,  520,    0,  520,    0,  520, 
          523,  523,    0,  120,  102,  523,    0,    0,    0,    0, 
            0,  520,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   93,    0,    0,    0,    0, 
            0,  520,    0,  523,    0,    0,    0,  522,  102,    0, 
            0,    0,    0,    0,  522,  522,    0,    0,    0,    0, 
            0,  100,    0,    0,    0,  102,    0,    0,    0,   93, 
            0,  521,  521,  521,    0,    0,  521,  521,  521,    0, 
          521,    0,    0,    0,    0,    0,   93,    0,    0,    0, 
          521,  521,    0,    0,    0,  524,    0,    0,    0,  521, 
          521,    0,  521,  521,  521,  521,  521,    0,    0,    0, 
            0,    0,    0,    0,  521,  522,  515,    0,    0,    0, 
            0,    0,    0,    0,    0,  522,  521,  521,  521,  521, 
          521,  521,  521,  521,  521,  521,  521,  521,  521,  521, 
            0,    0,  521,  521,  521,  521,    0,  533,  521,    0, 
            0,  521,    0,    0,  521,    0,  521,    0,  521,  522, 
          521,    0,  521,  521,  521,  521,  521,  521,  521,    0, 
          521,    0,  521,  522,  522,    0,  119,    0,  522,    0, 
            0,    0,    0,    0,  521,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  521,    0,  522,    0,    0,    0, 
            0,    0,    0,    0,  523,  523,  523,    0,    0,  523, 
          523,  523,    0,  523,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  523,  523,    0,    0,    0,    0,    0, 
            0,    0,  523,  523,    0,  523,  523,  523,  523,  523, 
            0,    0,    0,    0,    0,    0,    0,  523,  524,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  524,  523, 
          523,  523,  523,  523,  523,  523,  523,  523,  523,  523, 
          523,  523,  523,  102,    0,  523,  523,  523,  523,    0, 
          535,  523,    0,    0,  523,    0,    0,  523,    0,  523, 
            0,  523,  524,  523,   93,  523,  523,  523,  523,  523, 
          523,  523,    0,  523,    0,  523,  524,  524,    0,  121, 
           92,  524,    0,    0,    0,    0,    0,  523,    0,    0, 
            0,    0,  524,    0,    0,    0,    0,    0,    0,  524, 
          524,   95,    0,    0,    0,    0,  102,  523,    0,  524, 
            0,    0,    0,  515,   92,    0,    0,    0,    0,    0, 
          515,  515,    0,    0,    0,    0,    0,   93,    0,    0, 
            0,   92,    0,    0,    0,   95,    0,  522,  522,  522, 
            0,    0,  522,  522,  522,    0,  522,    0,    0,    0, 
            0,    0,   95,    0,    0,    0,  522,  522,    0,    0, 
            0,  514,    0,    0,    0,  522,  522,    0,  522,  522, 
          522,  522,  522,    0,    0,    0,    0,    0,    0,    0, 
          522,  515,  517,    0,    0,    0,    0,    0,    0,    0, 
            0,  515,  522,  522,  522,  522,  522,  522,  522,  522, 
          522,  522,  522,  522,  522,  522,    0,    0,  522,  522, 
          522,  522,    0,  534,  522,    0,    0,  522,    0,    0, 
          522,    0,  522,    0,  522,  515,  522,    0,  522,  522, 
          522,  522,  522,  522,  522,    0,  522,    0,  522,  515, 
          515,    0,  112,    0,  515,    0,    0,    0,    0,    0, 
          522,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          522,    0,  515,    0,    0,    0,    0,    0,    0,    0, 
          524,  524,  524,    0,    0,  524,  524,  524,    0,  524, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  524, 
          524,    0,    0,    0,    0,    0,    0,    0,  524,  524, 
            0,  524,  524,  524,  524,  524,    0,    0,    0,    0, 
            0,    0,    0,  524,  514,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  514,  524,  524,  524,  524,  524, 
          524,  524,  524,  524,  524,  524,  524,  524,  524,   92, 
            0,  524,  524,  524,  524,    0,  536,  524,    0,    0, 
          524,    0,    0,  524,    0,  524,  109,  524,  514,  524, 
           95,  524,  524,  524,  524,  524,  524,  524,    0,  524, 
            0,  524,  514,  514,    0,  111,  108,  514,    0,    0, 
            0,    0,    0,  524,    0,    0,    0,    0,  514,    0, 
          109,    0,    0,    0,    0,  514,  514,    0,    0,    0, 
            0,    0,   92,  524,    0,  514,    0,  109,    0,  517, 
          108,    0,    0,    0,    0,    0,  517,  517,    0,    0, 
            0,    0,    0,   95,    0,    0,    0,  108,    0,    0, 
            0,    0,    0,  515,  515,  515,    0,  306,  515,  515, 
          515,    0,  515,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  515,  515,    0,    0,    0,  317,    0,    0, 
            0,  515,  515,    0,  515,  515,  515,  515,  515,    0, 
            0,    0,    0,    0,    0,    0,  515,  517,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  517,  515,  515, 
          515,  515,  515,  515,  515,  515,  515,  515,  515,  515, 
          515,  515,    0,    0,  515,  515,  515,  515,    0,  527, 
          515,    0,    0,  515,    0,    0,  515,    0,  515,    0, 
          515,  517,  515,    0,  515,  515,  515,  515,  515,  515, 
          515,    0,  515,    0,  515,  517,  517,    0,  114,    0, 
          517,    0,    0,    0,    0,    0,  515,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  515,    0,  517,    0, 
            0,    0,    0,    0,    0,    0,  514,  514,  514,    0, 
            0,  514,  514,  514,    0,  514,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  514,  514,    0,    0,    0, 
            0,    0,    0,    0,  514,  514,    0,  514,  514,  514, 
          514,  514,    0,    0,    0,    0,    0,    0,    0,  514, 
          643,    0,    0,    0,    0,  109,    0,    0,    0,    0, 
          643,  514,  514,  514,  514,  514,  514,  514,  514,  514, 
          514,  514,  514,  514,  514,  108,    0,  514,  514,  514, 
          514,    0,  526,  514,    0,    0,  514,    0,    0,  514, 
            0,  514,    0,  514,  643,  514,    0,  514,  514,  514, 
          514,  514,  514,  514,  306,  514,    0,  514,  643,  643, 
            0,  306,  306,  643,    0,    0,    0,    0,  109,  514, 
            0,    0,    0,    0,  317,    0,    0,    0,    0,    0, 
            0,  317,  317,    0,    0,    0,    0,    0,  108,  514, 
            0,  643,    0,    0,    0,  621,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          621,    0,    0,    0,    0,    0,    0,    0,    0,  517, 
          517,  517,    0,    0,  517,  517,  517,    0,  517,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  517,  517, 
            0,    0,  621,    0,    0,    0,    0,  517,  517,    0, 
          517,  517,  517,  517,  517,    0,    0,    0,    0,    0, 
            0,    0,  517,  306,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  306,  517,  517,  517,  517,  517,  517, 
          517,  517,  517,  517,  517,  517,  517,  517,    0,    0, 
          517,  517,  517,  517,    0,  529,  517,    0,    0,  517, 
            0,    0,  517,    0,  517,    0,  517,  306,  517,    0, 
          517,  517,  517,  517,  517,  517,  517,    0,  517,    0, 
          517,  306,  306,    0,  128,    0,  306,    0,    0,    0, 
            0,    0,  517,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  517,    0,  306,    0,    0,    0,    0,    0, 
            0,    0,  643,  643,  643,    0,    0,  643,  643,  643, 
            0,  643,    0,    0,    0,    0,    0,    0,    0,    0, 
          643,  643,  643,    0,    0,    0,    0,    0,    0,    0, 
          643,  643,    0,  643,  643,  643,  643,  643,    0,    0, 
            0,    0,    0,    0,    0,  643,  317,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  317,  643,  643,  643, 
          643,  643,  643,  643,  643,  643,  643,  643,  643,  643, 
          643,  621,    0,  643,  643,  643,  643,    0,    0,  643, 
            0,    0,  643,    0,    0,  643,    0,  643,    0,  643, 
          317,  643,    0,  643,  643,  643,  643,  643,  643,  643, 
            0,  643,  643,  643,  317,  317,    0,  127,    0,  317, 
            0,    0,    0,    0,    0,  643,    0,    0,    0,  621, 
            0,    0,    0,    0,    0,    0,  621,  621,    0,    0, 
            0,    0,  617,    0,    0,  643,    0,  317,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          621,    0,    0,  621,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  306,  306,  306,  414,    0, 
          306,  306,  306,    0,  306,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  306,  306,    0,    0,    0,    0, 
            0,    0,    0,  306,  306,    0,  306,  306,  306,  306, 
          306,    0,    0,    0,    0,    0,    0,    0,  306,  457, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  457, 
          306,  306,  306,  306,  306,  306,  306,  306,  306,  306, 
          306,  306,  306,  306,    0,    0,  306,  306,  306,  306, 
            0,    0,  306,    0,    0,  306,    0,    0,  306,    0, 
          306,    0,  306,  457,  306,    0,  306,  306,  306,  306, 
          306,  306,  306,    0,  306,    0,  306,  457,  457,    0, 
            0,    0,  457,    0,    0,    0,    0,    0,  306,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  306,    0, 
          457,    0,    0,    0,    0,    0,    0,    0,  317,  317, 
          317,    0,    0,  317,  317,  317,    0,  317,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  317,  317,    0, 
            0,    0,    0,    0,    0,    0,  317,  317,    0,  317, 
          317,  317,  317,  317,    0,    0,    0,    0,    0,    0, 
            0,  317,  328,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  328,  317,  317,  317,  317,  317,  317,  317, 
          317,  317,  317,  317,  317,  317,  317,    0,    0,  317, 
          317,  317,  317,    0,    0,  317,    0,    0,  317,    0, 
            0,  317,    0,  317,    0,  317,  328,  317,    0,  317, 
          317,  317,  317,  317,  317,  317,    0,  317,    0,  317, 
          328,  328,    0,    0,    0,  328,    0,    0,    0,    0, 
            0,  317,  389,  390,  391,  392,  393,  394,  395,  396, 
          397,  398,  399,    0,  400,  401,    0,    0,  402,  403, 
            0,  317,    0,  328,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  404,    0,  405,    0,  406,  407, 
          408,  409,  410,  411,  412,    0,  413,    0,    0,    0, 
            0,  457,  457,  457,    0,    0,  457,  457,  457,    0, 
          457,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          457,  457,    0,    0,    0,    0,    0,    0,    0,  457, 
          457,    0,  457,  457,  457,  457,  457,    0,    0,    0, 
            0,    0,    0,    0,  457,  264,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  264,  457,  457,  457,  457, 
          457,  457,  457,  457,  457,  457,  457,  457,  457,  457, 
            0,    0,  457,  457,  457,  457,    0,    0,  457,    0, 
            0,  457,    0,    0,  457,    0,  457,    0,  457,  264, 
          457,    0,  457,  457,  457,  457,  457,  457,  457,    0, 
          457,    0,  457,  264,  264,    0,    0,    0,  264,    0, 
            0,    0,    0,    0,  457,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  457,    0,  360,    0,    0,    0, 
            0,    0,    0,    0,  328,  328,  328,    0,    0,  328, 
          328,  328,    0,  328,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  328,  328,    0,    0,    0,    0,    0, 
            0,    0,  328,  328,    0,  328,  328,  328,  328,  328, 
            0,    0,    0,    0,    0,    0,    0,  328,  323,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  323,  328, 
          328,  328,  328,  328,  328,  328,  328,  328,  328,  328, 
          328,  328,  328,    0,    0,  328,  328,  328,  328,    0, 
            0,  328,    0,    0,  328,    0,    0,  328,    0,  328, 
            0,  328,  323,  328,    0,  328,  328,  328,  328,  328, 
          328,  328,    0,  328,    0,  328,  323,  323,    0,    0, 
            0,  323,    0,    0,    0,    0,    0,  328,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  328,    0,  323, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  264,  264,  264, 
            0,    0,  264,  264,  264,    0,  264,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  264,  264,    0,    0, 
            0,    0,    0,    0,    0,  264,  264,    0,  264,  264, 
          264,  264,  264,    0,    0,    0,    0,    0,    0,    0, 
          264,  508,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  508,  264,  264,  264,  264,  264,  264,  264,  264, 
          264,  264,  264,  360,  264,  264,    0,    0,  264,  264, 
          360,  360,    0,    0,  264,    0,    0,  264,    0,    0, 
          264,    0,  264,    0,  264,  508,  264,    0,  264,  264, 
          264,  264,  264,  264,  264,    0,  264,    0,  264,  508, 
          508,    0,    0,    0,  508,    0,    0,    0,    0,    0, 
          264,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          264,    0,  508,    0,    0,    0,    0,    0,    0,    0, 
          323,  323,  323,    0,    0,  323,  323,  323,    0,  323, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  323, 
          323,    0,    0,    0,    0,    0,    0,    0,  323,  323, 
            0,  323,  323,  323,  323,  323,    0,    0,    0,    0, 
            0,    0,    0,  323,  356,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  356,  323,  323,  323,  323,  323, 
          323,  323,  323,  323,  323,  323,  323,  323,  323,    0, 
            0,  323,  323,  323,  323,    0,    0,  323,    0,    0, 
          323,    0,    0,  323,    0,  323,    0,  323,  356,  323, 
            0,  323,  323,  323,  323,  323,  323,  323,    0,  323, 
            0,  323,    0,  356,    0,    0,    0,  356,    0,    0, 
            0,    0,    0,  323,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  323,    0,  356,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   53,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   53,  508,  508,  508,    0,    0,  508,  508, 
          508,    0,  508,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  508,  508,    0,    0,    0,    0,    0,    0, 
            0,  508,  508,    0,  508,  508,  508,  508,  508,    0, 
            0,    0,    0,    0,    0,    0,  508,  357,    0,    0, 
            0,   53,    0,    0,    0,    0,    0,  357,    0,  508, 
          508,  508,  508,  508,  508,  508,  508,  508,  508,  508, 
          508,  508,    0,    0,  508,  508,  508,  508,    0,    0, 
          508,    0,    0,  508,    0,    0,  508,    0,  508,    0, 
          508,  357,  508,    0,  508,  508,  508,  508,  508,  508, 
          508,    0,  508,    0,  508,    0,  357,    0,    0,    0, 
          357,    0,    0,    0,    0,    0,  508,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  508,    0,  357,    0, 
            0,    0,    0,    0,    0,    0,  356,  356,  356,    0, 
            0,  356,  356,  356,    0,  356,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  356,  356,    0,    0,    0, 
            0,    0,    0,    0,  356,  356,    0,  356,  356,  356, 
          356,  356,    0,    0,    0,    0,    0,    0,    0,    0, 
          320,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          320,  356,  356,  356,  356,  356,  356,  356,  356,  356, 
          356,  356,  356,  356,  356,    0,    0,  356,  356,  356, 
          356,    0,    0,  356,    0,    0,  356,    0,    0,  356, 
            0,  356,    0,  356,  320,  356,    0,  356,  356,  356, 
          356,  356,  356,  356,    0,  356,    0,  356,    0,  320, 
            0,    0,    0,  320,   53,   53,   53,    0,    0,   53, 
           53,   53,    0,   53,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   53,    0,    0,    0,    0,    0,  356, 
            0,  320,   53,   53,    0,   53,   53,   53,   53,   53, 
            0,    0,    0,    0,    0,    0,    0,    0,   55,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   55,  357, 
          357,  357,    0,    0,  357,  357,  357,    0,  357,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  357,  357, 
            0,    0,    0,    0,   53,    0,    0,  357,  357,    0, 
          357,  357,  357,  357,  357,    0,    0,    0,    0,    0, 
            0,    0,    0,  239,    0,   53,    0,   55,    0,    0, 
            0,    0,    0,  239,  357,  357,  357,  357,  357,  357, 
          357,  357,  357,  357,  357,  357,  357,  357,    0,    0, 
          357,  357,  357,  357,    0,    0,  357,   53,    0,  357, 
            0,    0,  357,    0,  357,    0,  357,  239,  357,    0, 
          357,  357,  357,  357,  357,  357,  357,    0,  357,    0, 
          357,  239,  239,    0,    0,    0,  239,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  357,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  320,  320,  320,    0,    0,  320,  320,  320, 
            0,  320,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  320,  320,    0,    0,    0,    0,    0,    0,    0, 
          320,  320,    0,  320,  320,  320,  320,  320,    0,    0, 
            0,    0,    0,    0,    0,    0,  236,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  236,  320,  320,  320, 
          320,  320,  320,  320,  320,  320,  320,  320,  320,  320, 
          320,    0,    0,  320,  320,  320,  320,    0,    0,  320, 
            0,    0,  320,    0,    0,  320,    0,  320,    0,  320, 
          236,  320,    0,  320,  320,  320,  320,  320,  320,  320, 
            0,  320,    0,  320,  236,  236,    0,    0,    0,  236, 
           55,   55,   55,    0,    0,   55,   55,   55,    0,   55, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   55, 
            0,    0,    0,    0,    0,  320,    0,    0,   55,   55, 
            0,   55,   55,   55,   55,   55,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  239,  239,  239,    0,    0, 
          239,  239,  239,    0,  239,    0,  238,    0,    0,    0, 
            0,    0,    0,    0,  239,  239,  238,    0,    0,    0, 
           55,    0,    0,  239,  239,    0,  239,  239,  239,  239, 
          239,    0,    0,    0,    0,    0,    0,    0,  239,    0, 
            0,   55,    0,    0,    0,    0,    0,    0,    0,    0, 
          238,  239,  239,  239,  239,  239,  239,  239,  239,  239, 
          239,    0,  239,  239,  238,  238,  239,  239,    0,  238, 
            0,    0,  239,   55,    0,  239,    0,    0,  239,    0, 
          239,    0,  239,    0,  239,    0,  239,  239,  239,  239, 
          239,  239,  239,    0,  239,    0,  239,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  239,    0, 
            0,    0,    0,    0,    0,    0,  237,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  237,    0,  239,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  236,  236, 
          236,    0,    0,  236,  236,  236,    0,  236,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  236,  236,    0, 
          237,    0,    0,    0,    0,    0,  236,  236,    0,  236, 
          236,  236,  236,  236,  237,  237,    0,    0,    0,  237, 
            0,  236,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  236,  236,  236,  236,  236,  236, 
          236,  236,  236,  236,    0,  236,  236,    0,    0,  236, 
          236,    0,    0,    0,    0,  236,    0,    0,  236,    0, 
            0,  236,    0,  236,    0,  236,    0,  236,    0,  236, 
          236,  236,  236,  236,  236,  236,    0,  236,    0,  236, 
            0,    0,    0,    0,    0,    0,  240,    0,    0,    0, 
            0,  236,    0,    0,    0,    0,  240,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  238,  238, 
          238,  236,    0,  238,  238,  238,    0,  238,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  238,  238,    0, 
          240,    0,    0,    0,    0,    0,  238,  238,    0,  238, 
          238,  238,  238,  238,  240,  240,    0,    0,    0,  240, 
            0,  238,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  238,  238,  238,  238,  238,  238, 
          238,  238,  238,  238,    0,  238,  238,    0,    0,  238, 
          238,    0,    0,    0,    0,  238,    0,    0,  238,    0, 
            0,  238,    0,  238,    0,  238,  437,  238,    0,  238, 
          238,  238,  238,  238,  238,  238,  437,  238,    0,  238, 
            0,    0,    0,    0,    0,    0,    0,    0,  237,  237, 
          237,  238,    0,  237,  237,  237,    0,  237,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  237,  237,    0, 
          103,  238,    0,    0,    0,    0,  237,  237,    0,  237, 
          237,  237,  237,  237,    0,  437,    0,  122,    0,  437, 
            0,  237,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  237,  237,  237,  237,  237,  237, 
          237,  237,  237,  237,    0,  237,  237,  437,    0,  237, 
          237,    0,    0,    0,    0,  237,    0,    0,  237,    0, 
            0,  237,    0,  237,    0,  237,    0,  237,    0,  237, 
          237,  237,  237,  237,  237,  237,    0,  237,    0,  237, 
            0,    0,    0,    0,    0,    0,  519,    0,    0,    0, 
            0,  237,    0,    0,    0,    0,  519,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  240,  240, 
          240,  237,    0,  240,  240,  240,    0,  240,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  240,  240,    0, 
           97,    0,    0,    0,    0,    0,  240,  240,    0,  240, 
          240,  240,  240,  240,    0,  519,    0,  116,    0,  519, 
            0,  240,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  240,  240,  240,  240,  240,  240, 
          240,  240,  240,  240,    0,  240,  240,  519,    0,  240, 
          240,    0,    0,    0,    0,  240,    0,    0,  240,    0, 
            0,  240,    0,  240,    0,  240,  518,  240,    0,  240, 
          240,  240,  240,  240,  240,  240,  518,  240,    0,  240, 
            0,    0,    0,    0,    0,    0,    0,    0,  437,  437, 
          437,  240,    0,    0,  437,  437,    0,  437,    0,    0, 
            0,    0,    0,    0,    0,    0,  437,    0,    0,    0, 
           96,  240,    0,    0,    0,    0,  437,  437,    0,  437, 
          437,  437,  437,  437,    0,  518,    0,  115,    0,  518, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  437,  437,  437,  437,  437,  437,  437, 
          437,  437,  437,  437,  437,  437,  437,  518,    0,  437, 
          437,  437,  437,    0,    0,    0,    0,    0,  437,    0, 
            0,    0,    0,    0,    0,  437,    0,  437,    0,  437, 
          437,  437,  437,  437,  437,  437,    0,  437,  437,  437, 
            0,    0,    0,    0,    0,    0,  520,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  520,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  519,  519, 
          519,  437,    0,    0,  519,  519,    0,  519,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           98,    0,    0,    0,    0,    0,  519,  519,    0,  519, 
          519,  519,  519,  519,    0,  520,    0,  117,    0,  520, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  519,  519,  519,  519,  519,  519,  519, 
          519,  519,  519,  519,  519,  519,  519,  520,    0,  519, 
          519,  519,  519,    0,  531,    0,    0,    0,  519,    0, 
            0,    0,    0,    0,    0,  519,  521,  519,    0,  519, 
          519,  519,  519,  519,  519,  519,  521,  519,    0,  519, 
            0,    0,    0,    0,    0,    0,    0,    0,  518,  518, 
          518,    0,    0,    0,  518,  518,    0,  518,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           99,  519,    0,    0,    0,    0,  518,  518,    0,  518, 
          518,  518,  518,  518,    0,  521,    0,  118,    0,  521, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  518,  518,  518,  518,  518,  518,  518, 
          518,  518,  518,  518,  518,  518,  518,  521,    0,  518, 
          518,  518,  518,    0,  530,    0,    0,    0,  518,    0, 
            0,    0,    0,    0,    0,  518,    0,  518,  523,  518, 
          518,  518,  518,  518,  518,  518,    0,  518,  523,  518, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  520,  520, 
          520,  518,  101,    0,  520,  520,    0,  520,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  523,    0,  120, 
            0,  523,    0,    0,    0,    0,  520,  520,    0,  520, 
          520,  520,  520,  520,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  523, 
            0,    0,    0,  520,  520,  520,  520,  520,  520,  520, 
          520,  520,  520,  520,  520,  520,  520,  522,    0,  520, 
          520,  520,  520,    0,  532,    0,    0,  522,  520,    0, 
            0,    0,    0,    0,    0,  520,    0,  520,    0,  520, 
          520,  520,  520,  520,  520,  520,    0,  520,    0,  520, 
            0,    0,    0,    0,    0,    0,    0,    0,  521,  521, 
          521,  100,    0,    0,  521,  521,    0,  521,    0,    0, 
            0,    0,    0,    0,    0,    0,  522,    0,  119,    0, 
          522,  520,    0,    0,    0,    0,  521,  521,    0,  521, 
          521,  521,  521,  521,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  522,    0, 
            0,    0,    0,  521,  521,  521,  521,  521,  521,  521, 
          521,  521,  521,  521,  521,  521,  521,    0,    0,  521, 
          521,  521,  521,    0,  533,    0,    0,    0,  521,    0, 
            0,    0,    0,    0,    0,  521,    0,  521,    0,  521, 
          521,  521,  521,  521,  521,  521,  524,  521,    0,  521, 
            0,    0,    0,    0,    0,    0,  524,    0,    0,    0, 
          523,  523,  523,    0,    0,    0,  523,  523,    0,  523, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  521,    0,    0,    0,    0,    0,    0,  523,  523, 
          102,  523,  523,  523,  523,  523,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  524,    0,  121,    0,  524, 
            0,    0,    0,    0,    0,  523,  523,  523,  523,  523, 
          523,  523,  523,  523,  523,  523,  523,  523,  523,    0, 
            0,  523,  523,  523,  523,    0,  535,  524,    0,    0, 
          523,    0,    0,    0,    0,    0,    0,  523,    0,  523, 
          296,  523,  523,  523,  523,  523,  523,  523,    0,  523, 
          296,  523,    0,    0,    0,    0,    0,    0,    0,  522, 
          522,  522,    0,    0,    0,  522,  522,    0,  522,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  523,  289,    0,    0,  522,  522,    0, 
          522,  522,  522,  522,  522,    0,    0,    0,  515,  296, 
            0,    0,    0,    0,    0,    0,    0,    0,  515,    0, 
            0,    0,    0,    0,  522,  522,  522,  522,  522,  522, 
          522,  522,  522,  522,  522,  522,  522,  522,    0,    0, 
          522,  522,  522,  522,    0,  534,    0,    0,    0,  522, 
            0,    0,   93,    0,    0,    0,  522,    0,  522,    0, 
          522,  522,  522,  522,  522,  522,  522,  515,  522,  112, 
          522,  515,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  515, 
            0,    0,  522,    0,    0,    0,    0,    0,  524,  524, 
          524,    0,    0,    0,  524,  524,    0,  524,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  524,  524,    0,  524, 
          524,  524,  524,  524,    0,    0,    0,  514,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  514,    0,    0, 
            0,    0,    0,  524,  524,  524,  524,  524,  524,  524, 
          524,  524,  524,  524,  524,  524,  524,    0,    0,  524, 
          524,  524,  524,    0,  536,    0,    0,    0,  524,    0, 
            0,   92,    0,    0,    0,  524,    0,  524,    0,  524, 
          524,  524,  524,  524,  524,  524,  514,  524,  111,  524, 
          514,    0, 
      };
   }

   private static final short[] yyTable3() {
      return new short[] {

          296,  296,  296,    0,    0,  296,  296,  296,    0,  296, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  514,    0,    0,  524, 
            0,  296,  296,  296,  296,  296,    0,    0,    0,    0, 
            0,    0,    0,    0,  517,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  517,    0,    0,    0,  515,  515, 
          515,    0,    0,    0,  515,  515,    0,  515,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  296,    0,    0, 
          296,    0,    0,    0,    0,    0,  515,  515,   95,  515, 
          515,  515,  515,  515,    0,    0,    0,    0,    0,    0, 
            0,  296,    0,  517,    0,  114,    0,  517,    0,    0, 
            0,    0,    0,  515,  515,  515,  515,  515,  515,  515, 
          515,  515,  515,  515,  515,  515,  515,    0,    0,  515, 
          515,  515,  515,  296,  527,  517,    0,    0,  515,    0, 
            0,    0,    0,    0,    0,  515,    0,  515,    0,  515, 
          515,  515,  515,  515,  515,  515,  306,  515,    0,  515, 
            0,    0,    0,    0,    0,    0,  306,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  515,    0,    0,    0,    0,    0,  514,  514,  514, 
          109,    0,    0,  514,  514,    0,  514,    0,    0,    0, 
            0,    0,    0,    0,    0,  306,    0,  128,    0,  306, 
            0,    0,    0,    0,    0,  514,  514,    0,  514,  514, 
          514,  514,  514,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  306,    0,    0, 
            0,    0,  514,  514,  514,  514,  514,  514,  514,  514, 
          514,  514,  514,  514,  514,  514,  317,    0,  514,  514, 
          514,  514,    0,  526,    0,    0,  317,  514,    0,    0, 
            0,    0,    0,    0,  514,    0,  514,    0,  514,  514, 
          514,  514,  514,  514,  514,    0,  514,    0,  514,    0, 
            0,    0,    0,    0,    0,    0,  517,  517,  517,    0, 
          108,    0,  517,  517,    0,  517,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  317,    0,  127,    0,  317, 
          514,    0,    0,    0,  517,  517,    0,  517,  517,  517, 
          517,  517,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  317,    0,    0, 
            0,  517,  517,  517,  517,  517,  517,  517,  517,  517, 
          517,  517,  517,  517,  517,    0,    0,  517,  517,  517, 
          517,    0,  529,    0,    0,    0,  517,    0,    0,    0, 
            0,    0,    0,  517,    0,  517,  234,  517,  517,  517, 
          517,  517,  517,  517,    0,  517,  234,  517,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  306,  306, 
          306,    0,    0,    0,  306,  306,    0,  306,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  517, 
          234,    0,    0,    0,    0,    0,  306,  306,    0,  306, 
          306,  306,  306,  306,  234,  234,    0,    0,    0,  234, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  306,  306,  306,  306,  306,  306,  306, 
          306,  306,  306,  306,  306,  306,  306,    0,    0,  306, 
          306,  306,  306,    0,    0,    0,    0,    0,  306,    0, 
            0,    0,    0,    0,    0,  306,  235,  306,    0,  306, 
          306,  306,  306,  306,  306,  306,  235,  306,    0,  306, 
            0,    0,    0,    0,    0,    0,    0,    0,  317,  317, 
          317,    0,    0,    0,  317,  317,    0,  317,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          235,  306,    0,    0,    0,    0,  317,  317,    0,  317, 
          317,  317,  317,  317,  235,  235,    0,    0,    0,  235, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  317,  317,  317,  317,  317,  317,  317, 
          317,  317,  317,  317,  317,  317,  317,    0,    0,  317, 
          317,  317,  317,    0,    0,    0,    0,    0,  317,    0, 
            0,    0,    0,    0,    0,  317,    0,  317,    0,  317, 
          317,  317,  317,  317,  317,  317,    0,  317,    0,  317, 
            0,    0,    0,    0,    0,    0,  258,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  258,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  234,  234, 
          234,  317,    0,  234,  234,  234,    0,  234,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  234,  234,    0, 
          258,    0,    0,    0,    0,    0,  234,  234,    0,  234, 
          234,  234,  234,  234,  258,  258,    0,    0,    0,  258, 
            0,  234,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  234,  234,  234,  234,  234,  234, 
          234,  234,  234,  234,    0,  234,  234,    0,    0,  234, 
          234,    0,    0,    0,    0,  234,    0,    0,  234,    0, 
            0,  234,    0,  234,    0,    0,  259,  234,    0,    0, 
            0,  234,  234,  234,  234,  234,  259,  234,    0,  234, 
            0,    0,    0,    0,    0,    0,    0,    0,  235,  235, 
          235,  234,    0,  235,  235,  235,    0,  235,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  235,  235,    0, 
          259,  234,    0,    0,    0,    0,  235,  235,    0,  235, 
          235,  235,  235,  235,  259,  259,    0,    0,    0,  259, 
            0,  235,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  235,  235,  235,  235,  235,  235, 
          235,  235,  235,  235,    0,  235,  235,    0,    0,  235, 
          235,    0,    0,    0,    0,  235,    0,    0,  235,    0, 
            0,  235,    0,  235,    0,    0,    0,  235,    0,    0, 
            0,  235,  235,  235,  235,  235,    0,  235,    0,  235, 
            0,    0,    0,    0,    0,    0,  245,    0,    0,    0, 
            0,  235,    0,    0,    0,    0,  245,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  258,  258, 
          258,  235,    0,  258,  258,  258,    0,  258,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  258,  258,    0, 
          245,    0,    0,    0,    0,    0,  258,  258,    0,  258, 
          258,  258,  258,  258,  245,  245,    0,    0,    0,  245, 
            0,  258,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  258,  258,  258,  258,  258,  258, 
          258,  258,  258,  258,    0,  258,  258,    0,    0,  258, 
          258,    0,    0,    0,    0,  258,    0,    0,  258,    0, 
            0,  258,    0,  258,    0,    0,  243,  258,    0,    0, 
            0,    0,    0,  258,  258,  258,  243,  258,    0,  258, 
            0,    0,    0,    0,    0,    0,    0,    0,  259,  259, 
          259,  258,    0,  259,  259,  259,    0,  259,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  259,  259,    0, 
          243,  258,    0,    0,    0,    0,  259,  259,    0,  259, 
          259,  259,  259,  259,  243,  243,    0,    0,    0,  243, 
            0,  259,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  259,  259,  259,  259,  259,  259, 
          259,  259,  259,  259,    0,  259,  259,    0,    0,  259, 
          259,    0,    0,    0,    0,  259,    0,    0,  259,    0, 
            0,  259,    0,  259,    0,    0,    0,  259,    0,    0, 
            0,    0,  244,  259,  259,  259,    0,  259,    0,  259, 
            0,    0,  244,    0,    0,    0,    0,    0,    0,    0, 
            0,  259,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  245,  245, 
          245,  259,    0,  245,  245,  245,  244,  245,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  245,  245,    0, 
          244,  244,    0,    0,    0,  244,  245,  245,    0,  245, 
          245,  245,  245,  245,    0,    0,    0,    0,    0,    0, 
            0,  245,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  245,  245,  245,  245,  245,  245, 
          245,  245,  245,  245,    0,  245,  245,    0,    0,    0, 
            0,    0,    0,    0,    0,  245,    0,    0,  245,    0, 
            0,  245,    0,  245,    0,    0,    0,  245,    0,    0, 
            0,  248,    0,  245,  245,  245,    0,  245,    0,  245, 
            0,  248,    0,    0,    0,    0,    0,    0,  243,  243, 
          243,  245,    0,  243,  243,  243,    0,  243,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  243,  243,    0, 
            0,  245,    0,    0,    0,  248,  243,  243,    0,  243, 
          243,  243,  243,  243,    0,    0,    0,    0,    0,  248, 
          248,  243,    0,    0,  248,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  243,  243,  243,  243,  243,  243, 
          243,  243,  243,  243,    0,  243,  243,    0,    0,    0, 
            0,    0,    0,    0,    0,  243,    0,    0,  243,    0, 
            0,  243,    0,  243,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  243,  243,  243,  250,  243,    0,  243, 
            0,    0,    0,    0,    0,    0,  250,    0,    0,    0, 
            0,  243,    0,    0,  244,  244,  244,    0,    0,  244, 
          244,  244,    0,  244,    0,    0,    0,    0,    0,    0, 
            0,  243,    0,  244,  244,    0,    0,    0,    0,    0, 
          250,    0,  244,  244,    0,  244,  244,  244,  244,  244, 
            0,    0,    0,    0,  250,  250,    0,  244,    0,  250, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          244,  244,  244,  244,  244,  244,  244,  244,  244,  244, 
            0,  244,  244,    0,    0,    0,    0,    0,    0,    0, 
            0,  244,    0,    0,  244,    0,    0,  244,    0,  244, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  244, 
          244,  244,    0,  244,    0,  244,    0,    0,    0,    0, 
            0,  249,    0,    0,    0,    0,    0,  244,    0,    0, 
            0,  249,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  248,  248,  248,    0,  244,  248,  248, 
          248,    0,  248,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  248,  248,    0,  249,    0,    0,    0,    0, 
            0,  248,  248,    0,  248,  248,  248,  248,  248,  249, 
          249,    0,    0,    0,  249,    0,  248,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  248, 
          248,  248,  248,  248,  248,  248,  248,  248,  248,    0, 
          248,  248,    0,    0,    0,    0,    0,    0,    0,    0, 
          248,    0,    0,  248,    0,    0,  248,    0,  248,    0, 
            0,    0,    0,    0,    0,    0,  247,    0,  248,  248, 
            0,    0,    0,    0,  248,    0,  247,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  248,    0,  250,  250, 
          250,    0,    0,  250,  250,  250,    0,  250,    0,    0, 
            0,    0,    0,    0,    0,    0,  248,  250,  250,    0, 
          247,    0,    0,    0,    0,    0,  250,  250,    0,  250, 
          250,  250,  250,  250,  247,  247,    0,    0,    0,  247, 
            0,  250,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  250,  250,  250,  250,  250,  250, 
          250,  250,  250,  250,    0,  250,  250,    0,    0,    0, 
            0,    0,    0,    0,    0,  250,    0,    0,  250,    0, 
            0,  250,    0,  250,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  250,  250,    0,    0,    0,    0,  250, 
            0,    0,    0,    0,    0,  246,    0,    0,    0,    0, 
            0,  250,    0,    0,    0,  246,    0,    0,    0,    0, 
            0,    0,    0,  249,  249,  249,    0,    0,  249,  249, 
          249,  250,  249,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  249,  249,    0,    0,    0,    0,    0,  246, 
            0,  249,  249,    0,  249,  249,  249,  249,  249,    0, 
            0,    0,    0,  246,  246,    0,  249,    0,  246,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  249, 
          249,  249,  249,  249,  249,  249,  249,  249,  249,    0, 
          249,  249,    0,    0,    0,    0,    0,    0,    0,    0, 
          249,    0,  251,  249,    0,    0,  249,    0,  249,    0, 
            0,    0,  251,    0,    0,    0,    0,    0,  249,  249, 
            0,    0,    0,    0,  249,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  249,    0,  247,  247, 
          247,    0,    0,  247,  247,  247,  251,  247,    0,    0, 
            0,    0,    0,    0,    0,    0,  249,  247,  247,    0, 
          251,  251,    0,    0,    0,  251,  247,  247,    0,  247, 
          247,  247,  247,  247,    0,    0,    0,    0,    0,    0, 
            0,  247,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  247,  247,  247,  247,  247,  247, 
          247,  247,  247,  247,    0,  247,  247,    0,    0,    0, 
            0,    0,    0,    0,    0,  247,    0,    0,  247,  252, 
            0,  247,    0,  247,    0,    0,    0,    0,    0,  252, 
            0,    0,    0,  247,  247,    0,    0,    0,    0,  247, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  247,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  252,    0,    0,    0,  246,  246,  246, 
            0,  247,  246,  246,  246,    0,  246,  252,  252,    0, 
            0,    0,  252,    0,    0,    0,  246,  246,    0,    0, 
            0,    0,    0,    0,    0,  246,  246,    0,  246,  246, 
          246,  246,  246,    0,    0,    0,    0,    0,    0,    0, 
          246,    0,    0,    0,    0,    0,  253,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  253,    0,    0,  246, 
          246,    0,    0,    0,  246,  246,    0,    0,    0,    0, 
            0,    0,    0,    0,  246,    0,    0,  246,    0,    0, 
          246,    0,  246,    0,    0,    0,    0,    0,    0,    0, 
          253,    0,    0,    0,  251,  251,  251,    0,  246,  251, 
          251,  251,    0,  251,  253,  253,    0,    0,    0,  253, 
          246,    0,    0,  251,  251,    0,    0,    0,    0,    0, 
            0,    0,  251,  251,    0,  251,  251,  251,  251,  251, 
          246,    0,    0,    0,  260,    0,    0,  251,    0,    0, 
            0,    0,    0,    0,  260,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  251,  251,    0,    0, 
            0,  251,  251,    0,    0,    0,    0,    0,    0,    0, 
            0,  251,    0,    0,  251,    0,    0,  251,  260,  251, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  260,  260,    0,  251,    0,  260,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  251,    0,    0, 
            0,  252,  252,  252,    0,    0,  252,  252,  252,    0, 
          252,    0,  254,    0,    0,    0,    0,  251,    0,    0, 
          252,  252,  254,    0,    0,    0,    0,    0,    0,  252, 
          252,    0,  252,  252,  252,  252,  252,    0,    0,    0, 
            0,    0,    0,    0,  252,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  254,    0,    0,    0, 
            0,    0,    0,  252,  252,    0,    0,    0,  252,  252, 
          254,  254,    0,    0,    0,  254,    0,    0,  252,    0, 
            0,  252,    0,    0,  252,    0,  252,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  253,  253, 
          253,    0,  252,  253,  253,  253,    0,  253,    0,  255, 
            0,    0,    0,    0,  252,    0,    0,  253,  253,  255, 
            0,    0,    0,    0,    0,    0,  253,  253,    0,  253, 
          253,  253,  253,  253,  252,    0,    0,    0,    0,    0, 
            0,  253,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  255,    0,    0,    0,    0,    0,    0, 
          253,  253,    0,    0,    0,  253,  253,  255,  255,    0, 
            0,    0,  255,    0,    0,  253,    0,    0,  253,    0, 
            0,  253,    0,  253,    0,    0,  260,  260,  260,    0, 
            0,  260,  260,  260,    0,  260,    0,  261,    0,  253, 
            0,    0,    0,    0,    0,  260,  260,  261,    0,    0, 
            0,  253,    0,    0,  260,  260,    0,  260,  260,  260, 
          260,  260,    0,    0,    0,    0,    0,    0,    0,  260, 
            0,  253,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  261,    0,    0,    0,    0,    0,    0,  260,  260, 
            0,    0,    0,  260,  260,  261,  261,    0,    0,    0, 
          261,    0,    0,  260,    0,    0,  260,    0,    0,  260, 
            0,  260,    0,    0,  254,  254,  254,    0,    0,  254, 
          254,  254,    0,  254,    0,  232,    0,  260,    0,    0, 
            0,    0,    0,  254,  254,  232,    0,    0,    0,  260, 
            0,    0,  254,  254,    0,  254,  254,  254,  254,  254, 
            0,    0,    0,    0,    0,    0,    0,  254,    0,  260, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  232, 
            0,    0,    0,    0,    0,    0,  254,  254,    0,    0, 
            0,  254,  254,  232,  232,    0,    0,    0,  232,    0, 
            0,  254,    0,    0,  254,    0,    0,  254,    0,  254, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  255,  255,  255,    0,  254,  255,  255,  255,    0, 
          255,    0,  233,    0,    0,    0,    0,  254,    0,    0, 
          255,  255,  233,    0,    0,    0,    0,    0,    0,  255, 
          255,    0,  255,  255,  255,  255,  255,  254,    0,    0, 
            0,    0,    0,    0,  255,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  233,    0,    0,    0, 
            0,    0,    0,  255,  255,    0,    0,    0,  255,  255, 
          233,  233,    0,    0,    0,  233,    0,    0,  255,    0, 
            0,  255,    0,    0,  255,    0,  255,    0,    0,  261, 
          261,  261,    0,    0,  261,  261,  261,    0,  261,    0, 
          231,    0,  255,    0,    0,    0,    0,    0,  261,  261, 
          231,    0,    0,    0,  255,    0,    0,  261,  261,    0, 
          261,  261,  261,  261,  261,    0,    0,    0,    0,    0, 
            0,    0,  261,    0,  255,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  231,    0,    0,    0,    0,    0, 
            0,    0,  261,    0,    0,    0,  261,  261,  231,  231, 
            0,    0,    0,    0,    0,    0,  261,    0,    0,  261, 
            0,    0,  261,    0,  261,    0,    0,  232,  232,  232, 
            0,    0,  232,  232,  232,    0,  232,    0,  230,    0, 
          261,    0,    0,    0,    0,    0,  232,  232,  230,    0, 
            0,    0,  261,    0,    0,  232,  232,    0,  232,  232, 
          232,  232,  232,    0,    0,    0,    0,    0,    0,    0, 
          232,    0,  261,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  230,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  230,  230,    0,    0, 
            0,    0,    0,    0,  232,    0,    0,  232,    0,    0, 
          232,    0,  232,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  233,  233,  233,  228,  232,  233, 
          233,  233,    0,  233,    0,    0,    0,  228,    0,    0, 
          232,    0,    0,  233,  233,    0,    0,    0,    0,    0, 
            0,    0,  233,  233,    0,  233,  233,  233,  233,  233, 
          232,    0,    0,    0,    0,    0,    0,  233,    0,    0, 
            0,  228,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  228,  228,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  233,    0,    0,  233,    0,    0,  233,    0,  233, 
            0,    0,  231,  231,  231,    0,  229,  231,  231,  231, 
            0,  231,    0,    0,    0,  233,  229,    0,    0,    0, 
            0,  231,  231,    0,    0,    0,    0,  233,    0,    0, 
          231,  231,    0,  231,  231,  231,  231,  231,    0,    0, 
            0,    0,    0,    0,    0,  231,    0,  233,    0,    0, 
          229,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  229,  229,    0,    0,  226,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  226,  231, 
            0,    0,  231,    0,    0,  231,    0,  231,    0,    0, 
          230,  230,  230,    0,    0,  230,  230,  230,    0,  230, 
            0,    0,    0,  231,    0,    0,    0,    0,    0,  230, 
          230,    0,  226,    0,    0,  231,    0,    0,  230,  230, 
            0,  230,  230,  230,  230,  230,  226,  226,    0,    0, 
            0,    0,    0,  230,    0,  231,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  230,    0,    0, 
          230,    0,    0,  230,    0,  230,    0,  227,    0,  228, 
          228,  228,    0,    0,  228,  228,  228,  227,  228,    0, 
            0,  230,    0,    0,    0,    0,    0,    0,  228,  228, 
            0,    0,    0,  230,    0,    0,    0,  228,  228,    0, 
          228,  228,  228,  228,  228,    0,    0,    0,    0,    0, 
            0,  227,  228,  230,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  227,  227,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  228,    0,    0,  228, 
            0,    0,  228,    0,  228,    0,  222,    0,  229,  229, 
          229,    0,    0,  229,  229,  229,  222,  229,    0,    0, 
          228,    0,    0,    0,    0,    0,    0,  229,  229,    0, 
            0,    0,  228,    0,    0,    0,  229,  229,    0,  229, 
          229,  229,  229,  229,    0,    0,    0,    0,    0,    0, 
          222,  229,  228,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  222,  222,    0,    0,  224,    0, 
          226,  226,  226,    0,    0,  226,  226,  226,  224,  226, 
            0,    0,    0,    0,    0,  229,    0,    0,  229,  226, 
          226,  229,    0,  229,    0,    0,    0,    0,  226,  226, 
            0,  226,  226,  226,  226,  226,    0,    0,    0,  229, 
            0,    0,  224,  226,    0,    0,    0,    0,    0,    0, 
            0,  229,    0,    0,    0,    0,  224,  224,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  229,    0,    0,    0,    0,    0,  226,    0,    0, 
          226,    0,    0,  226,    0,  226,    0,  263,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  263,    0,    0, 
            0,  226,    0,    0,    0,    0,    0,    0,    0,  227, 
          227,  227,    0,  226,  227,  227,  227,    0,  227,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  227,  227, 
            0,  263,    0,  226,    0,    0,    0,  227,  227,    0, 
          227,  227,  227,  227,  227,  263,  263,    0,    0,    0, 
            0,    0,  227,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  227,    0,    0,  227, 
            0,    0,  227,    0,  227,    0,  225,    0,  222,  222, 
          222,    0,    0,  222,  222,  222,  225,  222,    0,    0, 
          227,    0,    0,    0,    0,    0,    0,  222,  222,    0, 
            0,    0,  227,    0,    0,    0,  222,  222,    0,  222, 
          222,  222,  222,  222,    0,    0,    0,    0,    0,    0, 
          225,  222,  227,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  225,  225,    0,    0,  265,    0, 
          224,  224,  224,    0,    0,  224,  224,  224,  265,  224, 
            0,    0,    0,    0,    0,  222,    0,    0,  222,  224, 
          224,  222,    0,  222,    0,    0,    0,    0,  224,  224, 
            0,  224,  224,  224,  224,  224,    0,    0,    0,  222, 
            0,    0,  265,  224,    0,    0,    0,    0,    0,    0, 
            0,  222,    0,    0,    0,    0,    0,  265,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  222,    0,    0,    0,    0,    0,  224,    0,    0, 
          224,    0,    0,  224,    0,  224,    0,  223,    0,  263, 
          263,  263,    0,    0,  263,  263,  263,  223,  263,    0, 
            0,  224,    0,    0,    0,    0,    0,    0,  263,  263, 
            0,    0,    0,  224,    0,    0,    0,  263,  263,    0, 
          263,  263,  263,  263,  263,    0,    0,    0,    0,    0, 
            0,  223,  263,  224,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  223,  223,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  263,    0,    0,  263, 
            0,    0,  263,    0,  263,    0,  221,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  221,    0,    0,    0, 
          263,    0,    0,    0,    0,    0,    0,    0,  225,  225, 
          225,    0,  263,  225,  225,  225,    0,  225,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  225,  225,    0, 
          221,    0,  263,    0,    0,    0,  225,  225,    0,  225, 
          225,  225,  225,  225,  221,  221,    0,    0,  288,    0, 
            0,  225,    0,    0,    0,    0,    0,    0,  288,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          265,  265,  265,    0,    0,  265,  265,  265,    0,  265, 
            0,    0,    0,    0,    0,  225,    0,    0,  225,  265, 
          265,  225,  288,  225,    0,    0,    0,    0,  265,  265, 
            0,  265,  265,  265,  265,  265,    0,  288,    0,  225, 
            0,    0,    0,  265,    0,    0,    0,    0,    0,    0, 
            0,  225,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  290,    0,    0,    0, 
            0,  225,    0,    0,    0,    0,  290,  265,    0,    0, 
          265,    0,    0,  265,    0,  265,    0,    0,    0,  223, 
          223,  223,    0,    0,  223,  223,  223,    0,  223,    0, 
            0,  265,    0,    0,    0,    0,    0,    0,  223,  223, 
          290,    0,    0,  265,    0,    0,    0,  223,  223,    0, 
          223,  223,  223,  223,    0,  290,    0,    0,    0,    0, 
            0,    0,  223,  265,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  644,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  644,    0,  223,    0,    0,  223, 
            0,    0,  223,    0,  223,    0,    0,    0,  221,  221, 
          221,    0,    0,  221,  221,  221,    0,  221,    0,    0, 
          223,   60,    0,    0,    0,    0,    0,  221,  221,    0, 
            0,   60,  223,    0,    0,    0,  221,  221,    0,  221, 
          221,  221,  221,  644,    0,    0,    0,    0,    0,    0, 
            0,  221,  223,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          288,  288,  288,    0,    0,  288,  288,  288,    0,  288, 
           60,    0,    0,    0,    0,  221,    0,    0,  221,  288, 
          288,  221,    0,  221,    0,    0,    0,    0,  288,  288, 
            0,  288,  288,  288,  288,  288,    0,   64,    0,  221, 
            0,    0,    0,    0,    0,    0,    0,   64,    0,    0, 
            0,  221,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  221,    0,    0,    0,    0,   62,    0,    0,    0, 
          288,    0,    0,  288,    0,  288,   62,    0,  290,  290, 
          290,    0,  294,  290,  290,  290,   64,  290,    0,    0, 
            0,  288,  294,    0,    0,    0,    0,  290,  290,    0, 
            0,    0,    0,    0,    0,    0,  290,  290,    0,  290, 
          290,  290,  290,  290,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  288,    0,   62,  290,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  294,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  290,    0, 
            0,  290,    0,  290,    0,    0,  644,  644,  644,    0, 
          295,  644,  644,  644,    0,  644,    0,    0,    0,  290, 
          295,    0,    0,    0,    0,  644,  644,    0,    0,    0, 
            0,    0,    0,    0,  644,  644,    0,  644,  644,  644, 
          644,  644,    0,   60,   60,   60,    0,   52,   60,   60, 
           60,  290,   60,    0,  291,    0,    0,   52,    0,    0, 
            0,    0,   60,   60,    0,    0,    0,    0,    0,  295, 
            0,   60,   60,    0,   60,   60,   60,   60,   60,    0, 
            0,    0,    0,    0,    0,    0,  644,    0,    0,  644, 
            0,  644,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   52,  644,  221,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  221,    0, 
            0,    0,    0,   60,    0,    0,   60,    0,    0,   64, 
           64,   64,    0,    0,   64,   64,   64,    0,   64,  644, 
            0,    0,    0,    0,   60,    0,    0,    0,   64,   64, 
            0,    0,  265,    0,    0,    0,    0,   64,   64,    0, 
           64,   64,   64,   64,   64,    0,    0,  221,   62,   62, 
           62,    0,    0,   62,   62,   62,   60,   62,    0,    0, 
            0,  307,    0,    0,  294,  294,  294,   62,   62,  294, 
          294,  294,    0,  294,    0,    0,   62,   62,    0,   62, 
           62,   62,   62,   62,    0,    0,    0,    0,    0,   64, 
            0,    0,   64,    0,    0,  294,  294,  294,  294,  294, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           64,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   62,    0, 
            0,   62,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  294,   64,    0,  294,    0,    0,    0,    0,   62, 
            0,    0,  295,  295,  295,    0,    0,  295,  295,  295, 
            0,  295,    0,    0,    0,  294,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   62,    0,  295,  295,  295,  295,  295,    0,   52, 
           52,   52,    0,    0,   52,   52,   52,  294,   52,    0, 
            0,    0,    0,    0,    0,  129,    0,    0,   52,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           52,   52,   52,   52,   52,    0,    0,    0,    0,  295, 
            0,    0,  295,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          221,  221,  221,  295,  129,    0,  221,  221,    0,  221, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   52, 
            0,    0,    0,    0,    0,    0,    0,    0,  221,  221, 
            0,  221,  221,  221,  221,  295,  513,    0,    0,    0, 
           52,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,   52,   12,   13,   14,   15,   16,   17,   18, 
          221,    0,    0,    0,   19,   20,   21,  238,  239,  240, 
          241,    0,    0,  117,    0,    0,    0,    0,    0,    0, 
           28,  221,    0,  242,  243,  244,  130,  245,   35,  246, 
          247,  248,  249,  284,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  221,    0,    0,    0,    0,  250,    0, 
            0,  130,    0,    0,   46,   47,    0,   48,    0,  285, 
            0,  286,    0,   50,    0,  130,    0,    0,    0,    0, 
            0,  287,    0,    0,    0,    0,   52,  288,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,   63,   64,    0,    0,    0,  516,    0,    0, 
            0,    0,    0,   65,   66,  289,    0,    0,    0,    0, 
            0,  129,  129,  129,  129,  129,  129,  129,  129,  129, 
          129,  129,    0,    0,  129,  129,    0,  129,  129,  129, 
          129,  129,  129,  129,    0,  614,    0,    0,  129,  129, 
          129,  129,  129,  129,  129,    0,    0,  129,    0,    0, 
            0,    0,    0,  129,  129,    0,  129,  129,  129,  129, 
          129,  129,  129,  129,  129,  129,  129,    0,  129,  129, 
          129,  129,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  513,    0,    0,    0,    0,    0,    0, 
          513,  513,  129,    0,    0,  129,  614,    0,  129,  129, 
            0,  129,    0,  129,    0,    0,    0,  129,    0,  129, 
            0,    0,  129,    0,    0,  129,    0,  614,    0,    0, 
          129,  129,  129,  129,  129,  129,    0,    0,    0,  129, 
            0,  129,  129,    0,  129,  129,  129,  129,    0,    0, 
            0,  621,    0,    0,    0,    0,    0,  129,  129,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  130,  130,  130,  130,  130,  130,  130,  130, 
          130,  130,  130,    0,    0,  130,  130,    0,  130,  130, 
          130,  130,  130,  130,  130,    0,  615,    0,    0,  130, 
          130,  130,  130,  130,  130,  130,    0,    0,  130,    0, 
            0,    0,    0,    0,  130,  130,    0,  130,  130,  130, 
          130,  130,  130,  130,  130,  130,  130,  130,    0,  130, 
          130,  130,  130,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  516,    0,    0,    0,    0,    0, 
            0,  516,  516,  130,    0,    0,  130,  615,    0,  130, 
          130,    0,  130,    0,  130,    0,    0,    0,  130,    0, 
          130,    0,    0,  130,    0,    0,  130,    0,  615,    0, 
            0,  130,  130,  130,  130,  130,  130,    0,    0,    0, 
          130,    0,  130,  130,    0,  130,  130,  130,  130,    0, 
            0,    0,  316,    0,    0,    0,    0,    0,  130,  130, 
            0,    0,    0,    0,    0,    0,  129,  129,  129,  129, 
          129,  129,  129,  129,  129,  129,  129,    0,    0,  129, 
          129,    0,  129,  129,  129,  129,  129,  129,  129,    0, 
          621,    0,    0,  129,  129,  129,  129,  129,  129,  129, 
            0,    0,  129,    0,    0,    0,    0,    0,  129,  129, 
            0,  129,  129,  129,  129,  130,  129,  129,  129,  129, 
          129,  129,    0,  129,  129,  129,  129,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  621,    0, 
            0,    0,    0,    0,    0,  621,  621,  129,    0,    0, 
          129,  617,    0,  129,  129,    0,  129,    0,  129,    0, 
            0,    0,  129,    0,  130,    0,    0,  129,    0,    0, 
          129,    0,  621,    0,    0,  129,  129,  129,  129,  129, 
          129,    0,    0,    0,  129,    0,  129,  129,    0,  129, 
          129,  129,  129,    0,    0,    0,  317,    0,    0,    0, 
            0,    0,  129,  129,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  130,  130,  130, 
          130,  130,  130,  130,  130,  130,  130,  130,    0,    0, 
          130,  130,    0,  130,  130,  130,  130,  130,  130,  130, 
            0,    0,    0,    0,  130,  130,  130,  130,  130,  130, 
          130,    0,    0,  130,  361,    0,    0,    0,    0,  130, 
          130,    0,  130,  130,  130,  130,    0,  130,  130,  130, 
          130,  130,  130,    0,  130,  130,  130,  130,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  316, 
            0,    0,    0,    0,    0,    0,  316,  316,  130,    0, 
            0,  130,  618,  361,  130,  130,    0,  130,    0,  130, 
            0,    0,    0,  130,    0,    0,    0,    0,  130,    0, 
            0,  130,    0,    0,    0,    0,  130,  130,  130,  130, 
          130,  130,    0,    0,    0,  130,    0,  130,  130,    0, 
          130,  130,  130,  130,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  130,  130,    0,    0,    0,    0,    0, 
            0,  130,  130,  130,  130,  130,  130,  130,  130,  130, 
          130,  130,    0,    0,  130,  130,    0,  130,  130,  130, 
          130,  130,  130,  130,    0,    0,    0,    0,  130,  130, 
          130,  130,  130,  130,  130,  308,    0,  130,    0,    0, 
            0,    0,    0,  130,  130,    0,  130,  130,  130,  130, 
            0,  130,  130,  130,  130,  130,  130,    0,  130,  130, 
          130,  130,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  317,    0,    0,    0,    0,    0,    0, 
          317,  317,  130,    0,  308,  130,    0,    0,  130,  130, 
            0,  130,    0,  130,    0,    0,    0,  130,    0,    0, 
            0,    0,  130,    0,    0,  130,    0,    0,    0,    0, 
          130,  130,  130,  130,  130,  130,    0,    0,    0,  130, 
            0,  130,  130,    0,  130,  130,  130,  130,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  130,  130,    0, 
          361,  361,  361,  361,  361,  361,  361,  361,  361,  361, 
          361,    0,  361,  361,  361,  361,  361,  361,  361,  361, 
          361,  361,  361,    0,    0,    0,    0,  361,  361,  361, 
          361,  361,  361,  361,  541,    0,  361,    0,    0,    0, 
            0,    0,  361,  361,    0,  361,  361,  361,  361,    0, 
          361,  361,  361,  361,  361,  361,    0,  361,  361,  361, 
          361,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  361,    0,  541,  361,    0,    0,  361,  361,    0, 
          361,    0,  361,    0,    0,    0,  361,    0,    0,    0, 
            0,    0,    0,    0,  361,    0,    0,    0,    0,  361, 
          361,  361,  361,  361,  361,    0,    0,    0,  361,    0, 
          361,  361,    0,  361,  361,  361,  361,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  361,  361,    0,    0, 
            0,  308,  308,  308,  308,  308,  308,  308,  308,  308, 
          308,  308,    0,    0,  308,  308,    0,  308,  308,  308, 
          308,  308,  308,  308,  643,    0,    0,    0,  308,  308, 
          308,  308,  308,  308,  308,    0,    0,  308,    0,    0, 
            0,    0,    0,  308,  308,    0,  308,  308,  308,  308, 
            0,  308,  308,  308,  308,  308,  308,    0,  308,  308, 
          308,  308,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  643,    0,    0,    0,    0,    0,    0, 
            0,    0,  308,    0,    0,  308,    0,    0,  308,  308, 
            0,  308,    0,  308,    0,    0,    0,  308,    0,    0, 
            0,    0,    0,    0,    0,  308,    0,   18,    0,    0, 
          308,  308,  308,  308,  308,  308,    0,    0,    0,  308, 
            0,  308,  308,    0,  308,  308,  308,  308,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  308,  308,    0, 
          541,  541,  541,  541,  541,  541,  541,  541,  541,  541, 
          541,    0,    0,  541,  541,    0,  541,  541,  541,  541, 
          541,  541,  541,  643,    0,    0,    0,  541,  541,  541, 
          541,  541,  541,  541,    0,    0,  541,    0,    0,    0, 
            0,    0,  541,  541,    0,  541,  541,  541,  541,    0, 
          541,  541,  541,  541,  541,  541,    0,  541,  541,  541, 
          541,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  643,    0,    0,    0,    0,    0,    0,    0, 
            0,  541,    0,    0,  541,    0,    0,  541,  541,    0, 
          541,    0,  541,    0,    0,    0,  541,    0,    0,    0, 
            0,    0,    0,    0,  541,    0,    0,    0,    0,  541, 
          541,  541,  541,  541,  541,    0,    0,    0,  541,    0, 
          541,  541,    0,  541,  541,  541,  541,    0,    0,    0, 
          643,  643,  643,  643,  643,  643,  541,  541,  643,  643, 
          643,    0,    0,    0,  643,    0,  643,  643,  643,  643, 
          643,  643,  643,  259,    0,    0,    0,  643,  643,  643, 
          643,  643,  643,  643,    0,    0,  643,    0,    0,    0, 
            0,    0,  643,  643,    0,  643,  643,  643,  643,    0, 
          643,  643,  643,  643,  643,  643,    0,  643,  643,  643, 
          643,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  258,    0,    0,    0,    0,    0,    0,    0, 
            0,  643,    0,    0,  643,    0,    0,  643,  643,    0, 
          643,    0,  643,    0,    0,    0,  643,    0,    0,    0, 
            0,    0,    0,    0,  643,    0,    0,    0,    0,  643, 
          643,  643,  643,  643,  643,    0,    0,    0,  643,    0, 
          643,  643, 
      };
   }

   private static final short[] yyTable4() {
      return new short[] {

            0,  643,  643,  643,  643,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  643,  643,    0,  643,  643,  643, 
          643,  643,  643,    0,    0,    0,  643,  643,    0,    0, 
          310,  643,    0,  643,  643,  643,  643,  643,  643,  643, 
            0,    0,    0,    0,  643,  643,  643,  643,  643,  643, 
          643,    0,    0,  643,    0,    0,    0,    0,    0,  643, 
          643,    0,  643,  643,  643,  643,    0,  643,  643,  643, 
          643,  643,  643,    0,  643,  643,  643,  643,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  643,    0, 
            0,  643,    0,    0,  643,  643,    0,  643,    0,  643, 
            0,    0,    0,  643,    0,    0,    0,    0,    0,    0, 
            0,  643,    0,    0,  643,    0,  643,  643,  643,  643, 
          643,  643,    0,    0,    0,  643,    0,  643,  643,    0, 
          643,  643,  643,  643,    0,    0,    0,    0,    4,    5, 
            6,    0,    8,  643,  643,    0,    9,   10,    0,  307, 
            0,   11,    0,   12,   13,   14,   15,   16,   17,   18, 
            0,    0,    0,    0,   19,   20,   21,  238,  239,  240, 
          241,    0,    0,   26,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,  242,  243,  244,    0,  245,   35,  246, 
          247,  248,  249,    0,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  250,    0, 
            0,  130,    0,    0,   46,   47,    0,   48,    0,    0, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,   51,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,   63,   64,    0,    0,    0,  312,  312,  312, 
            0,  312,    0,   65,   66,  312,  312,    0,    0,    0, 
          312,    0,  312,  312,  312,  312,  312,  312,  312,    0, 
            0,    0,    0,  312,  312,  312,  312,  312,  312,  312, 
            0,    0,  312,    0,    0,    0,    0,    0,    0,  312, 
            0,    0,  312,  312,  312,    0,  312,  312,  312,  312, 
          312,  312,    0,  312,  312,  312,  312,  472,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  312,    0,    0, 
          312,    0,  310,  312,  312,    0,  312,    0,    0,    0, 
            0,    0,  312,    0,    0,    0,    0,    0,    0,    0, 
          312,    0,    0,    0,    0,  312,  312,  312,  312,  312, 
          312,    0,    0,    0,  312,    0,  312,  312,    0,  312, 
          312,  312,  312,    0,    0,    0,    4,    5,    6,    0, 
            8,    0,  312,  312,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   15,   16,   17,   18,    0,    0, 
            0,    0,   19,   20,   21,  238,  239,  240,  241,    0, 
            0,   26,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,  242,  243,  244,    0,  245,   35,  246,  247,  248, 
          249,    0,   40,   41,   42,   43,  472,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  250,    0,    0,  130, 
            0,    0,   46,   47,    0,   48,    0,    0,    0,    0, 
            0,   50,    0,    0,    0,    0,    0,    0,    0,   51, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
           63,   64,    0,    0,    0,    4,    5,    6,    7,    8, 
            0,   65,   66,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   15,   16,   17,   18,  414,    0,    0, 
            0,   19,   20,   21,   22,   23,   24,   25,    0,    0, 
           26,    0,    0,    0,    0,    0,   27,   28,   29,   30, 
           31,   32,   33,    0,   34,   35,   36,   37,   38,   39, 
            0,   40,   41,   42,   43,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   44,    0,    0,   45,    0, 
            0,   46,   47,    0,   48,    0,   49,    0,    0,    0, 
           50,    0,    0,    0,    0,    0,    0,    0,   51,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,   63, 
           64,    0,    0,    0,    4,    5,    6,    7,  320,    0, 
           65,   66,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   15,   16,   17,   18,    0,    0,    0,    0, 
           19,   20,   21,   22,   23,   24,   25,    0,    0,   26, 
            0,    0,    0,    0,    0,   27,   28,    0,   30,   31, 
           32,   33,    0,   34,   35,   36,   37,   38,   39,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   44,    0,    0,   45,    0,    0, 
           46,   47,    0,   48,    0,   49,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,   51,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,  808,    0,    0,    0,    0,    0,    0,    0,   65, 
           66,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  389,  390,  391,  392,  393,  394,  395,  396,  397, 
          398,  399,    0,  400,  401,    0,    0,  402,  403,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  404,    0,  405,    0,  406,  407,  408, 
          409,  410,  411,  412,    0,  413,    3,    4,    5,    6, 
            7,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   15,   16,   17,   18,    0, 
            0,    0,    0,   19,   20,   21,   22,   23,   24,   25, 
            0,    0,   26,    0,    0,    0,    0,    0,   27,   28, 
           29,   30,   31,   32,   33,    0,   34,   35,   36,   37, 
           38,   39,    0,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   44,    0,    0, 
           45,    0,    0,   46,   47,    0,   48,    0,   49,    0, 
            0,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
           51,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,   63,   64,    0,    0,  319,    4,    5,    6,    7, 
          320,    0,   65,   66,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   15,   16,   17,   18,    0,    0, 
            0,    0,   19,   20,   21,   22,   23,   24,   25,    0, 
            0,   26,    0,    0,    0,    0,    0,   27,   28,    0, 
           30,   31,   32,   33,    0,   34,   35,   36,   37,   38, 
           39,    0,   40,   41,   42,   43,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   44,    0,    0,  321, 
            0,    0,   46,   47,    0,   48,    0,   49,    0,    0, 
            0,   50,    0,    0,    0,    0,    0,    0,    0,   51, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
           63,   64,    0,    0,  319,    4,    5,    6,    7,  320, 
            0,   65,   66,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   15,   16,   17,   18,    0,    0,    0, 
            0,   19,   20,   21,   22,   23,   24,   25,    0,    0, 
           26,    0,    0,    0,    0,    0,   27,   28,    0,   30, 
           31,   32,   33,    0,   34,   35,   36,   37,   38,   39, 
            0,   40,   41,   42,   43,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   44,    0,    0,   45,    0, 
            0,   46,   47,    0,   48,    0,   49,    0,    0,    0, 
           50,    0,    0,    0,    0,    0,    0,    0,   51,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,   63, 
           64,    0,    0,    0,    4,    5,    6,    0,    8,    0, 
           65,   66,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   15,   16,   17,   18,    0,    0,    0,    0, 
           19,   20,   21,  238,  239,  240,  241,    0,    0,  117, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,  242, 
          243,  244,    0,  245,   35,  246,  247,  248,  249,  284, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  250,    0,    0,  130,    0,    0, 
           46,   47,    0,   48,    0,  285,    0,  286,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,  287,    0,    0, 
            0,    0,   52,  288,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,    0,    0,    0,    4,    5,    6,    0,    8,   65, 
           66,  289,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  108,  109,   17,   18,    0,    0,    0,    0, 
          110,  111,  112,  238,  239,  240,  241,    0,    0,  117, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,  242, 
          243,  244,    0,  245,   35,  246,  247,  248,  249,  284, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  250,    0,    0,  130,    0,    0, 
           46,   47,    0,   48,    0,  714,    0,  286,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,  287,    0,    0, 
            0,    0,   52,  288,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,    0,    0,    0,  283,  283,  283,    0,  283,   65, 
           66,  289,  283,  283,    0,    0,    0,  283,    0,  283, 
          283,  283,  283,  283,  283,  283,    0,    0,    0,    0, 
          283,  283,  283,  283,  283,  283,  283,    0,    0,  283, 
            0,    0,    0,    0,    0,    0,  283,    0,    0,  283, 
          283,  283,    0,  283,  283,  283,  283,  283,  283,  283, 
          283,  283,  283,  283,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  283,    0,    0,  283,    0,    0, 
          283,  283,    0,  283,    0,  283,    0,  283,    0,  283, 
            0,    0,    0,    0,    0,    0,    0,  283,    0,    0, 
            0,    0,  283,  283,  283,  283,  283,  283,    0,    0, 
            0,  283,    0,  283,  283,    0,  283,  283,  283,  283, 
            0,    0,    0,    0,    4,    5,    6,    0,    8,  283, 
          283,  283,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  108,  109,   17,   18,    0,    0,    0,    0, 
          110,  111,  112,  238,  239,  240,  241,    0,    0,  117, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,  242, 
          243,  244,    0,  245,   35,  246,  247,  248,  249,  284, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  250,    0,    0,  130,    0,    0, 
           46,   47,    0,   48,    0,  285,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,  287,    0,    0, 
            0,    0,   52,  288,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,    0,    0,    0,    4,    5,    6,    0,    8,   65, 
           66,  289,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  108,  109,   17,   18,    0,    0,    0,    0, 
          110,  111,  112,  238,  239,  240,  241,    0,    0,  117, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,  242, 
          243,  244,    0,  245,   35,  246,  247,  248,  249,  284, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  250,    0,    0,  130,    0,    0, 
           46,   47,    0,   48,    0,    0,    0,  286,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,  287,    0,    0, 
            0,    0,   52,  288,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,    0,    0,    0,    4,    5,    6,    0,    8,   65, 
           66,  289,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  108,  109,   17,   18,    0,    0,    0,    0, 
          110,  111,  112,  238,  239,  240,  241,    0,    0,  117, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,  242, 
          243,  244,    0,  245,   35,  246,  247,  248,  249,  284, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  250,    0,    0,  130,    0,    0, 
           46,   47,    0,   48,    0,  714,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,  287,    0,    0, 
            0,    0,   52,  288,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,    0,    0,    0,    4,    5,    6,    0,    8,   65, 
           66,  289,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  108,  109,   17,   18,    0,    0,    0,    0, 
          110,  111,  112,  238,  239,  240,  241,    0,    0,  117, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,  242, 
          243,  244,    0,  245,   35,  246,  247,  248,  249,  284, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  250,    0,    0,  130,    0,    0, 
           46,   47,    0,   48,    0,    0,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,  287,    0,    0, 
            0,    0,   52,  288,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,    0,    0,    0,    4,    5,    6,    7,    8,   65, 
           66,  289,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   15,   16,   17,   18,    0,    0,    0,    0, 
           19,   20,   21,   22,   23,   24,   25,    0,    0,   26, 
            0,    0,    0,    0,    0,   27,   28,   29,   30,   31, 
           32,   33,    0,   34,   35,   36,   37,   38,   39,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   44,    0,    0,   45,    0,    0, 
           46,   47,    0,   48,    0,   49,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,   51,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,    0,    0,    4,    5,    6,    7,    8,    0,   65, 
           66,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   15,   16,   17,   18,    0,    0,    0,    0,   19, 
           20,   21,   22,   23,   24,   25,    0,    0,   26,    0, 
            0,    0,    0,    0,   27,   28,    0,   30,   31,   32, 
           33,    0,   34,   35,   36,   37,   38,   39,    0,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   44,    0,    0,   45,    0,    0,   46, 
           47,    0,   48,    0,   49,    0,    0,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,   51,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,   63,   64,    0, 
            0,    0,    4,    5,    6,    0,    8,    0,   65,   66, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
          108,  109,   17,   18,    0,    0,    0,    0,  110,  111, 
          112,  238,  239,  240,  241,    0,    0,  117,    0,    0, 
            0,    0,    0,    0,   28,    0,    0,  242,  243,  244, 
            0,  245,   35,  246,  247,  248,  249,    0,   40,   41, 
           42,   43,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  250,    0,    0,  130,  507,    0,   46,   47, 
            0,   48,    0,    0,    0,    0,    0,   50,    0,    0, 
            0,    0,    0,    0,    0,  287,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,   63,   64,    0,    0, 
            0,    4,    5,    6,    0,    8,    0,   65,   66,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,   15, 
           16,   17,   18,    0,    0,    0,    0,   19,   20,   21, 
          238,  239,  240,  241,    0,    0,  117,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,  242,  243,  244,    0, 
          245,   35,  246,  247,  248,  249,    0,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  250,    0,    0,  130,    0,    0,   46,   47,    0, 
           48,    0,  649,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,  287,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,    0,    0, 
            4,    5,    6,    0,    8,    0,   65,   66,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  108,  109, 
           17,   18,    0,    0,    0,    0,  110,  111,  112,  238, 
          239,  240,  241,    0,    0,  117,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,  242,  243,  244,    0,  245, 
           35,  246,  247,  248,  249,    0,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          250,    0,    0,  130,    0,    0,   46,   47,    0,   48, 
            0,  285,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  287,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,    0,    0,    4, 
            5,    6,    0,    8,    0,   65,   66,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,  108,  109,   17, 
           18,    0,    0,    0,    0,  110,  111,  112,  238,  239, 
          240,  241,    0,    0,  117,    0,    0,    0,    0,    0, 
            0,   28,    0,    0,  242,  243,  244,    0,  245,   35, 
          246,  247,  248,  249,    0,   40,   41,   42,   43,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  250, 
            0,    0,  130,    0,    0,   46,   47,    0,   48,    0, 
          649,    0,    0,    0,   50,    0,    0,    0,    0,    0, 
            0,    0,  287,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,   63,   64,    0,    0,    0,    4,    5, 
            6,    0,    8,    0,   65,   66,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,  108,  109,   17,   18, 
            0,    0,    0,    0,  110,  111,  112,  238,  239,  240, 
          241,    0,    0,  117,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,  242,  243,  244,    0,  245,   35,  246, 
          247,  248,  249,    0,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  250,    0, 
            0,  130,    0,    0,   46,   47,    0,   48,    0,  917, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,  287,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,   63,   64,    0,    0,    0,    4,    5,    6, 
            0,    8,    0,   65,   66,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,  108,  109,   17,   18,    0, 
            0,    0,    0,  110,  111,  112,  238,  239,  240,  241, 
            0,    0,  117,    0,    0,    0,    0,    0,    0,   28, 
            0,    0,  242,  243,  244,    0,  245,   35,  246,  247, 
          248,  249,    0,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  250,    0,    0, 
          130,    0,    0,   46,   47,    0,   48,    0,  714,    0, 
            0,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
          287,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,   63,   64,    0,    0,    0,  632,  632,  632,    0, 
          632,    0,   65,   66,  632,  632,    0,    0,    0,  632, 
            0,  632,  632,  632,  632,  632,  632,  632,    0,    0, 
            0,    0,  632,  632,  632,  632,  632,  632,  632,    0, 
            0,  632,    0,    0,    0,    0,    0,    0,  632,    0, 
            0,  632,  632,  632,    0,  632,  632,  632,  632,  632, 
          632,    0,  632,  632,  632,  632,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  632,    0,    0,  632, 
          632,    0,  632,  632,    0,  632,    0,    0,    0,    0, 
            0,  632,    0,    0,    0,    0,    0,    0,    0,  632, 
            0,    0,    0,    0,  632,  632,  632,  632,  632,  632, 
            0,    0,    0,  632,    0,  632,  632,    0,  632,  632, 
          632,  632,    0,    0,    0,    4,    5,    6,    0,    8, 
            0,  632,  632,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,   15,   16,   17,   18,    0,    0,    0, 
            0,   19,   20,   21,  238,  239,  240,  241,    0,    0, 
           26,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
          242,  243,  244,    0,  245,   35,  246,  247,  248,  249, 
            0,   40,   41,   42,   43,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  250,    0,    0,  130,    0, 
            0,   46,   47,    0,   48,    0,    0,    0,    0,    0, 
           50,    0,    0,    0,    0,    0,    0,    0,   51,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,   63, 
           64,    0,    0,    0,    4,    5,    6,    0,    8,    0, 
           65,   66,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  108,  109,   17,   18,    0,    0,    0,    0, 
          110,  111,  112,  238,  239,  240,  241,    0,    0,  117, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,  242, 
          243,  244,    0,  245,   35,  246,  247,  248,  249,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  250,    0,    0,  130,    0,    0, 
           46,   47,    0,   48,    0,    0,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,  287,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,   63,   64, 
            0,    0,    0,    4,    5,    6,    0,    8,    0,   65, 
           66,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   15,   16,   17,   18,    0,    0,    0,    0,   19, 
           20,   21,  238,  239,  240,  241,    0,    0,  117,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,  242,  243, 
          244,    0,  245,   35,  246,  247,  248,  249,    0,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  250,    0,    0,  130,    0,    0,   46, 
           47,    0,   48,    0,    0,    0,    0,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,  287,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,   63,   64,    0, 
            0,    0,  632,  632,  632,    0,  632,    0,   65,   66, 
          632,  632,    0,    0,    0,  632,    0,  632,  632,  632, 
          632,  632,  632,  632,    0,    0,    0,    0,  632,  632, 
          632,  632,  632,  632,  632,    0,    0,  632,    0,    0, 
            0,    0,    0,    0,  632,    0,    0,  632,  632,  632, 
            0,  632,  632,  632,  632,  632,  632,    0,  632,  632, 
          632,  632,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  632,    0,    0,  632,    0,    0,  632,  632, 
            0,  632,    0,    0,    0,    0,    0,  632,    0,    0, 
            0,    0,    0,    0,    0,  632,    0,    0,    0,    0, 
          632,  632,  632,  632,  632,  632,    0,    0,    0,  632, 
            0,  632,  632,    0,  632,  632,  632,  632,    0,    0, 
            0,    4,    5,    6,    0,    8,    0,  632,  632,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,  108, 
          109,   17,   18,    0,    0,    0,    0,  110,  111,  112, 
          113,  114,  115,  116,    0,    0,  117,    0,    0,    0, 
            0,    0,    0,  118,    0,    0,  119,  120,  121,    0, 
          122,   35,  123,  124,  125,  126,    0,   40,    0,    0, 
          127,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  128,    0,    0, 
            0,  129,    0,    0,  130,    0,    0,   46,   47,    0, 
           48,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,   63,   64,    0,    0,    0, 
            4,    5,    6,    0,    8,    0,   65,   66,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  108,  109, 
           17,   18,    0,    0,    0,    0,  110,  111,  112,  266, 
          267,  268,  269,    0,    0,  117,    0,    0,    0,    0, 
            0,    0,  118,    0,    0,  270,  271,  272,    0,  273, 
           35,  274,  275,  276,  277,    0,   40,    0,    0,  127, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          278,    0,    0,   45,    0,    0,   46,   47,    0,   48, 
            0,   49,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,   63,   64,    0,    0,    0,    4, 
            5,    6,    0,    8,    0,   65,   66,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,  108,  109,   17, 
           18,    0,    0,    0,    0,  110,  111,  112,  339,  340, 
          341,  342,    0,    0,  117,    0,    0,    0,    0,    0, 
            0,  118,    0,    0,  343,  344,  345,    0,  346,   35, 
          347,  348,  349,  350,    0,   40,    0,    0,  127,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  351, 
            0,    0,  428,    0,    0,   46,   47,    0,   48,    0, 
          429,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,   63,   64,    0,    0,    0,    4,    5, 
            6,    0,    8,    0,   65,   66,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,  108,  109,   17,   18, 
            0,    0,    0,    0,  110,  111,  112,  113,  114,  115, 
          116,    0,    0,  117,    0,    0,    0,    0,    0,    0, 
          118,    0,    0,  119,  120,  121,    0,  122,   35,  123, 
          124,  125,  126,    0,   40,    0,    0,  127,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  129,    0, 
            0,  130,    0,    0,   46,   47,    0,   48,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,   63,   64,    0,    0,    0,    4,    5,    6, 
            0,    8,    0,   65,   66,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,  108,  109,   17,   18,    0, 
            0,    0,    0,  110,  111,  112,  339,  340,  341,  342, 
            0,    0,  117,    0,    0,    0,    0,    0,    0,  118, 
            0,    0,  343,  344,  345,    0,  346,   35,  347,  348, 
          349,  350,    0,   40,    0,    0,  127,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  351,    0,    0, 
          428,    0,    0,   46,   47,    0,   48,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,   63,   64,    0,    0,    0,    4,    5,    6,    0, 
            8,    0,   65,   66,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,  108,  109,   17,   18,    0,    0, 
            0,    0,  110,  111,  112,  113,  114,  115,  116,    0, 
            0,  117,    0,    0,    0,    0,    0,    0,  118,    0, 
            0,  119,  120,  121,    0,  978,   35,  123,  124,  979, 
          126,    0,   40,    0,    0,  127,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  980,    0,    0,  130, 
            0,    0,   46,   47,    0,   48,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
           63,   64,    0,    0,    0,    4,    5,    6,    0,    8, 
            0,   65,   66,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,  108,  109,   17,   18,    0,    0,    0, 
            0,  110,  111,  112,  992,  993,  994,  995,    0,    0, 
          117,    0,    0,    0,    0,    0,    0,  118,    0,    0, 
          996,  997,  998,    0,  999,   35, 1000, 1001, 1002, 1003, 
            0,   40,    0,    0,  127,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0, 1004,    0,    0,  130,    0, 
            0,   46,   47,    0,   48,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,   63, 
           64,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           65,   66,  138,  139,  140,  141,  142,  143,  144,  145, 
          146,  147,  148,  149,  150,  151,  152,  153,  154,  155, 
          156,  157,  158,  159,  160,  161,    0,    0,  162,  163, 
          164,  222,  223,  224,  225,  169,  170,  171,  172,  173, 
          174,  175,  176,  177,  178,  179,  180,  226,  227,  228, 
            0,  229,  185,  309,    0,  230,    0,    0,    0,  187, 
          188,    0,  189,  190,  191,  192,  193,  194,  195,    0, 
            0,  196,  197,    0,    0,    0,  198,  199,  200,  201, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  203,  204,    0,  205,  206,  207,  208, 
          209,  210,  211,  212,  213,  214,  215,    0,    0,  216, 
           52,  138,  139,  140,  141,  142,  143,  144,  145,  146, 
          147,  148,  149,  150,  151,  152,  153,  154,  155,  156, 
          157,  158,  159,  160,  161,    0,    0,  162,  163,  164, 
          222,  223,  224,  225,  169,  170,  171,  172,  173,  174, 
          175,  176,  177,  178,  179,  180,  226,  227,  228,    0, 
          229,  185,    0,    0,  230,    0,    0,    0,  187,  188, 
            0,  189,  190,  191,  192,  193,  194,  195,    0,    0, 
          196,  197,    0,    0,    0,  198,  199,  200,  201,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  203,  204,    0,  205,  206,  207,  208,  209, 
          210,  211,  212,  213,  214,  215,    0,    0,  216,   52, 
          138,  139,  140,  141,  142,  143,  144,  145,  146,  147, 
          148,  149,  150,  151,  152,  153,  154,  155,  156,  157, 
          158,  159,  160,  161,    0,    0,  162,  163,  164,  165, 
          166,  167,  168,  169,  170,  171,  172,  173,  174,  175, 
          176,  177,  178,  179,  180,  181,  182,  183,    0,  184, 
          185,  123,  124,  186,  126,    0,    0,  187,  188,    0, 
          189,  190,  191,  192,  193,  194,  195,    0,    0,  196, 
          197,    0,    0,    0,  198,  199,  200,  201,    0,    0, 
            0,    0,    0,    0,  202,    0,    0,    0,    0,    0, 
            0,  203,  204,    0,  205,  206,  207,  208,  209,  210, 
          211,  212,  213,  214,  215,    0,    0,  216,  138,  139, 
          140,  141,  142,  143,  144,  145,  146,  147,  148,  149, 
          150,  151,  152,  153,  154,  155,  156,  157,  158,  159, 
          160,  161,    0,    0,  162,  163,  164,  222,  223,  224, 
          225,  169,  170,  171,  172,  173,  174,  175,  176,  177, 
          178,  179,  180,  226,  227,  228,    0,  229,  185,  359, 
          360,  230,  361,    0,    0,  187,  188,    0,  189,  190, 
          191,  192,  193,  194,  195,    0,    0,  196,  197,    0, 
            0,    0,  198,  199,  200,  201,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  203, 
          204,    0,  205,  206,  207,  208,  209,  210,  211,  212, 
          213,  214,  215,    0,    0,  216,  138,  139,  140,  141, 
          142,  143,  144,  145,  146,  147,  148,  149,  150,  151, 
          152,  153,  154,  155,  156,  157,  158,  159,  160,  161, 
            0,    0,  162,  163,  164,  222,  223,  224,  225,  169, 
          170,  171,  172,  173,  174,  175,  176,  177,  178,  179, 
          180,  226,  227,  228,    0,  229,  185,    0,    0,  230, 
            0,    0,    0,  187,  188,    0,  189,  190,  191,  192, 
          193,  194,  195,    0,    0,  196,  197,    0,    0,    0, 
          198,  199,  200,  201,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  203,  204,    0, 
          205,  206,  207,  208,  209,  210,  211,  212,  213,  214, 
          215,  638,  639,  216,    0,  640,    0,    0,    0,  187, 
          188,    0,  189,  190,  191,  192,  193,  194,  195,    0, 
            0,  196,  197,    0,    0,    0,  198,  199,  200,  201, 
            0,    0,    0,    0,    0,    0,  303,    0,    0,    0, 
            0,    0,    0,  203,  204,    0,  205,  206,  207,  208, 
          209,  210,  211,  212,  213,  214,  215,  673,  631,  216, 
            0,  674,    0,    0,    0,  187,  188,    0,  189,  190, 
          191,  192,  193,  194,  195,    0,    0,  196,  197,    0, 
            0,    0,  198,  199,  200,  201,    0,    0,    0,    0, 
            0,    0,  303,    0,    0,    0,    0,    0,    0,  203, 
          204,    0,  205,  206,  207,  208,  209,  210,  211,  212, 
          213,  214,  215,  644,  639,  216,    0,  645,    0,    0, 
            0,  187,  188,    0,  189,  190,  191,  192,  193,  194, 
          195,    0,    0,  196,  197,    0,    0,    0,  198,  199, 
          200,  201,    0,    0,    0,    0,    0,    0,  303,    0, 
            0,    0,    0,    0,    0,  203,  204,    0,  205,  206, 
          207,  208,  209,  210,  211,  212,  213,  214,  215,  692, 
          631,  216,    0,  693,    0,    0,    0,  187,  188,    0, 
          189,  190,  191,  192,  193,  194,  195,    0,    0,  196, 
          197,    0,    0,    0,  198,  199,  200,  201,    0,    0, 
            0,    0,    0,    0,  303,    0,    0,    0,    0,    0, 
            0,  203,  204,    0,  205,  206,  207,  208,  209,  210, 
          211,  212,  213,  214,  215,  695,  639,  216,    0,  696, 
            0,    0,    0,  187,  188,    0,  189,  190,  191,  192, 
          193,  194,  195,    0,    0,  196,  197,    0,    0,    0, 
          198,  199,  200,  201,    0,    0,    0,    0,    0,    0, 
          303,    0,    0,    0,    0,    0,    0,  203,  204,    0, 
          205,  206,  207,  208,  209,  210,  211,  212,  213,  214, 
          215,  706,  631,  216,    0,  707,    0,    0,    0,  187, 
          188,    0,  189,  190,  191,  192,  193,  194,  195,    0, 
            0,  196,  197,    0,    0,    0,  198,  199,  200,  201, 
            0,    0,    0,    0,    0,    0,  303,    0,    0,    0, 
            0,    0,    0,  203,  204,    0,  205,  206,  207,  208, 
          209,  210,  211,  212,  213,  214,  215,  709,  639,  216, 
            0,  710,    0,    0,    0,  187,  188,    0,  189,  190, 
          191,  192,  193,  194,  195,    0,    0,  196,  197,    0, 
            0,    0,  198,  199,  200,  201,    0,    0,    0,    0, 
            0,    0,  303,    0,    0,    0,    0,    0,    0,  203, 
          204,    0,  205,  206,  207,  208,  209,  210,  211,  212, 
          213,  214,  215,  737,  631,  216,    0,  738,    0,    0, 
            0,  187,  188,    0,  189,  190,  191,  192,  193,  194, 
          195,    0,    0,  196,  197,    0,    0,    0,  198,  199, 
          200,  201,    0,    0,    0,    0,    0,    0,  303,    0, 
            0,    0,    0,    0,    0,  203,  204,    0,  205,  206, 
          207,  208,  209,  210,  211,  212,  213,  214,  215,  740, 
          639,  216,    0,  741,    0,    0,    0,  187,  188,    0, 
          189,  190,  191,  192,  193,  194,  195,    0,    0,  196, 
          197,    0,    0,    0,  198,  199,  200,  201,    0,    0, 
            0,    0,    0,    0,  303,    0,    0,    0,    0,    0, 
            0,  203,  204,    0,  205,  206,  207,  208,  209,  210, 
          211,  212,  213,  214,  215, 1068,  631,  216,    0, 1069, 
            0,    0,    0,  187,  188,    0,  189,  190,  191,  192, 
          193,  194,  195,    0,    0,  196,  197,    0,    0,    0, 
          198,  199,  200,  201,    0,    0,    0,    0,    0,    0, 
          303,    0,    0,    0,    0,    0,    0,  203,  204,    0, 
          205,  206,  207,  208,  209,  210,  211,  212,  213,  214, 
          215, 1071,  631,  216,    0, 1072,    0,    0,    0,  187, 
          188,    0,  189,  190,  191,  192,  193,  194,  195,    0, 
            0,  196,  197,    0,    0,    0,  198,  199,  200,  201, 
            0,    0,    0,    0,    0,    0,  303,    0,    0,    0, 
            0,    0,    0,  203,  204,    0,  205,  206,  207,  208, 
          209,  210,  211,  212,  213,  214,  215, 1074,  639,  216, 
            0, 1075,    0,    0,    0,  187,  188,    0,  189,  190, 
          191,  192,  193,  194,  195,    0,    0,  196,  197,    0, 
            0,    0,  198,  199,  200,  201,    0,    0,    0,    0, 
            0,    0,  303,    0,    0,    0,    0,    0,    0,  203, 
          204,    0,  205,  206,  207,  208,  209,  210,  211,  212, 
          213,  214,  215,  644,  639,  216,    0,  645,    0,    0, 
            0,  187,  188,    0,  189,  190,  191,  192,  193,  194, 
          195,    0,    0,  196,  197,    0,    0,    0,  198,  199, 
          200,  201,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  203,  204,    0,  205,  206, 
          207,  208,  209,  210,  211,  212,  213,  214,  215,    0, 
            0,  216, 
      };
   }

   private static final short[] yyCheck1() {
      return new short[] {

            2,    3,    4,    5,   74,    6,  257,    9,   10,   11, 
          373,    7,   14,   15,   16,   27,   88,   19,   90,   10, 
           26,  295,   28,  449,  486,    6,    7,  489,   49,   51, 
            7,   27,  586,  489,   45,   99,   15,   16,  469,  129, 
           19,   11,    3,   45,   15,   16,   27,   49,   19,   51, 
           27,   52,  334,    0,   10,  427,  338,    0,   10,  474, 
          419,   10,  421,  769,   44,  424,  420,   10,   59,   10, 
           21,   52,  528,    0,   10,  677,   47,   48,  104,   59, 
           10,   10,  280,   15,   16,    2,    3,   19,  451,  448, 
           15,   16,  694,  447,   19,   59,  767,   99,    4,    5, 
           59,   10,   10,  462,  431,  464,  708,   10,   14,  463, 
           59,  761,  118,  509,  321,   47,   59,   10,   11,  478, 
           10,   10,   10,  477,   10,   61,  128,  595,  130,   44, 
           59,   61,  104,   43,  104,   44,  305,  739,   59,  974, 
          305,   10,  865,   49,  341,   10,   61,   10,  280,   10, 
           10,  863,   61,  512,   10,  106,  305,   10,   61,    2, 
            3,  629,   32,  308,  362,  756,    9,   10,   11,  280, 
           59,  282,   15,   16,  312,   61,   19,  342,  537,  317, 
           10,  253,  536,   44,   10,    0,  341,   10,   10,  780, 
           10,   44,   10,   99,  359,   10,   10,  790,   59,   59, 
           10,  564,   45,  796,   10,   10,  375,  279,   51,  341, 
          375,  345,  350,  351,   10,   10,   10,  127,   10,   10, 
           32,  428,   44,  373,  498,  328,  375, 1062,  378,  363, 
          362,  376,  377,  336,  260,  237,   59,  949,   10,   59, 
           10,  325,  373,  315,   59,   59,  672,  378,  290,  291, 
           44,  362,   44,   59,  960,   44,  394,  683,  362,  721, 
          722,   44,  264,  265,   10,   59,  722,   59,  350,  351, 
           59,   44,    9,   10,   11,  359,   59,  317,  263,  264, 
           59,  353,  953,  310,  269,  128,   59,  130,  352,   59, 
          260,    2,    3,    4,    5, 1018,  887,  323,  300,  970, 
          302,  303,  373,   14,  306,  955,  308,  378, 1020,  349, 
          321,  313,   59,  353,  354,   61,   32,  319,  681,  321, 
           10,  300,  688,  302,  303,  269,   32,  271,  330,  300, 
          884,  302,  698,  563,   45,  731,   32,  891,   49,   32, 
         1052,  809,  896,  279,   10,  268,  269,   10,  306,  279, 
          352,  323,  310,  323,  371,  372,  446,  366,  373,  686, 
          282,  378,   10,  378,  279,  338,  383,   44,  300,  338, 
          302,  264,  265,   10,   61,  300,  279,  302,  342,  359, 
          382,  383,  384,  385,  386,  387,  388, 1058,   99,  345, 
          342,  128,  281,  345,  237,   61,   44,   61,   61,  373, 
          359,  342,  319,  425,  395,  427,  342,  267,  429,  431, 
          432,   59,  342,  342,  363,   21,  363,  428,  420,  130, 
          363,  264,  265,  425,   61,  427,  428,  429,  843,  431, 
          432,  803,  434,  342,  342,   44,  363,  345,  359,  342, 
          421,  420,  716,  424,  305,  447,  352,  449,  450,  700, 
            2,    3,  342,  735,  342,  345,  342,  300,  460,  302, 
          303,  463,   14,  306,   45,  308,  468,  448,  447,  386, 
          313, 1073,  341,  434,  538,  477,  319,  342,  321,  342, 
         1034,  342,  944,  464,  463,  305,  342,  330,  944,  382, 
          383,  384,  385,   45,  506,  427,  922,  478,  477,  431, 
          106,  371,  372,  473,  474,  507,  112,  509,  378,  940, 
          506,  305,  342,  305,  375,  486,  342,  434,  520,  345, 
          750,  751,  342,  429,  342,  506,  237,  264,  265,  506, 
          136,  512,  342,  279,  536,  305,  538,  342,  470,  382, 
          383,  384,  385,  386,  387,  388,  342,  342,  342,  130, 
          342,  342,    2,    3,  525,  375,  537,  536,  305,  371, 
          372,  341,   10,   10,  927,  991,  378,  359,   44,  306, 
          359,  308,  342,  847,  940,   10,  359,  420,  130,   10, 
          359,  375,  425,  375,  427,  428,  359,   91,  431,  432, 
          564,  434,  509,  330,  658,   45,  342,   44,  263,  264, 
          290,  291,  313,  310,  447,  375,  449,  450,  319,   10, 
          321,   59,   59,  279,  306,   91,  279,  460,  357,  338, 
          463,   61,  628,   10,  538,  468,   61,  271,  375,  338, 
           61,  637,  538,  863,  477,  865,  328,  329,  577,  578, 
           59,  352,  279,  310,  279,  382,  383,  384,  385,   10, 
          387,  388,   10,  339,   44,  328,  658,  305,   59,   44, 
          362,   10,  335,  336,  507,  317,  509,  317,  338,  671, 
          672,  677,  736,  685,   61,  386,  342,  520,  929,  342, 
          130,  683,  633,  684,  935,  237,   44, 1046,  694,  685, 
          641, 1045,   10,  536,  342,  646,  342,  310,   59,   10, 
          670,   59,  708,  684,  685,  342,  345,  681,  685,  711, 
           59,  359,  682,  450,  371,  372,  373,  428,  429,  949, 
          950,  378,  363,  434,   44,   91,  373,  375,  373,  731, 
          800,  373,  313,  739,  736,  373,   44,  347,  449,  396, 
          321,   59,   91,  807,  658,  341,   10,  262,   59,  460, 
          721,  264,  658,  267,  686,  264,  342,  468,   44,   44, 
          363,  313,  764,  765,  362,  787,  788,  319,   44,  321, 
          507,  793,  794,  293,  294,  295,  296,  297,  671,   91, 
          782,  803,  784,   32,  786,  787,  788,  237, 1018,   61, 
         1020,  793,  794,   91,  306,   59,  306,   10,  509,  491, 
           10,  803,   44,  279,  280,  807,   59,  499,  500,  520, 
           44,    2,   44,   44,  731,  421,  306,   44,  711,  267, 
          267,   32, 1052,  825,  328,  517,  828,  538,  671,  672, 
          736,  335,  336,  338,  386,  338,  338,  839,  840,  841, 
          683,  811,  448,  338,  279,   61,   59,  428,  279,   59, 
           44,   44,  328,  264,  269,  338,   47,   48,  464,  335, 
          336,  338,  264,  313,  338,  341,  267,  338,  711,  319, 
          363,  321,  478,  843,   44,  427,  428,   58,  338,  460, 
          345,   91,  434,  264,  264,  907,  362,  468,  731,  263, 
          339,  339,  279,  807,  264,  897,  338,  449,   44,   10, 
          264,  807,  263,  264,  771,  907,  512,  342,  460,  267, 
           10,  342,  363,  780,   44,  342,  468,   44,  267,  921, 
          922,  764,  765,   44,  264,  363,  928,   44,   10,  868, 
          932,  537,   44, 1005,  671,  828,  386,  876,  877,  782, 
          879,  784,  881,  786,  787,  788,  264,  658,   59,   44, 
          793,  794,   61,  264,   44,  342,   44,  509,  269,   59, 
          803,  672,  328,   44,  966,  657,   44,  359,  520,  335, 
          336,  264,  683,   44,  711,  363,  264,   59,  428,  328, 
          264,  339,  825,  264,  434,  828,  335,  336,  680,  991, 
           44,  897,  341,  310,  359,   10,  839,  840,  841,  449, 
          264,  363,  264,   10,  310,  269, 1008,  271, 1010,   91, 
          460,   44,   44,  767, 1016,  769,  328,   44,  468,   44, 
          731,   44,  928,  335,  336,  736,  780,  633,   10,   44, 
          328,   44,  395,  744,  726,  641,  264,  335,  336,  264, 
          646,   10,  734, 1045,   44,  271,   61,  363, 1050,  262, 
          263,  264,   59,  764,  765,   58,  269,  267,  345,  509, 
          966,  341,  271,  755,  907, 1046, 1045, 1073,  342,  675, 
          520,  782,  678,  784,  345,  786,   91,   59,  921,  922, 
           91,  371,  372,  373, 1023, 1024, 1025, 1026,  378,  932, 
           59,  828,  264,   10,   44,  363,  807,  345,   91,  345, 
          967,  342,  359,  970,   70,  972,  288,  974,   54,   91, 
          375,    5,  303,  520,  825, 1048,    6,  646,  328,  927, 
          672,  780,   91,  972,  816,  335,  336,   44,  839,  840, 
          841,  683,  371,  372,  373,  767,  970,    0,  771,  378, 
          800,   91, 1081,   14,   61, 1047,  750,   10,  991,   -1, 
           91,  262,  263,  264,  371,  372,  373,  268,  269,   -1, 
          271,  378,  262,  263,  264, 1008,   10, 1010,  268,  269, 
          862,  271,   91, 1016,   91,  371,  372,  373,  955,  731, 
           -1,   44,  378,  764,  765,  267,  897,   10,   -1,   -1, 
           10, 1058,   -1, 1060,   -1, 1062,   59,   -1, 1065,   -1, 
           -1,  782, 1045,  784,   -1,  786,  960, 1050,   -1,   -1, 
          921,  922,  764,  765,   -1,   59,  970,  928,   -1,   44, 
          974,  932,  672, 1090,   44,  379,  380,  381,  382,  420, 
          782,  342,  784,  683,  786,  306,   59,  308,  309,  310, 
          311,   61,  342,   -1,  825,   -1,  328,   91,   -1,   -1, 
           -1,  803,  363,  335,  336,  966,  447,  264,  839,  840, 
          841,  268,  269,  363,  279,  456,   91,   -1,   91,   -1, 
           -1,   91,  463,  825,   15,   16,   -1,   10,   19,   10, 
          991,  731,   -1,   -1,  395,  267,  477,  839,  840,  841, 
           -1,   -1,   -1,   -1,   44,  395,   -1, 1008,  267, 1010, 
           41,   42,   -1,   -1,   -1, 1016,   47,   48, 1062,   50, 
           51,  280,   -1,  328,  764,  765,   10,  328,  509,   -1, 
          335,  336,   -1,   -1,  335,  336,   59,  342,   59,  279, 
          280,   -1,  782,   -1,  784,  328,  786,   -1,   -1, 1050, 
          921,   91,  335,  336,   -1,  536,  328,   44,   -1,   -1, 
           -1,  932,   -1,  335,  336,   48,   -1,   -1,   91,  328, 
           91,   -1,  279,  280,   -1,   59,  335,  336,   -1,  921, 
          922,   -1,  341,   -1,   -1,  825,  928,   -1,  328,   -1, 
          932,  371,  372,  373,  575,  335,  336,  328,  378,  839, 
          840,  841,   -1,  362,  335,  336,   -1,   91,   -1,  262, 
          263,  264,   -1,  594,  595,  268,  269,   -1,  271,  328, 
          317,  328,  362,  371,  372,  373,  335,  336,  335,  336, 
          378,   -1,   -1,  267,  341,  342,   44, 1008,   -1, 1010, 
          293,  294,  295,  296,  297, 1016,   -1,   -1,  629,  991, 
         1046,   59,  349,   10,  267,  362,  353,  354,  355,  356, 
          641,   -1,   -1,   -1,  279,  646, 1008,  280, 1010,  279, 
          280,   -1,  308,  309, 1016,  311,   -1,   -1,   -1, 1050, 
           -1,  921,  922,   91,   -1,   -1,   10,   44,   -1,  342, 
           -1,   -1,  932,   -1,  328,   -1,   -1,  678,   -1,   -1, 
           -1,  335,  336,   -1,   61,  686,   -1,  688, 1050,  690, 
          363,   10,   -1,  328,   -1,  328,   -1,  698,  328,   -1, 
          335,  336,  335,  336,   -1,  335,  336,    0,  341,   -1, 
           -1,  341,  342,   -1,   91,   59,   -1,   10,   -1,  279, 
          376,  377,  395,   -1,  267,   -1,  267,   -1,   -1,  362, 
          731,  991,  362,  284,  285,  286,  287,  280,  289,  280, 
           59,  306,   -1,  308,  309,  310,  311,   91, 1008,  300, 
         1010,  302,  303,   -1,   10,  756, 1016,  371,  372,  373, 
          311,   -1,   -1,  267,  378,   -1,   59,   -1,  328,   -1, 
            0,   -1,   91,   -1,   -1,  335,  336,   -1,   -1,  780, 
           10,  284,  285,  286,   -1,  328,  289,  328,   44,   -1, 
         1050,   -1,  335,  336,  335,  336,   -1,   -1,  341,  306, 
          341,  308,  309,  310,  311,   61,   -1,   -1,  809,   -1, 
          371,  372,  373,   -1,   44,   -1,   10,  378,   -1,  362, 
           -1,  362,  823,   -1,  328,  826,   -1,   -1,   58,   59, 
           -1,  335,  336,   63,   -1,   91,   -1,   -1,  389,  390, 
          391,  392,  393,  394,  395,  396,  397,  398,  399,  400, 
          401,  402,  403,  404,  405,  406,  407,  408,  409,  410, 
          411,  412,  413,  414,   -1,   59,   -1,  317,   -1,  420, 
           -1,   -1,   -1,   10,  425,   -1,  427,   -1,   -1,   -1, 
          431,  432,   -1,  333,  334,   -1,  887,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,  447,   91,   10,  349, 
          328,   10,  279,  353,  354,  355,  356,  335,  336,   10, 
           -1,   -1,  463,  341,  465,  466,  467,   -1,   -1,  470, 
           -1,   44,   59,  267,  427,   -1,  477,   -1,  431,   -1, 
           -1,  359,   44,   -1,  485,  486,  280,   -1,  489,  940, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,  267,   61, 
           59,  328,   -1,   -1,   91,   -1,   -1,   -1,  335,  336, 
           61,  280,  513,  514,   10,  342,   -1,  470,   91,  262, 
          263,  264,   -1,   -1,  525,  268,  269,  528,  271,   91, 
           -1,   -1,  485,  486,  328,  536,  489,   -1,   -1,   -1, 
           91,  335,  336,   -1,   -1,   -1,   -1,  341,   -1,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,  328, 
           -1,   -1,   -1,   59,   -1,   -1,  335,  336,  362,   -1, 
           -1,   -1,  525,  279,  280,  528,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,  587,  267,  268,  269, 
           44,  271,   -1,  362, 1045,   -1, 1047, 1048,    0,  342, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   10, 
          363,   10,  328,  267,   -1,  305,   -1,   -1,   -1,  335, 
          336,   -1,   -1,   -1,  587,  341,  342,   91,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  649,  329, 
          330,   -1,  395,  333,  334,   44,  362,   59,   -1,  339, 
           -1,   10,  342,   -1,   -1,  345,   -1,  347,   59,  349, 
           -1,  351,   61,  353,  354,  355,  356,  357,  358,  359, 
          267,  361,   -1,  363,  328,  686,   -1,   -1,   -1,   -1, 
           -1,  335,  336,   -1,   -1,  375,  649,   -1,   -1,   -1, 
           91,   -1,   91,  262,  263,  264,  279,   -1,  267,  268, 
          269,  712,  271,  714,   63,  395,   -1,  279,  280,   -1, 
          721,  722,  281,   -1,   -1,   -1,   -1,   -1,  279,  280, 
           -1,  290,  291,  686,  293,  294,  295,  296,  297,   -1, 
           -1,  328,   -1,   -1,   -1,   -1,   -1,  748,  335,  336, 
           -1,   -1,   -1,   -1,  365,  328,  367,   -1,  369,  712, 
           -1,  714,  335,  336,  375,    0,  328,   -1,  721,  722, 
           -1,   -1,   -1,  335,  336,   10,   -1,  328,   -1,  341, 
          342,   -1,   -1,  342,  335,  336,  787,  788,   -1,   -1, 
          341,  342,  793,  794,   -1,  748,   -1,   -1,   -1,   -1, 
          362,  802,  803,  804,  363,   -1,   -1,  808,   -1,   44, 
          306,  362,  308,  309,  310,  311,  312,   -1,   -1,   -1, 
           -1,  317,   -1,   58,   59,  279,   61,   -1,   63,   -1, 
          831,  832,  328,  834,  835,   -1,  395,  838,   -1,   -1, 
          336,   -1,   -1,   -1,  340,  341,   -1,   -1,   -1,   -1, 
           -1,  804,  348,  349,  350,  351,   91,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,  483,   -1,  328,   -1,  267,   -1,   -1,  281, 
           -1,  335,  336,   -1,   -1,  838,  317,  341,  290,  291, 
          279,  293,  294,  295,  296,  297,   -1,   -1,  394,  900, 
           -1,   -1,  333,  334,    0,   -1,  907,   -1,  306,   -1, 
          308,  309,  310,  311,   10,   -1,  917,   -1,  349,   -1, 
          351,   -1,  353,  354,  355,  356,  328,   -1,  359,   -1, 
          361,   -1,   -1,  335,  336,   -1,  937,  328,   -1,  328, 
          342,  552,  340,  944,  335,  336,  335,  336,   44,   -1, 
          348,   -1,  341,  342,  306,   -1,  308,  309,  310,  311, 
           -1,  363,   58,   59,  917,   61,   -1,   63,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  590, 
          329,  330,   -1,   -1,  333,  334,   -1,   -1,  340,   -1, 
           -1,  944,   -1,  395,   -1,   91,  348,   -1,   -1,   -1, 
          349,   -1,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   -1,  361,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,  267,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278, 1045,  280,  281,  282,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,   -1,  299,   59,   -1,  302,  303,  304, 
          305,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,  337,  338,  339,  340,  341,  342,  343,  344, 
          345,  346,  347,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  362,  363,   59, 
          365,  366,  367,  368,  369,  370,   -1,   -1,   -1,  374, 
          375,  376,  377,   -1,  379,  380,  381,  382,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,  392,  393,  394, 
          395,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,  267,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,  780,  280,  281,  282,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,  292,  293,  294,  295, 
          296,  297,   -1,  299,   59,   -1,  302,  303,  304,  305, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   44,   91,  333,  334,  335, 
          336,  337,  338,  339,  340,  341,  342,  343,  344,  345, 
          346,  347,  348,  349,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,  362,  363,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,    0,  374,  375, 
          376,  377,   91,  379,  380,  381,  382,   10,  888,   -1, 
           -1,   -1,  892,   -1,   -1,   -1,  392,  393,  394,  395, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,   -1, 
          268,  269,  306,  271,  308,  309,  310,  311,  312,   -1, 
           -1,   44,   -1,  317,  262,  263,  264,  317,   -1,   -1, 
          268,  269,   -1,  271,  328,   58,   59,   -1,   61,   -1, 
           63,   -1,  336,  333,  334,   -1,  340,  341,   -1,   -1, 
           -1,   -1,   -1,   -1,  348,  349,  350,  351,   -1,  349, 
           -1,  351,   -1,  353,  354,  355,  356,   -1,   91,   -1, 
          967,   -1,   -1,  970,   -1,  972,  306,  974,  308,  309, 
          310,  311,  312,   -1,  342,   -1,   -1,  317,  306,   -1, 
          308,  309,  310,  311,   -1,   -1,   -1,   -1,   -1,   -1, 
          394,   -1,   -1,   -1,  342,  363,   -1,   -1,   -1,   -1, 
          340,   -1,  267,   -1,   -1,   -1,    0,   -1,  348,  349, 
          350,  351,  340,   -1,   -1,  363,   10,   -1, 1028,   -1, 
           -1, 1031, 1032,   -1,   -1, 1035, 1036,  395,   -1,   -1, 
           -1,   -1,   -1,   -1,  306,   -1,  308,  309,  310,  311, 
          312,   -1,   -1,   -1,   -1,  317,   -1,  395,   -1,   -1, 
           44, 1058,   -1, 1060,  394, 1062,   -1,   -1, 1065,   -1, 
          279,   -1,   -1,  328,   58,   59,   -1,   61,  340,   63, 
          335,  336, 1082, 1083, 1084, 1085,  348,  349,  350,  351, 
           -1,   -1,   -1, 1090, 1094,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  328, 
           -1,   -1,   -1,   -1,   -1,   -1,  335,  336,   10,   -1, 
           -1,   -1,  394,   -1,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,  267,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   -1,  280,  281,  282, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,   -1,  299,   59,   -1,  302, 
          303,  304,  305,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   44,   -1, 
          333,  334,  335,  336,  337,   10,  339,  340,  341,  342, 
          343,  344,  345,  346,  347,  348,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  362, 
          363,   -1,  365,  366,  367,  368,  369,  370,   44,   -1, 
           -1,  374,  375,  376,  377,   91,  379,  380,  381,  382, 
           -1,   -1,   -1,   -1,   59,   -1,   -1,   10,   -1,  392, 
          393,  394,  395,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   91,  280,  281,  282,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,   -1,  299,   59,   -1,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   44,   91,  333, 
          334,  335,  336,  337,   -1,  339,  340,  341,  342,  343, 
          344,  345,  346,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  362,  363, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,    0, 
          374,  375,  376,  377,   91,  379,  380,  381,  382,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  392,  393, 
          394,  395,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  306,   -1,  308,  309,  310,  311, 
          312,   -1,   -1,   44,   -1,  317,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  279,  280,   -1,  328,   58,   59,   -1, 
           61,   -1,   63,   -1,  336,   -1,   -1,   -1,  340,  341, 
           -1,   -1,   -1,   -1,   -1,   -1,  348,  349,  350,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,   -1,   -1,  279,   -1,  306,   -1,  308,  309,  310, 
          311,  312,  328,   -1,   -1,   -1,  317,   -1,   -1,  335, 
          336,   -1,   -1,   -1,   -1,  341,   -1,   -1,   -1,   -1, 
           -1,  306,  394,  308,  309,  310,  311,  312,   -1,  340, 
           -1,   -1,  317,   -1,  267,   -1,  362,   -1,    0,  350, 
          351,   -1,  328,  328,   -1,   -1,   -1,   -1,   10,  335, 
          336,  336,   -1,   -1,   -1,  340,  341,   -1,   -1,   -1, 
           -1,   -1,   -1,  348,  349,  350,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  317,   -1,   -1,   -1,   -1,  322, 
          323,   -1,   44,  394,   -1,   -1,   -1,   -1,   -1,   -1, 
          333,  334,  279,   -1,   -1,  328,   58,   59,   -1,   -1, 
           -1,   63,  335,  336,   -1,   -1,  349,   -1,  351,  394, 
          353,  354,  355,  356,  357,  358,  359,   -1,  361,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  328,   -1,   -1,   -1,   -1,   -1,   -1,  335,  336, 
           10,   -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,   -1,  299,   59, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           44,   -1,  333,  334,  335,  336,  337,   10,  339,  340, 
          341,  342,  343,  344,  345,  346,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,  363,   -1,  365,  366,  367,  368,  369,  370, 
           44,   -1,   -1,  374,  375,  376,  377,   91,  379,  380, 
          381,  382,   -1,   -1,   -1,   -1,   59,   -1,   -1,   10, 
           -1,  392,  393,  394,  395,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,  267,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   91,  280,  281, 
          282,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,   -1,  299,   59,   -1, 
          302,  303,  304,  305,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   44, 
           91,  333,  334,  335,  336,  337,   -1,  339,  340,  341, 
          342,  343,  344,  345,  346,  347,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,  363,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,    0,  374,  375,  376,  377,   91,  379,  380,  381, 
          382,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          392,  393,  394,  395,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  306,   -1,  308,  309, 
          310,  311,  312,   -1,   -1,   44,   -1,  317,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  279,  280,   -1,  328,   58, 
           59,   -1,   -1,   -1,   63,   -1,  336,   -1,   -1,   -1, 
          340,  341,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349, 
          350,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   91,   -1,   -1,  279,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   -1,   -1, 
           -1,  335,  336,   -1,   -1,   -1,   -1,  341,   -1,   -1, 
           -1,   -1,   -1,  306,  394,  308,  309,  310,  311,  312, 
           -1,   -1,   -1,   -1,  317,   -1,  267,   -1,  362,   -1, 
            0,   -1,   -1,   -1,  328,  328,   -1,   -1,   -1,   -1, 
           10,  335,  336,  336,   -1,   -1,   -1,  340,  341,   -1, 
           -1,   -1,   -1,   -1,   -1,  348,  349,  350,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,   44,  326,  327,   -1,   -1,   -1, 
           -1,   -1,  333,  334,  279,   -1,   -1,  328,   58,   59, 
           -1,   -1,   -1,   63,  335,  336,   -1,   -1,  349,   -1, 
          351,  394,  353,  354,  355,  356,  357,  358,  359,   -1, 
          361,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  328,   -1,   -1,   -1,   -1,   -1,   -1, 
          335,  336,   10,   -1,   -1,   -1,   -1,   -1,  257,  258, 
          259,   -1,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
           -1,  280,  281,  282,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,   -1, 
          299,   59,   -1,  302,  303,  304,  305,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   44,   -1,  333,  334,  335,  336,  337,   10, 
          339,  340,  341,  342,  343,  344,  345,  346,  347,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  362,  363,   -1,  365,  366,  367,  368, 
          369,  370,   44,   -1,   -1,  374,  375,  376,  377,   91, 
          379,  380,  381,  382,   -1,   -1,   -1,   -1,   59,   -1, 
           -1,   10,   -1,  392,  393,  394,  395,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,  267,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,   91, 
          280,  281,  282,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,   -1,  299, 
           59,   -1,  302,  303,  304,  305,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   44,   91,  333,  334,  335,  336,  337,   -1,  339, 
          340,  341,  342,  343,  344,  345,  346,  347,  348,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,  362,  363,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,    0,  374,  375,  376,  377,   91,  379, 
          380,  381,  382,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  392,  393,  394,  395,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  306,   -1, 
          308,  309,  310,  311,  312,   -1,   -1,   44,   -1,  317, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  279,  280,   -1, 
          328,   58,   59,   -1,   61,   -1,   63,   -1,  336,   -1, 
           -1,   -1,  340,  341,   -1,   -1,   -1,   -1,   -1,   -1, 
          348,  349,  350,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   91,   -1,   -1,  279,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,   -1, 
           -1,   -1,   -1,  335,  336,   -1,   -1,   -1,   -1,  341, 
           -1,   -1,   -1,   -1,   -1,  306,  394,  308,  309,  310, 
          311,  312,   -1,   -1,   -1,   -1,  317,   -1,  267,   -1, 
          362,   -1,    0,   -1,   -1,   -1,  328,  328,   -1,   -1, 
           -1,   -1,   10,  335,  336,  336,   -1,   -1,   -1,  340, 
          341,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,  350, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,   -1,   44,  326,  327,   -1, 
           -1,   -1,   -1,   -1,  333,  334,  279,   -1,   -1,  328, 
           -1,   59,   -1,   -1,   -1,   63,  335,  336,   -1,   -1, 
          349,   -1,  351,  394,  353,  354,  355,  356,  357,  358, 
          359,   -1,  361,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   -1, 
           -1,   -1,  335,  336,   10,   -1,   -1,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,  281,  282,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,   -1,  299,   59,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
          337,   -1,  339,  340,  341,  342,  343,  344,  345,  346, 
          347,  348,  349,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,   -1,  363,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,  375,  376, 
          377,   -1,  379,  380,  381,  382,   44,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  392,  393,  394,  395,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,  267, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,   -1,  280,  281,  282,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,  337, 
           -1,  339,  340,   -1,  342,  343,  344,  345,  346,  347, 
          348,  349,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,  362,  363,   -1,  365,  366,  367, 
          368,  369,  370,   -1,   -1,    0,  374,   -1,  376,  377, 
           -1,  379,  380,  381,  382,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  392,  393,  394,  395,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          306,   -1,  308,  309,  310,  311,  312,   -1,   -1,   44, 
           -1,  317,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  328,   -1,   59,   -1,   -1,   -1,   63,   -1, 
          336,   -1,   -1,   -1,  340,  341,   -1,   -1,   -1,   -1, 
           -1,   -1,  348,  349,  350,  351,   -1,   -1,   -1,  257, 
          258,  259,   -1,  261,   -1,   -1,   91,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,  394,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,    0,  313,   -1,   -1,  316,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337, 
           -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  365,  366,  367, 
          368,  369,  370,   59,   -1,   -1,  374,   63,  376,  377, 
           -1,  379,  380,  381,  382,  306,   -1,  308,  309,  310, 
          311,  312,   -1,   -1,  392,  393,  317,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  340, 
          341,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,  350, 
          351,   -1,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,  267,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   -1,  280,  281,  282,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,  394,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,    0,   -1,  333,  334, 
          335,  336,  337,   -1,  339,  340,   10,  342,  343,  344, 
          345,  346,  347,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  362,  363,   -1, 
          365,  366,  367,  368,  369,  370,   44,   -1,   -1,  374, 
           44,  376,  377,   -1,  379,  380,  381,  382,   -1,   -1, 
           -1,   59,   -1,   -1,   58,   59,   -1,  392,  393,  394, 
          395,  257,  258,  259,   -1,  261,  262,  263,  264,  265, 
          266,  267,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,   91,   -1,  281,  282,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,  292,  293,  294,  295, 
          296,  297,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,  337,   -1,  339,  340,   -1,  342,  343,  344,  345, 
          346,  347,  348,  349,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,    0,  363,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   10,   -1,  374,   -1, 
          376,  377,   -1,  379,  380,  381,  382,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  392,  393,  394,  395, 
          306,   -1,  308,  309,  310,  311,  312,   -1,   -1,   -1, 
           44,  317,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   59,   -1,   61,   -1,   63, 
           -1,   -1,   -1,   -1,  340,  341,   -1,   -1,   -1,   -1, 
           -1,   -1,  348,  349,  350,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,  280,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,  394,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
          328,   -1,   -1,   -1,   -1,   -1,   -1,  335,  336,   -1, 
           -1,   -1,   -1,  341,   -1,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,  359,   -1,   -1,  362,   -1,   -1,   -1,   -1,  363, 
           -1,   -1,   -1,   -1,   59,   -1,   61,   -1,   63,   -1, 
           -1,  375,   -1,   -1,   -1,   -1,  306,   -1,  308,  309, 
          310,  311,  312,   -1,   -1,   -1,   -1,  317,   -1,   -1, 
           -1,  395,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          340,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349, 
          350,  351,   -1,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,   -1,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,  394,  299,   44,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,  337,  338,   10,  340,  341,  342,  343, 
          344,   -1,  346,   91,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  362,  363, 
           -1,  365,  366,  367,  368,  369,  370,   44,   -1,   44, 
          374,   -1,  376,  377,  759,  379,  380,  381,  382,   -1, 
           -1,   -1,   59,   -1,  769,   -1,   61,   -1,  392,  393, 
          394,  395,  257,  258,  259,  780,  261,  262,  263,  264, 
          265,  266,   -1,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   91,  280,   91,   -1,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   63,   -1,  333,  334, 
          335,  336,  337,  338,   -1,  340,  341,  342,  343,  344, 
           -1,  346,   -1,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  362,  363,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,    0,  374, 
           -1,  376,  377,   -1,  379,  380,  381,  382,   10,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,  392,  393,  394, 
          395,  279,  280,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   61, 
           -1,   63,   61,  958,   -1,  960,   -1,  962,   -1,   -1, 
          328,   -1,  967,   -1,   -1,   -1,   -1,  335,  336,  974, 
           -1,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1,   91, 
           -1,   -1,   91,  280,  279,  280,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,  328,   -1,  328,   -1,   -1,   -1,   10,  335,  336, 
          335,  336,   -1,   -1,  341,   -1,   -1,  342,   -1, 1054, 
           -1,   -1,   -1,   -1,   -1, 1060,   -1, 1062,   -1,   -1, 
         1065,   -1,  359,   -1,   -1,  362,   -1,  362,   -1,   -1, 
           -1,   44,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
          297,   -1,   -1,   -1,   -1, 1090,   59,   -1,   61,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   -1,   -1,  333,  334,   91,   -1, 
           -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  349,   -1,  351,   -1,  353,  354,  355,  356, 
          357,  358,  359,   -1,  361,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,   -1,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   -1,  280,   -1, 
          279,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,   -1,  299,   44,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,  328, 
           -1,  333,  334,  335,  336,  337,  335,  336,  340,  341, 
          342,  343,  344,  342,  346,   91,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,  363,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,   -1,  374,   -1,  376,  377,   -1,  379,  380,  381, 
          382,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          392,  393,  394,  395,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,   -1,  268,  269,  270,  271,  272, 
          273,  274, 
      };
   }

   private static final short[] yyCheck2() {
      return new short[] {

          275,  276,  277,  278,   -1,  280,   -1,  279,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,  328,   -1,  333,  334, 
          335,  336,  337,  335,  336,  340,  341,  342,  343,  344, 
           -1,  346,   -1,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  362,  363,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,    0,  374, 
           -1,  376,  377,   -1,  379,  380,  381,  382,   10,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,  392,  393,  394, 
          395,  279,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   61, 
           -1,   63,   61,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          328,   -1,   -1,   -1,   -1,   -1,   -1,  335,  336,   -1, 
           -1,   -1,  257,  258,  259,   -1,  261,   -1,   -1,   91, 
          265,  266,   91,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,    0,  313,   -1, 
           -1,  316,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344, 
           -1,  346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          365,  366,  367,  368,  369,  370,   59,   -1,   61,  374, 
           63,  376,  377,   -1,  379,  380,  381,  382,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  392,  393,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,   -1,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   -1,  280,   -1, 
          279,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,  328, 
           -1,  333,  334,  335,  336,  337,  335,  336,  340,  341, 
          342,  343,  344,  342,  346,   -1,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,  363,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,   -1,  374,   -1,  376,  377,    0,  379,  380,  381, 
          382,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
          392,  393,  394,  395,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,   -1,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,   59,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,  336,  337,   -1,   -1,  340,  341,  342, 
          343,  344,   -1,  346,   -1,  348,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,   -1, 
          363,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
            0,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  392, 
          393,  394,  395,   -1,   -1,  306,  307,   -1,   -1,  310, 
           -1,   -1,   -1,  314,  315,   -1,  317,  318,  319,  320, 
          321,  322,  323,   -1,   44,  326,  327,   -1,   -1,   -1, 
          331,  332,  333,  334,   -1,   -1,   -1,   -1,   58,   59, 
          341,   61,   -1,   63,   -1,   -1,   -1,  348,  349,   -1, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,   -1,   -1,  364,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          771,   -1,   -1,  774,   -1,   -1,   -1,   -1,   -1,  780, 
           -1,   -1,   -1,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,  281,  282,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   -1,   -1, 
           -1,  335,  336,  337,   -1,   -1,  340,    0,  342,  343, 
          344,   -1,  346,   -1,  348,   -1,  350,   10,  352,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,  362,  363, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,  392,  393, 
          394,  395,  262,  263,  264,   58,   59,  267,  268,  269, 
           63,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          280,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   91,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,  967,   -1,   -1,  970, 
           -1,  972,   -1,  974,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,   -1,   -1,  339, 
           -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1,  349, 
            0,  351,   -1,  353,  354,  355,  356,  357,  358,  359, 
           10,  361,  362,  363,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,  395,   -1, 1058,   -1, 1060, 
           -1, 1062,   -1,   -1, 1065,   -1,   -1,   -1,   58,   59, 
           -1,   61,   10,   63,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   -1,   -1,   -1, 1090, 
           -1,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   91,   -1,   -1,   -1,   -1,   44,  349,   -1,  351, 
           -1,  353,  354,  355,  356,  357,  358,  359,    0,  361, 
           -1,   -1,   -1,   61,   -1,   -1,   -1,   -1,   10,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  280,  281,  282, 
           -1,   -1,   -1,   91,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,    0,   -1,   -1,   -1,   59,   -1,   -1, 
           -1,   -1,   -1,   10,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,  336,   -1,   -1,  339,   -1,   -1,  342, 
           -1,   -1,  345,   -1,  347,   -1,  349,   44,  351,   -1, 
          353,  354,  355,  356,  357,  358,  359,   -1,  361,  362, 
          363,   58,   59,   -1,   61,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,  375,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  395,   -1,   91,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,  279,   -1,  333,  334,  335,  336,   -1,  338,  339, 
           -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1,  349, 
           44,  351,   -1,  353,  354,  355,  356,  357,  358,  359, 
           -1,  361,   -1,  363,   58,   59,   -1,   61,   -1,   63, 
          262,  263,  264,   -1,   -1,  375,  268,  269,   -1,  271, 
          328,   -1,   -1,   -1,   -1,   -1,   -1,  335,  336,   10, 
           -1,   -1,   -1,   -1,  342,  395,   -1,   91,   -1,   -1, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           61,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
          342,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,    0, 
           91,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
           -1,  338,  339,  395,   -1,  342,   -1,   -1,  345,   -1, 
          347,   -1,  349,   44,  351,   -1,  353,  354,  355,  356, 
          357,  358,  359,   -1,  361,   -1,  363,   58,   59,   -1, 
           61,   -1,   63,   -1,   -1,   -1,   -1,   -1,  375,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  395,   -1, 
           91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,  338,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,  349,   44,  351,  279,  353, 
          354,  355,  356,  357,  358,  359,   -1,  361,   -1,  363, 
           58,   59,   -1,   61,   10,   63,   -1,   -1,   -1,   -1, 
           -1,  375,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,  395,   -1,   91,   -1,   -1,   -1,  328,   44,   -1, 
           -1,   -1,   -1,   -1,  335,  336,   -1,   -1,   -1,   -1, 
           -1,  342,   -1,   -1,   -1,   61,   -1,   -1,   -1,   44, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   61,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   91,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,    0,   91,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,  336,   -1,  338,  339,   -1, 
           -1,  342,   -1,   -1,  345,   -1,  347,   -1,  349,   44, 
          351,   -1,  353,  354,  355,  356,  357,  358,  359,   -1, 
          361,   -1,  363,   58,   59,   -1,   61,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  395,   -1,   91,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,  279,   -1,  333,  334,  335,  336,   -1, 
          338,  339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347, 
           -1,  349,   44,  351,  279,  353,  354,  355,  356,  357, 
          358,  359,   -1,  361,   -1,  363,   58,   59,   -1,   61, 
           10,   63,   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1, 
           -1,   -1,  328,   -1,   -1,   -1,   -1,   -1,   -1,  335, 
          336,   10,   -1,   -1,   -1,   -1,  342,  395,   -1,   91, 
           -1,   -1,   -1,  328,   44,   -1,   -1,   -1,   -1,   -1, 
          335,  336,   -1,   -1,   -1,   -1,   -1,  342,   -1,   -1, 
           -1,   61,   -1,   -1,   -1,   44,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   61,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   91,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,    0,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,   -1,  338,  339,   -1,   -1,  342,   -1,   -1, 
          345,   -1,  347,   -1,  349,   44,  351,   -1,  353,  354, 
          355,  356,  357,  358,  359,   -1,  361,   -1,  363,   58, 
           59,   -1,   61,   -1,   63,   -1,   -1,   -1,   -1,   -1, 
          375,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          395,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,  279, 
           -1,  333,  334,  335,  336,   -1,  338,  339,   -1,   -1, 
          342,   -1,   -1,  345,   -1,  347,   10,  349,   44,  351, 
          279,  353,  354,  355,  356,  357,  358,  359,   -1,  361, 
           -1,  363,   58,   59,   -1,   61,   10,   63,   -1,   -1, 
           -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,  328,   -1, 
           44,   -1,   -1,   -1,   -1,  335,  336,   -1,   -1,   -1, 
           -1,   -1,  342,  395,   -1,   91,   -1,   61,   -1,  328, 
           44,   -1,   -1,   -1,   -1,   -1,  335,  336,   -1,   -1, 
           -1,   -1,   -1,  342,   -1,   -1,   -1,   61,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   91,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   91,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,  336,   -1,  338, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
          349,   44,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   -1,  361,   -1,  363,   58,   59,   -1,   61,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  395,   -1,   91,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
            0,   -1,   -1,   -1,   -1,  279,   -1,   -1,   -1,   -1, 
           10,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,  279,   -1,  333,  334,  335, 
          336,   -1,  338,  339,   -1,   -1,  342,   -1,   -1,  345, 
           -1,  347,   -1,  349,   44,  351,   -1,  353,  354,  355, 
          356,  357,  358,  359,  328,  361,   -1,  363,   58,   59, 
           -1,  335,  336,   63,   -1,   -1,   -1,   -1,  342,  375, 
           -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   -1,   -1, 
           -1,  335,  336,   -1,   -1,   -1,   -1,   -1,  342,  395, 
           -1,   91,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   91,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,  336,   -1,  338,  339,   -1,   -1,  342, 
           -1,   -1,  345,   -1,  347,   -1,  349,   44,  351,   -1, 
          353,  354,  355,  356,  357,  358,  359,   -1,  361,   -1, 
          363,   58,   59,   -1,   61,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,  375,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  395,   -1,   91,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          280,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,  280,   -1,  333,  334,  335,  336,   -1,   -1,  339, 
           -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1,  349, 
           44,  351,   -1,  353,  354,  355,  356,  357,  358,  359, 
           -1,  361,  362,  363,   58,   59,   -1,   61,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,  328, 
           -1,   -1,   -1,   -1,   -1,   -1,  335,  336,   -1,   -1, 
           -1,   -1,  341,   -1,   -1,  395,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          359,   -1,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   63,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,    0, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
           -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1, 
          347,   -1,  349,   44,  351,   -1,  353,  354,  355,  356, 
          357,  358,  359,   -1,  361,   -1,  363,   58,   59,   -1, 
           -1,   -1,   63,   -1,   -1,   -1,   -1,   -1,  375,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  395,   -1, 
           91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,   -1,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,  349,   44,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   -1,  361,   -1,  363, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,  375,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,   -1,  329,  330,   -1,   -1,  333,  334, 
           -1,  395,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  349,   -1,  351,   -1,  353,  354, 
          355,  356,  357,  358,  359,   -1,  361,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,  336,   -1,   -1,  339,   -1, 
           -1,  342,   -1,   -1,  345,   -1,  347,   -1,  349,   44, 
          351,   -1,  353,  354,  355,  356,  357,  358,  359,   -1, 
          361,   -1,  363,   58,   59,   -1,   -1,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  395,   -1,   91,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,   -1, 
           -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347, 
           -1,  349,   44,  351,   -1,  353,  354,  355,  356,  357, 
          358,  359,   -1,  361,   -1,  363,   58,   59,   -1,   -1, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  395,   -1,   91, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1, 
          345,   -1,  347,   -1,  349,   44,  351,   -1,  353,  354, 
          355,  356,  357,  358,  359,   -1,  361,   -1,  363,   58, 
           59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1, 
          375,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          395,   -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,   -1,   -1,  339,   -1,   -1, 
          342,   -1,   -1,  345,   -1,  347,   -1,  349,   44,  351, 
           -1,  353,  354,  355,  356,  357,  358,  359,   -1,  361, 
           -1,  363,   -1,   59,   -1,   -1,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,  375,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  395,   -1,   91,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,    0,   -1,   -1, 
           -1,   59,   -1,   -1,   -1,   -1,   -1,   10,   -1,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,  328, 
          329,  330,   -1,   -1,  333,  334,  335,  336,   -1,   -1, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
          349,   44,  351,   -1,  353,  354,  355,  356,  357,  358, 
          359,   -1,  361,   -1,  363,   -1,   59,   -1,   -1,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  395,   -1,   91,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345, 
           -1,  347,   -1,  349,   44,  351,   -1,  353,  354,  355, 
          356,  357,  358,  359,   -1,  361,   -1,  363,   -1,   59, 
           -1,   -1,   -1,   63,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,   -1,   -1,   -1,   -1,   -1,  395, 
           -1,   91,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,  342,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   -1,  363,   -1,   59,   -1,   -1, 
           -1,   -1,   -1,   10,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,  336,   -1,   -1,  339,  395,   -1,  342, 
           -1,   -1,  345,   -1,  347,   -1,  349,   44,  351,   -1, 
          353,  354,  355,  356,  357,  358,  359,   -1,  361,   -1, 
          363,   58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  395,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,   -1,   -1,  339, 
           -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1,  349, 
           44,  351,   -1,  353,  354,  355,  356,  357,  358,  359, 
           -1,  361,   -1,  363,   58,   59,   -1,   -1,   -1,   63, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
           -1,   -1,   -1,   -1,   -1,  395,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   10,   -1,   -1,   -1, 
          342,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1, 
           -1,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   58,   59,  333,  334,   -1,   63, 
           -1,   -1,  339,  395,   -1,  342,   -1,   -1,  345,   -1, 
          347,   -1,  349,   -1,  351,   -1,  353,  354,  355,  356, 
          357,  358,  359,   -1,  361,   -1,  363,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  375,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,  395,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   58,   59,   -1,   -1,   -1,   63, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,  333, 
          334,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,  349,   -1,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   -1,  361,   -1,  363, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,  375,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,  395,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   58,   59,   -1,   -1,   -1,   63, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,  333, 
          334,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,  349,    0,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   10,  361,   -1,  363, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,  375,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           44,  395,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   59,   -1,   61,   -1,   63, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   91,   -1,  333, 
          334,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,  349,   -1,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   -1,  361,   -1,  363, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,  375,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,  395,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   59,   -1,   61,   -1,   63, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   91,   -1,  333, 
          334,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,  349,    0,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   10,  361,   -1,  363, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,  375,   -1,   -1,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  280,   -1,   -1,   -1, 
           44,  395,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   59,   -1,   61,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   91,   -1,  333, 
          334,  335,  336,   -1,   -1,   -1,   -1,   -1,  342,   -1, 
           -1,   -1,   -1,   -1,   -1,  349,   -1,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   -1,  361,  362,  363, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,  395,   -1,   -1,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   59,   -1,   61,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   91,   -1,  333, 
          334,  335,  336,   -1,  338,   -1,   -1,   -1,  342,   -1, 
           -1,   -1,   -1,   -1,   -1,  349,    0,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   10,  361,   -1,  363, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,   -1,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,  395,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   59,   -1,   61,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   91,   -1,  333, 
          334,  335,  336,   -1,  338,   -1,   -1,   -1,  342,   -1, 
           -1,   -1,   -1,   -1,   -1,  349,   -1,  351,    0,  353, 
          354,  355,  356,  357,  358,  359,   -1,  361,   10,  363, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,  395,   44,   -1,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   61, 
           -1,   63,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,    0,   -1,  333, 
          334,  335,  336,   -1,  338,   -1,   -1,   10,  342,   -1, 
           -1,   -1,   -1,   -1,   -1,  349,   -1,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   -1,  361,   -1,  363, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   44,   -1,   -1,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   59,   -1,   61,   -1, 
           63,  395,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,  338,   -1,   -1,   -1,  342,   -1, 
           -1,   -1,   -1,   -1,   -1,  349,   -1,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,    0,  361,   -1,  363, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,   -1,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  395,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           44,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   59,   -1,   61,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,   -1,  338,   91,   -1,   -1, 
          342,   -1,   -1,   -1,   -1,   -1,   -1,  349,   -1,  351, 
            0,  353,  354,  355,  356,  357,  358,  359,   -1,  361, 
           10,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,   -1,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  395,   44,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,    0,   59, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,  336,   -1,  338,   -1,   -1,   -1,  342, 
           -1,   -1,   44,   -1,   -1,   -1,  349,   -1,  351,   -1, 
          353,  354,  355,  356,  357,  358,  359,   59,  361,   61, 
          363,   63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   91, 
           -1,   -1,  395,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,   -1,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,  338,   -1,   -1,   -1,  342,   -1, 
           -1,   44,   -1,   -1,   -1,  349,   -1,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   59,  361,   61,  363, 
           63,   -1, 
      };
   }

   private static final short[] yyCheck3() {
      return new short[] {

          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,  395, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,   -1,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1, 
          342,   -1,   -1,   -1,   -1,   -1,  290,  291,   44,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  363,   -1,   59,   -1,   61,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,  395,  338,   91,   -1,   -1,  342,   -1, 
           -1,   -1,   -1,   -1,   -1,  349,   -1,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,    0,  361,   -1,  363, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  395,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
           44,   -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   59,   -1,   61,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,    0,   -1,  333,  334, 
          335,  336,   -1,  338,   -1,   -1,   10,  342,   -1,   -1, 
           -1,   -1,   -1,   -1,  349,   -1,  351,   -1,  353,  354, 
          355,  356,  357,  358,  359,   -1,  361,   -1,  363,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
           44,   -1,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   59,   -1,   61,   -1,   63, 
          395,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
          336,   -1,  338,   -1,   -1,   -1,  342,   -1,   -1,   -1, 
           -1,   -1,   -1,  349,   -1,  351,    0,  353,  354,  355, 
          356,  357,  358,  359,   -1,  361,   10,  363,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,   -1,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  395, 
           44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   58,   59,   -1,   -1,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,   -1,   -1,   -1,   -1,  342,   -1, 
           -1,   -1,   -1,   -1,   -1,  349,    0,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   10,  361,   -1,  363, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,   -1,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,  395,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   58,   59,   -1,   -1,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,   -1,   -1,   -1,   -1,  342,   -1, 
           -1,   -1,   -1,   -1,   -1,  349,   -1,  351,   -1,  353, 
          354,  355,  356,  357,  358,  359,   -1,  361,   -1,  363, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,  395,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   58,   59,   -1,   -1,   -1,   63, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,  333, 
          334,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,   -1,    0,  351,   -1,   -1, 
           -1,  355,  356,  357,  358,  359,   10,  361,   -1,  363, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,  375,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           44,  395,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   58,   59,   -1,   -1,   -1,   63, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,  333, 
          334,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1, 
           -1,  355,  356,  357,  358,  359,   -1,  361,   -1,  363, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,  375,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,  395,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   58,   59,   -1,   -1,   -1,   63, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,  333, 
          334,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,   -1,    0,  351,   -1,   -1, 
           -1,   -1,   -1,  357,  358,  359,   10,  361,   -1,  363, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,  375,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           44,  395,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   58,   59,   -1,   -1,   -1,   63, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,  333, 
          334,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1, 
           -1,   -1,    0,  357,  358,  359,   -1,  361,   -1,  363, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  375,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,  395,   -1,  267,  268,  269,   44,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           58,   59,   -1,   -1,   -1,   63,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1, 
           -1,    0,   -1,  357,  358,  359,   -1,  361,   -1,  363, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,  375,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,  395,   -1,   -1,   -1,   44,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   58, 
           59,  305,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  357,  358,  359,    0,  361,   -1,  363, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
           -1,  375,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  395,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   58,   59,   -1,  305,   -1,   63, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  357, 
          358,  359,   -1,  361,   -1,  363,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1, 
           -1,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,  395,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   58, 
           59,   -1,   -1,   -1,   63,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
          329,  330,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,  357,  358, 
           -1,   -1,   -1,   -1,  363,   -1,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  375,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  395,  281,  282,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   58,   59,   -1,   -1,   -1,   63, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  357,  358,   -1,   -1,   -1,   -1,  363, 
           -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,  375,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  262,  263,  264,   -1,   -1,  267,  268, 
          269,  395,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   58,   59,   -1,  305,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
          329,  330,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          339,   -1,    0,  342,   -1,   -1,  345,   -1,  347,   -1, 
           -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,  357,  358, 
           -1,   -1,   -1,   -1,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  375,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   44,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  395,  281,  282,   -1, 
           58,   59,   -1,   -1,   -1,   63,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342,    0, 
           -1,  345,   -1,  347,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,  357,  358,   -1,   -1,   -1,   -1,  363, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  375,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,  262,  263,  264, 
           -1,  395,  267,  268,  269,   -1,  271,   58,   59,   -1, 
           -1,   -1,   63,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,  324, 
          325,   -1,   -1,   -1,  329,  330,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1, 
          345,   -1,  347,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,   -1,   -1,  262,  263,  264,   -1,  363,  267, 
          268,  269,   -1,  271,   58,   59,   -1,   -1,   -1,   63, 
          375,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
          395,   -1,   -1,   -1,    0,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  324,  325,   -1,   -1, 
           -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  339,   -1,   -1,  342,   -1,   -1,  345,   44,  347, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   58,   59,   -1,  363,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  375,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,    0,   -1,   -1,   -1,   -1,  395,   -1,   -1, 
          281,  282,   10,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,   -1,  324,  325,   -1,   -1,   -1,  329,  330, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,  339,   -1, 
           -1,  342,   -1,   -1,  345,   -1,  347,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,  363,  267,  268,  269,   -1,  271,   -1,    0, 
           -1,   -1,   -1,   -1,  375,   -1,   -1,  281,  282,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,  395,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1, 
          324,  325,   -1,   -1,   -1,  329,  330,   58,   59,   -1, 
           -1,   -1,   63,   -1,   -1,  339,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,    0,   -1,  363, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   10,   -1,   -1, 
           -1,  375,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           -1,  395,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,  324,  325, 
           -1,   -1,   -1,  329,  330,   58,   59,   -1,   -1,   -1, 
           63,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1,  345, 
           -1,  347,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,    0,   -1,  363,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   10,   -1,   -1,   -1,  375, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,  395, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,   -1,   -1,   -1,   -1,   -1,  324,  325,   -1,   -1, 
           -1,  329,  330,   58,   59,   -1,   -1,   -1,   63,   -1, 
           -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,  363,  267,  268,  269,   -1, 
          271,   -1,    0,   -1,   -1,   -1,   -1,  375,   -1,   -1, 
          281,  282,   10,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,  395,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,   -1,  324,  325,   -1,   -1,   -1,  329,  330, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,  339,   -1, 
           -1,  342,   -1,   -1,  345,   -1,  347,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
            0,   -1,  363,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           10,   -1,   -1,   -1,  375,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,   -1,  395,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  325,   -1,   -1,   -1,  329,  330,   58,   59, 
           -1,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342, 
           -1,   -1,  345,   -1,  347,   -1,   -1,  262,  263,  264, 
           -1,   -1,  267,  268,  269,   -1,  271,   -1,    0,   -1, 
          363,   -1,   -1,   -1,   -1,   -1,  281,  282,   10,   -1, 
           -1,   -1,  375,   -1,   -1,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,  395,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1,   -1, 
           -1,   -1,   -1,   -1,  339,   -1,   -1,  342,   -1,   -1, 
          345,   -1,  347,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,    0,  363,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   10,   -1,   -1, 
          375,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
          395,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  339,   -1,   -1,  342,   -1,   -1,  345,   -1,  347, 
           -1,   -1,  262,  263,  264,   -1,    0,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,  363,   10,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,  375,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,   -1,  395,   -1,   -1, 
           44,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   58,   59,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,  339, 
           -1,   -1,  342,   -1,   -1,  345,   -1,  347,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,  363,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   44,   -1,   -1,  375,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   58,   59,   -1,   -1, 
           -1,   -1,   -1,  305,   -1,  395,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1, 
          342,   -1,   -1,  345,   -1,  347,   -1,    0,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   10,  271,   -1, 
           -1,  363,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,  375,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,  305,  395,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342, 
           -1,   -1,  345,   -1,  347,   -1,    0,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   10,  271,   -1,   -1, 
          363,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,  375,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,  305,  395,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   58,   59,   -1,   -1,    0,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   10,  271, 
           -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342,  281, 
          282,  345,   -1,  347,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,  363, 
           -1,   -1,   44,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  375,   -1,   -1,   -1,   -1,   58,   59,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  395,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1, 
          342,   -1,   -1,  345,   -1,  347,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,  363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,  375,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   44,   -1,  395,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   58,   59,   -1,   -1,   -1, 
           -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342, 
           -1,   -1,  345,   -1,  347,   -1,    0,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   10,  271,   -1,   -1, 
          363,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,  375,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           44,  305,  395,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   58,   59,   -1,   -1,    0,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   10,  271, 
           -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342,  281, 
          282,  345,   -1,  347,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,  363, 
           -1,   -1,   44,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  375,   -1,   -1,   -1,   -1,   -1,   59,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  395,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1, 
          342,   -1,   -1,  345,   -1,  347,   -1,    0,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   10,  271,   -1, 
           -1,  363,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,  375,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,  305,  395,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   58,   59,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342, 
           -1,   -1,  345,   -1,  347,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,   -1, 
          363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,   -1,  375,  267,  268,  269,   -1,  271,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           44,   -1,  395,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   58,   59,   -1,   -1,    0,   -1, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342,  281, 
          282,  345,   44,  347,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   59,   -1,  363, 
           -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  375,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,  395,   -1,   -1,   -1,   -1,   10,  339,   -1,   -1, 
          342,   -1,   -1,  345,   -1,  347,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,  363,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           44,   -1,   -1,  375,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,   -1,   59,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,  395,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,  339,   -1,   -1,  342, 
           -1,   -1,  345,   -1,  347,   -1,   -1,   -1,  262,  263, 
          264,   -1,   -1,  267,  268,  269,   -1,  271,   -1,   -1, 
          363,    0,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   10,  375,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,   59,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,  395,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           59,   -1,   -1,   -1,   -1,  339,   -1,   -1,  342,  281, 
          282,  345,   -1,  347,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,    0,   -1,  363, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,  375,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  395,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
          342,   -1,   -1,  345,   -1,  347,   10,   -1,  262,  263, 
          264,   -1,    0,  267,  268,  269,   59,  271,   -1,   -1, 
           -1,  363,   10,   -1,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  395,   -1,   59,   44,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  342,   -1, 
           -1,  345,   -1,  347,   -1,   -1,  262,  263,  264,   -1, 
            0,  267,  268,  269,   -1,  271,   -1,   -1,   -1,  363, 
           10,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,  262,  263,  264,   -1,    0,  267,  268, 
          269,  395,  271,   -1,   44,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   59, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  342,   -1,   -1,  345, 
           -1,  347,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   59,  363,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,  342,   -1,   -1,  345,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,  395, 
           -1,   -1,   -1,   -1,  363,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   59,  262,  263, 
          264,   -1,   -1,  267,  268,  269,  395,  271,   -1,   -1, 
           -1,   10,   -1,   -1,  262,  263,  264,  281,  282,  267, 
          268,  269,   -1,  271,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,  342, 
           -1,   -1,  345,   -1,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  342,   -1, 
           -1,  345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  339,  395,   -1,  342,   -1,   -1,   -1,   -1,  363, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,  363,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  395,   -1,  293,  294,  295,  296,  297,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,  395,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,   -1,  281,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,  339, 
           -1,   -1,  342,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,  363,   59,   -1,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  342, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  395,   91,   -1,   -1,   -1, 
          363,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,  395,  272,  273,  274,  275,  276,  277,  278, 
          342,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,  363,   -1,  302,  303,  304,   10,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  395,   -1,   -1,   -1,   -1,  337,   -1, 
           -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1,  348, 
           -1,  350,   -1,  352,   -1,   59,   -1,   -1,   -1,   -1, 
           -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   -1,   -1,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,  392,  393,  394,   -1,   -1,   -1,   -1, 
           -1,  256,  257,  258,  259,  260,  261,  262,  263,  264, 
          265,  266,   -1,   -1,  269,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,  280,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,  298,  299,   -1,  301,  302,  303,  304, 
           10,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  328,   -1,   -1,   -1,   -1,   -1,   -1, 
          335,  336,  337,   -1,   -1,  340,  341,   -1,  343,  344, 
           -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1,   59, 
           -1,   -1,  357,   -1,   -1,  360,   -1,  362,   -1,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,   -1,  374, 
           -1,  376,  377,   -1,  379,  380,  381,  382,   -1,   -1, 
           -1,   91,   -1,   -1,   -1,   -1,   -1,  392,  393,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  256,  257,  258,  259,  260,  261,  262,  263, 
          264,  265,  266,   -1,   -1,  269,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,  280,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302,  303, 
          304,   10,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   -1,   -1, 
           -1,  335,  336,  337,   -1,   -1,  340,  341,   -1,  343, 
          344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1, 
           59,   -1,   -1,  357,   -1,   -1,  360,   -1,  362,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
           -1,   -1,   91,   -1,   -1,   -1,   -1,   -1,  392,  393, 
           -1,   -1,   -1,   -1,   -1,   -1,  256,  257,  258,  259, 
          260,  261,  262,  263,  264,  265,  266,   -1,   -1,  269, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
          280,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299, 
           -1,  301,  302,  303,  304,   10,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  328,   -1, 
           -1,   -1,   -1,   -1,   -1,  335,  336,  337,   -1,   -1, 
          340,  341,   -1,  343,  344,   -1,  346,   -1,  348,   -1, 
           -1,   -1,  352,   -1,   59,   -1,   -1,  357,   -1,   -1, 
          360,   -1,  362,   -1,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,   -1,   -1,   91,   -1,   -1,   -1, 
           -1,   -1,  392,  393,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,  257,  258, 
          259,  260,  261,  262,  263,  264,  265,  266,   -1,   -1, 
          269,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   10,   -1,   -1,   -1,   -1,  298, 
          299,   -1,  301,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  328, 
           -1,   -1,   -1,   -1,   -1,   -1,  335,  336,  337,   -1, 
           -1,  340,  341,   59,  343,  344,   -1,  346,   -1,  348, 
           -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,  357,   -1, 
           -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  392,  393,   -1,   -1,   -1,   -1,   -1, 
           -1,  256,  257,  258,  259,  260,  261,  262,  263,  264, 
          265,  266,   -1,   -1,  269,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   10,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,  298,  299,   -1,  301,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  328,   -1,   -1,   -1,   -1,   -1,   -1, 
          335,  336,  337,   -1,   59,  340,   -1,   -1,  343,  344, 
           -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1,   -1, 
           -1,   -1,  357,   -1,   -1,  360,   -1,   -1,   -1,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,   -1,  374, 
           -1,  376,  377,   -1,  379,  380,  381,  382,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  392,  393,   -1, 
          256,  257,  258,  259,  260,  261,  262,  263,  264,  265, 
          266,   -1,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   10,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,  298,  299,   -1,  301,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  337,   -1,   59,  340,   -1,   -1,  343,  344,   -1, 
          346,   -1,  348,   -1,   -1,   -1,  352,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   -1, 
          376,  377,   -1,  379,  380,  381,  382,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  392,  393,   -1,   -1, 
           -1,  256,  257,  258,  259,  260,  261,  262,  263,  264, 
          265,  266,   -1,   -1,  269,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   10,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,  298,  299,   -1,  301,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   59,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344, 
           -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  360,   -1,  362,   -1,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,   -1,  374, 
           -1,  376,  377,   -1,  379,  380,  381,  382,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  392,  393,   -1, 
          256,  257,  258,  259,  260,  261,  262,  263,  264,  265, 
          266,   -1,   -1,  269,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   10,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,  298,  299,   -1,  301,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1, 
          346,   -1,  348,   -1,   -1,   -1,  352,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   -1, 
          376,  377,   -1,  379,  380,  381,  382,   -1,   -1,   -1, 
          256,  257,  258,  259,  260,  261,  392,  393,  264,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   10,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,  298,  299,   -1,  301,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1, 
          346,   -1,  348,   -1,   -1,   -1,  352,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   -1, 
          376,  377, 
      };
   }

   private static final short[] yyCheck4() {
      return new short[] {

           -1,  379,  380,  381,  382,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  392,  393,   -1,  256,  257,  258, 
          259,  260,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           10,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298, 
          299,   -1,  301,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1, 
           -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1,  348, 
           -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  360,   -1,   -1,  363,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   -1,   -1,   -1,   -1,  257,  258, 
          259,   -1,  261,  392,  393,   -1,  265,  266,   -1,   10, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1, 
           -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1,   -1, 
           -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   -1,   -1,   -1,  257,  258,  259, 
           -1,  261,   -1,  392,  393,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   59,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1, 
          340,   -1,  342,  343,  344,   -1,  346,   -1,   -1,   -1, 
           -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          360,   -1,   -1,   -1,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,   -1,   -1,  257,  258,  259,   -1, 
          261,   -1,  392,  393,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   59,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340, 
           -1,   -1,  343,  344,   -1,  346,   -1,   -1,   -1,   -1, 
           -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360, 
           -1,   -1,   -1,   -1,  365,  366,  367,  368,  369,  370, 
           -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379,  380, 
          381,  382,   -1,   -1,   -1,  257,  258,  259,  260,  261, 
           -1,  392,  393,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   63,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,  298,  299,  300,  301, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1, 
           -1,  343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1, 
          352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1, 
           -1,   -1,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,   -1,  374,   -1,  376,  377,   -1,  379,  380,  381, 
          382,   -1,   -1,   -1,  257,  258,  259,  260,  261,   -1, 
          392,  393,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  392, 
          393,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   -1,   -1,  333,  334,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  349,   -1,  351,   -1,  353,  354,  355, 
          356,  357,  358,  359,   -1,  361,  256,  257,  258,  259, 
          260,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299, 
          300,  301,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1, 
          340,   -1,   -1,  343,  344,   -1,  346,   -1,  348,   -1, 
           -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          360,   -1,   -1,   -1,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,   -1,  256,  257,  258,  259,  260, 
          261,   -1,  392,  393,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299,   -1, 
          301,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340, 
           -1,   -1,  343,  344,   -1,  346,   -1,  348,   -1,   -1, 
           -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360, 
           -1,   -1,   -1,   -1,  365,  366,  367,  368,  369,  370, 
           -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379,  380, 
          381,  382,   -1,   -1,  256,  257,  258,  259,  260,  261, 
           -1,  392,  393,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1, 
           -1,  343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1, 
          352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1, 
           -1,   -1,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,   -1,  374,   -1,  376,  377,   -1,  379,  380,  381, 
          382,   -1,   -1,   -1,  257,  258,  259,   -1,  261,   -1, 
          392,  393,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,  348,   -1,  350,   -1,  352, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261,  392, 
          393,  394,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,  348,   -1,  350,   -1,  352, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261,  392, 
          393,  394,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,  348,   -1,  350,   -1,  352, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261,  392, 
          393,  394,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261,  392, 
          393,  394,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,   -1,   -1,  350,   -1,  352, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261,  392, 
          393,  394,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261,  392, 
          393,  394,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1,  352, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,   -1,   -1,   -1,  257,  258,  259,  260,  261,  392, 
          393,  394,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,  300,  301,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,   -1,   -1,  257,  258,  259,  260,  261,   -1,  392, 
          393,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343, 
          344,   -1,  346,   -1,  348,   -1,   -1,   -1,  352,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
           -1,   -1,  257,  258,  259,   -1,  261,   -1,  392,  393, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  337,   -1,   -1,  340,  341,   -1,  343,  344, 
           -1,  346,   -1,   -1,   -1,   -1,   -1,  352,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,   -1,  374, 
           -1,  376,  377,   -1,  379,  380,  381,  382,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,   -1,  392,  393,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1, 
          346,   -1,  348,   -1,   -1,   -1,  352,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   -1, 
          376,  377,   -1,  379,  380,  381,  382,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,   -1,  392,  393,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346, 
           -1,  348,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   -1,   -1,   -1,  257, 
          258,  259,   -1,  261,   -1,  392,  393,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337, 
           -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1, 
          348,   -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367, 
          368,  369,  370,   -1,   -1,   -1,  374,   -1,  376,  377, 
           -1,  379,  380,  381,  382,   -1,   -1,   -1,  257,  258, 
          259,   -1,  261,   -1,  392,  393,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1, 
           -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1,  348, 
           -1,   -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  360,   -1,   -1,   -1,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   -1,   -1,   -1,  257,  258,  259, 
           -1,  261,   -1,  392,  393,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1, 
          340,   -1,   -1,  343,  344,   -1,  346,   -1,  348,   -1, 
           -1,   -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          360,   -1,   -1,   -1,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,   -1,   -1,  257,  258,  259,   -1, 
          261,   -1,  392,  393,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340, 
          341,   -1,  343,  344,   -1,  346,   -1,   -1,   -1,   -1, 
           -1,  352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360, 
           -1,   -1,   -1,   -1,  365,  366,  367,  368,  369,  370, 
           -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379,  380, 
          381,  382,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
           -1,  392,  393,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1, 
           -1,  343,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1, 
          352,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1, 
           -1,   -1,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,   -1,  374,   -1,  376,  377,   -1,  379,  380,  381, 
          382,   -1,   -1,   -1,  257,  258,  259,   -1,  261,   -1, 
          392,  393,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1, 
          343,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1,  352, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1, 
           -1,   -1,  365,  366,  367,  368,  369,  370,   -1,   -1, 
           -1,  374,   -1,  376,  377,   -1,  379,  380,  381,  382, 
           -1,   -1,   -1,  257,  258,  259,   -1,  261,   -1,  392, 
          393,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343, 
          344,   -1,  346,   -1,   -1,   -1,   -1,   -1,  352,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1, 
           -1,  365,  366,  367,  368,  369,  370,   -1,   -1,   -1, 
          374,   -1,  376,  377,   -1,  379,  380,  381,  382,   -1, 
           -1,   -1,  257,  258,  259,   -1,  261,   -1,  392,  393, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344, 
           -1,  346,   -1,   -1,   -1,   -1,   -1,  352,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  360,   -1,   -1,   -1,   -1, 
          365,  366,  367,  368,  369,  370,   -1,   -1,   -1,  374, 
           -1,  376,  377,   -1,  379,  380,  381,  382,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,   -1,  392,  393,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,   -1,   -1, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  333,   -1,   -1, 
           -1,  337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1, 
          346,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  365, 
          366,  367,  368,  369,  370,   -1,   -1,   -1,  374,   -1, 
          376,  377,   -1,  379,  380,  381,  382,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,   -1,  392,  393,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,   -1,   -1,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          337,   -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346, 
           -1,  348,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  365,  366, 
          367,  368,  369,  370,   -1,   -1,   -1,  374,   -1,  376, 
          377,   -1,  379,  380,  381,  382,   -1,   -1,   -1,  257, 
          258,  259,   -1,  261,   -1,  392,  393,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,   -1,   -1,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337, 
           -1,   -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1, 
          348,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  365,  366,  367, 
          368,  369,  370,   -1,   -1,   -1,  374,   -1,  376,  377, 
           -1,  379,  380,  381,  382,   -1,   -1,   -1,  257,  258, 
          259,   -1,  261,   -1,  392,  393,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,   -1,   -1,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1, 
           -1,  340,   -1,   -1,  343,  344,   -1,  346,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  365,  366,  367,  368, 
          369,  370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1, 
          379,  380,  381,  382,   -1,   -1,   -1,  257,  258,  259, 
           -1,  261,   -1,  392,  393,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,   -1,   -1,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1, 
          340,   -1,   -1,  343,  344,   -1,  346,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  365,  366,  367,  368,  369, 
          370,   -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379, 
          380,  381,  382,   -1,   -1,   -1,  257,  258,  259,   -1, 
          261,   -1,  392,  393,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,   -1,   -1,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340, 
           -1,   -1,  343,  344,   -1,  346,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  365,  366,  367,  368,  369,  370, 
           -1,   -1,   -1,  374,   -1,  376,  377,   -1,  379,  380, 
          381,  382,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
           -1,  392,  393,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  337,   -1,   -1,  340,   -1, 
           -1,  343,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  365,  366,  367,  368,  369,  370,   -1, 
           -1,   -1,  374,   -1,  376,  377,   -1,  379,  380,  381, 
          382,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          392,  393,  257,  258,  259,  260,  261,  262,  263,  264, 
          265,  266,  267,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,  279,  280,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,  298,  299,  300,  301,  302,  303,  304, 
           -1,  306,  307,  308,   -1,  310,   -1,   -1,   -1,  314, 
          315,   -1,  317,  318,  319,  320,  321,  322,  323,   -1, 
           -1,  326,  327,   -1,   -1,   -1,  331,  332,  333,  334, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  348,  349,   -1,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,   -1,   -1,  364, 
          365,  257,  258,  259,  260,  261,  262,  263,  264,  265, 
          266,  267,  268,  269,  270,  271,  272,  273,  274,  275, 
          276,  277,  278,  279,  280,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,  290,  291,  292,  293,  294,  295, 
          296,  297,  298,  299,  300,  301,  302,  303,  304,   -1, 
          306,  307,   -1,   -1,  310,   -1,   -1,   -1,  314,  315, 
           -1,  317,  318,  319,  320,  321,  322,  323,   -1,   -1, 
          326,  327,   -1,   -1,   -1,  331,  332,  333,  334,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  348,  349,   -1,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,  361,   -1,   -1,  364,  365, 
          257,  258,  259,  260,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,  279,  280,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,  298,  299,  300,  301,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,   -1,  314,  315,   -1, 
          317,  318,  319,  320,  321,  322,  323,   -1,   -1,  326, 
          327,   -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1, 
           -1,   -1,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1, 
           -1,  348,  349,   -1,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,   -1,   -1,  364,  257,  258, 
          259,  260,  261,  262,  263,  264,  265,  266,  267,  268, 
          269,  270,  271,  272,  273,  274,  275,  276,  277,  278, 
          279,  280,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,  290,  291,  292,  293,  294,  295,  296,  297,  298, 
          299,  300,  301,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,   -1,  314,  315,   -1,  317,  318, 
          319,  320,  321,  322,  323,   -1,   -1,  326,  327,   -1, 
           -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  348, 
          349,   -1,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,   -1,   -1,  364,  257,  258,  259,  260, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,  279,  280, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,  298,  299,  300, 
          301,  302,  303,  304,   -1,  306,  307,   -1,   -1,  310, 
           -1,   -1,   -1,  314,  315,   -1,  317,  318,  319,  320, 
          321,  322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1, 
          331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,   -1, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  306,  307,  364,   -1,  310,   -1,   -1,   -1,  314, 
          315,   -1,  317,  318,  319,  320,  321,  322,  323,   -1, 
           -1,  326,  327,   -1,   -1,   -1,  331,  332,  333,  334, 
           -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,   -1, 
           -1,   -1,   -1,  348,  349,   -1,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  306,  307,  364, 
           -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317,  318, 
          319,  320,  321,  322,  323,   -1,   -1,  326,  327,   -1, 
           -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1, 
           -1,   -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,  348, 
          349,   -1,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  306,  307,  364,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,  321,  322, 
          323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1, 
           -1,   -1,   -1,   -1,   -1,  348,  349,   -1,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  306, 
          307,  364,   -1,  310,   -1,   -1,   -1,  314,  315,   -1, 
          317,  318,  319,  320,  321,  322,  323,   -1,   -1,  326, 
          327,   -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1, 
           -1,   -1,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1, 
           -1,  348,  349,   -1,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,  306,  307,  364,   -1,  310, 
           -1,   -1,   -1,  314,  315,   -1,  317,  318,  319,  320, 
          321,  322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1, 
          331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1, 
          341,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,   -1, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  306,  307,  364,   -1,  310,   -1,   -1,   -1,  314, 
          315,   -1,  317,  318,  319,  320,  321,  322,  323,   -1, 
           -1,  326,  327,   -1,   -1,   -1,  331,  332,  333,  334, 
           -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,   -1, 
           -1,   -1,   -1,  348,  349,   -1,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  306,  307,  364, 
           -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317,  318, 
          319,  320,  321,  322,  323,   -1,   -1,  326,  327,   -1, 
           -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1, 
           -1,   -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,  348, 
          349,   -1,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  306,  307,  364,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,  321,  322, 
          323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,   -1,  341,   -1, 
           -1,   -1,   -1,   -1,   -1,  348,  349,   -1,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  306, 
          307,  364,   -1,  310,   -1,   -1,   -1,  314,  315,   -1, 
          317,  318,  319,  320,  321,  322,  323,   -1,   -1,  326, 
          327,   -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1, 
           -1,   -1,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1, 
           -1,  348,  349,   -1,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,  306,  307,  364,   -1,  310, 
           -1,   -1,   -1,  314,  315,   -1,  317,  318,  319,  320, 
          321,  322,  323,   -1,   -1,  326,  327,   -1,   -1,   -1, 
          331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1, 
          341,   -1,   -1,   -1,   -1,   -1,   -1,  348,  349,   -1, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  306,  307,  364,   -1,  310,   -1,   -1,   -1,  314, 
          315,   -1,  317,  318,  319,  320,  321,  322,  323,   -1, 
           -1,  326,  327,   -1,   -1,   -1,  331,  332,  333,  334, 
           -1,   -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,   -1, 
           -1,   -1,   -1,  348,  349,   -1,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  306,  307,  364, 
           -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317,  318, 
          319,  320,  321,  322,  323,   -1,   -1,  326,  327,   -1, 
           -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1, 
           -1,   -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,  348, 
          349,   -1,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,  361,  306,  307,  364,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,  321,  322, 
          323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  348,  349,   -1,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,   -1, 
           -1,  364, 
      };
   }

}
