# Tutorials

In this folder you find several tutorials both for the CNTK Python API, the Python Functional API, and for BrainScript. 

## Python

The Python Jupyter notebooks in this folder cover a range of different application including 
image classification, language understanding, reinforcement learning and others. 
Additionally, the folder NumpyInterop contains a simple example of how to use 
numpy arrays as input for CNTK training and evaluation.

### Functional API (still Python)

The FunctionalAPI folder is the staging area for Tutorials written using the Python Functional API. 
The plan is to have each Tutorial in this folder translated to a more succinct style in the FunctionalAPI folder.
All FunctionalAPI Tutorials are fully tested, same as the Tutorials here.


## BrainScript

There are four detailed tutorials on how to use CNTK with BrainScript. 
A step-by-step walk through for each of these is provided in the [documentation](https://docs.microsoft.com/en-us/cognitive-toolkit/Tutorials).

* Hello World - Logistic Regression ([Details](https://docs.microsoft.com/en-us/cognitive-toolkit/Tutorials))
* Image Hands On ([Details](https://docs.microsoft.com/en-us/cognitive-toolkit/Hands-On-Labs-Image-Recognition)) 
* SLU (Language Understanding) Hands On ([Details](https://docs.microsoft.com/en-us/cognitive-toolkit/Hands-On-Labs-Language-Understanding))
* Object detection using Fast R-CNN ([Code](https://github.com/Microsoft/CNTK/tree/master/Examples/Image/Detection/FastRCNN), [Details](https://docs.microsoft.com/en-us/cognitive-toolkit/Object-Detection-using-Fast-R-CNN))
