// Code generated by protoc-gen-go. DO NOT EDIT.
// source: routing/v1alpha1/route_rule.proto

package v1alpha1

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf "github.com/golang/protobuf/ptypes/any"
import google_protobuf1 "github.com/golang/protobuf/ptypes/duration"
import google_protobuf2 "github.com/golang/protobuf/ptypes/wrappers"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Route rule provides a custom routing policy based on the source and
// destination service versions and connection/request metadata.  The rule
// must provide a set of conditions for each protocol (TCP, UDP, HTTP) that
// the destination service exposes on its ports.
//
// The rule applies only to the ports on the destination service for which
// it provides protocol-specific match condition, e.g. if the rule does not
// specify TCP condition, the rule does not apply to TCP traffic towards
// the destination service.
//
// For example, a simple rule to send 100% of incoming traffic for a
// "reviews" service to version "v1" can be specified as follows:
//
//     metadata:
//       name: my-rule
//       namespace: default # optional (default is "default")
//     spec:
//       destination:
//         name: reviews
//         namespace: my-namespace # optional (default is metadata namespace field)
//       route:
//       - labels:
//           version: v1
//         weight: 100
//
type RouteRule struct {
	// REQUIRED: Destination uniquely identifies the destination associated
	// with this routing rule. This field is applicable for hostname-based
	// resolution for HTTP traffic as well as IP-based resolution for
	// TCP/UDP traffic.
	//
	// *Note:* The route rule destination specification represents all version
	// of the service and therefore the IstioService's labels field MUST be empty.
	//
	Destination *IstioService `protobuf:"bytes,1,opt,name=destination" json:"destination,omitempty"`
	// RECOMMENDED. Precedence is used to disambiguate the order of
	// application of rules for the same destination service. A higher number
	// takes priority. If not specified, the value is assumed to be 0.  The
	// order of application for rules with the same precedence is
	// unspecified.
	Precedence int32 `protobuf:"varint,2,opt,name=precedence" json:"precedence,omitempty"`
	// Match condtions to be satisfied for the route rule to be
	// activated. If match is omitted, the route rule applies only to HTTP
	// traffic.
	Match *MatchCondition `protobuf:"bytes,3,opt,name=match" json:"match,omitempty"`
	// REQUIRED (route|redirect). A routing rule can either redirect traffic or
	// forward traffic. The forwarding target can be one of several versions
	// of a service (see glossary in beginning of document). Weights
	// associated with the service version determine the proportion of
	// traffic it receives.
	Route []*DestinationWeight `protobuf:"bytes,4,rep,name=route" json:"route,omitempty"`
	// REQUIRED (route|redirect). A routing rule can either redirect traffic or
	// forward traffic. The redirect primitive can be used to send a HTTP 302
	// redirect to a different URI or Authority.
	Redirect *HTTPRedirect `protobuf:"bytes,5,opt,name=redirect" json:"redirect,omitempty"`
	// Rewrite HTTP URIs and Authority headers. Rewrite cannot be used with
	// Redirect primitive. Rewrite will be performed before forwarding.
	Rewrite *HTTPRewrite `protobuf:"bytes,6,opt,name=rewrite" json:"rewrite,omitempty"`
	// Indicates that a HTTP/1.1 client connection to this particular route
	// should be allowed (and expected) to upgrade to a WebSocket connection.
	// The default is false. Envoy expects the first request to this route
	// to contain the WebSocket upgrade headers. Otherwise, the request
	// will be rejected.
	WebsocketUpgrade bool `protobuf:"varint,7,opt,name=websocket_upgrade,json=websocketUpgrade" json:"websocket_upgrade,omitempty"`
	// Timeout policy for HTTP requests.
	HttpReqTimeout *HTTPTimeout `protobuf:"bytes,8,opt,name=http_req_timeout,json=httpReqTimeout" json:"http_req_timeout,omitempty"`
	// Retry policy for HTTP requests.
	HttpReqRetries *HTTPRetry `protobuf:"bytes,9,opt,name=http_req_retries,json=httpReqRetries" json:"http_req_retries,omitempty"`
	// Fault injection policy to apply on HTTP traffic
	HttpFault *HTTPFaultInjection `protobuf:"bytes,10,opt,name=http_fault,json=httpFault" json:"http_fault,omitempty"`
	// (-- L4 fault injection policy applies to Tcp/Udp (not HTTP) traffic --)
	L4Fault *L4FaultInjection `protobuf:"bytes,11,opt,name=l4_fault,json=l4Fault" json:"l4_fault,omitempty"`
	// Mirror HTTP traffic to a another destination in addition to forwarding
	// the requests to the intended destination. Mirrored traffic is on best
	// effort basis where Envoy will not wait for the mirrored cluster to
	// respond before returning the response from the original destination.
	// Statistics will be generated for the mirrored destination.
	Mirror *IstioService `protobuf:"bytes,12,opt,name=mirror" json:"mirror,omitempty"`
	// Cross-Origin Resource Sharing policy (CORS). Refer to
	// https://developer.mozilla.org/en-US/docs/Web/HTTP/Access_control_CORS for
	// further details about cross origin resource sharing.
	CorsPolicy *CorsPolicy `protobuf:"bytes,13,opt,name=cors_policy,json=corsPolicy" json:"cors_policy,omitempty"`
	// Additional HTTP headers to add before forwarding a request to the
	// destnation service.
	AppendHeaders map[string]string `protobuf:"bytes,14,rep,name=append_headers,json=appendHeaders" json:"append_headers,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *RouteRule) Reset()                    { *m = RouteRule{} }
func (m *RouteRule) String() string            { return proto.CompactTextString(m) }
func (*RouteRule) ProtoMessage()               {}
func (*RouteRule) Descriptor() ([]byte, []int) { return fileDescriptor5, []int{0} }

func (m *RouteRule) GetDestination() *IstioService {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (m *RouteRule) GetPrecedence() int32 {
	if m != nil {
		return m.Precedence
	}
	return 0
}

func (m *RouteRule) GetMatch() *MatchCondition {
	if m != nil {
		return m.Match
	}
	return nil
}

func (m *RouteRule) GetRoute() []*DestinationWeight {
	if m != nil {
		return m.Route
	}
	return nil
}

func (m *RouteRule) GetRedirect() *HTTPRedirect {
	if m != nil {
		return m.Redirect
	}
	return nil
}

func (m *RouteRule) GetRewrite() *HTTPRewrite {
	if m != nil {
		return m.Rewrite
	}
	return nil
}

func (m *RouteRule) GetWebsocketUpgrade() bool {
	if m != nil {
		return m.WebsocketUpgrade
	}
	return false
}

func (m *RouteRule) GetHttpReqTimeout() *HTTPTimeout {
	if m != nil {
		return m.HttpReqTimeout
	}
	return nil
}

func (m *RouteRule) GetHttpReqRetries() *HTTPRetry {
	if m != nil {
		return m.HttpReqRetries
	}
	return nil
}

func (m *RouteRule) GetHttpFault() *HTTPFaultInjection {
	if m != nil {
		return m.HttpFault
	}
	return nil
}

func (m *RouteRule) GetL4Fault() *L4FaultInjection {
	if m != nil {
		return m.L4Fault
	}
	return nil
}

func (m *RouteRule) GetMirror() *IstioService {
	if m != nil {
		return m.Mirror
	}
	return nil
}

func (m *RouteRule) GetCorsPolicy() *CorsPolicy {
	if m != nil {
		return m.CorsPolicy
	}
	return nil
}

func (m *RouteRule) GetAppendHeaders() map[string]string {
	if m != nil {
		return m.AppendHeaders
	}
	return nil
}

// IstioService identifies a service and optionally service version.
// The FQDN of the service is composed from the name, namespace, and implementation-specific domain suffix
// (e.g. on Kubernetes, "reviews" + "default" + "svc.cluster.local" -> "reviews.default.svc.cluster.local").
type IstioService struct {
	// The short name of the service such as "foo".
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// Optional namespace of the service. Defaults to value of metadata namespace field.
	Namespace string `protobuf:"bytes,2,opt,name=namespace" json:"namespace,omitempty"`
	// Domain suffix used to construct the service FQDN in implementations that support such specification.
	Domain string `protobuf:"bytes,3,opt,name=domain" json:"domain,omitempty"`
	// The service FQDN.
	Service string `protobuf:"bytes,4,opt,name=service" json:"service,omitempty"`
	// Optional one or more labels that uniquely identify the service version.
	//
	// *Note:* When used for a RouteRule destination, labels MUST be empty.
	//
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *IstioService) Reset()                    { *m = IstioService{} }
func (m *IstioService) String() string            { return proto.CompactTextString(m) }
func (*IstioService) ProtoMessage()               {}
func (*IstioService) Descriptor() ([]byte, []int) { return fileDescriptor5, []int{1} }

func (m *IstioService) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *IstioService) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

func (m *IstioService) GetDomain() string {
	if m != nil {
		return m.Domain
	}
	return ""
}

func (m *IstioService) GetService() string {
	if m != nil {
		return m.Service
	}
	return ""
}

func (m *IstioService) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

// Match condition specifies a set of criterion to be met in order for the
// route rule to be applied to the connection or HTTP request. The
// condition provides distinct set of conditions for each protocol with the
// intention that conditions apply only to the service ports that match the
// protocol. For example, the following route rule restricts the rule to
// match only requests originating from "reviews:v2", accessing ratings
// service where the URL path starts with /ratings/v2/ and the request
// contains a "cookie" with value "user=jason",
//
//     metadata:
//       name: my-rule
//       namespace: default
//     spec:
//       destination:
//         name: ratings
//       match:
//         source:
//           name: reviews
//           labels:
//             version: v2
//         request:
//           headers:
//             cookie:
//               regex: "^(.*?;)?(user=jason)(;.*)?"
//             uri:
//               prefix: "/ratings/v2/"
//
// MatchCondition CANNOT be empty. At least one source or
// request header must be specified.
type MatchCondition struct {
	// Identifies the service initiating a connection or a request.
	Source *IstioService `protobuf:"bytes,1,opt,name=source" json:"source,omitempty"`
	// (-- Set of layer 4 match conditions based on the IP ranges --)
	Tcp *L4MatchAttributes `protobuf:"bytes,2,opt,name=tcp" json:"tcp,omitempty"`
	// (-- Set of layer 4 match conditions based on the IP ranges --)
	Udp *L4MatchAttributes `protobuf:"bytes,3,opt,name=udp" json:"udp,omitempty"`
	// Attributes of an HTTP request to match.
	Request *MatchRequest `protobuf:"bytes,4,opt,name=request" json:"request,omitempty"`
}

func (m *MatchCondition) Reset()                    { *m = MatchCondition{} }
func (m *MatchCondition) String() string            { return proto.CompactTextString(m) }
func (*MatchCondition) ProtoMessage()               {}
func (*MatchCondition) Descriptor() ([]byte, []int) { return fileDescriptor5, []int{2} }

func (m *MatchCondition) GetSource() *IstioService {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *MatchCondition) GetTcp() *L4MatchAttributes {
	if m != nil {
		return m.Tcp
	}
	return nil
}

func (m *MatchCondition) GetUdp() *L4MatchAttributes {
	if m != nil {
		return m.Udp
	}
	return nil
}

func (m *MatchCondition) GetRequest() *MatchRequest {
	if m != nil {
		return m.Request
	}
	return nil
}

// MatchRequest specifies the attributes of an HTTP request to be used for matching a request.
type MatchRequest struct {
	// Set of HTTP match conditions based on HTTP/1.1, HTTP/2, GRPC request
	// metadata, such as _uri_, _scheme_, _authority_.  The header keys must be
	// lowercase and use hyphen as the separator, e.g. _x-request-id_.
	//
	// Header values are case-sensitive and formatted as follows:
	//
	// *exact: "value"* or just *"value"* for exact string match
	//
	// *prefix: "value"* for prefix-based match
	//
	// *regex: "value"* for ECMAscript style regex-based match
	//
	// *Note 1:* The keys _uri_, _scheme_, _method_, and _authority_ correspond
	// to URI, protocol scheme (e.g., HTTP, HTTPS), HTTP method
	// (e.g., GET, POST), and the HTTP Host header respectively.
	//
	// *Note 2:* _uri_ can be used to perform URL matches.
	// For all HTTP headers including _uri_, exact, prefix and ECMA style
	// regular expression matches are supported.
	Headers map[string]*StringMatch `protobuf:"bytes,1,rep,name=headers" json:"headers,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *MatchRequest) Reset()                    { *m = MatchRequest{} }
func (m *MatchRequest) String() string            { return proto.CompactTextString(m) }
func (*MatchRequest) ProtoMessage()               {}
func (*MatchRequest) Descriptor() ([]byte, []int) { return fileDescriptor5, []int{3} }

func (m *MatchRequest) GetHeaders() map[string]*StringMatch {
	if m != nil {
		return m.Headers
	}
	return nil
}

// Each routing rule is associated with one or more service versions (see
// glossary in beginning of document). Weights associated with the version
// determine the proportion of traffic it receives. For example, the
// following rule will route 25% of traffic for the "reviews" service to
// instances with the "v2" tag and the remaining traffic (i.e., 75%) to
// "v1".
//
//     metadata:
//       name: my-rule
//       namespace: default
//     spec:
//       destination:
//         name: reviews
//       route:
//       - labels:
//           version: v2
//         weight: 25
//       - labels:
//           version: v1
//         weight: 75
//
type DestinationWeight struct {
	// Sometimes required. Optional destination uniquely identifies the destination service. If not
	// specified, the value is inherited from the parent route rule.
	Destination *IstioService `protobuf:"bytes,1,opt,name=destination" json:"destination,omitempty"`
	// Sometimes required. Service version identifier for the destination service.
	// (-- N.B. The map is used instead of pstruct due to lack of serialization support
	// in golang protobuf library (see https://github.com/golang/protobuf/pull/208) --)
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// REQUIRED. The proportion of traffic to be forwarded to the service
	// version. (0-100). Sum of weights across destinations SHOULD BE ==
	// 100. If there is only destination in a rule, the weight value is
	// assumed to be 100. When using multiple weights, either destination or labels must be
	// specified.
	Weight int32 `protobuf:"varint,3,opt,name=weight" json:"weight,omitempty"`
}

func (m *DestinationWeight) Reset()                    { *m = DestinationWeight{} }
func (m *DestinationWeight) String() string            { return proto.CompactTextString(m) }
func (*DestinationWeight) ProtoMessage()               {}
func (*DestinationWeight) Descriptor() ([]byte, []int) { return fileDescriptor5, []int{4} }

func (m *DestinationWeight) GetDestination() *IstioService {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (m *DestinationWeight) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *DestinationWeight) GetWeight() int32 {
	if m != nil {
		return m.Weight
	}
	return 0
}

// (-- L4 connection match attributes. Note that L4 connection matching
// support is incomplete. --)
type L4MatchAttributes struct {
	// IPv4 or IPv6 ip address with optional subnet. E.g., a.b.c.d/xx form or
	// just a.b.c.d
	SourceSubnet []string `protobuf:"bytes,1,rep,name=source_subnet,json=sourceSubnet" json:"source_subnet,omitempty"`
	// IPv4 or IPv6 ip address of destination with optional subnet.
	// E.g., a.b.c.d/xx form or just a.b.c.d. This is only valid when the destination
	// service has several IPs and the application explicitly specifies a particular IP.
	DestinationSubnet []string `protobuf:"bytes,2,rep,name=destination_subnet,json=destinationSubnet" json:"destination_subnet,omitempty"`
}

func (m *L4MatchAttributes) Reset()                    { *m = L4MatchAttributes{} }
func (m *L4MatchAttributes) String() string            { return proto.CompactTextString(m) }
func (*L4MatchAttributes) ProtoMessage()               {}
func (*L4MatchAttributes) Descriptor() ([]byte, []int) { return fileDescriptor5, []int{5} }

func (m *L4MatchAttributes) GetSourceSubnet() []string {
	if m != nil {
		return m.SourceSubnet
	}
	return nil
}

func (m *L4MatchAttributes) GetDestinationSubnet() []string {
	if m != nil {
		return m.DestinationSubnet
	}
	return nil
}

// HTTPRedirect can be used to send a 302 redirect response to the caller,
// where the Authority/Host and the URI in the response can be swapped with
// the specified values. For example, the following route rule redirects
// requests for /v1/getProductRatings API on the ratings service to
// /v1/bookRatings provided by the bookratings service.
//
//     metadata:
//       name: my-rule
//       namespace: default
//     spec:
//       destination:
//         name: ratings
//       match:
//         request:
//           headers:
//             uri: /v1/getProductRatings
//       redirect:
//         uri: /v1/bookRatings
//         authority: bookratings.default.svc.cluster.local
//
type HTTPRedirect struct {
	// On a redirect, overwrite the Path portion of the URL with this
	// value. Note that the entire path will be replaced, irrespective of the
	// request URI being matched as an exact path or prefix.
	Uri string `protobuf:"bytes,1,opt,name=uri" json:"uri,omitempty"`
	// On a redirect, overwrite the Authority/Host portion of the URL with
	// this value
	Authority string `protobuf:"bytes,2,opt,name=authority" json:"authority,omitempty"`
}

func (m *HTTPRedirect) Reset()                    { *m = HTTPRedirect{} }
func (m *HTTPRedirect) String() string            { return proto.CompactTextString(m) }
func (*HTTPRedirect) ProtoMessage()               {}
func (*HTTPRedirect) Descriptor() ([]byte, []int) { return fileDescriptor5, []int{6} }

func (m *HTTPRedirect) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

func (m *HTTPRedirect) GetAuthority() string {
	if m != nil {
		return m.Authority
	}
	return ""
}

// HTTPRewrite can be used to rewrite specific parts of a HTTP request
// before forwarding the request to the destination. Rewrite primitive can
// be used only with the DestinationWeights. The following example
// demonstrates how to rewrite the URL prefix for api call (/ratings) to
// ratings service before making the actual API call.
//
//     metadata:
//       name: my-rule
//       namespace: default
//     spec:
//       destination:
//         name: ratings
//       match:
//         request:
//           headers:
//             uri:
//               prefix: /ratings
//       rewrite:
//         uri: /v1/bookRatings
//       route:
//       - labels:
//           version: v1
//
type HTTPRewrite struct {
	// rewrite the Path (or the prefix) portion of the URI with this
	// value. If the original URI was matched based on prefix, the value
	// provided in this field will replace the corresponding matched prefix.
	Uri string `protobuf:"bytes,1,opt,name=uri" json:"uri,omitempty"`
	// rewrite the Authority/Host header with this value.
	Authority string `protobuf:"bytes,2,opt,name=authority" json:"authority,omitempty"`
}

func (m *HTTPRewrite) Reset()                    { *m = HTTPRewrite{} }
func (m *HTTPRewrite) String() string            { return proto.CompactTextString(m) }
func (*HTTPRewrite) ProtoMessage()               {}
func (*HTTPRewrite) Descriptor() ([]byte, []int) { return fileDescriptor5, []int{7} }

func (m *HTTPRewrite) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

func (m *HTTPRewrite) GetAuthority() string {
	if m != nil {
		return m.Authority
	}
	return ""
}

// Describes how to match a given string in HTTP headers. Match is case-sensitive.
type StringMatch struct {
	// Types that are valid to be assigned to MatchType:
	//	*StringMatch_Exact
	//	*StringMatch_Prefix
	//	*StringMatch_Regex
	MatchType isStringMatch_MatchType `protobuf_oneof:"match_type"`
}

func (m *StringMatch) Reset()                    { *m = StringMatch{} }
func (m *StringMatch) String() string            { return proto.CompactTextString(m) }
func (*StringMatch) ProtoMessage()               {}
func (*StringMatch) Descriptor() ([]byte, []int) { return fileDescriptor5, []int{8} }

type isStringMatch_MatchType interface {
	isStringMatch_MatchType()
}

type StringMatch_Exact struct {
	Exact string `protobuf:"bytes,1,opt,name=exact,oneof"`
}
type StringMatch_Prefix struct {
	Prefix string `protobuf:"bytes,2,opt,name=prefix,oneof"`
}
type StringMatch_Regex struct {
	Regex string `protobuf:"bytes,3,opt,name=regex,oneof"`
}

func (*StringMatch_Exact) isStringMatch_MatchType()  {}
func (*StringMatch_Prefix) isStringMatch_MatchType() {}
func (*StringMatch_Regex) isStringMatch_MatchType()  {}

func (m *StringMatch) GetMatchType() isStringMatch_MatchType {
	if m != nil {
		return m.MatchType
	}
	return nil
}

func (m *StringMatch) GetExact() string {
	if x, ok := m.GetMatchType().(*StringMatch_Exact); ok {
		return x.Exact
	}
	return ""
}

func (m *StringMatch) GetPrefix() string {
	if x, ok := m.GetMatchType().(*StringMatch_Prefix); ok {
		return x.Prefix
	}
	return ""
}

func (m *StringMatch) GetRegex() string {
	if x, ok := m.GetMatchType().(*StringMatch_Regex); ok {
		return x.Regex
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*StringMatch) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _StringMatch_OneofMarshaler, _StringMatch_OneofUnmarshaler, _StringMatch_OneofSizer, []interface{}{
		(*StringMatch_Exact)(nil),
		(*StringMatch_Prefix)(nil),
		(*StringMatch_Regex)(nil),
	}
}

func _StringMatch_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*StringMatch)
	// match_type
	switch x := m.MatchType.(type) {
	case *StringMatch_Exact:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Exact)
	case *StringMatch_Prefix:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Prefix)
	case *StringMatch_Regex:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Regex)
	case nil:
	default:
		return fmt.Errorf("StringMatch.MatchType has unexpected type %T", x)
	}
	return nil
}

func _StringMatch_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*StringMatch)
	switch tag {
	case 1: // match_type.exact
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.MatchType = &StringMatch_Exact{x}
		return true, err
	case 2: // match_type.prefix
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.MatchType = &StringMatch_Prefix{x}
		return true, err
	case 3: // match_type.regex
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.MatchType = &StringMatch_Regex{x}
		return true, err
	default:
		return false, nil
	}
}

func _StringMatch_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*StringMatch)
	// match_type
	switch x := m.MatchType.(type) {
	case *StringMatch_Exact:
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Exact)))
		n += len(x.Exact)
	case *StringMatch_Prefix:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Prefix)))
		n += len(x.Prefix)
	case *StringMatch_Regex:
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Regex)))
		n += len(x.Regex)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Describes HTTP request timeout. For example, the following rule sets a
// 10 second timeout for calls to the ratings:v1 service
//
//     metadata:
//       name: my-rule
//       namespace: default
//     spec:
//       destination:
//         name: ratings
//       route:
//       - labels:
//           version: v1
//       httpReqTimeout:
//         simpleTimeout:
//           timeout: 10s
//
type HTTPTimeout struct {
	// Types that are valid to be assigned to TimeoutPolicy:
	//	*HTTPTimeout_SimpleTimeout
	//	*HTTPTimeout_Custom
	TimeoutPolicy isHTTPTimeout_TimeoutPolicy `protobuf_oneof:"timeout_policy"`
}

func (m *HTTPTimeout) Reset()                    { *m = HTTPTimeout{} }
func (m *HTTPTimeout) String() string            { return proto.CompactTextString(m) }
func (*HTTPTimeout) ProtoMessage()               {}
func (*HTTPTimeout) Descriptor() ([]byte, []int) { return fileDescriptor5, []int{9} }

type isHTTPTimeout_TimeoutPolicy interface {
	isHTTPTimeout_TimeoutPolicy()
}

type HTTPTimeout_SimpleTimeout struct {
	SimpleTimeout *HTTPTimeout_SimpleTimeoutPolicy `protobuf:"bytes,1,opt,name=simple_timeout,json=simpleTimeout,oneof"`
}
type HTTPTimeout_Custom struct {
	Custom *google_protobuf.Any `protobuf:"bytes,2,opt,name=custom,oneof"`
}

func (*HTTPTimeout_SimpleTimeout) isHTTPTimeout_TimeoutPolicy() {}
func (*HTTPTimeout_Custom) isHTTPTimeout_TimeoutPolicy()        {}

func (m *HTTPTimeout) GetTimeoutPolicy() isHTTPTimeout_TimeoutPolicy {
	if m != nil {
		return m.TimeoutPolicy
	}
	return nil
}

func (m *HTTPTimeout) GetSimpleTimeout() *HTTPTimeout_SimpleTimeoutPolicy {
	if x, ok := m.GetTimeoutPolicy().(*HTTPTimeout_SimpleTimeout); ok {
		return x.SimpleTimeout
	}
	return nil
}

func (m *HTTPTimeout) GetCustom() *google_protobuf.Any {
	if x, ok := m.GetTimeoutPolicy().(*HTTPTimeout_Custom); ok {
		return x.Custom
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*HTTPTimeout) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _HTTPTimeout_OneofMarshaler, _HTTPTimeout_OneofUnmarshaler, _HTTPTimeout_OneofSizer, []interface{}{
		(*HTTPTimeout_SimpleTimeout)(nil),
		(*HTTPTimeout_Custom)(nil),
	}
}

func _HTTPTimeout_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*HTTPTimeout)
	// timeout_policy
	switch x := m.TimeoutPolicy.(type) {
	case *HTTPTimeout_SimpleTimeout:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SimpleTimeout); err != nil {
			return err
		}
	case *HTTPTimeout_Custom:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Custom); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("HTTPTimeout.TimeoutPolicy has unexpected type %T", x)
	}
	return nil
}

func _HTTPTimeout_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*HTTPTimeout)
	switch tag {
	case 1: // timeout_policy.simple_timeout
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(HTTPTimeout_SimpleTimeoutPolicy)
		err := b.DecodeMessage(msg)
		m.TimeoutPolicy = &HTTPTimeout_SimpleTimeout{msg}
		return true, err
	case 2: // timeout_policy.custom
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(google_protobuf.Any)
		err := b.DecodeMessage(msg)
		m.TimeoutPolicy = &HTTPTimeout_Custom{msg}
		return true, err
	default:
		return false, nil
	}
}

func _HTTPTimeout_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*HTTPTimeout)
	// timeout_policy
	switch x := m.TimeoutPolicy.(type) {
	case *HTTPTimeout_SimpleTimeout:
		s := proto.Size(x.SimpleTimeout)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *HTTPTimeout_Custom:
		s := proto.Size(x.Custom)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type HTTPTimeout_SimpleTimeoutPolicy struct {
	// REQUIRED. Timeout for a HTTP request. Includes retries as well.  Default
	// 15s. format: 1h/1m/1s/1ms. MUST BE >=1ms. It is possible to control
	// timeout per request by supplying the timeout value via
	// x-envoy-upstream-rq-timeout-ms HTTP header.
	Timeout *google_protobuf1.Duration `protobuf:"bytes,1,opt,name=timeout" json:"timeout,omitempty"`
	// (-- Downstream service could specify timeout via Http header to
	// Envoy, if Envoy supports such a feature. --)
	OverrideHeaderName string `protobuf:"bytes,2,opt,name=override_header_name,json=overrideHeaderName" json:"override_header_name,omitempty"`
}

func (m *HTTPTimeout_SimpleTimeoutPolicy) Reset()         { *m = HTTPTimeout_SimpleTimeoutPolicy{} }
func (m *HTTPTimeout_SimpleTimeoutPolicy) String() string { return proto.CompactTextString(m) }
func (*HTTPTimeout_SimpleTimeoutPolicy) ProtoMessage()    {}
func (*HTTPTimeout_SimpleTimeoutPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor5, []int{9, 0}
}

func (m *HTTPTimeout_SimpleTimeoutPolicy) GetTimeout() *google_protobuf1.Duration {
	if m != nil {
		return m.Timeout
	}
	return nil
}

func (m *HTTPTimeout_SimpleTimeoutPolicy) GetOverrideHeaderName() string {
	if m != nil {
		return m.OverrideHeaderName
	}
	return ""
}

// Describes the retry policy to use when a HTTP request fails. For
// example, the following rule sets the maximum number of retries to 3 when
// calling ratings:v1 service, with a 2s timeout per retry attempt.
//
//     metadata:
//       name: my-rule
//       namespace: default
//     spec:
//       destination:
//         name: ratings
//       route:
//       - labels:
//           version: v1
//       httpReqRetries:
//         simpleRetry:
//           attempts: 3
//           perTryTimeout: 2s
//
type HTTPRetry struct {
	// Types that are valid to be assigned to RetryPolicy:
	//	*HTTPRetry_SimpleRetry
	//	*HTTPRetry_Custom
	RetryPolicy isHTTPRetry_RetryPolicy `protobuf_oneof:"retry_policy"`
}

func (m *HTTPRetry) Reset()                    { *m = HTTPRetry{} }
func (m *HTTPRetry) String() string            { return proto.CompactTextString(m) }
func (*HTTPRetry) ProtoMessage()               {}
func (*HTTPRetry) Descriptor() ([]byte, []int) { return fileDescriptor5, []int{10} }

type isHTTPRetry_RetryPolicy interface {
	isHTTPRetry_RetryPolicy()
}

type HTTPRetry_SimpleRetry struct {
	SimpleRetry *HTTPRetry_SimpleRetryPolicy `protobuf:"bytes,1,opt,name=simple_retry,json=simpleRetry,oneof"`
}
type HTTPRetry_Custom struct {
	Custom *google_protobuf.Any `protobuf:"bytes,2,opt,name=custom,oneof"`
}

func (*HTTPRetry_SimpleRetry) isHTTPRetry_RetryPolicy() {}
func (*HTTPRetry_Custom) isHTTPRetry_RetryPolicy()      {}

func (m *HTTPRetry) GetRetryPolicy() isHTTPRetry_RetryPolicy {
	if m != nil {
		return m.RetryPolicy
	}
	return nil
}

func (m *HTTPRetry) GetSimpleRetry() *HTTPRetry_SimpleRetryPolicy {
	if x, ok := m.GetRetryPolicy().(*HTTPRetry_SimpleRetry); ok {
		return x.SimpleRetry
	}
	return nil
}

func (m *HTTPRetry) GetCustom() *google_protobuf.Any {
	if x, ok := m.GetRetryPolicy().(*HTTPRetry_Custom); ok {
		return x.Custom
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*HTTPRetry) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _HTTPRetry_OneofMarshaler, _HTTPRetry_OneofUnmarshaler, _HTTPRetry_OneofSizer, []interface{}{
		(*HTTPRetry_SimpleRetry)(nil),
		(*HTTPRetry_Custom)(nil),
	}
}

func _HTTPRetry_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*HTTPRetry)
	// retry_policy
	switch x := m.RetryPolicy.(type) {
	case *HTTPRetry_SimpleRetry:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SimpleRetry); err != nil {
			return err
		}
	case *HTTPRetry_Custom:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Custom); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("HTTPRetry.RetryPolicy has unexpected type %T", x)
	}
	return nil
}

func _HTTPRetry_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*HTTPRetry)
	switch tag {
	case 1: // retry_policy.simple_retry
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(HTTPRetry_SimpleRetryPolicy)
		err := b.DecodeMessage(msg)
		m.RetryPolicy = &HTTPRetry_SimpleRetry{msg}
		return true, err
	case 2: // retry_policy.custom
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(google_protobuf.Any)
		err := b.DecodeMessage(msg)
		m.RetryPolicy = &HTTPRetry_Custom{msg}
		return true, err
	default:
		return false, nil
	}
}

func _HTTPRetry_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*HTTPRetry)
	// retry_policy
	switch x := m.RetryPolicy.(type) {
	case *HTTPRetry_SimpleRetry:
		s := proto.Size(x.SimpleRetry)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *HTTPRetry_Custom:
		s := proto.Size(x.Custom)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type HTTPRetry_SimpleRetryPolicy struct {
	// REQUIRED. Number of retries for a given request. The interval
	// between retries will be determined automatically (25ms+). Actual
	// number of retries attempted depends on the httpReqTimeout.
	Attempts int32 `protobuf:"varint,1,opt,name=attempts" json:"attempts,omitempty"`
	// Timeout per retry attempt for a given request. format: 1h/1m/1s/1ms. MUST BE >=1ms.
	PerTryTimeout *google_protobuf1.Duration `protobuf:"bytes,2,opt,name=per_try_timeout,json=perTryTimeout" json:"per_try_timeout,omitempty"`
	// (-- Downstream Service could specify retry attempts via Http header to
	// Envoy, if Envoy supports such a feature. --)
	OverrideHeaderName string `protobuf:"bytes,3,opt,name=override_header_name,json=overrideHeaderName" json:"override_header_name,omitempty"`
}

func (m *HTTPRetry_SimpleRetryPolicy) Reset()                    { *m = HTTPRetry_SimpleRetryPolicy{} }
func (m *HTTPRetry_SimpleRetryPolicy) String() string            { return proto.CompactTextString(m) }
func (*HTTPRetry_SimpleRetryPolicy) ProtoMessage()               {}
func (*HTTPRetry_SimpleRetryPolicy) Descriptor() ([]byte, []int) { return fileDescriptor5, []int{10, 0} }

func (m *HTTPRetry_SimpleRetryPolicy) GetAttempts() int32 {
	if m != nil {
		return m.Attempts
	}
	return 0
}

func (m *HTTPRetry_SimpleRetryPolicy) GetPerTryTimeout() *google_protobuf1.Duration {
	if m != nil {
		return m.PerTryTimeout
	}
	return nil
}

func (m *HTTPRetry_SimpleRetryPolicy) GetOverrideHeaderName() string {
	if m != nil {
		return m.OverrideHeaderName
	}
	return ""
}

// Describes the Cross-Origin Resource Sharing (CORS) policy, for a given
// service. Refer to
// https://developer.mozilla.org/en-US/docs/Web/HTTP/Access_control_CORS
// for further details about cross origin resource sharing. For example,
// the following rule restricts cross origin requests to those originating
// from example.com domain using HTTP POST/GET, and sets the
// Access-Control-Allow-Credentials header to false. In addition, it only exposes
// X-Foo-bar header and sets an expiry period of 1 day.
//
//     metadata:
//       name: my-rule
//       namespace: default
//     spec:
//       destination:
//         name: ratings
//       route:
//       - labels:
//           version: v1
//       corsPolicy:
//         allowOrigin:
//         - example.com
//         allowMethods:
//         - POST
//         - GET
//         allowCredentials: false
//         allowHeaders:
//         - X-Foo-Bar
//         maxAge: "1d"
//
type CorsPolicy struct {
	// The list of origins that are allowed to perform CORS requests. The content will
	// be serialized into the Access-Control-Allow-Origin header. Wildcard * will allow
	// all origins.
	AllowOrigin []string `protobuf:"bytes,1,rep,name=allow_origin,json=allowOrigin" json:"allow_origin,omitempty"`
	// List of HTTP methods allowed to access the resource. The content will
	// be serialized into the Access-Control-Allow-Methods header.
	AllowMethods []string `protobuf:"bytes,2,rep,name=allow_methods,json=allowMethods" json:"allow_methods,omitempty"`
	// List of HTTP headers that can be used when requesting the
	// resource. Serialized to Access-Control-Allow-Methods header.
	AllowHeaders []string `protobuf:"bytes,3,rep,name=allow_headers,json=allowHeaders" json:"allow_headers,omitempty"`
	// A white list of HTTP headers that the browsers are allowed to
	// access. Serialized into Access-Control-Expose-Headers header.
	ExposeHeaders []string `protobuf:"bytes,4,rep,name=expose_headers,json=exposeHeaders" json:"expose_headers,omitempty"`
	// Specifies how long the the results of a preflight request can be
	// cached. Translates to the Access-Control-Max-Age header.
	MaxAge *google_protobuf1.Duration `protobuf:"bytes,5,opt,name=max_age,json=maxAge" json:"max_age,omitempty"`
	// Indicates whether the caller is allowed to send the actual request
	// (not the preflight) using credentials. Translates to
	// Access-Control-Allow-Credentials header.
	AllowCredentials *google_protobuf2.BoolValue `protobuf:"bytes,6,opt,name=allow_credentials,json=allowCredentials" json:"allow_credentials,omitempty"`
}

func (m *CorsPolicy) Reset()                    { *m = CorsPolicy{} }
func (m *CorsPolicy) String() string            { return proto.CompactTextString(m) }
func (*CorsPolicy) ProtoMessage()               {}
func (*CorsPolicy) Descriptor() ([]byte, []int) { return fileDescriptor5, []int{11} }

func (m *CorsPolicy) GetAllowOrigin() []string {
	if m != nil {
		return m.AllowOrigin
	}
	return nil
}

func (m *CorsPolicy) GetAllowMethods() []string {
	if m != nil {
		return m.AllowMethods
	}
	return nil
}

func (m *CorsPolicy) GetAllowHeaders() []string {
	if m != nil {
		return m.AllowHeaders
	}
	return nil
}

func (m *CorsPolicy) GetExposeHeaders() []string {
	if m != nil {
		return m.ExposeHeaders
	}
	return nil
}

func (m *CorsPolicy) GetMaxAge() *google_protobuf1.Duration {
	if m != nil {
		return m.MaxAge
	}
	return nil
}

func (m *CorsPolicy) GetAllowCredentials() *google_protobuf2.BoolValue {
	if m != nil {
		return m.AllowCredentials
	}
	return nil
}

func init() {
	proto.RegisterType((*RouteRule)(nil), "istio.routing.v1alpha1.RouteRule")
	proto.RegisterType((*IstioService)(nil), "istio.routing.v1alpha1.IstioService")
	proto.RegisterType((*MatchCondition)(nil), "istio.routing.v1alpha1.MatchCondition")
	proto.RegisterType((*MatchRequest)(nil), "istio.routing.v1alpha1.MatchRequest")
	proto.RegisterType((*DestinationWeight)(nil), "istio.routing.v1alpha1.DestinationWeight")
	proto.RegisterType((*L4MatchAttributes)(nil), "istio.routing.v1alpha1.L4MatchAttributes")
	proto.RegisterType((*HTTPRedirect)(nil), "istio.routing.v1alpha1.HTTPRedirect")
	proto.RegisterType((*HTTPRewrite)(nil), "istio.routing.v1alpha1.HTTPRewrite")
	proto.RegisterType((*StringMatch)(nil), "istio.routing.v1alpha1.StringMatch")
	proto.RegisterType((*HTTPTimeout)(nil), "istio.routing.v1alpha1.HTTPTimeout")
	proto.RegisterType((*HTTPTimeout_SimpleTimeoutPolicy)(nil), "istio.routing.v1alpha1.HTTPTimeout.SimpleTimeoutPolicy")
	proto.RegisterType((*HTTPRetry)(nil), "istio.routing.v1alpha1.HTTPRetry")
	proto.RegisterType((*HTTPRetry_SimpleRetryPolicy)(nil), "istio.routing.v1alpha1.HTTPRetry.SimpleRetryPolicy")
	proto.RegisterType((*CorsPolicy)(nil), "istio.routing.v1alpha1.CorsPolicy")
}

func init() { proto.RegisterFile("routing/v1alpha1/route_rule.proto", fileDescriptor5) }

var fileDescriptor5 = []byte{
	// 1250 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x57, 0xdd, 0x72, 0xdb, 0x44,
	0x14, 0xae, 0x9d, 0xd8, 0x8e, 0x8f, 0x1d, 0x93, 0x2c, 0x9d, 0x8e, 0xea, 0x81, 0x36, 0x75, 0x81,
	0x09, 0x30, 0x28, 0xfd, 0x09, 0x03, 0x85, 0xb6, 0x34, 0x49, 0x29, 0xe9, 0xb4, 0x81, 0xce, 0x26,
	0xfc, 0x0c, 0x5c, 0x08, 0x45, 0x3a, 0xb5, 0x97, 0xca, 0x5a, 0x75, 0xb5, 0x4a, 0xe2, 0x19, 0x1e,
	0x80, 0x97, 0xe0, 0x8e, 0x7b, 0x5e, 0x80, 0x47, 0xe0, 0x59, 0xb8, 0xe5, 0x8a, 0x19, 0x66, 0x7f,
	0x24, 0xab, 0x75, 0xed, 0xc4, 0x03, 0x57, 0xd6, 0x9e, 0xfd, 0xbe, 0x6f, 0x77, 0xcf, 0x9e, 0x73,
	0xf6, 0x18, 0xae, 0x08, 0x9e, 0x49, 0x16, 0xf7, 0x37, 0x8e, 0xae, 0xfb, 0x51, 0x32, 0xf0, 0xaf,
	0x6f, 0x28, 0x03, 0x7a, 0x22, 0x8b, 0xd0, 0x4d, 0x04, 0x97, 0x9c, 0x5c, 0x60, 0xa9, 0x64, 0xdc,
	0xb5, 0x40, 0x37, 0x07, 0x76, 0x2f, 0xf6, 0x39, 0xef, 0x47, 0xb8, 0xa1, 0x51, 0x87, 0xd9, 0xd3,
	0x0d, 0x3f, 0x1e, 0x19, 0x4a, 0xf7, 0xd2, 0xcb, 0x53, 0x61, 0x26, 0x7c, 0xc9, 0x78, 0x3c, 0x6d,
	0xfe, 0x58, 0xf8, 0x49, 0x82, 0x22, 0xb5, 0xf3, 0x93, 0xbb, 0x1a, 0x48, 0x99, 0x78, 0x4f, 0xfd,
	0x2c, 0x92, 0x16, 0x72, 0x79, 0x02, 0x12, 0x6d, 0x96, 0x01, 0xbd, 0xbf, 0x1a, 0xd0, 0xa4, 0xea,
	0x2c, 0x34, 0x8b, 0x90, 0x3c, 0x80, 0x56, 0x88, 0xa9, 0x64, 0xb1, 0xde, 0x86, 0x53, 0x59, 0xab,
	0xac, 0xb7, 0x6e, 0xbc, 0xe5, 0xbe, 0xfa, 0x68, 0xee, 0x43, 0x65, 0xde, 0x47, 0x71, 0xc4, 0x02,
	0xa4, 0x65, 0x22, 0xb9, 0x04, 0x90, 0x08, 0x0c, 0x30, 0xc4, 0x38, 0x40, 0xa7, 0xba, 0x56, 0x59,
	0xaf, 0xd1, 0x92, 0x85, 0xdc, 0x86, 0xda, 0xd0, 0x97, 0xc1, 0xc0, 0x59, 0xd0, 0x2b, 0xbc, 0x33,
	0x6d, 0x85, 0x3d, 0x05, 0xda, 0xe1, 0x71, 0xc8, 0x94, 0x2c, 0x35, 0x24, 0xf2, 0x19, 0xd4, 0xb4,
	0xfb, 0x9d, 0xc5, 0xb5, 0x85, 0xf5, 0xd6, 0x8d, 0x77, 0xa7, 0xb1, 0xef, 0x8f, 0x77, 0xf4, 0x2d,
	0xb2, 0xfe, 0x40, 0x52, 0xc3, 0x23, 0xf7, 0x60, 0x49, 0x60, 0xc8, 0x04, 0x06, 0xd2, 0xa9, 0xcd,
	0x3e, 0xe3, 0xee, 0xc1, 0xc1, 0x13, 0x6a, 0xb1, 0xb4, 0x60, 0x91, 0x3b, 0xd0, 0x10, 0x78, 0x2c,
	0x98, 0x44, 0xa7, 0xae, 0x05, 0xae, 0xce, 0x16, 0xd0, 0x50, 0x9a, 0x73, 0xc8, 0xfb, 0xb0, 0x7a,
	0x8c, 0x87, 0x29, 0x0f, 0x9e, 0xa1, 0xf4, 0xb2, 0xa4, 0x2f, 0xfc, 0x10, 0x9d, 0xc6, 0x5a, 0x65,
	0x7d, 0x89, 0xae, 0x14, 0x13, 0x5f, 0x1b, 0x3b, 0xd9, 0x83, 0x15, 0x7d, 0xaf, 0x02, 0x9f, 0x7b,
	0x92, 0x0d, 0x91, 0x67, 0xd2, 0x59, 0x3a, 0x7d, 0xd1, 0x03, 0x03, 0xa5, 0x1d, 0x45, 0xa6, 0xf8,
	0xdc, 0x8e, 0xc9, 0xa3, 0x92, 0x9c, 0x40, 0x29, 0x18, 0xa6, 0x4e, 0x53, 0xcb, 0x5d, 0x99, 0x7d,
	0x06, 0x29, 0x46, 0x85, 0x18, 0x35, 0x44, 0xf2, 0x10, 0x60, 0x1c, 0x73, 0x0e, 0x68, 0x99, 0xf7,
	0x66, 0xc9, 0x3c, 0x50, 0xc0, 0x87, 0xf1, 0x4f, 0x18, 0xe8, 0x1b, 0x6d, 0x2a, 0xb6, 0xb6, 0x91,
	0x1d, 0x58, 0xca, 0x63, 0xd3, 0x69, 0x69, 0xa1, 0xf5, 0x69, 0x42, 0x8f, 0x37, 0x5f, 0x92, 0x69,
	0x44, 0xc6, 0x42, 0x6e, 0x43, 0x7d, 0xc8, 0x84, 0xe0, 0xc2, 0x69, 0xcf, 0x11, 0xbb, 0x96, 0x43,
	0x76, 0xa0, 0x15, 0x70, 0x91, 0x7a, 0x09, 0x8f, 0x58, 0x30, 0x72, 0x96, 0xb5, 0x44, 0x6f, 0x9a,
	0xc4, 0x0e, 0x17, 0xe9, 0x13, 0x8d, 0xa4, 0x10, 0x14, 0xdf, 0xe4, 0x07, 0xe8, 0xa8, 0x2c, 0x8d,
	0x43, 0x6f, 0x80, 0x7e, 0x88, 0x22, 0x75, 0x3a, 0x3a, 0x4c, 0x37, 0xa7, 0xe9, 0x14, 0xe9, 0xe7,
	0x6e, 0x69, 0xde, 0xae, 0xa1, 0x7d, 0x1e, 0x2b, 0x87, 0x2f, 0xfb, 0x65, 0x5b, 0xf7, 0x1e, 0x90,
	0x49, 0x10, 0x59, 0x81, 0x85, 0x67, 0x38, 0xd2, 0xe9, 0xda, 0xa4, 0xea, 0x93, 0x9c, 0x87, 0xda,
	0x91, 0x1f, 0x65, 0x26, 0xf7, 0x9a, 0xd4, 0x0c, 0x3e, 0xa9, 0x7e, 0x5c, 0xe9, 0xfd, 0x5d, 0x81,
	0x76, 0xf9, 0xf0, 0x84, 0xc0, 0x62, 0xec, 0x0f, 0xd1, 0xb2, 0xf5, 0x37, 0x79, 0x03, 0x9a, 0xea,
	0x37, 0x4d, 0xfc, 0x20, 0x97, 0x18, 0x1b, 0xc8, 0x05, 0xa8, 0x87, 0x7c, 0xe8, 0xb3, 0x58, 0xa7,
	0x6f, 0x93, 0xda, 0x11, 0x71, 0xa0, 0x91, 0x1a, 0x51, 0x67, 0x51, 0x4f, 0xe4, 0x43, 0xb2, 0x0b,
	0xf5, 0xc8, 0x3f, 0xc4, 0x28, 0x75, 0x6a, 0xda, 0x17, 0xd7, 0xce, 0x72, 0x2d, 0xee, 0x63, 0x4d,
	0x31, 0x7e, 0xb0, 0xfc, 0xee, 0x2d, 0x68, 0x95, 0xcc, 0x73, 0x9d, 0xfc, 0x97, 0x2a, 0x74, 0x5e,
	0x2c, 0x28, 0x2a, 0x5c, 0x52, 0x9e, 0x89, 0x00, 0xe7, 0x2a, 0x75, 0x96, 0x43, 0x3e, 0x85, 0x05,
	0x19, 0x24, 0x7a, 0xa1, 0x19, 0x55, 0xe8, 0xf1, 0xa6, 0x5e, 0x74, 0x4b, 0x4a, 0xc1, 0x0e, 0x33,
	0x89, 0x29, 0x55, 0x2c, 0x45, 0xce, 0xc2, 0xc4, 0x16, 0xc0, 0x79, 0xc8, 0x59, 0x98, 0x90, 0xbb,
	0xaa, 0xfc, 0x3c, 0xcf, 0x30, 0x95, 0xda, 0xd3, 0x33, 0x36, 0xae, 0xe9, 0xd4, 0x60, 0x69, 0x4e,
	0xea, 0xfd, 0x51, 0x81, 0x76, 0x79, 0x86, 0x3c, 0x82, 0x46, 0x1e, 0xad, 0x15, 0x7d, 0x43, 0xd7,
	0xcf, 0x22, 0xe8, 0xbe, 0x10, 0xaa, 0xb9, 0x42, 0xd7, 0x83, 0xf6, 0x29, 0xe1, 0x79, 0xab, 0x7c,
	0x49, 0x33, 0xea, 0xd8, 0xbe, 0x14, 0x2c, 0xee, 0x9b, 0x25, 0x4b, 0x37, 0xf9, 0x4f, 0x05, 0x56,
	0x27, 0x8a, 0xfb, 0xff, 0xf6, 0x78, 0xed, 0x15, 0xc1, 0x5a, 0xd5, 0xae, 0xf8, 0xf0, 0xcc, 0xef,
	0xcb, 0xab, 0x22, 0x56, 0x65, 0xcb, 0xb1, 0x9e, 0xd5, 0x77, 0x5d, 0xa3, 0x76, 0xf4, 0x5f, 0x22,
	0xb9, 0x0f, 0xab, 0x13, 0x81, 0x41, 0xae, 0xc2, 0xb2, 0x89, 0x4b, 0x2f, 0xcd, 0x0e, 0x63, 0x94,
	0xfa, 0x22, 0x9b, 0xb4, 0x6d, 0x8c, 0xfb, 0xda, 0x46, 0x3e, 0x00, 0x52, 0x3a, 0x6a, 0x8e, 0xac,
	0x6a, 0xe4, 0x6a, 0x69, 0xc6, 0xc0, 0x7b, 0x77, 0xa1, 0x5d, 0x7e, 0x00, 0xd5, 0x26, 0x33, 0xc1,
	0xf2, 0x4d, 0x66, 0x82, 0xa9, 0x4a, 0xe1, 0x67, 0x72, 0xc0, 0x05, 0x93, 0xa3, 0xbc, 0x52, 0x14,
	0x86, 0xde, 0x1d, 0x68, 0x95, 0xde, 0xbf, 0xb9, 0xe9, 0x08, 0xad, 0x52, 0x04, 0x90, 0x0b, 0x50,
	0xc3, 0x13, 0x3f, 0x90, 0x46, 0x60, 0xf7, 0x1c, 0x35, 0x43, 0xe2, 0x40, 0x3d, 0x11, 0xf8, 0x94,
	0x9d, 0x18, 0x85, 0xdd, 0x73, 0xd4, 0x8e, 0x15, 0x43, 0x60, 0x1f, 0x4f, 0x4c, 0xa1, 0x52, 0x0c,
	0x3d, 0xdc, 0x6e, 0x03, 0xe8, 0x56, 0xc2, 0x93, 0xa3, 0x04, 0x7b, 0xbf, 0x57, 0xcd, 0x36, 0xf3,
	0x17, 0xf2, 0x47, 0xe8, 0xa4, 0x6c, 0x98, 0x44, 0x58, 0x3c, 0xb7, 0x26, 0x96, 0x3e, 0x3a, 0xc3,
	0x73, 0xeb, 0xee, 0x6b, 0xa6, 0x1d, 0x99, 0x27, 0x61, 0xf7, 0x1c, 0x5d, 0x4e, 0xcb, 0x66, 0xe2,
	0x42, 0x3d, 0xc8, 0x52, 0xc9, 0x87, 0x36, 0x01, 0xce, 0xbb, 0xa6, 0xd5, 0x73, 0xf3, 0x56, 0xcf,
	0xdd, 0x8a, 0x15, 0xcd, 0xa2, 0xba, 0x3f, 0xc3, 0xeb, 0xaf, 0xd0, 0x25, 0x37, 0xa1, 0xf1, 0xe2,
	0x0e, 0x2f, 0x4e, 0xe8, 0xdc, 0xb7, 0x2d, 0x25, 0xcd, 0x91, 0xe4, 0x1a, 0x9c, 0xe7, 0x47, 0x28,
	0x04, 0x0b, 0xd1, 0xbe, 0x50, 0x9e, 0xae, 0xff, 0xc6, 0xfb, 0x24, 0x9f, 0x33, 0x19, 0xfc, 0xa5,
	0x3f, 0xc4, 0xed, 0x15, 0xe8, 0x58, 0xb2, 0x7d, 0x19, 0x7b, 0x7f, 0x56, 0xa1, 0x59, 0x34, 0x05,
	0xe4, 0x3b, 0x68, 0x5b, 0x7f, 0xa9, 0x7e, 0x62, 0x64, 0xf7, 0x72, 0xf3, 0xd4, 0x6e, 0xc2, 0xfa,
	0x4a, 0x7f, 0x17, 0x9e, 0x6a, 0xa5, 0x63, 0xe3, 0xdc, 0x7e, 0xfa, 0xad, 0x02, 0xab, 0x13, 0xa2,
	0xa4, 0x0b, 0x4b, 0xbe, 0x94, 0x38, 0x4c, 0x64, 0xaa, 0xf7, 0x56, 0xa3, 0xc5, 0x98, 0x6c, 0xc1,
	0x6b, 0x09, 0x0a, 0x4f, 0x8a, 0x51, 0x71, 0xd9, 0xd5, 0xd3, 0x5c, 0xb9, 0x9c, 0xa0, 0x38, 0x10,
	0xa3, 0x83, 0x53, 0x1c, 0xba, 0x30, 0xd5, 0xa1, 0x1d, 0x68, 0x6b, 0x4f, 0xe5, 0xee, 0xfc, 0xb5,
	0x0a, 0x30, 0xee, 0x26, 0xc8, 0x15, 0x68, 0xfb, 0x51, 0xc4, 0x8f, 0x3d, 0x2e, 0x58, 0x9f, 0xc5,
	0x36, 0x91, 0x5b, 0xda, 0xf6, 0x95, 0x36, 0xa9, 0x64, 0x37, 0x90, 0x21, 0xca, 0x01, 0x0f, 0x53,
	0x9b, 0xc2, 0x86, 0xb7, 0x67, 0x6c, 0x63, 0x50, 0x5e, 0xda, 0x17, 0x4a, 0x20, 0x5b, 0xa1, 0xc9,
	0xdb, 0xd0, 0xc1, 0x93, 0x84, 0xa7, 0x58, 0xa0, 0x16, 0x35, 0x6a, 0xd9, 0x58, 0x73, 0xd8, 0x0d,
	0x68, 0x0c, 0xfd, 0x13, 0xcf, 0xef, 0xa3, 0xed, 0x98, 0x67, 0xf8, 0xa7, 0x3e, 0xf4, 0x4f, 0xb6,
	0xfa, 0x48, 0xbe, 0x80, 0x55, 0xb3, 0x7e, 0x20, 0x54, 0xdf, 0x2f, 0x99, 0x1f, 0xa5, 0xb6, 0x5d,
	0xee, 0x4e, 0xb0, 0xb7, 0x39, 0x8f, 0xbe, 0x51, 0x15, 0x8e, 0xae, 0x68, 0xd2, 0xce, 0x98, 0xb3,
	0x7d, 0xf9, 0xfb, 0x37, 0x4d, 0x2c, 0x31, 0xbe, 0xe1, 0x27, 0x6c, 0xe3, 0xe5, 0x3f, 0x35, 0x87,
	0x75, 0x2d, 0x73, 0xf3, 0xdf, 0x00, 0x00, 0x00, 0xff, 0xff, 0x16, 0x53, 0x23, 0x24, 0xa8, 0x0d,
	0x00, 0x00,
}
