// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: mixer/v1/check.proto

package v1

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"
import _ "github.com/gogo/protobuf/types"
import google_rpc "github.com/gogo/googleapis/google/rpc"

import time "time"

import strconv "strconv"

import types "github.com/gogo/protobuf/types"

import strings "strings"
import reflect "reflect"
import sortkeys "github.com/gogo/protobuf/sortkeys"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// How an attribute's value was matched
type ReferencedAttributes_Condition int32

const (
	CONDITION_UNSPECIFIED ReferencedAttributes_Condition = 0
	ABSENCE               ReferencedAttributes_Condition = 1
	EXACT                 ReferencedAttributes_Condition = 2
	REGEX                 ReferencedAttributes_Condition = 3
)

var ReferencedAttributes_Condition_name = map[int32]string{
	0: "CONDITION_UNSPECIFIED",
	1: "ABSENCE",
	2: "EXACT",
	3: "REGEX",
}
var ReferencedAttributes_Condition_value = map[string]int32{
	"CONDITION_UNSPECIFIED": 0,
	"ABSENCE":               1,
	"EXACT":                 2,
	"REGEX":                 3,
}

func (ReferencedAttributes_Condition) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorCheck, []int{2, 0}
}

// Used to get a thumbs-up/thumbs-down before performing an action.
type CheckRequest struct {
	// The attributes to use for this request.
	//
	// Mixer's configuration determines how these attributes are used to
	// establish the result returned in the response.
	Attributes CompressedAttributes `protobuf:"bytes,1,opt,name=attributes" json:"attributes"`
	// The number of words in the global dictionary, used with to populate the attributes.
	// This value is used as a quick way to determine whether the client is using a dictionary that
	// the server understands.
	GlobalWordCount uint32 `protobuf:"varint,2,opt,name=global_word_count,json=globalWordCount,proto3" json:"global_word_count,omitempty"`
	// Used for deduplicating `Check` calls in the case of failed RPCs and retries. This should be a UUID
	// per call, where the same UUID is used for retries of the same call.
	DeduplicationId string `protobuf:"bytes,3,opt,name=deduplication_id,json=deduplicationId,proto3" json:"deduplication_id,omitempty"`
	// The individual quotas to allocate
	Quotas map[string]CheckRequest_QuotaParams `protobuf:"bytes,4,rep,name=quotas" json:"quotas" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *CheckRequest) Reset()                    { *m = CheckRequest{} }
func (*CheckRequest) ProtoMessage()               {}
func (*CheckRequest) Descriptor() ([]byte, []int) { return fileDescriptorCheck, []int{0} }

// parameters for a quota allocation
type CheckRequest_QuotaParams struct {
	// Amount of quota to allocate
	Amount int64 `protobuf:"varint,1,opt,name=amount,proto3" json:"amount,omitempty"`
	// When true, supports returning less quota than what was requested.
	BestEffort bool `protobuf:"varint,2,opt,name=best_effort,json=bestEffort,proto3" json:"best_effort,omitempty"`
}

func (m *CheckRequest_QuotaParams) Reset()                    { *m = CheckRequest_QuotaParams{} }
func (*CheckRequest_QuotaParams) ProtoMessage()               {}
func (*CheckRequest_QuotaParams) Descriptor() ([]byte, []int) { return fileDescriptorCheck, []int{0, 0} }

// The response generated by the Check method.
type CheckResponse struct {
	// The precondition check results.
	Precondition CheckResponse_PreconditionResult `protobuf:"bytes,2,opt,name=precondition" json:"precondition"`
	// The resulting quota, one entry per requested quota.
	Quotas map[string]CheckResponse_QuotaResult `protobuf:"bytes,3,rep,name=quotas" json:"quotas" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *CheckResponse) Reset()                    { *m = CheckResponse{} }
func (*CheckResponse) ProtoMessage()               {}
func (*CheckResponse) Descriptor() ([]byte, []int) { return fileDescriptorCheck, []int{1} }

// Expresses the result of a precondition check.
type CheckResponse_PreconditionResult struct {
	// A status code of OK indicates all preconditions were satisfied. Any other code indicates not
	// all preconditions were satisfied and details describe why.
	Status google_rpc.Status `protobuf:"bytes,1,opt,name=status" json:"status"`
	// The amount of time for which this result can be considered valid.
	ValidDuration time.Duration `protobuf:"bytes,2,opt,name=valid_duration,json=validDuration,stdduration" json:"valid_duration"`
	// The number of uses for which this result can be considered valid.
	ValidUseCount int32 `protobuf:"varint,3,opt,name=valid_use_count,json=validUseCount,proto3" json:"valid_use_count,omitempty"`
	// The attributes returned by Mixer.
	//
	// The exact set of attributes returned is determined by the set of
	// adapters Mixer is configured with. These attributes are used to
	// ferry new attributes that Mixer derived based on the input set of
	// attributes and its configuration.
	Attributes CompressedAttributes `protobuf:"bytes,4,opt,name=attributes" json:"attributes"`
	// The total set of attributes that were used in producing the result
	// along with matching conditions.
	ReferencedAttributes ReferencedAttributes `protobuf:"bytes,5,opt,name=referenced_attributes,json=referencedAttributes" json:"referenced_attributes"`
}

func (m *CheckResponse_PreconditionResult) Reset()      { *m = CheckResponse_PreconditionResult{} }
func (*CheckResponse_PreconditionResult) ProtoMessage() {}
func (*CheckResponse_PreconditionResult) Descriptor() ([]byte, []int) {
	return fileDescriptorCheck, []int{1, 0}
}

// Expresses the result of a quota allocation.
type CheckResponse_QuotaResult struct {
	// The amount of time for which this result can be considered valid.
	ValidDuration time.Duration `protobuf:"bytes,1,opt,name=valid_duration,json=validDuration,stdduration" json:"valid_duration"`
	// The amount of granted quota. When `QuotaParams.best_effort` is true, this will be >= 0.
	// If `QuotaParams.best_effort` is false, this will be either 0 or >= `QuotaParams.amount`.
	GrantedAmount int64 `protobuf:"varint,2,opt,name=granted_amount,json=grantedAmount,proto3" json:"granted_amount,omitempty"`
	// The total set of attributes that were used in producing the result
	// along with matching conditions.
	ReferencedAttributes ReferencedAttributes `protobuf:"bytes,5,opt,name=referenced_attributes,json=referencedAttributes" json:"referenced_attributes"`
}

func (m *CheckResponse_QuotaResult) Reset()      { *m = CheckResponse_QuotaResult{} }
func (*CheckResponse_QuotaResult) ProtoMessage() {}
func (*CheckResponse_QuotaResult) Descriptor() ([]byte, []int) {
	return fileDescriptorCheck, []int{1, 1}
}

// Describes the attributes that were used to determine the response.
// This can be used to construct a response cache.
type ReferencedAttributes struct {
	// The message-level dictionary. Refer to [CompressedAttributes][istio.mixer.v1.CompressedAttributes] for information
	// on using dictionaries.
	Words []string `protobuf:"bytes,1,rep,name=words" json:"words,omitempty"`
	// Describes a set of attributes.
	AttributeMatches []ReferencedAttributes_AttributeMatch `protobuf:"bytes,2,rep,name=attribute_matches,json=attributeMatches" json:"attribute_matches"`
}

func (m *ReferencedAttributes) Reset()                    { *m = ReferencedAttributes{} }
func (*ReferencedAttributes) ProtoMessage()               {}
func (*ReferencedAttributes) Descriptor() ([]byte, []int) { return fileDescriptorCheck, []int{2} }

// Describes a single attribute match.
type ReferencedAttributes_AttributeMatch struct {
	// The name of the attribute. This is a dictionary index encoded in a manner identical
	// to all strings in the [CompressedAttributes][istio.mixer.v1.CompressedAttributes] message.
	Name int32 `protobuf:"zigzag32,1,opt,name=name,proto3" json:"name,omitempty"`
	// The kind of match against the attribute value.
	Condition ReferencedAttributes_Condition `protobuf:"varint,2,opt,name=condition,proto3,enum=istio.mixer.v1.ReferencedAttributes_Condition" json:"condition,omitempty"`
	// If a REGEX condition is provided for a STRING_MAP attribute,
	// clients should use the regex value to match against map keys.
	Regex string `protobuf:"bytes,3,opt,name=regex,proto3" json:"regex,omitempty"`
	// A key in a STRING_MAP. When multiple keys from a STRING_MAP
	// attribute were referenced, there will be multiple AttributeMatch
	// messages with different map_key values. Values for map_key SHOULD
	// be ignored for attributes that are not STRING_MAP.
	//
	// Indices for the keys are used (taken either from the
	// message dictionary from the `words` field or the global dictionary).
	//
	// If no map_key value is provided for a STRING_MAP attribute, the
	// entire STRING_MAP will be used.
	MapKey int32 `protobuf:"zigzag32,4,opt,name=map_key,json=mapKey,proto3" json:"map_key,omitempty"`
}

func (m *ReferencedAttributes_AttributeMatch) Reset()      { *m = ReferencedAttributes_AttributeMatch{} }
func (*ReferencedAttributes_AttributeMatch) ProtoMessage() {}
func (*ReferencedAttributes_AttributeMatch) Descriptor() ([]byte, []int) {
	return fileDescriptorCheck, []int{2, 0}
}

func init() {
	proto.RegisterType((*CheckRequest)(nil), "istio.mixer.v1.CheckRequest")
	proto.RegisterType((*CheckRequest_QuotaParams)(nil), "istio.mixer.v1.CheckRequest.QuotaParams")
	proto.RegisterType((*CheckResponse)(nil), "istio.mixer.v1.CheckResponse")
	proto.RegisterType((*CheckResponse_PreconditionResult)(nil), "istio.mixer.v1.CheckResponse.PreconditionResult")
	proto.RegisterType((*CheckResponse_QuotaResult)(nil), "istio.mixer.v1.CheckResponse.QuotaResult")
	proto.RegisterType((*ReferencedAttributes)(nil), "istio.mixer.v1.ReferencedAttributes")
	proto.RegisterType((*ReferencedAttributes_AttributeMatch)(nil), "istio.mixer.v1.ReferencedAttributes.AttributeMatch")
	proto.RegisterEnum("istio.mixer.v1.ReferencedAttributes_Condition", ReferencedAttributes_Condition_name, ReferencedAttributes_Condition_value)
}
func (x ReferencedAttributes_Condition) String() string {
	s, ok := ReferencedAttributes_Condition_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (m *CheckRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintCheck(dAtA, i, uint64(m.Attributes.Size()))
	n1, err := m.Attributes.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	if m.GlobalWordCount != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintCheck(dAtA, i, uint64(m.GlobalWordCount))
	}
	if len(m.DeduplicationId) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintCheck(dAtA, i, uint64(len(m.DeduplicationId)))
		i += copy(dAtA[i:], m.DeduplicationId)
	}
	if len(m.Quotas) > 0 {
		for k, _ := range m.Quotas {
			dAtA[i] = 0x22
			i++
			v := m.Quotas[k]
			msgSize := 0
			if (&v) != nil {
				msgSize = (&v).Size()
				msgSize += 1 + sovCheck(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovCheck(uint64(len(k))) + msgSize
			i = encodeVarintCheck(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintCheck(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintCheck(dAtA, i, uint64((&v).Size()))
			n2, err := (&v).MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n2
		}
	}
	return i, nil
}

func (m *CheckRequest_QuotaParams) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckRequest_QuotaParams) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Amount != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintCheck(dAtA, i, uint64(m.Amount))
	}
	if m.BestEffort {
		dAtA[i] = 0x10
		i++
		if m.BestEffort {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *CheckResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x12
	i++
	i = encodeVarintCheck(dAtA, i, uint64(m.Precondition.Size()))
	n3, err := m.Precondition.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n3
	if len(m.Quotas) > 0 {
		for k, _ := range m.Quotas {
			dAtA[i] = 0x1a
			i++
			v := m.Quotas[k]
			msgSize := 0
			if (&v) != nil {
				msgSize = (&v).Size()
				msgSize += 1 + sovCheck(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovCheck(uint64(len(k))) + msgSize
			i = encodeVarintCheck(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintCheck(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintCheck(dAtA, i, uint64((&v).Size()))
			n4, err := (&v).MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n4
		}
	}
	return i, nil
}

func (m *CheckResponse_PreconditionResult) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckResponse_PreconditionResult) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintCheck(dAtA, i, uint64(m.Status.Size()))
	n5, err := m.Status.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n5
	dAtA[i] = 0x12
	i++
	i = encodeVarintCheck(dAtA, i, uint64(types.SizeOfStdDuration(m.ValidDuration)))
	n6, err := types.StdDurationMarshalTo(m.ValidDuration, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n6
	if m.ValidUseCount != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintCheck(dAtA, i, uint64(m.ValidUseCount))
	}
	dAtA[i] = 0x22
	i++
	i = encodeVarintCheck(dAtA, i, uint64(m.Attributes.Size()))
	n7, err := m.Attributes.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n7
	dAtA[i] = 0x2a
	i++
	i = encodeVarintCheck(dAtA, i, uint64(m.ReferencedAttributes.Size()))
	n8, err := m.ReferencedAttributes.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n8
	return i, nil
}

func (m *CheckResponse_QuotaResult) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckResponse_QuotaResult) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintCheck(dAtA, i, uint64(types.SizeOfStdDuration(m.ValidDuration)))
	n9, err := types.StdDurationMarshalTo(m.ValidDuration, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n9
	if m.GrantedAmount != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintCheck(dAtA, i, uint64(m.GrantedAmount))
	}
	dAtA[i] = 0x2a
	i++
	i = encodeVarintCheck(dAtA, i, uint64(m.ReferencedAttributes.Size()))
	n10, err := m.ReferencedAttributes.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n10
	return i, nil
}

func (m *ReferencedAttributes) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReferencedAttributes) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Words) > 0 {
		for _, s := range m.Words {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.AttributeMatches) > 0 {
		for _, msg := range m.AttributeMatches {
			dAtA[i] = 0x12
			i++
			i = encodeVarintCheck(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *ReferencedAttributes_AttributeMatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReferencedAttributes_AttributeMatch) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Name != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintCheck(dAtA, i, uint64((uint32(m.Name)<<1)^uint32((m.Name>>31))))
	}
	if m.Condition != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintCheck(dAtA, i, uint64(m.Condition))
	}
	if len(m.Regex) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintCheck(dAtA, i, uint64(len(m.Regex)))
		i += copy(dAtA[i:], m.Regex)
	}
	if m.MapKey != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintCheck(dAtA, i, uint64((uint32(m.MapKey)<<1)^uint32((m.MapKey>>31))))
	}
	return i, nil
}

func encodeVarintCheck(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *CheckRequest) Size() (n int) {
	var l int
	_ = l
	l = m.Attributes.Size()
	n += 1 + l + sovCheck(uint64(l))
	if m.GlobalWordCount != 0 {
		n += 1 + sovCheck(uint64(m.GlobalWordCount))
	}
	l = len(m.DeduplicationId)
	if l > 0 {
		n += 1 + l + sovCheck(uint64(l))
	}
	if len(m.Quotas) > 0 {
		for k, v := range m.Quotas {
			_ = k
			_ = v
			l = v.Size()
			mapEntrySize := 1 + len(k) + sovCheck(uint64(len(k))) + 1 + l + sovCheck(uint64(l))
			n += mapEntrySize + 1 + sovCheck(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *CheckRequest_QuotaParams) Size() (n int) {
	var l int
	_ = l
	if m.Amount != 0 {
		n += 1 + sovCheck(uint64(m.Amount))
	}
	if m.BestEffort {
		n += 2
	}
	return n
}

func (m *CheckResponse) Size() (n int) {
	var l int
	_ = l
	l = m.Precondition.Size()
	n += 1 + l + sovCheck(uint64(l))
	if len(m.Quotas) > 0 {
		for k, v := range m.Quotas {
			_ = k
			_ = v
			l = v.Size()
			mapEntrySize := 1 + len(k) + sovCheck(uint64(len(k))) + 1 + l + sovCheck(uint64(l))
			n += mapEntrySize + 1 + sovCheck(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *CheckResponse_PreconditionResult) Size() (n int) {
	var l int
	_ = l
	l = m.Status.Size()
	n += 1 + l + sovCheck(uint64(l))
	l = types.SizeOfStdDuration(m.ValidDuration)
	n += 1 + l + sovCheck(uint64(l))
	if m.ValidUseCount != 0 {
		n += 1 + sovCheck(uint64(m.ValidUseCount))
	}
	l = m.Attributes.Size()
	n += 1 + l + sovCheck(uint64(l))
	l = m.ReferencedAttributes.Size()
	n += 1 + l + sovCheck(uint64(l))
	return n
}

func (m *CheckResponse_QuotaResult) Size() (n int) {
	var l int
	_ = l
	l = types.SizeOfStdDuration(m.ValidDuration)
	n += 1 + l + sovCheck(uint64(l))
	if m.GrantedAmount != 0 {
		n += 1 + sovCheck(uint64(m.GrantedAmount))
	}
	l = m.ReferencedAttributes.Size()
	n += 1 + l + sovCheck(uint64(l))
	return n
}

func (m *ReferencedAttributes) Size() (n int) {
	var l int
	_ = l
	if len(m.Words) > 0 {
		for _, s := range m.Words {
			l = len(s)
			n += 1 + l + sovCheck(uint64(l))
		}
	}
	if len(m.AttributeMatches) > 0 {
		for _, e := range m.AttributeMatches {
			l = e.Size()
			n += 1 + l + sovCheck(uint64(l))
		}
	}
	return n
}

func (m *ReferencedAttributes_AttributeMatch) Size() (n int) {
	var l int
	_ = l
	if m.Name != 0 {
		n += 1 + sozCheck(uint64(m.Name))
	}
	if m.Condition != 0 {
		n += 1 + sovCheck(uint64(m.Condition))
	}
	l = len(m.Regex)
	if l > 0 {
		n += 1 + l + sovCheck(uint64(l))
	}
	if m.MapKey != 0 {
		n += 1 + sozCheck(uint64(m.MapKey))
	}
	return n
}

func sovCheck(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozCheck(x uint64) (n int) {
	return sovCheck(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *CheckRequest) String() string {
	if this == nil {
		return "nil"
	}
	keysForQuotas := make([]string, 0, len(this.Quotas))
	for k, _ := range this.Quotas {
		keysForQuotas = append(keysForQuotas, k)
	}
	sortkeys.Strings(keysForQuotas)
	mapStringForQuotas := "map[string]CheckRequest_QuotaParams{"
	for _, k := range keysForQuotas {
		mapStringForQuotas += fmt.Sprintf("%v: %v,", k, this.Quotas[k])
	}
	mapStringForQuotas += "}"
	s := strings.Join([]string{`&CheckRequest{`,
		`Attributes:` + strings.Replace(strings.Replace(this.Attributes.String(), "CompressedAttributes", "CompressedAttributes", 1), `&`, ``, 1) + `,`,
		`GlobalWordCount:` + fmt.Sprintf("%v", this.GlobalWordCount) + `,`,
		`DeduplicationId:` + fmt.Sprintf("%v", this.DeduplicationId) + `,`,
		`Quotas:` + mapStringForQuotas + `,`,
		`}`,
	}, "")
	return s
}
func (this *CheckRequest_QuotaParams) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CheckRequest_QuotaParams{`,
		`Amount:` + fmt.Sprintf("%v", this.Amount) + `,`,
		`BestEffort:` + fmt.Sprintf("%v", this.BestEffort) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CheckResponse) String() string {
	if this == nil {
		return "nil"
	}
	keysForQuotas := make([]string, 0, len(this.Quotas))
	for k, _ := range this.Quotas {
		keysForQuotas = append(keysForQuotas, k)
	}
	sortkeys.Strings(keysForQuotas)
	mapStringForQuotas := "map[string]CheckResponse_QuotaResult{"
	for _, k := range keysForQuotas {
		mapStringForQuotas += fmt.Sprintf("%v: %v,", k, this.Quotas[k])
	}
	mapStringForQuotas += "}"
	s := strings.Join([]string{`&CheckResponse{`,
		`Precondition:` + strings.Replace(strings.Replace(this.Precondition.String(), "CheckResponse_PreconditionResult", "CheckResponse_PreconditionResult", 1), `&`, ``, 1) + `,`,
		`Quotas:` + mapStringForQuotas + `,`,
		`}`,
	}, "")
	return s
}
func (this *CheckResponse_PreconditionResult) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CheckResponse_PreconditionResult{`,
		`Status:` + strings.Replace(strings.Replace(this.Status.String(), "Status", "google_rpc.Status", 1), `&`, ``, 1) + `,`,
		`ValidDuration:` + strings.Replace(strings.Replace(this.ValidDuration.String(), "Duration", "google_protobuf1.Duration", 1), `&`, ``, 1) + `,`,
		`ValidUseCount:` + fmt.Sprintf("%v", this.ValidUseCount) + `,`,
		`Attributes:` + strings.Replace(strings.Replace(this.Attributes.String(), "CompressedAttributes", "CompressedAttributes", 1), `&`, ``, 1) + `,`,
		`ReferencedAttributes:` + strings.Replace(strings.Replace(this.ReferencedAttributes.String(), "ReferencedAttributes", "ReferencedAttributes", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CheckResponse_QuotaResult) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CheckResponse_QuotaResult{`,
		`ValidDuration:` + strings.Replace(strings.Replace(this.ValidDuration.String(), "Duration", "google_protobuf1.Duration", 1), `&`, ``, 1) + `,`,
		`GrantedAmount:` + fmt.Sprintf("%v", this.GrantedAmount) + `,`,
		`ReferencedAttributes:` + strings.Replace(strings.Replace(this.ReferencedAttributes.String(), "ReferencedAttributes", "ReferencedAttributes", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ReferencedAttributes) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ReferencedAttributes{`,
		`Words:` + fmt.Sprintf("%v", this.Words) + `,`,
		`AttributeMatches:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.AttributeMatches), "ReferencedAttributes_AttributeMatch", "ReferencedAttributes_AttributeMatch", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ReferencedAttributes_AttributeMatch) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ReferencedAttributes_AttributeMatch{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Condition:` + fmt.Sprintf("%v", this.Condition) + `,`,
		`Regex:` + fmt.Sprintf("%v", this.Regex) + `,`,
		`MapKey:` + fmt.Sprintf("%v", this.MapKey) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringCheck(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *CheckRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCheck
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CheckRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CheckRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Attributes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GlobalWordCount", wireType)
			}
			m.GlobalWordCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.GlobalWordCount |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeduplicationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeduplicationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Quotas", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Quotas == nil {
				m.Quotas = make(map[string]CheckRequest_QuotaParams)
			}
			var mapkey string
			mapvalue := &CheckRequest_QuotaParams{}
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowCheck
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowCheck
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthCheck
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowCheck
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthCheck
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthCheck
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &CheckRequest_QuotaParams{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipCheck(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthCheck
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Quotas[mapkey] = *mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCheck(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCheck
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CheckRequest_QuotaParams) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCheck
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QuotaParams: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QuotaParams: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Amount", wireType)
			}
			m.Amount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Amount |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BestEffort", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.BestEffort = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipCheck(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCheck
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CheckResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCheck
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CheckResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CheckResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Precondition", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Precondition.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Quotas", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Quotas == nil {
				m.Quotas = make(map[string]CheckResponse_QuotaResult)
			}
			var mapkey string
			mapvalue := &CheckResponse_QuotaResult{}
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowCheck
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowCheck
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthCheck
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowCheck
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthCheck
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthCheck
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &CheckResponse_QuotaResult{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipCheck(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthCheck
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Quotas[mapkey] = *mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCheck(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCheck
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CheckResponse_PreconditionResult) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCheck
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PreconditionResult: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PreconditionResult: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Status.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValidDuration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := types.StdDurationUnmarshal(&m.ValidDuration, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValidUseCount", wireType)
			}
			m.ValidUseCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ValidUseCount |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Attributes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReferencedAttributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ReferencedAttributes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCheck(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCheck
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CheckResponse_QuotaResult) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCheck
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QuotaResult: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QuotaResult: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValidDuration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := types.StdDurationUnmarshal(&m.ValidDuration, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GrantedAmount", wireType)
			}
			m.GrantedAmount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.GrantedAmount |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReferencedAttributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ReferencedAttributes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCheck(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCheck
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReferencedAttributes) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCheck
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReferencedAttributes: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReferencedAttributes: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Words", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Words = append(m.Words, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AttributeMatches", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AttributeMatches = append(m.AttributeMatches, ReferencedAttributes_AttributeMatch{})
			if err := m.AttributeMatches[len(m.AttributeMatches)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCheck(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCheck
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReferencedAttributes_AttributeMatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCheck
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AttributeMatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AttributeMatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			v = int32((uint32(v) >> 1) ^ uint32(((v&1)<<31)>>31))
			m.Name = v
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Condition", wireType)
			}
			m.Condition = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Condition |= (ReferencedAttributes_Condition(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Regex", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Regex = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MapKey", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			v = int32((uint32(v) >> 1) ^ uint32(((v&1)<<31)>>31))
			m.MapKey = v
		default:
			iNdEx = preIndex
			skippy, err := skipCheck(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCheck
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipCheck(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowCheck
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthCheck
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowCheck
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipCheck(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthCheck = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowCheck   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("mixer/v1/check.proto", fileDescriptorCheck) }

var fileDescriptorCheck = []byte{
	// 832 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x55, 0x4d, 0x73, 0xdb, 0x44,
	0x18, 0x96, 0x2c, 0xdb, 0xad, 0x5f, 0x37, 0x8e, 0xb3, 0xe3, 0x50, 0xc7, 0x07, 0x25, 0x93, 0x01,
	0xc6, 0xe5, 0x20, 0xb7, 0xe9, 0x85, 0xe1, 0x00, 0x93, 0x38, 0x4a, 0xc6, 0x05, 0xd2, 0xa0, 0xb4,
	0x43, 0xa7, 0x17, 0xcd, 0x5a, 0x5a, 0xbb, 0x9a, 0x5a, 0x5e, 0x75, 0xb5, 0x0a, 0xcd, 0x8d, 0x19,
	0xfe, 0x00, 0x47, 0xae, 0x5c, 0x18, 0x7e, 0x4a, 0x8e, 0x3d, 0x72, 0x02, 0x6c, 0x0e, 0xf4, 0xd8,
	0x9f, 0xc0, 0xec, 0x87, 0x55, 0x6b, 0x92, 0x82, 0x07, 0x86, 0xdb, 0xee, 0xfb, 0xf1, 0xec, 0xf3,
	0x3e, 0xf3, 0xbc, 0x12, 0xb4, 0xe2, 0xe8, 0x25, 0x61, 0xbd, 0xf3, 0x7b, 0xbd, 0xe0, 0x19, 0x09,
	0x9e, 0x3b, 0x09, 0xa3, 0x9c, 0xa2, 0x46, 0x94, 0xf2, 0x88, 0x3a, 0x32, 0xe7, 0x9c, 0xdf, 0xeb,
	0xb4, 0xc6, 0x74, 0x4c, 0x65, 0xaa, 0x27, 0x4e, 0xaa, 0xaa, 0x63, 0x8f, 0x29, 0x1d, 0x4f, 0x48,
	0x4f, 0xde, 0x86, 0xd9, 0xa8, 0x17, 0x66, 0x0c, 0xf3, 0x88, 0x4e, 0x75, 0xfe, 0xb6, 0xce, 0xb3,
	0x24, 0xe8, 0xa5, 0x1c, 0xf3, 0x2c, 0xd5, 0x89, 0xad, 0xfc, 0x51, 0xcc, 0x39, 0x8b, 0x86, 0x19,
	0x27, 0x3a, 0xb5, 0xfb, 0x93, 0x05, 0xb7, 0xfa, 0x82, 0x89, 0x47, 0x5e, 0x64, 0x24, 0xe5, 0xe8,
	0x01, 0xc0, 0xdb, 0xa2, 0xb6, 0xb9, 0x63, 0x76, 0xeb, 0x7b, 0xef, 0x3b, 0x45, 0x7e, 0x4e, 0x9f,
	0xc6, 0x09, 0x23, 0x69, 0x4a, 0xc2, 0xfd, 0xbc, 0xf6, 0xa0, 0x7c, 0xf9, 0xeb, 0xb6, 0xe1, 0x2d,
	0x75, 0xa3, 0x8f, 0x60, 0x63, 0x3c, 0xa1, 0x43, 0x3c, 0xf1, 0xbf, 0xa1, 0x2c, 0xf4, 0x03, 0x9a,
	0x4d, 0x79, 0xbb, 0xb4, 0x63, 0x76, 0xd7, 0xbc, 0x75, 0x95, 0xf8, 0x9a, 0xb2, 0xb0, 0x2f, 0xc2,
	0xe8, 0x0e, 0x34, 0x43, 0x12, 0x66, 0xc9, 0x24, 0x0a, 0xe4, 0x4c, 0x7e, 0x14, 0xb6, 0xad, 0x1d,
	0xb3, 0x5b, 0xf3, 0xd6, 0x0b, 0xf1, 0x41, 0x88, 0x8e, 0xa0, 0xfa, 0x22, 0xa3, 0x1c, 0xa7, 0xed,
	0xf2, 0x8e, 0xd5, 0xad, 0xef, 0x75, 0xaf, 0xd0, 0x5b, 0x1a, 0xc8, 0xf9, 0x4a, 0x96, 0xba, 0x53,
	0xce, 0x2e, 0x34, 0x45, 0xdd, 0xdd, 0x39, 0x82, 0xba, 0x4c, 0x9e, 0x62, 0x86, 0xe3, 0x14, 0xbd,
	0x07, 0x55, 0x1c, 0x4b, 0x8a, 0x62, 0x6a, 0xcb, 0xd3, 0x37, 0xb4, 0x0d, 0xf5, 0x21, 0x49, 0xb9,
	0x4f, 0x46, 0x23, 0xca, 0x14, 0xff, 0x9b, 0x1e, 0x88, 0x90, 0x2b, 0x23, 0x9d, 0x40, 0xe3, 0xa8,
	0x47, 0x50, 0x13, 0xac, 0xe7, 0xe4, 0x42, 0x82, 0xd4, 0x3c, 0x71, 0x44, 0x9f, 0x42, 0xe5, 0x1c,
	0x4f, 0x32, 0x22, 0x7b, 0x57, 0xe2, 0xab, 0x28, 0x79, 0xaa, 0xed, 0x93, 0xd2, 0xc7, 0xe6, 0xee,
	0xeb, 0x2a, 0xac, 0xe9, 0xba, 0x34, 0xa1, 0xd3, 0x94, 0xa0, 0xa7, 0x70, 0x2b, 0x61, 0x24, 0xa0,
	0xd3, 0x30, 0x12, 0xc2, 0x68, 0xf0, 0xbb, 0xef, 0x00, 0x57, 0x4d, 0xce, 0xe9, 0x52, 0x87, 0x47,
	0xd2, 0x6c, 0xc2, 0xb5, 0x28, 0x05, 0x2c, 0x74, 0x9c, 0x4b, 0x6c, 0x49, 0x89, 0xef, 0xfc, 0x3d,
	0xea, 0xbb, 0x35, 0xfe, 0xb3, 0x04, 0xe8, 0xea, 0x9b, 0xe8, 0x2e, 0x54, 0x95, 0x43, 0xb5, 0xc3,
	0x90, 0xa3, 0xbc, 0xeb, 0xb0, 0x24, 0x70, 0xce, 0x64, 0x66, 0x01, 0xa4, 0xea, 0xd0, 0x03, 0x68,
	0x9c, 0xe3, 0x49, 0x14, 0xfa, 0x0b, 0xd3, 0xeb, 0x79, 0xb7, 0x16, 0x9d, 0x8b, 0xad, 0x70, 0x0e,
	0x75, 0xc1, 0xc1, 0x4d, 0x01, 0xf0, 0xc3, 0x6f, 0xdb, 0xa6, 0xb7, 0x26, 0x5b, 0x17, 0x09, 0xf4,
	0x21, 0xac, 0x2b, 0xac, 0x2c, 0x25, 0xda, 0x95, 0xc2, 0x6a, 0x15, 0x5d, 0xf7, 0x38, 0x25, 0xca,
	0x93, 0xc5, 0x5d, 0x28, 0xff, 0xa7, 0x5d, 0xf0, 0x61, 0x93, 0x91, 0x11, 0x61, 0x64, 0x1a, 0x90,
	0xd0, 0x5f, 0x82, 0xad, 0x5c, 0x0f, 0xeb, 0xe5, 0xc5, 0x57, 0x60, 0x5b, 0xec, 0x9a, 0x5c, 0x67,
	0x66, 0x6a, 0x1b, 0x6a, 0x89, 0xaf, 0x0a, 0x66, 0xfe, 0x6b, 0xc1, 0x3e, 0x80, 0xc6, 0x98, 0xe1,
	0x29, 0x17, 0xcc, 0xe3, 0x7c, 0x8b, 0x2d, 0x6f, 0x4d, 0x47, 0xf7, 0xd5, 0xa6, 0xfc, 0xef, 0x33,
	0x86, 0xff, 0xb4, 0x69, 0x9f, 0x15, 0x37, 0x6d, 0x15, 0xdb, 0x2a, 0xb9, 0x96, 0x57, 0xed, 0x3b,
	0x0b, 0x5a, 0xd7, 0x51, 0x43, 0x2d, 0xa8, 0x88, 0x0f, 0x99, 0x30, 0xad, 0xd5, 0xad, 0x79, 0xea,
	0x82, 0x46, 0xb0, 0x91, 0x8f, 0xea, 0xc7, 0x98, 0x07, 0xcf, 0x48, 0xda, 0x2e, 0xc9, 0xb5, 0xb9,
	0xbf, 0xca, 0xc4, 0x4e, 0x7e, 0xfc, 0x52, 0x34, 0x6b, 0x01, 0x9a, 0xb8, 0x10, 0x25, 0x69, 0xe7,
	0x47, 0x13, 0x1a, 0xc5, 0x52, 0x84, 0xa0, 0x3c, 0xc5, 0x31, 0x91, 0x0a, 0x6c, 0x78, 0xf2, 0x8c,
	0xbe, 0x80, 0x5a, 0xf1, 0x9b, 0xd0, 0xd8, 0x73, 0x56, 0xa2, 0xd1, 0xcf, 0x77, 0xf4, 0x2d, 0x80,
	0x18, 0x99, 0x91, 0x31, 0x79, 0xa9, 0xbf, 0xc5, 0xea, 0x82, 0x6e, 0xc3, 0x8d, 0x18, 0x27, 0xbe,
	0x10, 0xbf, 0x2c, 0x9f, 0xae, 0xc6, 0x38, 0xf9, 0x9c, 0x5c, 0xec, 0x0e, 0xa0, 0x96, 0xc3, 0xa0,
	0x2d, 0xd8, 0xec, 0x3f, 0x3c, 0x39, 0x1c, 0x3c, 0x1a, 0x3c, 0x3c, 0xf1, 0x1f, 0x9f, 0x9c, 0x9d,
	0xba, 0xfd, 0xc1, 0xd1, 0xc0, 0x3d, 0x6c, 0x1a, 0xa8, 0x0e, 0x37, 0xf6, 0x0f, 0xce, 0xdc, 0x93,
	0xbe, 0xdb, 0x34, 0x51, 0x0d, 0x2a, 0xee, 0x93, 0xfd, 0xfe, 0xa3, 0x66, 0x49, 0x1c, 0x3d, 0xf7,
	0xd8, 0x7d, 0xd2, 0xb4, 0x0e, 0x8e, 0x2f, 0x67, 0xb6, 0xf1, 0x6a, 0x66, 0x1b, 0xbf, 0xcc, 0x6c,
	0xe3, 0xcd, 0xcc, 0x36, 0xbe, 0x9d, 0xdb, 0xe6, 0xcf, 0x73, 0xdb, 0xb8, 0x9c, 0xdb, 0xe6, 0xab,
	0xb9, 0x6d, 0xfe, 0x3e, 0xb7, 0xcd, 0xd7, 0x73, 0xdb, 0x78, 0x33, 0xb7, 0xcd, 0xef, 0xff, 0xb0,
	0x8d, 0xa7, 0x9b, 0x6a, 0xca, 0x88, 0xf6, 0x70, 0x12, 0xf5, 0x16, 0xff, 0xbc, 0x61, 0x55, 0x1a,
	0xfd, 0xfe, 0x5f, 0x01, 0x00, 0x00, 0xff, 0xff, 0xca, 0x66, 0xc1, 0x7e, 0x7b, 0x07, 0x00, 0x00,
}
