// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: mixer/v1/attributes.proto

/*
	Package v1 is a generated protocol buffer package.

	It is generated from these files:
		mixer/v1/attributes.proto
		mixer/v1/check.proto
		mixer/v1/report.proto
		mixer/v1/service.proto

	It has these top-level messages:
		Attributes
		CompressedAttributes
		StringMap
		CheckRequest
		CheckResponse
		ReferencedAttributes
		ReportRequest
		ReportResponse
*/
package v1

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"
import google_protobuf1 "github.com/gogo/protobuf/types"
import google_protobuf2 "github.com/gogo/protobuf/types"

import time "time"

import binary "encoding/binary"
import types "github.com/gogo/protobuf/types"

import strings "strings"
import reflect "reflect"
import sortkeys "github.com/gogo/protobuf/sortkeys"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Attributes represents a set of typed name/value pairs. Many of Mixer's
// API either consume and/or return attributes.
//
// Istio uses attributes to control the runtime behavior of services running in the service mesh.
// Attributes are named and typed pieces of metadata describing ingress and egress traffic and the
// environment this traffic occurs in. An Istio attribute carries a specific piece
// of information such as the error code of an API request, the latency of an API request, or the
// original IP address of a TCP connection. For example:
//
// ```
// request.path: xyz/abc
// request.size: 234
// request.time: 12:34:56.789 04/17/2017
// source.ip: 192.168.0.1
// target.service: example
// ```
//
// A given Istio deployment has a fixed vocabulary of attributes that it understands.
// The specific vocabulary is determined by the set of attribute producers being used
// in the deployment. The primary attribute producer in Istio is Envoy, although
// specialized Mixer adapters and services can also generate attributes.
//
// The common baseline set of attributes available in most Istio deployments is defined
// [here](https://istio.io/docs/reference/config/mixer/attribute-vocabulary.html).
//
// Attributes are strongly typed. The supported attribute types are defined by
// [ValueType](https://github.com/istio/api/blob/master/policy/v1beta1/value_type.proto).
// Each type of value is encoded into one of the so-called transport types present
// in this message.
//
// Defines a map of attributes in uncompressed format.
// Following places may use this message:
// 1) Configure Istio/Proxy with static per-proxy attributes, such as source.uid.
// 2) Service IDL definition to extract api attributes for active requests.
// 3) Forward attributes from client proxy to server proxy for HTTP requests.
type Attributes struct {
	// A map of attribute name to its value.
	Attributes map[string]*Attributes_AttributeValue `protobuf:"bytes,1,rep,name=attributes" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *Attributes) Reset()                    { *m = Attributes{} }
func (*Attributes) ProtoMessage()               {}
func (*Attributes) Descriptor() ([]byte, []int) { return fileDescriptorAttributes, []int{0} }

// Specifies one attribute value with different type.
type Attributes_AttributeValue struct {
	// The attribute value.
	//
	// Types that are valid to be assigned to Value:
	//	*Attributes_AttributeValue_StringValue
	//	*Attributes_AttributeValue_Int64Value
	//	*Attributes_AttributeValue_DoubleValue
	//	*Attributes_AttributeValue_BoolValue
	//	*Attributes_AttributeValue_BytesValue
	//	*Attributes_AttributeValue_TimestampValue
	//	*Attributes_AttributeValue_DurationValue
	//	*Attributes_AttributeValue_StringMapValue
	Value isAttributes_AttributeValue_Value `protobuf_oneof:"value"`
}

func (m *Attributes_AttributeValue) Reset()      { *m = Attributes_AttributeValue{} }
func (*Attributes_AttributeValue) ProtoMessage() {}
func (*Attributes_AttributeValue) Descriptor() ([]byte, []int) {
	return fileDescriptorAttributes, []int{0, 1}
}

type isAttributes_AttributeValue_Value interface {
	isAttributes_AttributeValue_Value()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Attributes_AttributeValue_StringValue struct {
	StringValue string `protobuf:"bytes,2,opt,name=string_value,json=stringValue,proto3,oneof"`
}
type Attributes_AttributeValue_Int64Value struct {
	Int64Value int64 `protobuf:"varint,3,opt,name=int64_value,json=int64Value,proto3,oneof"`
}
type Attributes_AttributeValue_DoubleValue struct {
	DoubleValue float64 `protobuf:"fixed64,4,opt,name=double_value,json=doubleValue,proto3,oneof"`
}
type Attributes_AttributeValue_BoolValue struct {
	BoolValue bool `protobuf:"varint,5,opt,name=bool_value,json=boolValue,proto3,oneof"`
}
type Attributes_AttributeValue_BytesValue struct {
	BytesValue []byte `protobuf:"bytes,6,opt,name=bytes_value,json=bytesValue,proto3,oneof"`
}
type Attributes_AttributeValue_TimestampValue struct {
	TimestampValue *google_protobuf2.Timestamp `protobuf:"bytes,7,opt,name=timestamp_value,json=timestampValue,oneof"`
}
type Attributes_AttributeValue_DurationValue struct {
	DurationValue *google_protobuf1.Duration `protobuf:"bytes,8,opt,name=duration_value,json=durationValue,oneof"`
}
type Attributes_AttributeValue_StringMapValue struct {
	StringMapValue *Attributes_StringMap `protobuf:"bytes,9,opt,name=string_map_value,json=stringMapValue,oneof"`
}

func (*Attributes_AttributeValue_StringValue) isAttributes_AttributeValue_Value()    {}
func (*Attributes_AttributeValue_Int64Value) isAttributes_AttributeValue_Value()     {}
func (*Attributes_AttributeValue_DoubleValue) isAttributes_AttributeValue_Value()    {}
func (*Attributes_AttributeValue_BoolValue) isAttributes_AttributeValue_Value()      {}
func (*Attributes_AttributeValue_BytesValue) isAttributes_AttributeValue_Value()     {}
func (*Attributes_AttributeValue_TimestampValue) isAttributes_AttributeValue_Value() {}
func (*Attributes_AttributeValue_DurationValue) isAttributes_AttributeValue_Value()  {}
func (*Attributes_AttributeValue_StringMapValue) isAttributes_AttributeValue_Value() {}

func (m *Attributes_AttributeValue) GetValue() isAttributes_AttributeValue_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *Attributes_AttributeValue) GetStringValue() string {
	if x, ok := m.GetValue().(*Attributes_AttributeValue_StringValue); ok {
		return x.StringValue
	}
	return ""
}

func (m *Attributes_AttributeValue) GetInt64Value() int64 {
	if x, ok := m.GetValue().(*Attributes_AttributeValue_Int64Value); ok {
		return x.Int64Value
	}
	return 0
}

func (m *Attributes_AttributeValue) GetDoubleValue() float64 {
	if x, ok := m.GetValue().(*Attributes_AttributeValue_DoubleValue); ok {
		return x.DoubleValue
	}
	return 0
}

func (m *Attributes_AttributeValue) GetBoolValue() bool {
	if x, ok := m.GetValue().(*Attributes_AttributeValue_BoolValue); ok {
		return x.BoolValue
	}
	return false
}

func (m *Attributes_AttributeValue) GetBytesValue() []byte {
	if x, ok := m.GetValue().(*Attributes_AttributeValue_BytesValue); ok {
		return x.BytesValue
	}
	return nil
}

func (m *Attributes_AttributeValue) GetTimestampValue() *google_protobuf2.Timestamp {
	if x, ok := m.GetValue().(*Attributes_AttributeValue_TimestampValue); ok {
		return x.TimestampValue
	}
	return nil
}

func (m *Attributes_AttributeValue) GetDurationValue() *google_protobuf1.Duration {
	if x, ok := m.GetValue().(*Attributes_AttributeValue_DurationValue); ok {
		return x.DurationValue
	}
	return nil
}

func (m *Attributes_AttributeValue) GetStringMapValue() *Attributes_StringMap {
	if x, ok := m.GetValue().(*Attributes_AttributeValue_StringMapValue); ok {
		return x.StringMapValue
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Attributes_AttributeValue) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Attributes_AttributeValue_OneofMarshaler, _Attributes_AttributeValue_OneofUnmarshaler, _Attributes_AttributeValue_OneofSizer, []interface{}{
		(*Attributes_AttributeValue_StringValue)(nil),
		(*Attributes_AttributeValue_Int64Value)(nil),
		(*Attributes_AttributeValue_DoubleValue)(nil),
		(*Attributes_AttributeValue_BoolValue)(nil),
		(*Attributes_AttributeValue_BytesValue)(nil),
		(*Attributes_AttributeValue_TimestampValue)(nil),
		(*Attributes_AttributeValue_DurationValue)(nil),
		(*Attributes_AttributeValue_StringMapValue)(nil),
	}
}

func _Attributes_AttributeValue_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Attributes_AttributeValue)
	// value
	switch x := m.Value.(type) {
	case *Attributes_AttributeValue_StringValue:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.StringValue)
	case *Attributes_AttributeValue_Int64Value:
		_ = b.EncodeVarint(3<<3 | proto.WireVarint)
		_ = b.EncodeVarint(uint64(x.Int64Value))
	case *Attributes_AttributeValue_DoubleValue:
		_ = b.EncodeVarint(4<<3 | proto.WireFixed64)
		_ = b.EncodeFixed64(math.Float64bits(x.DoubleValue))
	case *Attributes_AttributeValue_BoolValue:
		t := uint64(0)
		if x.BoolValue {
			t = 1
		}
		_ = b.EncodeVarint(5<<3 | proto.WireVarint)
		_ = b.EncodeVarint(t)
	case *Attributes_AttributeValue_BytesValue:
		_ = b.EncodeVarint(6<<3 | proto.WireBytes)
		_ = b.EncodeRawBytes(x.BytesValue)
	case *Attributes_AttributeValue_TimestampValue:
		_ = b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TimestampValue); err != nil {
			return err
		}
	case *Attributes_AttributeValue_DurationValue:
		_ = b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DurationValue); err != nil {
			return err
		}
	case *Attributes_AttributeValue_StringMapValue:
		_ = b.EncodeVarint(9<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.StringMapValue); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Attributes_AttributeValue.Value has unexpected type %T", x)
	}
	return nil
}

func _Attributes_AttributeValue_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Attributes_AttributeValue)
	switch tag {
	case 2: // value.string_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Value = &Attributes_AttributeValue_StringValue{x}
		return true, err
	case 3: // value.int64_value
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Value = &Attributes_AttributeValue_Int64Value{int64(x)}
		return true, err
	case 4: // value.double_value
		if wire != proto.WireFixed64 {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeFixed64()
		m.Value = &Attributes_AttributeValue_DoubleValue{math.Float64frombits(x)}
		return true, err
	case 5: // value.bool_value
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Value = &Attributes_AttributeValue_BoolValue{x != 0}
		return true, err
	case 6: // value.bytes_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Value = &Attributes_AttributeValue_BytesValue{x}
		return true, err
	case 7: // value.timestamp_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(google_protobuf2.Timestamp)
		err := b.DecodeMessage(msg)
		m.Value = &Attributes_AttributeValue_TimestampValue{msg}
		return true, err
	case 8: // value.duration_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(google_protobuf1.Duration)
		err := b.DecodeMessage(msg)
		m.Value = &Attributes_AttributeValue_DurationValue{msg}
		return true, err
	case 9: // value.string_map_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Attributes_StringMap)
		err := b.DecodeMessage(msg)
		m.Value = &Attributes_AttributeValue_StringMapValue{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Attributes_AttributeValue_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Attributes_AttributeValue)
	// value
	switch x := m.Value.(type) {
	case *Attributes_AttributeValue_StringValue:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.StringValue)))
		n += len(x.StringValue)
	case *Attributes_AttributeValue_Int64Value:
		n += proto.SizeVarint(3<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.Int64Value))
	case *Attributes_AttributeValue_DoubleValue:
		n += proto.SizeVarint(4<<3 | proto.WireFixed64)
		n += 8
	case *Attributes_AttributeValue_BoolValue:
		n += proto.SizeVarint(5<<3 | proto.WireVarint)
		n += 1
	case *Attributes_AttributeValue_BytesValue:
		n += proto.SizeVarint(6<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.BytesValue)))
		n += len(x.BytesValue)
	case *Attributes_AttributeValue_TimestampValue:
		s := proto.Size(x.TimestampValue)
		n += proto.SizeVarint(7<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Attributes_AttributeValue_DurationValue:
		s := proto.Size(x.DurationValue)
		n += proto.SizeVarint(8<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Attributes_AttributeValue_StringMapValue:
		s := proto.Size(x.StringMapValue)
		n += proto.SizeVarint(9<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Defines a string map.
type Attributes_StringMap struct {
	// Holds a set of name/value pairs.
	Entries map[string]string `protobuf:"bytes,1,rep,name=entries" json:"entries,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *Attributes_StringMap) Reset()      { *m = Attributes_StringMap{} }
func (*Attributes_StringMap) ProtoMessage() {}
func (*Attributes_StringMap) Descriptor() ([]byte, []int) {
	return fileDescriptorAttributes, []int{0, 2}
}

// Defines a list of attributes in compressed format optimized for transport.
// Within this message, strings are referenced using integer indices into
// one of two string dictionaries. Positive integers index into the global
// deployment-wide dictionary, whereas negative integers index into the message-level
// dictionary instead. The message-level dictionary is carried by the
// `words` field of this message, the deployment-wide dictionary is determined via
// configuration.
type CompressedAttributes struct {
	// The message-level dictionary.
	Words []string `protobuf:"bytes,1,rep,name=words" json:"words,omitempty"`
	// Holds attributes of type STRING, DNS_NAME, EMAIL_ADDRESS, URI
	Strings map[int32]int32 `protobuf:"bytes,2,rep,name=strings" json:"strings,omitempty" protobuf_key:"zigzag32,1,opt,name=key,proto3" protobuf_val:"zigzag32,2,opt,name=value,proto3"`
	// Holds attributes of type INT64
	Int64S map[int32]int64 `protobuf:"bytes,3,rep,name=int64s" json:"int64s,omitempty" protobuf_key:"zigzag32,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// Holds attributes of type DOUBLE
	Doubles map[int32]float64 `protobuf:"bytes,4,rep,name=doubles" json:"doubles,omitempty" protobuf_key:"zigzag32,1,opt,name=key,proto3" protobuf_val:"fixed64,2,opt,name=value,proto3"`
	// Holds attributes of type BOOL
	Bools map[int32]bool `protobuf:"bytes,5,rep,name=bools" json:"bools,omitempty" protobuf_key:"zigzag32,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// Holds attributes of type TIMESTAMP
	Timestamps map[int32]time.Time `protobuf:"bytes,6,rep,name=timestamps,stdtime" json:"timestamps" protobuf_key:"zigzag32,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
	// Holds attributes of type DURATION
	Durations map[int32]time.Duration `protobuf:"bytes,7,rep,name=durations,stdduration" json:"durations" protobuf_key:"zigzag32,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
	// Holds attributes of type BYTES
	Bytes map[int32][]byte `protobuf:"bytes,8,rep,name=bytes" json:"bytes,omitempty" protobuf_key:"zigzag32,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Holds attributes of type STRING_MAP
	StringMaps map[int32]StringMap `protobuf:"bytes,9,rep,name=string_maps,json=stringMaps" json:"string_maps" protobuf_key:"zigzag32,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *CompressedAttributes) Reset()                    { *m = CompressedAttributes{} }
func (*CompressedAttributes) ProtoMessage()               {}
func (*CompressedAttributes) Descriptor() ([]byte, []int) { return fileDescriptorAttributes, []int{1} }

// A map of string to string. The keys and values in this map are dictionary
// indices (see the [Attributes][istio.mixer.v1.CompressedAttributes] message for an explanation)
type StringMap struct {
	// Holds a set of name/value pairs.
	Entries map[int32]int32 `protobuf:"bytes,1,rep,name=entries" json:"entries,omitempty" protobuf_key:"zigzag32,1,opt,name=key,proto3" protobuf_val:"zigzag32,2,opt,name=value,proto3"`
}

func (m *StringMap) Reset()                    { *m = StringMap{} }
func (*StringMap) ProtoMessage()               {}
func (*StringMap) Descriptor() ([]byte, []int) { return fileDescriptorAttributes, []int{2} }

func init() {
	proto.RegisterType((*Attributes)(nil), "istio.mixer.v1.Attributes")
	proto.RegisterType((*Attributes_AttributeValue)(nil), "istio.mixer.v1.Attributes.AttributeValue")
	proto.RegisterType((*Attributes_StringMap)(nil), "istio.mixer.v1.Attributes.StringMap")
	proto.RegisterType((*CompressedAttributes)(nil), "istio.mixer.v1.CompressedAttributes")
	proto.RegisterType((*StringMap)(nil), "istio.mixer.v1.StringMap")
}
func (m *Attributes) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Attributes) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Attributes) > 0 {
		for k, _ := range m.Attributes {
			dAtA[i] = 0xa
			i++
			v := m.Attributes[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovAttributes(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovAttributes(uint64(len(k))) + msgSize
			i = encodeVarintAttributes(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintAttributes(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintAttributes(dAtA, i, uint64(v.Size()))
				n1, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n1
			}
		}
	}
	return i, nil
}

func (m *Attributes_AttributeValue) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Attributes_AttributeValue) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Value != nil {
		nn2, err := m.Value.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn2
	}
	return i, nil
}

func (m *Attributes_AttributeValue_StringValue) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x12
	i++
	i = encodeVarintAttributes(dAtA, i, uint64(len(m.StringValue)))
	i += copy(dAtA[i:], m.StringValue)
	return i, nil
}
func (m *Attributes_AttributeValue_Int64Value) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x18
	i++
	i = encodeVarintAttributes(dAtA, i, uint64(m.Int64Value))
	return i, nil
}
func (m *Attributes_AttributeValue_DoubleValue) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x21
	i++
	binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.DoubleValue))))
	i += 8
	return i, nil
}
func (m *Attributes_AttributeValue_BoolValue) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x28
	i++
	if m.BoolValue {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	return i, nil
}
func (m *Attributes_AttributeValue_BytesValue) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.BytesValue != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintAttributes(dAtA, i, uint64(len(m.BytesValue)))
		i += copy(dAtA[i:], m.BytesValue)
	}
	return i, nil
}
func (m *Attributes_AttributeValue_TimestampValue) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.TimestampValue != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintAttributes(dAtA, i, uint64(m.TimestampValue.Size()))
		n3, err := m.TimestampValue.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	return i, nil
}
func (m *Attributes_AttributeValue_DurationValue) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.DurationValue != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintAttributes(dAtA, i, uint64(m.DurationValue.Size()))
		n4, err := m.DurationValue.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	return i, nil
}
func (m *Attributes_AttributeValue_StringMapValue) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.StringMapValue != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintAttributes(dAtA, i, uint64(m.StringMapValue.Size()))
		n5, err := m.StringMapValue.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	return i, nil
}
func (m *Attributes_StringMap) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Attributes_StringMap) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Entries) > 0 {
		for k, _ := range m.Entries {
			dAtA[i] = 0xa
			i++
			v := m.Entries[k]
			mapSize := 1 + len(k) + sovAttributes(uint64(len(k))) + 1 + len(v) + sovAttributes(uint64(len(v)))
			i = encodeVarintAttributes(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintAttributes(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintAttributes(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	return i, nil
}

func (m *CompressedAttributes) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CompressedAttributes) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Words) > 0 {
		for _, s := range m.Words {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.Strings) > 0 {
		for k, _ := range m.Strings {
			dAtA[i] = 0x12
			i++
			v := m.Strings[k]
			mapSize := 1 + sozAttributes(uint64(k)) + 1 + sozAttributes(uint64(v))
			i = encodeVarintAttributes(dAtA, i, uint64(mapSize))
			dAtA[i] = 0x8
			i++
			i = encodeVarintAttributes(dAtA, i, uint64((uint32(k)<<1)^uint32((k>>31))))
			dAtA[i] = 0x10
			i++
			i = encodeVarintAttributes(dAtA, i, uint64((uint32(v)<<1)^uint32((v>>31))))
		}
	}
	if len(m.Int64S) > 0 {
		for k, _ := range m.Int64S {
			dAtA[i] = 0x1a
			i++
			v := m.Int64S[k]
			mapSize := 1 + sozAttributes(uint64(k)) + 1 + sovAttributes(uint64(v))
			i = encodeVarintAttributes(dAtA, i, uint64(mapSize))
			dAtA[i] = 0x8
			i++
			i = encodeVarintAttributes(dAtA, i, uint64((uint32(k)<<1)^uint32((k>>31))))
			dAtA[i] = 0x10
			i++
			i = encodeVarintAttributes(dAtA, i, uint64(v))
		}
	}
	if len(m.Doubles) > 0 {
		for k, _ := range m.Doubles {
			dAtA[i] = 0x22
			i++
			v := m.Doubles[k]
			mapSize := 1 + sozAttributes(uint64(k)) + 1 + 8
			i = encodeVarintAttributes(dAtA, i, uint64(mapSize))
			dAtA[i] = 0x8
			i++
			i = encodeVarintAttributes(dAtA, i, uint64((uint32(k)<<1)^uint32((k>>31))))
			dAtA[i] = 0x11
			i++
			binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(v))))
			i += 8
		}
	}
	if len(m.Bools) > 0 {
		for k, _ := range m.Bools {
			dAtA[i] = 0x2a
			i++
			v := m.Bools[k]
			mapSize := 1 + sozAttributes(uint64(k)) + 1 + 1
			i = encodeVarintAttributes(dAtA, i, uint64(mapSize))
			dAtA[i] = 0x8
			i++
			i = encodeVarintAttributes(dAtA, i, uint64((uint32(k)<<1)^uint32((k>>31))))
			dAtA[i] = 0x10
			i++
			if v {
				dAtA[i] = 1
			} else {
				dAtA[i] = 0
			}
			i++
		}
	}
	if len(m.Timestamps) > 0 {
		for k, _ := range m.Timestamps {
			dAtA[i] = 0x32
			i++
			v := m.Timestamps[k]
			msgSize := 0
			if (&v) != nil {
				msgSize = types.SizeOfStdTime(*(&v))
				msgSize += 1 + sovAttributes(uint64(msgSize))
			}
			mapSize := 1 + sozAttributes(uint64(k)) + msgSize
			i = encodeVarintAttributes(dAtA, i, uint64(mapSize))
			dAtA[i] = 0x8
			i++
			i = encodeVarintAttributes(dAtA, i, uint64((uint32(k)<<1)^uint32((k>>31))))
			dAtA[i] = 0x12
			i++
			i = encodeVarintAttributes(dAtA, i, uint64(types.SizeOfStdTime(*(&v))))
			n6, err := types.StdTimeMarshalTo(*(&v), dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n6
		}
	}
	if len(m.Durations) > 0 {
		for k, _ := range m.Durations {
			dAtA[i] = 0x3a
			i++
			v := m.Durations[k]
			msgSize := 0
			if (&v) != nil {
				msgSize = types.SizeOfStdDuration(*(&v))
				msgSize += 1 + sovAttributes(uint64(msgSize))
			}
			mapSize := 1 + sozAttributes(uint64(k)) + msgSize
			i = encodeVarintAttributes(dAtA, i, uint64(mapSize))
			dAtA[i] = 0x8
			i++
			i = encodeVarintAttributes(dAtA, i, uint64((uint32(k)<<1)^uint32((k>>31))))
			dAtA[i] = 0x12
			i++
			i = encodeVarintAttributes(dAtA, i, uint64(types.SizeOfStdDuration(*(&v))))
			n7, err := types.StdDurationMarshalTo(*(&v), dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n7
		}
	}
	if len(m.Bytes) > 0 {
		for k, _ := range m.Bytes {
			dAtA[i] = 0x42
			i++
			v := m.Bytes[k]
			byteSize := 0
			if len(v) > 0 {
				byteSize = 1 + len(v) + sovAttributes(uint64(len(v)))
			}
			mapSize := 1 + sozAttributes(uint64(k)) + byteSize
			i = encodeVarintAttributes(dAtA, i, uint64(mapSize))
			dAtA[i] = 0x8
			i++
			i = encodeVarintAttributes(dAtA, i, uint64((uint32(k)<<1)^uint32((k>>31))))
			if len(v) > 0 {
				dAtA[i] = 0x12
				i++
				i = encodeVarintAttributes(dAtA, i, uint64(len(v)))
				i += copy(dAtA[i:], v)
			}
		}
	}
	if len(m.StringMaps) > 0 {
		for k, _ := range m.StringMaps {
			dAtA[i] = 0x4a
			i++
			v := m.StringMaps[k]
			msgSize := 0
			if (&v) != nil {
				msgSize = (&v).Size()
				msgSize += 1 + sovAttributes(uint64(msgSize))
			}
			mapSize := 1 + sozAttributes(uint64(k)) + msgSize
			i = encodeVarintAttributes(dAtA, i, uint64(mapSize))
			dAtA[i] = 0x8
			i++
			i = encodeVarintAttributes(dAtA, i, uint64((uint32(k)<<1)^uint32((k>>31))))
			dAtA[i] = 0x12
			i++
			i = encodeVarintAttributes(dAtA, i, uint64((&v).Size()))
			n8, err := (&v).MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n8
		}
	}
	return i, nil
}

func (m *StringMap) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StringMap) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Entries) > 0 {
		for k, _ := range m.Entries {
			dAtA[i] = 0xa
			i++
			v := m.Entries[k]
			mapSize := 1 + sozAttributes(uint64(k)) + 1 + sozAttributes(uint64(v))
			i = encodeVarintAttributes(dAtA, i, uint64(mapSize))
			dAtA[i] = 0x8
			i++
			i = encodeVarintAttributes(dAtA, i, uint64((uint32(k)<<1)^uint32((k>>31))))
			dAtA[i] = 0x10
			i++
			i = encodeVarintAttributes(dAtA, i, uint64((uint32(v)<<1)^uint32((v>>31))))
		}
	}
	return i, nil
}

func encodeVarintAttributes(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Attributes) Size() (n int) {
	var l int
	_ = l
	if len(m.Attributes) > 0 {
		for k, v := range m.Attributes {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovAttributes(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovAttributes(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovAttributes(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *Attributes_AttributeValue) Size() (n int) {
	var l int
	_ = l
	if m.Value != nil {
		n += m.Value.Size()
	}
	return n
}

func (m *Attributes_AttributeValue_StringValue) Size() (n int) {
	var l int
	_ = l
	l = len(m.StringValue)
	n += 1 + l + sovAttributes(uint64(l))
	return n
}
func (m *Attributes_AttributeValue_Int64Value) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovAttributes(uint64(m.Int64Value))
	return n
}
func (m *Attributes_AttributeValue_DoubleValue) Size() (n int) {
	var l int
	_ = l
	n += 9
	return n
}
func (m *Attributes_AttributeValue_BoolValue) Size() (n int) {
	var l int
	_ = l
	n += 2
	return n
}
func (m *Attributes_AttributeValue_BytesValue) Size() (n int) {
	var l int
	_ = l
	if m.BytesValue != nil {
		l = len(m.BytesValue)
		n += 1 + l + sovAttributes(uint64(l))
	}
	return n
}
func (m *Attributes_AttributeValue_TimestampValue) Size() (n int) {
	var l int
	_ = l
	if m.TimestampValue != nil {
		l = m.TimestampValue.Size()
		n += 1 + l + sovAttributes(uint64(l))
	}
	return n
}
func (m *Attributes_AttributeValue_DurationValue) Size() (n int) {
	var l int
	_ = l
	if m.DurationValue != nil {
		l = m.DurationValue.Size()
		n += 1 + l + sovAttributes(uint64(l))
	}
	return n
}
func (m *Attributes_AttributeValue_StringMapValue) Size() (n int) {
	var l int
	_ = l
	if m.StringMapValue != nil {
		l = m.StringMapValue.Size()
		n += 1 + l + sovAttributes(uint64(l))
	}
	return n
}
func (m *Attributes_StringMap) Size() (n int) {
	var l int
	_ = l
	if len(m.Entries) > 0 {
		for k, v := range m.Entries {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovAttributes(uint64(len(k))) + 1 + len(v) + sovAttributes(uint64(len(v)))
			n += mapEntrySize + 1 + sovAttributes(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *CompressedAttributes) Size() (n int) {
	var l int
	_ = l
	if len(m.Words) > 0 {
		for _, s := range m.Words {
			l = len(s)
			n += 1 + l + sovAttributes(uint64(l))
		}
	}
	if len(m.Strings) > 0 {
		for k, v := range m.Strings {
			_ = k
			_ = v
			mapEntrySize := 1 + sozAttributes(uint64(k)) + 1 + sozAttributes(uint64(v))
			n += mapEntrySize + 1 + sovAttributes(uint64(mapEntrySize))
		}
	}
	if len(m.Int64S) > 0 {
		for k, v := range m.Int64S {
			_ = k
			_ = v
			mapEntrySize := 1 + sozAttributes(uint64(k)) + 1 + sovAttributes(uint64(v))
			n += mapEntrySize + 1 + sovAttributes(uint64(mapEntrySize))
		}
	}
	if len(m.Doubles) > 0 {
		for k, v := range m.Doubles {
			_ = k
			_ = v
			mapEntrySize := 1 + sozAttributes(uint64(k)) + 1 + 8
			n += mapEntrySize + 1 + sovAttributes(uint64(mapEntrySize))
		}
	}
	if len(m.Bools) > 0 {
		for k, v := range m.Bools {
			_ = k
			_ = v
			mapEntrySize := 1 + sozAttributes(uint64(k)) + 1 + 1
			n += mapEntrySize + 1 + sovAttributes(uint64(mapEntrySize))
		}
	}
	if len(m.Timestamps) > 0 {
		for k, v := range m.Timestamps {
			_ = k
			_ = v
			l = types.SizeOfStdTime(v)
			mapEntrySize := 1 + sozAttributes(uint64(k)) + 1 + l + sovAttributes(uint64(l))
			n += mapEntrySize + 1 + sovAttributes(uint64(mapEntrySize))
		}
	}
	if len(m.Durations) > 0 {
		for k, v := range m.Durations {
			_ = k
			_ = v
			l = types.SizeOfStdDuration(v)
			mapEntrySize := 1 + sozAttributes(uint64(k)) + 1 + l + sovAttributes(uint64(l))
			n += mapEntrySize + 1 + sovAttributes(uint64(mapEntrySize))
		}
	}
	if len(m.Bytes) > 0 {
		for k, v := range m.Bytes {
			_ = k
			_ = v
			l = 0
			if len(v) > 0 {
				l = 1 + len(v) + sovAttributes(uint64(len(v)))
			}
			mapEntrySize := 1 + sozAttributes(uint64(k)) + l
			n += mapEntrySize + 1 + sovAttributes(uint64(mapEntrySize))
		}
	}
	if len(m.StringMaps) > 0 {
		for k, v := range m.StringMaps {
			_ = k
			_ = v
			l = v.Size()
			mapEntrySize := 1 + sozAttributes(uint64(k)) + 1 + l + sovAttributes(uint64(l))
			n += mapEntrySize + 1 + sovAttributes(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *StringMap) Size() (n int) {
	var l int
	_ = l
	if len(m.Entries) > 0 {
		for k, v := range m.Entries {
			_ = k
			_ = v
			mapEntrySize := 1 + sozAttributes(uint64(k)) + 1 + sozAttributes(uint64(v))
			n += mapEntrySize + 1 + sovAttributes(uint64(mapEntrySize))
		}
	}
	return n
}

func sovAttributes(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozAttributes(x uint64) (n int) {
	return sovAttributes(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *Attributes) String() string {
	if this == nil {
		return "nil"
	}
	keysForAttributes := make([]string, 0, len(this.Attributes))
	for k, _ := range this.Attributes {
		keysForAttributes = append(keysForAttributes, k)
	}
	sortkeys.Strings(keysForAttributes)
	mapStringForAttributes := "map[string]*Attributes_AttributeValue{"
	for _, k := range keysForAttributes {
		mapStringForAttributes += fmt.Sprintf("%v: %v,", k, this.Attributes[k])
	}
	mapStringForAttributes += "}"
	s := strings.Join([]string{`&Attributes{`,
		`Attributes:` + mapStringForAttributes + `,`,
		`}`,
	}, "")
	return s
}
func (this *Attributes_AttributeValue) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Attributes_AttributeValue{`,
		`Value:` + fmt.Sprintf("%v", this.Value) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Attributes_AttributeValue_StringValue) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Attributes_AttributeValue_StringValue{`,
		`StringValue:` + fmt.Sprintf("%v", this.StringValue) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Attributes_AttributeValue_Int64Value) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Attributes_AttributeValue_Int64Value{`,
		`Int64Value:` + fmt.Sprintf("%v", this.Int64Value) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Attributes_AttributeValue_DoubleValue) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Attributes_AttributeValue_DoubleValue{`,
		`DoubleValue:` + fmt.Sprintf("%v", this.DoubleValue) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Attributes_AttributeValue_BoolValue) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Attributes_AttributeValue_BoolValue{`,
		`BoolValue:` + fmt.Sprintf("%v", this.BoolValue) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Attributes_AttributeValue_BytesValue) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Attributes_AttributeValue_BytesValue{`,
		`BytesValue:` + fmt.Sprintf("%v", this.BytesValue) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Attributes_AttributeValue_TimestampValue) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Attributes_AttributeValue_TimestampValue{`,
		`TimestampValue:` + strings.Replace(fmt.Sprintf("%v", this.TimestampValue), "Timestamp", "google_protobuf2.Timestamp", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Attributes_AttributeValue_DurationValue) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Attributes_AttributeValue_DurationValue{`,
		`DurationValue:` + strings.Replace(fmt.Sprintf("%v", this.DurationValue), "Duration", "google_protobuf1.Duration", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Attributes_AttributeValue_StringMapValue) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Attributes_AttributeValue_StringMapValue{`,
		`StringMapValue:` + strings.Replace(fmt.Sprintf("%v", this.StringMapValue), "Attributes_StringMap", "Attributes_StringMap", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Attributes_StringMap) String() string {
	if this == nil {
		return "nil"
	}
	keysForEntries := make([]string, 0, len(this.Entries))
	for k, _ := range this.Entries {
		keysForEntries = append(keysForEntries, k)
	}
	sortkeys.Strings(keysForEntries)
	mapStringForEntries := "map[string]string{"
	for _, k := range keysForEntries {
		mapStringForEntries += fmt.Sprintf("%v: %v,", k, this.Entries[k])
	}
	mapStringForEntries += "}"
	s := strings.Join([]string{`&Attributes_StringMap{`,
		`Entries:` + mapStringForEntries + `,`,
		`}`,
	}, "")
	return s
}
func (this *CompressedAttributes) String() string {
	if this == nil {
		return "nil"
	}
	keysForStrings := make([]int32, 0, len(this.Strings))
	for k, _ := range this.Strings {
		keysForStrings = append(keysForStrings, k)
	}
	sortkeys.Int32s(keysForStrings)
	mapStringForStrings := "map[int32]int32{"
	for _, k := range keysForStrings {
		mapStringForStrings += fmt.Sprintf("%v: %v,", k, this.Strings[k])
	}
	mapStringForStrings += "}"
	keysForInt64S := make([]int32, 0, len(this.Int64S))
	for k, _ := range this.Int64S {
		keysForInt64S = append(keysForInt64S, k)
	}
	sortkeys.Int32s(keysForInt64S)
	mapStringForInt64S := "map[int32]int64{"
	for _, k := range keysForInt64S {
		mapStringForInt64S += fmt.Sprintf("%v: %v,", k, this.Int64S[k])
	}
	mapStringForInt64S += "}"
	keysForDoubles := make([]int32, 0, len(this.Doubles))
	for k, _ := range this.Doubles {
		keysForDoubles = append(keysForDoubles, k)
	}
	sortkeys.Int32s(keysForDoubles)
	mapStringForDoubles := "map[int32]float64{"
	for _, k := range keysForDoubles {
		mapStringForDoubles += fmt.Sprintf("%v: %v,", k, this.Doubles[k])
	}
	mapStringForDoubles += "}"
	keysForBools := make([]int32, 0, len(this.Bools))
	for k, _ := range this.Bools {
		keysForBools = append(keysForBools, k)
	}
	sortkeys.Int32s(keysForBools)
	mapStringForBools := "map[int32]bool{"
	for _, k := range keysForBools {
		mapStringForBools += fmt.Sprintf("%v: %v,", k, this.Bools[k])
	}
	mapStringForBools += "}"
	keysForTimestamps := make([]int32, 0, len(this.Timestamps))
	for k, _ := range this.Timestamps {
		keysForTimestamps = append(keysForTimestamps, k)
	}
	sortkeys.Int32s(keysForTimestamps)
	mapStringForTimestamps := "map[int32]time.Time{"
	for _, k := range keysForTimestamps {
		mapStringForTimestamps += fmt.Sprintf("%v: %v,", k, this.Timestamps[k])
	}
	mapStringForTimestamps += "}"
	keysForDurations := make([]int32, 0, len(this.Durations))
	for k, _ := range this.Durations {
		keysForDurations = append(keysForDurations, k)
	}
	sortkeys.Int32s(keysForDurations)
	mapStringForDurations := "map[int32]time.Duration{"
	for _, k := range keysForDurations {
		mapStringForDurations += fmt.Sprintf("%v: %v,", k, this.Durations[k])
	}
	mapStringForDurations += "}"
	keysForBytes := make([]int32, 0, len(this.Bytes))
	for k, _ := range this.Bytes {
		keysForBytes = append(keysForBytes, k)
	}
	sortkeys.Int32s(keysForBytes)
	mapStringForBytes := "map[int32][]byte{"
	for _, k := range keysForBytes {
		mapStringForBytes += fmt.Sprintf("%v: %v,", k, this.Bytes[k])
	}
	mapStringForBytes += "}"
	keysForStringMaps := make([]int32, 0, len(this.StringMaps))
	for k, _ := range this.StringMaps {
		keysForStringMaps = append(keysForStringMaps, k)
	}
	sortkeys.Int32s(keysForStringMaps)
	mapStringForStringMaps := "map[int32]StringMap{"
	for _, k := range keysForStringMaps {
		mapStringForStringMaps += fmt.Sprintf("%v: %v,", k, this.StringMaps[k])
	}
	mapStringForStringMaps += "}"
	s := strings.Join([]string{`&CompressedAttributes{`,
		`Words:` + fmt.Sprintf("%v", this.Words) + `,`,
		`Strings:` + mapStringForStrings + `,`,
		`Int64S:` + mapStringForInt64S + `,`,
		`Doubles:` + mapStringForDoubles + `,`,
		`Bools:` + mapStringForBools + `,`,
		`Timestamps:` + mapStringForTimestamps + `,`,
		`Durations:` + mapStringForDurations + `,`,
		`Bytes:` + mapStringForBytes + `,`,
		`StringMaps:` + mapStringForStringMaps + `,`,
		`}`,
	}, "")
	return s
}
func (this *StringMap) String() string {
	if this == nil {
		return "nil"
	}
	keysForEntries := make([]int32, 0, len(this.Entries))
	for k, _ := range this.Entries {
		keysForEntries = append(keysForEntries, k)
	}
	sortkeys.Int32s(keysForEntries)
	mapStringForEntries := "map[int32]int32{"
	for _, k := range keysForEntries {
		mapStringForEntries += fmt.Sprintf("%v: %v,", k, this.Entries[k])
	}
	mapStringForEntries += "}"
	s := strings.Join([]string{`&StringMap{`,
		`Entries:` + mapStringForEntries + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringAttributes(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *Attributes) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAttributes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Attributes: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Attributes: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAttributes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Attributes == nil {
				m.Attributes = make(map[string]*Attributes_AttributeValue)
			}
			var mapkey string
			var mapvalue *Attributes_AttributeValue
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAttributes
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthAttributes
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthAttributes
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthAttributes
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &Attributes_AttributeValue{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAttributes(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthAttributes
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Attributes[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAttributes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAttributes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Attributes_AttributeValue) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAttributes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AttributeValue: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AttributeValue: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StringValue", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAttributes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = &Attributes_AttributeValue_StringValue{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Int64Value", wireType)
			}
			var v int64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Value = &Attributes_AttributeValue_Int64Value{v}
		case 4:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field DoubleValue", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Value = &Attributes_AttributeValue_DoubleValue{float64(math.Float64frombits(v))}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BoolValue", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Value = &Attributes_AttributeValue_BoolValue{b}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BytesValue", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthAttributes
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := make([]byte, postIndex-iNdEx)
			copy(v, dAtA[iNdEx:postIndex])
			m.Value = &Attributes_AttributeValue_BytesValue{v}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimestampValue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAttributes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &google_protobuf2.Timestamp{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Attributes_AttributeValue_TimestampValue{v}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DurationValue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAttributes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &google_protobuf1.Duration{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Attributes_AttributeValue_DurationValue{v}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StringMapValue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAttributes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Attributes_StringMap{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Value = &Attributes_AttributeValue_StringMapValue{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAttributes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAttributes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Attributes_StringMap) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAttributes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StringMap: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StringMap: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Entries", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAttributes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Entries == nil {
				m.Entries = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAttributes
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthAttributes
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthAttributes
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAttributes(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthAttributes
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Entries[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAttributes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAttributes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CompressedAttributes) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAttributes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CompressedAttributes: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CompressedAttributes: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Words", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAttributes
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Words = append(m.Words, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Strings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAttributes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Strings == nil {
				m.Strings = make(map[int32]int32)
			}
			var mapkey int32
			var mapvalue int32
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAttributes
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var mapkeytemp int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkeytemp |= (int32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					mapkeytemp = int32((uint32(mapkeytemp) >> 1) ^ uint32(((mapkeytemp&1)<<31)>>31))
					mapkey = int32(mapkeytemp)
				} else if fieldNum == 2 {
					var mapvaluetemp int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvaluetemp |= (int32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					mapvaluetemp = int32((uint32(mapvaluetemp) >> 1) ^ uint32(((mapvaluetemp&1)<<31)>>31))
					mapvalue = int32(mapvaluetemp)
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAttributes(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthAttributes
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Strings[mapkey] = mapvalue
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Int64S", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAttributes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Int64S == nil {
				m.Int64S = make(map[int32]int64)
			}
			var mapkey int32
			var mapvalue int64
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAttributes
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var mapkeytemp int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkeytemp |= (int32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					mapkeytemp = int32((uint32(mapkeytemp) >> 1) ^ uint32(((mapkeytemp&1)<<31)>>31))
					mapkey = int32(mapkeytemp)
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= (int64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAttributes(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthAttributes
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Int64S[mapkey] = mapvalue
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Doubles", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAttributes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Doubles == nil {
				m.Doubles = make(map[int32]float64)
			}
			var mapkey int32
			var mapvalue float64
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAttributes
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var mapkeytemp int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkeytemp |= (int32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					mapkeytemp = int32((uint32(mapkeytemp) >> 1) ^ uint32(((mapkeytemp&1)<<31)>>31))
					mapkey = int32(mapkeytemp)
				} else if fieldNum == 2 {
					var mapvaluetemp uint64
					if (iNdEx + 8) > l {
						return io.ErrUnexpectedEOF
					}
					mapvaluetemp = uint64(binary.LittleEndian.Uint64(dAtA[iNdEx:]))
					iNdEx += 8
					mapvalue = math.Float64frombits(mapvaluetemp)
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAttributes(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthAttributes
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Doubles[mapkey] = mapvalue
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bools", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAttributes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Bools == nil {
				m.Bools = make(map[int32]bool)
			}
			var mapkey int32
			var mapvalue bool
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAttributes
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var mapkeytemp int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkeytemp |= (int32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					mapkeytemp = int32((uint32(mapkeytemp) >> 1) ^ uint32(((mapkeytemp&1)<<31)>>31))
					mapkey = int32(mapkeytemp)
				} else if fieldNum == 2 {
					var mapvaluetemp int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvaluetemp |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					mapvalue = bool(mapvaluetemp != 0)
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAttributes(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthAttributes
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Bools[mapkey] = mapvalue
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamps", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAttributes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Timestamps == nil {
				m.Timestamps = make(map[int32]time.Time)
			}
			var mapkey int32
			mapvalue := new(time.Time)
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAttributes
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var mapkeytemp int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkeytemp |= (int32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					mapkeytemp = int32((uint32(mapkeytemp) >> 1) ^ uint32(((mapkeytemp&1)<<31)>>31))
					mapkey = int32(mapkeytemp)
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthAttributes
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthAttributes
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					if err := types.StdTimeUnmarshal(mapvalue, dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAttributes(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthAttributes
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Timestamps[mapkey] = *mapvalue
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Durations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAttributes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Durations == nil {
				m.Durations = make(map[int32]time.Duration)
			}
			var mapkey int32
			mapvalue := new(time.Duration)
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAttributes
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var mapkeytemp int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkeytemp |= (int32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					mapkeytemp = int32((uint32(mapkeytemp) >> 1) ^ uint32(((mapkeytemp&1)<<31)>>31))
					mapkey = int32(mapkeytemp)
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthAttributes
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthAttributes
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					if err := types.StdDurationUnmarshal(mapvalue, dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAttributes(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthAttributes
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Durations[mapkey] = *mapvalue
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bytes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAttributes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Bytes == nil {
				m.Bytes = make(map[int32][]byte)
			}
			var mapkey int32
			mapvalue := []byte{}
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAttributes
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var mapkeytemp int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkeytemp |= (int32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					mapkeytemp = int32((uint32(mapkeytemp) >> 1) ^ uint32(((mapkeytemp&1)<<31)>>31))
					mapkey = int32(mapkeytemp)
				} else if fieldNum == 2 {
					var mapbyteLen uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapbyteLen |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intMapbyteLen := int(mapbyteLen)
					if intMapbyteLen < 0 {
						return ErrInvalidLengthAttributes
					}
					postbytesIndex := iNdEx + intMapbyteLen
					if postbytesIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = make([]byte, mapbyteLen)
					copy(mapvalue, dAtA[iNdEx:postbytesIndex])
					iNdEx = postbytesIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAttributes(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthAttributes
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Bytes[mapkey] = mapvalue
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StringMaps", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAttributes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StringMaps == nil {
				m.StringMaps = make(map[int32]StringMap)
			}
			var mapkey int32
			mapvalue := &StringMap{}
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAttributes
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var mapkeytemp int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkeytemp |= (int32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					mapkeytemp = int32((uint32(mapkeytemp) >> 1) ^ uint32(((mapkeytemp&1)<<31)>>31))
					mapkey = int32(mapkeytemp)
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthAttributes
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthAttributes
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &StringMap{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAttributes(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthAttributes
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.StringMaps[mapkey] = *mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAttributes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAttributes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StringMap) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAttributes
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StringMap: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StringMap: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Entries", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAttributes
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAttributes
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Entries == nil {
				m.Entries = make(map[int32]int32)
			}
			var mapkey int32
			var mapvalue int32
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAttributes
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var mapkeytemp int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkeytemp |= (int32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					mapkeytemp = int32((uint32(mapkeytemp) >> 1) ^ uint32(((mapkeytemp&1)<<31)>>31))
					mapkey = int32(mapkeytemp)
				} else if fieldNum == 2 {
					var mapvaluetemp int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAttributes
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvaluetemp |= (int32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					mapvaluetemp = int32((uint32(mapvaluetemp) >> 1) ^ uint32(((mapvaluetemp&1)<<31)>>31))
					mapvalue = int32(mapvaluetemp)
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAttributes(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthAttributes
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Entries[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAttributes(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAttributes
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipAttributes(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowAttributes
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAttributes
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAttributes
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthAttributes
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowAttributes
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipAttributes(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthAttributes = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowAttributes   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("mixer/v1/attributes.proto", fileDescriptorAttributes) }

var fileDescriptorAttributes = []byte{
	// 804 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x96, 0xcd, 0x6e, 0xd3, 0x4a,
	0x18, 0x86, 0x3d, 0x4d, 0xf3, 0xe3, 0x2f, 0x39, 0x49, 0x6b, 0xe5, 0x48, 0x6e, 0x16, 0x4e, 0x4e,
	0x0f, 0x42, 0x81, 0x85, 0xdd, 0x3f, 0xa1, 0xd2, 0x0d, 0x10, 0x1a, 0x11, 0x40, 0x48, 0xc8, 0x20,
	0xfe, 0x2a, 0x81, 0x12, 0xc5, 0x04, 0x8b, 0x24, 0x13, 0x79, 0x26, 0x85, 0xec, 0x90, 0x58, 0xb1,
	0xeb, 0x82, 0x05, 0x77, 0x00, 0x97, 0xd2, 0x65, 0x97, 0xac, 0x80, 0x84, 0x0d, 0x1b, 0xa4, 0x5e,
	0x02, 0xf2, 0xcc, 0xd8, 0x99, 0x84, 0xb4, 0x71, 0x76, 0xf6, 0xcc, 0xf7, 0x3e, 0x7e, 0x67, 0xe6,
	0x9d, 0x2f, 0x81, 0xb5, 0x8e, 0xfb, 0xd6, 0xf1, 0xac, 0xc3, 0x4d, 0xab, 0x4e, 0xa9, 0xe7, 0x36,
	0xfa, 0xd4, 0x21, 0x66, 0xcf, 0xc3, 0x14, 0x6b, 0x59, 0x97, 0x50, 0x17, 0x9b, 0xac, 0xc0, 0x3c,
	0xdc, 0x2c, 0xe4, 0x5b, 0xb8, 0x85, 0xd9, 0x94, 0xe5, 0x3f, 0xf1, 0xaa, 0x82, 0xd1, 0xc2, 0xb8,
	0xd5, 0x76, 0x2c, 0xf6, 0xd6, 0xe8, 0xbf, 0xb4, 0x9a, 0x7d, 0xaf, 0x4e, 0x5d, 0xdc, 0x15, 0xf3,
	0xc5, 0xe9, 0x79, 0xea, 0x76, 0x1c, 0x42, 0xeb, 0x9d, 0x1e, 0x2f, 0x58, 0x7f, 0x9f, 0x00, 0xb8,
	0x11, 0x7e, 0x5b, 0xbb, 0x03, 0x30, 0x76, 0xa2, 0xa3, 0x52, 0xac, 0x9c, 0xde, 0xba, 0x6c, 0x4e,
	0x5a, 0x31, 0xc7, 0xf5, 0xd2, 0x63, 0xb5, 0x4b, 0xbd, 0x81, 0x2d, 0xa9, 0x0b, 0xaf, 0x20, 0x37,
	0x35, 0xad, 0xad, 0x40, 0xec, 0xb5, 0x33, 0xd0, 0x51, 0x09, 0x95, 0x55, 0xdb, 0x7f, 0xd4, 0xae,
	0x41, 0xfc, 0xb0, 0xde, 0xee, 0x3b, 0xfa, 0x52, 0x09, 0x95, 0xd3, 0x5b, 0x97, 0xa2, 0x7c, 0xeb,
	0x91, 0x2f, 0xb0, 0xb9, 0x6e, 0x6f, 0x69, 0x17, 0x15, 0x3e, 0xc7, 0x20, 0x3b, 0x39, 0xab, 0xfd,
	0x0f, 0x19, 0x42, 0x3d, 0xb7, 0xdb, 0x7a, 0x31, 0xc6, 0xab, 0x35, 0xc5, 0x4e, 0xf3, 0x51, 0x5e,
	0xf4, 0x1f, 0xa4, 0xdd, 0x2e, 0xbd, 0xb2, 0x23, 0x6a, 0x62, 0x25, 0x54, 0x8e, 0xd5, 0x14, 0x1b,
	0xd8, 0x60, 0xc8, 0x69, 0xe2, 0x7e, 0xa3, 0xed, 0x88, 0x9a, 0xe5, 0x12, 0x2a, 0x23, 0x9f, 0xc3,
	0x47, 0x79, 0x51, 0x11, 0xa0, 0x81, 0x71, 0x5b, 0x94, 0xc4, 0x4b, 0xa8, 0x9c, 0xaa, 0x29, 0xb6,
	0xea, 0x8f, 0x85, 0x1f, 0x6a, 0x0c, 0xa8, 0x43, 0x44, 0x45, 0xa2, 0x84, 0xca, 0x19, 0xff, 0x43,
	0x6c, 0x90, 0x97, 0x54, 0x21, 0x17, 0x9e, 0x8d, 0x28, 0x4b, 0xb2, 0x2d, 0x29, 0x98, 0xfc, 0x0c,
	0xcd, 0xe0, 0x0c, 0xcd, 0x87, 0x41, 0x5d, 0x4d, 0xb1, 0xb3, 0xa1, 0x88, 0x63, 0x2a, 0x90, 0x0d,
	0x22, 0x20, 0x28, 0x29, 0x46, 0x59, 0xfb, 0x8b, 0xb2, 0x2f, 0xca, 0x6a, 0x8a, 0xfd, 0x4f, 0x20,
	0xe1, 0x8c, 0xfb, 0xb0, 0x22, 0xf6, 0xae, 0x53, 0x0f, 0xbc, 0xa8, 0x8c, 0x72, 0xe1, 0x9c, 0xe3,
	0x79, 0xc0, 0x24, 0xf7, 0xea, 0xcc, 0x15, 0x09, 0x5e, 0x18, 0xb1, 0x92, 0x14, 0xa7, 0x5c, 0xf8,
	0x88, 0x40, 0x0d, 0x0b, 0xb5, 0xbb, 0x90, 0x74, 0xba, 0xd4, 0x73, 0xc3, 0xa8, 0x6d, 0x46, 0xe1,
	0x9b, 0x55, 0xae, 0xe1, 0x89, 0x0b, 0x08, 0x85, 0x3d, 0xc8, 0xc8, 0x13, 0x33, 0xb2, 0x96, 0x97,
	0xb3, 0xa6, 0x4a, 0x01, 0x5a, 0xff, 0xad, 0x42, 0xfe, 0x26, 0xee, 0xf4, 0x3c, 0x87, 0x10, 0xa7,
	0x29, 0xdd, 0x87, 0x3c, 0xc4, 0xdf, 0x60, 0xaf, 0xc9, 0xfd, 0xa9, 0x36, 0x7f, 0xf1, 0x7d, 0xf3,
	0x05, 0x12, 0x7d, 0x69, 0xb6, 0xef, 0x59, 0x30, 0xb1, 0x82, 0xc0, 0xb7, 0x20, 0x68, 0x35, 0x48,
	0xb0, 0xbc, 0x11, 0x3d, 0xc6, 0x58, 0x1b, 0x91, 0x58, 0xb7, 0x99, 0x84, 0xa3, 0x84, 0xde, 0xb7,
	0xc5, 0x53, 0x49, 0xf4, 0xe5, 0x05, 0x6c, 0xed, 0x73, 0x8d, 0xb0, 0x25, 0x08, 0x5a, 0x15, 0xe2,
	0x7e, 0x7e, 0x89, 0x1e, 0x67, 0x28, 0x2b, 0x12, 0xaa, 0xe2, 0x2b, 0x38, 0x88, 0xab, 0xb5, 0xe7,
	0x00, 0x61, 0x42, 0x89, 0x9e, 0x60, 0xac, 0x9d, 0x48, 0xac, 0x30, 0xe5, 0x1c, 0x58, 0x49, 0x1d,
	0x7f, 0x2b, 0x2a, 0x47, 0xdf, 0x8b, 0xc8, 0x96, 0x88, 0xda, 0x01, 0xa8, 0x41, 0x78, 0x89, 0x9e,
	0x64, 0xf8, 0xed, 0x68, 0xab, 0x0e, 0x54, 0x12, 0xfd, 0x93, 0x4f, 0x1f, 0xf3, 0xd8, 0x1e, 0xf8,
	0x37, 0x54, 0x4f, 0x2d, 0xb2, 0x07, 0x83, 0xb0, 0x1b, 0x72, 0xb5, 0x76, 0x00, 0xe9, 0xf1, 0x7d,
	0x22, 0xba, 0xba, 0xc0, 0x26, 0x84, 0xa1, 0x17, 0x36, 0x97, 0x7d, 0x9b, 0x36, 0x84, 0xd7, 0x8b,
	0xc5, 0x5e, 0xce, 0x95, 0x1c, 0xfb, 0xd5, 0x19, 0xb1, 0x5f, 0x95, 0xfb, 0xe6, 0x55, 0x48, 0x4b,
	0x39, 0x9a, 0x27, 0x8d, 0xc9, 0xd2, 0x3d, 0xc8, 0xc8, 0xb9, 0x99, 0xa7, 0x45, 0xb2, 0x76, 0x17,
	0x60, 0x1c, 0x94, 0x79, 0xca, 0x94, 0xac, 0x7c, 0x0a, 0xb9, 0xa9, 0x58, 0xcc, 0x90, 0x6f, 0x4c,
	0xfe, 0xa4, 0x9c, 0xd3, 0x3f, 0x65, 0xf4, 0x63, 0xc8, 0x4e, 0x46, 0x62, 0x06, 0xd9, 0x9a, 0x24,
	0x9f, 0xdd, 0x53, 0xa7, 0x57, 0x3b, 0xa0, 0x11, 0xf7, 0x29, 0x23, 0x2b, 0x9f, 0x40, 0x6e, 0xea,
	0xfc, 0xa3, 0x78, 0x9a, 0x8a, 0x55, 0x48, 0x90, 0xfb, 0xdd, 0x87, 0x89, 0x36, 0x7c, 0x7d, 0xba,
	0x0d, 0x5f, 0x3c, 0x13, 0xb2, 0x78, 0xef, 0x9d, 0x17, 0xc2, 0xca, 0xad, 0xe3, 0xa1, 0xa1, 0x9c,
	0x0c, 0x0d, 0xe5, 0xeb, 0xd0, 0x50, 0x4e, 0x87, 0x86, 0xf2, 0x6e, 0x64, 0xa0, 0x2f, 0x23, 0x43,
	0x39, 0x1e, 0x19, 0xe8, 0x64, 0x64, 0xa0, 0x1f, 0x23, 0x03, 0xfd, 0x1a, 0x19, 0xca, 0xe9, 0xc8,
	0x40, 0x47, 0x3f, 0x0d, 0xe5, 0xd9, 0xbf, 0xdc, 0x9d, 0x8b, 0xad, 0x7a, 0xcf, 0xb5, 0x82, 0xbf,
	0x50, 0x8d, 0x04, 0x3b, 0x86, 0xed, 0x3f, 0x01, 0x00, 0x00, 0xff, 0xff, 0xe6, 0xe8, 0xfe, 0x05,
	0x55, 0x09, 0x00, 0x00,
}
