// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: mixer/adapter/model/v1beta1/quota.proto

package v1beta1

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"
import _ "github.com/gogo/protobuf/types"

import time "time"

import types "github.com/gogo/protobuf/types"

import strings "strings"
import reflect "reflect"
import sortkeys "github.com/gogo/protobuf/sortkeys"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// Expresses the quota allocation request.
type QuotaRequest struct {
	// The individual quotas to allocate
	Quotas map[string]QuotaRequest_QuotaParams `protobuf:"bytes,1,rep,name=quotas" json:"quotas" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *QuotaRequest) Reset()                    { *m = QuotaRequest{} }
func (*QuotaRequest) ProtoMessage()               {}
func (*QuotaRequest) Descriptor() ([]byte, []int) { return fileDescriptorQuota, []int{0} }

// parameters for a quota allocation
type QuotaRequest_QuotaParams struct {
	// Amount of quota to allocate
	Amount int64 `protobuf:"varint,1,opt,name=amount,proto3" json:"amount,omitempty"`
	// When true, supports returning less quota than what was requested.
	BestEffort bool `protobuf:"varint,2,opt,name=best_effort,json=bestEffort,proto3" json:"best_effort,omitempty"`
}

func (m *QuotaRequest_QuotaParams) Reset()                    { *m = QuotaRequest_QuotaParams{} }
func (*QuotaRequest_QuotaParams) ProtoMessage()               {}
func (*QuotaRequest_QuotaParams) Descriptor() ([]byte, []int) { return fileDescriptorQuota, []int{0, 0} }

// Expresses the result of multiple quota allocations.
type QuotaResult struct {
	// The resulting quota, one entry per requested quota.
	Quotas map[string]QuotaResult_Result `protobuf:"bytes,1,rep,name=quotas" json:"quotas" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *QuotaResult) Reset()                    { *m = QuotaResult{} }
func (*QuotaResult) ProtoMessage()               {}
func (*QuotaResult) Descriptor() ([]byte, []int) { return fileDescriptorQuota, []int{1} }

// Expresses the result of a quota allocation.
type QuotaResult_Result struct {
	// The amount of time for which this result can be considered valid.
	ValidDuration time.Duration `protobuf:"bytes,2,opt,name=valid_duration,json=validDuration,stdduration" json:"valid_duration"`
	// The amount of granted quota. When `QuotaParams.best_effort` is true, this will be >= 0.
	// If `QuotaParams.best_effort` is false, this will be either 0 or >= `QuotaParams.amount`.
	GrantedAmount int64 `protobuf:"varint,3,opt,name=granted_amount,json=grantedAmount,proto3" json:"granted_amount,omitempty"`
}

func (m *QuotaResult_Result) Reset()                    { *m = QuotaResult_Result{} }
func (*QuotaResult_Result) ProtoMessage()               {}
func (*QuotaResult_Result) Descriptor() ([]byte, []int) { return fileDescriptorQuota, []int{1, 0} }

func init() {
	proto.RegisterType((*QuotaRequest)(nil), "istio.mixer.adapter.model.v1beta1.QuotaRequest")
	proto.RegisterType((*QuotaRequest_QuotaParams)(nil), "istio.mixer.adapter.model.v1beta1.QuotaRequest.QuotaParams")
	proto.RegisterType((*QuotaResult)(nil), "istio.mixer.adapter.model.v1beta1.QuotaResult")
	proto.RegisterType((*QuotaResult_Result)(nil), "istio.mixer.adapter.model.v1beta1.QuotaResult.Result")
}
func (m *QuotaRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QuotaRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Quotas) > 0 {
		for k, _ := range m.Quotas {
			dAtA[i] = 0xa
			i++
			v := m.Quotas[k]
			msgSize := 0
			if (&v) != nil {
				msgSize = (&v).Size()
				msgSize += 1 + sovQuota(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovQuota(uint64(len(k))) + msgSize
			i = encodeVarintQuota(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintQuota(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintQuota(dAtA, i, uint64((&v).Size()))
			n1, err := (&v).MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n1
		}
	}
	return i, nil
}

func (m *QuotaRequest_QuotaParams) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QuotaRequest_QuotaParams) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Amount != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintQuota(dAtA, i, uint64(m.Amount))
	}
	if m.BestEffort {
		dAtA[i] = 0x10
		i++
		if m.BestEffort {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *QuotaResult) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QuotaResult) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Quotas) > 0 {
		for k, _ := range m.Quotas {
			dAtA[i] = 0xa
			i++
			v := m.Quotas[k]
			msgSize := 0
			if (&v) != nil {
				msgSize = (&v).Size()
				msgSize += 1 + sovQuota(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovQuota(uint64(len(k))) + msgSize
			i = encodeVarintQuota(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintQuota(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintQuota(dAtA, i, uint64((&v).Size()))
			n2, err := (&v).MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n2
		}
	}
	return i, nil
}

func (m *QuotaResult_Result) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QuotaResult_Result) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x12
	i++
	i = encodeVarintQuota(dAtA, i, uint64(types.SizeOfStdDuration(m.ValidDuration)))
	n3, err := types.StdDurationMarshalTo(m.ValidDuration, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n3
	if m.GrantedAmount != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintQuota(dAtA, i, uint64(m.GrantedAmount))
	}
	return i, nil
}

func encodeVarintQuota(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *QuotaRequest) Size() (n int) {
	var l int
	_ = l
	if len(m.Quotas) > 0 {
		for k, v := range m.Quotas {
			_ = k
			_ = v
			l = v.Size()
			mapEntrySize := 1 + len(k) + sovQuota(uint64(len(k))) + 1 + l + sovQuota(uint64(l))
			n += mapEntrySize + 1 + sovQuota(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *QuotaRequest_QuotaParams) Size() (n int) {
	var l int
	_ = l
	if m.Amount != 0 {
		n += 1 + sovQuota(uint64(m.Amount))
	}
	if m.BestEffort {
		n += 2
	}
	return n
}

func (m *QuotaResult) Size() (n int) {
	var l int
	_ = l
	if len(m.Quotas) > 0 {
		for k, v := range m.Quotas {
			_ = k
			_ = v
			l = v.Size()
			mapEntrySize := 1 + len(k) + sovQuota(uint64(len(k))) + 1 + l + sovQuota(uint64(l))
			n += mapEntrySize + 1 + sovQuota(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *QuotaResult_Result) Size() (n int) {
	var l int
	_ = l
	l = types.SizeOfStdDuration(m.ValidDuration)
	n += 1 + l + sovQuota(uint64(l))
	if m.GrantedAmount != 0 {
		n += 1 + sovQuota(uint64(m.GrantedAmount))
	}
	return n
}

func sovQuota(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozQuota(x uint64) (n int) {
	return sovQuota(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *QuotaRequest) String() string {
	if this == nil {
		return "nil"
	}
	keysForQuotas := make([]string, 0, len(this.Quotas))
	for k, _ := range this.Quotas {
		keysForQuotas = append(keysForQuotas, k)
	}
	sortkeys.Strings(keysForQuotas)
	mapStringForQuotas := "map[string]QuotaRequest_QuotaParams{"
	for _, k := range keysForQuotas {
		mapStringForQuotas += fmt.Sprintf("%v: %v,", k, this.Quotas[k])
	}
	mapStringForQuotas += "}"
	s := strings.Join([]string{`&QuotaRequest{`,
		`Quotas:` + mapStringForQuotas + `,`,
		`}`,
	}, "")
	return s
}
func (this *QuotaRequest_QuotaParams) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&QuotaRequest_QuotaParams{`,
		`Amount:` + fmt.Sprintf("%v", this.Amount) + `,`,
		`BestEffort:` + fmt.Sprintf("%v", this.BestEffort) + `,`,
		`}`,
	}, "")
	return s
}
func (this *QuotaResult) String() string {
	if this == nil {
		return "nil"
	}
	keysForQuotas := make([]string, 0, len(this.Quotas))
	for k, _ := range this.Quotas {
		keysForQuotas = append(keysForQuotas, k)
	}
	sortkeys.Strings(keysForQuotas)
	mapStringForQuotas := "map[string]QuotaResult_Result{"
	for _, k := range keysForQuotas {
		mapStringForQuotas += fmt.Sprintf("%v: %v,", k, this.Quotas[k])
	}
	mapStringForQuotas += "}"
	s := strings.Join([]string{`&QuotaResult{`,
		`Quotas:` + mapStringForQuotas + `,`,
		`}`,
	}, "")
	return s
}
func (this *QuotaResult_Result) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&QuotaResult_Result{`,
		`ValidDuration:` + strings.Replace(strings.Replace(this.ValidDuration.String(), "Duration", "google_protobuf1.Duration", 1), `&`, ``, 1) + `,`,
		`GrantedAmount:` + fmt.Sprintf("%v", this.GrantedAmount) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringQuota(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *QuotaRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuota
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QuotaRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QuotaRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Quotas", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Quotas == nil {
				m.Quotas = make(map[string]QuotaRequest_QuotaParams)
			}
			var mapkey string
			mapvalue := &QuotaRequest_QuotaParams{}
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowQuota
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowQuota
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthQuota
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowQuota
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthQuota
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthQuota
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &QuotaRequest_QuotaParams{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipQuota(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthQuota
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Quotas[mapkey] = *mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuota(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuota
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QuotaRequest_QuotaParams) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuota
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QuotaParams: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QuotaParams: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Amount", wireType)
			}
			m.Amount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Amount |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BestEffort", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.BestEffort = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipQuota(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuota
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QuotaResult) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuota
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QuotaResult: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QuotaResult: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Quotas", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Quotas == nil {
				m.Quotas = make(map[string]QuotaResult_Result)
			}
			var mapkey string
			mapvalue := &QuotaResult_Result{}
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowQuota
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowQuota
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthQuota
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowQuota
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthQuota
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthQuota
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &QuotaResult_Result{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipQuota(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthQuota
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Quotas[mapkey] = *mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuota(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuota
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QuotaResult_Result) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuota
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Result: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Result: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValidDuration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := types.StdDurationUnmarshal(&m.ValidDuration, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GrantedAmount", wireType)
			}
			m.GrantedAmount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.GrantedAmount |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipQuota(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuota
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipQuota(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowQuota
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthQuota
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowQuota
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipQuota(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthQuota = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowQuota   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("mixer/adapter/model/v1beta1/quota.proto", fileDescriptorQuota) }

var fileDescriptorQuota = []byte{
	// 444 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x53, 0x3d, 0x6f, 0xd4, 0x30,
	0x18, 0xb6, 0xef, 0xe0, 0x54, 0x7c, 0xb4, 0x42, 0x16, 0x42, 0x47, 0x06, 0xdf, 0x51, 0x09, 0x91,
	0xc9, 0x56, 0x41, 0x48, 0xa8, 0x4c, 0x9c, 0x28, 0x03, 0x2c, 0xd4, 0x13, 0x74, 0x39, 0x39, 0x8a,
	0x2f, 0x8a, 0x48, 0xe2, 0xd4, 0x71, 0x22, 0x2a, 0x16, 0x7e, 0x02, 0x23, 0x3f, 0x01, 0xfe, 0xc9,
	0x8d, 0x9d, 0x10, 0x13, 0x90, 0xb0, 0x30, 0xf6, 0x27, 0xa0, 0xd8, 0x3e, 0xa9, 0x30, 0xf4, 0xa0,
	0x53, 0xde, 0x8f, 0xe7, 0x7d, 0x9e, 0xbc, 0xcf, 0x2b, 0xa3, 0x7b, 0x79, 0xfa, 0x56, 0x6a, 0x26,
	0x62, 0x51, 0x1a, 0xa9, 0x59, 0xae, 0x62, 0x99, 0xb1, 0x66, 0x2f, 0x92, 0x46, 0xec, 0xb1, 0xe3,
	0x5a, 0x19, 0x41, 0x4b, 0xad, 0x8c, 0xc2, 0x77, 0xd2, 0xca, 0xa4, 0x8a, 0x5a, 0x38, 0xf5, 0x70,
	0x6a, 0xe1, 0xd4, 0xc3, 0x83, 0x9b, 0x89, 0x4a, 0x94, 0x45, 0xb3, 0x3e, 0x72, 0x83, 0x01, 0x49,
	0x94, 0x4a, 0x32, 0xc9, 0x6c, 0x16, 0xd5, 0x4b, 0x16, 0xd7, 0x5a, 0x98, 0x54, 0x15, 0xae, 0xbf,
	0xfb, 0x79, 0x80, 0xae, 0x1f, 0xf6, 0x42, 0x5c, 0x1e, 0xd7, 0xb2, 0x32, 0xf8, 0x35, 0x1a, 0x59,
	0xe1, 0x6a, 0x02, 0x67, 0xc3, 0x70, 0x7c, 0xff, 0x31, 0xdd, 0x28, 0x4d, 0xcf, 0x13, 0xb8, 0xa4,
	0x3a, 0x28, 0x8c, 0x3e, 0x99, 0x5f, 0x59, 0x7d, 0x9b, 0x02, 0xee, 0x09, 0x83, 0x67, 0x68, 0x6c,
	0x9b, 0x2f, 0x85, 0x16, 0x79, 0x85, 0x6f, 0xa1, 0x91, 0xc8, 0x55, 0x5d, 0x98, 0x09, 0x9c, 0xc1,
	0x70, 0xc8, 0x7d, 0x86, 0xa7, 0x68, 0x1c, 0xc9, 0xca, 0x2c, 0xe4, 0x72, 0xa9, 0xb4, 0x99, 0x0c,
	0x66, 0x30, 0xdc, 0xe2, 0xa8, 0x2f, 0x1d, 0xd8, 0x4a, 0xd0, 0x78, 0x1e, 0x27, 0x82, 0x6f, 0xa0,
	0xe1, 0x1b, 0x79, 0x62, 0x49, 0xae, 0xf1, 0x3e, 0xc4, 0x87, 0xe8, 0x6a, 0x23, 0xb2, 0x5a, 0xda,
	0xd9, 0xcb, 0xae, 0xe0, 0xfe, 0x92, 0x3b, 0xa6, 0xfd, 0xc1, 0x23, 0xb8, 0xfb, 0x65, 0xe0, 0x85,
	0xb9, 0xac, 0xea, 0xcc, 0xe0, 0x57, 0x7f, 0x59, 0xb5, 0xff, 0xef, 0x3a, 0xfd, 0xfc, 0x05, 0x4e,
	0xbd, 0x43, 0x23, 0xaf, 0xf1, 0x1c, 0xed, 0x34, 0x22, 0x4b, 0xe3, 0xc5, 0xfa, 0x6e, 0x7e, 0xa7,
	0xdb, 0xd4, 0x1d, 0x96, 0xae, 0x0f, 0x4b, 0x9f, 0x7a, 0xc0, 0x7c, 0xab, 0xa7, 0xfa, 0xf8, 0x7d,
	0x0a, 0xf9, 0xb6, 0x1d, 0x5d, 0x37, 0xf0, 0x5d, 0xb4, 0x93, 0x68, 0x51, 0x18, 0x19, 0x2f, 0xbc,
	0xf1, 0x43, 0x6b, 0xfc, 0xb6, 0xaf, 0x3e, 0xb1, 0xc5, 0xa0, 0xdc, 0x64, 0xef, 0x8b, 0x3f, 0xed,
	0x7d, 0xf8, 0x9f, 0x6b, 0xbb, 0xcf, 0x39, 0x63, 0xe7, 0x47, 0xab, 0x96, 0x80, 0xd3, 0x96, 0x80,
	0xaf, 0x2d, 0x01, 0x67, 0x2d, 0x01, 0xef, 0x3b, 0x02, 0x3f, 0x75, 0x04, 0xac, 0x3a, 0x02, 0x4f,
	0x3b, 0x02, 0x7f, 0x74, 0x04, 0xfe, 0xea, 0x08, 0x38, 0xeb, 0x08, 0xfc, 0xf0, 0x93, 0x80, 0xa3,
	0xd0, 0x49, 0xa6, 0x8a, 0x89, 0x32, 0x65, 0x17, 0xbc, 0xa2, 0x68, 0x64, 0x0d, 0x7a, 0xf0, 0x3b,
	0x00, 0x00, 0xff, 0xff, 0xf7, 0xfa, 0xfe, 0x63, 0x6b, 0x03, 0x00, 0x00,
}
