// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: authentication/v1alpha1/policy.proto

/*
	Package v1alpha1 is a generated protocol buffer package.

	This package defines user-facing authentication policy.

	It is generated from these files:
		authentication/v1alpha1/policy.proto

	It has these top-level messages:
		MutualTls
		Jwt
		PeerAuthenticationMethod
		OriginAuthenticationMethod
		Policy
		TargetSelector
		PortSelector
*/
package v1alpha1

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Associates authentication with request principal.
type PrincipalBinding int32

const (
	// Principal will be set to the identity from peer authentication.
	PrincipalBinding_USE_PEER PrincipalBinding = 0
	// Principal will be set to the identity from origin authentication.
	PrincipalBinding_USE_ORIGIN PrincipalBinding = 1
)

var PrincipalBinding_name = map[int32]string{
	0: "USE_PEER",
	1: "USE_ORIGIN",
}
var PrincipalBinding_value = map[string]int32{
	"USE_PEER":   0,
	"USE_ORIGIN": 1,
}

func (x PrincipalBinding) String() string {
	return proto.EnumName(PrincipalBinding_name, int32(x))
}
func (PrincipalBinding) EnumDescriptor() ([]byte, []int) { return fileDescriptorPolicy, []int{0} }

// Defines the acceptable connection TLS mode.
type MutualTls_Mode int32

const (
	// Client cert must be presented, connection is in TLS.
	MutualTls_STRICT MutualTls_Mode = 0
	// Connection must be in TLS, but client cert can be omitted.
	// Request will not be fully authenticate if client cert is missing, but
	// still be accepted.
	MutualTls_TLS_PERMISSIVE MutualTls_Mode = 1
	// Connection can be either plaintext or TLS, and client cert can be omitted.
	MutualTls_PERMISSIVE MutualTls_Mode = 2
)

var MutualTls_Mode_name = map[int32]string{
	0: "STRICT",
	1: "TLS_PERMISSIVE",
	2: "PERMISSIVE",
}
var MutualTls_Mode_value = map[string]int32{
	"STRICT":         0,
	"TLS_PERMISSIVE": 1,
	"PERMISSIVE":     2,
}

func (x MutualTls_Mode) String() string {
	return proto.EnumName(MutualTls_Mode_name, int32(x))
}
func (MutualTls_Mode) EnumDescriptor() ([]byte, []int) { return fileDescriptorPolicy, []int{0, 0} }

// TLS authentication params.
// TODO: consider to give it a better name, maybe TlsParams?
type MutualTls struct {
	// WILL BE DEPRECATED, if set, will translates to `TLS_PERMISSIVE` mode.
	// Set this flag to true to allow regular TLS (i.e without client x509
	// certificate). If request carries client certificate, identity will be
	// extracted and used (set to peer identity). Otherwise, peer identity will
	// be left unset.
	// When the flag is false (default), request must have client certificate.
	AllowTls bool `protobuf:"varint,1,opt,name=allow_tls,json=allowTls,proto3" json:"allow_tls,omitempty"`
	// Defines the mode of mTLS authentication.
	Mode MutualTls_Mode `protobuf:"varint,2,opt,name=mode,proto3,enum=istio.authentication.v1alpha1.MutualTls_Mode" json:"mode,omitempty"`
}

func (m *MutualTls) Reset()                    { *m = MutualTls{} }
func (m *MutualTls) String() string            { return proto.CompactTextString(m) }
func (*MutualTls) ProtoMessage()               {}
func (*MutualTls) Descriptor() ([]byte, []int) { return fileDescriptorPolicy, []int{0} }

func (m *MutualTls) GetAllowTls() bool {
	if m != nil {
		return m.AllowTls
	}
	return false
}

func (m *MutualTls) GetMode() MutualTls_Mode {
	if m != nil {
		return m.Mode
	}
	return MutualTls_STRICT
}

// JSON Web Token (JWT) token format for authentication as defined by
// https://tools.ietf.org/html/rfc7519. See [OAuth
// 2.0](https://tools.ietf.org/html/rfc6749) and [OIDC
// 1.0](http://openid.net/connect) for how this is used in the whole
// authentication flow.
//
// Example,
//
// ```yaml
// issuer: https://example.com
// audiences:
// - bookstore_android.apps.googleusercontent.com
//   bookstore_web.apps.googleusercontent.com
// jwksUri: https://example.com/.well-known/jwks.json
// ```
type Jwt struct {
	// Identifies the issuer that issued the JWT. See
	// [issuer](https://tools.ietf.org/html/rfc7519#section-4.1.1)
	// Usually a URL or an email address.
	//
	// Example: https://securetoken.google.com
	// Example: 1234567-compute@developer.gserviceaccount.com
	Issuer string `protobuf:"bytes,1,opt,name=issuer,proto3" json:"issuer,omitempty"`
	// The list of JWT
	// [audiences](https://tools.ietf.org/html/rfc7519#section-4.1.3).
	// that are allowed to access. A JWT containing any of these
	// audiences will be accepted.
	//
	// The service name will be accepted if audiences is empty.
	//
	// Example:
	//
	// ```yaml
	// audiences:
	// - bookstore_android.apps.googleusercontent.com
	//   bookstore_web.apps.googleusercontent.com
	// ```
	Audiences []string `protobuf:"bytes,2,rep,name=audiences" json:"audiences,omitempty"`
	// URL of the provider's public key set to validate signature of the
	// JWT. See [OpenID
	// Discovery](https://openid.net/specs/openid-connect-discovery-1_0.html#ProviderMetadata).
	//
	// Optional if the key set document can either (a) be retrieved from
	// [OpenID
	// Discovery](https://openid.net/specs/openid-connect-discovery-1_0.html) of
	// the issuer or (b) inferred from the email domain of the issuer (e.g. a
	// Google service account).
	//
	// Example: https://www.googleapis.com/oauth2/v1/certs
	JwksUri string `protobuf:"bytes,3,opt,name=jwks_uri,json=jwksUri,proto3" json:"jwks_uri,omitempty"`
	// JWT is sent in a request header. `header` represents the
	// header name.
	//
	// For example, if `header=x-goog-iap-jwt-assertion`, the header
	// format will be x-goog-iap-jwt-assertion: <JWT>.
	JwtHeaders []string `protobuf:"bytes,6,rep,name=jwt_headers,json=jwtHeaders" json:"jwt_headers,omitempty"`
	// JWT is sent in a query parameter. `query` represents the
	// query parameter name.
	//
	// For example, `query=jwt_token`.
	JwtParams []string `protobuf:"bytes,7,rep,name=jwt_params,json=jwtParams" json:"jwt_params,omitempty"`
}

func (m *Jwt) Reset()                    { *m = Jwt{} }
func (m *Jwt) String() string            { return proto.CompactTextString(m) }
func (*Jwt) ProtoMessage()               {}
func (*Jwt) Descriptor() ([]byte, []int) { return fileDescriptorPolicy, []int{1} }

func (m *Jwt) GetIssuer() string {
	if m != nil {
		return m.Issuer
	}
	return ""
}

func (m *Jwt) GetAudiences() []string {
	if m != nil {
		return m.Audiences
	}
	return nil
}

func (m *Jwt) GetJwksUri() string {
	if m != nil {
		return m.JwksUri
	}
	return ""
}

func (m *Jwt) GetJwtHeaders() []string {
	if m != nil {
		return m.JwtHeaders
	}
	return nil
}

func (m *Jwt) GetJwtParams() []string {
	if m != nil {
		return m.JwtParams
	}
	return nil
}

// PeerAuthenticationMethod defines one particular type of authentication, e.g
// mutual TLS, JWT etc, (no authentication is one type by itself) that can
// be used for peer authentication.
// The type can be progammatically determine by checking the type of the
// "params" field.
type PeerAuthenticationMethod struct {
	// Types that are valid to be assigned to Params:
	//	*PeerAuthenticationMethod_Mtls
	//	*PeerAuthenticationMethod_Jwt
	Params isPeerAuthenticationMethod_Params `protobuf_oneof:"params"`
}

func (m *PeerAuthenticationMethod) Reset()                    { *m = PeerAuthenticationMethod{} }
func (m *PeerAuthenticationMethod) String() string            { return proto.CompactTextString(m) }
func (*PeerAuthenticationMethod) ProtoMessage()               {}
func (*PeerAuthenticationMethod) Descriptor() ([]byte, []int) { return fileDescriptorPolicy, []int{2} }

type isPeerAuthenticationMethod_Params interface {
	isPeerAuthenticationMethod_Params()
	MarshalTo([]byte) (int, error)
	Size() int
}

type PeerAuthenticationMethod_Mtls struct {
	Mtls *MutualTls `protobuf:"bytes,1,opt,name=mtls,oneof"`
}
type PeerAuthenticationMethod_Jwt struct {
	Jwt *Jwt `protobuf:"bytes,2,opt,name=jwt,oneof"`
}

func (*PeerAuthenticationMethod_Mtls) isPeerAuthenticationMethod_Params() {}
func (*PeerAuthenticationMethod_Jwt) isPeerAuthenticationMethod_Params()  {}

func (m *PeerAuthenticationMethod) GetParams() isPeerAuthenticationMethod_Params {
	if m != nil {
		return m.Params
	}
	return nil
}

func (m *PeerAuthenticationMethod) GetMtls() *MutualTls {
	if x, ok := m.GetParams().(*PeerAuthenticationMethod_Mtls); ok {
		return x.Mtls
	}
	return nil
}

func (m *PeerAuthenticationMethod) GetJwt() *Jwt {
	if x, ok := m.GetParams().(*PeerAuthenticationMethod_Jwt); ok {
		return x.Jwt
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*PeerAuthenticationMethod) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _PeerAuthenticationMethod_OneofMarshaler, _PeerAuthenticationMethod_OneofUnmarshaler, _PeerAuthenticationMethod_OneofSizer, []interface{}{
		(*PeerAuthenticationMethod_Mtls)(nil),
		(*PeerAuthenticationMethod_Jwt)(nil),
	}
}

func _PeerAuthenticationMethod_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*PeerAuthenticationMethod)
	// params
	switch x := m.Params.(type) {
	case *PeerAuthenticationMethod_Mtls:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Mtls); err != nil {
			return err
		}
	case *PeerAuthenticationMethod_Jwt:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Jwt); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("PeerAuthenticationMethod.Params has unexpected type %T", x)
	}
	return nil
}

func _PeerAuthenticationMethod_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*PeerAuthenticationMethod)
	switch tag {
	case 1: // params.mtls
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MutualTls)
		err := b.DecodeMessage(msg)
		m.Params = &PeerAuthenticationMethod_Mtls{msg}
		return true, err
	case 2: // params.jwt
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Jwt)
		err := b.DecodeMessage(msg)
		m.Params = &PeerAuthenticationMethod_Jwt{msg}
		return true, err
	default:
		return false, nil
	}
}

func _PeerAuthenticationMethod_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*PeerAuthenticationMethod)
	// params
	switch x := m.Params.(type) {
	case *PeerAuthenticationMethod_Mtls:
		s := proto.Size(x.Mtls)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *PeerAuthenticationMethod_Jwt:
		s := proto.Size(x.Jwt)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// OriginAuthenticationMethod defines authentication method/params for origin
// authentication. Origin could be end-user, device, delegate service etc.
// Currently, only JWT is supported for origin authentication.
type OriginAuthenticationMethod struct {
	// Jwt params for the method.
	Jwt *Jwt `protobuf:"bytes,1,opt,name=jwt" json:"jwt,omitempty"`
}

func (m *OriginAuthenticationMethod) Reset()                    { *m = OriginAuthenticationMethod{} }
func (m *OriginAuthenticationMethod) String() string            { return proto.CompactTextString(m) }
func (*OriginAuthenticationMethod) ProtoMessage()               {}
func (*OriginAuthenticationMethod) Descriptor() ([]byte, []int) { return fileDescriptorPolicy, []int{3} }

func (m *OriginAuthenticationMethod) GetJwt() *Jwt {
	if m != nil {
		return m.Jwt
	}
	return nil
}

// Policy defines what authentication methods can be accepted on workload(s),
// and if authenticated, which method/certificate will set the request principal
// (i.e request.auth.principal attribute).
//
// Authentication policy is composed of 2-part authentication:
// - peer: verify caller service credentials. This part will set source.user
// (peer identity).
// - origin: verify the origin credentials. This part will set request.auth.user
// (origin identity), as well as other attributes like request.auth.presenter,
// request.auth.audiences and raw claims. Note that the identity could be
// end-user, service account, device etc.
//
// Last but not least, the principal binding rule defines which identity (peer
// or origin) should be used as principal. By default, it uses peer.
//
// Examples:
//
// Policy to enable mTLS for all services in namespace frod
//
// ```yaml
// apiVersion: authentication.istio.io/v1alpha1
// kind: Policy
// metadata:
//   name: mTLS_enable
//   namespace: frod
// spec:
//   peers:
//   - mtls:
// ```
// Policy to disable mTLS for "productpage" service
//
// ```yaml
// apiVersion: authentication.istio.io/v1alpha1
// kind: Policy
// metadata:
//   name: mTLS_disable
//   namespace: frod
// spec:
//   targets:
//   - name: productpage
// ```
// Policy to require mTLS for peer authentication, and JWT for origin authenticationn
// for productpage:9000. Principal is set from origin identity.
//
// ```yaml
// apiVersion: authentication.istio.io/v1alpha1
// kind: Policy
// metadata:
//   name: mTLS_enable
//   namespace: frod
// spec:
//   target:
//   - name: productpage
//     ports:
//     - number: 9000
//   peers:
//   - mtls:
//   origins:
//   - jwt:
//       issuer: "https://securetoken.google.com"
//       audiences:
//       - "productpage"
//       jwksUri: "https://www.googleapis.com/oauth2/v1/certs"
//       jwt_headers:
//       - "x-goog-iap-jwt-assertion"
//   principaBinding: USE_ORIGIN
// ```
//
// Policy to require mTLS for peer authentication, and JWT for origin authenticationn
// for productpage:9000, but allow origin authentication failed. Principal is set
// from origin identity.
// Note: this example can be used for use cases when we want to allow request from
// certain peers, given it comes with an approperiate authorization poicy to check
// and reject request accoridingly.
//
// ```yaml
// apiVersion: authentication.istio.io/v1alpha1
// kind: Policy
// metadata:
//   name: mTLS_enable
//   namespace: frod
// spec:
//   target:
//   - name: productpage
//     ports:
//     - number: 9000
//   peers:
//   - mtls:
//   origins:
//   - jwt:
//       issuer: "https://securetoken.google.com"
//       audiences:
//       - "productpage"
//       jwksUri: "https://www.googleapis.com/oauth2/v1/certs"
//       jwt_headers:
//       - "x-goog-iap-jwt-assertion"
//   originIsOptional: true
//   principalBinding: USE_ORIGIN
// ```
type Policy struct {
	// List rules to select destinations that the policy should be applied on.
	// If empty, policy will be used on all destinations in the same namespace.
	Targets []*TargetSelector `protobuf:"bytes,1,rep,name=targets" json:"targets,omitempty"`
	// List of authentication methods that can be used for peer authentication.
	// They will be evaluated in order; the first validate one will be used to
	// set peer identity (source.user) and other peer attributes. If none of
	// these methods pass, and peer_is_optional flag is false (see below),
	// request will be rejected with authentication failed error (401).
	// Leave the list empty if peer authentication is not required
	Peers []*PeerAuthenticationMethod `protobuf:"bytes,2,rep,name=peers" json:"peers,omitempty"`
	// Set this flag to true to accept request (for peer authentication perspective),
	// even when none of the peer authentication methods defined above satisfied.
	// Typically, this is used to delay the rejection decision to next layer (e.g
	// authorization).
	// This flag is ignored if no authentication defined for peer (peers field is empty).
	PeerIsOptional bool `protobuf:"varint,3,opt,name=peer_is_optional,json=peerIsOptional,proto3" json:"peer_is_optional,omitempty"`
	// List of authentication methods that can be used for origin authentication.
	// Similar to peers, these will be evaluated in order; the first validate one
	// will be used to set origin identity and attributes (i.e request.auth.user,
	// request.auth.issuer etc). If none of these methods pass, and origin_is_optional
	// is false (see below), request will be rejected with authentication failed
	// error (401).
	// Leave the list empty if origin authentication is not required.
	Origins []*OriginAuthenticationMethod `protobuf:"bytes,4,rep,name=origins" json:"origins,omitempty"`
	// Set this flag to true to accept request (for origin authentication perspective),
	// even when none of the origin authentication methods defined above satisfied.
	// Typically, this is used to delay the rejection decision to next layer (e.g
	// authorization).
	// This flag is ignored if no authentication defined for origin (origins field is empty).
	OriginIsOptional bool `protobuf:"varint,5,opt,name=origin_is_optional,json=originIsOptional,proto3" json:"origin_is_optional,omitempty"`
	// Define whether peer or origin identity should be use for principal. Default
	// value is USE_PEER.
	// If peer (or orgin) identity is not available, either because of peer/origin
	// authentication is not defined, or failed, principal will be left unset.
	// In other words, binding rule does not affect the decision to accept or
	// reject request.
	PrincipalBinding PrincipalBinding `protobuf:"varint,6,opt,name=principal_binding,json=principalBinding,proto3,enum=istio.authentication.v1alpha1.PrincipalBinding" json:"principal_binding,omitempty"`
}

func (m *Policy) Reset()                    { *m = Policy{} }
func (m *Policy) String() string            { return proto.CompactTextString(m) }
func (*Policy) ProtoMessage()               {}
func (*Policy) Descriptor() ([]byte, []int) { return fileDescriptorPolicy, []int{4} }

func (m *Policy) GetTargets() []*TargetSelector {
	if m != nil {
		return m.Targets
	}
	return nil
}

func (m *Policy) GetPeers() []*PeerAuthenticationMethod {
	if m != nil {
		return m.Peers
	}
	return nil
}

func (m *Policy) GetPeerIsOptional() bool {
	if m != nil {
		return m.PeerIsOptional
	}
	return false
}

func (m *Policy) GetOrigins() []*OriginAuthenticationMethod {
	if m != nil {
		return m.Origins
	}
	return nil
}

func (m *Policy) GetOriginIsOptional() bool {
	if m != nil {
		return m.OriginIsOptional
	}
	return false
}

func (m *Policy) GetPrincipalBinding() PrincipalBinding {
	if m != nil {
		return m.PrincipalBinding
	}
	return PrincipalBinding_USE_PEER
}

// TargetSelector defines a matching rule to a service/destination.
type TargetSelector struct {
	// REQUIRED. The name must be a short name from the service registry. The
	// fully qualified domain name will be resolved in a platform specific manner.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The name of a subset within the service. Applicable only to services
	// within the mesh. The subset must be defined in a corresponding
	// DestinationRule.
	Subset string `protobuf:"bytes,2,opt,name=subset,proto3" json:"subset,omitempty"`
	// Specifies the ports on the destination. Leave empty to match all ports
	// that are exposed.
	Ports []*PortSelector `protobuf:"bytes,3,rep,name=ports" json:"ports,omitempty"`
}

func (m *TargetSelector) Reset()                    { *m = TargetSelector{} }
func (m *TargetSelector) String() string            { return proto.CompactTextString(m) }
func (*TargetSelector) ProtoMessage()               {}
func (*TargetSelector) Descriptor() ([]byte, []int) { return fileDescriptorPolicy, []int{5} }

func (m *TargetSelector) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *TargetSelector) GetSubset() string {
	if m != nil {
		return m.Subset
	}
	return ""
}

func (m *TargetSelector) GetPorts() []*PortSelector {
	if m != nil {
		return m.Ports
	}
	return nil
}

// PortSelector specifies the name or number of a port to be used for
// matching targets for authenticationn policy. This is copied from
// networking API to avoid dependency.
type PortSelector struct {
	// Types that are valid to be assigned to Port:
	//	*PortSelector_Number
	//	*PortSelector_Name
	Port isPortSelector_Port `protobuf_oneof:"port"`
}

func (m *PortSelector) Reset()                    { *m = PortSelector{} }
func (m *PortSelector) String() string            { return proto.CompactTextString(m) }
func (*PortSelector) ProtoMessage()               {}
func (*PortSelector) Descriptor() ([]byte, []int) { return fileDescriptorPolicy, []int{6} }

type isPortSelector_Port interface {
	isPortSelector_Port()
	MarshalTo([]byte) (int, error)
	Size() int
}

type PortSelector_Number struct {
	Number uint32 `protobuf:"varint,1,opt,name=number,proto3,oneof"`
}
type PortSelector_Name struct {
	Name string `protobuf:"bytes,2,opt,name=name,proto3,oneof"`
}

func (*PortSelector_Number) isPortSelector_Port() {}
func (*PortSelector_Name) isPortSelector_Port()   {}

func (m *PortSelector) GetPort() isPortSelector_Port {
	if m != nil {
		return m.Port
	}
	return nil
}

func (m *PortSelector) GetNumber() uint32 {
	if x, ok := m.GetPort().(*PortSelector_Number); ok {
		return x.Number
	}
	return 0
}

func (m *PortSelector) GetName() string {
	if x, ok := m.GetPort().(*PortSelector_Name); ok {
		return x.Name
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*PortSelector) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _PortSelector_OneofMarshaler, _PortSelector_OneofUnmarshaler, _PortSelector_OneofSizer, []interface{}{
		(*PortSelector_Number)(nil),
		(*PortSelector_Name)(nil),
	}
}

func _PortSelector_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*PortSelector)
	// port
	switch x := m.Port.(type) {
	case *PortSelector_Number:
		_ = b.EncodeVarint(1<<3 | proto.WireVarint)
		_ = b.EncodeVarint(uint64(x.Number))
	case *PortSelector_Name:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Name)
	case nil:
	default:
		return fmt.Errorf("PortSelector.Port has unexpected type %T", x)
	}
	return nil
}

func _PortSelector_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*PortSelector)
	switch tag {
	case 1: // port.number
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Port = &PortSelector_Number{uint32(x)}
		return true, err
	case 2: // port.name
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Port = &PortSelector_Name{x}
		return true, err
	default:
		return false, nil
	}
}

func _PortSelector_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*PortSelector)
	// port
	switch x := m.Port.(type) {
	case *PortSelector_Number:
		n += proto.SizeVarint(1<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.Number))
	case *PortSelector_Name:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Name)))
		n += len(x.Name)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

func init() {
	proto.RegisterType((*MutualTls)(nil), "istio.authentication.v1alpha1.MutualTls")
	proto.RegisterType((*Jwt)(nil), "istio.authentication.v1alpha1.Jwt")
	proto.RegisterType((*PeerAuthenticationMethod)(nil), "istio.authentication.v1alpha1.PeerAuthenticationMethod")
	proto.RegisterType((*OriginAuthenticationMethod)(nil), "istio.authentication.v1alpha1.OriginAuthenticationMethod")
	proto.RegisterType((*Policy)(nil), "istio.authentication.v1alpha1.Policy")
	proto.RegisterType((*TargetSelector)(nil), "istio.authentication.v1alpha1.TargetSelector")
	proto.RegisterType((*PortSelector)(nil), "istio.authentication.v1alpha1.PortSelector")
	proto.RegisterEnum("istio.authentication.v1alpha1.PrincipalBinding", PrincipalBinding_name, PrincipalBinding_value)
	proto.RegisterEnum("istio.authentication.v1alpha1.MutualTls_Mode", MutualTls_Mode_name, MutualTls_Mode_value)
}
func (m *MutualTls) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MutualTls) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.AllowTls {
		dAtA[i] = 0x8
		i++
		if m.AllowTls {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Mode != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintPolicy(dAtA, i, uint64(m.Mode))
	}
	return i, nil
}

func (m *Jwt) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Jwt) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Issuer) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintPolicy(dAtA, i, uint64(len(m.Issuer)))
		i += copy(dAtA[i:], m.Issuer)
	}
	if len(m.Audiences) > 0 {
		for _, s := range m.Audiences {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.JwksUri) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintPolicy(dAtA, i, uint64(len(m.JwksUri)))
		i += copy(dAtA[i:], m.JwksUri)
	}
	if len(m.JwtHeaders) > 0 {
		for _, s := range m.JwtHeaders {
			dAtA[i] = 0x32
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.JwtParams) > 0 {
		for _, s := range m.JwtParams {
			dAtA[i] = 0x3a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	return i, nil
}

func (m *PeerAuthenticationMethod) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PeerAuthenticationMethod) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Params != nil {
		nn1, err := m.Params.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn1
	}
	return i, nil
}

func (m *PeerAuthenticationMethod_Mtls) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Mtls != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintPolicy(dAtA, i, uint64(m.Mtls.Size()))
		n2, err := m.Mtls.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	return i, nil
}
func (m *PeerAuthenticationMethod_Jwt) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Jwt != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintPolicy(dAtA, i, uint64(m.Jwt.Size()))
		n3, err := m.Jwt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	return i, nil
}
func (m *OriginAuthenticationMethod) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OriginAuthenticationMethod) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Jwt != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintPolicy(dAtA, i, uint64(m.Jwt.Size()))
		n4, err := m.Jwt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	return i, nil
}

func (m *Policy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Policy) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Targets) > 0 {
		for _, msg := range m.Targets {
			dAtA[i] = 0xa
			i++
			i = encodeVarintPolicy(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Peers) > 0 {
		for _, msg := range m.Peers {
			dAtA[i] = 0x12
			i++
			i = encodeVarintPolicy(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.PeerIsOptional {
		dAtA[i] = 0x18
		i++
		if m.PeerIsOptional {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.Origins) > 0 {
		for _, msg := range m.Origins {
			dAtA[i] = 0x22
			i++
			i = encodeVarintPolicy(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.OriginIsOptional {
		dAtA[i] = 0x28
		i++
		if m.OriginIsOptional {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.PrincipalBinding != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintPolicy(dAtA, i, uint64(m.PrincipalBinding))
	}
	return i, nil
}

func (m *TargetSelector) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TargetSelector) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintPolicy(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Subset) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintPolicy(dAtA, i, uint64(len(m.Subset)))
		i += copy(dAtA[i:], m.Subset)
	}
	if len(m.Ports) > 0 {
		for _, msg := range m.Ports {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintPolicy(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *PortSelector) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PortSelector) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Port != nil {
		nn5, err := m.Port.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn5
	}
	return i, nil
}

func (m *PortSelector_Number) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x8
	i++
	i = encodeVarintPolicy(dAtA, i, uint64(m.Number))
	return i, nil
}
func (m *PortSelector_Name) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x12
	i++
	i = encodeVarintPolicy(dAtA, i, uint64(len(m.Name)))
	i += copy(dAtA[i:], m.Name)
	return i, nil
}
func encodeVarintPolicy(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *MutualTls) Size() (n int) {
	var l int
	_ = l
	if m.AllowTls {
		n += 2
	}
	if m.Mode != 0 {
		n += 1 + sovPolicy(uint64(m.Mode))
	}
	return n
}

func (m *Jwt) Size() (n int) {
	var l int
	_ = l
	l = len(m.Issuer)
	if l > 0 {
		n += 1 + l + sovPolicy(uint64(l))
	}
	if len(m.Audiences) > 0 {
		for _, s := range m.Audiences {
			l = len(s)
			n += 1 + l + sovPolicy(uint64(l))
		}
	}
	l = len(m.JwksUri)
	if l > 0 {
		n += 1 + l + sovPolicy(uint64(l))
	}
	if len(m.JwtHeaders) > 0 {
		for _, s := range m.JwtHeaders {
			l = len(s)
			n += 1 + l + sovPolicy(uint64(l))
		}
	}
	if len(m.JwtParams) > 0 {
		for _, s := range m.JwtParams {
			l = len(s)
			n += 1 + l + sovPolicy(uint64(l))
		}
	}
	return n
}

func (m *PeerAuthenticationMethod) Size() (n int) {
	var l int
	_ = l
	if m.Params != nil {
		n += m.Params.Size()
	}
	return n
}

func (m *PeerAuthenticationMethod_Mtls) Size() (n int) {
	var l int
	_ = l
	if m.Mtls != nil {
		l = m.Mtls.Size()
		n += 1 + l + sovPolicy(uint64(l))
	}
	return n
}
func (m *PeerAuthenticationMethod_Jwt) Size() (n int) {
	var l int
	_ = l
	if m.Jwt != nil {
		l = m.Jwt.Size()
		n += 1 + l + sovPolicy(uint64(l))
	}
	return n
}
func (m *OriginAuthenticationMethod) Size() (n int) {
	var l int
	_ = l
	if m.Jwt != nil {
		l = m.Jwt.Size()
		n += 1 + l + sovPolicy(uint64(l))
	}
	return n
}

func (m *Policy) Size() (n int) {
	var l int
	_ = l
	if len(m.Targets) > 0 {
		for _, e := range m.Targets {
			l = e.Size()
			n += 1 + l + sovPolicy(uint64(l))
		}
	}
	if len(m.Peers) > 0 {
		for _, e := range m.Peers {
			l = e.Size()
			n += 1 + l + sovPolicy(uint64(l))
		}
	}
	if m.PeerIsOptional {
		n += 2
	}
	if len(m.Origins) > 0 {
		for _, e := range m.Origins {
			l = e.Size()
			n += 1 + l + sovPolicy(uint64(l))
		}
	}
	if m.OriginIsOptional {
		n += 2
	}
	if m.PrincipalBinding != 0 {
		n += 1 + sovPolicy(uint64(m.PrincipalBinding))
	}
	return n
}

func (m *TargetSelector) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovPolicy(uint64(l))
	}
	l = len(m.Subset)
	if l > 0 {
		n += 1 + l + sovPolicy(uint64(l))
	}
	if len(m.Ports) > 0 {
		for _, e := range m.Ports {
			l = e.Size()
			n += 1 + l + sovPolicy(uint64(l))
		}
	}
	return n
}

func (m *PortSelector) Size() (n int) {
	var l int
	_ = l
	if m.Port != nil {
		n += m.Port.Size()
	}
	return n
}

func (m *PortSelector_Number) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovPolicy(uint64(m.Number))
	return n
}
func (m *PortSelector_Name) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	n += 1 + l + sovPolicy(uint64(l))
	return n
}

func sovPolicy(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozPolicy(x uint64) (n int) {
	return sovPolicy(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *MutualTls) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPolicy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MutualTls: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MutualTls: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AllowTls", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.AllowTls = bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mode", wireType)
			}
			m.Mode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Mode |= (MutualTls_Mode(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPolicy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPolicy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Jwt) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPolicy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Jwt: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Jwt: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Issuer", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Issuer = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Audiences", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Audiences = append(m.Audiences, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field JwksUri", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.JwksUri = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field JwtHeaders", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.JwtHeaders = append(m.JwtHeaders, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field JwtParams", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.JwtParams = append(m.JwtParams, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPolicy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPolicy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PeerAuthenticationMethod) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPolicy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PeerAuthenticationMethod: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PeerAuthenticationMethod: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mtls", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &MutualTls{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Params = &PeerAuthenticationMethod_Mtls{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Jwt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Jwt{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Params = &PeerAuthenticationMethod_Jwt{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPolicy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPolicy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OriginAuthenticationMethod) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPolicy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OriginAuthenticationMethod: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OriginAuthenticationMethod: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Jwt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Jwt == nil {
				m.Jwt = &Jwt{}
			}
			if err := m.Jwt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPolicy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPolicy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Policy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPolicy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Policy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Policy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Targets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Targets = append(m.Targets, &TargetSelector{})
			if err := m.Targets[len(m.Targets)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Peers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Peers = append(m.Peers, &PeerAuthenticationMethod{})
			if err := m.Peers[len(m.Peers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PeerIsOptional", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.PeerIsOptional = bool(v != 0)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Origins", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Origins = append(m.Origins, &OriginAuthenticationMethod{})
			if err := m.Origins[len(m.Origins)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field OriginIsOptional", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.OriginIsOptional = bool(v != 0)
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrincipalBinding", wireType)
			}
			m.PrincipalBinding = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PrincipalBinding |= (PrincipalBinding(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPolicy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPolicy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TargetSelector) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPolicy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TargetSelector: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TargetSelector: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subset", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Subset = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ports", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ports = append(m.Ports, &PortSelector{})
			if err := m.Ports[len(m.Ports)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPolicy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPolicy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PortSelector) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPolicy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PortSelector: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PortSelector: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Number", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Port = &PortSelector_Number{v}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Port = &PortSelector_Name{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPolicy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPolicy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipPolicy(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowPolicy
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthPolicy
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowPolicy
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipPolicy(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthPolicy = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowPolicy   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("authentication/v1alpha1/policy.proto", fileDescriptorPolicy) }

var fileDescriptorPolicy = []byte{
	// 658 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x54, 0x4f, 0x6f, 0xd3, 0x3e,
	0x18, 0x6e, 0x9a, 0x2e, 0x6d, 0xdf, 0xee, 0x57, 0xe5, 0x67, 0x21, 0x14, 0xfe, 0x6c, 0x4c, 0xd1,
	0x0e, 0x15, 0x7f, 0x5a, 0x56, 0xd0, 0x10, 0x17, 0xa4, 0x15, 0x95, 0xb5, 0x13, 0x65, 0x95, 0xd3,
	0x71, 0x40, 0x48, 0x91, 0xdb, 0x5a, 0xab, 0x4b, 0x1a, 0x47, 0xb1, 0x43, 0xc4, 0x89, 0x6f, 0xc1,
	0x89, 0x1b, 0x47, 0xbe, 0x08, 0x47, 0x3e, 0x02, 0xda, 0x27, 0x41, 0x76, 0x52, 0xb6, 0x4e, 0x8c,
	0xee, 0xe6, 0xe7, 0xb5, 0x9f, 0xc7, 0x8f, 0x1f, 0xfb, 0x35, 0xec, 0x92, 0x44, 0xce, 0x68, 0x28,
	0xd9, 0x84, 0x48, 0xc6, 0xc3, 0xd6, 0xc7, 0x3d, 0x12, 0x44, 0x33, 0xb2, 0xd7, 0x8a, 0x78, 0xc0,
	0x26, 0x9f, 0x9a, 0x51, 0xcc, 0x25, 0x47, 0x5b, 0x4c, 0x48, 0xc6, 0x9b, 0xab, 0x6b, 0x9b, 0xcb,
	0xb5, 0xee, 0x37, 0x03, 0xaa, 0x83, 0x44, 0x26, 0x24, 0x18, 0x05, 0x02, 0xdd, 0x81, 0x2a, 0x09,
	0x02, 0x9e, 0xfa, 0x32, 0x10, 0x8e, 0xb1, 0x63, 0x34, 0x2a, 0xb8, 0xa2, 0x0b, 0x6a, 0xf2, 0x00,
	0x4a, 0x0b, 0x3e, 0xa5, 0x4e, 0x71, 0xc7, 0x68, 0xd4, 0xdb, 0x8f, 0x9a, 0xff, 0x14, 0x6e, 0xfe,
	0x11, 0x6d, 0x0e, 0xf8, 0x94, 0x62, 0x4d, 0x75, 0xf7, 0xa1, 0xa4, 0x10, 0x02, 0xb0, 0xbc, 0x11,
	0xee, 0xbf, 0x1c, 0xd9, 0x05, 0x84, 0xa0, 0x3e, 0x7a, 0xed, 0xf9, 0xc3, 0x2e, 0x1e, 0xf4, 0x3d,
	0xaf, 0xff, 0xb6, 0x6b, 0x1b, 0xa8, 0x0e, 0x70, 0x01, 0x17, 0xdd, 0x2f, 0x06, 0x98, 0x47, 0xa9,
	0x44, 0x37, 0xc1, 0x62, 0x42, 0x24, 0x34, 0xd6, 0xe6, 0xaa, 0x38, 0x47, 0xe8, 0x2e, 0x54, 0x49,
	0x32, 0x65, 0x34, 0x9c, 0x50, 0xe1, 0x14, 0x77, 0xcc, 0x46, 0x15, 0x9f, 0x17, 0xd0, 0x2d, 0xa8,
	0xcc, 0xd3, 0x0f, 0xc2, 0x4f, 0x62, 0xe6, 0x98, 0x9a, 0x57, 0x56, 0xf8, 0x24, 0x66, 0xe8, 0x1e,
	0xd4, 0xe6, 0xa9, 0xf4, 0x67, 0x94, 0x4c, 0x69, 0x2c, 0x1c, 0x4b, 0x53, 0x61, 0x9e, 0xca, 0x5e,
	0x56, 0x41, 0x5b, 0xa0, 0x90, 0x1f, 0x91, 0x98, 0x2c, 0x84, 0x53, 0xce, 0xa4, 0xe7, 0xa9, 0x1c,
	0xea, 0x82, 0xfb, 0xd5, 0x00, 0x67, 0x48, 0x69, 0x7c, 0xb0, 0x92, 0xc2, 0x80, 0xca, 0x19, 0x9f,
	0xa2, 0x17, 0x50, 0x5a, 0x2c, 0x83, 0xac, 0xb5, 0x1b, 0xd7, 0x0d, 0xac, 0x57, 0xc0, 0x9a, 0x87,
	0xf6, 0xc1, 0x9c, 0xa7, 0x52, 0xe7, 0x5d, 0x6b, 0xbb, 0x6b, 0xe8, 0x47, 0xa9, 0xec, 0x15, 0xb0,
	0x22, 0x74, 0x2a, 0x60, 0x65, 0x7e, 0x5d, 0x0c, 0xb7, 0x8f, 0x63, 0x76, 0xca, 0xc2, 0xbf, 0xfa,
	0x7b, 0x9a, 0xe9, 0x1b, 0xd7, 0xd5, 0xd7, 0xea, 0xee, 0x77, 0x13, 0xac, 0xa1, 0x7e, 0x61, 0xe8,
	0x10, 0xca, 0x92, 0xc4, 0xa7, 0x54, 0xaa, 0x33, 0x9a, 0x8d, 0xda, 0xda, 0x47, 0x31, 0xd2, 0xab,
	0x3d, 0x1a, 0xd0, 0x89, 0xe4, 0x31, 0x5e, 0xb2, 0xd1, 0x00, 0x36, 0x22, 0xaa, 0x2e, 0xa0, 0xa8,
	0x65, 0x9e, 0xad, 0x91, 0xb9, 0x2a, 0x71, 0x9c, 0xa9, 0xa0, 0x06, 0xd8, 0x6a, 0xe0, 0x33, 0xe1,
	0xf3, 0x48, 0x4d, 0x93, 0x40, 0x5f, 0x7c, 0x05, 0xd7, 0x55, 0xbd, 0x2f, 0x8e, 0xf3, 0x2a, 0xf2,
	0xa0, 0xcc, 0x75, 0x40, 0xc2, 0x29, 0xe9, 0xad, 0x9f, 0xaf, 0xd9, 0xfa, 0xea, 0x38, 0xf1, 0x52,
	0x09, 0x3d, 0x04, 0x94, 0x0d, 0x57, 0x0c, 0x6c, 0x68, 0x03, 0x76, 0x36, 0x73, 0xc1, 0xc2, 0x7b,
	0xf8, 0x3f, 0x8a, 0x59, 0x38, 0x61, 0x11, 0x09, 0xfc, 0x31, 0x0b, 0xa7, 0x2c, 0x3c, 0x75, 0x2c,
	0xdd, 0x63, 0xad, 0x75, 0x39, 0x2c, 0x79, 0x9d, 0x8c, 0x86, 0xed, 0xe8, 0x52, 0xc5, 0xfd, 0x0c,
	0xf5, 0xd5, 0xd0, 0x11, 0x82, 0x52, 0x48, 0x16, 0x34, 0xef, 0x20, 0x3d, 0x56, 0x7d, 0x25, 0x92,
	0xb1, 0xa0, 0xd9, 0x63, 0xab, 0xe2, 0x1c, 0xa1, 0x03, 0xd8, 0x88, 0x78, 0x2c, 0x85, 0x63, 0xea,
	0x70, 0x1e, 0xac, 0xf3, 0xc3, 0xe3, 0xf3, 0xcb, 0xcd, 0x98, 0xee, 0x2b, 0xd8, 0xbc, 0x58, 0x46,
	0x0e, 0x58, 0x61, 0xb2, 0x18, 0xe7, 0x2d, 0xfc, 0x5f, 0xaf, 0x80, 0x73, 0x8c, 0x6e, 0xe4, 0xc6,
	0xb4, 0x05, 0xd5, 0x04, 0x0a, 0x75, 0x2c, 0x28, 0x29, 0xa1, 0xfb, 0x8f, 0xc1, 0xbe, 0x7c, 0x5c,
	0xb4, 0x09, 0x95, 0x13, 0xaf, 0xeb, 0x0f, 0xbb, 0x5d, 0x6c, 0x17, 0xd4, 0xa7, 0xa1, 0xd0, 0x31,
	0xee, 0x1f, 0xf6, 0xdf, 0xd8, 0x46, 0xa7, 0xfd, 0xe3, 0x6c, 0xdb, 0xf8, 0x79, 0xb6, 0x6d, 0xfc,
	0x3a, 0xdb, 0x36, 0xde, 0xed, 0x66, 0xd6, 0x19, 0x6f, 0x91, 0x88, 0xb5, 0xae, 0xf8, 0x3a, 0xc7,
	0x96, 0xfe, 0x34, 0x9f, 0xfc, 0x0e, 0x00, 0x00, 0xff, 0xff, 0xa2, 0xed, 0x5c, 0xc1, 0x5c, 0x05,
	0x00, 0x00,
}
