// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: envoy/api/v2/route/route.proto

/*
	Package route is a generated protocol buffer package.

	It is generated from these files:
		envoy/api/v2/route/route.proto

	It has these top-level messages:
		VirtualHost
		Route
		WeightedCluster
		RouteMatch
		CorsPolicy
		RouteAction
		RedirectAction
		DirectResponseAction
		Decorator
		VirtualCluster
		RateLimit
		HeaderMatcher
		QueryParameterMatcher
*/
package route

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import envoy_api_v2_core "github.com/envoyproxy/go-control-plane/envoy/api/v2/core"
import envoy_api_v2_auth1 "github.com/envoyproxy/go-control-plane/envoy/api/v2/auth"
import envoy_type "github.com/envoyproxy/go-control-plane/envoy/type"
import _ "github.com/gogo/protobuf/types"
import google_protobuf "github.com/gogo/protobuf/types"
import google_protobuf1 "github.com/gogo/protobuf/types"
import _ "github.com/lyft/protoc-gen-validate/validate"
import _ "github.com/gogo/protobuf/gogoproto"

import time "time"

import github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type VirtualHost_TlsRequirementType int32

const (
	// No TLS requirement for the virtual host.
	VirtualHost_NONE VirtualHost_TlsRequirementType = 0
	// External requests must use TLS. If a request is external and it is not
	// using TLS, a 301 redirect will be sent telling the client to use HTTPS.
	VirtualHost_EXTERNAL_ONLY VirtualHost_TlsRequirementType = 1
	// All requests must use TLS. If a request is not using TLS, a 301 redirect
	// will be sent telling the client to use HTTPS.
	VirtualHost_ALL VirtualHost_TlsRequirementType = 2
)

var VirtualHost_TlsRequirementType_name = map[int32]string{
	0: "NONE",
	1: "EXTERNAL_ONLY",
	2: "ALL",
}
var VirtualHost_TlsRequirementType_value = map[string]int32{
	"NONE":          0,
	"EXTERNAL_ONLY": 1,
	"ALL":           2,
}

func (x VirtualHost_TlsRequirementType) String() string {
	return proto.EnumName(VirtualHost_TlsRequirementType_name, int32(x))
}
func (VirtualHost_TlsRequirementType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorRoute, []int{0, 0}
}

type RouteAction_ClusterNotFoundResponseCode int32

const (
	// HTTP status code - 503 Service Unavailable.
	RouteAction_SERVICE_UNAVAILABLE RouteAction_ClusterNotFoundResponseCode = 0
	// HTTP status code - 404 Not Found.
	RouteAction_NOT_FOUND RouteAction_ClusterNotFoundResponseCode = 1
)

var RouteAction_ClusterNotFoundResponseCode_name = map[int32]string{
	0: "SERVICE_UNAVAILABLE",
	1: "NOT_FOUND",
}
var RouteAction_ClusterNotFoundResponseCode_value = map[string]int32{
	"SERVICE_UNAVAILABLE": 0,
	"NOT_FOUND":           1,
}

func (x RouteAction_ClusterNotFoundResponseCode) String() string {
	return proto.EnumName(RouteAction_ClusterNotFoundResponseCode_name, int32(x))
}
func (RouteAction_ClusterNotFoundResponseCode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorRoute, []int{5, 0}
}

type RedirectAction_RedirectResponseCode int32

const (
	// Moved Permanently HTTP Status Code - 301.
	RedirectAction_MOVED_PERMANENTLY RedirectAction_RedirectResponseCode = 0
	// Found HTTP Status Code - 302.
	RedirectAction_FOUND RedirectAction_RedirectResponseCode = 1
	// See Other HTTP Status Code - 303.
	RedirectAction_SEE_OTHER RedirectAction_RedirectResponseCode = 2
	// Temporary Redirect HTTP Status Code - 307.
	RedirectAction_TEMPORARY_REDIRECT RedirectAction_RedirectResponseCode = 3
	// Permanent Redirect HTTP Status Code - 308.
	RedirectAction_PERMANENT_REDIRECT RedirectAction_RedirectResponseCode = 4
)

var RedirectAction_RedirectResponseCode_name = map[int32]string{
	0: "MOVED_PERMANENTLY",
	1: "FOUND",
	2: "SEE_OTHER",
	3: "TEMPORARY_REDIRECT",
	4: "PERMANENT_REDIRECT",
}
var RedirectAction_RedirectResponseCode_value = map[string]int32{
	"MOVED_PERMANENTLY":  0,
	"FOUND":              1,
	"SEE_OTHER":          2,
	"TEMPORARY_REDIRECT": 3,
	"PERMANENT_REDIRECT": 4,
}

func (x RedirectAction_RedirectResponseCode) String() string {
	return proto.EnumName(RedirectAction_RedirectResponseCode_name, int32(x))
}
func (RedirectAction_RedirectResponseCode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorRoute, []int{6, 0}
}

// The top level element in the routing configuration is a virtual host. Each virtual host has
// a logical name as well as a set of domains that get routed to it based on the incoming request's
// host header. This allows a single listener to service multiple top level domain path trees. Once
// a virtual host is selected based on the domain, the routes are processed in order to see which
// upstream cluster to route to or whether to perform a redirect.
type VirtualHost struct {
	// The logical name of the virtual host. This is used when emitting certain
	// statistics but is not relevant for routing.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A list of domains (host/authority header) that will be matched to this
	// virtual host. Wildcard hosts are supported in the form of “*.foo.com” or
	// “*-bar.foo.com”.
	//
	// .. note::
	//
	//   The wildcard will not match the empty string.
	//   e.g. “*-bar.foo.com” will match “baz-bar.foo.com” but not “-bar.foo.com”.
	//   Additionally, a special entry “*” is allowed which will match any
	//   host/authority header. Only a single virtual host in the entire route
	//   configuration can match on “*”. A domain must be unique across all virtual
	//   hosts or the config will fail to load.
	Domains []string `protobuf:"bytes,2,rep,name=domains" json:"domains,omitempty"`
	// The list of routes that will be matched, in order, for incoming requests.
	// The first route that matches will be used.
	Routes []Route `protobuf:"bytes,3,rep,name=routes" json:"routes"`
	// Specifies the type of TLS enforcement the virtual host expects. If this option is not
	// specified, there is no TLS requirement for the virtual host.
	RequireTls VirtualHost_TlsRequirementType `protobuf:"varint,4,opt,name=require_tls,json=requireTls,proto3,enum=envoy.api.v2.route.VirtualHost_TlsRequirementType" json:"require_tls,omitempty"`
	// A list of virtual clusters defined for this virtual host. Virtual clusters
	// are used for additional statistics gathering.
	VirtualClusters []*VirtualCluster `protobuf:"bytes,5,rep,name=virtual_clusters,json=virtualClusters" json:"virtual_clusters,omitempty"`
	// Specifies a set of rate limit configurations that will be applied to the
	// virtual host.
	RateLimits []*RateLimit `protobuf:"bytes,6,rep,name=rate_limits,json=rateLimits" json:"rate_limits,omitempty"`
	// Specifies a list of HTTP headers that should be added to each request
	// handled by this virtual host. Headers specified at this level are applied
	// after headers from enclosed :ref:`envoy_api_msg_route.RouteAction` and before headers from the
	// enclosing :ref:`envoy_api_msg_RouteConfiguration`. For more information, including
	// details on header value syntax, see the documentation on :ref:`custom request headers
	// <config_http_conn_man_headers_custom_request_headers>`.
	RequestHeadersToAdd []*envoy_api_v2_core.HeaderValueOption `protobuf:"bytes,7,rep,name=request_headers_to_add,json=requestHeadersToAdd" json:"request_headers_to_add,omitempty"`
	// Specifies a list of HTTP headers that should be added to each response
	// handled by this virtual host. Headers specified at this level are applied
	// after headers from enclosed :ref:`envoy_api_msg_route.RouteAction` and before headers from the
	// enclosing :ref:`envoy_api_msg_RouteConfiguration`. For more information, including
	// details on header value syntax, see the documentation on :ref:`custom request headers
	// <config_http_conn_man_headers_custom_request_headers>`.
	ResponseHeadersToAdd []*envoy_api_v2_core.HeaderValueOption `protobuf:"bytes,10,rep,name=response_headers_to_add,json=responseHeadersToAdd" json:"response_headers_to_add,omitempty"`
	// Specifies a list of HTTP headers that should be removed from each response
	// handled by this virtual host.
	ResponseHeadersToRemove []string `protobuf:"bytes,11,rep,name=response_headers_to_remove,json=responseHeadersToRemove" json:"response_headers_to_remove,omitempty"`
	// Indicates that the virtual host has a CORS policy.
	Cors *CorsPolicy `protobuf:"bytes,8,opt,name=cors" json:"cors,omitempty"`
	// [#not-implemented-hide:]
	// Return a 401/403 when auth checks fail.
	Auth *envoy_api_v2_auth1.AuthAction `protobuf:"bytes,9,opt,name=auth" json:"auth,omitempty"`
	// The per_filter_config field can be used to provide virtual host-specific
	// configurations for filters. The key should match the filter name, such as
	// *envoy.buffer* for the HTTP buffer filter. Use of this field is filter
	// specific; see the :ref:`HTTP filter documentation <config_http_filters>`
	// for if and how it is utilized.
	PerFilterConfig map[string]*google_protobuf.Struct `protobuf:"bytes,12,rep,name=per_filter_config,json=perFilterConfig" json:"per_filter_config,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *VirtualHost) Reset()                    { *m = VirtualHost{} }
func (m *VirtualHost) String() string            { return proto.CompactTextString(m) }
func (*VirtualHost) ProtoMessage()               {}
func (*VirtualHost) Descriptor() ([]byte, []int) { return fileDescriptorRoute, []int{0} }

func (m *VirtualHost) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *VirtualHost) GetDomains() []string {
	if m != nil {
		return m.Domains
	}
	return nil
}

func (m *VirtualHost) GetRoutes() []Route {
	if m != nil {
		return m.Routes
	}
	return nil
}

func (m *VirtualHost) GetRequireTls() VirtualHost_TlsRequirementType {
	if m != nil {
		return m.RequireTls
	}
	return VirtualHost_NONE
}

func (m *VirtualHost) GetVirtualClusters() []*VirtualCluster {
	if m != nil {
		return m.VirtualClusters
	}
	return nil
}

func (m *VirtualHost) GetRateLimits() []*RateLimit {
	if m != nil {
		return m.RateLimits
	}
	return nil
}

func (m *VirtualHost) GetRequestHeadersToAdd() []*envoy_api_v2_core.HeaderValueOption {
	if m != nil {
		return m.RequestHeadersToAdd
	}
	return nil
}

func (m *VirtualHost) GetResponseHeadersToAdd() []*envoy_api_v2_core.HeaderValueOption {
	if m != nil {
		return m.ResponseHeadersToAdd
	}
	return nil
}

func (m *VirtualHost) GetResponseHeadersToRemove() []string {
	if m != nil {
		return m.ResponseHeadersToRemove
	}
	return nil
}

func (m *VirtualHost) GetCors() *CorsPolicy {
	if m != nil {
		return m.Cors
	}
	return nil
}

func (m *VirtualHost) GetAuth() *envoy_api_v2_auth1.AuthAction {
	if m != nil {
		return m.Auth
	}
	return nil
}

func (m *VirtualHost) GetPerFilterConfig() map[string]*google_protobuf.Struct {
	if m != nil {
		return m.PerFilterConfig
	}
	return nil
}

// A route is both a specification of how to match a request as well as an indication of what to do
// next (e.g., redirect, forward, rewrite, etc.).
//
// .. attention::
//
//   Envoy supports routing on HTTP method via :ref:`header matching
//   <envoy_api_msg_route.HeaderMatcher>`.
type Route struct {
	// Route matching parameters.
	Match RouteMatch `protobuf:"bytes,1,opt,name=match" json:"match"`
	// Types that are valid to be assigned to Action:
	//	*Route_Route
	//	*Route_Redirect
	//	*Route_DirectResponse
	Action isRoute_Action `protobuf_oneof:"action"`
	// The Metadata field can be used to provide additional information
	// about the route. It can be used for configuration, stats, and logging.
	// The metadata should go under the filter namespace that will need it.
	// For instance, if the metadata is intended for the Router filter,
	// the filter name should be specified as *envoy.router*.
	Metadata *envoy_api_v2_core.Metadata `protobuf:"bytes,4,opt,name=metadata" json:"metadata,omitempty"`
	// Decorator for the matched route.
	Decorator *Decorator `protobuf:"bytes,5,opt,name=decorator" json:"decorator,omitempty"`
	// [#not-implemented-hide:]
	// Return a 401/403 when auth checks fail.
	Auth *envoy_api_v2_auth1.AuthAction `protobuf:"bytes,6,opt,name=auth" json:"auth,omitempty"`
	// The per_filter_config field can be used to provide route-specific
	// configurations for filters. The key should match the filter name, such as
	// *envoy.buffer* for the HTTP buffer filter. Use of this field is filter
	// specific; see the :ref:`HTTP filter documentation <config_http_filters>` for
	// if and how it is utilized.
	PerFilterConfig map[string]*google_protobuf.Struct `protobuf:"bytes,8,rep,name=per_filter_config,json=perFilterConfig" json:"per_filter_config,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *Route) Reset()                    { *m = Route{} }
func (m *Route) String() string            { return proto.CompactTextString(m) }
func (*Route) ProtoMessage()               {}
func (*Route) Descriptor() ([]byte, []int) { return fileDescriptorRoute, []int{1} }

type isRoute_Action interface {
	isRoute_Action()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type Route_Route struct {
	Route *RouteAction `protobuf:"bytes,2,opt,name=route,oneof"`
}
type Route_Redirect struct {
	Redirect *RedirectAction `protobuf:"bytes,3,opt,name=redirect,oneof"`
}
type Route_DirectResponse struct {
	DirectResponse *DirectResponseAction `protobuf:"bytes,7,opt,name=direct_response,json=directResponse,oneof"`
}

func (*Route_Route) isRoute_Action()          {}
func (*Route_Redirect) isRoute_Action()       {}
func (*Route_DirectResponse) isRoute_Action() {}

func (m *Route) GetAction() isRoute_Action {
	if m != nil {
		return m.Action
	}
	return nil
}

func (m *Route) GetMatch() RouteMatch {
	if m != nil {
		return m.Match
	}
	return RouteMatch{}
}

func (m *Route) GetRoute() *RouteAction {
	if x, ok := m.GetAction().(*Route_Route); ok {
		return x.Route
	}
	return nil
}

func (m *Route) GetRedirect() *RedirectAction {
	if x, ok := m.GetAction().(*Route_Redirect); ok {
		return x.Redirect
	}
	return nil
}

func (m *Route) GetDirectResponse() *DirectResponseAction {
	if x, ok := m.GetAction().(*Route_DirectResponse); ok {
		return x.DirectResponse
	}
	return nil
}

func (m *Route) GetMetadata() *envoy_api_v2_core.Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Route) GetDecorator() *Decorator {
	if m != nil {
		return m.Decorator
	}
	return nil
}

func (m *Route) GetAuth() *envoy_api_v2_auth1.AuthAction {
	if m != nil {
		return m.Auth
	}
	return nil
}

func (m *Route) GetPerFilterConfig() map[string]*google_protobuf.Struct {
	if m != nil {
		return m.PerFilterConfig
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Route) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Route_OneofMarshaler, _Route_OneofUnmarshaler, _Route_OneofSizer, []interface{}{
		(*Route_Route)(nil),
		(*Route_Redirect)(nil),
		(*Route_DirectResponse)(nil),
	}
}

func _Route_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Route)
	// action
	switch x := m.Action.(type) {
	case *Route_Route:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Route); err != nil {
			return err
		}
	case *Route_Redirect:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Redirect); err != nil {
			return err
		}
	case *Route_DirectResponse:
		_ = b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DirectResponse); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Route.Action has unexpected type %T", x)
	}
	return nil
}

func _Route_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Route)
	switch tag {
	case 2: // action.route
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RouteAction)
		err := b.DecodeMessage(msg)
		m.Action = &Route_Route{msg}
		return true, err
	case 3: // action.redirect
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RedirectAction)
		err := b.DecodeMessage(msg)
		m.Action = &Route_Redirect{msg}
		return true, err
	case 7: // action.direct_response
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DirectResponseAction)
		err := b.DecodeMessage(msg)
		m.Action = &Route_DirectResponse{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Route_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Route)
	// action
	switch x := m.Action.(type) {
	case *Route_Route:
		s := proto.Size(x.Route)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Route_Redirect:
		s := proto.Size(x.Redirect)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Route_DirectResponse:
		s := proto.Size(x.DirectResponse)
		n += proto.SizeVarint(7<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Compared to the :ref:`cluster <envoy_api_field_route.RouteAction.cluster>` field that specifies a
// single upstream cluster as the target of a request, the :ref:`weighted_clusters
// <envoy_api_field_route.RouteAction.weighted_clusters>` option allows for specification of
// multiple upstream clusters along with weights that indicate the percentage of
// traffic to be forwarded to each cluster. The router selects an upstream cluster based on the
// weights.
type WeightedCluster struct {
	// Specifies one or more upstream clusters associated with the route.
	Clusters []*WeightedCluster_ClusterWeight `protobuf:"bytes,1,rep,name=clusters" json:"clusters,omitempty"`
	// Specifies the total weight across all clusters. The sum of all cluster weights must equal this
	// value, which must be greater than 0. Defaults to 100.
	TotalWeight *google_protobuf1.UInt32Value `protobuf:"bytes,3,opt,name=total_weight,json=totalWeight" json:"total_weight,omitempty"`
	// Specifies the runtime key prefix that should be used to construct the
	// runtime keys associated with each cluster. When the *runtime_key_prefix* is
	// specified, the router will look for weights associated with each upstream
	// cluster under the key *runtime_key_prefix* + "." + *cluster[i].name* where
	// *cluster[i]* denotes an entry in the clusters array field. If the runtime
	// key for the cluster does not exist, the value specified in the
	// configuration file will be used as the default weight. See the :ref:`runtime documentation
	// <operations_runtime>` for how key names map to the underlying implementation.
	RuntimeKeyPrefix string `protobuf:"bytes,2,opt,name=runtime_key_prefix,json=runtimeKeyPrefix,proto3" json:"runtime_key_prefix,omitempty"`
}

func (m *WeightedCluster) Reset()                    { *m = WeightedCluster{} }
func (m *WeightedCluster) String() string            { return proto.CompactTextString(m) }
func (*WeightedCluster) ProtoMessage()               {}
func (*WeightedCluster) Descriptor() ([]byte, []int) { return fileDescriptorRoute, []int{2} }

func (m *WeightedCluster) GetClusters() []*WeightedCluster_ClusterWeight {
	if m != nil {
		return m.Clusters
	}
	return nil
}

func (m *WeightedCluster) GetTotalWeight() *google_protobuf1.UInt32Value {
	if m != nil {
		return m.TotalWeight
	}
	return nil
}

func (m *WeightedCluster) GetRuntimeKeyPrefix() string {
	if m != nil {
		return m.RuntimeKeyPrefix
	}
	return ""
}

type WeightedCluster_ClusterWeight struct {
	// Name of the upstream cluster. The cluster must exist in the
	// :ref:`cluster manager configuration <config_cluster_manager>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// An integer between 0 and :ref:`total_weight
	// <envoy_api_field_route.WeightedCluster.total_weight>`. When a request matches the route,
	// the choice of an upstream cluster is determined by its weight. The sum of weights across all
	// entries in the clusters array must add up to the total_weight, which defaults to 100.
	Weight *google_protobuf1.UInt32Value `protobuf:"bytes,2,opt,name=weight" json:"weight,omitempty"`
	// Optional endpoint metadata match criteria. Only endpoints in the upstream
	// cluster with metadata matching that set in metadata_match will be
	// considered. The filter name should be specified as *envoy.lb*.
	MetadataMatch *envoy_api_v2_core.Metadata `protobuf:"bytes,3,opt,name=metadata_match,json=metadataMatch" json:"metadata_match,omitempty"`
	// Specifies a list of headers to be added to requests when this cluster is selected
	// through the enclosing :ref:`envoy_api_msg_route.RouteAction`.
	// Headers specified at this level are applied before headers from the enclosing
	// :ref:`envoy_api_msg_route.RouteAction`,
	// :ref:`envoy_api_msg_route.VirtualHost`, and
	// :ref:`envoy_api_msg_RouteConfiguration`. For more information, including details on
	// header value syntax, see the documentation on :ref:`custom request headers
	// <config_http_conn_man_headers_custom_request_headers>`.
	RequestHeadersToAdd []*envoy_api_v2_core.HeaderValueOption `protobuf:"bytes,4,rep,name=request_headers_to_add,json=requestHeadersToAdd" json:"request_headers_to_add,omitempty"`
	// Specifies a list of headers to be added to responses when this cluster is selected
	// through the enclosing :ref:`envoy_api_msg_route.RouteAction`.
	// Headers specified at this level are applied before headers from the enclosing
	// :ref:`envoy_api_msg_route.RouteAction`,
	// :ref:`envoy_api_msg_route.VirtualHost`, and
	// :ref:`envoy_api_msg_RouteConfiguration`. For more information, including details on
	// header value syntax, see the documentation on :ref:`custom request headers
	// <config_http_conn_man_headers_custom_request_headers>`.
	ResponseHeadersToAdd []*envoy_api_v2_core.HeaderValueOption `protobuf:"bytes,5,rep,name=response_headers_to_add,json=responseHeadersToAdd" json:"response_headers_to_add,omitempty"`
	// Specifies a list of headers to be removed from responses when this cluster is selected
	// through the enclosing :ref:`envoy_api_msg_route.RouteAction`.
	ResponseHeadersToRemove []string `protobuf:"bytes,6,rep,name=response_headers_to_remove,json=responseHeadersToRemove" json:"response_headers_to_remove,omitempty"`
	// The per_filter_config field can be used to provide weighted cluster-specific
	// configurations for filters. The key should match the filter name, such as
	// *envoy.buffer* for the HTTP buffer filter. Use of this field is filter
	// specific; see the :ref:`HTTP filter documentation <config_http_filters>`
	// for if and how it is utilized.
	PerFilterConfig map[string]*google_protobuf.Struct `protobuf:"bytes,8,rep,name=per_filter_config,json=perFilterConfig" json:"per_filter_config,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *WeightedCluster_ClusterWeight) Reset()         { *m = WeightedCluster_ClusterWeight{} }
func (m *WeightedCluster_ClusterWeight) String() string { return proto.CompactTextString(m) }
func (*WeightedCluster_ClusterWeight) ProtoMessage()    {}
func (*WeightedCluster_ClusterWeight) Descriptor() ([]byte, []int) {
	return fileDescriptorRoute, []int{2, 0}
}

func (m *WeightedCluster_ClusterWeight) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *WeightedCluster_ClusterWeight) GetWeight() *google_protobuf1.UInt32Value {
	if m != nil {
		return m.Weight
	}
	return nil
}

func (m *WeightedCluster_ClusterWeight) GetMetadataMatch() *envoy_api_v2_core.Metadata {
	if m != nil {
		return m.MetadataMatch
	}
	return nil
}

func (m *WeightedCluster_ClusterWeight) GetRequestHeadersToAdd() []*envoy_api_v2_core.HeaderValueOption {
	if m != nil {
		return m.RequestHeadersToAdd
	}
	return nil
}

func (m *WeightedCluster_ClusterWeight) GetResponseHeadersToAdd() []*envoy_api_v2_core.HeaderValueOption {
	if m != nil {
		return m.ResponseHeadersToAdd
	}
	return nil
}

func (m *WeightedCluster_ClusterWeight) GetResponseHeadersToRemove() []string {
	if m != nil {
		return m.ResponseHeadersToRemove
	}
	return nil
}

func (m *WeightedCluster_ClusterWeight) GetPerFilterConfig() map[string]*google_protobuf.Struct {
	if m != nil {
		return m.PerFilterConfig
	}
	return nil
}

type RouteMatch struct {
	// Types that are valid to be assigned to PathSpecifier:
	//	*RouteMatch_Prefix
	//	*RouteMatch_Path
	//	*RouteMatch_Regex
	PathSpecifier isRouteMatch_PathSpecifier `protobuf_oneof:"path_specifier"`
	// Indicates that prefix/path matching should be case insensitive. The default
	// is true.
	CaseSensitive *google_protobuf1.BoolValue `protobuf:"bytes,4,opt,name=case_sensitive,json=caseSensitive" json:"case_sensitive,omitempty"`
	// Indicates that the route should additionally match on a runtime key. An
	// integer between 0-100. Every time the route is considered for a match, a
	// random number between 0-99 is selected. If the number is <= the value found
	// in the key (checked first) or, if the key is not present, the default
	// value, the route is a match (assuming everything also about the route
	// matches). A runtime route configuration can be used to roll out route changes in a
	// gradual manner without full code/config deploys. Refer to the
	// :ref:`traffic shifting <config_http_conn_man_route_table_traffic_splitting_shift>` docs
	// for additional documentation.
	Runtime *envoy_api_v2_core.RuntimeUInt32 `protobuf:"bytes,5,opt,name=runtime" json:"runtime,omitempty"`
	// Specifies a set of headers that the route should match on. The router will
	// check the request’s headers against all the specified headers in the route
	// config. A match will happen if all the headers in the route are present in
	// the request with the same values (or based on presence if the value field
	// is not in the config).
	Headers []*HeaderMatcher `protobuf:"bytes,6,rep,name=headers" json:"headers,omitempty"`
	// Specifies a set of URL query parameters on which the route should
	// match. The router will check the query string from the *path* header
	// against all the specified query parameters. If the number of specified
	// query parameters is nonzero, they all must match the *path* header's
	// query string for a match to occur.
	QueryParameters []*QueryParameterMatcher `protobuf:"bytes,7,rep,name=query_parameters,json=queryParameters" json:"query_parameters,omitempty"`
}

func (m *RouteMatch) Reset()                    { *m = RouteMatch{} }
func (m *RouteMatch) String() string            { return proto.CompactTextString(m) }
func (*RouteMatch) ProtoMessage()               {}
func (*RouteMatch) Descriptor() ([]byte, []int) { return fileDescriptorRoute, []int{3} }

type isRouteMatch_PathSpecifier interface {
	isRouteMatch_PathSpecifier()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type RouteMatch_Prefix struct {
	Prefix string `protobuf:"bytes,1,opt,name=prefix,proto3,oneof"`
}
type RouteMatch_Path struct {
	Path string `protobuf:"bytes,2,opt,name=path,proto3,oneof"`
}
type RouteMatch_Regex struct {
	Regex string `protobuf:"bytes,3,opt,name=regex,proto3,oneof"`
}

func (*RouteMatch_Prefix) isRouteMatch_PathSpecifier() {}
func (*RouteMatch_Path) isRouteMatch_PathSpecifier()   {}
func (*RouteMatch_Regex) isRouteMatch_PathSpecifier()  {}

func (m *RouteMatch) GetPathSpecifier() isRouteMatch_PathSpecifier {
	if m != nil {
		return m.PathSpecifier
	}
	return nil
}

func (m *RouteMatch) GetPrefix() string {
	if x, ok := m.GetPathSpecifier().(*RouteMatch_Prefix); ok {
		return x.Prefix
	}
	return ""
}

func (m *RouteMatch) GetPath() string {
	if x, ok := m.GetPathSpecifier().(*RouteMatch_Path); ok {
		return x.Path
	}
	return ""
}

func (m *RouteMatch) GetRegex() string {
	if x, ok := m.GetPathSpecifier().(*RouteMatch_Regex); ok {
		return x.Regex
	}
	return ""
}

func (m *RouteMatch) GetCaseSensitive() *google_protobuf1.BoolValue {
	if m != nil {
		return m.CaseSensitive
	}
	return nil
}

func (m *RouteMatch) GetRuntime() *envoy_api_v2_core.RuntimeUInt32 {
	if m != nil {
		return m.Runtime
	}
	return nil
}

func (m *RouteMatch) GetHeaders() []*HeaderMatcher {
	if m != nil {
		return m.Headers
	}
	return nil
}

func (m *RouteMatch) GetQueryParameters() []*QueryParameterMatcher {
	if m != nil {
		return m.QueryParameters
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*RouteMatch) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _RouteMatch_OneofMarshaler, _RouteMatch_OneofUnmarshaler, _RouteMatch_OneofSizer, []interface{}{
		(*RouteMatch_Prefix)(nil),
		(*RouteMatch_Path)(nil),
		(*RouteMatch_Regex)(nil),
	}
}

func _RouteMatch_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*RouteMatch)
	// path_specifier
	switch x := m.PathSpecifier.(type) {
	case *RouteMatch_Prefix:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Prefix)
	case *RouteMatch_Path:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Path)
	case *RouteMatch_Regex:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Regex)
	case nil:
	default:
		return fmt.Errorf("RouteMatch.PathSpecifier has unexpected type %T", x)
	}
	return nil
}

func _RouteMatch_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*RouteMatch)
	switch tag {
	case 1: // path_specifier.prefix
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.PathSpecifier = &RouteMatch_Prefix{x}
		return true, err
	case 2: // path_specifier.path
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.PathSpecifier = &RouteMatch_Path{x}
		return true, err
	case 3: // path_specifier.regex
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.PathSpecifier = &RouteMatch_Regex{x}
		return true, err
	default:
		return false, nil
	}
}

func _RouteMatch_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*RouteMatch)
	// path_specifier
	switch x := m.PathSpecifier.(type) {
	case *RouteMatch_Prefix:
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Prefix)))
		n += len(x.Prefix)
	case *RouteMatch_Path:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Path)))
		n += len(x.Path)
	case *RouteMatch_Regex:
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Regex)))
		n += len(x.Regex)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type CorsPolicy struct {
	// Specifies the origins that will be allowed to do CORS requests.
	AllowOrigin []string `protobuf:"bytes,1,rep,name=allow_origin,json=allowOrigin" json:"allow_origin,omitempty"`
	// Specifies the content for the *access-control-allow-methods* header.
	AllowMethods string `protobuf:"bytes,2,opt,name=allow_methods,json=allowMethods,proto3" json:"allow_methods,omitempty"`
	// Specifies the content for the *access-control-allow-headers* header.
	AllowHeaders string `protobuf:"bytes,3,opt,name=allow_headers,json=allowHeaders,proto3" json:"allow_headers,omitempty"`
	// Specifies the content for the *access-control-expose-headers* header.
	ExposeHeaders string `protobuf:"bytes,4,opt,name=expose_headers,json=exposeHeaders,proto3" json:"expose_headers,omitempty"`
	// Specifies the content for the *access-control-max-age* header.
	MaxAge string `protobuf:"bytes,5,opt,name=max_age,json=maxAge,proto3" json:"max_age,omitempty"`
	// Specifies whether the resource allows credentials.
	AllowCredentials *google_protobuf1.BoolValue `protobuf:"bytes,6,opt,name=allow_credentials,json=allowCredentials" json:"allow_credentials,omitempty"`
	// Specifies if CORS is enabled. Defaults to true. Only effective on route.
	Enabled *google_protobuf1.BoolValue `protobuf:"bytes,7,opt,name=enabled" json:"enabled,omitempty"`
}

func (m *CorsPolicy) Reset()                    { *m = CorsPolicy{} }
func (m *CorsPolicy) String() string            { return proto.CompactTextString(m) }
func (*CorsPolicy) ProtoMessage()               {}
func (*CorsPolicy) Descriptor() ([]byte, []int) { return fileDescriptorRoute, []int{4} }

func (m *CorsPolicy) GetAllowOrigin() []string {
	if m != nil {
		return m.AllowOrigin
	}
	return nil
}

func (m *CorsPolicy) GetAllowMethods() string {
	if m != nil {
		return m.AllowMethods
	}
	return ""
}

func (m *CorsPolicy) GetAllowHeaders() string {
	if m != nil {
		return m.AllowHeaders
	}
	return ""
}

func (m *CorsPolicy) GetExposeHeaders() string {
	if m != nil {
		return m.ExposeHeaders
	}
	return ""
}

func (m *CorsPolicy) GetMaxAge() string {
	if m != nil {
		return m.MaxAge
	}
	return ""
}

func (m *CorsPolicy) GetAllowCredentials() *google_protobuf1.BoolValue {
	if m != nil {
		return m.AllowCredentials
	}
	return nil
}

func (m *CorsPolicy) GetEnabled() *google_protobuf1.BoolValue {
	if m != nil {
		return m.Enabled
	}
	return nil
}

type RouteAction struct {
	// Types that are valid to be assigned to ClusterSpecifier:
	//	*RouteAction_Cluster
	//	*RouteAction_ClusterHeader
	//	*RouteAction_WeightedClusters
	ClusterSpecifier isRouteAction_ClusterSpecifier `protobuf_oneof:"cluster_specifier"`
	// The HTTP status code to use when configured cluster is not found.
	// The default response code is 503 Service Unavailable.
	ClusterNotFoundResponseCode RouteAction_ClusterNotFoundResponseCode `protobuf:"varint,20,opt,name=cluster_not_found_response_code,json=clusterNotFoundResponseCode,proto3,enum=envoy.api.v2.route.RouteAction_ClusterNotFoundResponseCode" json:"cluster_not_found_response_code,omitempty"`
	// Optional endpoint metadata match criteria. Only endpoints in the upstream
	// cluster with metadata matching that set in metadata_match will be
	// considered. The filter name should be specified as *envoy.lb*.
	MetadataMatch *envoy_api_v2_core.Metadata `protobuf:"bytes,4,opt,name=metadata_match,json=metadataMatch" json:"metadata_match,omitempty"`
	// Indicates that during forwarding, the matched prefix (or path) should be
	// swapped with this value. This option allows application URLs to be rooted
	// at a different path from those exposed at the reverse proxy layer.
	PrefixRewrite string `protobuf:"bytes,5,opt,name=prefix_rewrite,json=prefixRewrite,proto3" json:"prefix_rewrite,omitempty"`
	// Types that are valid to be assigned to HostRewriteSpecifier:
	//	*RouteAction_HostRewrite
	//	*RouteAction_AutoHostRewrite
	HostRewriteSpecifier isRouteAction_HostRewriteSpecifier `protobuf_oneof:"host_rewrite_specifier"`
	// Specifies the timeout for the route. If not specified, the default is 15s.
	//
	// .. note::
	//
	//   This timeout includes all retries. See also
	//   :ref:`config_http_filters_router_x-envoy-upstream-rq-timeout-ms`,
	//   :ref:`config_http_filters_router_x-envoy-upstream-rq-per-try-timeout-ms`, and the
	//   :ref:`retry overview <arch_overview_http_routing_retry>`.
	Timeout *time.Duration `protobuf:"bytes,8,opt,name=timeout,stdduration" json:"timeout,omitempty"`
	// Indicates that the route has a retry policy.
	RetryPolicy *RouteAction_RetryPolicy `protobuf:"bytes,9,opt,name=retry_policy,json=retryPolicy" json:"retry_policy,omitempty"`
	// Indicates that the route has a request mirroring policy.
	RequestMirrorPolicy *RouteAction_RequestMirrorPolicy `protobuf:"bytes,10,opt,name=request_mirror_policy,json=requestMirrorPolicy" json:"request_mirror_policy,omitempty"`
	// Optionally specifies the :ref:`routing priority <arch_overview_http_routing_priority>`.
	// [#comment:TODO(htuch): add (validate.rules).enum.defined_only = true once
	// https://github.com/lyft/protoc-gen-validate/issues/42 is resolved.]
	Priority envoy_api_v2_core.RoutingPriority `protobuf:"varint,11,opt,name=priority,proto3,enum=envoy.api.v2.core.RoutingPriority" json:"priority,omitempty"`
	// Specifies a set of headers that will be added to requests matching this
	// route. Headers specified at this level are applied before headers from the
	// enclosing :ref:`envoy_api_msg_route.VirtualHost` and
	// :ref:`envoy_api_msg_RouteConfiguration`. For more information, including details on
	// header value syntax, see the documentation on :ref:`custom request headers
	// <config_http_conn_man_headers_custom_request_headers>`.
	RequestHeadersToAdd []*envoy_api_v2_core.HeaderValueOption `protobuf:"bytes,12,rep,name=request_headers_to_add,json=requestHeadersToAdd" json:"request_headers_to_add,omitempty"`
	// Specifies a set of headers that will be added to responses to requests
	// matching this route. Headers specified at this level are applied before
	// headers from the enclosing :ref:`envoy_api_msg_route.VirtualHost` and
	// :ref:`envoy_api_msg_RouteConfiguration`. For more information, including
	// details on header value syntax, see the documentation on
	// :ref:`custom request headers <config_http_conn_man_headers_custom_request_headers>`.
	ResponseHeadersToAdd []*envoy_api_v2_core.HeaderValueOption `protobuf:"bytes,18,rep,name=response_headers_to_add,json=responseHeadersToAdd" json:"response_headers_to_add,omitempty"`
	// Specifies a list of HTTP headers that should be removed from each response
	// to requests matching this route.
	ResponseHeadersToRemove []string `protobuf:"bytes,19,rep,name=response_headers_to_remove,json=responseHeadersToRemove" json:"response_headers_to_remove,omitempty"`
	// Specifies a set of rate limit configurations that could be applied to the
	// route.
	RateLimits []*RateLimit `protobuf:"bytes,13,rep,name=rate_limits,json=rateLimits" json:"rate_limits,omitempty"`
	// Specifies if the rate limit filter should include the virtual host rate
	// limits. By default, if the route configured rate limits, the virtual host
	// :ref:`rate_limits <envoy_api_field_route.VirtualHost.rate_limits>` are not applied to the
	// request.
	IncludeVhRateLimits *google_protobuf1.BoolValue `protobuf:"bytes,14,opt,name=include_vh_rate_limits,json=includeVhRateLimits" json:"include_vh_rate_limits,omitempty"`
	// Specifies a list of hash policies to use for ring hash load balancing. Each
	// hash policy is evaluated individually and the combined result is used to
	// route the request. The method of combination is deterministic such that
	// identical lists of hash policies will produce the same hash. Since a hash
	// policy examines specific parts of a request, it can fail to produce a hash
	// (i.e. if the hashed header is not present). If (and only if) all configured
	// hash policies fail to generate a hash, no hash will be produced for
	// the route. In this case, the behavior is the same as if no hash policies
	// were specified (i.e. the ring hash load balancer will choose a random
	// backend).
	HashPolicy []*RouteAction_HashPolicy `protobuf:"bytes,15,rep,name=hash_policy,json=hashPolicy" json:"hash_policy,omitempty"`
	// Indicates that a HTTP/1.1 client connection to this particular route
	// should be allowed (and expected) to upgrade to a WebSocket connection. The
	// default is false.
	//
	// .. attention::
	//
	//   If set to true, Envoy will expect the first request matching this route to
	//   contain WebSocket upgrade headers. If the headers are not present, the
	//   connection will be rejected. If set to true, Envoy will setup plain TCP
	//   proxying between the client and the upstream server. Hence, an upstream
	//   server that rejects the WebSocket upgrade request is also responsible for
	//   closing the associated connection. Until then, Envoy will continue to
	//   proxy data from the client to the upstream server.
	//
	//   Redirects, timeouts and retries are not supported on routes where websocket upgrades are
	//   allowed.
	UseWebsocket *google_protobuf1.BoolValue `protobuf:"bytes,16,opt,name=use_websocket,json=useWebsocket" json:"use_websocket,omitempty"`
	// Indicates that the route has a CORS policy.
	Cors *CorsPolicy `protobuf:"bytes,17,opt,name=cors" json:"cors,omitempty"`
}

func (m *RouteAction) Reset()                    { *m = RouteAction{} }
func (m *RouteAction) String() string            { return proto.CompactTextString(m) }
func (*RouteAction) ProtoMessage()               {}
func (*RouteAction) Descriptor() ([]byte, []int) { return fileDescriptorRoute, []int{5} }

type isRouteAction_ClusterSpecifier interface {
	isRouteAction_ClusterSpecifier()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}
type isRouteAction_HostRewriteSpecifier interface {
	isRouteAction_HostRewriteSpecifier()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type RouteAction_Cluster struct {
	Cluster string `protobuf:"bytes,1,opt,name=cluster,proto3,oneof"`
}
type RouteAction_ClusterHeader struct {
	ClusterHeader string `protobuf:"bytes,2,opt,name=cluster_header,json=clusterHeader,proto3,oneof"`
}
type RouteAction_WeightedClusters struct {
	WeightedClusters *WeightedCluster `protobuf:"bytes,3,opt,name=weighted_clusters,json=weightedClusters,oneof"`
}
type RouteAction_HostRewrite struct {
	HostRewrite string `protobuf:"bytes,6,opt,name=host_rewrite,json=hostRewrite,proto3,oneof"`
}
type RouteAction_AutoHostRewrite struct {
	AutoHostRewrite *google_protobuf1.BoolValue `protobuf:"bytes,7,opt,name=auto_host_rewrite,json=autoHostRewrite,oneof"`
}

func (*RouteAction_Cluster) isRouteAction_ClusterSpecifier()             {}
func (*RouteAction_ClusterHeader) isRouteAction_ClusterSpecifier()       {}
func (*RouteAction_WeightedClusters) isRouteAction_ClusterSpecifier()    {}
func (*RouteAction_HostRewrite) isRouteAction_HostRewriteSpecifier()     {}
func (*RouteAction_AutoHostRewrite) isRouteAction_HostRewriteSpecifier() {}

func (m *RouteAction) GetClusterSpecifier() isRouteAction_ClusterSpecifier {
	if m != nil {
		return m.ClusterSpecifier
	}
	return nil
}
func (m *RouteAction) GetHostRewriteSpecifier() isRouteAction_HostRewriteSpecifier {
	if m != nil {
		return m.HostRewriteSpecifier
	}
	return nil
}

func (m *RouteAction) GetCluster() string {
	if x, ok := m.GetClusterSpecifier().(*RouteAction_Cluster); ok {
		return x.Cluster
	}
	return ""
}

func (m *RouteAction) GetClusterHeader() string {
	if x, ok := m.GetClusterSpecifier().(*RouteAction_ClusterHeader); ok {
		return x.ClusterHeader
	}
	return ""
}

func (m *RouteAction) GetWeightedClusters() *WeightedCluster {
	if x, ok := m.GetClusterSpecifier().(*RouteAction_WeightedClusters); ok {
		return x.WeightedClusters
	}
	return nil
}

func (m *RouteAction) GetClusterNotFoundResponseCode() RouteAction_ClusterNotFoundResponseCode {
	if m != nil {
		return m.ClusterNotFoundResponseCode
	}
	return RouteAction_SERVICE_UNAVAILABLE
}

func (m *RouteAction) GetMetadataMatch() *envoy_api_v2_core.Metadata {
	if m != nil {
		return m.MetadataMatch
	}
	return nil
}

func (m *RouteAction) GetPrefixRewrite() string {
	if m != nil {
		return m.PrefixRewrite
	}
	return ""
}

func (m *RouteAction) GetHostRewrite() string {
	if x, ok := m.GetHostRewriteSpecifier().(*RouteAction_HostRewrite); ok {
		return x.HostRewrite
	}
	return ""
}

func (m *RouteAction) GetAutoHostRewrite() *google_protobuf1.BoolValue {
	if x, ok := m.GetHostRewriteSpecifier().(*RouteAction_AutoHostRewrite); ok {
		return x.AutoHostRewrite
	}
	return nil
}

func (m *RouteAction) GetTimeout() *time.Duration {
	if m != nil {
		return m.Timeout
	}
	return nil
}

func (m *RouteAction) GetRetryPolicy() *RouteAction_RetryPolicy {
	if m != nil {
		return m.RetryPolicy
	}
	return nil
}

func (m *RouteAction) GetRequestMirrorPolicy() *RouteAction_RequestMirrorPolicy {
	if m != nil {
		return m.RequestMirrorPolicy
	}
	return nil
}

func (m *RouteAction) GetPriority() envoy_api_v2_core.RoutingPriority {
	if m != nil {
		return m.Priority
	}
	return envoy_api_v2_core.RoutingPriority_DEFAULT
}

func (m *RouteAction) GetRequestHeadersToAdd() []*envoy_api_v2_core.HeaderValueOption {
	if m != nil {
		return m.RequestHeadersToAdd
	}
	return nil
}

func (m *RouteAction) GetResponseHeadersToAdd() []*envoy_api_v2_core.HeaderValueOption {
	if m != nil {
		return m.ResponseHeadersToAdd
	}
	return nil
}

func (m *RouteAction) GetResponseHeadersToRemove() []string {
	if m != nil {
		return m.ResponseHeadersToRemove
	}
	return nil
}

func (m *RouteAction) GetRateLimits() []*RateLimit {
	if m != nil {
		return m.RateLimits
	}
	return nil
}

func (m *RouteAction) GetIncludeVhRateLimits() *google_protobuf1.BoolValue {
	if m != nil {
		return m.IncludeVhRateLimits
	}
	return nil
}

func (m *RouteAction) GetHashPolicy() []*RouteAction_HashPolicy {
	if m != nil {
		return m.HashPolicy
	}
	return nil
}

func (m *RouteAction) GetUseWebsocket() *google_protobuf1.BoolValue {
	if m != nil {
		return m.UseWebsocket
	}
	return nil
}

func (m *RouteAction) GetCors() *CorsPolicy {
	if m != nil {
		return m.Cors
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*RouteAction) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _RouteAction_OneofMarshaler, _RouteAction_OneofUnmarshaler, _RouteAction_OneofSizer, []interface{}{
		(*RouteAction_Cluster)(nil),
		(*RouteAction_ClusterHeader)(nil),
		(*RouteAction_WeightedClusters)(nil),
		(*RouteAction_HostRewrite)(nil),
		(*RouteAction_AutoHostRewrite)(nil),
	}
}

func _RouteAction_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*RouteAction)
	// cluster_specifier
	switch x := m.ClusterSpecifier.(type) {
	case *RouteAction_Cluster:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Cluster)
	case *RouteAction_ClusterHeader:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.ClusterHeader)
	case *RouteAction_WeightedClusters:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.WeightedClusters); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("RouteAction.ClusterSpecifier has unexpected type %T", x)
	}
	// host_rewrite_specifier
	switch x := m.HostRewriteSpecifier.(type) {
	case *RouteAction_HostRewrite:
		_ = b.EncodeVarint(6<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.HostRewrite)
	case *RouteAction_AutoHostRewrite:
		_ = b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AutoHostRewrite); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("RouteAction.HostRewriteSpecifier has unexpected type %T", x)
	}
	return nil
}

func _RouteAction_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*RouteAction)
	switch tag {
	case 1: // cluster_specifier.cluster
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.ClusterSpecifier = &RouteAction_Cluster{x}
		return true, err
	case 2: // cluster_specifier.cluster_header
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.ClusterSpecifier = &RouteAction_ClusterHeader{x}
		return true, err
	case 3: // cluster_specifier.weighted_clusters
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(WeightedCluster)
		err := b.DecodeMessage(msg)
		m.ClusterSpecifier = &RouteAction_WeightedClusters{msg}
		return true, err
	case 6: // host_rewrite_specifier.host_rewrite
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.HostRewriteSpecifier = &RouteAction_HostRewrite{x}
		return true, err
	case 7: // host_rewrite_specifier.auto_host_rewrite
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(google_protobuf1.BoolValue)
		err := b.DecodeMessage(msg)
		m.HostRewriteSpecifier = &RouteAction_AutoHostRewrite{msg}
		return true, err
	default:
		return false, nil
	}
}

func _RouteAction_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*RouteAction)
	// cluster_specifier
	switch x := m.ClusterSpecifier.(type) {
	case *RouteAction_Cluster:
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Cluster)))
		n += len(x.Cluster)
	case *RouteAction_ClusterHeader:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.ClusterHeader)))
		n += len(x.ClusterHeader)
	case *RouteAction_WeightedClusters:
		s := proto.Size(x.WeightedClusters)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// host_rewrite_specifier
	switch x := m.HostRewriteSpecifier.(type) {
	case *RouteAction_HostRewrite:
		n += proto.SizeVarint(6<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.HostRewrite)))
		n += len(x.HostRewrite)
	case *RouteAction_AutoHostRewrite:
		s := proto.Size(x.AutoHostRewrite)
		n += proto.SizeVarint(7<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// HTTP retry :ref:`architecture overview <arch_overview_http_routing_retry>`.
type RouteAction_RetryPolicy struct {
	// Specifies the conditions under which retry takes place. These are the same
	// conditions documented for :ref:`config_http_filters_router_x-envoy-retry-on` and
	// :ref:`config_http_filters_router_x-envoy-retry-grpc-on`.
	RetryOn string `protobuf:"bytes,1,opt,name=retry_on,json=retryOn,proto3" json:"retry_on,omitempty"`
	// Specifies the allowed number of retries. This parameter is optional and
	// defaults to 1. These are the same conditions documented for
	// :ref:`config_http_filters_router_x-envoy-max-retries`.
	NumRetries *google_protobuf1.UInt32Value `protobuf:"bytes,2,opt,name=num_retries,json=numRetries" json:"num_retries,omitempty"`
	// Specifies a non-zero timeout per retry attempt. This parameter is optional.
	// The same conditions documented for
	// :ref:`config_http_filters_router_x-envoy-upstream-rq-per-try-timeout-ms` apply.
	//
	// .. note::
	//
	//   If left unspecified, Envoy will use the global
	//   :ref:`route timeout <envoy_api_field_route.RouteAction.timeout>` for the request.
	//   Consequently, when using a :ref:`5xx <config_http_filters_router_x-envoy-retry-on>` based
	//   retry policy, a request that times out will not be retried as the total timeout budget
	//   would have been exhausted.
	PerTryTimeout *time.Duration `protobuf:"bytes,3,opt,name=per_try_timeout,json=perTryTimeout,stdduration" json:"per_try_timeout,omitempty"`
}

func (m *RouteAction_RetryPolicy) Reset()                    { *m = RouteAction_RetryPolicy{} }
func (m *RouteAction_RetryPolicy) String() string            { return proto.CompactTextString(m) }
func (*RouteAction_RetryPolicy) ProtoMessage()               {}
func (*RouteAction_RetryPolicy) Descriptor() ([]byte, []int) { return fileDescriptorRoute, []int{5, 0} }

func (m *RouteAction_RetryPolicy) GetRetryOn() string {
	if m != nil {
		return m.RetryOn
	}
	return ""
}

func (m *RouteAction_RetryPolicy) GetNumRetries() *google_protobuf1.UInt32Value {
	if m != nil {
		return m.NumRetries
	}
	return nil
}

func (m *RouteAction_RetryPolicy) GetPerTryTimeout() *time.Duration {
	if m != nil {
		return m.PerTryTimeout
	}
	return nil
}

// The router is capable of shadowing traffic from one cluster to another. The current
// implementation is "fire and forget," meaning Envoy will not wait for the shadow cluster to
// respond before returning the response from the primary cluster. All normal statistics are
// collected for the shadow cluster making this feature useful for testing.
//
// During shadowing, the host/authority header is altered such that *-shadow* is appended. This is
// useful for logging. For example, *cluster1* becomes *cluster1-shadow*.
type RouteAction_RequestMirrorPolicy struct {
	// Specifies the cluster that requests will be mirrored to. The cluster must
	// exist in the cluster manager configuration.
	Cluster string `protobuf:"bytes,1,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// If not specified, all requests to the target cluster will be mirrored. If
	// specified, Envoy will lookup the runtime key to get the % of requests to
	// mirror. Valid values are from 0 to 10000, allowing for increments of
	// 0.01% of requests to be mirrored. If the runtime key is specified in the
	// configuration but not present in runtime, 0 is the default and thus 0% of
	// requests will be mirrored.
	RuntimeKey string `protobuf:"bytes,2,opt,name=runtime_key,json=runtimeKey,proto3" json:"runtime_key,omitempty"`
}

func (m *RouteAction_RequestMirrorPolicy) Reset()         { *m = RouteAction_RequestMirrorPolicy{} }
func (m *RouteAction_RequestMirrorPolicy) String() string { return proto.CompactTextString(m) }
func (*RouteAction_RequestMirrorPolicy) ProtoMessage()    {}
func (*RouteAction_RequestMirrorPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptorRoute, []int{5, 1}
}

func (m *RouteAction_RequestMirrorPolicy) GetCluster() string {
	if m != nil {
		return m.Cluster
	}
	return ""
}

func (m *RouteAction_RequestMirrorPolicy) GetRuntimeKey() string {
	if m != nil {
		return m.RuntimeKey
	}
	return ""
}

// Specifies the route's hashing policy if the upstream cluster uses a hashing :ref:`load balancer
// <arch_overview_load_balancing_types>`.
type RouteAction_HashPolicy struct {
	// Types that are valid to be assigned to PolicySpecifier:
	//	*RouteAction_HashPolicy_Header_
	//	*RouteAction_HashPolicy_Cookie_
	//	*RouteAction_HashPolicy_ConnectionProperties_
	PolicySpecifier isRouteAction_HashPolicy_PolicySpecifier `protobuf_oneof:"policy_specifier"`
}

func (m *RouteAction_HashPolicy) Reset()                    { *m = RouteAction_HashPolicy{} }
func (m *RouteAction_HashPolicy) String() string            { return proto.CompactTextString(m) }
func (*RouteAction_HashPolicy) ProtoMessage()               {}
func (*RouteAction_HashPolicy) Descriptor() ([]byte, []int) { return fileDescriptorRoute, []int{5, 2} }

type isRouteAction_HashPolicy_PolicySpecifier interface {
	isRouteAction_HashPolicy_PolicySpecifier()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type RouteAction_HashPolicy_Header_ struct {
	Header *RouteAction_HashPolicy_Header `protobuf:"bytes,1,opt,name=header,oneof"`
}
type RouteAction_HashPolicy_Cookie_ struct {
	Cookie *RouteAction_HashPolicy_Cookie `protobuf:"bytes,2,opt,name=cookie,oneof"`
}
type RouteAction_HashPolicy_ConnectionProperties_ struct {
	ConnectionProperties *RouteAction_HashPolicy_ConnectionProperties `protobuf:"bytes,3,opt,name=connection_properties,json=connectionProperties,oneof"`
}

func (*RouteAction_HashPolicy_Header_) isRouteAction_HashPolicy_PolicySpecifier()               {}
func (*RouteAction_HashPolicy_Cookie_) isRouteAction_HashPolicy_PolicySpecifier()               {}
func (*RouteAction_HashPolicy_ConnectionProperties_) isRouteAction_HashPolicy_PolicySpecifier() {}

func (m *RouteAction_HashPolicy) GetPolicySpecifier() isRouteAction_HashPolicy_PolicySpecifier {
	if m != nil {
		return m.PolicySpecifier
	}
	return nil
}

func (m *RouteAction_HashPolicy) GetHeader() *RouteAction_HashPolicy_Header {
	if x, ok := m.GetPolicySpecifier().(*RouteAction_HashPolicy_Header_); ok {
		return x.Header
	}
	return nil
}

func (m *RouteAction_HashPolicy) GetCookie() *RouteAction_HashPolicy_Cookie {
	if x, ok := m.GetPolicySpecifier().(*RouteAction_HashPolicy_Cookie_); ok {
		return x.Cookie
	}
	return nil
}

func (m *RouteAction_HashPolicy) GetConnectionProperties() *RouteAction_HashPolicy_ConnectionProperties {
	if x, ok := m.GetPolicySpecifier().(*RouteAction_HashPolicy_ConnectionProperties_); ok {
		return x.ConnectionProperties
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*RouteAction_HashPolicy) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _RouteAction_HashPolicy_OneofMarshaler, _RouteAction_HashPolicy_OneofUnmarshaler, _RouteAction_HashPolicy_OneofSizer, []interface{}{
		(*RouteAction_HashPolicy_Header_)(nil),
		(*RouteAction_HashPolicy_Cookie_)(nil),
		(*RouteAction_HashPolicy_ConnectionProperties_)(nil),
	}
}

func _RouteAction_HashPolicy_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*RouteAction_HashPolicy)
	// policy_specifier
	switch x := m.PolicySpecifier.(type) {
	case *RouteAction_HashPolicy_Header_:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Header); err != nil {
			return err
		}
	case *RouteAction_HashPolicy_Cookie_:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Cookie); err != nil {
			return err
		}
	case *RouteAction_HashPolicy_ConnectionProperties_:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ConnectionProperties); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("RouteAction_HashPolicy.PolicySpecifier has unexpected type %T", x)
	}
	return nil
}

func _RouteAction_HashPolicy_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*RouteAction_HashPolicy)
	switch tag {
	case 1: // policy_specifier.header
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RouteAction_HashPolicy_Header)
		err := b.DecodeMessage(msg)
		m.PolicySpecifier = &RouteAction_HashPolicy_Header_{msg}
		return true, err
	case 2: // policy_specifier.cookie
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RouteAction_HashPolicy_Cookie)
		err := b.DecodeMessage(msg)
		m.PolicySpecifier = &RouteAction_HashPolicy_Cookie_{msg}
		return true, err
	case 3: // policy_specifier.connection_properties
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RouteAction_HashPolicy_ConnectionProperties)
		err := b.DecodeMessage(msg)
		m.PolicySpecifier = &RouteAction_HashPolicy_ConnectionProperties_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _RouteAction_HashPolicy_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*RouteAction_HashPolicy)
	// policy_specifier
	switch x := m.PolicySpecifier.(type) {
	case *RouteAction_HashPolicy_Header_:
		s := proto.Size(x.Header)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RouteAction_HashPolicy_Cookie_:
		s := proto.Size(x.Cookie)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RouteAction_HashPolicy_ConnectionProperties_:
		s := proto.Size(x.ConnectionProperties)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type RouteAction_HashPolicy_Header struct {
	// The name of the request header that will be used to obtain the hash
	// key. If the request header is not present, no hash will be produced.
	HeaderName string `protobuf:"bytes,1,opt,name=header_name,json=headerName,proto3" json:"header_name,omitempty"`
}

func (m *RouteAction_HashPolicy_Header) Reset()         { *m = RouteAction_HashPolicy_Header{} }
func (m *RouteAction_HashPolicy_Header) String() string { return proto.CompactTextString(m) }
func (*RouteAction_HashPolicy_Header) ProtoMessage()    {}
func (*RouteAction_HashPolicy_Header) Descriptor() ([]byte, []int) {
	return fileDescriptorRoute, []int{5, 2, 0}
}

func (m *RouteAction_HashPolicy_Header) GetHeaderName() string {
	if m != nil {
		return m.HeaderName
	}
	return ""
}

// Envoy supports two types of cookie affinity:
//
// 1. Passive. Envoy takes a cookie that's present in the cookies header and
//    hashes on its value.
//
// 2. Generated. Envoy generates and sets a cookie with an expiration (TTL)
//    on the first request from the client in its response to the client,
//    based on the endpoint the request gets sent to. The client then
//    presents this on the next and all subsequent requests. The hash of
//    this is sufficient to ensure these requests get sent to the same
//    endpoint. The cookie is generated by hashing the source and
//    destination ports and addresses so that multiple independent HTTP2
//    streams on the same connection will independently receive the same
//    cookie, even if they arrive at the Envoy simultaneously.
type RouteAction_HashPolicy_Cookie struct {
	// The name of the cookie that will be used to obtain the hash key. If the
	// cookie is not present and ttl below is not set, no hash will be
	// produced.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If specified, a cookie with the TTL will be generated if the cookie is
	// not present.
	Ttl *time.Duration `protobuf:"bytes,2,opt,name=ttl,stdduration" json:"ttl,omitempty"`
}

func (m *RouteAction_HashPolicy_Cookie) Reset()         { *m = RouteAction_HashPolicy_Cookie{} }
func (m *RouteAction_HashPolicy_Cookie) String() string { return proto.CompactTextString(m) }
func (*RouteAction_HashPolicy_Cookie) ProtoMessage()    {}
func (*RouteAction_HashPolicy_Cookie) Descriptor() ([]byte, []int) {
	return fileDescriptorRoute, []int{5, 2, 1}
}

func (m *RouteAction_HashPolicy_Cookie) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *RouteAction_HashPolicy_Cookie) GetTtl() *time.Duration {
	if m != nil {
		return m.Ttl
	}
	return nil
}

type RouteAction_HashPolicy_ConnectionProperties struct {
	// Hash on source IP address.
	SourceIp bool `protobuf:"varint,1,opt,name=source_ip,json=sourceIp,proto3" json:"source_ip,omitempty"`
}

func (m *RouteAction_HashPolicy_ConnectionProperties) Reset() {
	*m = RouteAction_HashPolicy_ConnectionProperties{}
}
func (m *RouteAction_HashPolicy_ConnectionProperties) String() string {
	return proto.CompactTextString(m)
}
func (*RouteAction_HashPolicy_ConnectionProperties) ProtoMessage() {}
func (*RouteAction_HashPolicy_ConnectionProperties) Descriptor() ([]byte, []int) {
	return fileDescriptorRoute, []int{5, 2, 2}
}

func (m *RouteAction_HashPolicy_ConnectionProperties) GetSourceIp() bool {
	if m != nil {
		return m.SourceIp
	}
	return false
}

type RedirectAction struct {
	// The host portion of the URL will be swapped with this value.
	HostRedirect string `protobuf:"bytes,1,opt,name=host_redirect,json=hostRedirect,proto3" json:"host_redirect,omitempty"`
	// Types that are valid to be assigned to PathRewriteSpecifier:
	//	*RedirectAction_PathRedirect
	//	*RedirectAction_PrefixRewrite
	PathRewriteSpecifier isRedirectAction_PathRewriteSpecifier `protobuf_oneof:"path_rewrite_specifier"`
	// The HTTP status code to use in the redirect response. The default response
	// code is MOVED_PERMANENTLY (301).
	ResponseCode RedirectAction_RedirectResponseCode `protobuf:"varint,3,opt,name=response_code,json=responseCode,proto3,enum=envoy.api.v2.route.RedirectAction_RedirectResponseCode" json:"response_code,omitempty"`
	// The scheme portion of the URL will be swapped with "https".
	HttpsRedirect bool `protobuf:"varint,4,opt,name=https_redirect,json=httpsRedirect,proto3" json:"https_redirect,omitempty"`
	// Indicates that during redirection, the query portion of the URL will
	// be removed. Default value is false.
	StripQuery bool `protobuf:"varint,6,opt,name=strip_query,json=stripQuery,proto3" json:"strip_query,omitempty"`
}

func (m *RedirectAction) Reset()                    { *m = RedirectAction{} }
func (m *RedirectAction) String() string            { return proto.CompactTextString(m) }
func (*RedirectAction) ProtoMessage()               {}
func (*RedirectAction) Descriptor() ([]byte, []int) { return fileDescriptorRoute, []int{6} }

type isRedirectAction_PathRewriteSpecifier interface {
	isRedirectAction_PathRewriteSpecifier()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type RedirectAction_PathRedirect struct {
	PathRedirect string `protobuf:"bytes,2,opt,name=path_redirect,json=pathRedirect,proto3,oneof"`
}
type RedirectAction_PrefixRewrite struct {
	PrefixRewrite string `protobuf:"bytes,5,opt,name=prefix_rewrite,json=prefixRewrite,proto3,oneof"`
}

func (*RedirectAction_PathRedirect) isRedirectAction_PathRewriteSpecifier()  {}
func (*RedirectAction_PrefixRewrite) isRedirectAction_PathRewriteSpecifier() {}

func (m *RedirectAction) GetPathRewriteSpecifier() isRedirectAction_PathRewriteSpecifier {
	if m != nil {
		return m.PathRewriteSpecifier
	}
	return nil
}

func (m *RedirectAction) GetHostRedirect() string {
	if m != nil {
		return m.HostRedirect
	}
	return ""
}

func (m *RedirectAction) GetPathRedirect() string {
	if x, ok := m.GetPathRewriteSpecifier().(*RedirectAction_PathRedirect); ok {
		return x.PathRedirect
	}
	return ""
}

func (m *RedirectAction) GetPrefixRewrite() string {
	if x, ok := m.GetPathRewriteSpecifier().(*RedirectAction_PrefixRewrite); ok {
		return x.PrefixRewrite
	}
	return ""
}

func (m *RedirectAction) GetResponseCode() RedirectAction_RedirectResponseCode {
	if m != nil {
		return m.ResponseCode
	}
	return RedirectAction_MOVED_PERMANENTLY
}

func (m *RedirectAction) GetHttpsRedirect() bool {
	if m != nil {
		return m.HttpsRedirect
	}
	return false
}

func (m *RedirectAction) GetStripQuery() bool {
	if m != nil {
		return m.StripQuery
	}
	return false
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*RedirectAction) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _RedirectAction_OneofMarshaler, _RedirectAction_OneofUnmarshaler, _RedirectAction_OneofSizer, []interface{}{
		(*RedirectAction_PathRedirect)(nil),
		(*RedirectAction_PrefixRewrite)(nil),
	}
}

func _RedirectAction_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*RedirectAction)
	// path_rewrite_specifier
	switch x := m.PathRewriteSpecifier.(type) {
	case *RedirectAction_PathRedirect:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.PathRedirect)
	case *RedirectAction_PrefixRewrite:
		_ = b.EncodeVarint(5<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.PrefixRewrite)
	case nil:
	default:
		return fmt.Errorf("RedirectAction.PathRewriteSpecifier has unexpected type %T", x)
	}
	return nil
}

func _RedirectAction_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*RedirectAction)
	switch tag {
	case 2: // path_rewrite_specifier.path_redirect
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.PathRewriteSpecifier = &RedirectAction_PathRedirect{x}
		return true, err
	case 5: // path_rewrite_specifier.prefix_rewrite
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.PathRewriteSpecifier = &RedirectAction_PrefixRewrite{x}
		return true, err
	default:
		return false, nil
	}
}

func _RedirectAction_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*RedirectAction)
	// path_rewrite_specifier
	switch x := m.PathRewriteSpecifier.(type) {
	case *RedirectAction_PathRedirect:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.PathRedirect)))
		n += len(x.PathRedirect)
	case *RedirectAction_PrefixRewrite:
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.PrefixRewrite)))
		n += len(x.PrefixRewrite)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type DirectResponseAction struct {
	// Specifies the HTTP response status to be returned.
	Status uint32 `protobuf:"varint,1,opt,name=status,proto3" json:"status,omitempty"`
	// Specifies the content of the response body. If this setting is omitted,
	// no body is included in the generated response.
	//
	// .. note::
	//
	//   Headers can be specified using *response_headers_to_add* in
	//   :ref:`envoy_api_msg_RouteConfiguration`.
	Body *envoy_api_v2_core.DataSource `protobuf:"bytes,2,opt,name=body" json:"body,omitempty"`
}

func (m *DirectResponseAction) Reset()                    { *m = DirectResponseAction{} }
func (m *DirectResponseAction) String() string            { return proto.CompactTextString(m) }
func (*DirectResponseAction) ProtoMessage()               {}
func (*DirectResponseAction) Descriptor() ([]byte, []int) { return fileDescriptorRoute, []int{7} }

func (m *DirectResponseAction) GetStatus() uint32 {
	if m != nil {
		return m.Status
	}
	return 0
}

func (m *DirectResponseAction) GetBody() *envoy_api_v2_core.DataSource {
	if m != nil {
		return m.Body
	}
	return nil
}

type Decorator struct {
	// The operation name associated with the request matched to this route. If tracing is
	// enabled, this information will be used as the span name reported for this request.
	//
	// .. note::
	//
	//   For ingress (inbound) requests, or egress (outbound) responses, this value may be overridden
	//   by the :ref:`x-envoy-decorator-operation
	//   <config_http_filters_router_x-envoy-decorator-operation>` header.
	Operation string `protobuf:"bytes,1,opt,name=operation,proto3" json:"operation,omitempty"`
}

func (m *Decorator) Reset()                    { *m = Decorator{} }
func (m *Decorator) String() string            { return proto.CompactTextString(m) }
func (*Decorator) ProtoMessage()               {}
func (*Decorator) Descriptor() ([]byte, []int) { return fileDescriptorRoute, []int{8} }

func (m *Decorator) GetOperation() string {
	if m != nil {
		return m.Operation
	}
	return ""
}

// A virtual cluster is a way of specifying a regex matching rule against
// certain important endpoints such that statistics are generated explicitly for
// the matched requests. The reason this is useful is that when doing
// prefix/path matching Envoy does not always know what the application
// considers to be an endpoint. Thus, it’s impossible for Envoy to generically
// emit per endpoint statistics. However, often systems have highly critical
// endpoints that they wish to get “perfect” statistics on. Virtual cluster
// statistics are perfect in the sense that they are emitted on the downstream
// side such that they include network level failures.
//
// Documentation for :ref:`virtual cluster statistics <config_http_filters_router_stats>`.
//
// .. note::
//
//    Virtual clusters are a useful tool, but we do not recommend setting up a virtual cluster for
//    every application endpoint. This is both not easily maintainable and as well the matching and
//    statistics output are not free.
type VirtualCluster struct {
	// Specifies a regex pattern to use for matching requests. The entire path of the request
	// must match the regex. The regex grammar used is defined `here
	// <http://en.cppreference.com/w/cpp/regex/ecmascript>`_.
	//
	// Examples:
	//
	// * The regex */rides/\d+* matches the path */rides/0*
	// * The regex */rides/\d+* matches the path */rides/123*
	// * The regex */rides/\d+* does not match the path */rides/123/456*
	Pattern string `protobuf:"bytes,1,opt,name=pattern,proto3" json:"pattern,omitempty"`
	//  Specifies the name of the virtual cluster. The virtual cluster name as well
	// as the virtual host name are used when emitting statistics. The statistics are emitted by the
	// router filter and are documented :ref:`here <config_http_filters_router_stats>`.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Optionally specifies the HTTP method to match on. For example GET, PUT,
	// etc.
	// [#comment:TODO(htuch): add (validate.rules).enum.defined_only = true once
	// https://github.com/lyft/protoc-gen-validate/issues/42 is resolved.]
	Method envoy_api_v2_core.RequestMethod `protobuf:"varint,3,opt,name=method,proto3,enum=envoy.api.v2.core.RequestMethod" json:"method,omitempty"`
}

func (m *VirtualCluster) Reset()                    { *m = VirtualCluster{} }
func (m *VirtualCluster) String() string            { return proto.CompactTextString(m) }
func (*VirtualCluster) ProtoMessage()               {}
func (*VirtualCluster) Descriptor() ([]byte, []int) { return fileDescriptorRoute, []int{9} }

func (m *VirtualCluster) GetPattern() string {
	if m != nil {
		return m.Pattern
	}
	return ""
}

func (m *VirtualCluster) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *VirtualCluster) GetMethod() envoy_api_v2_core.RequestMethod {
	if m != nil {
		return m.Method
	}
	return envoy_api_v2_core.METHOD_UNSPECIFIED
}

// Global rate limiting :ref:`architecture overview <arch_overview_rate_limit>`.
type RateLimit struct {
	// Refers to the stage set in the filter. The rate limit configuration only
	// applies to filters with the same stage number. The default stage number is
	// 0.
	//
	// .. note::
	//
	//   The filter supports a range of 0 - 10 inclusively for stage numbers.
	Stage *google_protobuf1.UInt32Value `protobuf:"bytes,1,opt,name=stage" json:"stage,omitempty"`
	// The key to be set in runtime to disable this rate limit configuration.
	DisableKey string `protobuf:"bytes,2,opt,name=disable_key,json=disableKey,proto3" json:"disable_key,omitempty"`
	// A list of actions that are to be applied for this rate limit configuration.
	// Order matters as the actions are processed sequentially and the descriptor
	// is composed by appending descriptor entries in that sequence. If an action
	// cannot append a descriptor entry, no descriptor is generated for the
	// configuration. See :ref:`composing actions
	// <config_http_filters_rate_limit_composing_actions>` for additional documentation.
	Actions []*RateLimit_Action `protobuf:"bytes,3,rep,name=actions" json:"actions,omitempty"`
}

func (m *RateLimit) Reset()                    { *m = RateLimit{} }
func (m *RateLimit) String() string            { return proto.CompactTextString(m) }
func (*RateLimit) ProtoMessage()               {}
func (*RateLimit) Descriptor() ([]byte, []int) { return fileDescriptorRoute, []int{10} }

func (m *RateLimit) GetStage() *google_protobuf1.UInt32Value {
	if m != nil {
		return m.Stage
	}
	return nil
}

func (m *RateLimit) GetDisableKey() string {
	if m != nil {
		return m.DisableKey
	}
	return ""
}

func (m *RateLimit) GetActions() []*RateLimit_Action {
	if m != nil {
		return m.Actions
	}
	return nil
}

type RateLimit_Action struct {
	// Types that are valid to be assigned to ActionSpecifier:
	//	*RateLimit_Action_SourceCluster_
	//	*RateLimit_Action_DestinationCluster_
	//	*RateLimit_Action_RequestHeaders_
	//	*RateLimit_Action_RemoteAddress_
	//	*RateLimit_Action_GenericKey_
	//	*RateLimit_Action_HeaderValueMatch_
	ActionSpecifier isRateLimit_Action_ActionSpecifier `protobuf_oneof:"action_specifier"`
}

func (m *RateLimit_Action) Reset()                    { *m = RateLimit_Action{} }
func (m *RateLimit_Action) String() string            { return proto.CompactTextString(m) }
func (*RateLimit_Action) ProtoMessage()               {}
func (*RateLimit_Action) Descriptor() ([]byte, []int) { return fileDescriptorRoute, []int{10, 0} }

type isRateLimit_Action_ActionSpecifier interface {
	isRateLimit_Action_ActionSpecifier()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type RateLimit_Action_SourceCluster_ struct {
	SourceCluster *RateLimit_Action_SourceCluster `protobuf:"bytes,1,opt,name=source_cluster,json=sourceCluster,oneof"`
}
type RateLimit_Action_DestinationCluster_ struct {
	DestinationCluster *RateLimit_Action_DestinationCluster `protobuf:"bytes,2,opt,name=destination_cluster,json=destinationCluster,oneof"`
}
type RateLimit_Action_RequestHeaders_ struct {
	RequestHeaders *RateLimit_Action_RequestHeaders `protobuf:"bytes,3,opt,name=request_headers,json=requestHeaders,oneof"`
}
type RateLimit_Action_RemoteAddress_ struct {
	RemoteAddress *RateLimit_Action_RemoteAddress `protobuf:"bytes,4,opt,name=remote_address,json=remoteAddress,oneof"`
}
type RateLimit_Action_GenericKey_ struct {
	GenericKey *RateLimit_Action_GenericKey `protobuf:"bytes,5,opt,name=generic_key,json=genericKey,oneof"`
}
type RateLimit_Action_HeaderValueMatch_ struct {
	HeaderValueMatch *RateLimit_Action_HeaderValueMatch `protobuf:"bytes,6,opt,name=header_value_match,json=headerValueMatch,oneof"`
}

func (*RateLimit_Action_SourceCluster_) isRateLimit_Action_ActionSpecifier()      {}
func (*RateLimit_Action_DestinationCluster_) isRateLimit_Action_ActionSpecifier() {}
func (*RateLimit_Action_RequestHeaders_) isRateLimit_Action_ActionSpecifier()     {}
func (*RateLimit_Action_RemoteAddress_) isRateLimit_Action_ActionSpecifier()      {}
func (*RateLimit_Action_GenericKey_) isRateLimit_Action_ActionSpecifier()         {}
func (*RateLimit_Action_HeaderValueMatch_) isRateLimit_Action_ActionSpecifier()   {}

func (m *RateLimit_Action) GetActionSpecifier() isRateLimit_Action_ActionSpecifier {
	if m != nil {
		return m.ActionSpecifier
	}
	return nil
}

func (m *RateLimit_Action) GetSourceCluster() *RateLimit_Action_SourceCluster {
	if x, ok := m.GetActionSpecifier().(*RateLimit_Action_SourceCluster_); ok {
		return x.SourceCluster
	}
	return nil
}

func (m *RateLimit_Action) GetDestinationCluster() *RateLimit_Action_DestinationCluster {
	if x, ok := m.GetActionSpecifier().(*RateLimit_Action_DestinationCluster_); ok {
		return x.DestinationCluster
	}
	return nil
}

func (m *RateLimit_Action) GetRequestHeaders() *RateLimit_Action_RequestHeaders {
	if x, ok := m.GetActionSpecifier().(*RateLimit_Action_RequestHeaders_); ok {
		return x.RequestHeaders
	}
	return nil
}

func (m *RateLimit_Action) GetRemoteAddress() *RateLimit_Action_RemoteAddress {
	if x, ok := m.GetActionSpecifier().(*RateLimit_Action_RemoteAddress_); ok {
		return x.RemoteAddress
	}
	return nil
}

func (m *RateLimit_Action) GetGenericKey() *RateLimit_Action_GenericKey {
	if x, ok := m.GetActionSpecifier().(*RateLimit_Action_GenericKey_); ok {
		return x.GenericKey
	}
	return nil
}

func (m *RateLimit_Action) GetHeaderValueMatch() *RateLimit_Action_HeaderValueMatch {
	if x, ok := m.GetActionSpecifier().(*RateLimit_Action_HeaderValueMatch_); ok {
		return x.HeaderValueMatch
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*RateLimit_Action) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _RateLimit_Action_OneofMarshaler, _RateLimit_Action_OneofUnmarshaler, _RateLimit_Action_OneofSizer, []interface{}{
		(*RateLimit_Action_SourceCluster_)(nil),
		(*RateLimit_Action_DestinationCluster_)(nil),
		(*RateLimit_Action_RequestHeaders_)(nil),
		(*RateLimit_Action_RemoteAddress_)(nil),
		(*RateLimit_Action_GenericKey_)(nil),
		(*RateLimit_Action_HeaderValueMatch_)(nil),
	}
}

func _RateLimit_Action_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*RateLimit_Action)
	// action_specifier
	switch x := m.ActionSpecifier.(type) {
	case *RateLimit_Action_SourceCluster_:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SourceCluster); err != nil {
			return err
		}
	case *RateLimit_Action_DestinationCluster_:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DestinationCluster); err != nil {
			return err
		}
	case *RateLimit_Action_RequestHeaders_:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RequestHeaders); err != nil {
			return err
		}
	case *RateLimit_Action_RemoteAddress_:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RemoteAddress); err != nil {
			return err
		}
	case *RateLimit_Action_GenericKey_:
		_ = b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.GenericKey); err != nil {
			return err
		}
	case *RateLimit_Action_HeaderValueMatch_:
		_ = b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HeaderValueMatch); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("RateLimit_Action.ActionSpecifier has unexpected type %T", x)
	}
	return nil
}

func _RateLimit_Action_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*RateLimit_Action)
	switch tag {
	case 1: // action_specifier.source_cluster
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RateLimit_Action_SourceCluster)
		err := b.DecodeMessage(msg)
		m.ActionSpecifier = &RateLimit_Action_SourceCluster_{msg}
		return true, err
	case 2: // action_specifier.destination_cluster
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RateLimit_Action_DestinationCluster)
		err := b.DecodeMessage(msg)
		m.ActionSpecifier = &RateLimit_Action_DestinationCluster_{msg}
		return true, err
	case 3: // action_specifier.request_headers
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RateLimit_Action_RequestHeaders)
		err := b.DecodeMessage(msg)
		m.ActionSpecifier = &RateLimit_Action_RequestHeaders_{msg}
		return true, err
	case 4: // action_specifier.remote_address
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RateLimit_Action_RemoteAddress)
		err := b.DecodeMessage(msg)
		m.ActionSpecifier = &RateLimit_Action_RemoteAddress_{msg}
		return true, err
	case 5: // action_specifier.generic_key
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RateLimit_Action_GenericKey)
		err := b.DecodeMessage(msg)
		m.ActionSpecifier = &RateLimit_Action_GenericKey_{msg}
		return true, err
	case 6: // action_specifier.header_value_match
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RateLimit_Action_HeaderValueMatch)
		err := b.DecodeMessage(msg)
		m.ActionSpecifier = &RateLimit_Action_HeaderValueMatch_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _RateLimit_Action_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*RateLimit_Action)
	// action_specifier
	switch x := m.ActionSpecifier.(type) {
	case *RateLimit_Action_SourceCluster_:
		s := proto.Size(x.SourceCluster)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RateLimit_Action_DestinationCluster_:
		s := proto.Size(x.DestinationCluster)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RateLimit_Action_RequestHeaders_:
		s := proto.Size(x.RequestHeaders)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RateLimit_Action_RemoteAddress_:
		s := proto.Size(x.RemoteAddress)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RateLimit_Action_GenericKey_:
		s := proto.Size(x.GenericKey)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RateLimit_Action_HeaderValueMatch_:
		s := proto.Size(x.HeaderValueMatch)
		n += proto.SizeVarint(6<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The following descriptor entry is appended to the descriptor:
//
// .. code-block:: cpp
//
//   ("source_cluster", "<local service cluster>")
//
// <local service cluster> is derived from the :option:`--service-cluster` option.
type RateLimit_Action_SourceCluster struct {
}

func (m *RateLimit_Action_SourceCluster) Reset()         { *m = RateLimit_Action_SourceCluster{} }
func (m *RateLimit_Action_SourceCluster) String() string { return proto.CompactTextString(m) }
func (*RateLimit_Action_SourceCluster) ProtoMessage()    {}
func (*RateLimit_Action_SourceCluster) Descriptor() ([]byte, []int) {
	return fileDescriptorRoute, []int{10, 0, 0}
}

// The following descriptor entry is appended to the descriptor:
//
// .. code-block:: cpp
//
//   ("destination_cluster", "<routed target cluster>")
//
// Once a request matches against a route table rule, a routed cluster is determined by one of
// the following :ref:`route table configuration <envoy_api_msg_RouteConfiguration>`
// settings:
//
// * :ref:`cluster <envoy_api_field_route.RouteAction.cluster>` indicates the upstream cluster
//   to route to.
// * :ref:`weighted_clusters <envoy_api_field_route.RouteAction.weighted_clusters>`
//   chooses a cluster randomly from a set of clusters with attributed weight.
// * :ref:`cluster_header <envoy_api_field_route.RouteAction.cluster_header>` indicates which
//   header in the request contains the target cluster.
type RateLimit_Action_DestinationCluster struct {
}

func (m *RateLimit_Action_DestinationCluster) Reset()         { *m = RateLimit_Action_DestinationCluster{} }
func (m *RateLimit_Action_DestinationCluster) String() string { return proto.CompactTextString(m) }
func (*RateLimit_Action_DestinationCluster) ProtoMessage()    {}
func (*RateLimit_Action_DestinationCluster) Descriptor() ([]byte, []int) {
	return fileDescriptorRoute, []int{10, 0, 1}
}

// The following descriptor entry is appended when a header contains a key that matches the
// *header_name*:
//
// .. code-block:: cpp
//
//   ("<descriptor_key>", "<header_value_queried_from_header>")
type RateLimit_Action_RequestHeaders struct {
	// The header name to be queried from the request headers. The header’s
	// value is used to populate the value of the descriptor entry for the
	// descriptor_key.
	HeaderName string `protobuf:"bytes,1,opt,name=header_name,json=headerName,proto3" json:"header_name,omitempty"`
	// The key to use in the descriptor entry.
	DescriptorKey string `protobuf:"bytes,2,opt,name=descriptor_key,json=descriptorKey,proto3" json:"descriptor_key,omitempty"`
}

func (m *RateLimit_Action_RequestHeaders) Reset()         { *m = RateLimit_Action_RequestHeaders{} }
func (m *RateLimit_Action_RequestHeaders) String() string { return proto.CompactTextString(m) }
func (*RateLimit_Action_RequestHeaders) ProtoMessage()    {}
func (*RateLimit_Action_RequestHeaders) Descriptor() ([]byte, []int) {
	return fileDescriptorRoute, []int{10, 0, 2}
}

func (m *RateLimit_Action_RequestHeaders) GetHeaderName() string {
	if m != nil {
		return m.HeaderName
	}
	return ""
}

func (m *RateLimit_Action_RequestHeaders) GetDescriptorKey() string {
	if m != nil {
		return m.DescriptorKey
	}
	return ""
}

// The following descriptor entry is appended to the descriptor and is populated using the
// trusted address from :ref:`x-forwarded-for <config_http_conn_man_headers_x-forwarded-for>`:
//
// .. code-block:: cpp
//
//   ("remote_address", "<trusted address from x-forwarded-for>")
type RateLimit_Action_RemoteAddress struct {
}

func (m *RateLimit_Action_RemoteAddress) Reset()         { *m = RateLimit_Action_RemoteAddress{} }
func (m *RateLimit_Action_RemoteAddress) String() string { return proto.CompactTextString(m) }
func (*RateLimit_Action_RemoteAddress) ProtoMessage()    {}
func (*RateLimit_Action_RemoteAddress) Descriptor() ([]byte, []int) {
	return fileDescriptorRoute, []int{10, 0, 3}
}

// The following descriptor entry is appended to the descriptor:
//
// .. code-block:: cpp
//
//   ("generic_key", "<descriptor_value>")
type RateLimit_Action_GenericKey struct {
	// The value to use in the descriptor entry.
	DescriptorValue string `protobuf:"bytes,1,opt,name=descriptor_value,json=descriptorValue,proto3" json:"descriptor_value,omitempty"`
}

func (m *RateLimit_Action_GenericKey) Reset()         { *m = RateLimit_Action_GenericKey{} }
func (m *RateLimit_Action_GenericKey) String() string { return proto.CompactTextString(m) }
func (*RateLimit_Action_GenericKey) ProtoMessage()    {}
func (*RateLimit_Action_GenericKey) Descriptor() ([]byte, []int) {
	return fileDescriptorRoute, []int{10, 0, 4}
}

func (m *RateLimit_Action_GenericKey) GetDescriptorValue() string {
	if m != nil {
		return m.DescriptorValue
	}
	return ""
}

// The following descriptor entry is appended to the descriptor:
//
// .. code-block:: cpp
//
//   ("header_match", "<descriptor_value>")
type RateLimit_Action_HeaderValueMatch struct {
	// The value to use in the descriptor entry.
	DescriptorValue string `protobuf:"bytes,1,opt,name=descriptor_value,json=descriptorValue,proto3" json:"descriptor_value,omitempty"`
	// If set to true, the action will append a descriptor entry when the
	// request matches the headers. If set to false, the action will append a
	// descriptor entry when the request does not match the headers. The
	// default value is true.
	ExpectMatch *google_protobuf1.BoolValue `protobuf:"bytes,2,opt,name=expect_match,json=expectMatch" json:"expect_match,omitempty"`
	// Specifies a set of headers that the rate limit action should match
	// on. The action will check the request’s headers against all the
	// specified headers in the config. A match will happen if all the
	// headers in the config are present in the request with the same values
	// (or based on presence if the value field is not in the config).
	Headers []*HeaderMatcher `protobuf:"bytes,3,rep,name=headers" json:"headers,omitempty"`
}

func (m *RateLimit_Action_HeaderValueMatch) Reset()         { *m = RateLimit_Action_HeaderValueMatch{} }
func (m *RateLimit_Action_HeaderValueMatch) String() string { return proto.CompactTextString(m) }
func (*RateLimit_Action_HeaderValueMatch) ProtoMessage()    {}
func (*RateLimit_Action_HeaderValueMatch) Descriptor() ([]byte, []int) {
	return fileDescriptorRoute, []int{10, 0, 5}
}

func (m *RateLimit_Action_HeaderValueMatch) GetDescriptorValue() string {
	if m != nil {
		return m.DescriptorValue
	}
	return ""
}

func (m *RateLimit_Action_HeaderValueMatch) GetExpectMatch() *google_protobuf1.BoolValue {
	if m != nil {
		return m.ExpectMatch
	}
	return nil
}

func (m *RateLimit_Action_HeaderValueMatch) GetHeaders() []*HeaderMatcher {
	if m != nil {
		return m.Headers
	}
	return nil
}

// .. attention::
//
//   Internally, Envoy always uses the HTTP/2 *:authority* header to represent the HTTP/1 *Host*
//   header. Thus, if attempting to match on *Host*, match on *:authority* instead.
//
// .. attention::
//
//   To route on HTTP method, use the special HTTP/2 *:method* header. This works for both
//   HTTP/1 and HTTP/2 as Envoy normalizes headers. E.g.,
//
//   .. code-block:: json
//
//     {
//       "name": ":method",
//       "value": "POST"
//     }
type HeaderMatcher struct {
	// Specifies the name of the header in the request.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Specifies the value of the header. If the value is absent a request that
	// has the name header will match, regardless of the header’s value.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// Specifies whether the header value is a regular
	// expression or not. Defaults to false. The entire request header value must match the regex. The
	// rule will not match if only a subsequence of the request header value matches the regex. The
	// regex grammar used in the value field is defined
	// `here <http://en.cppreference.com/w/cpp/regex/ecmascript>`_.
	//
	// Examples:
	//
	// * The regex *\d{3}* matches the value *123*
	// * The regex *\d{3}* does not match the value *1234*
	// * The regex *\d{3}* does not match the value *123.456*
	Regex *google_protobuf1.BoolValue `protobuf:"bytes,3,opt,name=regex" json:"regex,omitempty"`
	// Specifies how the header match will be performed to route the request.
	// If header_match_specifier is absent, a request that has the
	// :ref:`envoy_api_msg_route.HeaderMatcher.name` header will match, regardless of the header's
	// value.
	//
	// Types that are valid to be assigned to HeaderMatchSpecifier:
	//	*HeaderMatcher_ExactMatch
	//	*HeaderMatcher_RegexMatch
	//	*HeaderMatcher_RangeMatch
	HeaderMatchSpecifier isHeaderMatcher_HeaderMatchSpecifier `protobuf_oneof:"header_match_specifier"`
}

func (m *HeaderMatcher) Reset()                    { *m = HeaderMatcher{} }
func (m *HeaderMatcher) String() string            { return proto.CompactTextString(m) }
func (*HeaderMatcher) ProtoMessage()               {}
func (*HeaderMatcher) Descriptor() ([]byte, []int) { return fileDescriptorRoute, []int{11} }

type isHeaderMatcher_HeaderMatchSpecifier interface {
	isHeaderMatcher_HeaderMatchSpecifier()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type HeaderMatcher_ExactMatch struct {
	ExactMatch string `protobuf:"bytes,4,opt,name=exact_match,json=exactMatch,proto3,oneof"`
}
type HeaderMatcher_RegexMatch struct {
	RegexMatch string `protobuf:"bytes,5,opt,name=regex_match,json=regexMatch,proto3,oneof"`
}
type HeaderMatcher_RangeMatch struct {
	RangeMatch *envoy_type.Int64Range `protobuf:"bytes,6,opt,name=range_match,json=rangeMatch,oneof"`
}

func (*HeaderMatcher_ExactMatch) isHeaderMatcher_HeaderMatchSpecifier() {}
func (*HeaderMatcher_RegexMatch) isHeaderMatcher_HeaderMatchSpecifier() {}
func (*HeaderMatcher_RangeMatch) isHeaderMatcher_HeaderMatchSpecifier() {}

func (m *HeaderMatcher) GetHeaderMatchSpecifier() isHeaderMatcher_HeaderMatchSpecifier {
	if m != nil {
		return m.HeaderMatchSpecifier
	}
	return nil
}

func (m *HeaderMatcher) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *HeaderMatcher) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *HeaderMatcher) GetRegex() *google_protobuf1.BoolValue {
	if m != nil {
		return m.Regex
	}
	return nil
}

func (m *HeaderMatcher) GetExactMatch() string {
	if x, ok := m.GetHeaderMatchSpecifier().(*HeaderMatcher_ExactMatch); ok {
		return x.ExactMatch
	}
	return ""
}

func (m *HeaderMatcher) GetRegexMatch() string {
	if x, ok := m.GetHeaderMatchSpecifier().(*HeaderMatcher_RegexMatch); ok {
		return x.RegexMatch
	}
	return ""
}

func (m *HeaderMatcher) GetRangeMatch() *envoy_type.Int64Range {
	if x, ok := m.GetHeaderMatchSpecifier().(*HeaderMatcher_RangeMatch); ok {
		return x.RangeMatch
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*HeaderMatcher) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _HeaderMatcher_OneofMarshaler, _HeaderMatcher_OneofUnmarshaler, _HeaderMatcher_OneofSizer, []interface{}{
		(*HeaderMatcher_ExactMatch)(nil),
		(*HeaderMatcher_RegexMatch)(nil),
		(*HeaderMatcher_RangeMatch)(nil),
	}
}

func _HeaderMatcher_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*HeaderMatcher)
	// header_match_specifier
	switch x := m.HeaderMatchSpecifier.(type) {
	case *HeaderMatcher_ExactMatch:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.ExactMatch)
	case *HeaderMatcher_RegexMatch:
		_ = b.EncodeVarint(5<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.RegexMatch)
	case *HeaderMatcher_RangeMatch:
		_ = b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RangeMatch); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("HeaderMatcher.HeaderMatchSpecifier has unexpected type %T", x)
	}
	return nil
}

func _HeaderMatcher_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*HeaderMatcher)
	switch tag {
	case 4: // header_match_specifier.exact_match
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.HeaderMatchSpecifier = &HeaderMatcher_ExactMatch{x}
		return true, err
	case 5: // header_match_specifier.regex_match
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.HeaderMatchSpecifier = &HeaderMatcher_RegexMatch{x}
		return true, err
	case 6: // header_match_specifier.range_match
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(envoy_type.Int64Range)
		err := b.DecodeMessage(msg)
		m.HeaderMatchSpecifier = &HeaderMatcher_RangeMatch{msg}
		return true, err
	default:
		return false, nil
	}
}

func _HeaderMatcher_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*HeaderMatcher)
	// header_match_specifier
	switch x := m.HeaderMatchSpecifier.(type) {
	case *HeaderMatcher_ExactMatch:
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.ExactMatch)))
		n += len(x.ExactMatch)
	case *HeaderMatcher_RegexMatch:
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.RegexMatch)))
		n += len(x.RegexMatch)
	case *HeaderMatcher_RangeMatch:
		s := proto.Size(x.RangeMatch)
		n += proto.SizeVarint(6<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Query parameter matching treats the query string of a request's :path header
// as an ampersand-separated list of keys and/or key=value elements.
type QueryParameterMatcher struct {
	// Specifies the name of a key that must be present in the requested
	// *path*'s query string.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Specifies the value of the key. If the value is absent, a request
	// that contains the key in its query string will match, whether the
	// key appears with a value (e.g., "?debug=true") or not (e.g., "?debug")
	Value string `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
	// Specifies whether the query parameter value is a regular expression.
	// Defaults to false. The entire query parameter value (i.e., the part to
	// the right of the equals sign in "key=value") must match the regex.
	// E.g., the regex "\d+$" will match "123" but not "a123" or "123a".
	Regex *google_protobuf1.BoolValue `protobuf:"bytes,4,opt,name=regex" json:"regex,omitempty"`
}

func (m *QueryParameterMatcher) Reset()                    { *m = QueryParameterMatcher{} }
func (m *QueryParameterMatcher) String() string            { return proto.CompactTextString(m) }
func (*QueryParameterMatcher) ProtoMessage()               {}
func (*QueryParameterMatcher) Descriptor() ([]byte, []int) { return fileDescriptorRoute, []int{12} }

func (m *QueryParameterMatcher) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *QueryParameterMatcher) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *QueryParameterMatcher) GetRegex() *google_protobuf1.BoolValue {
	if m != nil {
		return m.Regex
	}
	return nil
}

func init() {
	proto.RegisterType((*VirtualHost)(nil), "envoy.api.v2.route.VirtualHost")
	proto.RegisterType((*Route)(nil), "envoy.api.v2.route.Route")
	proto.RegisterType((*WeightedCluster)(nil), "envoy.api.v2.route.WeightedCluster")
	proto.RegisterType((*WeightedCluster_ClusterWeight)(nil), "envoy.api.v2.route.WeightedCluster.ClusterWeight")
	proto.RegisterType((*RouteMatch)(nil), "envoy.api.v2.route.RouteMatch")
	proto.RegisterType((*CorsPolicy)(nil), "envoy.api.v2.route.CorsPolicy")
	proto.RegisterType((*RouteAction)(nil), "envoy.api.v2.route.RouteAction")
	proto.RegisterType((*RouteAction_RetryPolicy)(nil), "envoy.api.v2.route.RouteAction.RetryPolicy")
	proto.RegisterType((*RouteAction_RequestMirrorPolicy)(nil), "envoy.api.v2.route.RouteAction.RequestMirrorPolicy")
	proto.RegisterType((*RouteAction_HashPolicy)(nil), "envoy.api.v2.route.RouteAction.HashPolicy")
	proto.RegisterType((*RouteAction_HashPolicy_Header)(nil), "envoy.api.v2.route.RouteAction.HashPolicy.Header")
	proto.RegisterType((*RouteAction_HashPolicy_Cookie)(nil), "envoy.api.v2.route.RouteAction.HashPolicy.Cookie")
	proto.RegisterType((*RouteAction_HashPolicy_ConnectionProperties)(nil), "envoy.api.v2.route.RouteAction.HashPolicy.ConnectionProperties")
	proto.RegisterType((*RedirectAction)(nil), "envoy.api.v2.route.RedirectAction")
	proto.RegisterType((*DirectResponseAction)(nil), "envoy.api.v2.route.DirectResponseAction")
	proto.RegisterType((*Decorator)(nil), "envoy.api.v2.route.Decorator")
	proto.RegisterType((*VirtualCluster)(nil), "envoy.api.v2.route.VirtualCluster")
	proto.RegisterType((*RateLimit)(nil), "envoy.api.v2.route.RateLimit")
	proto.RegisterType((*RateLimit_Action)(nil), "envoy.api.v2.route.RateLimit.Action")
	proto.RegisterType((*RateLimit_Action_SourceCluster)(nil), "envoy.api.v2.route.RateLimit.Action.SourceCluster")
	proto.RegisterType((*RateLimit_Action_DestinationCluster)(nil), "envoy.api.v2.route.RateLimit.Action.DestinationCluster")
	proto.RegisterType((*RateLimit_Action_RequestHeaders)(nil), "envoy.api.v2.route.RateLimit.Action.RequestHeaders")
	proto.RegisterType((*RateLimit_Action_RemoteAddress)(nil), "envoy.api.v2.route.RateLimit.Action.RemoteAddress")
	proto.RegisterType((*RateLimit_Action_GenericKey)(nil), "envoy.api.v2.route.RateLimit.Action.GenericKey")
	proto.RegisterType((*RateLimit_Action_HeaderValueMatch)(nil), "envoy.api.v2.route.RateLimit.Action.HeaderValueMatch")
	proto.RegisterType((*HeaderMatcher)(nil), "envoy.api.v2.route.HeaderMatcher")
	proto.RegisterType((*QueryParameterMatcher)(nil), "envoy.api.v2.route.QueryParameterMatcher")
	proto.RegisterEnum("envoy.api.v2.route.VirtualHost_TlsRequirementType", VirtualHost_TlsRequirementType_name, VirtualHost_TlsRequirementType_value)
	proto.RegisterEnum("envoy.api.v2.route.RouteAction_ClusterNotFoundResponseCode", RouteAction_ClusterNotFoundResponseCode_name, RouteAction_ClusterNotFoundResponseCode_value)
	proto.RegisterEnum("envoy.api.v2.route.RedirectAction_RedirectResponseCode", RedirectAction_RedirectResponseCode_name, RedirectAction_RedirectResponseCode_value)
}
func (this *VirtualHost) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*VirtualHost)
	if !ok {
		that2, ok := that.(VirtualHost)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if len(this.Domains) != len(that1.Domains) {
		return false
	}
	for i := range this.Domains {
		if this.Domains[i] != that1.Domains[i] {
			return false
		}
	}
	if len(this.Routes) != len(that1.Routes) {
		return false
	}
	for i := range this.Routes {
		if !this.Routes[i].Equal(&that1.Routes[i]) {
			return false
		}
	}
	if this.RequireTls != that1.RequireTls {
		return false
	}
	if len(this.VirtualClusters) != len(that1.VirtualClusters) {
		return false
	}
	for i := range this.VirtualClusters {
		if !this.VirtualClusters[i].Equal(that1.VirtualClusters[i]) {
			return false
		}
	}
	if len(this.RateLimits) != len(that1.RateLimits) {
		return false
	}
	for i := range this.RateLimits {
		if !this.RateLimits[i].Equal(that1.RateLimits[i]) {
			return false
		}
	}
	if len(this.RequestHeadersToAdd) != len(that1.RequestHeadersToAdd) {
		return false
	}
	for i := range this.RequestHeadersToAdd {
		if !this.RequestHeadersToAdd[i].Equal(that1.RequestHeadersToAdd[i]) {
			return false
		}
	}
	if len(this.ResponseHeadersToAdd) != len(that1.ResponseHeadersToAdd) {
		return false
	}
	for i := range this.ResponseHeadersToAdd {
		if !this.ResponseHeadersToAdd[i].Equal(that1.ResponseHeadersToAdd[i]) {
			return false
		}
	}
	if len(this.ResponseHeadersToRemove) != len(that1.ResponseHeadersToRemove) {
		return false
	}
	for i := range this.ResponseHeadersToRemove {
		if this.ResponseHeadersToRemove[i] != that1.ResponseHeadersToRemove[i] {
			return false
		}
	}
	if !this.Cors.Equal(that1.Cors) {
		return false
	}
	if !this.Auth.Equal(that1.Auth) {
		return false
	}
	if len(this.PerFilterConfig) != len(that1.PerFilterConfig) {
		return false
	}
	for i := range this.PerFilterConfig {
		if !this.PerFilterConfig[i].Equal(that1.PerFilterConfig[i]) {
			return false
		}
	}
	return true
}
func (this *Route) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Route)
	if !ok {
		that2, ok := that.(Route)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Match.Equal(&that1.Match) {
		return false
	}
	if that1.Action == nil {
		if this.Action != nil {
			return false
		}
	} else if this.Action == nil {
		return false
	} else if !this.Action.Equal(that1.Action) {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if !this.Decorator.Equal(that1.Decorator) {
		return false
	}
	if !this.Auth.Equal(that1.Auth) {
		return false
	}
	if len(this.PerFilterConfig) != len(that1.PerFilterConfig) {
		return false
	}
	for i := range this.PerFilterConfig {
		if !this.PerFilterConfig[i].Equal(that1.PerFilterConfig[i]) {
			return false
		}
	}
	return true
}
func (this *Route_Route) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Route_Route)
	if !ok {
		that2, ok := that.(Route_Route)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Route.Equal(that1.Route) {
		return false
	}
	return true
}
func (this *Route_Redirect) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Route_Redirect)
	if !ok {
		that2, ok := that.(Route_Redirect)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Redirect.Equal(that1.Redirect) {
		return false
	}
	return true
}
func (this *Route_DirectResponse) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Route_DirectResponse)
	if !ok {
		that2, ok := that.(Route_DirectResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.DirectResponse.Equal(that1.DirectResponse) {
		return false
	}
	return true
}
func (this *WeightedCluster) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*WeightedCluster)
	if !ok {
		that2, ok := that.(WeightedCluster)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Clusters) != len(that1.Clusters) {
		return false
	}
	for i := range this.Clusters {
		if !this.Clusters[i].Equal(that1.Clusters[i]) {
			return false
		}
	}
	if !this.TotalWeight.Equal(that1.TotalWeight) {
		return false
	}
	if this.RuntimeKeyPrefix != that1.RuntimeKeyPrefix {
		return false
	}
	return true
}
func (this *WeightedCluster_ClusterWeight) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*WeightedCluster_ClusterWeight)
	if !ok {
		that2, ok := that.(WeightedCluster_ClusterWeight)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if !this.Weight.Equal(that1.Weight) {
		return false
	}
	if !this.MetadataMatch.Equal(that1.MetadataMatch) {
		return false
	}
	if len(this.RequestHeadersToAdd) != len(that1.RequestHeadersToAdd) {
		return false
	}
	for i := range this.RequestHeadersToAdd {
		if !this.RequestHeadersToAdd[i].Equal(that1.RequestHeadersToAdd[i]) {
			return false
		}
	}
	if len(this.ResponseHeadersToAdd) != len(that1.ResponseHeadersToAdd) {
		return false
	}
	for i := range this.ResponseHeadersToAdd {
		if !this.ResponseHeadersToAdd[i].Equal(that1.ResponseHeadersToAdd[i]) {
			return false
		}
	}
	if len(this.ResponseHeadersToRemove) != len(that1.ResponseHeadersToRemove) {
		return false
	}
	for i := range this.ResponseHeadersToRemove {
		if this.ResponseHeadersToRemove[i] != that1.ResponseHeadersToRemove[i] {
			return false
		}
	}
	if len(this.PerFilterConfig) != len(that1.PerFilterConfig) {
		return false
	}
	for i := range this.PerFilterConfig {
		if !this.PerFilterConfig[i].Equal(that1.PerFilterConfig[i]) {
			return false
		}
	}
	return true
}
func (this *RouteMatch) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RouteMatch)
	if !ok {
		that2, ok := that.(RouteMatch)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if that1.PathSpecifier == nil {
		if this.PathSpecifier != nil {
			return false
		}
	} else if this.PathSpecifier == nil {
		return false
	} else if !this.PathSpecifier.Equal(that1.PathSpecifier) {
		return false
	}
	if !this.CaseSensitive.Equal(that1.CaseSensitive) {
		return false
	}
	if !this.Runtime.Equal(that1.Runtime) {
		return false
	}
	if len(this.Headers) != len(that1.Headers) {
		return false
	}
	for i := range this.Headers {
		if !this.Headers[i].Equal(that1.Headers[i]) {
			return false
		}
	}
	if len(this.QueryParameters) != len(that1.QueryParameters) {
		return false
	}
	for i := range this.QueryParameters {
		if !this.QueryParameters[i].Equal(that1.QueryParameters[i]) {
			return false
		}
	}
	return true
}
func (this *RouteMatch_Prefix) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RouteMatch_Prefix)
	if !ok {
		that2, ok := that.(RouteMatch_Prefix)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Prefix != that1.Prefix {
		return false
	}
	return true
}
func (this *RouteMatch_Path) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RouteMatch_Path)
	if !ok {
		that2, ok := that.(RouteMatch_Path)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	return true
}
func (this *RouteMatch_Regex) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RouteMatch_Regex)
	if !ok {
		that2, ok := that.(RouteMatch_Regex)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Regex != that1.Regex {
		return false
	}
	return true
}
func (this *CorsPolicy) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*CorsPolicy)
	if !ok {
		that2, ok := that.(CorsPolicy)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.AllowOrigin) != len(that1.AllowOrigin) {
		return false
	}
	for i := range this.AllowOrigin {
		if this.AllowOrigin[i] != that1.AllowOrigin[i] {
			return false
		}
	}
	if this.AllowMethods != that1.AllowMethods {
		return false
	}
	if this.AllowHeaders != that1.AllowHeaders {
		return false
	}
	if this.ExposeHeaders != that1.ExposeHeaders {
		return false
	}
	if this.MaxAge != that1.MaxAge {
		return false
	}
	if !this.AllowCredentials.Equal(that1.AllowCredentials) {
		return false
	}
	if !this.Enabled.Equal(that1.Enabled) {
		return false
	}
	return true
}
func (this *RouteAction) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RouteAction)
	if !ok {
		that2, ok := that.(RouteAction)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if that1.ClusterSpecifier == nil {
		if this.ClusterSpecifier != nil {
			return false
		}
	} else if this.ClusterSpecifier == nil {
		return false
	} else if !this.ClusterSpecifier.Equal(that1.ClusterSpecifier) {
		return false
	}
	if this.ClusterNotFoundResponseCode != that1.ClusterNotFoundResponseCode {
		return false
	}
	if !this.MetadataMatch.Equal(that1.MetadataMatch) {
		return false
	}
	if this.PrefixRewrite != that1.PrefixRewrite {
		return false
	}
	if that1.HostRewriteSpecifier == nil {
		if this.HostRewriteSpecifier != nil {
			return false
		}
	} else if this.HostRewriteSpecifier == nil {
		return false
	} else if !this.HostRewriteSpecifier.Equal(that1.HostRewriteSpecifier) {
		return false
	}
	if this.Timeout != nil && that1.Timeout != nil {
		if *this.Timeout != *that1.Timeout {
			return false
		}
	} else if this.Timeout != nil {
		return false
	} else if that1.Timeout != nil {
		return false
	}
	if !this.RetryPolicy.Equal(that1.RetryPolicy) {
		return false
	}
	if !this.RequestMirrorPolicy.Equal(that1.RequestMirrorPolicy) {
		return false
	}
	if this.Priority != that1.Priority {
		return false
	}
	if len(this.RequestHeadersToAdd) != len(that1.RequestHeadersToAdd) {
		return false
	}
	for i := range this.RequestHeadersToAdd {
		if !this.RequestHeadersToAdd[i].Equal(that1.RequestHeadersToAdd[i]) {
			return false
		}
	}
	if len(this.ResponseHeadersToAdd) != len(that1.ResponseHeadersToAdd) {
		return false
	}
	for i := range this.ResponseHeadersToAdd {
		if !this.ResponseHeadersToAdd[i].Equal(that1.ResponseHeadersToAdd[i]) {
			return false
		}
	}
	if len(this.ResponseHeadersToRemove) != len(that1.ResponseHeadersToRemove) {
		return false
	}
	for i := range this.ResponseHeadersToRemove {
		if this.ResponseHeadersToRemove[i] != that1.ResponseHeadersToRemove[i] {
			return false
		}
	}
	if len(this.RateLimits) != len(that1.RateLimits) {
		return false
	}
	for i := range this.RateLimits {
		if !this.RateLimits[i].Equal(that1.RateLimits[i]) {
			return false
		}
	}
	if !this.IncludeVhRateLimits.Equal(that1.IncludeVhRateLimits) {
		return false
	}
	if len(this.HashPolicy) != len(that1.HashPolicy) {
		return false
	}
	for i := range this.HashPolicy {
		if !this.HashPolicy[i].Equal(that1.HashPolicy[i]) {
			return false
		}
	}
	if !this.UseWebsocket.Equal(that1.UseWebsocket) {
		return false
	}
	if !this.Cors.Equal(that1.Cors) {
		return false
	}
	return true
}
func (this *RouteAction_Cluster) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RouteAction_Cluster)
	if !ok {
		that2, ok := that.(RouteAction_Cluster)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Cluster != that1.Cluster {
		return false
	}
	return true
}
func (this *RouteAction_ClusterHeader) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RouteAction_ClusterHeader)
	if !ok {
		that2, ok := that.(RouteAction_ClusterHeader)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.ClusterHeader != that1.ClusterHeader {
		return false
	}
	return true
}
func (this *RouteAction_WeightedClusters) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RouteAction_WeightedClusters)
	if !ok {
		that2, ok := that.(RouteAction_WeightedClusters)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.WeightedClusters.Equal(that1.WeightedClusters) {
		return false
	}
	return true
}
func (this *RouteAction_HostRewrite) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RouteAction_HostRewrite)
	if !ok {
		that2, ok := that.(RouteAction_HostRewrite)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.HostRewrite != that1.HostRewrite {
		return false
	}
	return true
}
func (this *RouteAction_AutoHostRewrite) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RouteAction_AutoHostRewrite)
	if !ok {
		that2, ok := that.(RouteAction_AutoHostRewrite)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.AutoHostRewrite.Equal(that1.AutoHostRewrite) {
		return false
	}
	return true
}
func (this *RouteAction_RetryPolicy) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RouteAction_RetryPolicy)
	if !ok {
		that2, ok := that.(RouteAction_RetryPolicy)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.RetryOn != that1.RetryOn {
		return false
	}
	if !this.NumRetries.Equal(that1.NumRetries) {
		return false
	}
	if this.PerTryTimeout != nil && that1.PerTryTimeout != nil {
		if *this.PerTryTimeout != *that1.PerTryTimeout {
			return false
		}
	} else if this.PerTryTimeout != nil {
		return false
	} else if that1.PerTryTimeout != nil {
		return false
	}
	return true
}
func (this *RouteAction_RequestMirrorPolicy) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RouteAction_RequestMirrorPolicy)
	if !ok {
		that2, ok := that.(RouteAction_RequestMirrorPolicy)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Cluster != that1.Cluster {
		return false
	}
	if this.RuntimeKey != that1.RuntimeKey {
		return false
	}
	return true
}
func (this *RouteAction_HashPolicy) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RouteAction_HashPolicy)
	if !ok {
		that2, ok := that.(RouteAction_HashPolicy)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if that1.PolicySpecifier == nil {
		if this.PolicySpecifier != nil {
			return false
		}
	} else if this.PolicySpecifier == nil {
		return false
	} else if !this.PolicySpecifier.Equal(that1.PolicySpecifier) {
		return false
	}
	return true
}
func (this *RouteAction_HashPolicy_Header_) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RouteAction_HashPolicy_Header_)
	if !ok {
		that2, ok := that.(RouteAction_HashPolicy_Header_)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Header.Equal(that1.Header) {
		return false
	}
	return true
}
func (this *RouteAction_HashPolicy_Cookie_) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RouteAction_HashPolicy_Cookie_)
	if !ok {
		that2, ok := that.(RouteAction_HashPolicy_Cookie_)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Cookie.Equal(that1.Cookie) {
		return false
	}
	return true
}
func (this *RouteAction_HashPolicy_ConnectionProperties_) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RouteAction_HashPolicy_ConnectionProperties_)
	if !ok {
		that2, ok := that.(RouteAction_HashPolicy_ConnectionProperties_)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.ConnectionProperties.Equal(that1.ConnectionProperties) {
		return false
	}
	return true
}
func (this *RouteAction_HashPolicy_Header) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RouteAction_HashPolicy_Header)
	if !ok {
		that2, ok := that.(RouteAction_HashPolicy_Header)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.HeaderName != that1.HeaderName {
		return false
	}
	return true
}
func (this *RouteAction_HashPolicy_Cookie) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RouteAction_HashPolicy_Cookie)
	if !ok {
		that2, ok := that.(RouteAction_HashPolicy_Cookie)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.Ttl != nil && that1.Ttl != nil {
		if *this.Ttl != *that1.Ttl {
			return false
		}
	} else if this.Ttl != nil {
		return false
	} else if that1.Ttl != nil {
		return false
	}
	return true
}
func (this *RouteAction_HashPolicy_ConnectionProperties) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RouteAction_HashPolicy_ConnectionProperties)
	if !ok {
		that2, ok := that.(RouteAction_HashPolicy_ConnectionProperties)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.SourceIp != that1.SourceIp {
		return false
	}
	return true
}
func (this *RedirectAction) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RedirectAction)
	if !ok {
		that2, ok := that.(RedirectAction)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.HostRedirect != that1.HostRedirect {
		return false
	}
	if that1.PathRewriteSpecifier == nil {
		if this.PathRewriteSpecifier != nil {
			return false
		}
	} else if this.PathRewriteSpecifier == nil {
		return false
	} else if !this.PathRewriteSpecifier.Equal(that1.PathRewriteSpecifier) {
		return false
	}
	if this.ResponseCode != that1.ResponseCode {
		return false
	}
	if this.HttpsRedirect != that1.HttpsRedirect {
		return false
	}
	if this.StripQuery != that1.StripQuery {
		return false
	}
	return true
}
func (this *RedirectAction_PathRedirect) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RedirectAction_PathRedirect)
	if !ok {
		that2, ok := that.(RedirectAction_PathRedirect)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.PathRedirect != that1.PathRedirect {
		return false
	}
	return true
}
func (this *RedirectAction_PrefixRewrite) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RedirectAction_PrefixRewrite)
	if !ok {
		that2, ok := that.(RedirectAction_PrefixRewrite)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.PrefixRewrite != that1.PrefixRewrite {
		return false
	}
	return true
}
func (this *DirectResponseAction) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*DirectResponseAction)
	if !ok {
		that2, ok := that.(DirectResponseAction)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Status != that1.Status {
		return false
	}
	if !this.Body.Equal(that1.Body) {
		return false
	}
	return true
}
func (this *Decorator) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Decorator)
	if !ok {
		that2, ok := that.(Decorator)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Operation != that1.Operation {
		return false
	}
	return true
}
func (this *VirtualCluster) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*VirtualCluster)
	if !ok {
		that2, ok := that.(VirtualCluster)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Pattern != that1.Pattern {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.Method != that1.Method {
		return false
	}
	return true
}
func (this *RateLimit) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RateLimit)
	if !ok {
		that2, ok := that.(RateLimit)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Stage.Equal(that1.Stage) {
		return false
	}
	if this.DisableKey != that1.DisableKey {
		return false
	}
	if len(this.Actions) != len(that1.Actions) {
		return false
	}
	for i := range this.Actions {
		if !this.Actions[i].Equal(that1.Actions[i]) {
			return false
		}
	}
	return true
}
func (this *RateLimit_Action) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RateLimit_Action)
	if !ok {
		that2, ok := that.(RateLimit_Action)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if that1.ActionSpecifier == nil {
		if this.ActionSpecifier != nil {
			return false
		}
	} else if this.ActionSpecifier == nil {
		return false
	} else if !this.ActionSpecifier.Equal(that1.ActionSpecifier) {
		return false
	}
	return true
}
func (this *RateLimit_Action_SourceCluster_) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RateLimit_Action_SourceCluster_)
	if !ok {
		that2, ok := that.(RateLimit_Action_SourceCluster_)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.SourceCluster.Equal(that1.SourceCluster) {
		return false
	}
	return true
}
func (this *RateLimit_Action_DestinationCluster_) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RateLimit_Action_DestinationCluster_)
	if !ok {
		that2, ok := that.(RateLimit_Action_DestinationCluster_)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.DestinationCluster.Equal(that1.DestinationCluster) {
		return false
	}
	return true
}
func (this *RateLimit_Action_RequestHeaders_) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RateLimit_Action_RequestHeaders_)
	if !ok {
		that2, ok := that.(RateLimit_Action_RequestHeaders_)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.RequestHeaders.Equal(that1.RequestHeaders) {
		return false
	}
	return true
}
func (this *RateLimit_Action_RemoteAddress_) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RateLimit_Action_RemoteAddress_)
	if !ok {
		that2, ok := that.(RateLimit_Action_RemoteAddress_)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.RemoteAddress.Equal(that1.RemoteAddress) {
		return false
	}
	return true
}
func (this *RateLimit_Action_GenericKey_) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RateLimit_Action_GenericKey_)
	if !ok {
		that2, ok := that.(RateLimit_Action_GenericKey_)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.GenericKey.Equal(that1.GenericKey) {
		return false
	}
	return true
}
func (this *RateLimit_Action_HeaderValueMatch_) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RateLimit_Action_HeaderValueMatch_)
	if !ok {
		that2, ok := that.(RateLimit_Action_HeaderValueMatch_)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.HeaderValueMatch.Equal(that1.HeaderValueMatch) {
		return false
	}
	return true
}
func (this *RateLimit_Action_SourceCluster) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RateLimit_Action_SourceCluster)
	if !ok {
		that2, ok := that.(RateLimit_Action_SourceCluster)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	return true
}
func (this *RateLimit_Action_DestinationCluster) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RateLimit_Action_DestinationCluster)
	if !ok {
		that2, ok := that.(RateLimit_Action_DestinationCluster)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	return true
}
func (this *RateLimit_Action_RequestHeaders) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RateLimit_Action_RequestHeaders)
	if !ok {
		that2, ok := that.(RateLimit_Action_RequestHeaders)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.HeaderName != that1.HeaderName {
		return false
	}
	if this.DescriptorKey != that1.DescriptorKey {
		return false
	}
	return true
}
func (this *RateLimit_Action_RemoteAddress) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RateLimit_Action_RemoteAddress)
	if !ok {
		that2, ok := that.(RateLimit_Action_RemoteAddress)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	return true
}
func (this *RateLimit_Action_GenericKey) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RateLimit_Action_GenericKey)
	if !ok {
		that2, ok := that.(RateLimit_Action_GenericKey)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.DescriptorValue != that1.DescriptorValue {
		return false
	}
	return true
}
func (this *RateLimit_Action_HeaderValueMatch) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RateLimit_Action_HeaderValueMatch)
	if !ok {
		that2, ok := that.(RateLimit_Action_HeaderValueMatch)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.DescriptorValue != that1.DescriptorValue {
		return false
	}
	if !this.ExpectMatch.Equal(that1.ExpectMatch) {
		return false
	}
	if len(this.Headers) != len(that1.Headers) {
		return false
	}
	for i := range this.Headers {
		if !this.Headers[i].Equal(that1.Headers[i]) {
			return false
		}
	}
	return true
}
func (this *HeaderMatcher) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*HeaderMatcher)
	if !ok {
		that2, ok := that.(HeaderMatcher)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.Value != that1.Value {
		return false
	}
	if !this.Regex.Equal(that1.Regex) {
		return false
	}
	if that1.HeaderMatchSpecifier == nil {
		if this.HeaderMatchSpecifier != nil {
			return false
		}
	} else if this.HeaderMatchSpecifier == nil {
		return false
	} else if !this.HeaderMatchSpecifier.Equal(that1.HeaderMatchSpecifier) {
		return false
	}
	return true
}
func (this *HeaderMatcher_ExactMatch) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*HeaderMatcher_ExactMatch)
	if !ok {
		that2, ok := that.(HeaderMatcher_ExactMatch)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.ExactMatch != that1.ExactMatch {
		return false
	}
	return true
}
func (this *HeaderMatcher_RegexMatch) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*HeaderMatcher_RegexMatch)
	if !ok {
		that2, ok := that.(HeaderMatcher_RegexMatch)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.RegexMatch != that1.RegexMatch {
		return false
	}
	return true
}
func (this *HeaderMatcher_RangeMatch) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*HeaderMatcher_RangeMatch)
	if !ok {
		that2, ok := that.(HeaderMatcher_RangeMatch)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.RangeMatch.Equal(that1.RangeMatch) {
		return false
	}
	return true
}
func (this *QueryParameterMatcher) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*QueryParameterMatcher)
	if !ok {
		that2, ok := that.(QueryParameterMatcher)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.Value != that1.Value {
		return false
	}
	if !this.Regex.Equal(that1.Regex) {
		return false
	}
	return true
}
func (m *VirtualHost) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VirtualHost) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Domains) > 0 {
		for _, s := range m.Domains {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.Routes) > 0 {
		for _, msg := range m.Routes {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintRoute(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.RequireTls != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.RequireTls))
	}
	if len(m.VirtualClusters) > 0 {
		for _, msg := range m.VirtualClusters {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintRoute(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.RateLimits) > 0 {
		for _, msg := range m.RateLimits {
			dAtA[i] = 0x32
			i++
			i = encodeVarintRoute(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.RequestHeadersToAdd) > 0 {
		for _, msg := range m.RequestHeadersToAdd {
			dAtA[i] = 0x3a
			i++
			i = encodeVarintRoute(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Cors != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.Cors.Size()))
		n1, err := m.Cors.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.Auth != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.Auth.Size()))
		n2, err := m.Auth.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if len(m.ResponseHeadersToAdd) > 0 {
		for _, msg := range m.ResponseHeadersToAdd {
			dAtA[i] = 0x52
			i++
			i = encodeVarintRoute(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.ResponseHeadersToRemove) > 0 {
		for _, s := range m.ResponseHeadersToRemove {
			dAtA[i] = 0x5a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.PerFilterConfig) > 0 {
		for k, _ := range m.PerFilterConfig {
			dAtA[i] = 0x62
			i++
			v := m.PerFilterConfig[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovRoute(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovRoute(uint64(len(k))) + msgSize
			i = encodeVarintRoute(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintRoute(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintRoute(dAtA, i, uint64(v.Size()))
				n3, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n3
			}
		}
	}
	return i, nil
}

func (m *Route) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Route) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintRoute(dAtA, i, uint64(m.Match.Size()))
	n4, err := m.Match.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n4
	if m.Action != nil {
		nn5, err := m.Action.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn5
	}
	if m.Metadata != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.Metadata.Size()))
		n6, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.Decorator != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.Decorator.Size()))
		n7, err := m.Decorator.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.Auth != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.Auth.Size()))
		n8, err := m.Auth.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if len(m.PerFilterConfig) > 0 {
		for k, _ := range m.PerFilterConfig {
			dAtA[i] = 0x42
			i++
			v := m.PerFilterConfig[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovRoute(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovRoute(uint64(len(k))) + msgSize
			i = encodeVarintRoute(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintRoute(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintRoute(dAtA, i, uint64(v.Size()))
				n9, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n9
			}
		}
	}
	return i, nil
}

func (m *Route_Route) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Route != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.Route.Size()))
		n10, err := m.Route.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	return i, nil
}
func (m *Route_Redirect) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Redirect != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.Redirect.Size()))
		n11, err := m.Redirect.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	return i, nil
}
func (m *Route_DirectResponse) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.DirectResponse != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.DirectResponse.Size()))
		n12, err := m.DirectResponse.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	return i, nil
}
func (m *WeightedCluster) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WeightedCluster) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Clusters) > 0 {
		for _, msg := range m.Clusters {
			dAtA[i] = 0xa
			i++
			i = encodeVarintRoute(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.RuntimeKeyPrefix) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.RuntimeKeyPrefix)))
		i += copy(dAtA[i:], m.RuntimeKeyPrefix)
	}
	if m.TotalWeight != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.TotalWeight.Size()))
		n13, err := m.TotalWeight.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	return i, nil
}

func (m *WeightedCluster_ClusterWeight) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WeightedCluster_ClusterWeight) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.Weight != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.Weight.Size()))
		n14, err := m.Weight.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	if m.MetadataMatch != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.MetadataMatch.Size()))
		n15, err := m.MetadataMatch.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	if len(m.RequestHeadersToAdd) > 0 {
		for _, msg := range m.RequestHeadersToAdd {
			dAtA[i] = 0x22
			i++
			i = encodeVarintRoute(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.ResponseHeadersToAdd) > 0 {
		for _, msg := range m.ResponseHeadersToAdd {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintRoute(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.ResponseHeadersToRemove) > 0 {
		for _, s := range m.ResponseHeadersToRemove {
			dAtA[i] = 0x32
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.PerFilterConfig) > 0 {
		for k, _ := range m.PerFilterConfig {
			dAtA[i] = 0x42
			i++
			v := m.PerFilterConfig[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovRoute(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovRoute(uint64(len(k))) + msgSize
			i = encodeVarintRoute(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintRoute(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintRoute(dAtA, i, uint64(v.Size()))
				n16, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n16
			}
		}
	}
	return i, nil
}

func (m *RouteMatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RouteMatch) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.PathSpecifier != nil {
		nn17, err := m.PathSpecifier.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn17
	}
	if m.CaseSensitive != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.CaseSensitive.Size()))
		n18, err := m.CaseSensitive.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n18
	}
	if m.Runtime != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.Runtime.Size()))
		n19, err := m.Runtime.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n19
	}
	if len(m.Headers) > 0 {
		for _, msg := range m.Headers {
			dAtA[i] = 0x32
			i++
			i = encodeVarintRoute(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.QueryParameters) > 0 {
		for _, msg := range m.QueryParameters {
			dAtA[i] = 0x3a
			i++
			i = encodeVarintRoute(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *RouteMatch_Prefix) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0xa
	i++
	i = encodeVarintRoute(dAtA, i, uint64(len(m.Prefix)))
	i += copy(dAtA[i:], m.Prefix)
	return i, nil
}
func (m *RouteMatch_Path) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x12
	i++
	i = encodeVarintRoute(dAtA, i, uint64(len(m.Path)))
	i += copy(dAtA[i:], m.Path)
	return i, nil
}
func (m *RouteMatch_Regex) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x1a
	i++
	i = encodeVarintRoute(dAtA, i, uint64(len(m.Regex)))
	i += copy(dAtA[i:], m.Regex)
	return i, nil
}
func (m *CorsPolicy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CorsPolicy) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.AllowOrigin) > 0 {
		for _, s := range m.AllowOrigin {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.AllowMethods) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.AllowMethods)))
		i += copy(dAtA[i:], m.AllowMethods)
	}
	if len(m.AllowHeaders) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.AllowHeaders)))
		i += copy(dAtA[i:], m.AllowHeaders)
	}
	if len(m.ExposeHeaders) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.ExposeHeaders)))
		i += copy(dAtA[i:], m.ExposeHeaders)
	}
	if len(m.MaxAge) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.MaxAge)))
		i += copy(dAtA[i:], m.MaxAge)
	}
	if m.AllowCredentials != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.AllowCredentials.Size()))
		n20, err := m.AllowCredentials.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n20
	}
	if m.Enabled != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.Enabled.Size()))
		n21, err := m.Enabled.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n21
	}
	return i, nil
}

func (m *RouteAction) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RouteAction) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ClusterSpecifier != nil {
		nn22, err := m.ClusterSpecifier.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn22
	}
	if m.MetadataMatch != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.MetadataMatch.Size()))
		n23, err := m.MetadataMatch.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n23
	}
	if len(m.PrefixRewrite) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.PrefixRewrite)))
		i += copy(dAtA[i:], m.PrefixRewrite)
	}
	if m.HostRewriteSpecifier != nil {
		nn24, err := m.HostRewriteSpecifier.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn24
	}
	if m.Timeout != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintRoute(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(*m.Timeout)))
		n25, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.Timeout, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n25
	}
	if m.RetryPolicy != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.RetryPolicy.Size()))
		n26, err := m.RetryPolicy.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n26
	}
	if m.RequestMirrorPolicy != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.RequestMirrorPolicy.Size()))
		n27, err := m.RequestMirrorPolicy.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n27
	}
	if m.Priority != 0 {
		dAtA[i] = 0x58
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.Priority))
	}
	if len(m.RequestHeadersToAdd) > 0 {
		for _, msg := range m.RequestHeadersToAdd {
			dAtA[i] = 0x62
			i++
			i = encodeVarintRoute(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.RateLimits) > 0 {
		for _, msg := range m.RateLimits {
			dAtA[i] = 0x6a
			i++
			i = encodeVarintRoute(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.IncludeVhRateLimits != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.IncludeVhRateLimits.Size()))
		n28, err := m.IncludeVhRateLimits.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n28
	}
	if len(m.HashPolicy) > 0 {
		for _, msg := range m.HashPolicy {
			dAtA[i] = 0x7a
			i++
			i = encodeVarintRoute(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.UseWebsocket != nil {
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.UseWebsocket.Size()))
		n29, err := m.UseWebsocket.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n29
	}
	if m.Cors != nil {
		dAtA[i] = 0x8a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.Cors.Size()))
		n30, err := m.Cors.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n30
	}
	if len(m.ResponseHeadersToAdd) > 0 {
		for _, msg := range m.ResponseHeadersToAdd {
			dAtA[i] = 0x92
			i++
			dAtA[i] = 0x1
			i++
			i = encodeVarintRoute(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.ResponseHeadersToRemove) > 0 {
		for _, s := range m.ResponseHeadersToRemove {
			dAtA[i] = 0x9a
			i++
			dAtA[i] = 0x1
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.ClusterNotFoundResponseCode != 0 {
		dAtA[i] = 0xa0
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.ClusterNotFoundResponseCode))
	}
	return i, nil
}

func (m *RouteAction_Cluster) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0xa
	i++
	i = encodeVarintRoute(dAtA, i, uint64(len(m.Cluster)))
	i += copy(dAtA[i:], m.Cluster)
	return i, nil
}
func (m *RouteAction_ClusterHeader) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x12
	i++
	i = encodeVarintRoute(dAtA, i, uint64(len(m.ClusterHeader)))
	i += copy(dAtA[i:], m.ClusterHeader)
	return i, nil
}
func (m *RouteAction_WeightedClusters) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.WeightedClusters != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.WeightedClusters.Size()))
		n31, err := m.WeightedClusters.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n31
	}
	return i, nil
}
func (m *RouteAction_HostRewrite) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x32
	i++
	i = encodeVarintRoute(dAtA, i, uint64(len(m.HostRewrite)))
	i += copy(dAtA[i:], m.HostRewrite)
	return i, nil
}
func (m *RouteAction_AutoHostRewrite) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.AutoHostRewrite != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.AutoHostRewrite.Size()))
		n32, err := m.AutoHostRewrite.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n32
	}
	return i, nil
}
func (m *RouteAction_RetryPolicy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RouteAction_RetryPolicy) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.RetryOn) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.RetryOn)))
		i += copy(dAtA[i:], m.RetryOn)
	}
	if m.NumRetries != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.NumRetries.Size()))
		n33, err := m.NumRetries.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n33
	}
	if m.PerTryTimeout != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(*m.PerTryTimeout)))
		n34, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.PerTryTimeout, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n34
	}
	return i, nil
}

func (m *RouteAction_RequestMirrorPolicy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RouteAction_RequestMirrorPolicy) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Cluster) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.Cluster)))
		i += copy(dAtA[i:], m.Cluster)
	}
	if len(m.RuntimeKey) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.RuntimeKey)))
		i += copy(dAtA[i:], m.RuntimeKey)
	}
	return i, nil
}

func (m *RouteAction_HashPolicy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RouteAction_HashPolicy) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.PolicySpecifier != nil {
		nn35, err := m.PolicySpecifier.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn35
	}
	return i, nil
}

func (m *RouteAction_HashPolicy_Header_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Header != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.Header.Size()))
		n36, err := m.Header.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n36
	}
	return i, nil
}
func (m *RouteAction_HashPolicy_Cookie_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Cookie != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.Cookie.Size()))
		n37, err := m.Cookie.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n37
	}
	return i, nil
}
func (m *RouteAction_HashPolicy_ConnectionProperties_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ConnectionProperties != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.ConnectionProperties.Size()))
		n38, err := m.ConnectionProperties.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n38
	}
	return i, nil
}
func (m *RouteAction_HashPolicy_Header) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RouteAction_HashPolicy_Header) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.HeaderName) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.HeaderName)))
		i += copy(dAtA[i:], m.HeaderName)
	}
	return i, nil
}

func (m *RouteAction_HashPolicy_Cookie) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RouteAction_HashPolicy_Cookie) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.Ttl != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRoute(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(*m.Ttl)))
		n39, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.Ttl, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n39
	}
	return i, nil
}

func (m *RouteAction_HashPolicy_ConnectionProperties) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RouteAction_HashPolicy_ConnectionProperties) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.SourceIp {
		dAtA[i] = 0x8
		i++
		if m.SourceIp {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *RedirectAction) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RedirectAction) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.HostRedirect) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.HostRedirect)))
		i += copy(dAtA[i:], m.HostRedirect)
	}
	if m.PathRewriteSpecifier != nil {
		nn40, err := m.PathRewriteSpecifier.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn40
	}
	if m.ResponseCode != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.ResponseCode))
	}
	if m.HttpsRedirect {
		dAtA[i] = 0x20
		i++
		if m.HttpsRedirect {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.StripQuery {
		dAtA[i] = 0x30
		i++
		if m.StripQuery {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *RedirectAction_PathRedirect) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x12
	i++
	i = encodeVarintRoute(dAtA, i, uint64(len(m.PathRedirect)))
	i += copy(dAtA[i:], m.PathRedirect)
	return i, nil
}
func (m *RedirectAction_PrefixRewrite) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x2a
	i++
	i = encodeVarintRoute(dAtA, i, uint64(len(m.PrefixRewrite)))
	i += copy(dAtA[i:], m.PrefixRewrite)
	return i, nil
}
func (m *DirectResponseAction) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DirectResponseAction) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Status != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.Status))
	}
	if m.Body != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.Body.Size()))
		n41, err := m.Body.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n41
	}
	return i, nil
}

func (m *Decorator) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Decorator) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Operation) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.Operation)))
		i += copy(dAtA[i:], m.Operation)
	}
	return i, nil
}

func (m *VirtualCluster) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VirtualCluster) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Pattern) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.Pattern)))
		i += copy(dAtA[i:], m.Pattern)
	}
	if len(m.Name) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.Method != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.Method))
	}
	return i, nil
}

func (m *RateLimit) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RateLimit) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Stage != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.Stage.Size()))
		n42, err := m.Stage.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n42
	}
	if len(m.DisableKey) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.DisableKey)))
		i += copy(dAtA[i:], m.DisableKey)
	}
	if len(m.Actions) > 0 {
		for _, msg := range m.Actions {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintRoute(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *RateLimit_Action) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RateLimit_Action) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ActionSpecifier != nil {
		nn43, err := m.ActionSpecifier.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn43
	}
	return i, nil
}

func (m *RateLimit_Action_SourceCluster_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.SourceCluster != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.SourceCluster.Size()))
		n44, err := m.SourceCluster.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n44
	}
	return i, nil
}
func (m *RateLimit_Action_DestinationCluster_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.DestinationCluster != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.DestinationCluster.Size()))
		n45, err := m.DestinationCluster.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n45
	}
	return i, nil
}
func (m *RateLimit_Action_RequestHeaders_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.RequestHeaders != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.RequestHeaders.Size()))
		n46, err := m.RequestHeaders.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n46
	}
	return i, nil
}
func (m *RateLimit_Action_RemoteAddress_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.RemoteAddress != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.RemoteAddress.Size()))
		n47, err := m.RemoteAddress.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n47
	}
	return i, nil
}
func (m *RateLimit_Action_GenericKey_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.GenericKey != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.GenericKey.Size()))
		n48, err := m.GenericKey.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n48
	}
	return i, nil
}
func (m *RateLimit_Action_HeaderValueMatch_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.HeaderValueMatch != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.HeaderValueMatch.Size()))
		n49, err := m.HeaderValueMatch.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n49
	}
	return i, nil
}
func (m *RateLimit_Action_SourceCluster) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RateLimit_Action_SourceCluster) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *RateLimit_Action_DestinationCluster) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RateLimit_Action_DestinationCluster) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *RateLimit_Action_RequestHeaders) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RateLimit_Action_RequestHeaders) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.HeaderName) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.HeaderName)))
		i += copy(dAtA[i:], m.HeaderName)
	}
	if len(m.DescriptorKey) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.DescriptorKey)))
		i += copy(dAtA[i:], m.DescriptorKey)
	}
	return i, nil
}

func (m *RateLimit_Action_RemoteAddress) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RateLimit_Action_RemoteAddress) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *RateLimit_Action_GenericKey) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RateLimit_Action_GenericKey) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.DescriptorValue) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.DescriptorValue)))
		i += copy(dAtA[i:], m.DescriptorValue)
	}
	return i, nil
}

func (m *RateLimit_Action_HeaderValueMatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RateLimit_Action_HeaderValueMatch) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.DescriptorValue) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.DescriptorValue)))
		i += copy(dAtA[i:], m.DescriptorValue)
	}
	if m.ExpectMatch != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.ExpectMatch.Size()))
		n50, err := m.ExpectMatch.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n50
	}
	if len(m.Headers) > 0 {
		for _, msg := range m.Headers {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintRoute(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *HeaderMatcher) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HeaderMatcher) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Value) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.Value)))
		i += copy(dAtA[i:], m.Value)
	}
	if m.Regex != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.Regex.Size()))
		n51, err := m.Regex.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n51
	}
	if m.HeaderMatchSpecifier != nil {
		nn52, err := m.HeaderMatchSpecifier.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn52
	}
	return i, nil
}

func (m *HeaderMatcher_ExactMatch) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x22
	i++
	i = encodeVarintRoute(dAtA, i, uint64(len(m.ExactMatch)))
	i += copy(dAtA[i:], m.ExactMatch)
	return i, nil
}
func (m *HeaderMatcher_RegexMatch) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x2a
	i++
	i = encodeVarintRoute(dAtA, i, uint64(len(m.RegexMatch)))
	i += copy(dAtA[i:], m.RegexMatch)
	return i, nil
}
func (m *HeaderMatcher_RangeMatch) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.RangeMatch != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.RangeMatch.Size()))
		n53, err := m.RangeMatch.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n53
	}
	return i, nil
}
func (m *QueryParameterMatcher) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryParameterMatcher) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Value) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintRoute(dAtA, i, uint64(len(m.Value)))
		i += copy(dAtA[i:], m.Value)
	}
	if m.Regex != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintRoute(dAtA, i, uint64(m.Regex.Size()))
		n54, err := m.Regex.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n54
	}
	return i, nil
}

func encodeVarintRoute(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *VirtualHost) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	if len(m.Domains) > 0 {
		for _, s := range m.Domains {
			l = len(s)
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	if len(m.Routes) > 0 {
		for _, e := range m.Routes {
			l = e.Size()
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	if m.RequireTls != 0 {
		n += 1 + sovRoute(uint64(m.RequireTls))
	}
	if len(m.VirtualClusters) > 0 {
		for _, e := range m.VirtualClusters {
			l = e.Size()
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	if len(m.RateLimits) > 0 {
		for _, e := range m.RateLimits {
			l = e.Size()
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	if len(m.RequestHeadersToAdd) > 0 {
		for _, e := range m.RequestHeadersToAdd {
			l = e.Size()
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	if m.Cors != nil {
		l = m.Cors.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.Auth != nil {
		l = m.Auth.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	if len(m.ResponseHeadersToAdd) > 0 {
		for _, e := range m.ResponseHeadersToAdd {
			l = e.Size()
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	if len(m.ResponseHeadersToRemove) > 0 {
		for _, s := range m.ResponseHeadersToRemove {
			l = len(s)
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	if len(m.PerFilterConfig) > 0 {
		for k, v := range m.PerFilterConfig {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovRoute(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovRoute(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovRoute(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *Route) Size() (n int) {
	var l int
	_ = l
	l = m.Match.Size()
	n += 1 + l + sovRoute(uint64(l))
	if m.Action != nil {
		n += m.Action.Size()
	}
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.Decorator != nil {
		l = m.Decorator.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.Auth != nil {
		l = m.Auth.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	if len(m.PerFilterConfig) > 0 {
		for k, v := range m.PerFilterConfig {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovRoute(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovRoute(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovRoute(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *Route_Route) Size() (n int) {
	var l int
	_ = l
	if m.Route != nil {
		l = m.Route.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}
func (m *Route_Redirect) Size() (n int) {
	var l int
	_ = l
	if m.Redirect != nil {
		l = m.Redirect.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}
func (m *Route_DirectResponse) Size() (n int) {
	var l int
	_ = l
	if m.DirectResponse != nil {
		l = m.DirectResponse.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}
func (m *WeightedCluster) Size() (n int) {
	var l int
	_ = l
	if len(m.Clusters) > 0 {
		for _, e := range m.Clusters {
			l = e.Size()
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	l = len(m.RuntimeKeyPrefix)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.TotalWeight != nil {
		l = m.TotalWeight.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}

func (m *WeightedCluster_ClusterWeight) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.Weight != nil {
		l = m.Weight.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.MetadataMatch != nil {
		l = m.MetadataMatch.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	if len(m.RequestHeadersToAdd) > 0 {
		for _, e := range m.RequestHeadersToAdd {
			l = e.Size()
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	if len(m.ResponseHeadersToAdd) > 0 {
		for _, e := range m.ResponseHeadersToAdd {
			l = e.Size()
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	if len(m.ResponseHeadersToRemove) > 0 {
		for _, s := range m.ResponseHeadersToRemove {
			l = len(s)
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	if len(m.PerFilterConfig) > 0 {
		for k, v := range m.PerFilterConfig {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovRoute(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovRoute(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovRoute(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *RouteMatch) Size() (n int) {
	var l int
	_ = l
	if m.PathSpecifier != nil {
		n += m.PathSpecifier.Size()
	}
	if m.CaseSensitive != nil {
		l = m.CaseSensitive.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.Runtime != nil {
		l = m.Runtime.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	if len(m.Headers) > 0 {
		for _, e := range m.Headers {
			l = e.Size()
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	if len(m.QueryParameters) > 0 {
		for _, e := range m.QueryParameters {
			l = e.Size()
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	return n
}

func (m *RouteMatch_Prefix) Size() (n int) {
	var l int
	_ = l
	l = len(m.Prefix)
	n += 1 + l + sovRoute(uint64(l))
	return n
}
func (m *RouteMatch_Path) Size() (n int) {
	var l int
	_ = l
	l = len(m.Path)
	n += 1 + l + sovRoute(uint64(l))
	return n
}
func (m *RouteMatch_Regex) Size() (n int) {
	var l int
	_ = l
	l = len(m.Regex)
	n += 1 + l + sovRoute(uint64(l))
	return n
}
func (m *CorsPolicy) Size() (n int) {
	var l int
	_ = l
	if len(m.AllowOrigin) > 0 {
		for _, s := range m.AllowOrigin {
			l = len(s)
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	l = len(m.AllowMethods)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	l = len(m.AllowHeaders)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	l = len(m.ExposeHeaders)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	l = len(m.MaxAge)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.AllowCredentials != nil {
		l = m.AllowCredentials.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.Enabled != nil {
		l = m.Enabled.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}

func (m *RouteAction) Size() (n int) {
	var l int
	_ = l
	if m.ClusterSpecifier != nil {
		n += m.ClusterSpecifier.Size()
	}
	if m.MetadataMatch != nil {
		l = m.MetadataMatch.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	l = len(m.PrefixRewrite)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.HostRewriteSpecifier != nil {
		n += m.HostRewriteSpecifier.Size()
	}
	if m.Timeout != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.Timeout)
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.RetryPolicy != nil {
		l = m.RetryPolicy.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.RequestMirrorPolicy != nil {
		l = m.RequestMirrorPolicy.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.Priority != 0 {
		n += 1 + sovRoute(uint64(m.Priority))
	}
	if len(m.RequestHeadersToAdd) > 0 {
		for _, e := range m.RequestHeadersToAdd {
			l = e.Size()
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	if len(m.RateLimits) > 0 {
		for _, e := range m.RateLimits {
			l = e.Size()
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	if m.IncludeVhRateLimits != nil {
		l = m.IncludeVhRateLimits.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	if len(m.HashPolicy) > 0 {
		for _, e := range m.HashPolicy {
			l = e.Size()
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	if m.UseWebsocket != nil {
		l = m.UseWebsocket.Size()
		n += 2 + l + sovRoute(uint64(l))
	}
	if m.Cors != nil {
		l = m.Cors.Size()
		n += 2 + l + sovRoute(uint64(l))
	}
	if len(m.ResponseHeadersToAdd) > 0 {
		for _, e := range m.ResponseHeadersToAdd {
			l = e.Size()
			n += 2 + l + sovRoute(uint64(l))
		}
	}
	if len(m.ResponseHeadersToRemove) > 0 {
		for _, s := range m.ResponseHeadersToRemove {
			l = len(s)
			n += 2 + l + sovRoute(uint64(l))
		}
	}
	if m.ClusterNotFoundResponseCode != 0 {
		n += 2 + sovRoute(uint64(m.ClusterNotFoundResponseCode))
	}
	return n
}

func (m *RouteAction_Cluster) Size() (n int) {
	var l int
	_ = l
	l = len(m.Cluster)
	n += 1 + l + sovRoute(uint64(l))
	return n
}
func (m *RouteAction_ClusterHeader) Size() (n int) {
	var l int
	_ = l
	l = len(m.ClusterHeader)
	n += 1 + l + sovRoute(uint64(l))
	return n
}
func (m *RouteAction_WeightedClusters) Size() (n int) {
	var l int
	_ = l
	if m.WeightedClusters != nil {
		l = m.WeightedClusters.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}
func (m *RouteAction_HostRewrite) Size() (n int) {
	var l int
	_ = l
	l = len(m.HostRewrite)
	n += 1 + l + sovRoute(uint64(l))
	return n
}
func (m *RouteAction_AutoHostRewrite) Size() (n int) {
	var l int
	_ = l
	if m.AutoHostRewrite != nil {
		l = m.AutoHostRewrite.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}
func (m *RouteAction_RetryPolicy) Size() (n int) {
	var l int
	_ = l
	l = len(m.RetryOn)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.NumRetries != nil {
		l = m.NumRetries.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.PerTryTimeout != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.PerTryTimeout)
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}

func (m *RouteAction_RequestMirrorPolicy) Size() (n int) {
	var l int
	_ = l
	l = len(m.Cluster)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	l = len(m.RuntimeKey)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}

func (m *RouteAction_HashPolicy) Size() (n int) {
	var l int
	_ = l
	if m.PolicySpecifier != nil {
		n += m.PolicySpecifier.Size()
	}
	return n
}

func (m *RouteAction_HashPolicy_Header_) Size() (n int) {
	var l int
	_ = l
	if m.Header != nil {
		l = m.Header.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}
func (m *RouteAction_HashPolicy_Cookie_) Size() (n int) {
	var l int
	_ = l
	if m.Cookie != nil {
		l = m.Cookie.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}
func (m *RouteAction_HashPolicy_ConnectionProperties_) Size() (n int) {
	var l int
	_ = l
	if m.ConnectionProperties != nil {
		l = m.ConnectionProperties.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}
func (m *RouteAction_HashPolicy_Header) Size() (n int) {
	var l int
	_ = l
	l = len(m.HeaderName)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}

func (m *RouteAction_HashPolicy_Cookie) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.Ttl != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.Ttl)
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}

func (m *RouteAction_HashPolicy_ConnectionProperties) Size() (n int) {
	var l int
	_ = l
	if m.SourceIp {
		n += 2
	}
	return n
}

func (m *RedirectAction) Size() (n int) {
	var l int
	_ = l
	l = len(m.HostRedirect)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.PathRewriteSpecifier != nil {
		n += m.PathRewriteSpecifier.Size()
	}
	if m.ResponseCode != 0 {
		n += 1 + sovRoute(uint64(m.ResponseCode))
	}
	if m.HttpsRedirect {
		n += 2
	}
	if m.StripQuery {
		n += 2
	}
	return n
}

func (m *RedirectAction_PathRedirect) Size() (n int) {
	var l int
	_ = l
	l = len(m.PathRedirect)
	n += 1 + l + sovRoute(uint64(l))
	return n
}
func (m *RedirectAction_PrefixRewrite) Size() (n int) {
	var l int
	_ = l
	l = len(m.PrefixRewrite)
	n += 1 + l + sovRoute(uint64(l))
	return n
}
func (m *DirectResponseAction) Size() (n int) {
	var l int
	_ = l
	if m.Status != 0 {
		n += 1 + sovRoute(uint64(m.Status))
	}
	if m.Body != nil {
		l = m.Body.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}

func (m *Decorator) Size() (n int) {
	var l int
	_ = l
	l = len(m.Operation)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}

func (m *VirtualCluster) Size() (n int) {
	var l int
	_ = l
	l = len(m.Pattern)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.Method != 0 {
		n += 1 + sovRoute(uint64(m.Method))
	}
	return n
}

func (m *RateLimit) Size() (n int) {
	var l int
	_ = l
	if m.Stage != nil {
		l = m.Stage.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	l = len(m.DisableKey)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	if len(m.Actions) > 0 {
		for _, e := range m.Actions {
			l = e.Size()
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	return n
}

func (m *RateLimit_Action) Size() (n int) {
	var l int
	_ = l
	if m.ActionSpecifier != nil {
		n += m.ActionSpecifier.Size()
	}
	return n
}

func (m *RateLimit_Action_SourceCluster_) Size() (n int) {
	var l int
	_ = l
	if m.SourceCluster != nil {
		l = m.SourceCluster.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}
func (m *RateLimit_Action_DestinationCluster_) Size() (n int) {
	var l int
	_ = l
	if m.DestinationCluster != nil {
		l = m.DestinationCluster.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}
func (m *RateLimit_Action_RequestHeaders_) Size() (n int) {
	var l int
	_ = l
	if m.RequestHeaders != nil {
		l = m.RequestHeaders.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}
func (m *RateLimit_Action_RemoteAddress_) Size() (n int) {
	var l int
	_ = l
	if m.RemoteAddress != nil {
		l = m.RemoteAddress.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}
func (m *RateLimit_Action_GenericKey_) Size() (n int) {
	var l int
	_ = l
	if m.GenericKey != nil {
		l = m.GenericKey.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}
func (m *RateLimit_Action_HeaderValueMatch_) Size() (n int) {
	var l int
	_ = l
	if m.HeaderValueMatch != nil {
		l = m.HeaderValueMatch.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}
func (m *RateLimit_Action_SourceCluster) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *RateLimit_Action_DestinationCluster) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *RateLimit_Action_RequestHeaders) Size() (n int) {
	var l int
	_ = l
	l = len(m.HeaderName)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	l = len(m.DescriptorKey)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}

func (m *RateLimit_Action_RemoteAddress) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *RateLimit_Action_GenericKey) Size() (n int) {
	var l int
	_ = l
	l = len(m.DescriptorValue)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}

func (m *RateLimit_Action_HeaderValueMatch) Size() (n int) {
	var l int
	_ = l
	l = len(m.DescriptorValue)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.ExpectMatch != nil {
		l = m.ExpectMatch.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	if len(m.Headers) > 0 {
		for _, e := range m.Headers {
			l = e.Size()
			n += 1 + l + sovRoute(uint64(l))
		}
	}
	return n
}

func (m *HeaderMatcher) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.Regex != nil {
		l = m.Regex.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.HeaderMatchSpecifier != nil {
		n += m.HeaderMatchSpecifier.Size()
	}
	return n
}

func (m *HeaderMatcher_ExactMatch) Size() (n int) {
	var l int
	_ = l
	l = len(m.ExactMatch)
	n += 1 + l + sovRoute(uint64(l))
	return n
}
func (m *HeaderMatcher_RegexMatch) Size() (n int) {
	var l int
	_ = l
	l = len(m.RegexMatch)
	n += 1 + l + sovRoute(uint64(l))
	return n
}
func (m *HeaderMatcher_RangeMatch) Size() (n int) {
	var l int
	_ = l
	if m.RangeMatch != nil {
		l = m.RangeMatch.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}
func (m *QueryParameterMatcher) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovRoute(uint64(l))
	}
	if m.Regex != nil {
		l = m.Regex.Size()
		n += 1 + l + sovRoute(uint64(l))
	}
	return n
}

func sovRoute(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozRoute(x uint64) (n int) {
	return sovRoute(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *VirtualHost) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: VirtualHost: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: VirtualHost: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Domains", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Domains = append(m.Domains, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Routes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Routes = append(m.Routes, Route{})
			if err := m.Routes[len(m.Routes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequireTls", wireType)
			}
			m.RequireTls = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RequireTls |= (VirtualHost_TlsRequirementType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field VirtualClusters", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.VirtualClusters = append(m.VirtualClusters, &VirtualCluster{})
			if err := m.VirtualClusters[len(m.VirtualClusters)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RateLimits", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RateLimits = append(m.RateLimits, &RateLimit{})
			if err := m.RateLimits[len(m.RateLimits)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeadersToAdd", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestHeadersToAdd = append(m.RequestHeadersToAdd, &envoy_api_v2_core.HeaderValueOption{})
			if err := m.RequestHeadersToAdd[len(m.RequestHeadersToAdd)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Cors == nil {
				m.Cors = &CorsPolicy{}
			}
			if err := m.Cors.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Auth", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Auth == nil {
				m.Auth = &envoy_api_v2_auth1.AuthAction{}
			}
			if err := m.Auth.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeadersToAdd", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResponseHeadersToAdd = append(m.ResponseHeadersToAdd, &envoy_api_v2_core.HeaderValueOption{})
			if err := m.ResponseHeadersToAdd[len(m.ResponseHeadersToAdd)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeadersToRemove", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResponseHeadersToRemove = append(m.ResponseHeadersToRemove, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PerFilterConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PerFilterConfig == nil {
				m.PerFilterConfig = make(map[string]*google_protobuf.Struct)
			}
			var mapkey string
			var mapvalue *google_protobuf.Struct
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRoute
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRoute
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthRoute
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRoute
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthRoute
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthRoute
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &google_protobuf.Struct{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipRoute(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthRoute
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.PerFilterConfig[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Route) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Route: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Route: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Match", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Match.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Route", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RouteAction{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Action = &Route_Route{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Redirect", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RedirectAction{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Action = &Route_Redirect{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &envoy_api_v2_core.Metadata{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Decorator", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Decorator == nil {
				m.Decorator = &Decorator{}
			}
			if err := m.Decorator.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Auth", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Auth == nil {
				m.Auth = &envoy_api_v2_auth1.AuthAction{}
			}
			if err := m.Auth.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DirectResponse", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &DirectResponseAction{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Action = &Route_DirectResponse{v}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PerFilterConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PerFilterConfig == nil {
				m.PerFilterConfig = make(map[string]*google_protobuf.Struct)
			}
			var mapkey string
			var mapvalue *google_protobuf.Struct
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRoute
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRoute
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthRoute
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRoute
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthRoute
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthRoute
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &google_protobuf.Struct{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipRoute(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthRoute
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.PerFilterConfig[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WeightedCluster) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WeightedCluster: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WeightedCluster: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Clusters", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Clusters = append(m.Clusters, &WeightedCluster_ClusterWeight{})
			if err := m.Clusters[len(m.Clusters)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RuntimeKeyPrefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RuntimeKeyPrefix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalWeight", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TotalWeight == nil {
				m.TotalWeight = &google_protobuf1.UInt32Value{}
			}
			if err := m.TotalWeight.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WeightedCluster_ClusterWeight) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClusterWeight: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClusterWeight: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Weight", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Weight == nil {
				m.Weight = &google_protobuf1.UInt32Value{}
			}
			if err := m.Weight.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MetadataMatch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MetadataMatch == nil {
				m.MetadataMatch = &envoy_api_v2_core.Metadata{}
			}
			if err := m.MetadataMatch.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeadersToAdd", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestHeadersToAdd = append(m.RequestHeadersToAdd, &envoy_api_v2_core.HeaderValueOption{})
			if err := m.RequestHeadersToAdd[len(m.RequestHeadersToAdd)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeadersToAdd", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResponseHeadersToAdd = append(m.ResponseHeadersToAdd, &envoy_api_v2_core.HeaderValueOption{})
			if err := m.ResponseHeadersToAdd[len(m.ResponseHeadersToAdd)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeadersToRemove", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResponseHeadersToRemove = append(m.ResponseHeadersToRemove, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PerFilterConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PerFilterConfig == nil {
				m.PerFilterConfig = make(map[string]*google_protobuf.Struct)
			}
			var mapkey string
			var mapvalue *google_protobuf.Struct
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowRoute
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRoute
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthRoute
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowRoute
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthRoute
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthRoute
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &google_protobuf.Struct{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipRoute(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthRoute
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.PerFilterConfig[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RouteMatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RouteMatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RouteMatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Prefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PathSpecifier = &RouteMatch_Prefix{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PathSpecifier = &RouteMatch_Path{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Regex", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PathSpecifier = &RouteMatch_Regex{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CaseSensitive", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CaseSensitive == nil {
				m.CaseSensitive = &google_protobuf1.BoolValue{}
			}
			if err := m.CaseSensitive.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Runtime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Runtime == nil {
				m.Runtime = &envoy_api_v2_core.RuntimeUInt32{}
			}
			if err := m.Runtime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Headers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Headers = append(m.Headers, &HeaderMatcher{})
			if err := m.Headers[len(m.Headers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field QueryParameters", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.QueryParameters = append(m.QueryParameters, &QueryParameterMatcher{})
			if err := m.QueryParameters[len(m.QueryParameters)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CorsPolicy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CorsPolicy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CorsPolicy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AllowOrigin", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AllowOrigin = append(m.AllowOrigin, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AllowMethods", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AllowMethods = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AllowHeaders", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AllowHeaders = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExposeHeaders", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExposeHeaders = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxAge", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MaxAge = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AllowCredentials", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AllowCredentials == nil {
				m.AllowCredentials = &google_protobuf1.BoolValue{}
			}
			if err := m.AllowCredentials.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Enabled", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Enabled == nil {
				m.Enabled = &google_protobuf1.BoolValue{}
			}
			if err := m.Enabled.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RouteAction) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RouteAction: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RouteAction: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterSpecifier = &RouteAction_Cluster{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterHeader", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterSpecifier = &RouteAction_ClusterHeader{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WeightedClusters", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &WeightedCluster{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ClusterSpecifier = &RouteAction_WeightedClusters{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MetadataMatch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MetadataMatch == nil {
				m.MetadataMatch = &envoy_api_v2_core.Metadata{}
			}
			if err := m.MetadataMatch.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrefixRewrite", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PrefixRewrite = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HostRewrite", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HostRewriteSpecifier = &RouteAction_HostRewrite{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AutoHostRewrite", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &google_protobuf1.BoolValue{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.HostRewriteSpecifier = &RouteAction_AutoHostRewrite{v}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Timeout == nil {
				m.Timeout = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.Timeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetryPolicy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RetryPolicy == nil {
				m.RetryPolicy = &RouteAction_RetryPolicy{}
			}
			if err := m.RetryPolicy.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestMirrorPolicy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RequestMirrorPolicy == nil {
				m.RequestMirrorPolicy = &RouteAction_RequestMirrorPolicy{}
			}
			if err := m.RequestMirrorPolicy.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Priority", wireType)
			}
			m.Priority = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Priority |= (envoy_api_v2_core.RoutingPriority(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeadersToAdd", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestHeadersToAdd = append(m.RequestHeadersToAdd, &envoy_api_v2_core.HeaderValueOption{})
			if err := m.RequestHeadersToAdd[len(m.RequestHeadersToAdd)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RateLimits", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RateLimits = append(m.RateLimits, &RateLimit{})
			if err := m.RateLimits[len(m.RateLimits)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IncludeVhRateLimits", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.IncludeVhRateLimits == nil {
				m.IncludeVhRateLimits = &google_protobuf1.BoolValue{}
			}
			if err := m.IncludeVhRateLimits.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HashPolicy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HashPolicy = append(m.HashPolicy, &RouteAction_HashPolicy{})
			if err := m.HashPolicy[len(m.HashPolicy)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UseWebsocket", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UseWebsocket == nil {
				m.UseWebsocket = &google_protobuf1.BoolValue{}
			}
			if err := m.UseWebsocket.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Cors == nil {
				m.Cors = &CorsPolicy{}
			}
			if err := m.Cors.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 18:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeadersToAdd", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResponseHeadersToAdd = append(m.ResponseHeadersToAdd, &envoy_api_v2_core.HeaderValueOption{})
			if err := m.ResponseHeadersToAdd[len(m.ResponseHeadersToAdd)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 19:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeadersToRemove", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResponseHeadersToRemove = append(m.ResponseHeadersToRemove, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 20:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterNotFoundResponseCode", wireType)
			}
			m.ClusterNotFoundResponseCode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ClusterNotFoundResponseCode |= (RouteAction_ClusterNotFoundResponseCode(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RouteAction_RetryPolicy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RetryPolicy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RetryPolicy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetryOn", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RetryOn = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumRetries", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NumRetries == nil {
				m.NumRetries = &google_protobuf1.UInt32Value{}
			}
			if err := m.NumRetries.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PerTryTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PerTryTimeout == nil {
				m.PerTryTimeout = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.PerTryTimeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RouteAction_RequestMirrorPolicy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestMirrorPolicy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestMirrorPolicy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Cluster = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RuntimeKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RuntimeKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RouteAction_HashPolicy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HashPolicy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HashPolicy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Header", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RouteAction_HashPolicy_Header{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.PolicySpecifier = &RouteAction_HashPolicy_Header_{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cookie", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RouteAction_HashPolicy_Cookie{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.PolicySpecifier = &RouteAction_HashPolicy_Cookie_{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnectionProperties", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RouteAction_HashPolicy_ConnectionProperties{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.PolicySpecifier = &RouteAction_HashPolicy_ConnectionProperties_{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RouteAction_HashPolicy_Header) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Header: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Header: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HeaderName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HeaderName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RouteAction_HashPolicy_Cookie) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Cookie: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Cookie: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ttl", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Ttl == nil {
				m.Ttl = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.Ttl, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RouteAction_HashPolicy_ConnectionProperties) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConnectionProperties: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConnectionProperties: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceIp", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.SourceIp = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RedirectAction) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RedirectAction: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RedirectAction: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HostRedirect", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HostRedirect = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PathRedirect", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PathRewriteSpecifier = &RedirectAction_PathRedirect{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseCode", wireType)
			}
			m.ResponseCode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ResponseCode |= (RedirectAction_RedirectResponseCode(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpsRedirect", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.HttpsRedirect = bool(v != 0)
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrefixRewrite", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PathRewriteSpecifier = &RedirectAction_PrefixRewrite{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StripQuery", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.StripQuery = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DirectResponseAction) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DirectResponseAction: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DirectResponseAction: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Body", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Body == nil {
				m.Body = &envoy_api_v2_core.DataSource{}
			}
			if err := m.Body.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Decorator) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Decorator: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Decorator: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Operation", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Operation = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *VirtualCluster) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: VirtualCluster: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: VirtualCluster: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Pattern", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Pattern = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Method", wireType)
			}
			m.Method = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Method |= (envoy_api_v2_core.RequestMethod(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RateLimit) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RateLimit: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RateLimit: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stage", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Stage == nil {
				m.Stage = &google_protobuf1.UInt32Value{}
			}
			if err := m.Stage.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DisableKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DisableKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Actions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Actions = append(m.Actions, &RateLimit_Action{})
			if err := m.Actions[len(m.Actions)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RateLimit_Action) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Action: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Action: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceCluster", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RateLimit_Action_SourceCluster{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ActionSpecifier = &RateLimit_Action_SourceCluster_{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationCluster", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RateLimit_Action_DestinationCluster{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ActionSpecifier = &RateLimit_Action_DestinationCluster_{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeaders", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RateLimit_Action_RequestHeaders{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ActionSpecifier = &RateLimit_Action_RequestHeaders_{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RemoteAddress", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RateLimit_Action_RemoteAddress{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ActionSpecifier = &RateLimit_Action_RemoteAddress_{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GenericKey", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RateLimit_Action_GenericKey{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ActionSpecifier = &RateLimit_Action_GenericKey_{v}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HeaderValueMatch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RateLimit_Action_HeaderValueMatch{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ActionSpecifier = &RateLimit_Action_HeaderValueMatch_{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RateLimit_Action_SourceCluster) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SourceCluster: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SourceCluster: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RateLimit_Action_DestinationCluster) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DestinationCluster: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DestinationCluster: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RateLimit_Action_RequestHeaders) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestHeaders: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestHeaders: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HeaderName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HeaderName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DescriptorKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DescriptorKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RateLimit_Action_RemoteAddress) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RemoteAddress: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RemoteAddress: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RateLimit_Action_GenericKey) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GenericKey: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GenericKey: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DescriptorValue", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DescriptorValue = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RateLimit_Action_HeaderValueMatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HeaderValueMatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HeaderValueMatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DescriptorValue", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DescriptorValue = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExpectMatch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExpectMatch == nil {
				m.ExpectMatch = &google_protobuf1.BoolValue{}
			}
			if err := m.ExpectMatch.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Headers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Headers = append(m.Headers, &HeaderMatcher{})
			if err := m.Headers[len(m.Headers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HeaderMatcher) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HeaderMatcher: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HeaderMatcher: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Regex", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Regex == nil {
				m.Regex = &google_protobuf1.BoolValue{}
			}
			if err := m.Regex.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExactMatch", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HeaderMatchSpecifier = &HeaderMatcher_ExactMatch{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegexMatch", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HeaderMatchSpecifier = &HeaderMatcher_RegexMatch{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeMatch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &envoy_type.Int64Range{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.HeaderMatchSpecifier = &HeaderMatcher_RangeMatch{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryParameterMatcher) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryParameterMatcher: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryParameterMatcher: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Regex", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRoute
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Regex == nil {
				m.Regex = &google_protobuf1.BoolValue{}
			}
			if err := m.Regex.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRoute(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRoute
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipRoute(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowRoute
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRoute
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthRoute
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowRoute
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipRoute(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthRoute = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowRoute   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("envoy/api/v2/route/route.proto", fileDescriptorRoute) }

var fileDescriptorRoute = []byte{
	// 2709 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x59, 0x4b, 0x6c, 0x1b, 0xc7,
	0x19, 0xd6, 0xf2, 0xcd, 0x9f, 0x22, 0x45, 0x8d, 0x65, 0x89, 0xa6, 0x13, 0x59, 0xa6, 0x6d, 0x44,
	0x75, 0x5b, 0x2a, 0x96, 0xd5, 0x3a, 0x89, 0x91, 0xa4, 0xa4, 0x44, 0x9b, 0xb6, 0xf5, 0xea, 0x88,
	0x71, 0xea, 0x18, 0xe8, 0x76, 0xcd, 0x1d, 0x91, 0x5b, 0x93, 0xbb, 0x9b, 0xd9, 0xa1, 0x24, 0x5e,
	0x8a, 0xa2, 0xa7, 0xa2, 0x40, 0x8b, 0xb6, 0xa7, 0x9e, 0xdb, 0x4b, 0x8f, 0x3d, 0x06, 0x3d, 0xe5,
	0x54, 0x04, 0x3d, 0xe5, 0xd8, 0x4b, 0xda, 0xc2, 0xb7, 0xdc, 0x7b, 0x6f, 0x31, 0x8f, 0x5d, 0x3e,
	0xb4, 0x12, 0xa9, 0x06, 0x01, 0x72, 0x91, 0x76, 0xfe, 0xf9, 0xfe, 0x7f, 0x1e, 0xff, 0x7b, 0x08,
	0xcb, 0xc4, 0x3e, 0x72, 0xfa, 0x6b, 0x86, 0x6b, 0xad, 0x1d, 0xad, 0xaf, 0x51, 0xa7, 0xc7, 0x88,
	0xfc, 0x5b, 0x76, 0xa9, 0xc3, 0x1c, 0x84, 0xc4, 0x7c, 0xd9, 0x70, 0xad, 0xf2, 0xd1, 0x7a, 0x59,
	0xcc, 0x14, 0x5f, 0x1b, 0xe1, 0x69, 0x3a, 0x94, 0xac, 0xbd, 0x30, 0x3c, 0xc5, 0x31, 0x36, 0x6b,
	0xf4, 0x58, 0x5b, 0xfc, 0x51, 0xb3, 0x8b, 0x72, 0x96, 0xf5, 0x5d, 0xb2, 0x46, 0x0d, 0xbb, 0xe5,
	0x73, 0x2d, 0xb7, 0x1c, 0xa7, 0xd5, 0x21, 0x6b, 0x62, 0xf4, 0xa2, 0x77, 0xb8, 0x66, 0xf6, 0xa8,
	0xc1, 0x2c, 0xc7, 0xf6, 0xa5, 0x8e, 0xcf, 0x7b, 0x8c, 0xf6, 0x9a, 0xec, 0x2c, 0xee, 0x63, 0x6a,
	0xb8, 0x2e, 0xa1, 0x9e, 0x9a, 0x5f, 0x3a, 0x32, 0x3a, 0x96, 0x69, 0x30, 0xb2, 0xe6, 0x7f, 0xa8,
	0x89, 0x85, 0x96, 0xd3, 0x72, 0xc4, 0xe7, 0x1a, 0xff, 0x92, 0xd4, 0xd2, 0xdf, 0x92, 0x90, 0x79,
	0x6a, 0x51, 0xd6, 0x33, 0x3a, 0x75, 0xc7, 0x63, 0xe8, 0x75, 0x88, 0xd9, 0x46, 0x97, 0x14, 0xb4,
	0x15, 0x6d, 0x35, 0x5d, 0x4d, 0xff, 0xf5, 0xcb, 0x4f, 0xa3, 0x31, 0x1a, 0x59, 0xd1, 0xb0, 0x20,
	0xa3, 0x9b, 0x90, 0x34, 0x9d, 0xae, 0x61, 0xd9, 0x5e, 0x21, 0xb2, 0x12, 0x5d, 0x4d, 0x57, 0x81,
	0x23, 0xe2, 0xbf, 0xd7, 0x22, 0x29, 0x0d, 0xfb, 0x53, 0xe8, 0x1e, 0x24, 0xc4, 0xf5, 0x79, 0x85,
	0xe8, 0x4a, 0x74, 0x35, 0xb3, 0x7e, 0xa5, 0x7c, 0xfa, 0x6a, 0xcb, 0x98, 0xff, 0xad, 0xc6, 0x3e,
	0xfb, 0xe7, 0xb5, 0x19, 0xac, 0xe0, 0xe8, 0x00, 0x32, 0x94, 0x7c, 0xdc, 0xb3, 0x28, 0xd1, 0x59,
	0xc7, 0x2b, 0xc4, 0x56, 0xb4, 0xd5, 0xdc, 0xfa, 0x7a, 0x18, 0xf7, 0xd0, 0x9e, 0xcb, 0x8d, 0x8e,
	0x87, 0x25, 0x57, 0x97, 0xd8, 0xac, 0xd1, 0x77, 0x09, 0x06, 0x25, 0xa6, 0xd1, 0xf1, 0xd0, 0x0e,
	0xe4, 0x8f, 0x24, 0x5a, 0x6f, 0x76, 0x7a, 0x1e, 0x23, 0xd4, 0x2b, 0xc4, 0xc5, 0xbe, 0x4a, 0xe7,
	0x48, 0xde, 0x94, 0x50, 0x3c, 0x77, 0x34, 0x32, 0xf6, 0xd0, 0x7b, 0x90, 0xa1, 0x06, 0x23, 0x7a,
	0xc7, 0xea, 0x5a, 0xcc, 0x2b, 0x24, 0x84, 0xa4, 0xd7, 0x43, 0x4f, 0x68, 0x30, 0xb2, 0xcd, 0x51,
	0x18, 0xa8, 0xff, 0xe9, 0xa1, 0x67, 0xb0, 0xc8, 0x37, 0x47, 0x3c, 0xa6, 0xb7, 0x89, 0x61, 0x12,
	0xea, 0xe9, 0xcc, 0xd1, 0x0d, 0xd3, 0x2c, 0x24, 0x85, 0xa8, 0x9b, 0xa3, 0xa2, 0xb8, 0xcd, 0x95,
	0xeb, 0x02, 0xf8, 0xd4, 0xe8, 0xf4, 0xc8, 0x9e, 0xcb, 0x4d, 0x05, 0x5f, 0x52, 0x32, 0xe4, 0x8c,
	0xd7, 0x70, 0x2a, 0xa6, 0x89, 0xd6, 0x21, 0xd6, 0x74, 0xa8, 0x57, 0x48, 0xad, 0x68, 0xab, 0x99,
	0xf5, 0xe5, 0xb0, 0x3d, 0x6d, 0x3a, 0xd4, 0xdb, 0x77, 0x3a, 0x56, 0xb3, 0x8f, 0x05, 0x16, 0xdd,
	0x81, 0x18, 0xb7, 0xd9, 0x42, 0x5a, 0xf0, 0x8c, 0x9d, 0x43, 0x58, 0x73, 0xa5, 0xc7, 0xda, 0x95,
	0xa6, 0x58, 0x55, 0x40, 0xd1, 0x73, 0x58, 0xa2, 0xc4, 0x73, 0x1d, 0xdb, 0x23, 0xe3, 0x47, 0x80,
	0x0b, 0x1c, 0x61, 0xc1, 0x17, 0x32, 0x72, 0x86, 0xfb, 0x50, 0x0c, 0x13, 0x4e, 0x49, 0xd7, 0x39,
	0x22, 0x85, 0x0c, 0x37, 0x3a, 0xbc, 0x74, 0x8a, 0x13, 0x8b, 0x69, 0xf4, 0x13, 0x98, 0x77, 0x09,
	0xd5, 0x0f, 0xad, 0x0e, 0x23, 0x54, 0x6f, 0x3a, 0xf6, 0xa1, 0xd5, 0x2a, 0xcc, 0x8a, 0x3d, 0x6d,
	0x4c, 0xb2, 0xa2, 0x7d, 0x42, 0x1f, 0x08, 0xbe, 0x4d, 0xc1, 0x56, 0xb3, 0x19, 0xed, 0xe3, 0x39,
	0x77, 0x94, 0x5a, 0x7c, 0x0e, 0x0b, 0x61, 0x40, 0x94, 0x87, 0xe8, 0x4b, 0xd2, 0x97, 0x6e, 0x83,
	0xf9, 0x27, 0xfa, 0x2e, 0xc4, 0x8f, 0xf8, 0x69, 0x0b, 0x11, 0x71, 0xb3, 0x4b, 0x65, 0xe9, 0xb8,
	0x65, 0xdf, 0x71, 0xcb, 0x07, 0xc2, 0xad, 0xb1, 0x44, 0xbd, 0x13, 0x79, 0x4b, 0x2b, 0xbd, 0x03,
	0xe8, 0xb4, 0x2d, 0xa3, 0x14, 0xc4, 0x76, 0xf7, 0x76, 0x6b, 0xf9, 0x19, 0x34, 0x0f, 0xd9, 0xda,
	0x8f, 0x1a, 0x35, 0xbc, 0x5b, 0xd9, 0xd6, 0xf7, 0x76, 0xb7, 0x9f, 0xe5, 0x35, 0x94, 0x84, 0x68,
	0x65, 0x7b, 0x3b, 0x1f, 0x29, 0xfd, 0x36, 0x0e, 0x71, 0xe1, 0x52, 0x68, 0x0b, 0xe2, 0x5d, 0x83,
	0x35, 0xdb, 0x62, 0x33, 0x67, 0x98, 0x81, 0x40, 0xee, 0x70, 0x54, 0x35, 0xc7, 0x3d, 0x50, 0x78,
	0xf1, 0xaf, 0xb4, 0x48, 0x5e, 0xc3, 0x92, 0x19, 0xdd, 0x83, 0xb8, 0x80, 0xaa, 0xed, 0x5f, 0x3b,
	0x53, 0x8a, 0x34, 0x8d, 0xfa, 0x0c, 0x96, 0x78, 0xf4, 0x03, 0x48, 0x51, 0x62, 0x5a, 0x94, 0x34,
	0x59, 0x21, 0x2a, 0x78, 0x43, 0xdd, 0x0c, 0x2b, 0x4c, 0xc0, 0x1e, 0x70, 0xa1, 0x7b, 0x90, 0xea,
	0x12, 0x66, 0x98, 0x06, 0x33, 0x44, 0x08, 0xc8, 0xac, 0x5f, 0x0d, 0x31, 0xa8, 0x1d, 0x05, 0xc1,
	0x01, 0x18, 0xdd, 0x87, 0xb4, 0x49, 0x9a, 0x0e, 0x35, 0x98, 0x43, 0x0b, 0xf1, 0x30, 0x83, 0x96,
	0x6b, 0x6f, 0xf9, 0x20, 0x3c, 0xc0, 0x07, 0x8e, 0x90, 0x98, 0xde, 0x11, 0x0e, 0x60, 0x4e, 0x6e,
	0x59, 0xf7, 0x0d, 0xb2, 0x90, 0x14, 0xdc, 0xab, 0xa1, 0xab, 0x0a, 0x28, 0x56, 0xc8, 0xe0, 0xdc,
	0x39, 0x73, 0x84, 0x8e, 0x3e, 0x0a, 0xb3, 0xe1, 0x94, 0xb0, 0xe1, 0xf2, 0x99, 0x4a, 0xf8, 0x06,
	0x58, 0x6f, 0x75, 0x0e, 0x12, 0x86, 0x38, 0x14, 0x8a, 0x7f, 0xf2, 0xe5, 0xa7, 0x51, 0xad, 0xf4,
	0x45, 0x02, 0xe6, 0x3e, 0x24, 0x56, 0xab, 0xcd, 0x88, 0xa9, 0xc2, 0x27, 0x7a, 0x06, 0xa9, 0x20,
	0x08, 0x6b, 0xe2, 0x50, 0x77, 0xc2, 0x0e, 0x35, 0xc6, 0x56, 0x56, 0xff, 0x25, 0x79, 0x24, 0xe9,
	0x04, 0xe2, 0xd0, 0x77, 0x00, 0xd1, 0x9e, 0xcd, 0xac, 0x2e, 0xd1, 0x5f, 0x92, 0xbe, 0xee, 0x52,
	0x72, 0x68, 0x9d, 0x88, 0xfd, 0xa7, 0x71, 0x5e, 0xcd, 0x3c, 0x21, 0xfd, 0x7d, 0x41, 0x47, 0x8f,
	0x61, 0x96, 0x39, 0xcc, 0xe8, 0xe8, 0xc7, 0x42, 0xa6, 0x32, 0xd5, 0xd7, 0x4e, 0x9d, 0xf3, 0x83,
	0x47, 0x36, 0xbb, 0xbb, 0x2e, 0xe2, 0x96, 0x4a, 0x87, 0xb7, 0x23, 0xab, 0x1a, 0xce, 0x08, 0x66,
	0xb9, 0x9f, 0xe2, 0x7f, 0x62, 0x90, 0x1d, 0xd9, 0xe1, 0xa4, 0x34, 0xba, 0x01, 0x09, 0xb5, 0x6c,
	0x64, 0xf2, 0xb2, 0x58, 0x61, 0x51, 0x15, 0x72, 0xbe, 0xa9, 0xeb, 0xd2, 0xc3, 0xa3, 0x93, 0xbd,
	0x23, 0xeb, 0xb3, 0x08, 0x6f, 0x3f, 0x27, 0xfb, 0xc4, 0xbe, 0x6a, 0xf6, 0x39, 0x27, 0x2d, 0xc4,
	0xbf, 0xe6, 0xb4, 0x90, 0x38, 0x3f, 0x2d, 0xd0, 0xb3, 0x5d, 0xea, 0xc1, 0x85, 0xad, 0xef, 0x1b,
	0xe0, 0x6a, 0x8f, 0x63, 0xa9, 0x64, 0x3e, 0x55, 0xfa, 0x6f, 0x04, 0x60, 0x10, 0xc8, 0x51, 0x01,
	0x12, 0xca, 0xe6, 0x85, 0xf0, 0xfa, 0x0c, 0x56, 0x63, 0xb4, 0x00, 0x31, 0xd7, 0x60, 0x6d, 0xe9,
	0x0b, 0xf5, 0x19, 0x2c, 0x46, 0x68, 0x11, 0xe2, 0x94, 0xb4, 0xc8, 0x89, 0xb0, 0xa2, 0xb4, 0x08,
	0xe0, 0x7c, 0x88, 0x2a, 0x90, 0x6b, 0x1a, 0x1e, 0xd1, 0x3d, 0x62, 0x7b, 0x16, 0xb3, 0x8e, 0x88,
	0x0a, 0xc2, 0xc5, 0x53, 0x1b, 0xab, 0x3a, 0x4e, 0x47, 0x9a, 0x68, 0x96, 0x73, 0x1c, 0xf8, 0x0c,
	0xe8, 0x1d, 0x48, 0x2a, 0x87, 0x53, 0x61, 0x78, 0x25, 0x44, 0xf5, 0x58, 0x22, 0xa4, 0xa5, 0x63,
	0x9f, 0x01, 0xdd, 0x87, 0xa4, 0x52, 0xb0, 0xaa, 0xad, 0xae, 0x87, 0xa9, 0x48, 0xaa, 0x58, 0x1c,
	0x9c, 0x50, 0xec, 0x73, 0xa0, 0x06, 0xe4, 0x3f, 0xee, 0x11, 0xda, 0xd7, 0x5d, 0x83, 0x1a, 0x5d,
	0x22, 0xc2, 0x8c, 0x2c, 0xab, 0xbe, 0x15, 0x26, 0xe5, 0x87, 0x1c, 0xbb, 0xef, 0x43, 0x7d, 0x69,
	0x73, 0x1f, 0x8f, 0x90, 0xbd, 0xea, 0x12, 0xe4, 0xf8, 0x8d, 0xe9, 0x9e, 0x4b, 0x9a, 0xd6, 0xa1,
	0x45, 0xa8, 0x1f, 0xe1, 0x3e, 0x89, 0x00, 0x0c, 0x2a, 0x2a, 0x74, 0x1d, 0x66, 0x8d, 0x4e, 0xc7,
	0x39, 0xd6, 0x1d, 0x6a, 0xb5, 0x2c, 0x5b, 0x04, 0xb8, 0x34, 0xce, 0x08, 0xda, 0x9e, 0x20, 0xa1,
	0x1b, 0x90, 0x95, 0x90, 0x2e, 0x61, 0x6d, 0xc7, 0xf4, 0x54, 0x7c, 0x92, 0x7c, 0x3b, 0x92, 0x36,
	0x00, 0xf9, 0x17, 0x11, 0x1d, 0x02, 0x29, 0xe3, 0x46, 0xb7, 0x20, 0x47, 0x4e, 0x5c, 0x67, 0xe0,
	0x0f, 0x42, 0x4d, 0x69, 0x9c, 0x95, 0x54, 0x1f, 0xb6, 0x04, 0xc9, 0xae, 0x71, 0xa2, 0x1b, 0x2d,
	0xa9, 0x8a, 0x34, 0x4e, 0x74, 0x8d, 0x93, 0x4a, 0x8b, 0xa0, 0x87, 0x30, 0x2f, 0x17, 0x69, 0x52,
	0x62, 0x12, 0x9b, 0x59, 0x46, 0xc7, 0x53, 0xc9, 0xef, 0x3c, 0x4d, 0xe7, 0x05, 0xd3, 0xe6, 0x80,
	0x07, 0x6d, 0x40, 0x92, 0xd8, 0xc6, 0x8b, 0x0e, 0x31, 0x55, 0xf6, 0x3b, 0x8f, 0xdd, 0x87, 0x96,
	0xfe, 0x88, 0x20, 0x33, 0x54, 0x3f, 0xa0, 0x22, 0x24, 0x55, 0x24, 0x0f, 0xcc, 0xd7, 0x27, 0xa0,
	0x37, 0x20, 0xa7, 0x3e, 0xd5, 0x59, 0x03, 0x4b, 0xce, 0x2a, 0xba, 0x3c, 0x2d, 0xc2, 0x30, 0x7f,
	0xac, 0x7c, 0x77, 0x50, 0xeb, 0xcb, 0x20, 0x79, 0x63, 0x0a, 0x47, 0xaf, 0xcf, 0xe0, 0xfc, 0xf1,
	0x28, 0xc9, 0x0b, 0x89, 0xba, 0xb1, 0x0b, 0x47, 0xdd, 0x5b, 0x90, 0x93, 0xae, 0xa8, 0x53, 0x72,
	0x4c, 0x2d, 0xe6, 0xeb, 0x22, 0x2b, 0xa9, 0x58, 0x12, 0xd1, 0x0d, 0x98, 0x6d, 0x3b, 0x1e, 0x0b,
	0x40, 0x09, 0x71, 0x4a, 0x0d, 0x67, 0x38, 0xd5, 0x07, 0xd5, 0x61, 0xde, 0xe8, 0x31, 0x47, 0x1f,
	0x41, 0x4e, 0xbc, 0xf8, 0xba, 0x86, 0xe7, 0x38, 0x5b, 0x7d, 0x48, 0xd2, 0xdb, 0x90, 0xe4, 0x1e,
	0xe7, 0xf4, 0x98, 0xea, 0x18, 0xae, 0x9c, 0xe2, 0xdf, 0x52, 0xad, 0x69, 0x35, 0xf6, 0x87, 0x7f,
	0x5d, 0xd3, 0xb0, 0x8f, 0x47, 0xbb, 0x30, 0x4b, 0x09, 0xe3, 0x7e, 0x26, 0x2c, 0x5f, 0x75, 0x0f,
	0xdf, 0x9e, 0x50, 0x24, 0x96, 0x31, 0xe7, 0x51, 0xed, 0x47, 0x86, 0x0e, 0x06, 0xa8, 0x05, 0x97,
	0xfd, 0xb4, 0xd4, 0xb5, 0x28, 0x75, 0xa8, 0x2f, 0x18, 0x84, 0xe0, 0xbb, 0x93, 0x05, 0x0b, 0xe6,
	0x1d, 0xc1, 0xab, 0x16, 0xf0, 0x93, 0xd4, 0x30, 0x11, 0xbd, 0x07, 0x29, 0x97, 0x5a, 0x0e, 0xb5,
	0x58, 0xbf, 0x90, 0x11, 0xed, 0x65, 0x29, 0x2c, 0x34, 0x39, 0x3d, 0x66, 0xd9, 0xad, 0x7d, 0x85,
	0xc4, 0x01, 0xcf, 0x39, 0xf9, 0x73, 0xf6, 0xab, 0xe6, 0xcf, 0xb1, 0xc6, 0x32, 0x7b, 0xd1, 0xc6,
	0x72, 0x0f, 0x16, 0x2d, 0xbb, 0xd9, 0xe9, 0x99, 0x44, 0x3f, 0x6a, 0xeb, 0xc3, 0xa2, 0x72, 0x13,
	0xdd, 0xf2, 0x92, 0xe2, 0x7c, 0xda, 0xc6, 0x03, 0x81, 0x4f, 0x20, 0xd3, 0x36, 0xbc, 0xb6, 0xaf,
	0x8a, 0x39, 0xb1, 0xa1, 0xdb, 0x93, 0x54, 0x51, 0x37, 0xbc, 0xb6, 0xd2, 0x00, 0xb4, 0x83, 0x6f,
	0xf4, 0x3e, 0x64, 0x7b, 0x1e, 0xd1, 0x8f, 0xc9, 0x0b, 0xcf, 0x69, 0xbe, 0x24, 0xac, 0x90, 0x9f,
	0xb8, 0xa9, 0xd9, 0x9e, 0x47, 0x3e, 0xf4, 0xf1, 0x41, 0x73, 0x3b, 0x7f, 0x81, 0xe6, 0xf6, 0x9c,
	0x92, 0x04, 0x7d, 0xcd, 0x25, 0xc9, 0xa5, 0xf3, 0x4b, 0x92, 0x5f, 0x6b, 0x70, 0xcd, 0x8f, 0x69,
	0xb6, 0xc3, 0xf4, 0x43, 0xa7, 0x67, 0x9b, 0x41, 0x1b, 0xa1, 0x37, 0x1d, 0x93, 0x14, 0x16, 0x84,
	0x7d, 0xde, 0x9f, 0x74, 0xe1, 0x2a, 0x52, 0xed, 0x3a, 0xec, 0x01, 0x17, 0xe2, 0x37, 0x12, 0x9b,
	0x8e, 0x49, 0x54, 0xa5, 0xfc, 0x0b, 0xd1, 0xd8, 0x5d, 0x6d, 0x9e, 0x0d, 0x2c, 0xfe, 0x45, 0x83,
	0xcc, 0x90, 0x77, 0xa2, 0x2b, 0xbc, 0x8b, 0xe3, 0x0e, 0xee, 0xd8, 0xaa, 0x56, 0x49, 0x8a, 0xf1,
	0x9e, 0x8d, 0xde, 0x85, 0x8c, 0xdd, 0xeb, 0xea, 0x7c, 0x68, 0x11, 0x6f, 0xaa, 0x0a, 0x16, 0xec,
	0x5e, 0x17, 0x4b, 0x3c, 0x7a, 0x08, 0xbc, 0x56, 0xd2, 0xb9, 0x6c, 0x3f, 0xfa, 0x44, 0xa7, 0x8b,
	0x3e, 0x59, 0x97, 0xd0, 0x06, 0xed, 0x37, 0x24, 0x57, 0xf1, 0x39, 0x5c, 0x0a, 0x71, 0x7b, 0x74,
	0x63, 0x2c, 0x91, 0x0c, 0x57, 0xdf, 0x41, 0x46, 0xb9, 0x06, 0x99, 0xa1, 0x5e, 0x41, 0x25, 0x61,
	0x18, 0x34, 0x09, 0xc5, 0x9f, 0xc7, 0x00, 0x06, 0x96, 0x8c, 0x9e, 0x40, 0x42, 0x65, 0x1e, 0xd9,
	0x54, 0xdf, 0x99, 0xde, 0x0b, 0x94, 0x3d, 0xf1, 0x72, 0x4c, 0x8a, 0xe0, 0xc2, 0x9a, 0x8e, 0xf3,
	0xd2, 0xf2, 0x2b, 0xbe, 0x8b, 0x08, 0xdb, 0x14, 0x8c, 0x5c, 0x98, 0x14, 0x81, 0x8e, 0xe0, 0x72,
	0xd3, 0xb1, 0x6d, 0x22, 0x90, 0xba, 0x4b, 0x1d, 0x97, 0x50, 0x66, 0x11, 0x3f, 0xed, 0xbd, 0x7f,
	0x21, 0xd9, 0xbe, 0x9c, 0xfd, 0x40, 0x4c, 0x7d, 0x06, 0x2f, 0x34, 0x43, 0xe8, 0xc5, 0x0d, 0x48,
	0xa8, 0xa4, 0x7b, 0x1b, 0x32, 0xf2, 0x60, 0x7a, 0x78, 0xcb, 0x03, 0x72, 0x76, 0xd7, 0xe8, 0x92,
	0xe2, 0x47, 0x90, 0x90, 0x27, 0x98, 0xd4, 0x21, 0xdd, 0x81, 0x28, 0x63, 0x1d, 0x75, 0x41, 0x13,
	0x2d, 0x83, 0x63, 0x8b, 0x77, 0x61, 0x21, 0xec, 0x04, 0xe8, 0x2a, 0xa4, 0x3d, 0xa7, 0x47, 0x9b,
	0x44, 0xb7, 0x5c, 0xb1, 0x5c, 0x0a, 0xa7, 0x24, 0xe1, 0x91, 0x5b, 0xbd, 0x02, 0x79, 0x19, 0xde,
	0x4e, 0x17, 0x77, 0x35, 0xb8, 0x7a, 0x8e, 0x6b, 0xa1, 0x25, 0xb8, 0x74, 0x50, 0xc3, 0x4f, 0x1f,
	0x6d, 0xd6, 0xf4, 0x0f, 0x76, 0x2b, 0x4f, 0x2b, 0x8f, 0xb6, 0x2b, 0xd5, 0xed, 0x5a, 0x7e, 0x06,
	0x65, 0x21, 0xbd, 0xbb, 0xd7, 0xd0, 0x1f, 0xec, 0x7d, 0xb0, 0xbb, 0x95, 0xd7, 0xaa, 0x45, 0x98,
	0xf7, 0x1d, 0x7d, 0x7c, 0x89, 0x6a, 0x01, 0x16, 0x87, 0xd3, 0xf8, 0x00, 0xf0, 0x38, 0x96, 0xba,
	0x9c, 0x5f, 0x2c, 0xfd, 0x3d, 0x0a, 0xb9, 0xd1, 0x87, 0x12, 0x5e, 0x1b, 0x2a, 0x16, 0xf5, 0xc6,
	0x22, 0xbd, 0x73, 0x56, 0x96, 0x08, 0xea, 0x05, 0xe5, 0x16, 0x64, 0x45, 0xc1, 0x1a, 0x80, 0xfc,
	0x7a, 0x69, 0x96, 0x93, 0x03, 0x58, 0x1b, 0xb2, 0xa3, 0x11, 0x27, 0x2a, 0x22, 0xce, 0xbd, 0xc9,
	0xef, 0x35, 0xc1, 0xf0, 0xcc, 0x68, 0x33, 0x4b, 0x87, 0x2f, 0xeb, 0x16, 0xe4, 0xda, 0x8c, 0xb9,
	0xde, 0x60, 0x47, 0x31, 0xa1, 0x88, 0xac, 0xa0, 0x06, 0x1b, 0x7a, 0x23, 0xbc, 0x4e, 0xe2, 0x85,
	0xde, 0x68, 0xa5, 0x74, 0x0d, 0x32, 0x1e, 0xa3, 0x96, 0xab, 0x8b, 0x52, 0x5d, 0x14, 0x4a, 0x29,
	0x0c, 0x82, 0x24, 0x6a, 0xfa, 0xd2, 0x31, 0x2c, 0x84, 0x6d, 0x11, 0x5d, 0x86, 0xf9, 0x9d, 0xbd,
	0xa7, 0xb5, 0x2d, 0x7d, 0xbf, 0x86, 0x77, 0x2a, 0xbb, 0xb5, 0xdd, 0xc6, 0xf6, 0xb3, 0xfc, 0x0c,
	0x4a, 0x43, 0x5c, 0xe9, 0x8b, 0xab, 0xef, 0xa0, 0x56, 0xd3, 0xf7, 0x1a, 0xf5, 0x1a, 0xce, 0x47,
	0xd0, 0x22, 0xa0, 0x46, 0x6d, 0x67, 0x7f, 0x0f, 0x57, 0xf0, 0x33, 0x1d, 0xd7, 0xb6, 0x1e, 0xe1,
	0xda, 0x66, 0x23, 0x1f, 0xe5, 0xf4, 0x40, 0xc4, 0x80, 0x1e, 0xe3, 0x2a, 0x55, 0x57, 0x3f, 0xa6,
	0xd2, 0x92, 0x03, 0x0b, 0x61, 0x4f, 0x40, 0xe8, 0x26, 0x24, 0x3c, 0x66, 0xb0, 0x9e, 0x27, 0x54,
	0x99, 0xad, 0xce, 0xf2, 0x5b, 0x4c, 0xde, 0x8e, 0xe7, 0xff, 0x11, 0x5b, 0x35, 0xb1, 0x9a, 0x43,
	0x77, 0x20, 0xf6, 0xc2, 0x31, 0xfb, 0xca, 0x23, 0x5e, 0x0f, 0xc9, 0x5b, 0x5b, 0x06, 0x33, 0x0e,
	0x84, 0x5d, 0x63, 0x01, 0x2d, 0x6d, 0x40, 0x3a, 0x78, 0xe9, 0x42, 0x6f, 0x40, 0x9a, 0x7b, 0x84,
	0xf0, 0x9a, 0xd3, 0x4e, 0x37, 0x98, 0x2b, 0xfd, 0x46, 0x83, 0xdc, 0xe8, 0x1b, 0x38, 0x0f, 0xa9,
	0xae, 0xc1, 0x18, 0xa1, 0x21, 0x9c, 0xfe, 0x4c, 0xe0, 0xd0, 0x91, 0x70, 0x87, 0x7e, 0x0b, 0x12,
	0xb2, 0xe5, 0x51, 0x46, 0x16, 0xda, 0x11, 0xaa, 0x70, 0x2e, 0x70, 0x58, 0xe1, 0x4b, 0x5f, 0xa4,
	0x21, 0x1d, 0x54, 0x25, 0xe8, 0x5d, 0x88, 0x7b, 0x8c, 0x77, 0x33, 0xda, 0x05, 0x1e, 0x6c, 0x0a,
	0x80, 0x25, 0x17, 0x37, 0x1c, 0xd3, 0xf2, 0x78, 0x0b, 0x32, 0x1c, 0xf8, 0x15, 0xe9, 0x09, 0xe9,
	0xa3, 0xc7, 0x90, 0x94, 0xaf, 0x58, 0xfe, 0x8f, 0x17, 0x37, 0xcf, 0xad, 0xc0, 0xca, 0x52, 0x89,
	0xa3, 0xbf, 0x83, 0x28, 0x01, 0xc5, 0x3f, 0xa5, 0x20, 0xa1, 0x94, 0xfc, 0x1c, 0x72, 0x2a, 0x08,
	0x0d, 0x27, 0xa7, 0x4c, 0xf8, 0x8f, 0x1b, 0xe3, 0xd2, 0xcb, 0x52, 0xad, 0x83, 0x2e, 0x25, 0xeb,
	0x0d, 0x13, 0xd0, 0x4f, 0xe1, 0x92, 0x49, 0x3c, 0x66, 0xd9, 0x42, 0x83, 0xc1, 0x0a, 0xd2, 0x54,
	0xee, 0x4d, 0xb5, 0xc2, 0xd6, 0x80, 0x7f, 0xb0, 0x0c, 0x32, 0x4f, 0x51, 0xd1, 0x8f, 0x61, 0x6e,
	0xac, 0x00, 0x56, 0x99, 0xe6, 0xee, 0x54, 0xeb, 0xe0, 0x91, 0xc2, 0xb7, 0x3e, 0x83, 0x73, 0xa3,
	0xa5, 0x30, 0xbf, 0x28, 0x5e, 0x41, 0x31, 0xc2, 0xab, 0x34, 0x4a, 0x3c, 0x4f, 0xb5, 0x5b, 0xeb,
	0x53, 0x8a, 0xe7, 0xac, 0x15, 0xc9, 0xc9, 0x2f, 0x8a, 0x0e, 0x13, 0x10, 0x86, 0x4c, 0x8b, 0xd8,
	0x84, 0x5a, 0x4d, 0xa1, 0x7d, 0xf9, 0x36, 0xb1, 0x36, 0x95, 0xe4, 0x87, 0x92, 0xef, 0x09, 0xe9,
	0xd7, 0x67, 0x30, 0xb4, 0x82, 0x11, 0x22, 0x80, 0x54, 0xfa, 0x13, 0xef, 0x33, 0xaa, 0x47, 0x94,
	0x8d, 0xf4, 0xf7, 0xa6, 0x12, 0x3d, 0x54, 0x70, 0x8a, 0x76, 0x91, 0xb7, 0xa1, 0xed, 0x31, 0x5a,
	0x71, 0x0e, 0xb2, 0x23, 0x56, 0x50, 0x5c, 0x00, 0x74, 0x5a, 0x69, 0x45, 0x9b, 0x27, 0x8c, 0x91,
	0x0b, 0xbd, 0x40, 0x7a, 0x46, 0x6f, 0x42, 0xce, 0x24, 0x5e, 0x93, 0x5a, 0x2e, 0x73, 0xe8, 0xc0,
	0x41, 0x86, 0xe1, 0xd9, 0x01, 0x80, 0xd7, 0x49, 0x73, 0x90, 0x1d, 0xb9, 0xf3, 0x62, 0x15, 0x60,
	0x70, 0x55, 0x68, 0x03, 0xf2, 0x43, 0x02, 0xe5, 0x33, 0xd7, 0xa9, 0x1d, 0xcc, 0x0d, 0x20, 0xe2,
	0xc0, 0xc5, 0xcf, 0x35, 0xc8, 0x8f, 0x5f, 0xca, 0xff, 0x27, 0x0a, 0xbd, 0x0b, 0xb3, 0xe4, 0xc4,
	0x25, 0x4d, 0xa6, 0xf4, 0x12, 0x99, 0xd8, 0x75, 0x64, 0x24, 0x5e, 0x2e, 0xfa, 0x70, 0xf0, 0x18,
	0x15, 0x9d, 0xf2, 0x31, 0x6a, 0x34, 0x14, 0x28, 0x6e, 0x5e, 0x67, 0xc8, 0xa8, 0x70, 0xba, 0xce,
	0xf8, 0x5d, 0x04, 0xb2, 0x23, 0x12, 0x26, 0xd5, 0x46, 0x0b, 0xc3, 0x0f, 0x86, 0x69, 0xf5, 0x2e,
	0x88, 0xde, 0x1c, 0x7e, 0xce, 0x3b, 0xff, 0x88, 0xea, 0xa1, 0xef, 0x3a, 0x64, 0xc8, 0x89, 0x11,
	0x5c, 0x4d, 0x4c, 0xa5, 0x5a, 0x10, 0x44, 0x79, 0xfe, 0xeb, 0x90, 0x11, 0x58, 0x05, 0xf1, 0xb3,
	0x31, 0x08, 0xa2, 0x84, 0xbc, 0xcd, 0xdb, 0x56, 0xbb, 0x35, 0x6a, 0xf8, 0x8b, 0xea, 0x9a, 0x58,
	0xdf, 0x25, 0xe5, 0x47, 0x36, 0xfb, 0xfe, 0x06, 0xe6, 0x18, 0xc1, 0xca, 0x3f, 0xe4, 0x4f, 0x4f,
	0xbc, 0xfc, 0x91, 0xa6, 0x29, 0x78, 0x87, 0x72, 0xe5, 0xcf, 0xe0, 0x72, 0xe8, 0xdb, 0xdc, 0xd4,
	0x57, 0x13, 0x0d, 0xbd, 0x9a, 0xd8, 0x94, 0x57, 0x53, 0x2d, 0xfe, 0xf9, 0xd5, 0xb2, 0xf6, 0xd9,
	0xab, 0x65, 0xed, 0xf3, 0x57, 0xcb, 0xda, 0xbf, 0x5f, 0x2d, 0x6b, 0x1f, 0xc9, 0x5f, 0xb7, 0x7e,
	0xa9, 0x69, 0x2f, 0x12, 0x82, 0xed, 0xee, 0xff, 0x02, 0x00, 0x00, 0xff, 0xff, 0x57, 0x21, 0x4f,
	0xef, 0x50, 0x20, 0x00, 0x00,
}
