// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: envoy/api/v2/core/grpc_service.proto

package core

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf2 "github.com/gogo/protobuf/types"
import google_protobuf4 "github.com/gogo/protobuf/types"
import _ "github.com/lyft/protoc-gen-validate/validate"
import _ "github.com/gogo/protobuf/gogoproto"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// gRPC service configuration. This is used by :ref:`ApiConfigSource
// <envoy_api_msg_core.ApiConfigSource>` and filter configurations.
type GrpcService struct {
	// Types that are valid to be assigned to TargetSpecifier:
	//	*GrpcService_EnvoyGrpc_
	//	*GrpcService_GoogleGrpc_
	TargetSpecifier isGrpcService_TargetSpecifier `protobuf_oneof:"target_specifier"`
	// The timeout for the gRPC request. This is the timeout for a specific
	// request.
	Timeout *google_protobuf2.Duration `protobuf:"bytes,3,opt,name=timeout" json:"timeout,omitempty"`
	// A set of credentials that will be composed to form the `channel credentials
	// <https://grpc.io/docs/guides/auth.html#credential-types>`_.
	Credentials []*GrpcService_Credentials `protobuf:"bytes,4,rep,name=credentials" json:"credentials,omitempty"`
	// Additional metadata to include in streams initiated to the GrpcService.
	// This can be used for scenarios in which additional ad hoc authorization
	// headers (e.g. `x-foo-bar: baz-key`) are to be injected.
	InitialMetadata []*HeaderValue `protobuf:"bytes,5,rep,name=initial_metadata,json=initialMetadata" json:"initial_metadata,omitempty"`
}

func (m *GrpcService) Reset()                    { *m = GrpcService{} }
func (m *GrpcService) String() string            { return proto.CompactTextString(m) }
func (*GrpcService) ProtoMessage()               {}
func (*GrpcService) Descriptor() ([]byte, []int) { return fileDescriptorGrpcService, []int{0} }

type isGrpcService_TargetSpecifier interface {
	isGrpcService_TargetSpecifier()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type GrpcService_EnvoyGrpc_ struct {
	EnvoyGrpc *GrpcService_EnvoyGrpc `protobuf:"bytes,1,opt,name=envoy_grpc,json=envoyGrpc,oneof"`
}
type GrpcService_GoogleGrpc_ struct {
	GoogleGrpc *GrpcService_GoogleGrpc `protobuf:"bytes,2,opt,name=google_grpc,json=googleGrpc,oneof"`
}

func (*GrpcService_EnvoyGrpc_) isGrpcService_TargetSpecifier()  {}
func (*GrpcService_GoogleGrpc_) isGrpcService_TargetSpecifier() {}

func (m *GrpcService) GetTargetSpecifier() isGrpcService_TargetSpecifier {
	if m != nil {
		return m.TargetSpecifier
	}
	return nil
}

func (m *GrpcService) GetEnvoyGrpc() *GrpcService_EnvoyGrpc {
	if x, ok := m.GetTargetSpecifier().(*GrpcService_EnvoyGrpc_); ok {
		return x.EnvoyGrpc
	}
	return nil
}

func (m *GrpcService) GetGoogleGrpc() *GrpcService_GoogleGrpc {
	if x, ok := m.GetTargetSpecifier().(*GrpcService_GoogleGrpc_); ok {
		return x.GoogleGrpc
	}
	return nil
}

func (m *GrpcService) GetTimeout() *google_protobuf2.Duration {
	if m != nil {
		return m.Timeout
	}
	return nil
}

func (m *GrpcService) GetCredentials() []*GrpcService_Credentials {
	if m != nil {
		return m.Credentials
	}
	return nil
}

func (m *GrpcService) GetInitialMetadata() []*HeaderValue {
	if m != nil {
		return m.InitialMetadata
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*GrpcService) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _GrpcService_OneofMarshaler, _GrpcService_OneofUnmarshaler, _GrpcService_OneofSizer, []interface{}{
		(*GrpcService_EnvoyGrpc_)(nil),
		(*GrpcService_GoogleGrpc_)(nil),
	}
}

func _GrpcService_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*GrpcService)
	// target_specifier
	switch x := m.TargetSpecifier.(type) {
	case *GrpcService_EnvoyGrpc_:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.EnvoyGrpc); err != nil {
			return err
		}
	case *GrpcService_GoogleGrpc_:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.GoogleGrpc); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("GrpcService.TargetSpecifier has unexpected type %T", x)
	}
	return nil
}

func _GrpcService_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*GrpcService)
	switch tag {
	case 1: // target_specifier.envoy_grpc
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(GrpcService_EnvoyGrpc)
		err := b.DecodeMessage(msg)
		m.TargetSpecifier = &GrpcService_EnvoyGrpc_{msg}
		return true, err
	case 2: // target_specifier.google_grpc
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(GrpcService_GoogleGrpc)
		err := b.DecodeMessage(msg)
		m.TargetSpecifier = &GrpcService_GoogleGrpc_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _GrpcService_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*GrpcService)
	// target_specifier
	switch x := m.TargetSpecifier.(type) {
	case *GrpcService_EnvoyGrpc_:
		s := proto.Size(x.EnvoyGrpc)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *GrpcService_GoogleGrpc_:
		s := proto.Size(x.GoogleGrpc)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type GrpcService_EnvoyGrpc struct {
	// The name of the upstream gRPC cluster. SSL credentials will be supplied
	// in the :ref:`Cluster <envoy_api_msg_Cluster>` :ref:`tls_context
	// <envoy_api_field_Cluster.tls_context>`.
	ClusterName string `protobuf:"bytes,1,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
}

func (m *GrpcService_EnvoyGrpc) Reset()         { *m = GrpcService_EnvoyGrpc{} }
func (m *GrpcService_EnvoyGrpc) String() string { return proto.CompactTextString(m) }
func (*GrpcService_EnvoyGrpc) ProtoMessage()    {}
func (*GrpcService_EnvoyGrpc) Descriptor() ([]byte, []int) {
	return fileDescriptorGrpcService, []int{0, 0}
}

func (m *GrpcService_EnvoyGrpc) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

type GrpcService_GoogleGrpc struct {
	// The target URI when using the `Google C++ gRPC client
	// <https://github.com/grpc/grpc>`_. SSL credentials will be supplied in
	// :ref:`credentials <envoy_api_field_core.GrpcService.credentials>`.
	TargetUri      string                                 `protobuf:"bytes,1,opt,name=target_uri,json=targetUri,proto3" json:"target_uri,omitempty"`
	SslCredentials *GrpcService_GoogleGrpc_SslCredentials `protobuf:"bytes,2,opt,name=ssl_credentials,json=sslCredentials" json:"ssl_credentials,omitempty"`
	// The human readable prefix to use when emitting statistics for the gRPC
	// service.
	//
	// .. csv-table::
	//    :header: Name, Type, Description
	//    :widths: 1, 1, 2
	//
	//    streams_total, Counter, Total number of streams opened
	//    streams_closed_<gRPC status code>, Counter, Total streams closed with <gRPC status code>
	StatPrefix string `protobuf:"bytes,3,opt,name=stat_prefix,json=statPrefix,proto3" json:"stat_prefix,omitempty"`
	// Additional configuration for site-specific customizations of the Google
	// gRPC library.
	Config *google_protobuf4.Struct `protobuf:"bytes,4,opt,name=config" json:"config,omitempty"`
}

func (m *GrpcService_GoogleGrpc) Reset()         { *m = GrpcService_GoogleGrpc{} }
func (m *GrpcService_GoogleGrpc) String() string { return proto.CompactTextString(m) }
func (*GrpcService_GoogleGrpc) ProtoMessage()    {}
func (*GrpcService_GoogleGrpc) Descriptor() ([]byte, []int) {
	return fileDescriptorGrpcService, []int{0, 1}
}

func (m *GrpcService_GoogleGrpc) GetTargetUri() string {
	if m != nil {
		return m.TargetUri
	}
	return ""
}

func (m *GrpcService_GoogleGrpc) GetSslCredentials() *GrpcService_GoogleGrpc_SslCredentials {
	if m != nil {
		return m.SslCredentials
	}
	return nil
}

func (m *GrpcService_GoogleGrpc) GetStatPrefix() string {
	if m != nil {
		return m.StatPrefix
	}
	return ""
}

func (m *GrpcService_GoogleGrpc) GetConfig() *google_protobuf4.Struct {
	if m != nil {
		return m.Config
	}
	return nil
}

// See https://grpc.io/grpc/cpp/structgrpc_1_1_ssl_credentials_options.html.
type GrpcService_GoogleGrpc_SslCredentials struct {
	// PEM encoded server root certificates.
	RootCerts *DataSource `protobuf:"bytes,1,opt,name=root_certs,json=rootCerts" json:"root_certs,omitempty"`
	// PEM encoded client private key.
	PrivateKey *DataSource `protobuf:"bytes,2,opt,name=private_key,json=privateKey" json:"private_key,omitempty"`
	// PEM encoded client certificate chain.
	CertChain *DataSource `protobuf:"bytes,3,opt,name=cert_chain,json=certChain" json:"cert_chain,omitempty"`
}

func (m *GrpcService_GoogleGrpc_SslCredentials) Reset()         { *m = GrpcService_GoogleGrpc_SslCredentials{} }
func (m *GrpcService_GoogleGrpc_SslCredentials) String() string { return proto.CompactTextString(m) }
func (*GrpcService_GoogleGrpc_SslCredentials) ProtoMessage()    {}
func (*GrpcService_GoogleGrpc_SslCredentials) Descriptor() ([]byte, []int) {
	return fileDescriptorGrpcService, []int{0, 1, 0}
}

func (m *GrpcService_GoogleGrpc_SslCredentials) GetRootCerts() *DataSource {
	if m != nil {
		return m.RootCerts
	}
	return nil
}

func (m *GrpcService_GoogleGrpc_SslCredentials) GetPrivateKey() *DataSource {
	if m != nil {
		return m.PrivateKey
	}
	return nil
}

func (m *GrpcService_GoogleGrpc_SslCredentials) GetCertChain() *DataSource {
	if m != nil {
		return m.CertChain
	}
	return nil
}

// gRPC credentials as described at
// https://grpc.io/docs/guides/auth.html#credential-types.
//
// .. note::
//
//   Credentials are only currently implemented for the Google gRPC client.
type GrpcService_Credentials struct {
	// Types that are valid to be assigned to CredentialSpecifier:
	//	*GrpcService_Credentials_AccessToken
	CredentialSpecifier isGrpcService_Credentials_CredentialSpecifier `protobuf_oneof:"credential_specifier"`
}

func (m *GrpcService_Credentials) Reset()         { *m = GrpcService_Credentials{} }
func (m *GrpcService_Credentials) String() string { return proto.CompactTextString(m) }
func (*GrpcService_Credentials) ProtoMessage()    {}
func (*GrpcService_Credentials) Descriptor() ([]byte, []int) {
	return fileDescriptorGrpcService, []int{0, 2}
}

type isGrpcService_Credentials_CredentialSpecifier interface {
	isGrpcService_Credentials_CredentialSpecifier()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type GrpcService_Credentials_AccessToken struct {
	AccessToken string `protobuf:"bytes,1,opt,name=access_token,json=accessToken,proto3,oneof"`
}

func (*GrpcService_Credentials_AccessToken) isGrpcService_Credentials_CredentialSpecifier() {}

func (m *GrpcService_Credentials) GetCredentialSpecifier() isGrpcService_Credentials_CredentialSpecifier {
	if m != nil {
		return m.CredentialSpecifier
	}
	return nil
}

func (m *GrpcService_Credentials) GetAccessToken() string {
	if x, ok := m.GetCredentialSpecifier().(*GrpcService_Credentials_AccessToken); ok {
		return x.AccessToken
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*GrpcService_Credentials) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _GrpcService_Credentials_OneofMarshaler, _GrpcService_Credentials_OneofUnmarshaler, _GrpcService_Credentials_OneofSizer, []interface{}{
		(*GrpcService_Credentials_AccessToken)(nil),
	}
}

func _GrpcService_Credentials_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*GrpcService_Credentials)
	// credential_specifier
	switch x := m.CredentialSpecifier.(type) {
	case *GrpcService_Credentials_AccessToken:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.AccessToken)
	case nil:
	default:
		return fmt.Errorf("GrpcService_Credentials.CredentialSpecifier has unexpected type %T", x)
	}
	return nil
}

func _GrpcService_Credentials_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*GrpcService_Credentials)
	switch tag {
	case 1: // credential_specifier.access_token
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.CredentialSpecifier = &GrpcService_Credentials_AccessToken{x}
		return true, err
	default:
		return false, nil
	}
}

func _GrpcService_Credentials_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*GrpcService_Credentials)
	// credential_specifier
	switch x := m.CredentialSpecifier.(type) {
	case *GrpcService_Credentials_AccessToken:
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.AccessToken)))
		n += len(x.AccessToken)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

func init() {
	proto.RegisterType((*GrpcService)(nil), "envoy.api.v2.core.GrpcService")
	proto.RegisterType((*GrpcService_EnvoyGrpc)(nil), "envoy.api.v2.core.GrpcService.EnvoyGrpc")
	proto.RegisterType((*GrpcService_GoogleGrpc)(nil), "envoy.api.v2.core.GrpcService.GoogleGrpc")
	proto.RegisterType((*GrpcService_GoogleGrpc_SslCredentials)(nil), "envoy.api.v2.core.GrpcService.GoogleGrpc.SslCredentials")
	proto.RegisterType((*GrpcService_Credentials)(nil), "envoy.api.v2.core.GrpcService.Credentials")
}
func (this *GrpcService) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*GrpcService)
	if !ok {
		that2, ok := that.(GrpcService)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if that1.TargetSpecifier == nil {
		if this.TargetSpecifier != nil {
			return false
		}
	} else if this.TargetSpecifier == nil {
		return false
	} else if !this.TargetSpecifier.Equal(that1.TargetSpecifier) {
		return false
	}
	if !this.Timeout.Equal(that1.Timeout) {
		return false
	}
	if len(this.Credentials) != len(that1.Credentials) {
		return false
	}
	for i := range this.Credentials {
		if !this.Credentials[i].Equal(that1.Credentials[i]) {
			return false
		}
	}
	if len(this.InitialMetadata) != len(that1.InitialMetadata) {
		return false
	}
	for i := range this.InitialMetadata {
		if !this.InitialMetadata[i].Equal(that1.InitialMetadata[i]) {
			return false
		}
	}
	return true
}
func (this *GrpcService_EnvoyGrpc_) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*GrpcService_EnvoyGrpc_)
	if !ok {
		that2, ok := that.(GrpcService_EnvoyGrpc_)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.EnvoyGrpc.Equal(that1.EnvoyGrpc) {
		return false
	}
	return true
}
func (this *GrpcService_GoogleGrpc_) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*GrpcService_GoogleGrpc_)
	if !ok {
		that2, ok := that.(GrpcService_GoogleGrpc_)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.GoogleGrpc.Equal(that1.GoogleGrpc) {
		return false
	}
	return true
}
func (this *GrpcService_EnvoyGrpc) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*GrpcService_EnvoyGrpc)
	if !ok {
		that2, ok := that.(GrpcService_EnvoyGrpc)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.ClusterName != that1.ClusterName {
		return false
	}
	return true
}
func (this *GrpcService_GoogleGrpc) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*GrpcService_GoogleGrpc)
	if !ok {
		that2, ok := that.(GrpcService_GoogleGrpc)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.TargetUri != that1.TargetUri {
		return false
	}
	if !this.SslCredentials.Equal(that1.SslCredentials) {
		return false
	}
	if this.StatPrefix != that1.StatPrefix {
		return false
	}
	if !this.Config.Equal(that1.Config) {
		return false
	}
	return true
}
func (this *GrpcService_GoogleGrpc_SslCredentials) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*GrpcService_GoogleGrpc_SslCredentials)
	if !ok {
		that2, ok := that.(GrpcService_GoogleGrpc_SslCredentials)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.RootCerts.Equal(that1.RootCerts) {
		return false
	}
	if !this.PrivateKey.Equal(that1.PrivateKey) {
		return false
	}
	if !this.CertChain.Equal(that1.CertChain) {
		return false
	}
	return true
}
func (this *GrpcService_Credentials) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*GrpcService_Credentials)
	if !ok {
		that2, ok := that.(GrpcService_Credentials)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if that1.CredentialSpecifier == nil {
		if this.CredentialSpecifier != nil {
			return false
		}
	} else if this.CredentialSpecifier == nil {
		return false
	} else if !this.CredentialSpecifier.Equal(that1.CredentialSpecifier) {
		return false
	}
	return true
}
func (this *GrpcService_Credentials_AccessToken) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*GrpcService_Credentials_AccessToken)
	if !ok {
		that2, ok := that.(GrpcService_Credentials_AccessToken)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.AccessToken != that1.AccessToken {
		return false
	}
	return true
}
func (m *GrpcService) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GrpcService) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.TargetSpecifier != nil {
		nn1, err := m.TargetSpecifier.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn1
	}
	if m.Timeout != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGrpcService(dAtA, i, uint64(m.Timeout.Size()))
		n2, err := m.Timeout.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if len(m.Credentials) > 0 {
		for _, msg := range m.Credentials {
			dAtA[i] = 0x22
			i++
			i = encodeVarintGrpcService(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.InitialMetadata) > 0 {
		for _, msg := range m.InitialMetadata {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintGrpcService(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *GrpcService_EnvoyGrpc_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.EnvoyGrpc != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGrpcService(dAtA, i, uint64(m.EnvoyGrpc.Size()))
		n3, err := m.EnvoyGrpc.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	return i, nil
}
func (m *GrpcService_GoogleGrpc_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.GoogleGrpc != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGrpcService(dAtA, i, uint64(m.GoogleGrpc.Size()))
		n4, err := m.GoogleGrpc.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	return i, nil
}
func (m *GrpcService_EnvoyGrpc) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GrpcService_EnvoyGrpc) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ClusterName) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGrpcService(dAtA, i, uint64(len(m.ClusterName)))
		i += copy(dAtA[i:], m.ClusterName)
	}
	return i, nil
}

func (m *GrpcService_GoogleGrpc) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GrpcService_GoogleGrpc) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.TargetUri) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGrpcService(dAtA, i, uint64(len(m.TargetUri)))
		i += copy(dAtA[i:], m.TargetUri)
	}
	if m.SslCredentials != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGrpcService(dAtA, i, uint64(m.SslCredentials.Size()))
		n5, err := m.SslCredentials.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if len(m.StatPrefix) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGrpcService(dAtA, i, uint64(len(m.StatPrefix)))
		i += copy(dAtA[i:], m.StatPrefix)
	}
	if m.Config != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintGrpcService(dAtA, i, uint64(m.Config.Size()))
		n6, err := m.Config.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	return i, nil
}

func (m *GrpcService_GoogleGrpc_SslCredentials) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GrpcService_GoogleGrpc_SslCredentials) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RootCerts != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintGrpcService(dAtA, i, uint64(m.RootCerts.Size()))
		n7, err := m.RootCerts.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.PrivateKey != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGrpcService(dAtA, i, uint64(m.PrivateKey.Size()))
		n8, err := m.PrivateKey.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.CertChain != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGrpcService(dAtA, i, uint64(m.CertChain.Size()))
		n9, err := m.CertChain.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	return i, nil
}

func (m *GrpcService_Credentials) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GrpcService_Credentials) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.CredentialSpecifier != nil {
		nn10, err := m.CredentialSpecifier.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn10
	}
	return i, nil
}

func (m *GrpcService_Credentials_AccessToken) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0xa
	i++
	i = encodeVarintGrpcService(dAtA, i, uint64(len(m.AccessToken)))
	i += copy(dAtA[i:], m.AccessToken)
	return i, nil
}
func encodeVarintGrpcService(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *GrpcService) Size() (n int) {
	var l int
	_ = l
	if m.TargetSpecifier != nil {
		n += m.TargetSpecifier.Size()
	}
	if m.Timeout != nil {
		l = m.Timeout.Size()
		n += 1 + l + sovGrpcService(uint64(l))
	}
	if len(m.Credentials) > 0 {
		for _, e := range m.Credentials {
			l = e.Size()
			n += 1 + l + sovGrpcService(uint64(l))
		}
	}
	if len(m.InitialMetadata) > 0 {
		for _, e := range m.InitialMetadata {
			l = e.Size()
			n += 1 + l + sovGrpcService(uint64(l))
		}
	}
	return n
}

func (m *GrpcService_EnvoyGrpc_) Size() (n int) {
	var l int
	_ = l
	if m.EnvoyGrpc != nil {
		l = m.EnvoyGrpc.Size()
		n += 1 + l + sovGrpcService(uint64(l))
	}
	return n
}
func (m *GrpcService_GoogleGrpc_) Size() (n int) {
	var l int
	_ = l
	if m.GoogleGrpc != nil {
		l = m.GoogleGrpc.Size()
		n += 1 + l + sovGrpcService(uint64(l))
	}
	return n
}
func (m *GrpcService_EnvoyGrpc) Size() (n int) {
	var l int
	_ = l
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovGrpcService(uint64(l))
	}
	return n
}

func (m *GrpcService_GoogleGrpc) Size() (n int) {
	var l int
	_ = l
	l = len(m.TargetUri)
	if l > 0 {
		n += 1 + l + sovGrpcService(uint64(l))
	}
	if m.SslCredentials != nil {
		l = m.SslCredentials.Size()
		n += 1 + l + sovGrpcService(uint64(l))
	}
	l = len(m.StatPrefix)
	if l > 0 {
		n += 1 + l + sovGrpcService(uint64(l))
	}
	if m.Config != nil {
		l = m.Config.Size()
		n += 1 + l + sovGrpcService(uint64(l))
	}
	return n
}

func (m *GrpcService_GoogleGrpc_SslCredentials) Size() (n int) {
	var l int
	_ = l
	if m.RootCerts != nil {
		l = m.RootCerts.Size()
		n += 1 + l + sovGrpcService(uint64(l))
	}
	if m.PrivateKey != nil {
		l = m.PrivateKey.Size()
		n += 1 + l + sovGrpcService(uint64(l))
	}
	if m.CertChain != nil {
		l = m.CertChain.Size()
		n += 1 + l + sovGrpcService(uint64(l))
	}
	return n
}

func (m *GrpcService_Credentials) Size() (n int) {
	var l int
	_ = l
	if m.CredentialSpecifier != nil {
		n += m.CredentialSpecifier.Size()
	}
	return n
}

func (m *GrpcService_Credentials_AccessToken) Size() (n int) {
	var l int
	_ = l
	l = len(m.AccessToken)
	n += 1 + l + sovGrpcService(uint64(l))
	return n
}

func sovGrpcService(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozGrpcService(x uint64) (n int) {
	return sovGrpcService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *GrpcService) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGrpcService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GrpcService: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GrpcService: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnvoyGrpc", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGrpcService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGrpcService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &GrpcService_EnvoyGrpc{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.TargetSpecifier = &GrpcService_EnvoyGrpc_{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GoogleGrpc", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGrpcService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGrpcService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &GrpcService_GoogleGrpc{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.TargetSpecifier = &GrpcService_GoogleGrpc_{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGrpcService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGrpcService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Timeout == nil {
				m.Timeout = &google_protobuf2.Duration{}
			}
			if err := m.Timeout.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Credentials", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGrpcService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGrpcService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Credentials = append(m.Credentials, &GrpcService_Credentials{})
			if err := m.Credentials[len(m.Credentials)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitialMetadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGrpcService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGrpcService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.InitialMetadata = append(m.InitialMetadata, &HeaderValue{})
			if err := m.InitialMetadata[len(m.InitialMetadata)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGrpcService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGrpcService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GrpcService_EnvoyGrpc) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGrpcService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EnvoyGrpc: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EnvoyGrpc: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGrpcService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGrpcService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGrpcService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGrpcService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GrpcService_GoogleGrpc) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGrpcService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GoogleGrpc: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GoogleGrpc: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TargetUri", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGrpcService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGrpcService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TargetUri = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SslCredentials", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGrpcService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGrpcService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SslCredentials == nil {
				m.SslCredentials = &GrpcService_GoogleGrpc_SslCredentials{}
			}
			if err := m.SslCredentials.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StatPrefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGrpcService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGrpcService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StatPrefix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Config", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGrpcService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGrpcService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Config == nil {
				m.Config = &google_protobuf4.Struct{}
			}
			if err := m.Config.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGrpcService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGrpcService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GrpcService_GoogleGrpc_SslCredentials) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGrpcService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SslCredentials: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SslCredentials: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RootCerts", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGrpcService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGrpcService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RootCerts == nil {
				m.RootCerts = &DataSource{}
			}
			if err := m.RootCerts.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrivateKey", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGrpcService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGrpcService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PrivateKey == nil {
				m.PrivateKey = &DataSource{}
			}
			if err := m.PrivateKey.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CertChain", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGrpcService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGrpcService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CertChain == nil {
				m.CertChain = &DataSource{}
			}
			if err := m.CertChain.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGrpcService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGrpcService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GrpcService_Credentials) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGrpcService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Credentials: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Credentials: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccessToken", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGrpcService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGrpcService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CredentialSpecifier = &GrpcService_Credentials_AccessToken{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGrpcService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGrpcService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipGrpcService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowGrpcService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowGrpcService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowGrpcService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthGrpcService
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowGrpcService
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipGrpcService(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthGrpcService = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowGrpcService   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("envoy/api/v2/core/grpc_service.proto", fileDescriptorGrpcService) }

var fileDescriptorGrpcService = []byte{
	// 594 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x52, 0xcd, 0x6a, 0x14, 0x41,
	0x10, 0xce, 0x64, 0xf3, 0xc3, 0xd6, 0x84, 0x24, 0x36, 0x81, 0x6c, 0x96, 0x64, 0x09, 0xea, 0x61,
	0x0d, 0x32, 0x03, 0x9b, 0x8b, 0x82, 0x78, 0x48, 0x22, 0x49, 0xf0, 0x07, 0x9d, 0x55, 0xaf, 0x4d,
	0xa7, 0xb7, 0x76, 0x6c, 0x32, 0x3b, 0x3d, 0x74, 0xf7, 0x2c, 0xe6, 0x8d, 0x7c, 0x04, 0xf1, 0x94,
	0x8b, 0xe0, 0xc1, 0x83, 0x8f, 0x20, 0x0b, 0x1e, 0xf2, 0x16, 0xd2, 0x3d, 0xbd, 0xc9, 0xc6, 0x0d,
	0xac, 0xb7, 0xaa, 0xfa, 0xea, 0xab, 0x9f, 0xaf, 0x0a, 0x1e, 0x62, 0x3e, 0x94, 0x17, 0x31, 0x2b,
	0x44, 0x3c, 0xec, 0xc4, 0x5c, 0x2a, 0x8c, 0x53, 0x55, 0x70, 0xaa, 0x51, 0x0d, 0x05, 0xc7, 0xa8,
	0x50, 0xd2, 0x48, 0x72, 0xcf, 0x65, 0x45, 0xac, 0x10, 0xd1, 0xb0, 0x13, 0xd9, 0xac, 0xe6, 0xf6,
	0x34, 0xf1, 0x8c, 0x69, 0x4f, 0x68, 0xb6, 0x52, 0x29, 0xd3, 0x0c, 0x63, 0xe7, 0x9d, 0x95, 0xfd,
	0xb8, 0x57, 0x2a, 0x66, 0x84, 0xcc, 0x3d, 0xbe, 0xfd, 0x2f, 0xae, 0x8d, 0x2a, 0xb9, 0xf1, 0xe8,
	0xe6, 0x90, 0x65, 0xa2, 0xc7, 0x0c, 0xc6, 0x63, 0xc3, 0x03, 0x1b, 0xa9, 0x4c, 0xa5, 0x33, 0x63,
	0x6b, 0x55, 0xd1, 0xfb, 0x7f, 0x96, 0x21, 0x3c, 0x56, 0x05, 0xef, 0x56, 0x33, 0x93, 0x53, 0x00,
	0x37, 0x1c, 0xb5, 0x9b, 0x34, 0x82, 0xdd, 0xa0, 0x1d, 0x76, 0xda, 0xd1, 0xd4, 0x0a, 0xd1, 0x04,
	0x27, 0x7a, 0x61, 0x51, 0x1b, 0x38, 0x99, 0x4b, 0xea, 0x38, 0x76, 0xc8, 0x2b, 0x08, 0xab, 0x49,
	0xab, 0x5a, 0xf3, 0xae, 0xd6, 0xa3, 0x19, 0xb5, 0x8e, 0x1d, 0xc3, 0x17, 0x83, 0xf4, 0xda, 0x23,
	0xfb, 0xb0, 0x6c, 0xc4, 0x00, 0x65, 0x69, 0x1a, 0x35, 0x57, 0x69, 0x2b, 0xaa, 0xd0, 0x68, 0xac,
	0x43, 0x74, 0xe4, 0x75, 0x4a, 0xc6, 0x99, 0x76, 0x04, 0xae, 0xb0, 0x87, 0xb9, 0x11, 0x2c, 0xd3,
	0x8d, 0x85, 0xdd, 0x5a, 0x3b, 0xec, 0xec, 0xcd, 0x18, 0xe1, 0xf0, 0x86, 0x91, 0x4c, 0xd2, 0xc9,
	0x29, 0xac, 0x8b, 0x5c, 0x58, 0x9b, 0x0e, 0xd0, 0xb0, 0x1e, 0x33, 0xac, 0xb1, 0xe8, 0x4a, 0xb6,
	0xee, 0x28, 0x79, 0x82, 0xac, 0x87, 0xea, 0x23, 0xcb, 0x4a, 0x4c, 0xd6, 0x3c, 0xef, 0xb5, 0xa7,
	0x35, 0x9f, 0x42, 0xfd, 0x5a, 0x35, 0xf2, 0x18, 0x56, 0x78, 0x56, 0x6a, 0x83, 0x8a, 0xe6, 0x6c,
	0x80, 0x4e, 0xf5, 0xfa, 0x41, 0xfd, 0xdb, 0xd5, 0x65, 0x6d, 0x41, 0xcd, 0xef, 0x06, 0x49, 0xe8,
	0xe1, 0x37, 0x6c, 0x80, 0xcd, 0xef, 0x35, 0x80, 0x1b, 0x95, 0x48, 0x1b, 0xc0, 0x30, 0x95, 0xa2,
	0xa1, 0xa5, 0x12, 0xd3, 0xd4, 0x7a, 0x05, 0x7e, 0x50, 0x82, 0x30, 0x58, 0xd3, 0x3a, 0xa3, 0x93,
	0x82, 0x54, 0x37, 0x79, 0xf2, 0xdf, 0x37, 0x89, 0xba, 0x3a, 0x9b, 0x94, 0x67, 0x55, 0xdf, 0xf2,
	0xc9, 0x1e, 0x84, 0xda, 0x30, 0x43, 0x0b, 0x85, 0x7d, 0xf1, 0xd9, 0x1d, 0xea, 0xd6, 0x34, 0x60,
	0xd1, 0xb7, 0x0e, 0x24, 0x31, 0x2c, 0x71, 0x99, 0xf7, 0x45, 0xda, 0x58, 0x70, 0x53, 0x6c, 0x4e,
	0xdd, 0xb3, 0xeb, 0xfe, 0x3a, 0xf1, 0x69, 0xcd, 0x9f, 0x01, 0xac, 0xde, 0xee, 0x4f, 0x9e, 0x01,
	0x28, 0x29, 0x0d, 0xe5, 0xa8, 0x8c, 0xf6, 0xdf, 0xba, 0x73, 0xc7, 0x36, 0x47, 0xcc, 0xb0, 0xae,
	0x2c, 0x15, 0xc7, 0xa4, 0x6e, 0x09, 0x87, 0x36, 0x9f, 0x3c, 0x87, 0xb0, 0x50, 0x62, 0xc8, 0x0c,
	0xd2, 0x73, 0xbc, 0xf0, 0x62, 0xcc, 0xa0, 0x83, 0x67, 0xbc, 0xc4, 0x0b, 0xdb, 0xdd, 0x36, 0xa6,
	0xfc, 0x13, 0x13, 0xb9, 0xff, 0xca, 0x59, 0xdd, 0x2d, 0xe1, 0xd0, 0xe6, 0x37, 0xdf, 0x41, 0x38,
	0xb9, 0xca, 0x03, 0x58, 0x61, 0x9c, 0xa3, 0xd6, 0xd4, 0xc8, 0x73, 0xcc, 0xab, 0x4b, 0x9e, 0xcc,
	0x25, 0x61, 0x15, 0x7d, 0x6f, 0x83, 0x07, 0x3b, 0xb0, 0x71, 0x73, 0x3e, 0xaa, 0x0b, 0xe4, 0xa2,
	0x2f, 0x50, 0x91, 0xc5, 0xaf, 0x57, 0x97, 0xb5, 0xe0, 0x60, 0x0b, 0xd6, 0xfd, 0x2f, 0x4c, 0x41,
	0xeb, 0x5f, 0x46, 0xad, 0xe0, 0xc7, 0xa8, 0x15, 0xfc, 0x1a, 0xb5, 0x82, 0xdf, 0xa3, 0x56, 0x70,
	0xb6, 0xe4, 0x74, 0xde, 0xff, 0x1b, 0x00, 0x00, 0xff, 0xff, 0x65, 0x49, 0x51, 0x88, 0xc6, 0x04,
	0x00, 0x00,
}
