// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: mixer/template/tracespan/tracespan_handler_service.proto

/*
	Package tracespan is a generated protocol buffer package.


	TraceSpan represents an individual span within a distributed trace.

	When writing the configuration, the value for the fields associated with this template can either be a
	literal or an [expression](https://istio.io/docs/reference/config/mixer/expression-language.html). Please note that if the datatype of a field is not istio.mixer.adapter.model.v1beta1.Value,
	then the expression's [inferred type](https://istio.io/docs/reference/config/mixer/expression-language.html#type-checking) must match the datatype of the field.

	Example config:
	```
	apiVersion: "config.istio.io/v1alpha2"
	kind: tracespan
	metadata:
	  name: default
	  namespace: istio-system
	spec:
	  traceId: request.headers["x-b3-traceid"]
	  spanId: request.headers["x-b3-spanid"] | ""
	  parentSpanId: request.headers["x-b3-parentspanid"] | ""
	  spanName: request.path | "/"
	  startTime: request.time
	  endTime: response.time
	  spanTags:
	    http.method: request.method | ""
	    http.status_code: response.code | 200
	    http.url: request.path | ""
	    request.size: request.size | 0
	    response.size: response.size | 0
	    source.ip: source.ip | ip("0.0.0.0")
	    source.service: source.service | ""
	    source.user: source.user | ""
	    source.version: source.labels["version"] | ""
	```

	See also: [Distributed Tracing](https://istio.io/docs/tasks/telemetry/distributed-tracing.html)
	for information on tracing within Istio.

	It is generated from these files:
		mixer/template/tracespan/tracespan_handler_service.proto

	It has these top-level messages:
		HandleTraceSpanRequest
		InstanceMsg
		Type
		InstanceParam
*/
package tracespan

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"
import _ "istio.io/api/mixer/adapter/model/v1beta1"
import google_protobuf1 "github.com/gogo/protobuf/types"
import istio_mixer_adapter_model_v1beta11 "istio.io/api/mixer/adapter/model/v1beta1"
import istio_mixer_adapter_model_v1beta12 "istio.io/api/mixer/adapter/model/v1beta1"
import istio_policy_v1beta1 "istio.io/api/policy/v1beta1"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

import strings "strings"
import reflect "reflect"
import github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Request message for HandleTraceSpan method.
type HandleTraceSpanRequest struct {
	// 'tracespan' instances.
	Instances []*InstanceMsg `protobuf:"bytes,1,rep,name=instances" json:"instances,omitempty"`
	// Adapter specific handler configuration.
	//
	// Note: Backends can also implement [InfrastructureBackend][https://istio.io/docs/reference/config/mixer/istio.mixer.adapter.model.v1beta1.html#InfrastructureBackend]
	// service and therefore opt to receive handler configuration during session creation through [InfrastructureBackend.CreateSession][TODO: Link to this fragment]
	// call. In that case, adapter_config will have type_url as 'google.protobuf.Any.type_url' and would contain string
	// value of session_id (returned from InfrastructureBackend.CreateSession).
	AdapterConfig *google_protobuf1.Any `protobuf:"bytes,2,opt,name=adapter_config,json=adapterConfig" json:"adapter_config,omitempty"`
	// Id to dedupe identical requests from Mixer.
	DedupId string `protobuf:"bytes,3,opt,name=dedup_id,json=dedupId,proto3" json:"dedup_id,omitempty"`
}

func (m *HandleTraceSpanRequest) Reset()      { *m = HandleTraceSpanRequest{} }
func (*HandleTraceSpanRequest) ProtoMessage() {}
func (*HandleTraceSpanRequest) Descriptor() ([]byte, []int) {
	return fileDescriptorTracespanHandlerService, []int{0}
}

// Contains instance payload for 'tracespan' template. This is passed to infrastructure backends during request-time
// through HandleTraceSpanService.HandleTraceSpan.
type InstanceMsg struct {
	// Name of the instance as specified in configuration.
	Name string `protobuf:"bytes,72295727,opt,name=name,proto3" json:"name,omitempty"`
	// Trace ID is the unique identifier for a trace. All spans from the same
	// trace share the same Trace ID.
	//
	// Required.
	TraceId string `protobuf:"bytes,1,opt,name=trace_id,json=traceId,proto3" json:"trace_id,omitempty"`
	// Span ID is the unique identifier for a span within a trace. It is assigned
	// when the span is created.
	//
	// Optional.
	SpanId string `protobuf:"bytes,2,opt,name=span_id,json=spanId,proto3" json:"span_id,omitempty"`
	// Parent Span ID is the unique identifier for a parent span of this span
	// instance. If this is a root span, then this field MUST be empty.
	//
	// Optional.
	ParentSpanId string `protobuf:"bytes,3,opt,name=parent_span_id,json=parentSpanId,proto3" json:"parent_span_id,omitempty"`
	// Span name is a description of the span's operation.
	//
	// For example, the name can be a qualified method name or a file name
	// and a line number where the operation is called. A best practice is to use
	// the same display name within an application and at the same call point.
	// This makes it easier to correlate spans in different traces.
	//
	// Required.
	SpanName string `protobuf:"bytes,4,opt,name=span_name,json=spanName,proto3" json:"span_name,omitempty"`
	// The start time of the span.
	//
	// Required.
	StartTime *istio_mixer_adapter_model_v1beta12.TimeStamp `protobuf:"bytes,5,opt,name=start_time,json=startTime" json:"start_time,omitempty"`
	// The end time of the span.
	//
	// Required.
	EndTime *istio_mixer_adapter_model_v1beta12.TimeStamp `protobuf:"bytes,6,opt,name=end_time,json=endTime" json:"end_time,omitempty"`
	// Span tags are a set of <key, value> pairs that provide metadata for the
	// entire span. The values can be specified in the form of expressions.
	//
	// Optional.
	SpanTags map[string]*istio_mixer_adapter_model_v1beta12.Value `protobuf:"bytes,7,rep,name=span_tags,json=spanTags" json:"span_tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *InstanceMsg) Reset()      { *m = InstanceMsg{} }
func (*InstanceMsg) ProtoMessage() {}
func (*InstanceMsg) Descriptor() ([]byte, []int) {
	return fileDescriptorTracespanHandlerService, []int{1}
}

// Contains inferred type information about specific instance of 'tracespan' template. This is passed to
// infrastructure backends during configuration-time through [InfrastructureBackend.CreateSession][TODO: Link to this fragment].
type Type struct {
	// Span tags are a set of <key, value> pairs that provide metadata for the
	// entire span. The values can be specified in the form of expressions.
	//
	// Optional.
	SpanTags map[string]istio_policy_v1beta1.ValueType `protobuf:"bytes,7,rep,name=span_tags,json=spanTags" json:"span_tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3,enum=istio.policy.v1beta1.ValueType"`
}

func (m *Type) Reset()                    { *m = Type{} }
func (*Type) ProtoMessage()               {}
func (*Type) Descriptor() ([]byte, []int) { return fileDescriptorTracespanHandlerService, []int{2} }

// Represents instance configuration schema for 'tracespan' template.
type InstanceParam struct {
	// Trace ID is the unique identifier for a trace. All spans from the same
	// trace share the same Trace ID.
	//
	// Required.
	TraceId string `protobuf:"bytes,1,opt,name=trace_id,json=traceId,proto3" json:"trace_id,omitempty"`
	// Span ID is the unique identifier for a span within a trace. It is assigned
	// when the span is created.
	//
	// Optional.
	SpanId string `protobuf:"bytes,2,opt,name=span_id,json=spanId,proto3" json:"span_id,omitempty"`
	// Parent Span ID is the unique identifier for a parent span of this span
	// instance. If this is a root span, then this field MUST be empty.
	//
	// Optional.
	ParentSpanId string `protobuf:"bytes,3,opt,name=parent_span_id,json=parentSpanId,proto3" json:"parent_span_id,omitempty"`
	// Span name is a description of the span's operation.
	//
	// For example, the name can be a qualified method name or a file name
	// and a line number where the operation is called. A best practice is to use
	// the same display name within an application and at the same call point.
	// This makes it easier to correlate spans in different traces.
	//
	// Required.
	SpanName string `protobuf:"bytes,4,opt,name=span_name,json=spanName,proto3" json:"span_name,omitempty"`
	// The start time of the span.
	//
	// Required.
	StartTime string `protobuf:"bytes,5,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The end time of the span.
	//
	// Required.
	EndTime string `protobuf:"bytes,6,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Span tags are a set of <key, value> pairs that provide metadata for the
	// entire span. The values can be specified in the form of expressions.
	//
	// Optional.
	SpanTags map[string]string `protobuf:"bytes,7,rep,name=span_tags,json=spanTags" json:"span_tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *InstanceParam) Reset()      { *m = InstanceParam{} }
func (*InstanceParam) ProtoMessage() {}
func (*InstanceParam) Descriptor() ([]byte, []int) {
	return fileDescriptorTracespanHandlerService, []int{3}
}

func init() {
	proto.RegisterType((*HandleTraceSpanRequest)(nil), "tracespan.HandleTraceSpanRequest")
	proto.RegisterType((*InstanceMsg)(nil), "tracespan.InstanceMsg")
	proto.RegisterType((*Type)(nil), "tracespan.Type")
	proto.RegisterType((*InstanceParam)(nil), "tracespan.InstanceParam")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for HandleTraceSpanService service

type HandleTraceSpanServiceClient interface {
	// HandleTraceSpan is called by Mixer at request-time to deliver 'tracespan' instances to the backend.
	HandleTraceSpan(ctx context.Context, in *HandleTraceSpanRequest, opts ...grpc.CallOption) (*istio_mixer_adapter_model_v1beta11.ReportResult, error)
}

type handleTraceSpanServiceClient struct {
	cc *grpc.ClientConn
}

func NewHandleTraceSpanServiceClient(cc *grpc.ClientConn) HandleTraceSpanServiceClient {
	return &handleTraceSpanServiceClient{cc}
}

func (c *handleTraceSpanServiceClient) HandleTraceSpan(ctx context.Context, in *HandleTraceSpanRequest, opts ...grpc.CallOption) (*istio_mixer_adapter_model_v1beta11.ReportResult, error) {
	out := new(istio_mixer_adapter_model_v1beta11.ReportResult)
	err := grpc.Invoke(ctx, "/tracespan.HandleTraceSpanService/HandleTraceSpan", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for HandleTraceSpanService service

type HandleTraceSpanServiceServer interface {
	// HandleTraceSpan is called by Mixer at request-time to deliver 'tracespan' instances to the backend.
	HandleTraceSpan(context.Context, *HandleTraceSpanRequest) (*istio_mixer_adapter_model_v1beta11.ReportResult, error)
}

func RegisterHandleTraceSpanServiceServer(s *grpc.Server, srv HandleTraceSpanServiceServer) {
	s.RegisterService(&_HandleTraceSpanService_serviceDesc, srv)
}

func _HandleTraceSpanService_HandleTraceSpan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HandleTraceSpanRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HandleTraceSpanServiceServer).HandleTraceSpan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tracespan.HandleTraceSpanService/HandleTraceSpan",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HandleTraceSpanServiceServer).HandleTraceSpan(ctx, req.(*HandleTraceSpanRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _HandleTraceSpanService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "tracespan.HandleTraceSpanService",
	HandlerType: (*HandleTraceSpanServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "HandleTraceSpan",
			Handler:    _HandleTraceSpanService_HandleTraceSpan_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "mixer/template/tracespan/tracespan_handler_service.proto",
}

func (m *HandleTraceSpanRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HandleTraceSpanRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Instances) > 0 {
		for _, msg := range m.Instances {
			dAtA[i] = 0xa
			i++
			i = encodeVarintTracespanHandlerService(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.AdapterConfig != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(m.AdapterConfig.Size()))
		n1, err := m.AdapterConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if len(m.DedupId) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.DedupId)))
		i += copy(dAtA[i:], m.DedupId)
	}
	return i, nil
}

func (m *InstanceMsg) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InstanceMsg) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.TraceId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.TraceId)))
		i += copy(dAtA[i:], m.TraceId)
	}
	if len(m.SpanId) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.SpanId)))
		i += copy(dAtA[i:], m.SpanId)
	}
	if len(m.ParentSpanId) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.ParentSpanId)))
		i += copy(dAtA[i:], m.ParentSpanId)
	}
	if len(m.SpanName) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.SpanName)))
		i += copy(dAtA[i:], m.SpanName)
	}
	if m.StartTime != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(m.StartTime.Size()))
		n2, err := m.StartTime.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.EndTime != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(m.EndTime.Size()))
		n3, err := m.EndTime.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if len(m.SpanTags) > 0 {
		for k, _ := range m.SpanTags {
			dAtA[i] = 0x3a
			i++
			v := m.SpanTags[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovTracespanHandlerService(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovTracespanHandlerService(uint64(len(k))) + msgSize
			i = encodeVarintTracespanHandlerService(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintTracespanHandlerService(dAtA, i, uint64(v.Size()))
				n4, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n4
			}
		}
	}
	if len(m.Name) > 0 {
		dAtA[i] = 0xfa
		i++
		dAtA[i] = 0xd2
		i++
		dAtA[i] = 0xe4
		i++
		dAtA[i] = 0x93
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	return i, nil
}

func (m *Type) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Type) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.SpanTags) > 0 {
		for k, _ := range m.SpanTags {
			dAtA[i] = 0x3a
			i++
			v := m.SpanTags[k]
			mapSize := 1 + len(k) + sovTracespanHandlerService(uint64(len(k))) + 1 + sovTracespanHandlerService(uint64(v))
			i = encodeVarintTracespanHandlerService(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x10
			i++
			i = encodeVarintTracespanHandlerService(dAtA, i, uint64(v))
		}
	}
	return i, nil
}

func (m *InstanceParam) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InstanceParam) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.TraceId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.TraceId)))
		i += copy(dAtA[i:], m.TraceId)
	}
	if len(m.SpanId) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.SpanId)))
		i += copy(dAtA[i:], m.SpanId)
	}
	if len(m.ParentSpanId) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.ParentSpanId)))
		i += copy(dAtA[i:], m.ParentSpanId)
	}
	if len(m.SpanName) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.SpanName)))
		i += copy(dAtA[i:], m.SpanName)
	}
	if len(m.StartTime) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.StartTime)))
		i += copy(dAtA[i:], m.StartTime)
	}
	if len(m.EndTime) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.EndTime)))
		i += copy(dAtA[i:], m.EndTime)
	}
	if len(m.SpanTags) > 0 {
		for k, _ := range m.SpanTags {
			dAtA[i] = 0x3a
			i++
			v := m.SpanTags[k]
			mapSize := 1 + len(k) + sovTracespanHandlerService(uint64(len(k))) + 1 + len(v) + sovTracespanHandlerService(uint64(len(v)))
			i = encodeVarintTracespanHandlerService(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	return i, nil
}

func encodeVarintTracespanHandlerService(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *HandleTraceSpanRequest) Size() (n int) {
	var l int
	_ = l
	if len(m.Instances) > 0 {
		for _, e := range m.Instances {
			l = e.Size()
			n += 1 + l + sovTracespanHandlerService(uint64(l))
		}
	}
	if m.AdapterConfig != nil {
		l = m.AdapterConfig.Size()
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.DedupId)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	return n
}

func (m *InstanceMsg) Size() (n int) {
	var l int
	_ = l
	l = len(m.TraceId)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.SpanId)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.ParentSpanId)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.SpanName)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	if m.StartTime != nil {
		l = m.StartTime.Size()
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	if m.EndTime != nil {
		l = m.EndTime.Size()
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	if len(m.SpanTags) > 0 {
		for k, v := range m.SpanTags {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovTracespanHandlerService(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovTracespanHandlerService(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovTracespanHandlerService(uint64(mapEntrySize))
		}
	}
	l = len(m.Name)
	if l > 0 {
		n += 5 + l + sovTracespanHandlerService(uint64(l))
	}
	return n
}

func (m *Type) Size() (n int) {
	var l int
	_ = l
	if len(m.SpanTags) > 0 {
		for k, v := range m.SpanTags {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovTracespanHandlerService(uint64(len(k))) + 1 + sovTracespanHandlerService(uint64(v))
			n += mapEntrySize + 1 + sovTracespanHandlerService(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *InstanceParam) Size() (n int) {
	var l int
	_ = l
	l = len(m.TraceId)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.SpanId)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.ParentSpanId)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.SpanName)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.StartTime)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.EndTime)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	if len(m.SpanTags) > 0 {
		for k, v := range m.SpanTags {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovTracespanHandlerService(uint64(len(k))) + 1 + len(v) + sovTracespanHandlerService(uint64(len(v)))
			n += mapEntrySize + 1 + sovTracespanHandlerService(uint64(mapEntrySize))
		}
	}
	return n
}

func sovTracespanHandlerService(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozTracespanHandlerService(x uint64) (n int) {
	return sovTracespanHandlerService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *HandleTraceSpanRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HandleTraceSpanRequest{`,
		`Instances:` + strings.Replace(fmt.Sprintf("%v", this.Instances), "InstanceMsg", "InstanceMsg", 1) + `,`,
		`AdapterConfig:` + strings.Replace(fmt.Sprintf("%v", this.AdapterConfig), "Any", "google_protobuf1.Any", 1) + `,`,
		`DedupId:` + fmt.Sprintf("%v", this.DedupId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *InstanceMsg) String() string {
	if this == nil {
		return "nil"
	}
	keysForSpanTags := make([]string, 0, len(this.SpanTags))
	for k, _ := range this.SpanTags {
		keysForSpanTags = append(keysForSpanTags, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForSpanTags)
	mapStringForSpanTags := "map[string]*istio_mixer_adapter_model_v1beta12.Value{"
	for _, k := range keysForSpanTags {
		mapStringForSpanTags += fmt.Sprintf("%v: %v,", k, this.SpanTags[k])
	}
	mapStringForSpanTags += "}"
	s := strings.Join([]string{`&InstanceMsg{`,
		`TraceId:` + fmt.Sprintf("%v", this.TraceId) + `,`,
		`SpanId:` + fmt.Sprintf("%v", this.SpanId) + `,`,
		`ParentSpanId:` + fmt.Sprintf("%v", this.ParentSpanId) + `,`,
		`SpanName:` + fmt.Sprintf("%v", this.SpanName) + `,`,
		`StartTime:` + strings.Replace(fmt.Sprintf("%v", this.StartTime), "TimeStamp", "istio_mixer_adapter_model_v1beta12.TimeStamp", 1) + `,`,
		`EndTime:` + strings.Replace(fmt.Sprintf("%v", this.EndTime), "TimeStamp", "istio_mixer_adapter_model_v1beta12.TimeStamp", 1) + `,`,
		`SpanTags:` + mapStringForSpanTags + `,`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Type) String() string {
	if this == nil {
		return "nil"
	}
	keysForSpanTags := make([]string, 0, len(this.SpanTags))
	for k, _ := range this.SpanTags {
		keysForSpanTags = append(keysForSpanTags, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForSpanTags)
	mapStringForSpanTags := "map[string]istio_policy_v1beta1.ValueType{"
	for _, k := range keysForSpanTags {
		mapStringForSpanTags += fmt.Sprintf("%v: %v,", k, this.SpanTags[k])
	}
	mapStringForSpanTags += "}"
	s := strings.Join([]string{`&Type{`,
		`SpanTags:` + mapStringForSpanTags + `,`,
		`}`,
	}, "")
	return s
}
func (this *InstanceParam) String() string {
	if this == nil {
		return "nil"
	}
	keysForSpanTags := make([]string, 0, len(this.SpanTags))
	for k, _ := range this.SpanTags {
		keysForSpanTags = append(keysForSpanTags, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForSpanTags)
	mapStringForSpanTags := "map[string]string{"
	for _, k := range keysForSpanTags {
		mapStringForSpanTags += fmt.Sprintf("%v: %v,", k, this.SpanTags[k])
	}
	mapStringForSpanTags += "}"
	s := strings.Join([]string{`&InstanceParam{`,
		`TraceId:` + fmt.Sprintf("%v", this.TraceId) + `,`,
		`SpanId:` + fmt.Sprintf("%v", this.SpanId) + `,`,
		`ParentSpanId:` + fmt.Sprintf("%v", this.ParentSpanId) + `,`,
		`SpanName:` + fmt.Sprintf("%v", this.SpanName) + `,`,
		`StartTime:` + fmt.Sprintf("%v", this.StartTime) + `,`,
		`EndTime:` + fmt.Sprintf("%v", this.EndTime) + `,`,
		`SpanTags:` + mapStringForSpanTags + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringTracespanHandlerService(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *HandleTraceSpanRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTracespanHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HandleTraceSpanRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HandleTraceSpanRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Instances", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Instances = append(m.Instances, &InstanceMsg{})
			if err := m.Instances[len(m.Instances)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdapterConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AdapterConfig == nil {
				m.AdapterConfig = &google_protobuf1.Any{}
			}
			if err := m.AdapterConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DedupId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DedupId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTracespanHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InstanceMsg) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTracespanHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InstanceMsg: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InstanceMsg: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TraceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SpanId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParentSpanId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ParentSpanId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SpanName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StartTime == nil {
				m.StartTime = &istio_mixer_adapter_model_v1beta12.TimeStamp{}
			}
			if err := m.StartTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EndTime == nil {
				m.EndTime = &istio_mixer_adapter_model_v1beta12.TimeStamp{}
			}
			if err := m.EndTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanTags", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SpanTags == nil {
				m.SpanTags = make(map[string]*istio_mixer_adapter_model_v1beta12.Value)
			}
			var mapkey string
			var mapvalue *istio_mixer_adapter_model_v1beta12.Value
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTracespanHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTracespanHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthTracespanHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTracespanHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthTracespanHandlerService
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthTracespanHandlerService
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &istio_mixer_adapter_model_v1beta12.Value{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipTracespanHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthTracespanHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.SpanTags[mapkey] = mapvalue
			iNdEx = postIndex
		case 72295727:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTracespanHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Type) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTracespanHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Type: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Type: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanTags", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SpanTags == nil {
				m.SpanTags = make(map[string]istio_policy_v1beta1.ValueType)
			}
			var mapkey string
			var mapvalue istio_policy_v1beta1.ValueType
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTracespanHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTracespanHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthTracespanHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTracespanHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= (istio_policy_v1beta1.ValueType(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipTracespanHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthTracespanHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.SpanTags[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTracespanHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InstanceParam) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTracespanHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InstanceParam: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InstanceParam: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TraceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SpanId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParentSpanId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ParentSpanId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SpanName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTime", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartTime = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndTime", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndTime = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanTags", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SpanTags == nil {
				m.SpanTags = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTracespanHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTracespanHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthTracespanHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTracespanHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthTracespanHandlerService
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipTracespanHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthTracespanHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.SpanTags[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTracespanHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipTracespanHandlerService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowTracespanHandlerService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthTracespanHandlerService
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowTracespanHandlerService
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipTracespanHandlerService(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthTracespanHandlerService = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowTracespanHandlerService   = fmt.Errorf("proto: integer overflow")
)

func init() {
	proto.RegisterFile("mixer/template/tracespan/tracespan_handler_service.proto", fileDescriptorTracespanHandlerService)
}

var fileDescriptorTracespanHandlerService = []byte{
	// 710 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x55, 0x4f, 0x6b, 0xd4, 0x5e,
	0x14, 0x4d, 0x66, 0xda, 0x4e, 0xf3, 0xfa, 0x6b, 0x7f, 0xf2, 0xa8, 0x75, 0x3a, 0xd2, 0xb4, 0x0e,
	0xa5, 0xcc, 0xa2, 0x24, 0x74, 0x54, 0x28, 0x2d, 0x08, 0xb5, 0x14, 0x1d, 0x44, 0x91, 0xcc, 0xe0,
	0x4a, 0x08, 0xaf, 0x93, 0xdb, 0x18, 0x4c, 0x5e, 0x62, 0xf2, 0xa6, 0x34, 0x2b, 0xc5, 0x4f, 0x20,
	0xf4, 0x0b, 0xb8, 0x12, 0x77, 0x7e, 0x01, 0x57, 0xae, 0x8a, 0xab, 0xe2, 0x4a, 0x10, 0xc1, 0x89,
	0x5d, 0xb8, 0xec, 0xd2, 0xa5, 0xe4, 0xe5, 0xb5, 0x93, 0x76, 0xa6, 0x7f, 0x70, 0xe3, 0x2e, 0xf7,
	0xdd, 0xf3, 0xee, 0x3b, 0xe7, 0xdc, 0x3b, 0x77, 0xd0, 0xb2, 0xe7, 0xec, 0x40, 0xa8, 0x33, 0xf0,
	0x02, 0x97, 0x30, 0xd0, 0x59, 0x48, 0xda, 0x10, 0x05, 0x84, 0xf6, 0xbe, 0xcc, 0x67, 0x84, 0x5a,
	0x2e, 0x84, 0x66, 0x04, 0xe1, 0xb6, 0xd3, 0x06, 0x2d, 0x08, 0x7d, 0xe6, 0x63, 0xe5, 0x18, 0x50,
	0x99, 0xb4, 0x7d, 0xdb, 0xe7, 0xa7, 0x7a, 0xfa, 0x95, 0x01, 0x2a, 0x8b, 0x59, 0x69, 0x62, 0x91,
	0x80, 0x41, 0xa8, 0x7b, 0xbe, 0x05, 0xae, 0xbe, 0xbd, 0xb4, 0x09, 0x8c, 0x2c, 0xe9, 0xb0, 0xc3,
	0x80, 0x46, 0x8e, 0x4f, 0x23, 0x81, 0x9e, 0xb6, 0x7d, 0xdf, 0x76, 0x41, 0xe7, 0xd1, 0x66, 0x67,
	0x4b, 0x27, 0x34, 0x16, 0xa9, 0xda, 0x79, 0x85, 0x42, 0x08, 0xfc, 0x90, 0x09, 0xe4, 0xc2, 0x79,
	0x48, 0x16, 0x07, 0x82, 0x7b, 0x65, 0x36, 0xf0, 0x5d, 0xa7, 0x1d, 0x1f, 0xa7, 0xb6, 0x89, 0xdb,
	0x01, 0xb3, 0x07, 0xa8, 0xbe, 0x93, 0xd1, 0xd4, 0x7d, 0x2e, 0xbb, 0x95, 0xaa, 0x6c, 0x06, 0x84,
	0x1a, 0xf0, 0xa2, 0x03, 0x11, 0xc3, 0xb7, 0x90, 0xe2, 0xd0, 0x88, 0x11, 0xda, 0x86, 0xa8, 0x2c,
	0xcf, 0x15, 0x6b, 0x63, 0xf5, 0x29, 0xed, 0xd8, 0x0b, 0xad, 0x21, 0x72, 0x0f, 0x23, 0xdb, 0xe8,
	0x01, 0xf1, 0x2a, 0x9a, 0x10, 0xac, 0xcc, 0xb6, 0x4f, 0xb7, 0x1c, 0xbb, 0x5c, 0x98, 0x93, 0x6b,
	0x63, 0xf5, 0x49, 0x2d, 0xd3, 0xad, 0x1d, 0xe9, 0xd6, 0xd6, 0x68, 0x6c, 0x8c, 0x0b, 0xec, 0x3a,
	0x87, 0xe2, 0x69, 0x34, 0x6a, 0x81, 0xd5, 0x09, 0x4c, 0xc7, 0x2a, 0x17, 0xe7, 0xe4, 0x9a, 0x62,
	0x94, 0x78, 0xdc, 0xb0, 0xaa, 0xdf, 0x8a, 0x68, 0x2c, 0xf7, 0x64, 0x0a, 0xe5, 0x5c, 0x52, 0xa8,
	0x9c, 0x41, 0x79, 0xdc, 0xb0, 0xf0, 0x35, 0x54, 0xe2, 0xed, 0x74, 0x2c, 0xfe, 0xb6, 0x62, 0x8c,
	0xa4, 0x61, 0xc3, 0xc2, 0xf3, 0x68, 0x22, 0x20, 0x21, 0x50, 0x66, 0x1e, 0xe5, 0xb3, 0x47, 0xfe,
	0xcb, 0x4e, 0x9b, 0x19, 0xea, 0x3a, 0x52, 0x78, 0x9a, 0x12, 0x0f, 0xca, 0x43, 0x1c, 0x30, 0x9a,
	0x1e, 0x3c, 0x22, 0x1e, 0xe0, 0x07, 0x08, 0x45, 0x8c, 0x84, 0xcc, 0x64, 0x8e, 0x07, 0xe5, 0x61,
	0x2e, 0x6d, 0x51, 0x73, 0x22, 0xe6, 0xf8, 0x1a, 0xef, 0x89, 0x26, 0x14, 0x69, 0xbc, 0x27, 0x9a,
	0x30, 0x5e, 0x6b, 0x39, 0x1e, 0x34, 0x19, 0xf1, 0x02, 0x43, 0xe1, 0xf7, 0xd3, 0x18, 0xdf, 0x43,
	0xa3, 0x40, 0xad, 0xac, 0xd4, 0xc8, 0x5f, 0x94, 0x2a, 0x01, 0xb5, 0x78, 0xa1, 0x35, 0x41, 0x99,
	0x11, 0x3b, 0x2a, 0x97, 0x78, 0xab, 0xe6, 0x07, 0xb7, 0x4a, 0x4b, 0x45, 0xb6, 0x88, 0x1d, 0x6d,
	0x50, 0x16, 0xc6, 0x99, 0xb0, 0x34, 0xc4, 0x57, 0xd1, 0x10, 0x17, 0xfc, 0xe1, 0xf3, 0xc7, 0x2a,
	0xd7, 0xcc, 0xc3, 0x0a, 0xa0, 0xf1, 0x13, 0x37, 0xf0, 0x15, 0x54, 0x7c, 0x0e, 0xb1, 0xb0, 0x3c,
	0xfd, 0xc4, 0x77, 0xd0, 0x30, 0x1f, 0x2b, 0xd1, 0xe8, 0xda, 0x25, 0x24, 0x3c, 0x49, 0xf1, 0x46,
	0x76, 0x6d, 0xa5, 0xb0, 0x2c, 0x57, 0xdf, 0xca, 0x68, 0xa8, 0x15, 0x07, 0x80, 0x57, 0xfa, 0x95,
	0xcc, 0xe4, 0x94, 0xa4, 0x98, 0xb3, 0x24, 0x54, 0x9e, 0x5e, 0xcc, 0xf5, 0x76, 0x9e, 0xeb, 0x44,
	0x7d, 0x56, 0x70, 0xcd, 0x7e, 0x25, 0x27, 0xe9, 0xa5, 0x4f, 0xe5, 0x29, 0x7e, 0x2a, 0xa0, 0xf1,
	0x23, 0x23, 0x1f, 0x93, 0x90, 0x78, 0xff, 0x6a, 0x04, 0x67, 0xfa, 0x46, 0x50, 0xc9, 0x0f, 0xd5,
	0xf4, 0xa9, 0xa1, 0x52, 0x7a, 0x63, 0xb2, 0xde, 0x6f, 0xee, 0xc2, 0x80, 0x31, 0xe1, 0xea, 0xce,
	0x74, 0x79, 0xf5, 0x62, 0x97, 0x27, 0xf3, 0x2e, 0x2b, 0x39, 0x13, 0xeb, 0x2f, 0xfb, 0xb6, 0x4d,
	0x33, 0xdb, 0xb5, 0x18, 0xd0, 0xff, 0xa7, 0x32, 0xf8, 0x46, 0x8e, 0xdb, 0xe0, 0x1d, 0x55, 0xd1,
	0x2f, 0x31, 0x6c, 0x06, 0x5f, 0x9c, 0x06, 0x44, 0x1d, 0x97, 0xdd, 0xdd, 0xd8, 0xeb, 0xaa, 0xd2,
	0x7e, 0x57, 0x95, 0xbe, 0x76, 0x55, 0xe9, 0xb0, 0xab, 0x4a, 0xaf, 0x12, 0x55, 0x7e, 0x9f, 0xa8,
	0xd2, 0x5e, 0xa2, 0xca, 0xfb, 0x89, 0x2a, 0xff, 0x48, 0x54, 0xf9, 0x57, 0xa2, 0x4a, 0x87, 0x89,
	0x2a, 0xbf, 0xf9, 0xa9, 0x4a, 0xbf, 0xbf, 0x1c, 0xec, 0x16, 0xe4, 0xd7, 0xdf, 0x0f, 0x76, 0x0b,
	0xbd, 0x3f, 0x82, 0xcd, 0x11, 0xbe, 0xc5, 0x6e, 0xfe, 0x09, 0x00, 0x00, 0xff, 0xff, 0xc4, 0x4f,
	0x84, 0x15, 0x56, 0x06, 0x00, 0x00,
}
