// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: networking/v1alpha3/destination_rule.proto

/*
	Package v1alpha3 is a generated protocol buffer package.

	It is generated from these files:
		networking/v1alpha3/destination_rule.proto
		networking/v1alpha3/gateway.proto
		networking/v1alpha3/service_entry.proto
		networking/v1alpha3/virtual_service.proto

	It has these top-level messages:
		DestinationRule
		TrafficPolicy
		Subset
		LoadBalancerSettings
		ConnectionPoolSettings
		OutlierDetection
		TLSSettings
		Gateway
		Server
		Port
		ServiceEntry
		VirtualService
		Destination
		HTTPRoute
		TCPRoute
		HTTPMatchRequest
		DestinationWeight
		L4MatchAttributes
		HTTPRedirect
		HTTPRewrite
		StringMatch
		HTTPRetry
		CorsPolicy
		HTTPFaultInjection
		PortSelector
*/
package v1alpha3

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf "github.com/gogo/protobuf/types"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Standard load balancing algorithms that require no tuning.
type LoadBalancerSettings_SimpleLB int32

const (
	// Round Robin policy. Default
	LoadBalancerSettings_ROUND_ROBIN LoadBalancerSettings_SimpleLB = 0
	// The least request load balancer uses an O(1) algorithm which selects
	// two random healthy hosts and picks the host which has fewer active
	// requests.
	LoadBalancerSettings_LEAST_CONN LoadBalancerSettings_SimpleLB = 1
	// The random load balancer selects a random healthy host. The random
	// load balancer generally performs better than round robin if no health
	// checking policy is configured.
	LoadBalancerSettings_RANDOM LoadBalancerSettings_SimpleLB = 2
	// This option will forward the connection to the original IP address
	// requested by the caller without doing any form of load
	// balancing. This option must be used with care. It is meant for
	// advanced use cases. Refer to Original Destination load balancer in
	// Envoy for further details.
	LoadBalancerSettings_PASSTHROUGH LoadBalancerSettings_SimpleLB = 3
)

var LoadBalancerSettings_SimpleLB_name = map[int32]string{
	0: "ROUND_ROBIN",
	1: "LEAST_CONN",
	2: "RANDOM",
	3: "PASSTHROUGH",
}
var LoadBalancerSettings_SimpleLB_value = map[string]int32{
	"ROUND_ROBIN": 0,
	"LEAST_CONN":  1,
	"RANDOM":      2,
	"PASSTHROUGH": 3,
}

func (x LoadBalancerSettings_SimpleLB) String() string {
	return proto.EnumName(LoadBalancerSettings_SimpleLB_name, int32(x))
}
func (LoadBalancerSettings_SimpleLB) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorDestinationRule, []int{3, 0}
}

// TLS connection mode
type TLSSettings_TLSmode int32

const (
	// Do not setup a TLS connection to the upstream endpoint.
	TLSSettings_DISABLE TLSSettings_TLSmode = 0
	// Originate a TLS connection to the upstream endpoint.
	TLSSettings_SIMPLE TLSSettings_TLSmode = 1
	// Secure connections to the upstream using mutual TLS by presenting
	// client certificates for authentication.
	TLSSettings_MUTUAL TLSSettings_TLSmode = 2
	// Secure connections to the upstream using mutual TLS by presenting
	// client certificates for authentication.
	// Compared to Mutual mode, this mode uses certificates generated
	// automatically by Istio for mTLS authentication. When this mode is
	// used, all other fields in `TLSSettings` should be empty.
	TLSSettings_ISTIO_MUTUAL TLSSettings_TLSmode = 3
)

var TLSSettings_TLSmode_name = map[int32]string{
	0: "DISABLE",
	1: "SIMPLE",
	2: "MUTUAL",
	3: "ISTIO_MUTUAL",
}
var TLSSettings_TLSmode_value = map[string]int32{
	"DISABLE":      0,
	"SIMPLE":       1,
	"MUTUAL":       2,
	"ISTIO_MUTUAL": 3,
}

func (x TLSSettings_TLSmode) String() string {
	return proto.EnumName(TLSSettings_TLSmode_name, int32(x))
}
func (TLSSettings_TLSmode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorDestinationRule, []int{6, 0}
}

// `DestinationRule` defines policies that apply to traffic intended for a
// service after routing has occurred. These rules specify configuration
// for load balancing, connection pool size from the sidecar, and outlier
// detection settings to detect and evict unhealthy hosts from the load
// balancing pool. For example, a simple load balancing policy for the
// ratings service would look as follows:
//
//     apiVersion: networking.istio.io/v1alpha3
//     kind: DestinationRule
//     metadata:
//       name: bookinfo-ratings
//     spec:
//       host: ratings.prod.svc.cluster.local
//       trafficPolicy:
//         loadBalancer:
//           simple: LEAST_CONN
//
// Version specific policies can be specified by defining a named
// `subset` and overriding the settings specified at the service level. The
// following rule uses a round robin load balancing policy for all traffic
// going to a subset named testversion that is composed of endpoints (e.g.,
// pods) with labels (version:v3).
//
//     apiVersion: networking.istio.io/v1alpha3
//     kind: DestinationRule
//     metadata:
//       name: bookinfo-ratings
//     spec:
//       host: ratings.prod.svc.cluster.local
//       trafficPolicy:
//         loadBalancer:
//           simple: LEAST_CONN
//       subsets:
//       - name: testversion
//         labels:
//           version: v3
//         trafficPolicy:
//           loadBalancer:
//             simple: ROUND_ROBIN
//
// **Note:** Policies specified for subsets will not take effect until
// a route rule explicitly sends traffic to this subset.
//
// Traffic policies can be customized to specific ports as well. The
// following rule uses the least connection load balancing policy for all
// traffic to port 80, while uses a round robin load balancing setting for
// traffic to the port 9080.
//
//     apiVersion: networking.istio.io/v1alpha3
//     kind: DestinationRule
//     metadata:
//       name: bookinfo-ratings-port
//     spec:
//       host: ratings.prod.svc.cluster.local
//       trafficPolicy: # Apply to all ports
//         portLevelSettings:
//         - port:
//             number: 80
//           loadBalancer:
//             simple: LEAST_CONN
//         - port:
//             number: 9080
//           loadBalancer:
//             simple: ROUND_ROBIN
//
type DestinationRule struct {
	// REQUIRED. The name of a service from the service registry. Service
	// names are looked up from the platform's service registry (e.g.,
	// Kubernetes services, Consul services, etc.) and from the hosts
	// declared by [ServiceEntries](#ServiceEntry). Rules defined for
	// services that do not exist in the service registry will be ignored.
	//
	// *Note for Kubernetes users*: When short names are used (e.g. "reviews"
	// instead of "reviews.default.svc.cluster.local"), Istio will interpret
	// the short name based on the namespace of the rule, not the service. A
	// rule in the "default" namespace containing a host "reviews will be
	// interpreted as "reviews.default.svc.cluster.local", irrespective of
	// the actual namespace associated with the reviews service. _To avoid
	// potential misconfigurations, it is recommended to always use fully
	// qualified domain names over short names._
	//
	// Note that the host field applies to both HTTP and TCP services.
	Host string `protobuf:"bytes,1,opt,name=host,proto3" json:"host,omitempty"`
	// Traffic policies to apply (load balancing policy, connection pool
	// sizes, outlier detection).
	TrafficPolicy *TrafficPolicy `protobuf:"bytes,2,opt,name=traffic_policy,json=trafficPolicy" json:"traffic_policy,omitempty"`
	// One or more named sets that represent individual versions of a
	// service. Traffic policies can be overridden at subset level.
	Subsets []*Subset `protobuf:"bytes,3,rep,name=subsets" json:"subsets,omitempty"`
}

func (m *DestinationRule) Reset()                    { *m = DestinationRule{} }
func (m *DestinationRule) String() string            { return proto.CompactTextString(m) }
func (*DestinationRule) ProtoMessage()               {}
func (*DestinationRule) Descriptor() ([]byte, []int) { return fileDescriptorDestinationRule, []int{0} }

func (m *DestinationRule) GetHost() string {
	if m != nil {
		return m.Host
	}
	return ""
}

func (m *DestinationRule) GetTrafficPolicy() *TrafficPolicy {
	if m != nil {
		return m.TrafficPolicy
	}
	return nil
}

func (m *DestinationRule) GetSubsets() []*Subset {
	if m != nil {
		return m.Subsets
	}
	return nil
}

// Traffic policies to apply for a specific destination, across all
// destination ports. See DestinationRule for examples.
type TrafficPolicy struct {
	// Settings controlling the load balancer algorithms.
	LoadBalancer *LoadBalancerSettings `protobuf:"bytes,1,opt,name=load_balancer,json=loadBalancer" json:"load_balancer,omitempty"`
	// Settings controlling the volume of connections to an upstream service
	ConnectionPool *ConnectionPoolSettings `protobuf:"bytes,2,opt,name=connection_pool,json=connectionPool" json:"connection_pool,omitempty"`
	// Settings controlling eviction of unhealthy hosts from the load balancing pool
	OutlierDetection *OutlierDetection `protobuf:"bytes,3,opt,name=outlier_detection,json=outlierDetection" json:"outlier_detection,omitempty"`
	// TLS related settings for connections to the upstream service.
	Tls *TLSSettings `protobuf:"bytes,4,opt,name=tls" json:"tls,omitempty"`
	// Traffic policies specific to individual ports. Note that port level
	// settings will override the destination-level settings. Traffic
	// settings specified at the destination-level will not be inherited when
	// overridden by port-level settings, i.e. default values will be applied
	// to fields omitted in port-level traffic policies.
	PortLevelSettings []*TrafficPolicy_PortTrafficPolicy `protobuf:"bytes,5,rep,name=port_level_settings,json=portLevelSettings" json:"port_level_settings,omitempty"`
}

func (m *TrafficPolicy) Reset()                    { *m = TrafficPolicy{} }
func (m *TrafficPolicy) String() string            { return proto.CompactTextString(m) }
func (*TrafficPolicy) ProtoMessage()               {}
func (*TrafficPolicy) Descriptor() ([]byte, []int) { return fileDescriptorDestinationRule, []int{1} }

func (m *TrafficPolicy) GetLoadBalancer() *LoadBalancerSettings {
	if m != nil {
		return m.LoadBalancer
	}
	return nil
}

func (m *TrafficPolicy) GetConnectionPool() *ConnectionPoolSettings {
	if m != nil {
		return m.ConnectionPool
	}
	return nil
}

func (m *TrafficPolicy) GetOutlierDetection() *OutlierDetection {
	if m != nil {
		return m.OutlierDetection
	}
	return nil
}

func (m *TrafficPolicy) GetTls() *TLSSettings {
	if m != nil {
		return m.Tls
	}
	return nil
}

func (m *TrafficPolicy) GetPortLevelSettings() []*TrafficPolicy_PortTrafficPolicy {
	if m != nil {
		return m.PortLevelSettings
	}
	return nil
}

// Traffic policies that apply to specific ports of the service
type TrafficPolicy_PortTrafficPolicy struct {
	// Specifies the port name or number of a port on the destination service
	// on which this policy is being applied.
	//
	// Names must comply with DNS label syntax (rfc1035) and therefore cannot
	// collide with numbers. If there are multiple ports on a service with
	// the same protocol the names should be of the form <protocol-name>-<DNS
	// label>.
	Port *PortSelector `protobuf:"bytes,1,opt,name=port" json:"port,omitempty"`
	// Settings controlling the load balancer algorithms.
	LoadBalancer *LoadBalancerSettings `protobuf:"bytes,2,opt,name=load_balancer,json=loadBalancer" json:"load_balancer,omitempty"`
	// Settings controlling the volume of connections to an upstream service
	ConnectionPool *ConnectionPoolSettings `protobuf:"bytes,3,opt,name=connection_pool,json=connectionPool" json:"connection_pool,omitempty"`
	// Settings controlling eviction of unhealthy hosts from the load balancing pool
	OutlierDetection *OutlierDetection `protobuf:"bytes,4,opt,name=outlier_detection,json=outlierDetection" json:"outlier_detection,omitempty"`
	// TLS related settings for connections to the upstream service.
	Tls *TLSSettings `protobuf:"bytes,5,opt,name=tls" json:"tls,omitempty"`
}

func (m *TrafficPolicy_PortTrafficPolicy) Reset()         { *m = TrafficPolicy_PortTrafficPolicy{} }
func (m *TrafficPolicy_PortTrafficPolicy) String() string { return proto.CompactTextString(m) }
func (*TrafficPolicy_PortTrafficPolicy) ProtoMessage()    {}
func (*TrafficPolicy_PortTrafficPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptorDestinationRule, []int{1, 0}
}

func (m *TrafficPolicy_PortTrafficPolicy) GetPort() *PortSelector {
	if m != nil {
		return m.Port
	}
	return nil
}

func (m *TrafficPolicy_PortTrafficPolicy) GetLoadBalancer() *LoadBalancerSettings {
	if m != nil {
		return m.LoadBalancer
	}
	return nil
}

func (m *TrafficPolicy_PortTrafficPolicy) GetConnectionPool() *ConnectionPoolSettings {
	if m != nil {
		return m.ConnectionPool
	}
	return nil
}

func (m *TrafficPolicy_PortTrafficPolicy) GetOutlierDetection() *OutlierDetection {
	if m != nil {
		return m.OutlierDetection
	}
	return nil
}

func (m *TrafficPolicy_PortTrafficPolicy) GetTls() *TLSSettings {
	if m != nil {
		return m.Tls
	}
	return nil
}

// A subset of endpoints of a service. Subsets can be used for scenarios
// like A/B testing, or routing to a specific version of a service. Refer
// to [VirtualService](#VirtualService) documentation for examples of using
// subsets in these scenarios. In addition, traffic policies defined at the
// service-level can be overridden at a subset-level. The following rule
// uses a round robin load balancing policy for all traffic going to a
// subset named testversion that is composed of endpoints (e.g., pods) with
// labels (version:v3).
//
//     apiVersion: networking.istio.io/v1alpha3
//     kind: DestinationRule
//     metadata:
//       name: bookinfo-ratings
//     spec:
//       host: ratings.prod.svc.cluster.local
//       trafficPolicy:
//         loadBalancer:
//           simple: LEAST_CONN
//       subsets:
//       - name: testversion
//         labels:
//           version: v3
//         trafficPolicy:
//           loadBalancer:
//             simple: ROUND_ROBIN
//
// **Note:** Policies specified for subsets will not take effect until
// a route rule explicitly sends traffic to this subset.
type Subset struct {
	// REQUIRED. Name of the subset. The service name and the subset name can
	// be used for traffic splitting in a route rule.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// REQUIRED. Labels apply a filter over the endpoints of a service in the
	// service registry. See route rules for examples of usage.
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Traffic policies that apply to this subset. Subsets inherit the
	// traffic policies specified at the DestinationRule level. Settings
	// specified at the subset level will override the corresponding settings
	// specified at the DestinationRule level.
	TrafficPolicy *TrafficPolicy `protobuf:"bytes,3,opt,name=traffic_policy,json=trafficPolicy" json:"traffic_policy,omitempty"`
}

func (m *Subset) Reset()                    { *m = Subset{} }
func (m *Subset) String() string            { return proto.CompactTextString(m) }
func (*Subset) ProtoMessage()               {}
func (*Subset) Descriptor() ([]byte, []int) { return fileDescriptorDestinationRule, []int{2} }

func (m *Subset) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Subset) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Subset) GetTrafficPolicy() *TrafficPolicy {
	if m != nil {
		return m.TrafficPolicy
	}
	return nil
}

// Load balancing policies to apply for a specific destination. See Envoy's
// load balancing
// [documentation](https://www.envoyproxy.io/docs/envoy/latest/intro/arch_overview/load_balancing.html)
// for more details.
//
// For example, the following rule uses a round robin load balancing policy
// for all traffic going to the ratings service.
//
//     apiVersion: networking.istio.io/v1alpha3
//     kind: DestinationRule
//     metadata:
//       name: bookinfo-ratings
//     spec:
//       host: ratings.prod.svc.cluster.local
//       trafficPolicy:
//         loadBalancer:
//           simple: ROUND_ROBIN
//
// The following example uses the consistent hashing based load balancer
// for the same ratings service using the Cookie header as the hash key.
//
//     apiVersion: networking.istio.io/v1alpha3
//     kind: DestinationRule
//     metadata:
//       name: bookinfo-ratings
//     spec:
//       host: ratings.prod.svc.cluster.local
//       trafficPolicy:
//         loadBalancer:
//           consistentHash:
//             http_header: Cookie
//
type LoadBalancerSettings struct {
	// Upstream load balancing policy.
	//
	// Types that are valid to be assigned to LbPolicy:
	//	*LoadBalancerSettings_Simple
	//	*LoadBalancerSettings_ConsistentHash
	LbPolicy isLoadBalancerSettings_LbPolicy `protobuf_oneof:"lb_policy"`
}

func (m *LoadBalancerSettings) Reset()         { *m = LoadBalancerSettings{} }
func (m *LoadBalancerSettings) String() string { return proto.CompactTextString(m) }
func (*LoadBalancerSettings) ProtoMessage()    {}
func (*LoadBalancerSettings) Descriptor() ([]byte, []int) {
	return fileDescriptorDestinationRule, []int{3}
}

type isLoadBalancerSettings_LbPolicy interface {
	isLoadBalancerSettings_LbPolicy()
	MarshalTo([]byte) (int, error)
	Size() int
}

type LoadBalancerSettings_Simple struct {
	Simple LoadBalancerSettings_SimpleLB `protobuf:"varint,1,opt,name=simple,proto3,enum=istio.networking.v1alpha3.LoadBalancerSettings_SimpleLB,oneof"`
}
type LoadBalancerSettings_ConsistentHash struct {
	ConsistentHash *LoadBalancerSettings_ConsistentHashLB `protobuf:"bytes,2,opt,name=consistent_hash,json=consistentHash,oneof"`
}

func (*LoadBalancerSettings_Simple) isLoadBalancerSettings_LbPolicy()         {}
func (*LoadBalancerSettings_ConsistentHash) isLoadBalancerSettings_LbPolicy() {}

func (m *LoadBalancerSettings) GetLbPolicy() isLoadBalancerSettings_LbPolicy {
	if m != nil {
		return m.LbPolicy
	}
	return nil
}

func (m *LoadBalancerSettings) GetSimple() LoadBalancerSettings_SimpleLB {
	if x, ok := m.GetLbPolicy().(*LoadBalancerSettings_Simple); ok {
		return x.Simple
	}
	return LoadBalancerSettings_ROUND_ROBIN
}

func (m *LoadBalancerSettings) GetConsistentHash() *LoadBalancerSettings_ConsistentHashLB {
	if x, ok := m.GetLbPolicy().(*LoadBalancerSettings_ConsistentHash); ok {
		return x.ConsistentHash
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*LoadBalancerSettings) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _LoadBalancerSettings_OneofMarshaler, _LoadBalancerSettings_OneofUnmarshaler, _LoadBalancerSettings_OneofSizer, []interface{}{
		(*LoadBalancerSettings_Simple)(nil),
		(*LoadBalancerSettings_ConsistentHash)(nil),
	}
}

func _LoadBalancerSettings_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*LoadBalancerSettings)
	// lb_policy
	switch x := m.LbPolicy.(type) {
	case *LoadBalancerSettings_Simple:
		_ = b.EncodeVarint(1<<3 | proto.WireVarint)
		_ = b.EncodeVarint(uint64(x.Simple))
	case *LoadBalancerSettings_ConsistentHash:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ConsistentHash); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("LoadBalancerSettings.LbPolicy has unexpected type %T", x)
	}
	return nil
}

func _LoadBalancerSettings_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*LoadBalancerSettings)
	switch tag {
	case 1: // lb_policy.simple
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.LbPolicy = &LoadBalancerSettings_Simple{LoadBalancerSettings_SimpleLB(x)}
		return true, err
	case 2: // lb_policy.consistent_hash
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(LoadBalancerSettings_ConsistentHashLB)
		err := b.DecodeMessage(msg)
		m.LbPolicy = &LoadBalancerSettings_ConsistentHash{msg}
		return true, err
	default:
		return false, nil
	}
}

func _LoadBalancerSettings_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*LoadBalancerSettings)
	// lb_policy
	switch x := m.LbPolicy.(type) {
	case *LoadBalancerSettings_Simple:
		n += proto.SizeVarint(1<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.Simple))
	case *LoadBalancerSettings_ConsistentHash:
		s := proto.Size(x.ConsistentHash)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Consistent hashing (ketama hash) based load balancer for even load
// distribution/redistribution when the connection pool changes. This
// load balancing policy is applicable only for HTTP-based
// connections. A user specified HTTP header is used as the key with
// [xxHash](http://cyan4973.github.io/xxHash) hashing.
type LoadBalancerSettings_ConsistentHashLB struct {
	// REQUIRED. The name of the HTTP request header that will be used to
	// obtain the hash key. If the request header is not present, the load
	// balancer will use a random number as the hash, effectively making
	// the load balancing policy random.
	HttpHeader string `protobuf:"bytes,1,opt,name=http_header,json=httpHeader,proto3" json:"http_header,omitempty"`
	// The minimum number of virtual nodes to use for the hash
	// ring. Defaults to 1024. Larger ring sizes result in more granular
	// load distributions. If the number of hosts in the load balancing
	// pool is larger than the ring size, each host will be assigned a
	// single virtual node.
	MinimumRingSize uint32 `protobuf:"varint,2,opt,name=minimum_ring_size,json=minimumRingSize,proto3" json:"minimum_ring_size,omitempty"`
}

func (m *LoadBalancerSettings_ConsistentHashLB) Reset()         { *m = LoadBalancerSettings_ConsistentHashLB{} }
func (m *LoadBalancerSettings_ConsistentHashLB) String() string { return proto.CompactTextString(m) }
func (*LoadBalancerSettings_ConsistentHashLB) ProtoMessage()    {}
func (*LoadBalancerSettings_ConsistentHashLB) Descriptor() ([]byte, []int) {
	return fileDescriptorDestinationRule, []int{3, 0}
}

func (m *LoadBalancerSettings_ConsistentHashLB) GetHttpHeader() string {
	if m != nil {
		return m.HttpHeader
	}
	return ""
}

func (m *LoadBalancerSettings_ConsistentHashLB) GetMinimumRingSize() uint32 {
	if m != nil {
		return m.MinimumRingSize
	}
	return 0
}

// Connection pool settings for an upstream host. The settings apply to
// each individual host in the upstream service.  See Envoy's [circuit
// breaker](https://www.envoyproxy.io/docs/envoy/latest/intro/arch_overview/circuit_breaking)
// for more details. Connection pool settings can be applied at the TCP
// level as well as at HTTP level.
//
// For example, the following rule sets a limit of 100 connections to redis
// service called myredissrv with a connect timeout of 30ms
//
//     apiVersion: networking.istio.io/v1alpha3
//     kind: DestinationRule
//     metadata:
//       name: bookinfo-redis
//     spec:
//       host: myredissrv.prod.svc.cluster.local
//       trafficPolicy:
//         connectionPool:
//           tcp:
//             maxConnections: 100
//             connectTimeout: 30ms
//
type ConnectionPoolSettings struct {
	// Settings common to both HTTP and TCP upstream connections.
	Tcp *ConnectionPoolSettings_TCPSettings `protobuf:"bytes,1,opt,name=tcp" json:"tcp,omitempty"`
	// HTTP connection pool settings.
	Http *ConnectionPoolSettings_HTTPSettings `protobuf:"bytes,2,opt,name=http" json:"http,omitempty"`
}

func (m *ConnectionPoolSettings) Reset()         { *m = ConnectionPoolSettings{} }
func (m *ConnectionPoolSettings) String() string { return proto.CompactTextString(m) }
func (*ConnectionPoolSettings) ProtoMessage()    {}
func (*ConnectionPoolSettings) Descriptor() ([]byte, []int) {
	return fileDescriptorDestinationRule, []int{4}
}

func (m *ConnectionPoolSettings) GetTcp() *ConnectionPoolSettings_TCPSettings {
	if m != nil {
		return m.Tcp
	}
	return nil
}

func (m *ConnectionPoolSettings) GetHttp() *ConnectionPoolSettings_HTTPSettings {
	if m != nil {
		return m.Http
	}
	return nil
}

// Settings common to both HTTP and TCP upstream connections.
type ConnectionPoolSettings_TCPSettings struct {
	// Maximum number of HTTP1 /TCP connections to a destination host.
	MaxConnections int32 `protobuf:"varint,1,opt,name=max_connections,json=maxConnections,proto3" json:"max_connections,omitempty"`
	// TCP connection timeout.
	ConnectTimeout *google_protobuf.Duration `protobuf:"bytes,2,opt,name=connect_timeout,json=connectTimeout" json:"connect_timeout,omitempty"`
}

func (m *ConnectionPoolSettings_TCPSettings) Reset()         { *m = ConnectionPoolSettings_TCPSettings{} }
func (m *ConnectionPoolSettings_TCPSettings) String() string { return proto.CompactTextString(m) }
func (*ConnectionPoolSettings_TCPSettings) ProtoMessage()    {}
func (*ConnectionPoolSettings_TCPSettings) Descriptor() ([]byte, []int) {
	return fileDescriptorDestinationRule, []int{4, 0}
}

func (m *ConnectionPoolSettings_TCPSettings) GetMaxConnections() int32 {
	if m != nil {
		return m.MaxConnections
	}
	return 0
}

func (m *ConnectionPoolSettings_TCPSettings) GetConnectTimeout() *google_protobuf.Duration {
	if m != nil {
		return m.ConnectTimeout
	}
	return nil
}

// Settings applicable to HTTP1.1/HTTP2/GRPC connections.
type ConnectionPoolSettings_HTTPSettings struct {
	// Maximum number of pending HTTP requests to a destination. Default 1024.
	Http1MaxPendingRequests int32 `protobuf:"varint,1,opt,name=http1_max_pending_requests,json=http1MaxPendingRequests,proto3" json:"http1_max_pending_requests,omitempty"`
	// Maximum number of requests to a backend. Default 1024.
	Http2MaxRequests int32 `protobuf:"varint,2,opt,name=http2_max_requests,json=http2MaxRequests,proto3" json:"http2_max_requests,omitempty"`
	// Maximum number of requests per connection to a backend. Setting this
	// parameter to 1 disables keep alive.
	MaxRequestsPerConnection int32 `protobuf:"varint,3,opt,name=max_requests_per_connection,json=maxRequestsPerConnection,proto3" json:"max_requests_per_connection,omitempty"`
	// Maximum number of retries that can be outstanding to all hosts in a
	// cluster at a given time. Defaults to 3.
	MaxRetries int32 `protobuf:"varint,4,opt,name=max_retries,json=maxRetries,proto3" json:"max_retries,omitempty"`
}

func (m *ConnectionPoolSettings_HTTPSettings) Reset()         { *m = ConnectionPoolSettings_HTTPSettings{} }
func (m *ConnectionPoolSettings_HTTPSettings) String() string { return proto.CompactTextString(m) }
func (*ConnectionPoolSettings_HTTPSettings) ProtoMessage()    {}
func (*ConnectionPoolSettings_HTTPSettings) Descriptor() ([]byte, []int) {
	return fileDescriptorDestinationRule, []int{4, 1}
}

func (m *ConnectionPoolSettings_HTTPSettings) GetHttp1MaxPendingRequests() int32 {
	if m != nil {
		return m.Http1MaxPendingRequests
	}
	return 0
}

func (m *ConnectionPoolSettings_HTTPSettings) GetHttp2MaxRequests() int32 {
	if m != nil {
		return m.Http2MaxRequests
	}
	return 0
}

func (m *ConnectionPoolSettings_HTTPSettings) GetMaxRequestsPerConnection() int32 {
	if m != nil {
		return m.MaxRequestsPerConnection
	}
	return 0
}

func (m *ConnectionPoolSettings_HTTPSettings) GetMaxRetries() int32 {
	if m != nil {
		return m.MaxRetries
	}
	return 0
}

// A Circuit breaker implementation that tracks the status of each
// individual host in the upstream service.  While currently applicable to
// only HTTP services, future versions will support opaque TCP services as
// well. For HTTP services, hosts that continually return errors for API
// calls are ejected from the pool for a pre-defined period of time. See
// Envoy's [outlier
// detection](https://www.envoyproxy.io/docs/envoy/latest/intro/arch_overview/outlier)
// for more details.
//
// The following rule sets a connection pool size of 100 connections and
// 1000 concurrent HTTP2 requests, with no more than 10 req/connection to
// "reviews" service. In addition, it configures upstream hosts to be
// scanned every 5 mins, such that any host that fails 7 consecutive times
// with 5XX error code will be ejected for 15 minutes.
//
//     apiVersion: networking.istio.io/v1alpha3
//     kind: DestinationRule
//     metadata:
//       name: reviews-cb-policy
//     spec:
//       host: reviews.prod.svc.cluster.local
//       trafficPolicy:
//         connectionPool:
//           tcp:
//             maxConnections: 100
//           http:
//             http2MaxRequests: 1000
//             maxRequestsPerConnection: 10
//         outlierDetection:
//           http:
//             consecutiveErrors: 7
//             interval: 5m
//             baseEjectionTime: 15m
//
type OutlierDetection struct {
	// Settings for HTTP1.1/HTTP2/GRPC connections.
	Http *OutlierDetection_HTTPSettings `protobuf:"bytes,1,opt,name=http" json:"http,omitempty"`
}

func (m *OutlierDetection) Reset()                    { *m = OutlierDetection{} }
func (m *OutlierDetection) String() string            { return proto.CompactTextString(m) }
func (*OutlierDetection) ProtoMessage()               {}
func (*OutlierDetection) Descriptor() ([]byte, []int) { return fileDescriptorDestinationRule, []int{5} }

func (m *OutlierDetection) GetHttp() *OutlierDetection_HTTPSettings {
	if m != nil {
		return m.Http
	}
	return nil
}

// Outlier detection settings for HTTP1.1/HTTP2/GRPC connections.
type OutlierDetection_HTTPSettings struct {
	// Number of 5XX errors before a host is ejected from the connection
	// pool. Defaults to 5.
	ConsecutiveErrors int32 `protobuf:"varint,1,opt,name=consecutive_errors,json=consecutiveErrors,proto3" json:"consecutive_errors,omitempty"`
	// Time interval between ejection sweep analysis. format:
	// 1h/1m/1s/1ms. MUST BE >=1ms. Default is 10s.
	Interval *google_protobuf.Duration `protobuf:"bytes,2,opt,name=interval" json:"interval,omitempty"`
	// Minimum ejection duration. A host will remain ejected for a period
	// equal to the product of minimum ejection duration and the number of
	// times the host has been ejected. This technique allows the system to
	// automatically increase the ejection period for unhealthy upstream
	// servers. format: 1h/1m/1s/1ms. MUST BE >=1ms. Default is 30s.
	BaseEjectionTime *google_protobuf.Duration `protobuf:"bytes,3,opt,name=base_ejection_time,json=baseEjectionTime" json:"base_ejection_time,omitempty"`
	// Maximum % of hosts in the load balancing pool for the upstream
	// service that can be ejected. Defaults to 10%.
	MaxEjectionPercent int32 `protobuf:"varint,4,opt,name=max_ejection_percent,json=maxEjectionPercent,proto3" json:"max_ejection_percent,omitempty"`
}

func (m *OutlierDetection_HTTPSettings) Reset()         { *m = OutlierDetection_HTTPSettings{} }
func (m *OutlierDetection_HTTPSettings) String() string { return proto.CompactTextString(m) }
func (*OutlierDetection_HTTPSettings) ProtoMessage()    {}
func (*OutlierDetection_HTTPSettings) Descriptor() ([]byte, []int) {
	return fileDescriptorDestinationRule, []int{5, 0}
}

func (m *OutlierDetection_HTTPSettings) GetConsecutiveErrors() int32 {
	if m != nil {
		return m.ConsecutiveErrors
	}
	return 0
}

func (m *OutlierDetection_HTTPSettings) GetInterval() *google_protobuf.Duration {
	if m != nil {
		return m.Interval
	}
	return nil
}

func (m *OutlierDetection_HTTPSettings) GetBaseEjectionTime() *google_protobuf.Duration {
	if m != nil {
		return m.BaseEjectionTime
	}
	return nil
}

func (m *OutlierDetection_HTTPSettings) GetMaxEjectionPercent() int32 {
	if m != nil {
		return m.MaxEjectionPercent
	}
	return 0
}

// SSL/TLS related settings for upstream connections. See Envoy's [TLS
// context](https://www.envoyproxy.io/docs/envoy/latest/api-v1/cluster_manager/cluster_ssl.html#config-cluster-manager-cluster-ssl)
// for more details. These settings are common to both HTTP and TCP upstreams.
//
// For example, the following rule configures a client to use mutual TLS
// for connections to upstream database cluster.
//
//     apiVersion: networking.istio.io/v1alpha3
//     kind: DestinationRule
//     metadata:
//       name: db-mtls
//     spec:
//       host: mydbserver.prod.svc.cluster.local
//       trafficPolicy:
//         tls:
//           mode: MUTUAL
//           clientCertificate: /etc/certs/myclientcert.pem
//           privateKey: /etc/certs/client_private_key.pem
//           caCertificates: /etc/certs/rootcacerts.pem
//
// The following rule configures a client to use TLS when talking to a
// foreign service whose domain matches *.foo.com.
//
//     apiVersion: networking.istio.io/v1alpha3
//     kind: DestinationRule
//     metadata:
//       name: tls-foo
//     spec:
//       host: "*.foo.com"
//       trafficPolicy:
//         tls:
//           mode: SIMPLE
//
// The following rule configures a client to use Istio mutual TLS when talking
// to rating services.
//     apiVersion: networking.istio.io/v1alpha3
//     kind: DestinationRule
//     metadata:
//       name: ratings-istio-mtls
//     spec:
//       host: ratings.prod.svc.cluster.local
//       trafficPolicy:
//         tls:
//           mode: ISTIO_MUTUAL
type TLSSettings struct {
	// REQUIRED: Indicates whether connections to this port should be secured
	// using TLS. The value of this field determines how TLS is enforced.
	Mode TLSSettings_TLSmode `protobuf:"varint,1,opt,name=mode,proto3,enum=istio.networking.v1alpha3.TLSSettings_TLSmode" json:"mode,omitempty"`
	// REQUIRED if mode is `MUTUAL`. The path to the file holding the
	// client-side TLS certificate to use.
	// Should be empty if mode is `ISTIO_MUTUAL`.
	ClientCertificate string `protobuf:"bytes,2,opt,name=client_certificate,json=clientCertificate,proto3" json:"client_certificate,omitempty"`
	// REQUIRED if mode is `MUTUAL`. The path to the file holding the
	// client's private key.
	// Should be empty if mode is `ISTIO_MUTUAL`.
	PrivateKey string `protobuf:"bytes,3,opt,name=private_key,json=privateKey,proto3" json:"private_key,omitempty"`
	// OPTIONAL: The path to the file containing certificate authority
	// certificates to use in verifying a presented server certificate. If
	// omitted, the proxy will not verify the server's certificate.
	// Should be empty if mode is `ISTIO_MUTUAL`.
	CaCertificates string `protobuf:"bytes,4,opt,name=ca_certificates,json=caCertificates,proto3" json:"ca_certificates,omitempty"`
	// A list of alternate names to verify the subject identity in the
	// certificate. If specified, the proxy will verify that the server
	// certificate's subject alt name matches one of the specified values.
	// Should be empty if mode is `ISTIO_MUTUAL`.
	SubjectAltNames []string `protobuf:"bytes,5,rep,name=subject_alt_names,json=subjectAltNames" json:"subject_alt_names,omitempty"`
	// SNI string to present to the server during TLS handshake.
	// Should be empty if mode is `ISTIO_MUTUAL`.
	Sni string `protobuf:"bytes,6,opt,name=sni,proto3" json:"sni,omitempty"`
}

func (m *TLSSettings) Reset()                    { *m = TLSSettings{} }
func (m *TLSSettings) String() string            { return proto.CompactTextString(m) }
func (*TLSSettings) ProtoMessage()               {}
func (*TLSSettings) Descriptor() ([]byte, []int) { return fileDescriptorDestinationRule, []int{6} }

func (m *TLSSettings) GetMode() TLSSettings_TLSmode {
	if m != nil {
		return m.Mode
	}
	return TLSSettings_DISABLE
}

func (m *TLSSettings) GetClientCertificate() string {
	if m != nil {
		return m.ClientCertificate
	}
	return ""
}

func (m *TLSSettings) GetPrivateKey() string {
	if m != nil {
		return m.PrivateKey
	}
	return ""
}

func (m *TLSSettings) GetCaCertificates() string {
	if m != nil {
		return m.CaCertificates
	}
	return ""
}

func (m *TLSSettings) GetSubjectAltNames() []string {
	if m != nil {
		return m.SubjectAltNames
	}
	return nil
}

func (m *TLSSettings) GetSni() string {
	if m != nil {
		return m.Sni
	}
	return ""
}

func init() {
	proto.RegisterType((*DestinationRule)(nil), "istio.networking.v1alpha3.DestinationRule")
	proto.RegisterType((*TrafficPolicy)(nil), "istio.networking.v1alpha3.TrafficPolicy")
	proto.RegisterType((*TrafficPolicy_PortTrafficPolicy)(nil), "istio.networking.v1alpha3.TrafficPolicy.PortTrafficPolicy")
	proto.RegisterType((*Subset)(nil), "istio.networking.v1alpha3.Subset")
	proto.RegisterType((*LoadBalancerSettings)(nil), "istio.networking.v1alpha3.LoadBalancerSettings")
	proto.RegisterType((*LoadBalancerSettings_ConsistentHashLB)(nil), "istio.networking.v1alpha3.LoadBalancerSettings.ConsistentHashLB")
	proto.RegisterType((*ConnectionPoolSettings)(nil), "istio.networking.v1alpha3.ConnectionPoolSettings")
	proto.RegisterType((*ConnectionPoolSettings_TCPSettings)(nil), "istio.networking.v1alpha3.ConnectionPoolSettings.TCPSettings")
	proto.RegisterType((*ConnectionPoolSettings_HTTPSettings)(nil), "istio.networking.v1alpha3.ConnectionPoolSettings.HTTPSettings")
	proto.RegisterType((*OutlierDetection)(nil), "istio.networking.v1alpha3.OutlierDetection")
	proto.RegisterType((*OutlierDetection_HTTPSettings)(nil), "istio.networking.v1alpha3.OutlierDetection.HTTPSettings")
	proto.RegisterType((*TLSSettings)(nil), "istio.networking.v1alpha3.TLSSettings")
	proto.RegisterEnum("istio.networking.v1alpha3.LoadBalancerSettings_SimpleLB", LoadBalancerSettings_SimpleLB_name, LoadBalancerSettings_SimpleLB_value)
	proto.RegisterEnum("istio.networking.v1alpha3.TLSSettings_TLSmode", TLSSettings_TLSmode_name, TLSSettings_TLSmode_value)
}
func (m *DestinationRule) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DestinationRule) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Host) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintDestinationRule(dAtA, i, uint64(len(m.Host)))
		i += copy(dAtA[i:], m.Host)
	}
	if m.TrafficPolicy != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintDestinationRule(dAtA, i, uint64(m.TrafficPolicy.Size()))
		n1, err := m.TrafficPolicy.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if len(m.Subsets) > 0 {
		for _, msg := range m.Subsets {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintDestinationRule(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *TrafficPolicy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TrafficPolicy) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.LoadBalancer != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintDestinationRule(dAtA, i, uint64(m.LoadBalancer.Size()))
		n2, err := m.LoadBalancer.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.ConnectionPool != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintDestinationRule(dAtA, i, uint64(m.ConnectionPool.Size()))
		n3, err := m.ConnectionPool.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.OutlierDetection != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintDestinationRule(dAtA, i, uint64(m.OutlierDetection.Size()))
		n4, err := m.OutlierDetection.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.Tls != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintDestinationRule(dAtA, i, uint64(m.Tls.Size()))
		n5, err := m.Tls.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if len(m.PortLevelSettings) > 0 {
		for _, msg := range m.PortLevelSettings {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintDestinationRule(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *TrafficPolicy_PortTrafficPolicy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TrafficPolicy_PortTrafficPolicy) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Port != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintDestinationRule(dAtA, i, uint64(m.Port.Size()))
		n6, err := m.Port.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.LoadBalancer != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintDestinationRule(dAtA, i, uint64(m.LoadBalancer.Size()))
		n7, err := m.LoadBalancer.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.ConnectionPool != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintDestinationRule(dAtA, i, uint64(m.ConnectionPool.Size()))
		n8, err := m.ConnectionPool.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.OutlierDetection != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintDestinationRule(dAtA, i, uint64(m.OutlierDetection.Size()))
		n9, err := m.OutlierDetection.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if m.Tls != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintDestinationRule(dAtA, i, uint64(m.Tls.Size()))
		n10, err := m.Tls.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	return i, nil
}

func (m *Subset) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Subset) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintDestinationRule(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Labels) > 0 {
		for k, _ := range m.Labels {
			dAtA[i] = 0x12
			i++
			v := m.Labels[k]
			mapSize := 1 + len(k) + sovDestinationRule(uint64(len(k))) + 1 + len(v) + sovDestinationRule(uint64(len(v)))
			i = encodeVarintDestinationRule(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintDestinationRule(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintDestinationRule(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	if m.TrafficPolicy != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintDestinationRule(dAtA, i, uint64(m.TrafficPolicy.Size()))
		n11, err := m.TrafficPolicy.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	return i, nil
}

func (m *LoadBalancerSettings) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LoadBalancerSettings) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.LbPolicy != nil {
		nn12, err := m.LbPolicy.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn12
	}
	return i, nil
}

func (m *LoadBalancerSettings_Simple) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x8
	i++
	i = encodeVarintDestinationRule(dAtA, i, uint64(m.Simple))
	return i, nil
}
func (m *LoadBalancerSettings_ConsistentHash) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ConsistentHash != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintDestinationRule(dAtA, i, uint64(m.ConsistentHash.Size()))
		n13, err := m.ConsistentHash.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	return i, nil
}
func (m *LoadBalancerSettings_ConsistentHashLB) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LoadBalancerSettings_ConsistentHashLB) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.HttpHeader) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintDestinationRule(dAtA, i, uint64(len(m.HttpHeader)))
		i += copy(dAtA[i:], m.HttpHeader)
	}
	if m.MinimumRingSize != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintDestinationRule(dAtA, i, uint64(m.MinimumRingSize))
	}
	return i, nil
}

func (m *ConnectionPoolSettings) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConnectionPoolSettings) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Tcp != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintDestinationRule(dAtA, i, uint64(m.Tcp.Size()))
		n14, err := m.Tcp.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	if m.Http != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintDestinationRule(dAtA, i, uint64(m.Http.Size()))
		n15, err := m.Http.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	return i, nil
}

func (m *ConnectionPoolSettings_TCPSettings) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConnectionPoolSettings_TCPSettings) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.MaxConnections != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintDestinationRule(dAtA, i, uint64(m.MaxConnections))
	}
	if m.ConnectTimeout != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintDestinationRule(dAtA, i, uint64(m.ConnectTimeout.Size()))
		n16, err := m.ConnectTimeout.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	return i, nil
}

func (m *ConnectionPoolSettings_HTTPSettings) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConnectionPoolSettings_HTTPSettings) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Http1MaxPendingRequests != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintDestinationRule(dAtA, i, uint64(m.Http1MaxPendingRequests))
	}
	if m.Http2MaxRequests != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintDestinationRule(dAtA, i, uint64(m.Http2MaxRequests))
	}
	if m.MaxRequestsPerConnection != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintDestinationRule(dAtA, i, uint64(m.MaxRequestsPerConnection))
	}
	if m.MaxRetries != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintDestinationRule(dAtA, i, uint64(m.MaxRetries))
	}
	return i, nil
}

func (m *OutlierDetection) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OutlierDetection) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Http != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintDestinationRule(dAtA, i, uint64(m.Http.Size()))
		n17, err := m.Http.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n17
	}
	return i, nil
}

func (m *OutlierDetection_HTTPSettings) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OutlierDetection_HTTPSettings) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ConsecutiveErrors != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintDestinationRule(dAtA, i, uint64(m.ConsecutiveErrors))
	}
	if m.Interval != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintDestinationRule(dAtA, i, uint64(m.Interval.Size()))
		n18, err := m.Interval.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n18
	}
	if m.BaseEjectionTime != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintDestinationRule(dAtA, i, uint64(m.BaseEjectionTime.Size()))
		n19, err := m.BaseEjectionTime.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n19
	}
	if m.MaxEjectionPercent != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintDestinationRule(dAtA, i, uint64(m.MaxEjectionPercent))
	}
	return i, nil
}

func (m *TLSSettings) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TLSSettings) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Mode != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintDestinationRule(dAtA, i, uint64(m.Mode))
	}
	if len(m.ClientCertificate) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintDestinationRule(dAtA, i, uint64(len(m.ClientCertificate)))
		i += copy(dAtA[i:], m.ClientCertificate)
	}
	if len(m.PrivateKey) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintDestinationRule(dAtA, i, uint64(len(m.PrivateKey)))
		i += copy(dAtA[i:], m.PrivateKey)
	}
	if len(m.CaCertificates) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintDestinationRule(dAtA, i, uint64(len(m.CaCertificates)))
		i += copy(dAtA[i:], m.CaCertificates)
	}
	if len(m.SubjectAltNames) > 0 {
		for _, s := range m.SubjectAltNames {
			dAtA[i] = 0x2a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.Sni) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintDestinationRule(dAtA, i, uint64(len(m.Sni)))
		i += copy(dAtA[i:], m.Sni)
	}
	return i, nil
}

func encodeVarintDestinationRule(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *DestinationRule) Size() (n int) {
	var l int
	_ = l
	l = len(m.Host)
	if l > 0 {
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if m.TrafficPolicy != nil {
		l = m.TrafficPolicy.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if len(m.Subsets) > 0 {
		for _, e := range m.Subsets {
			l = e.Size()
			n += 1 + l + sovDestinationRule(uint64(l))
		}
	}
	return n
}

func (m *TrafficPolicy) Size() (n int) {
	var l int
	_ = l
	if m.LoadBalancer != nil {
		l = m.LoadBalancer.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if m.ConnectionPool != nil {
		l = m.ConnectionPool.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if m.OutlierDetection != nil {
		l = m.OutlierDetection.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if m.Tls != nil {
		l = m.Tls.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if len(m.PortLevelSettings) > 0 {
		for _, e := range m.PortLevelSettings {
			l = e.Size()
			n += 1 + l + sovDestinationRule(uint64(l))
		}
	}
	return n
}

func (m *TrafficPolicy_PortTrafficPolicy) Size() (n int) {
	var l int
	_ = l
	if m.Port != nil {
		l = m.Port.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if m.LoadBalancer != nil {
		l = m.LoadBalancer.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if m.ConnectionPool != nil {
		l = m.ConnectionPool.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if m.OutlierDetection != nil {
		l = m.OutlierDetection.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if m.Tls != nil {
		l = m.Tls.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	return n
}

func (m *Subset) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if len(m.Labels) > 0 {
		for k, v := range m.Labels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovDestinationRule(uint64(len(k))) + 1 + len(v) + sovDestinationRule(uint64(len(v)))
			n += mapEntrySize + 1 + sovDestinationRule(uint64(mapEntrySize))
		}
	}
	if m.TrafficPolicy != nil {
		l = m.TrafficPolicy.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	return n
}

func (m *LoadBalancerSettings) Size() (n int) {
	var l int
	_ = l
	if m.LbPolicy != nil {
		n += m.LbPolicy.Size()
	}
	return n
}

func (m *LoadBalancerSettings_Simple) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovDestinationRule(uint64(m.Simple))
	return n
}
func (m *LoadBalancerSettings_ConsistentHash) Size() (n int) {
	var l int
	_ = l
	if m.ConsistentHash != nil {
		l = m.ConsistentHash.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	return n
}
func (m *LoadBalancerSettings_ConsistentHashLB) Size() (n int) {
	var l int
	_ = l
	l = len(m.HttpHeader)
	if l > 0 {
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if m.MinimumRingSize != 0 {
		n += 1 + sovDestinationRule(uint64(m.MinimumRingSize))
	}
	return n
}

func (m *ConnectionPoolSettings) Size() (n int) {
	var l int
	_ = l
	if m.Tcp != nil {
		l = m.Tcp.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if m.Http != nil {
		l = m.Http.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	return n
}

func (m *ConnectionPoolSettings_TCPSettings) Size() (n int) {
	var l int
	_ = l
	if m.MaxConnections != 0 {
		n += 1 + sovDestinationRule(uint64(m.MaxConnections))
	}
	if m.ConnectTimeout != nil {
		l = m.ConnectTimeout.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	return n
}

func (m *ConnectionPoolSettings_HTTPSettings) Size() (n int) {
	var l int
	_ = l
	if m.Http1MaxPendingRequests != 0 {
		n += 1 + sovDestinationRule(uint64(m.Http1MaxPendingRequests))
	}
	if m.Http2MaxRequests != 0 {
		n += 1 + sovDestinationRule(uint64(m.Http2MaxRequests))
	}
	if m.MaxRequestsPerConnection != 0 {
		n += 1 + sovDestinationRule(uint64(m.MaxRequestsPerConnection))
	}
	if m.MaxRetries != 0 {
		n += 1 + sovDestinationRule(uint64(m.MaxRetries))
	}
	return n
}

func (m *OutlierDetection) Size() (n int) {
	var l int
	_ = l
	if m.Http != nil {
		l = m.Http.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	return n
}

func (m *OutlierDetection_HTTPSettings) Size() (n int) {
	var l int
	_ = l
	if m.ConsecutiveErrors != 0 {
		n += 1 + sovDestinationRule(uint64(m.ConsecutiveErrors))
	}
	if m.Interval != nil {
		l = m.Interval.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if m.BaseEjectionTime != nil {
		l = m.BaseEjectionTime.Size()
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if m.MaxEjectionPercent != 0 {
		n += 1 + sovDestinationRule(uint64(m.MaxEjectionPercent))
	}
	return n
}

func (m *TLSSettings) Size() (n int) {
	var l int
	_ = l
	if m.Mode != 0 {
		n += 1 + sovDestinationRule(uint64(m.Mode))
	}
	l = len(m.ClientCertificate)
	if l > 0 {
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	l = len(m.PrivateKey)
	if l > 0 {
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	l = len(m.CaCertificates)
	if l > 0 {
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	if len(m.SubjectAltNames) > 0 {
		for _, s := range m.SubjectAltNames {
			l = len(s)
			n += 1 + l + sovDestinationRule(uint64(l))
		}
	}
	l = len(m.Sni)
	if l > 0 {
		n += 1 + l + sovDestinationRule(uint64(l))
	}
	return n
}

func sovDestinationRule(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozDestinationRule(x uint64) (n int) {
	return sovDestinationRule(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *DestinationRule) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDestinationRule
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DestinationRule: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DestinationRule: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Host", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Host = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TrafficPolicy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TrafficPolicy == nil {
				m.TrafficPolicy = &TrafficPolicy{}
			}
			if err := m.TrafficPolicy.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subsets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Subsets = append(m.Subsets, &Subset{})
			if err := m.Subsets[len(m.Subsets)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDestinationRule(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TrafficPolicy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDestinationRule
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TrafficPolicy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TrafficPolicy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LoadBalancer", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LoadBalancer == nil {
				m.LoadBalancer = &LoadBalancerSettings{}
			}
			if err := m.LoadBalancer.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnectionPool", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ConnectionPool == nil {
				m.ConnectionPool = &ConnectionPoolSettings{}
			}
			if err := m.ConnectionPool.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OutlierDetection", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.OutlierDetection == nil {
				m.OutlierDetection = &OutlierDetection{}
			}
			if err := m.OutlierDetection.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tls", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Tls == nil {
				m.Tls = &TLSSettings{}
			}
			if err := m.Tls.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PortLevelSettings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PortLevelSettings = append(m.PortLevelSettings, &TrafficPolicy_PortTrafficPolicy{})
			if err := m.PortLevelSettings[len(m.PortLevelSettings)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDestinationRule(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TrafficPolicy_PortTrafficPolicy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDestinationRule
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PortTrafficPolicy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PortTrafficPolicy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Port == nil {
				m.Port = &PortSelector{}
			}
			if err := m.Port.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LoadBalancer", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LoadBalancer == nil {
				m.LoadBalancer = &LoadBalancerSettings{}
			}
			if err := m.LoadBalancer.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnectionPool", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ConnectionPool == nil {
				m.ConnectionPool = &ConnectionPoolSettings{}
			}
			if err := m.ConnectionPool.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OutlierDetection", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.OutlierDetection == nil {
				m.OutlierDetection = &OutlierDetection{}
			}
			if err := m.OutlierDetection.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tls", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Tls == nil {
				m.Tls = &TLSSettings{}
			}
			if err := m.Tls.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDestinationRule(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Subset) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDestinationRule
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Subset: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Subset: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Labels == nil {
				m.Labels = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowDestinationRule
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowDestinationRule
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthDestinationRule
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowDestinationRule
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthDestinationRule
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipDestinationRule(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthDestinationRule
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Labels[mapkey] = mapvalue
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TrafficPolicy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TrafficPolicy == nil {
				m.TrafficPolicy = &TrafficPolicy{}
			}
			if err := m.TrafficPolicy.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDestinationRule(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LoadBalancerSettings) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDestinationRule
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LoadBalancerSettings: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LoadBalancerSettings: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Simple", wireType)
			}
			var v LoadBalancerSettings_SimpleLB
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (LoadBalancerSettings_SimpleLB(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.LbPolicy = &LoadBalancerSettings_Simple{v}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConsistentHash", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &LoadBalancerSettings_ConsistentHashLB{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.LbPolicy = &LoadBalancerSettings_ConsistentHash{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDestinationRule(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LoadBalancerSettings_ConsistentHashLB) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDestinationRule
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConsistentHashLB: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConsistentHashLB: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpHeader", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HttpHeader = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinimumRingSize", wireType)
			}
			m.MinimumRingSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MinimumRingSize |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipDestinationRule(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConnectionPoolSettings) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDestinationRule
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConnectionPoolSettings: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConnectionPoolSettings: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tcp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Tcp == nil {
				m.Tcp = &ConnectionPoolSettings_TCPSettings{}
			}
			if err := m.Tcp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Http", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Http == nil {
				m.Http = &ConnectionPoolSettings_HTTPSettings{}
			}
			if err := m.Http.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDestinationRule(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConnectionPoolSettings_TCPSettings) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDestinationRule
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TCPSettings: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TCPSettings: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxConnections", wireType)
			}
			m.MaxConnections = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxConnections |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnectTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ConnectTimeout == nil {
				m.ConnectTimeout = &google_protobuf.Duration{}
			}
			if err := m.ConnectTimeout.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDestinationRule(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConnectionPoolSettings_HTTPSettings) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDestinationRule
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HTTPSettings: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HTTPSettings: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Http1MaxPendingRequests", wireType)
			}
			m.Http1MaxPendingRequests = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Http1MaxPendingRequests |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Http2MaxRequests", wireType)
			}
			m.Http2MaxRequests = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Http2MaxRequests |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxRequestsPerConnection", wireType)
			}
			m.MaxRequestsPerConnection = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxRequestsPerConnection |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxRetries", wireType)
			}
			m.MaxRetries = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxRetries |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipDestinationRule(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OutlierDetection) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDestinationRule
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OutlierDetection: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OutlierDetection: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Http", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Http == nil {
				m.Http = &OutlierDetection_HTTPSettings{}
			}
			if err := m.Http.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDestinationRule(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OutlierDetection_HTTPSettings) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDestinationRule
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HTTPSettings: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HTTPSettings: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConsecutiveErrors", wireType)
			}
			m.ConsecutiveErrors = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ConsecutiveErrors |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Interval", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Interval == nil {
				m.Interval = &google_protobuf.Duration{}
			}
			if err := m.Interval.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BaseEjectionTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.BaseEjectionTime == nil {
				m.BaseEjectionTime = &google_protobuf.Duration{}
			}
			if err := m.BaseEjectionTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxEjectionPercent", wireType)
			}
			m.MaxEjectionPercent = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxEjectionPercent |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipDestinationRule(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TLSSettings) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDestinationRule
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TLSSettings: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TLSSettings: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mode", wireType)
			}
			m.Mode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Mode |= (TLSSettings_TLSmode(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientCertificate", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClientCertificate = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrivateKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PrivateKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CaCertificates", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CaCertificates = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubjectAltNames", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SubjectAltNames = append(m.SubjectAltNames, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sni", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDestinationRule
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Sni = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDestinationRule(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDestinationRule
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipDestinationRule(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowDestinationRule
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowDestinationRule
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthDestinationRule
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowDestinationRule
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipDestinationRule(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthDestinationRule = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowDestinationRule   = fmt.Errorf("proto: integer overflow")
)

func init() {
	proto.RegisterFile("networking/v1alpha3/destination_rule.proto", fileDescriptorDestinationRule)
}

var fileDescriptorDestinationRule = []byte{
	// 1192 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x56, 0xd1, 0x6e, 0x1b, 0x45,
	0x17, 0xae, 0xbd, 0x8e, 0xdb, 0x1c, 0x37, 0xce, 0x66, 0xfe, 0xea, 0xc7, 0x35, 0x52, 0x08, 0xbe,
	0xa0, 0xa1, 0xd0, 0x35, 0x4d, 0x85, 0x14, 0x5a, 0x15, 0x35, 0x4e, 0xac, 0x3a, 0xc2, 0x89, 0xad,
	0xb1, 0x23, 0xa1, 0xde, 0xac, 0xc6, 0xeb, 0x49, 0x3c, 0xed, 0x7a, 0x67, 0x99, 0x99, 0x35, 0x49,
	0x5f, 0x82, 0x2b, 0x78, 0x11, 0x5e, 0x02, 0x71, 0x85, 0xb8, 0x83, 0x2b, 0xd4, 0x17, 0xe8, 0x2b,
	0xa0, 0x99, 0x1d, 0xdb, 0x9b, 0x34, 0xb8, 0x8d, 0xa0, 0x77, 0xeb, 0x39, 0xe7, 0xfb, 0xe6, 0xcc,
	0x9c, 0x6f, 0xbe, 0x63, 0xb8, 0x1b, 0x51, 0xf5, 0x3d, 0x17, 0x2f, 0x58, 0x74, 0x52, 0x9f, 0xdc,
	0x27, 0x61, 0x3c, 0x22, 0x0f, 0xea, 0x43, 0x2a, 0x15, 0x8b, 0x88, 0x62, 0x3c, 0xf2, 0x45, 0x12,
	0x52, 0x2f, 0x16, 0x5c, 0x71, 0x74, 0x9b, 0x49, 0xc5, 0xb8, 0x37, 0x47, 0x78, 0x53, 0x44, 0x75,
	0xfd, 0x84, 0xf3, 0x93, 0x90, 0xd6, 0x4d, 0xe2, 0x20, 0x39, 0xae, 0x0f, 0x13, 0x61, 0xf0, 0x29,
	0xb4, 0xfa, 0xe9, 0x65, 0xdb, 0x4c, 0x98, 0x50, 0x09, 0x09, 0x7d, 0x49, 0xc5, 0x84, 0x05, 0x76,
	0x97, 0xda, 0xcf, 0x39, 0x58, 0xdd, 0x9b, 0x17, 0x80, 0x93, 0x90, 0x22, 0x04, 0x85, 0x11, 0x97,
	0xaa, 0x92, 0xdb, 0xc8, 0x6d, 0x2e, 0x63, 0xf3, 0x8d, 0x3a, 0x50, 0x56, 0x82, 0x1c, 0x1f, 0xb3,
	0xc0, 0x8f, 0x79, 0xc8, 0x82, 0xb3, 0x4a, 0x7e, 0x23, 0xb7, 0x59, 0xda, 0xda, 0xf4, 0xfe, 0xb1,
	0x4c, 0xaf, 0x9f, 0x02, 0xba, 0x26, 0x1f, 0xaf, 0xa8, 0xec, 0x4f, 0xf4, 0x08, 0xae, 0xcb, 0x64,
	0x20, 0xa9, 0x92, 0x15, 0x67, 0xc3, 0xd9, 0x2c, 0x6d, 0x7d, 0xbc, 0x80, 0xa9, 0x67, 0x32, 0xf1,
	0x14, 0x51, 0xfb, 0xb3, 0x08, 0x2b, 0xe7, 0xd8, 0x51, 0x1f, 0x56, 0x42, 0x4e, 0x86, 0xfe, 0x80,
	0x84, 0x24, 0x0a, 0xa8, 0x30, 0xc5, 0x97, 0xb6, 0xea, 0x0b, 0x48, 0xdb, 0x9c, 0x0c, 0x1b, 0x36,
	0xbd, 0x47, 0x95, 0x62, 0xd1, 0x89, 0xc4, 0x37, 0xc3, 0xcc, 0x2a, 0x7a, 0x06, 0xab, 0x01, 0x8f,
	0x22, 0x1a, 0x98, 0xe6, 0xc4, 0x9c, 0x87, 0xf6, 0xd8, 0xf7, 0x17, 0xf0, 0xee, 0xce, 0x10, 0x5d,
	0xce, 0xc3, 0x19, 0x73, 0x39, 0x38, 0xb7, 0x8e, 0xbe, 0x85, 0x35, 0x9e, 0xa8, 0x90, 0x51, 0xe1,
	0x0f, 0xa9, 0x4a, 0x03, 0x15, 0xc7, 0xb0, 0x7f, 0xb6, 0x80, 0xbd, 0x93, 0x62, 0xf6, 0xa6, 0x10,
	0xec, 0xf2, 0x0b, 0x2b, 0x68, 0x1b, 0x1c, 0x15, 0xca, 0x4a, 0xc1, 0x70, 0x7d, 0xb2, 0xa8, 0x41,
	0xed, 0xde, 0xac, 0x3c, 0x0d, 0x41, 0xcf, 0xe1, 0x7f, 0x31, 0x17, 0xca, 0x0f, 0xe9, 0x84, 0x6a,
	0xa5, 0xa4, 0xb1, 0xca, 0x92, 0x69, 0xd0, 0xc3, 0x77, 0x6d, 0xb5, 0xd7, 0xe5, 0x42, 0x9d, 0x6f,
	0xfe, 0x9a, 0xa6, 0x6d, 0x6b, 0xd6, 0xe9, 0x86, 0xd5, 0x9f, 0x1c, 0x58, 0x7b, 0x23, 0x11, 0x3d,
	0x82, 0x82, 0x4e, 0xb5, 0xed, 0xbb, 0xb3, 0x60, 0x4b, 0x8d, 0xed, 0xd1, 0x90, 0x06, 0x8a, 0x0b,
	0x6c, 0x40, 0x6f, 0x8a, 0x20, 0xff, 0x9e, 0x44, 0xe0, 0xbc, 0x57, 0x11, 0x14, 0xfe, 0x43, 0x11,
	0x2c, 0x5d, 0x59, 0x04, 0xb5, 0xd7, 0x39, 0x28, 0xa6, 0x0f, 0x4e, 0x3b, 0x41, 0x44, 0xc6, 0x74,
	0xea, 0x04, 0xfa, 0x1b, 0x35, 0xa1, 0x18, 0x92, 0x01, 0x0d, 0x65, 0x25, 0x6f, 0x64, 0x71, 0xef,
	0xad, 0xef, 0xd6, 0x6b, 0x9b, 0xfc, 0x66, 0xa4, 0xc4, 0x19, 0xb6, 0xe0, 0x4b, 0x0c, 0xc5, 0xf9,
	0x57, 0x86, 0x52, 0xfd, 0x0a, 0x4a, 0x99, 0x7d, 0x90, 0x0b, 0xce, 0x0b, 0x7a, 0x66, 0x2b, 0xd7,
	0x9f, 0xe8, 0x16, 0x2c, 0x4d, 0x48, 0x98, 0x50, 0xa3, 0x8a, 0x65, 0x9c, 0xfe, 0x78, 0x98, 0xdf,
	0xce, 0xd5, 0x7e, 0x70, 0xe0, 0xd6, 0x65, 0x42, 0x40, 0x18, 0x8a, 0x92, 0x8d, 0xe3, 0x30, 0xbd,
	0x81, 0xf2, 0xd6, 0xf6, 0x15, 0x95, 0xe4, 0xf5, 0x0c, 0xba, 0xdd, 0x68, 0x5d, 0xc3, 0x96, 0x09,
	0xbd, 0x30, 0x72, 0x92, 0x4c, 0x2a, 0x1a, 0x29, 0x7f, 0x44, 0xe4, 0xc8, 0xca, 0xf4, 0xc9, 0x55,
	0xc9, 0x77, 0x67, 0x34, 0x2d, 0x22, 0x47, 0x66, 0x93, 0x72, 0x70, 0x6e, 0xad, 0xea, 0x83, 0x7b,
	0x31, 0x0b, 0x7d, 0x04, 0xa5, 0x91, 0x52, 0xb1, 0x3f, 0xa2, 0x64, 0x68, 0x8d, 0x72, 0x19, 0x83,
	0x5e, 0x6a, 0x99, 0x15, 0x74, 0x17, 0xd6, 0xc6, 0x2c, 0x62, 0xe3, 0x64, 0xec, 0x0b, 0x16, 0x9d,
	0xf8, 0x92, 0xbd, 0x4c, 0x2f, 0x6d, 0x05, 0xaf, 0xda, 0x00, 0x66, 0xd1, 0x49, 0x8f, 0xbd, 0xa4,
	0xb5, 0x16, 0xdc, 0x98, 0x9e, 0x11, 0xad, 0x42, 0x09, 0x77, 0x8e, 0x0e, 0xf7, 0x7c, 0xdc, 0x69,
	0xec, 0x1f, 0xba, 0xd7, 0x50, 0x19, 0xa0, 0xdd, 0xdc, 0xe9, 0xf5, 0xfd, 0xdd, 0xce, 0xe1, 0xa1,
	0x9b, 0x43, 0x00, 0x45, 0xbc, 0x73, 0xb8, 0xd7, 0x39, 0x70, 0xf3, 0x3a, 0xb9, 0xbb, 0xd3, 0xeb,
	0xf5, 0x5b, 0xb8, 0x73, 0xf4, 0xb4, 0xe5, 0x3a, 0x8d, 0x12, 0x2c, 0x87, 0x03, 0xab, 0x85, 0xda,
	0x8f, 0x05, 0xf8, 0xff, 0xe5, 0x4f, 0x08, 0x75, 0xc0, 0x51, 0x41, 0x6c, 0x0d, 0xe2, 0xf1, 0x95,
	0x9f, 0xa0, 0xd7, 0xdf, 0xed, 0x66, 0xf4, 0x1e, 0xc4, 0x08, 0x43, 0x41, 0x1f, 0xde, 0x76, 0xe1,
	0xeb, 0xab, 0x33, 0xb6, 0xfa, 0xfd, 0x39, 0xa5, 0xe1, 0xaa, 0xbe, 0x84, 0x52, 0x66, 0x1f, 0x74,
	0x07, 0x56, 0xc7, 0xe4, 0xd4, 0x9f, 0x3f, 0x7e, 0x69, 0xea, 0x5f, 0xc2, 0xe5, 0x31, 0x39, 0x9d,
	0xb3, 0x4a, 0xd4, 0x98, 0x79, 0x8d, 0xaf, 0xd8, 0x98, 0xf2, 0x44, 0xd9, 0xb2, 0x6e, 0x7b, 0xe9,
	0xcc, 0xf7, 0xa6, 0x33, 0xdf, 0xdb, 0xb3, 0x33, 0x7f, 0xe6, 0x29, 0xfd, 0x14, 0x50, 0xfd, 0x23,
	0x07, 0x37, 0xb3, 0x25, 0xa1, 0x47, 0x50, 0xd5, 0x45, 0xdd, 0xf7, 0x75, 0x0d, 0x31, 0x8d, 0x86,
	0xba, 0xa9, 0x82, 0x7e, 0x97, 0x50, 0xa9, 0xa6, 0x85, 0x7c, 0x60, 0x32, 0x0e, 0xc8, 0x69, 0x37,
	0x8d, 0x63, 0x1b, 0x46, 0x9f, 0x03, 0xd2, 0xa1, 0x2d, 0x03, 0x9e, 0x81, 0xf2, 0x06, 0xe4, 0x9a,
	0xc8, 0x01, 0x39, 0x9d, 0x65, 0x3f, 0x86, 0x0f, 0xb3, 0x79, 0x7e, 0x4c, 0x45, 0xe6, 0xd4, 0xe6,
	0x89, 0x2f, 0xe1, 0xca, 0x78, 0x8e, 0xe8, 0x52, 0x31, 0x3f, 0xbf, 0x96, 0x66, 0x0a, 0x57, 0x82,
	0xd1, 0x74, 0x82, 0x2d, 0x61, 0x30, 0xe9, 0x66, 0xa5, 0xf6, 0x7b, 0x1e, 0xdc, 0x8b, 0xe6, 0x87,
	0xda, 0xb6, 0x81, 0xa9, 0x24, 0xb6, 0xaf, 0xe0, 0x9b, 0x97, 0xb5, 0xee, 0xf5, 0xc5, 0xeb, 0xbb,
	0x07, 0x48, 0xbf, 0x2a, 0x1a, 0x24, 0x8a, 0x4d, 0xa8, 0x4f, 0x85, 0xe0, 0x62, 0x7a, 0x6d, 0x6b,
	0x99, 0x48, 0xd3, 0x04, 0xd0, 0x97, 0x70, 0x83, 0x45, 0x8a, 0x8a, 0x09, 0x09, 0xdf, 0xde, 0xbb,
	0x59, 0x2a, 0x7a, 0x0a, 0x68, 0x40, 0x24, 0xf5, 0xe9, 0x73, 0x3b, 0x68, 0x74, 0xff, 0xad, 0x27,
	0x2e, 0x20, 0x70, 0x35, 0xa8, 0x69, 0x31, 0x5a, 0x01, 0xe8, 0x0b, 0xb8, 0xa5, 0xef, 0x70, 0xc6,
	0x13, 0x53, 0x11, 0xd0, 0x48, 0xd9, 0xcb, 0x44, 0x63, 0x72, 0x3a, 0x4d, 0xef, 0xa6, 0x91, 0xda,
	0xaf, 0x79, 0x28, 0x65, 0xa6, 0x00, 0x6a, 0x40, 0x61, 0xcc, 0x87, 0x53, 0xcf, 0xf3, 0xde, 0x6d,
	0x76, 0xe8, 0x6f, 0x8d, 0xc2, 0x06, 0x6b, 0x2e, 0x2d, 0x64, 0xda, 0xe1, 0x02, 0x2a, 0x14, 0x3b,
	0x66, 0x01, 0x51, 0x53, 0xe7, 0x5d, 0x4b, 0x23, 0xbb, 0xf3, 0x80, 0x6e, 0x7c, 0x2c, 0xd8, 0x84,
	0x28, 0xea, 0x6b, 0xd7, 0x76, 0x52, 0x4f, 0xb2, 0x4b, 0xdf, 0xd0, 0x33, 0xfd, 0x82, 0x02, 0x92,
	0xe5, 0x4a, 0xd5, 0xb1, 0x8c, 0xcb, 0x01, 0xc9, 0x10, 0x49, 0x6d, 0x5e, 0x32, 0x19, 0xe8, 0x13,
	0xfa, 0x24, 0x54, 0xbe, 0x1e, 0x59, 0xe9, 0x1f, 0x98, 0x65, 0xbc, 0x6a, 0x03, 0x3b, 0xa1, 0x3a,
	0xd4, 0xcb, 0x7a, 0x46, 0xc8, 0x88, 0x55, 0x8a, 0xe9, 0x8c, 0x90, 0x11, 0xab, 0x3d, 0x81, 0xeb,
	0xf6, 0x1c, 0xa8, 0x04, 0xd7, 0xf7, 0xf6, 0x7b, 0x3b, 0x8d, 0x76, 0xd3, 0xbd, 0xa6, 0x9d, 0xab,
	0xb7, 0x7f, 0xd0, 0x6d, 0x37, 0x53, 0x17, 0x3b, 0x38, 0xea, 0x1f, 0xed, 0xb4, 0xdd, 0x3c, 0x72,
	0xe1, 0xe6, 0x7e, 0xaf, 0xbf, 0xdf, 0xf1, 0xed, 0x8a, 0xd3, 0xf0, 0x7e, 0x79, 0xb5, 0x9e, 0xfb,
	0xed, 0xd5, 0x7a, 0xee, 0xaf, 0x57, 0xeb, 0xb9, 0x67, 0x1b, 0xe9, 0xdd, 0x31, 0x5e, 0x27, 0x31,
	0xab, 0x5f, 0xf2, 0xb7, 0x7c, 0x50, 0x34, 0x3d, 0x7d, 0xf0, 0x77, 0x00, 0x00, 0x00, 0xff, 0xff,
	0x5d, 0xe9, 0xfc, 0x06, 0x1b, 0x0c, 0x00, 0x00,
}
