// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: envoy/service/discovery/v2/hds.proto

package v2

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import envoy_api_v2_core "github.com/envoyproxy/go-control-plane/envoy/api/v2/core"
import envoy_api_v2_core1 "github.com/envoyproxy/go-control-plane/envoy/api/v2/core"
import envoy_api_v2_endpoint "github.com/envoyproxy/go-control-plane/envoy/api/v2/endpoint"
import _ "github.com/gogo/googleapis/google/api"
import google_protobuf3 "github.com/gogo/protobuf/types"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Different Envoy instances may have different capabilities (e.g. Redis)
// and/or have ports enabled for different protocols.
type Capability_Protocol int32

const (
	Capability_HTTP  Capability_Protocol = 0
	Capability_TCP   Capability_Protocol = 1
	Capability_REDIS Capability_Protocol = 2
)

var Capability_Protocol_name = map[int32]string{
	0: "HTTP",
	1: "TCP",
	2: "REDIS",
}
var Capability_Protocol_value = map[string]int32{
	"HTTP":  0,
	"TCP":   1,
	"REDIS": 2,
}

func (x Capability_Protocol) String() string {
	return proto.EnumName(Capability_Protocol_name, int32(x))
}
func (Capability_Protocol) EnumDescriptor() ([]byte, []int) { return fileDescriptorHds, []int{0, 0} }

// Defines supported protocols etc, so the management server can assign proper
// endpoints to healthcheck.
type Capability struct {
	HealthCheckProtocol []Capability_Protocol `protobuf:"varint,1,rep,packed,name=health_check_protocol,json=healthCheckProtocol,enum=envoy.service.discovery.v2.Capability_Protocol" json:"health_check_protocol,omitempty"`
}

func (m *Capability) Reset()                    { *m = Capability{} }
func (m *Capability) String() string            { return proto.CompactTextString(m) }
func (*Capability) ProtoMessage()               {}
func (*Capability) Descriptor() ([]byte, []int) { return fileDescriptorHds, []int{0} }

func (m *Capability) GetHealthCheckProtocol() []Capability_Protocol {
	if m != nil {
		return m.HealthCheckProtocol
	}
	return nil
}

type HealthCheckRequest struct {
	Node       *envoy_api_v2_core.Node `protobuf:"bytes,1,opt,name=node" json:"node,omitempty"`
	Capability *Capability             `protobuf:"bytes,2,opt,name=capability" json:"capability,omitempty"`
}

func (m *HealthCheckRequest) Reset()                    { *m = HealthCheckRequest{} }
func (m *HealthCheckRequest) String() string            { return proto.CompactTextString(m) }
func (*HealthCheckRequest) ProtoMessage()               {}
func (*HealthCheckRequest) Descriptor() ([]byte, []int) { return fileDescriptorHds, []int{1} }

func (m *HealthCheckRequest) GetNode() *envoy_api_v2_core.Node {
	if m != nil {
		return m.Node
	}
	return nil
}

func (m *HealthCheckRequest) GetCapability() *Capability {
	if m != nil {
		return m.Capability
	}
	return nil
}

type EndpointHealth struct {
	Endpoint     *envoy_api_v2_endpoint.Endpoint `protobuf:"bytes,1,opt,name=endpoint" json:"endpoint,omitempty"`
	HealthStatus envoy_api_v2_core1.HealthStatus `protobuf:"varint,2,opt,name=health_status,json=healthStatus,proto3,enum=envoy.api.v2.core.HealthStatus" json:"health_status,omitempty"`
}

func (m *EndpointHealth) Reset()                    { *m = EndpointHealth{} }
func (m *EndpointHealth) String() string            { return proto.CompactTextString(m) }
func (*EndpointHealth) ProtoMessage()               {}
func (*EndpointHealth) Descriptor() ([]byte, []int) { return fileDescriptorHds, []int{2} }

func (m *EndpointHealth) GetEndpoint() *envoy_api_v2_endpoint.Endpoint {
	if m != nil {
		return m.Endpoint
	}
	return nil
}

func (m *EndpointHealth) GetHealthStatus() envoy_api_v2_core1.HealthStatus {
	if m != nil {
		return m.HealthStatus
	}
	return envoy_api_v2_core1.HealthStatus_UNKNOWN
}

type EndpointHealthResponse struct {
	EndpointsHealth []*EndpointHealth `protobuf:"bytes,1,rep,name=endpoints_health,json=endpointsHealth" json:"endpoints_health,omitempty"`
}

func (m *EndpointHealthResponse) Reset()                    { *m = EndpointHealthResponse{} }
func (m *EndpointHealthResponse) String() string            { return proto.CompactTextString(m) }
func (*EndpointHealthResponse) ProtoMessage()               {}
func (*EndpointHealthResponse) Descriptor() ([]byte, []int) { return fileDescriptorHds, []int{3} }

func (m *EndpointHealthResponse) GetEndpointsHealth() []*EndpointHealth {
	if m != nil {
		return m.EndpointsHealth
	}
	return nil
}

type HealthCheckRequestOrEndpointHealthResponse struct {
	// Types that are valid to be assigned to RequestType:
	//	*HealthCheckRequestOrEndpointHealthResponse_HealthCheckRequest
	//	*HealthCheckRequestOrEndpointHealthResponse_EndpointHealthResponse
	RequestType isHealthCheckRequestOrEndpointHealthResponse_RequestType `protobuf_oneof:"request_type"`
}

func (m *HealthCheckRequestOrEndpointHealthResponse) Reset() {
	*m = HealthCheckRequestOrEndpointHealthResponse{}
}
func (m *HealthCheckRequestOrEndpointHealthResponse) String() string {
	return proto.CompactTextString(m)
}
func (*HealthCheckRequestOrEndpointHealthResponse) ProtoMessage() {}
func (*HealthCheckRequestOrEndpointHealthResponse) Descriptor() ([]byte, []int) {
	return fileDescriptorHds, []int{4}
}

type isHealthCheckRequestOrEndpointHealthResponse_RequestType interface {
	isHealthCheckRequestOrEndpointHealthResponse_RequestType()
	MarshalTo([]byte) (int, error)
	Size() int
}

type HealthCheckRequestOrEndpointHealthResponse_HealthCheckRequest struct {
	HealthCheckRequest *HealthCheckRequest `protobuf:"bytes,1,opt,name=health_check_request,json=healthCheckRequest,oneof"`
}
type HealthCheckRequestOrEndpointHealthResponse_EndpointHealthResponse struct {
	EndpointHealthResponse *EndpointHealthResponse `protobuf:"bytes,2,opt,name=endpoint_health_response,json=endpointHealthResponse,oneof"`
}

func (*HealthCheckRequestOrEndpointHealthResponse_HealthCheckRequest) isHealthCheckRequestOrEndpointHealthResponse_RequestType() {
}
func (*HealthCheckRequestOrEndpointHealthResponse_EndpointHealthResponse) isHealthCheckRequestOrEndpointHealthResponse_RequestType() {
}

func (m *HealthCheckRequestOrEndpointHealthResponse) GetRequestType() isHealthCheckRequestOrEndpointHealthResponse_RequestType {
	if m != nil {
		return m.RequestType
	}
	return nil
}

func (m *HealthCheckRequestOrEndpointHealthResponse) GetHealthCheckRequest() *HealthCheckRequest {
	if x, ok := m.GetRequestType().(*HealthCheckRequestOrEndpointHealthResponse_HealthCheckRequest); ok {
		return x.HealthCheckRequest
	}
	return nil
}

func (m *HealthCheckRequestOrEndpointHealthResponse) GetEndpointHealthResponse() *EndpointHealthResponse {
	if x, ok := m.GetRequestType().(*HealthCheckRequestOrEndpointHealthResponse_EndpointHealthResponse); ok {
		return x.EndpointHealthResponse
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*HealthCheckRequestOrEndpointHealthResponse) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _HealthCheckRequestOrEndpointHealthResponse_OneofMarshaler, _HealthCheckRequestOrEndpointHealthResponse_OneofUnmarshaler, _HealthCheckRequestOrEndpointHealthResponse_OneofSizer, []interface{}{
		(*HealthCheckRequestOrEndpointHealthResponse_HealthCheckRequest)(nil),
		(*HealthCheckRequestOrEndpointHealthResponse_EndpointHealthResponse)(nil),
	}
}

func _HealthCheckRequestOrEndpointHealthResponse_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*HealthCheckRequestOrEndpointHealthResponse)
	// request_type
	switch x := m.RequestType.(type) {
	case *HealthCheckRequestOrEndpointHealthResponse_HealthCheckRequest:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HealthCheckRequest); err != nil {
			return err
		}
	case *HealthCheckRequestOrEndpointHealthResponse_EndpointHealthResponse:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.EndpointHealthResponse); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("HealthCheckRequestOrEndpointHealthResponse.RequestType has unexpected type %T", x)
	}
	return nil
}

func _HealthCheckRequestOrEndpointHealthResponse_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*HealthCheckRequestOrEndpointHealthResponse)
	switch tag {
	case 1: // request_type.health_check_request
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(HealthCheckRequest)
		err := b.DecodeMessage(msg)
		m.RequestType = &HealthCheckRequestOrEndpointHealthResponse_HealthCheckRequest{msg}
		return true, err
	case 2: // request_type.endpoint_health_response
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(EndpointHealthResponse)
		err := b.DecodeMessage(msg)
		m.RequestType = &HealthCheckRequestOrEndpointHealthResponse_EndpointHealthResponse{msg}
		return true, err
	default:
		return false, nil
	}
}

func _HealthCheckRequestOrEndpointHealthResponse_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*HealthCheckRequestOrEndpointHealthResponse)
	// request_type
	switch x := m.RequestType.(type) {
	case *HealthCheckRequestOrEndpointHealthResponse_HealthCheckRequest:
		s := proto.Size(x.HealthCheckRequest)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *HealthCheckRequestOrEndpointHealthResponse_EndpointHealthResponse:
		s := proto.Size(x.EndpointHealthResponse)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type LocalityEndpoints struct {
	Locality  *envoy_api_v2_core.Locality       `protobuf:"bytes,1,opt,name=locality" json:"locality,omitempty"`
	Endpoints []*envoy_api_v2_endpoint.Endpoint `protobuf:"bytes,2,rep,name=endpoints" json:"endpoints,omitempty"`
}

func (m *LocalityEndpoints) Reset()                    { *m = LocalityEndpoints{} }
func (m *LocalityEndpoints) String() string            { return proto.CompactTextString(m) }
func (*LocalityEndpoints) ProtoMessage()               {}
func (*LocalityEndpoints) Descriptor() ([]byte, []int) { return fileDescriptorHds, []int{5} }

func (m *LocalityEndpoints) GetLocality() *envoy_api_v2_core.Locality {
	if m != nil {
		return m.Locality
	}
	return nil
}

func (m *LocalityEndpoints) GetEndpoints() []*envoy_api_v2_endpoint.Endpoint {
	if m != nil {
		return m.Endpoints
	}
	return nil
}

// The cluster name and locality is provided to Envoy for the endpoints that it
// health checks to support statistics reporting, logging and debugging by the
// Envoy instance (outside of HDS). For maximum usefulness, it should match the
// same cluster structure as that provided by EDS.
type ClusterHealthCheck struct {
	ClusterName  string                            `protobuf:"bytes,1,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
	HealthChecks []*envoy_api_v2_core1.HealthCheck `protobuf:"bytes,2,rep,name=health_checks,json=healthChecks" json:"health_checks,omitempty"`
	Endpoints    []*LocalityEndpoints              `protobuf:"bytes,3,rep,name=endpoints" json:"endpoints,omitempty"`
}

func (m *ClusterHealthCheck) Reset()                    { *m = ClusterHealthCheck{} }
func (m *ClusterHealthCheck) String() string            { return proto.CompactTextString(m) }
func (*ClusterHealthCheck) ProtoMessage()               {}
func (*ClusterHealthCheck) Descriptor() ([]byte, []int) { return fileDescriptorHds, []int{6} }

func (m *ClusterHealthCheck) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *ClusterHealthCheck) GetHealthChecks() []*envoy_api_v2_core1.HealthCheck {
	if m != nil {
		return m.HealthChecks
	}
	return nil
}

func (m *ClusterHealthCheck) GetEndpoints() []*LocalityEndpoints {
	if m != nil {
		return m.Endpoints
	}
	return nil
}

type HealthCheckSpecifier struct {
	HealthCheck []*ClusterHealthCheck `protobuf:"bytes,1,rep,name=health_check,json=healthCheck" json:"health_check,omitempty"`
	// The default is 1 second.
	Interval *google_protobuf3.Duration `protobuf:"bytes,2,opt,name=interval" json:"interval,omitempty"`
}

func (m *HealthCheckSpecifier) Reset()                    { *m = HealthCheckSpecifier{} }
func (m *HealthCheckSpecifier) String() string            { return proto.CompactTextString(m) }
func (*HealthCheckSpecifier) ProtoMessage()               {}
func (*HealthCheckSpecifier) Descriptor() ([]byte, []int) { return fileDescriptorHds, []int{7} }

func (m *HealthCheckSpecifier) GetHealthCheck() []*ClusterHealthCheck {
	if m != nil {
		return m.HealthCheck
	}
	return nil
}

func (m *HealthCheckSpecifier) GetInterval() *google_protobuf3.Duration {
	if m != nil {
		return m.Interval
	}
	return nil
}

func init() {
	proto.RegisterType((*Capability)(nil), "envoy.service.discovery.v2.Capability")
	proto.RegisterType((*HealthCheckRequest)(nil), "envoy.service.discovery.v2.HealthCheckRequest")
	proto.RegisterType((*EndpointHealth)(nil), "envoy.service.discovery.v2.EndpointHealth")
	proto.RegisterType((*EndpointHealthResponse)(nil), "envoy.service.discovery.v2.EndpointHealthResponse")
	proto.RegisterType((*HealthCheckRequestOrEndpointHealthResponse)(nil), "envoy.service.discovery.v2.HealthCheckRequestOrEndpointHealthResponse")
	proto.RegisterType((*LocalityEndpoints)(nil), "envoy.service.discovery.v2.LocalityEndpoints")
	proto.RegisterType((*ClusterHealthCheck)(nil), "envoy.service.discovery.v2.ClusterHealthCheck")
	proto.RegisterType((*HealthCheckSpecifier)(nil), "envoy.service.discovery.v2.HealthCheckSpecifier")
	proto.RegisterEnum("envoy.service.discovery.v2.Capability_Protocol", Capability_Protocol_name, Capability_Protocol_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for HealthDiscoveryService service

type HealthDiscoveryServiceClient interface {
	// 1. Envoy starts up and if its can_healthcheck option in the static
	//    bootstrap config is enabled, sends HealthCheckRequest to the management
	//    server. It supplies its capabilities (which protocol it can health check
	//    with, what zone it resides in, etc.).
	// 2. In response to (1), the management server designates this Envoy as a
	//    healthchecker to health check a subset of all upstream hosts for a given
	//    cluster (for example upstream Host 1 and Host 2). It streams
	//    HealthCheckSpecifier messages with cluster related configuration for all
	//    clusters this Envoy is designated to health check. Subsequent
	//    HealthCheckSpecifier message will be sent on changes to:
	//    a. Endpoints to health checks
	//    b. Per cluster configuration change
	// 3. Envoy creates a health probe based on the HealthCheck config and sends
	//    it to endpoint(ip:port) of Host 1 and 2. Based on the HealthCheck
	//    configuration Envoy waits upon the arrival of the probe response and
	//    looks at the content of the response to decide whether the endpoint is
	//    healthy or not. If a response hasn’t been received within the timeout
	//    interval, the endpoint health status is considered TIMEOUT.
	// 4. Envoy reports results back in an EndpointHealthResponse message.
	//    Envoy streams responses as often as the interval configured by the
	//    management server in HealthCheckSpecifier.
	// 5. The management Server collects health statuses for all endpoints in the
	//    cluster (for all clusters) and uses this information to construct
	//    EndpointDiscoveryResponse messages.
	// 6. Once Envoy has a list of upstream endpoints to send traffic to, it load
	//    balances traffic to them without additional health checking. It may
	//    use inline healthcheck (i.e. consider endpoint UNHEALTHY if connection
	//    failed to a particular endpoint to account for health status propagation
	//    delay between HDS and EDS).
	// By default, can_healthcheck is true. If can_healthcheck is false, Cluster
	// configuration may not contain HealthCheck message.
	// TODO(htuch): How is can_healthcheck communicated to CDS to ensure the above
	// invariant?
	// TODO(htuch): Add @amb67's diagram.
	StreamHealthCheck(ctx context.Context, opts ...grpc.CallOption) (HealthDiscoveryService_StreamHealthCheckClient, error)
	// TODO(htuch): Unlike the gRPC version, there is no stream-based binding of
	// request/response. Should we add an identifier to the HealthCheckSpecifier
	// to bind with the response?
	FetchHealthCheck(ctx context.Context, in *HealthCheckRequestOrEndpointHealthResponse, opts ...grpc.CallOption) (*HealthCheckSpecifier, error)
}

type healthDiscoveryServiceClient struct {
	cc *grpc.ClientConn
}

func NewHealthDiscoveryServiceClient(cc *grpc.ClientConn) HealthDiscoveryServiceClient {
	return &healthDiscoveryServiceClient{cc}
}

func (c *healthDiscoveryServiceClient) StreamHealthCheck(ctx context.Context, opts ...grpc.CallOption) (HealthDiscoveryService_StreamHealthCheckClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_HealthDiscoveryService_serviceDesc.Streams[0], c.cc, "/envoy.service.discovery.v2.HealthDiscoveryService/StreamHealthCheck", opts...)
	if err != nil {
		return nil, err
	}
	x := &healthDiscoveryServiceStreamHealthCheckClient{stream}
	return x, nil
}

type HealthDiscoveryService_StreamHealthCheckClient interface {
	Send(*HealthCheckRequestOrEndpointHealthResponse) error
	Recv() (*HealthCheckSpecifier, error)
	grpc.ClientStream
}

type healthDiscoveryServiceStreamHealthCheckClient struct {
	grpc.ClientStream
}

func (x *healthDiscoveryServiceStreamHealthCheckClient) Send(m *HealthCheckRequestOrEndpointHealthResponse) error {
	return x.ClientStream.SendMsg(m)
}

func (x *healthDiscoveryServiceStreamHealthCheckClient) Recv() (*HealthCheckSpecifier, error) {
	m := new(HealthCheckSpecifier)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *healthDiscoveryServiceClient) FetchHealthCheck(ctx context.Context, in *HealthCheckRequestOrEndpointHealthResponse, opts ...grpc.CallOption) (*HealthCheckSpecifier, error) {
	out := new(HealthCheckSpecifier)
	err := grpc.Invoke(ctx, "/envoy.service.discovery.v2.HealthDiscoveryService/FetchHealthCheck", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for HealthDiscoveryService service

type HealthDiscoveryServiceServer interface {
	// 1. Envoy starts up and if its can_healthcheck option in the static
	//    bootstrap config is enabled, sends HealthCheckRequest to the management
	//    server. It supplies its capabilities (which protocol it can health check
	//    with, what zone it resides in, etc.).
	// 2. In response to (1), the management server designates this Envoy as a
	//    healthchecker to health check a subset of all upstream hosts for a given
	//    cluster (for example upstream Host 1 and Host 2). It streams
	//    HealthCheckSpecifier messages with cluster related configuration for all
	//    clusters this Envoy is designated to health check. Subsequent
	//    HealthCheckSpecifier message will be sent on changes to:
	//    a. Endpoints to health checks
	//    b. Per cluster configuration change
	// 3. Envoy creates a health probe based on the HealthCheck config and sends
	//    it to endpoint(ip:port) of Host 1 and 2. Based on the HealthCheck
	//    configuration Envoy waits upon the arrival of the probe response and
	//    looks at the content of the response to decide whether the endpoint is
	//    healthy or not. If a response hasn’t been received within the timeout
	//    interval, the endpoint health status is considered TIMEOUT.
	// 4. Envoy reports results back in an EndpointHealthResponse message.
	//    Envoy streams responses as often as the interval configured by the
	//    management server in HealthCheckSpecifier.
	// 5. The management Server collects health statuses for all endpoints in the
	//    cluster (for all clusters) and uses this information to construct
	//    EndpointDiscoveryResponse messages.
	// 6. Once Envoy has a list of upstream endpoints to send traffic to, it load
	//    balances traffic to them without additional health checking. It may
	//    use inline healthcheck (i.e. consider endpoint UNHEALTHY if connection
	//    failed to a particular endpoint to account for health status propagation
	//    delay between HDS and EDS).
	// By default, can_healthcheck is true. If can_healthcheck is false, Cluster
	// configuration may not contain HealthCheck message.
	// TODO(htuch): How is can_healthcheck communicated to CDS to ensure the above
	// invariant?
	// TODO(htuch): Add @amb67's diagram.
	StreamHealthCheck(HealthDiscoveryService_StreamHealthCheckServer) error
	// TODO(htuch): Unlike the gRPC version, there is no stream-based binding of
	// request/response. Should we add an identifier to the HealthCheckSpecifier
	// to bind with the response?
	FetchHealthCheck(context.Context, *HealthCheckRequestOrEndpointHealthResponse) (*HealthCheckSpecifier, error)
}

func RegisterHealthDiscoveryServiceServer(s *grpc.Server, srv HealthDiscoveryServiceServer) {
	s.RegisterService(&_HealthDiscoveryService_serviceDesc, srv)
}

func _HealthDiscoveryService_StreamHealthCheck_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(HealthDiscoveryServiceServer).StreamHealthCheck(&healthDiscoveryServiceStreamHealthCheckServer{stream})
}

type HealthDiscoveryService_StreamHealthCheckServer interface {
	Send(*HealthCheckSpecifier) error
	Recv() (*HealthCheckRequestOrEndpointHealthResponse, error)
	grpc.ServerStream
}

type healthDiscoveryServiceStreamHealthCheckServer struct {
	grpc.ServerStream
}

func (x *healthDiscoveryServiceStreamHealthCheckServer) Send(m *HealthCheckSpecifier) error {
	return x.ServerStream.SendMsg(m)
}

func (x *healthDiscoveryServiceStreamHealthCheckServer) Recv() (*HealthCheckRequestOrEndpointHealthResponse, error) {
	m := new(HealthCheckRequestOrEndpointHealthResponse)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _HealthDiscoveryService_FetchHealthCheck_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HealthCheckRequestOrEndpointHealthResponse)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HealthDiscoveryServiceServer).FetchHealthCheck(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/envoy.service.discovery.v2.HealthDiscoveryService/FetchHealthCheck",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HealthDiscoveryServiceServer).FetchHealthCheck(ctx, req.(*HealthCheckRequestOrEndpointHealthResponse))
	}
	return interceptor(ctx, in, info, handler)
}

var _HealthDiscoveryService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "envoy.service.discovery.v2.HealthDiscoveryService",
	HandlerType: (*HealthDiscoveryServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "FetchHealthCheck",
			Handler:    _HealthDiscoveryService_FetchHealthCheck_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamHealthCheck",
			Handler:       _HealthDiscoveryService_StreamHealthCheck_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "envoy/service/discovery/v2/hds.proto",
}

func (m *Capability) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Capability) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.HealthCheckProtocol) > 0 {
		dAtA2 := make([]byte, len(m.HealthCheckProtocol)*10)
		var j1 int
		for _, num := range m.HealthCheckProtocol {
			for num >= 1<<7 {
				dAtA2[j1] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j1++
			}
			dAtA2[j1] = uint8(num)
			j1++
		}
		dAtA[i] = 0xa
		i++
		i = encodeVarintHds(dAtA, i, uint64(j1))
		i += copy(dAtA[i:], dAtA2[:j1])
	}
	return i, nil
}

func (m *HealthCheckRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HealthCheckRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Node != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintHds(dAtA, i, uint64(m.Node.Size()))
		n3, err := m.Node.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.Capability != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintHds(dAtA, i, uint64(m.Capability.Size()))
		n4, err := m.Capability.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	return i, nil
}

func (m *EndpointHealth) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EndpointHealth) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Endpoint != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintHds(dAtA, i, uint64(m.Endpoint.Size()))
		n5, err := m.Endpoint.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.HealthStatus != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintHds(dAtA, i, uint64(m.HealthStatus))
	}
	return i, nil
}

func (m *EndpointHealthResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EndpointHealthResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.EndpointsHealth) > 0 {
		for _, msg := range m.EndpointsHealth {
			dAtA[i] = 0xa
			i++
			i = encodeVarintHds(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *HealthCheckRequestOrEndpointHealthResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HealthCheckRequestOrEndpointHealthResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RequestType != nil {
		nn6, err := m.RequestType.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn6
	}
	return i, nil
}

func (m *HealthCheckRequestOrEndpointHealthResponse_HealthCheckRequest) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.HealthCheckRequest != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintHds(dAtA, i, uint64(m.HealthCheckRequest.Size()))
		n7, err := m.HealthCheckRequest.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	return i, nil
}
func (m *HealthCheckRequestOrEndpointHealthResponse_EndpointHealthResponse) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.EndpointHealthResponse != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintHds(dAtA, i, uint64(m.EndpointHealthResponse.Size()))
		n8, err := m.EndpointHealthResponse.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	return i, nil
}
func (m *LocalityEndpoints) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LocalityEndpoints) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Locality != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintHds(dAtA, i, uint64(m.Locality.Size()))
		n9, err := m.Locality.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if len(m.Endpoints) > 0 {
		for _, msg := range m.Endpoints {
			dAtA[i] = 0x12
			i++
			i = encodeVarintHds(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *ClusterHealthCheck) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClusterHealthCheck) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ClusterName) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintHds(dAtA, i, uint64(len(m.ClusterName)))
		i += copy(dAtA[i:], m.ClusterName)
	}
	if len(m.HealthChecks) > 0 {
		for _, msg := range m.HealthChecks {
			dAtA[i] = 0x12
			i++
			i = encodeVarintHds(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Endpoints) > 0 {
		for _, msg := range m.Endpoints {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintHds(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *HealthCheckSpecifier) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HealthCheckSpecifier) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.HealthCheck) > 0 {
		for _, msg := range m.HealthCheck {
			dAtA[i] = 0xa
			i++
			i = encodeVarintHds(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Interval != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintHds(dAtA, i, uint64(m.Interval.Size()))
		n10, err := m.Interval.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	return i, nil
}

func encodeVarintHds(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Capability) Size() (n int) {
	var l int
	_ = l
	if len(m.HealthCheckProtocol) > 0 {
		l = 0
		for _, e := range m.HealthCheckProtocol {
			l += sovHds(uint64(e))
		}
		n += 1 + sovHds(uint64(l)) + l
	}
	return n
}

func (m *HealthCheckRequest) Size() (n int) {
	var l int
	_ = l
	if m.Node != nil {
		l = m.Node.Size()
		n += 1 + l + sovHds(uint64(l))
	}
	if m.Capability != nil {
		l = m.Capability.Size()
		n += 1 + l + sovHds(uint64(l))
	}
	return n
}

func (m *EndpointHealth) Size() (n int) {
	var l int
	_ = l
	if m.Endpoint != nil {
		l = m.Endpoint.Size()
		n += 1 + l + sovHds(uint64(l))
	}
	if m.HealthStatus != 0 {
		n += 1 + sovHds(uint64(m.HealthStatus))
	}
	return n
}

func (m *EndpointHealthResponse) Size() (n int) {
	var l int
	_ = l
	if len(m.EndpointsHealth) > 0 {
		for _, e := range m.EndpointsHealth {
			l = e.Size()
			n += 1 + l + sovHds(uint64(l))
		}
	}
	return n
}

func (m *HealthCheckRequestOrEndpointHealthResponse) Size() (n int) {
	var l int
	_ = l
	if m.RequestType != nil {
		n += m.RequestType.Size()
	}
	return n
}

func (m *HealthCheckRequestOrEndpointHealthResponse_HealthCheckRequest) Size() (n int) {
	var l int
	_ = l
	if m.HealthCheckRequest != nil {
		l = m.HealthCheckRequest.Size()
		n += 1 + l + sovHds(uint64(l))
	}
	return n
}
func (m *HealthCheckRequestOrEndpointHealthResponse_EndpointHealthResponse) Size() (n int) {
	var l int
	_ = l
	if m.EndpointHealthResponse != nil {
		l = m.EndpointHealthResponse.Size()
		n += 1 + l + sovHds(uint64(l))
	}
	return n
}
func (m *LocalityEndpoints) Size() (n int) {
	var l int
	_ = l
	if m.Locality != nil {
		l = m.Locality.Size()
		n += 1 + l + sovHds(uint64(l))
	}
	if len(m.Endpoints) > 0 {
		for _, e := range m.Endpoints {
			l = e.Size()
			n += 1 + l + sovHds(uint64(l))
		}
	}
	return n
}

func (m *ClusterHealthCheck) Size() (n int) {
	var l int
	_ = l
	l = len(m.ClusterName)
	if l > 0 {
		n += 1 + l + sovHds(uint64(l))
	}
	if len(m.HealthChecks) > 0 {
		for _, e := range m.HealthChecks {
			l = e.Size()
			n += 1 + l + sovHds(uint64(l))
		}
	}
	if len(m.Endpoints) > 0 {
		for _, e := range m.Endpoints {
			l = e.Size()
			n += 1 + l + sovHds(uint64(l))
		}
	}
	return n
}

func (m *HealthCheckSpecifier) Size() (n int) {
	var l int
	_ = l
	if len(m.HealthCheck) > 0 {
		for _, e := range m.HealthCheck {
			l = e.Size()
			n += 1 + l + sovHds(uint64(l))
		}
	}
	if m.Interval != nil {
		l = m.Interval.Size()
		n += 1 + l + sovHds(uint64(l))
	}
	return n
}

func sovHds(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozHds(x uint64) (n int) {
	return sovHds(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Capability) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowHds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Capability: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Capability: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 0 {
				var v Capability_Protocol
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowHds
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (Capability_Protocol(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.HealthCheckProtocol = append(m.HealthCheckProtocol, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowHds
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthHds
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v Capability_Protocol
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowHds
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (Capability_Protocol(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.HealthCheckProtocol = append(m.HealthCheckProtocol, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field HealthCheckProtocol", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipHds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthHds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HealthCheckRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowHds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HealthCheckRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HealthCheckRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Node", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Node == nil {
				m.Node = &envoy_api_v2_core.Node{}
			}
			if err := m.Node.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Capability", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Capability == nil {
				m.Capability = &Capability{}
			}
			if err := m.Capability.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipHds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthHds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EndpointHealth) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowHds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EndpointHealth: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EndpointHealth: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Endpoint", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Endpoint == nil {
				m.Endpoint = &envoy_api_v2_endpoint.Endpoint{}
			}
			if err := m.Endpoint.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HealthStatus", wireType)
			}
			m.HealthStatus = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.HealthStatus |= (envoy_api_v2_core1.HealthStatus(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipHds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthHds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EndpointHealthResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowHds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EndpointHealthResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EndpointHealthResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndpointsHealth", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndpointsHealth = append(m.EndpointsHealth, &EndpointHealth{})
			if err := m.EndpointsHealth[len(m.EndpointsHealth)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipHds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthHds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HealthCheckRequestOrEndpointHealthResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowHds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HealthCheckRequestOrEndpointHealthResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HealthCheckRequestOrEndpointHealthResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HealthCheckRequest", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &HealthCheckRequest{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.RequestType = &HealthCheckRequestOrEndpointHealthResponse_HealthCheckRequest{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndpointHealthResponse", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &EndpointHealthResponse{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.RequestType = &HealthCheckRequestOrEndpointHealthResponse_EndpointHealthResponse{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipHds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthHds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LocalityEndpoints) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowHds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LocalityEndpoints: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LocalityEndpoints: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Locality", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Locality == nil {
				m.Locality = &envoy_api_v2_core.Locality{}
			}
			if err := m.Locality.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Endpoints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Endpoints = append(m.Endpoints, &envoy_api_v2_endpoint.Endpoint{})
			if err := m.Endpoints[len(m.Endpoints)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipHds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthHds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClusterHealthCheck) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowHds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClusterHealthCheck: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClusterHealthCheck: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthHds
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HealthChecks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HealthChecks = append(m.HealthChecks, &envoy_api_v2_core1.HealthCheck{})
			if err := m.HealthChecks[len(m.HealthChecks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Endpoints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Endpoints = append(m.Endpoints, &LocalityEndpoints{})
			if err := m.Endpoints[len(m.Endpoints)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipHds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthHds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HealthCheckSpecifier) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowHds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HealthCheckSpecifier: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HealthCheckSpecifier: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HealthCheck", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HealthCheck = append(m.HealthCheck, &ClusterHealthCheck{})
			if err := m.HealthCheck[len(m.HealthCheck)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Interval", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowHds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthHds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Interval == nil {
				m.Interval = &google_protobuf3.Duration{}
			}
			if err := m.Interval.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipHds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthHds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipHds(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowHds
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowHds
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowHds
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthHds
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowHds
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipHds(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthHds = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowHds   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("envoy/service/discovery/v2/hds.proto", fileDescriptorHds) }

var fileDescriptorHds = []byte{
	// 734 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x55, 0xc1, 0x6e, 0xd3, 0x4a,
	0x14, 0xcd, 0xa4, 0x7d, 0xef, 0xa5, 0x37, 0x79, 0x69, 0x3a, 0xaf, 0xaf, 0x84, 0x50, 0xa5, 0xc5,
	0x2a, 0x28, 0x2a, 0xc2, 0xa9, 0x8c, 0x10, 0x52, 0x11, 0x9b, 0x26, 0xad, 0x82, 0x40, 0xa5, 0x4c,
	0xca, 0x3a, 0x9a, 0x38, 0xd3, 0xda, 0xc2, 0xf5, 0x18, 0x7b, 0x12, 0x29, 0x5b, 0x56, 0x20, 0x36,
	0x48, 0x5d, 0xb2, 0xe1, 0x1f, 0xf8, 0x09, 0xd8, 0x21, 0xf1, 0x03, 0xa8, 0xea, 0x87, 0xa0, 0xcc,
	0x8c, 0x5d, 0xb7, 0x69, 0x42, 0xbb, 0x63, 0x17, 0xcf, 0x9c, 0x73, 0xee, 0xb9, 0xf7, 0x5c, 0x3b,
	0xb0, 0xc6, 0xfc, 0x01, 0x1f, 0xd6, 0x23, 0x16, 0x0e, 0x5c, 0x9b, 0xd5, 0x7b, 0x6e, 0x64, 0xf3,
	0x01, 0x0b, 0x87, 0xf5, 0x81, 0x55, 0x77, 0x7a, 0x91, 0x19, 0x84, 0x5c, 0x70, 0x5c, 0x91, 0x28,
	0x53, 0xa3, 0xcc, 0x04, 0x65, 0x0e, 0xac, 0xca, 0xb2, 0x52, 0xa0, 0x81, 0x3b, 0xe2, 0xd8, 0x3c,
	0x64, 0xf5, 0x2e, 0x8d, 0x98, 0x62, 0x56, 0xd6, 0xc6, 0x6f, 0x1d, 0x46, 0x3d, 0xe1, 0x74, 0x6c,
	0x87, 0xd9, 0xaf, 0x2f, 0x45, 0x31, 0xbf, 0x17, 0x70, 0xd7, 0x17, 0xc9, 0x0f, 0x8d, 0x5a, 0x3e,
	0xe4, 0xfc, 0xd0, 0x63, 0x12, 0x46, 0x7d, 0x9f, 0x0b, 0x2a, 0x5c, 0xee, 0x6b, 0x8f, 0x95, 0xaa,
	0xbe, 0x95, 0x4f, 0xdd, 0xfe, 0x41, 0xbd, 0xd7, 0x0f, 0x25, 0x40, 0xdd, 0x1b, 0x9f, 0x10, 0x40,
	0x83, 0x06, 0xb4, 0xeb, 0x7a, 0xae, 0x18, 0x62, 0x1b, 0xfe, 0x4f, 0x1b, 0xe9, 0x48, 0x90, 0xcd,
	0xbd, 0x32, 0x5a, 0x9d, 0xa9, 0x15, 0xad, 0xba, 0x39, 0xb9, 0x65, 0xf3, 0x4c, 0xc6, 0xdc, 0xd3,
	0x34, 0xf2, 0x9f, 0x52, 0x6b, 0x8c, 0xc4, 0xe2, 0x43, 0xa3, 0x06, 0xb9, 0xf8, 0x37, 0xce, 0xc1,
	0x6c, 0x6b, 0x7f, 0x7f, 0xaf, 0x94, 0xc1, 0xff, 0xc0, 0xcc, 0x7e, 0x63, 0xaf, 0x84, 0xf0, 0x1c,
	0xfc, 0x45, 0xb6, 0x9b, 0x4f, 0xdb, 0xa5, 0xac, 0xf1, 0x1e, 0x01, 0x6e, 0x9d, 0x29, 0x10, 0xf6,
	0xa6, 0xcf, 0x22, 0x81, 0xef, 0xc1, 0xac, 0xcf, 0x7b, 0xac, 0x8c, 0x56, 0x51, 0x2d, 0x6f, 0xdd,
	0xd0, 0xa6, 0x68, 0xe0, 0x8e, 0x6c, 0x8c, 0xa6, 0x69, 0xee, 0xf2, 0x1e, 0x23, 0x12, 0x84, 0x77,
	0x00, 0xec, 0xc4, 0x59, 0x39, 0x2b, 0x29, 0x77, 0xaf, 0xd6, 0x07, 0x49, 0x31, 0x8d, 0x63, 0x04,
	0xc5, 0x6d, 0x3d, 0x7a, 0xe5, 0x09, 0x3f, 0x86, 0x5c, 0x1c, 0x86, 0xf6, 0xb2, 0x72, 0xde, 0x4b,
	0x12, 0x55, 0x4c, 0x24, 0x09, 0x01, 0x37, 0xe1, 0x5f, 0x3d, 0xea, 0x48, 0x50, 0xd1, 0x8f, 0xa4,
	0xb5, 0xe2, 0x45, 0x05, 0xd9, 0x8d, 0x2a, 0xd7, 0x96, 0x30, 0x52, 0x70, 0x52, 0x4f, 0x06, 0x87,
	0xa5, 0xf3, 0xa6, 0x08, 0x8b, 0x02, 0xee, 0x47, 0x0c, 0xbf, 0x82, 0x52, 0x5c, 0x2b, 0xea, 0x28,
	0x8e, 0x4c, 0x31, 0x6f, 0xad, 0x4f, 0xeb, 0xfe, 0x82, 0xda, 0x7c, 0xa2, 0xa1, 0x0e, 0x8c, 0x8f,
	0x59, 0x58, 0x1f, 0x8f, 0xe4, 0x45, 0x38, 0xc1, 0x45, 0x17, 0x16, 0xcf, 0x2d, 0x54, 0xa8, 0xf0,
	0x7a, 0x5c, 0xe6, 0x34, 0x27, 0xe3, 0x55, 0x5a, 0x19, 0x82, 0x9d, 0xf1, 0x75, 0xf0, 0xa1, 0x1c,
	0xbb, 0xd4, 0x8d, 0x76, 0x42, 0x5d, 0x5f, 0xe7, 0x6d, 0x5d, 0xa3, 0x63, 0xcd, 0x6c, 0x65, 0xc8,
	0x12, 0xbb, 0xf4, 0x66, 0xab, 0x08, 0x05, 0xdd, 0x46, 0x47, 0x0c, 0x03, 0x66, 0x7c, 0x40, 0xb0,
	0xf0, 0x9c, 0xdb, 0x74, 0xb4, 0x26, 0xb1, 0x58, 0x84, 0x1f, 0x41, 0xce, 0xd3, 0x87, 0xba, 0xdb,
	0x5b, 0x97, 0x44, 0x1b, 0xf3, 0x48, 0x02, 0xc6, 0x4f, 0x60, 0x2e, 0x19, 0x7a, 0x39, 0x2b, 0x13,
	0xfb, 0xed, 0x5a, 0x9d, 0x31, 0x8c, 0x6f, 0x08, 0x70, 0xc3, 0xeb, 0x47, 0x82, 0x85, 0xa9, 0x09,
	0xe2, 0xdb, 0x50, 0xb0, 0xd5, 0x69, 0xc7, 0xa7, 0x47, 0xea, 0xdd, 0x99, 0x23, 0x79, 0x7d, 0xb6,
	0x4b, 0x8f, 0x18, 0x6e, 0x24, 0x1b, 0x29, 0xb3, 0x8a, 0x8b, 0x57, 0x27, 0x6e, 0xa4, 0x4a, 0xa1,
	0x90, 0x8a, 0x24, 0xc2, 0xcf, 0xd2, 0xee, 0x67, 0xa4, 0xc0, 0xfd, 0x69, 0xd3, 0x1f, 0x1b, 0x5c,
	0xba, 0x97, 0xcf, 0x08, 0x16, 0x53, 0xa5, 0xda, 0x01, 0xb3, 0xdd, 0x03, 0x97, 0x85, 0xf8, 0x25,
	0x14, 0xd2, 0x56, 0xf5, 0x62, 0x4f, 0x5d, 0xa7, 0xf1, 0x99, 0x90, 0x7c, 0xca, 0x39, 0x7e, 0x08,
	0x39, 0xd7, 0x17, 0x2c, 0x1c, 0x50, 0x4f, 0x6f, 0xcd, 0x4d, 0x53, 0x7d, 0x3c, 0xcd, 0xf8, 0xe3,
	0x69, 0x36, 0xf5, 0xc7, 0x93, 0x24, 0x50, 0xeb, 0x34, 0x0b, 0x4b, 0x4a, 0xb3, 0x19, 0x57, 0x6b,
	0xab, 0xf2, 0xf8, 0x18, 0xc1, 0x42, 0x5b, 0x84, 0x8c, 0x1e, 0xa5, 0x83, 0xd8, 0xb9, 0xde, 0xce,
	0x4f, 0x7a, 0xb3, 0x2a, 0x1b, 0x57, 0xd4, 0x49, 0x86, 0x66, 0x64, 0x6a, 0x68, 0x03, 0xe1, 0x2f,
	0x08, 0x4a, 0x3b, 0x4c, 0xd8, 0xce, 0x9f, 0x61, 0xea, 0xce, 0xdb, 0x1f, 0xa7, 0xc7, 0xd9, 0x15,
	0xa3, 0x32, 0xfa, 0x8f, 0x4b, 0xe0, 0x9b, 0xe9, 0x74, 0x37, 0xd1, 0xfa, 0xd6, 0xfc, 0xd7, 0x93,
	0x2a, 0xfa, 0x7e, 0x52, 0x45, 0x3f, 0x4f, 0xaa, 0xe8, 0x1d, 0x42, 0xdd, 0xbf, 0x65, 0x28, 0x0f,
	0x7e, 0x05, 0x00, 0x00, 0xff, 0xff, 0x88, 0xb0, 0xb1, 0x2c, 0xab, 0x07, 0x00, 0x00,
}
