// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: envoy/config/metrics/v2/stats.proto

package v2

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import envoy_api_v2_core2 "github.com/envoyproxy/go-control-plane/envoy/api/v2/core"
import google_protobuf "github.com/gogo/protobuf/types"
import google_protobuf1 "github.com/gogo/protobuf/types"
import _ "github.com/lyft/protoc-gen-validate/validate"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Configuration for pluggable stats sinks.
type StatsSink struct {
	// The name of the stats sink to instantiate. The name must match a supported
	// stats sink. The built-in stats sinks are:
	//
	// * :ref:`envoy.statsd <envoy_api_msg_config.metrics.v2.StatsdSink>`
	// * :ref:`envoy.dog_statsd <envoy_api_msg_config.metrics.v2.DogStatsdSink>`
	// * :ref:`envoy.metrics_service <envoy_api_msg_config.metrics.v2.MetricsServiceConfig>`
	//
	// Sinks optionally support tagged/multiple dimensional metrics.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Stats sink specific configuration which depends on the sink being
	// instantiated. See :ref:`StatsdSink <envoy_api_msg_config.metrics.v2.StatsdSink>` for an
	// example.
	Config *google_protobuf.Struct `protobuf:"bytes,2,opt,name=config" json:"config,omitempty"`
}

func (m *StatsSink) Reset()                    { *m = StatsSink{} }
func (m *StatsSink) String() string            { return proto.CompactTextString(m) }
func (*StatsSink) ProtoMessage()               {}
func (*StatsSink) Descriptor() ([]byte, []int) { return fileDescriptorStats, []int{0} }

func (m *StatsSink) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *StatsSink) GetConfig() *google_protobuf.Struct {
	if m != nil {
		return m.Config
	}
	return nil
}

// Statistics configuration such as tagging.
type StatsConfig struct {
	// Each stat name is iteratively processed through these tag specifiers.
	// When a tag is matched, the first capture group is removed from the name so
	// later :ref:`TagSpecifiers <envoy_api_msg_config.metrics.v2.TagSpecifier>` cannot match that
	// same portion of the match.
	StatsTags []*TagSpecifier `protobuf:"bytes,1,rep,name=stats_tags,json=statsTags" json:"stats_tags,omitempty"`
	// Use all default tag regexes specified in Envoy. These can be combined with
	// custom tags specified in :ref:`stats_tags
	// <envoy_api_field_config.metrics.v2.StatsConfig.stats_tags>`. They will be processed before
	// the custom tags.
	//
	// .. note::
	//
	//   If any default tags are specified twice, the config will be considered
	//   invalid.
	//
	// See `well_known_names.h
	// <https://github.com/envoyproxy/envoy/blob/master/source/common/config/well_known_names.h>`_
	// for a list of the default tags in Envoy.
	//
	// If not provided, the value is assumed to be true.
	UseAllDefaultTags *google_protobuf1.BoolValue `protobuf:"bytes,2,opt,name=use_all_default_tags,json=useAllDefaultTags" json:"use_all_default_tags,omitempty"`
}

func (m *StatsConfig) Reset()                    { *m = StatsConfig{} }
func (m *StatsConfig) String() string            { return proto.CompactTextString(m) }
func (*StatsConfig) ProtoMessage()               {}
func (*StatsConfig) Descriptor() ([]byte, []int) { return fileDescriptorStats, []int{1} }

func (m *StatsConfig) GetStatsTags() []*TagSpecifier {
	if m != nil {
		return m.StatsTags
	}
	return nil
}

func (m *StatsConfig) GetUseAllDefaultTags() *google_protobuf1.BoolValue {
	if m != nil {
		return m.UseAllDefaultTags
	}
	return nil
}

// Designates a tag name and value pair. The value may be either a fixed value
// or a regex providing the value via capture groups. The specified tag will be
// unconditionally set if a fixed value, otherwise it will only be set if one
// or more capture groups in the regex match.
type TagSpecifier struct {
	// Attaches an identifier to the tag values to identify the tag being in the
	// sink. Envoy has a set of default names and regexes to extract dynamic
	// portions of existing stats, which can be found in `well_known_names.h
	// <https://github.com/envoyproxy/envoy/blob/master/source/common/config/well_known_names.h>`_
	// in the Envoy repository. If a :ref:`tag_name
	// <envoy_api_field_config.metrics.v2.TagSpecifier.tag_name>` is provided in the config and
	// neither :ref:`regex <envoy_api_field_config.metrics.v2.TagSpecifier.regex>` or
	// :ref:`fixed_value <envoy_api_field_config.metrics.v2.TagSpecifier.fixed_value>` were specified,
	// Envoy will attempt to find that name in its set of defaults and use the accompanying regex.
	//
	// .. note::
	//
	//   It is invalid to specify the same tag name twice in a config.
	TagName string `protobuf:"bytes,1,opt,name=tag_name,json=tagName,proto3" json:"tag_name,omitempty"`
	// Types that are valid to be assigned to TagValue:
	//	*TagSpecifier_Regex
	//	*TagSpecifier_FixedValue
	TagValue isTagSpecifier_TagValue `protobuf_oneof:"tag_value"`
}

func (m *TagSpecifier) Reset()                    { *m = TagSpecifier{} }
func (m *TagSpecifier) String() string            { return proto.CompactTextString(m) }
func (*TagSpecifier) ProtoMessage()               {}
func (*TagSpecifier) Descriptor() ([]byte, []int) { return fileDescriptorStats, []int{2} }

type isTagSpecifier_TagValue interface {
	isTagSpecifier_TagValue()
	MarshalTo([]byte) (int, error)
	Size() int
}

type TagSpecifier_Regex struct {
	Regex string `protobuf:"bytes,2,opt,name=regex,proto3,oneof"`
}
type TagSpecifier_FixedValue struct {
	FixedValue string `protobuf:"bytes,3,opt,name=fixed_value,json=fixedValue,proto3,oneof"`
}

func (*TagSpecifier_Regex) isTagSpecifier_TagValue()      {}
func (*TagSpecifier_FixedValue) isTagSpecifier_TagValue() {}

func (m *TagSpecifier) GetTagValue() isTagSpecifier_TagValue {
	if m != nil {
		return m.TagValue
	}
	return nil
}

func (m *TagSpecifier) GetTagName() string {
	if m != nil {
		return m.TagName
	}
	return ""
}

func (m *TagSpecifier) GetRegex() string {
	if x, ok := m.GetTagValue().(*TagSpecifier_Regex); ok {
		return x.Regex
	}
	return ""
}

func (m *TagSpecifier) GetFixedValue() string {
	if x, ok := m.GetTagValue().(*TagSpecifier_FixedValue); ok {
		return x.FixedValue
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*TagSpecifier) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _TagSpecifier_OneofMarshaler, _TagSpecifier_OneofUnmarshaler, _TagSpecifier_OneofSizer, []interface{}{
		(*TagSpecifier_Regex)(nil),
		(*TagSpecifier_FixedValue)(nil),
	}
}

func _TagSpecifier_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*TagSpecifier)
	// tag_value
	switch x := m.TagValue.(type) {
	case *TagSpecifier_Regex:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Regex)
	case *TagSpecifier_FixedValue:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.FixedValue)
	case nil:
	default:
		return fmt.Errorf("TagSpecifier.TagValue has unexpected type %T", x)
	}
	return nil
}

func _TagSpecifier_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*TagSpecifier)
	switch tag {
	case 2: // tag_value.regex
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.TagValue = &TagSpecifier_Regex{x}
		return true, err
	case 3: // tag_value.fixed_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.TagValue = &TagSpecifier_FixedValue{x}
		return true, err
	default:
		return false, nil
	}
}

func _TagSpecifier_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*TagSpecifier)
	// tag_value
	switch x := m.TagValue.(type) {
	case *TagSpecifier_Regex:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Regex)))
		n += len(x.Regex)
	case *TagSpecifier_FixedValue:
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.FixedValue)))
		n += len(x.FixedValue)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Stats configuration proto schema for built-in *envoy.statsd* sink. This sink does not support
// tagged metrics.
type StatsdSink struct {
	// Types that are valid to be assigned to StatsdSpecifier:
	//	*StatsdSink_Address
	//	*StatsdSink_TcpClusterName
	StatsdSpecifier isStatsdSink_StatsdSpecifier `protobuf_oneof:"statsd_specifier"`
	// [#not-implemented-hide:] Optional custom prefix for StatsdSink. If
	// specified, this will override the default prefix.
	// For example:
	//
	// .. code-block:: json
	//
	//   {
	//     "prefix" : "envoy-prod"
	//   }
	//
	// will change emitted stats to
	//
	// .. code-block:: cpp
	//
	//   envoy-prod.test_counter:1|c
	//   envoy-prod.test_timer:5|ms
	//
	// Note that the default prefix, "envoy", will be used if a prefix is not
	// specified.
	//
	// Stats with default prefix:
	//
	// .. code-block:: cpp
	//
	//   envoy.test_counter:1|c
	//   envoy.test_timer:5|ms
	Prefix string `protobuf:"bytes,3,opt,name=prefix,proto3" json:"prefix,omitempty"`
}

func (m *StatsdSink) Reset()                    { *m = StatsdSink{} }
func (m *StatsdSink) String() string            { return proto.CompactTextString(m) }
func (*StatsdSink) ProtoMessage()               {}
func (*StatsdSink) Descriptor() ([]byte, []int) { return fileDescriptorStats, []int{3} }

type isStatsdSink_StatsdSpecifier interface {
	isStatsdSink_StatsdSpecifier()
	MarshalTo([]byte) (int, error)
	Size() int
}

type StatsdSink_Address struct {
	Address *envoy_api_v2_core2.Address `protobuf:"bytes,1,opt,name=address,oneof"`
}
type StatsdSink_TcpClusterName struct {
	TcpClusterName string `protobuf:"bytes,2,opt,name=tcp_cluster_name,json=tcpClusterName,proto3,oneof"`
}

func (*StatsdSink_Address) isStatsdSink_StatsdSpecifier()        {}
func (*StatsdSink_TcpClusterName) isStatsdSink_StatsdSpecifier() {}

func (m *StatsdSink) GetStatsdSpecifier() isStatsdSink_StatsdSpecifier {
	if m != nil {
		return m.StatsdSpecifier
	}
	return nil
}

func (m *StatsdSink) GetAddress() *envoy_api_v2_core2.Address {
	if x, ok := m.GetStatsdSpecifier().(*StatsdSink_Address); ok {
		return x.Address
	}
	return nil
}

func (m *StatsdSink) GetTcpClusterName() string {
	if x, ok := m.GetStatsdSpecifier().(*StatsdSink_TcpClusterName); ok {
		return x.TcpClusterName
	}
	return ""
}

func (m *StatsdSink) GetPrefix() string {
	if m != nil {
		return m.Prefix
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*StatsdSink) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _StatsdSink_OneofMarshaler, _StatsdSink_OneofUnmarshaler, _StatsdSink_OneofSizer, []interface{}{
		(*StatsdSink_Address)(nil),
		(*StatsdSink_TcpClusterName)(nil),
	}
}

func _StatsdSink_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*StatsdSink)
	// statsd_specifier
	switch x := m.StatsdSpecifier.(type) {
	case *StatsdSink_Address:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Address); err != nil {
			return err
		}
	case *StatsdSink_TcpClusterName:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.TcpClusterName)
	case nil:
	default:
		return fmt.Errorf("StatsdSink.StatsdSpecifier has unexpected type %T", x)
	}
	return nil
}

func _StatsdSink_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*StatsdSink)
	switch tag {
	case 1: // statsd_specifier.address
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(envoy_api_v2_core2.Address)
		err := b.DecodeMessage(msg)
		m.StatsdSpecifier = &StatsdSink_Address{msg}
		return true, err
	case 2: // statsd_specifier.tcp_cluster_name
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.StatsdSpecifier = &StatsdSink_TcpClusterName{x}
		return true, err
	default:
		return false, nil
	}
}

func _StatsdSink_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*StatsdSink)
	// statsd_specifier
	switch x := m.StatsdSpecifier.(type) {
	case *StatsdSink_Address:
		s := proto.Size(x.Address)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StatsdSink_TcpClusterName:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.TcpClusterName)))
		n += len(x.TcpClusterName)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Stats configuration proto schema for built-in *envoy.dog_statsd* sink.
// The sink emits stats with `DogStatsD <https://docs.datadoghq.com/guides/dogstatsd/>`_
// compatible tags. Tags are configurable via :ref:`StatsConfig
// <envoy_api_msg_config.metrics.v2.StatsConfig>`.
// [#comment:next free field: 3]
type DogStatsdSink struct {
	// Types that are valid to be assigned to DogStatsdSpecifier:
	//	*DogStatsdSink_Address
	DogStatsdSpecifier isDogStatsdSink_DogStatsdSpecifier `protobuf_oneof:"dog_statsd_specifier"`
}

func (m *DogStatsdSink) Reset()                    { *m = DogStatsdSink{} }
func (m *DogStatsdSink) String() string            { return proto.CompactTextString(m) }
func (*DogStatsdSink) ProtoMessage()               {}
func (*DogStatsdSink) Descriptor() ([]byte, []int) { return fileDescriptorStats, []int{4} }

type isDogStatsdSink_DogStatsdSpecifier interface {
	isDogStatsdSink_DogStatsdSpecifier()
	MarshalTo([]byte) (int, error)
	Size() int
}

type DogStatsdSink_Address struct {
	Address *envoy_api_v2_core2.Address `protobuf:"bytes,1,opt,name=address,oneof"`
}

func (*DogStatsdSink_Address) isDogStatsdSink_DogStatsdSpecifier() {}

func (m *DogStatsdSink) GetDogStatsdSpecifier() isDogStatsdSink_DogStatsdSpecifier {
	if m != nil {
		return m.DogStatsdSpecifier
	}
	return nil
}

func (m *DogStatsdSink) GetAddress() *envoy_api_v2_core2.Address {
	if x, ok := m.GetDogStatsdSpecifier().(*DogStatsdSink_Address); ok {
		return x.Address
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*DogStatsdSink) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _DogStatsdSink_OneofMarshaler, _DogStatsdSink_OneofUnmarshaler, _DogStatsdSink_OneofSizer, []interface{}{
		(*DogStatsdSink_Address)(nil),
	}
}

func _DogStatsdSink_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*DogStatsdSink)
	// dog_statsd_specifier
	switch x := m.DogStatsdSpecifier.(type) {
	case *DogStatsdSink_Address:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Address); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("DogStatsdSink.DogStatsdSpecifier has unexpected type %T", x)
	}
	return nil
}

func _DogStatsdSink_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*DogStatsdSink)
	switch tag {
	case 1: // dog_statsd_specifier.address
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(envoy_api_v2_core2.Address)
		err := b.DecodeMessage(msg)
		m.DogStatsdSpecifier = &DogStatsdSink_Address{msg}
		return true, err
	default:
		return false, nil
	}
}

func _DogStatsdSink_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*DogStatsdSink)
	// dog_statsd_specifier
	switch x := m.DogStatsdSpecifier.(type) {
	case *DogStatsdSink_Address:
		s := proto.Size(x.Address)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

func init() {
	proto.RegisterType((*StatsSink)(nil), "envoy.config.metrics.v2.StatsSink")
	proto.RegisterType((*StatsConfig)(nil), "envoy.config.metrics.v2.StatsConfig")
	proto.RegisterType((*TagSpecifier)(nil), "envoy.config.metrics.v2.TagSpecifier")
	proto.RegisterType((*StatsdSink)(nil), "envoy.config.metrics.v2.StatsdSink")
	proto.RegisterType((*DogStatsdSink)(nil), "envoy.config.metrics.v2.DogStatsdSink")
}
func (m *StatsSink) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StatsSink) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStats(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.Config != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.Config.Size()))
		n1, err := m.Config.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	return i, nil
}

func (m *StatsConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StatsConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.StatsTags) > 0 {
		for _, msg := range m.StatsTags {
			dAtA[i] = 0xa
			i++
			i = encodeVarintStats(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.UseAllDefaultTags != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.UseAllDefaultTags.Size()))
		n2, err := m.UseAllDefaultTags.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	return i, nil
}

func (m *TagSpecifier) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TagSpecifier) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.TagName) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStats(dAtA, i, uint64(len(m.TagName)))
		i += copy(dAtA[i:], m.TagName)
	}
	if m.TagValue != nil {
		nn3, err := m.TagValue.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn3
	}
	return i, nil
}

func (m *TagSpecifier_Regex) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x12
	i++
	i = encodeVarintStats(dAtA, i, uint64(len(m.Regex)))
	i += copy(dAtA[i:], m.Regex)
	return i, nil
}
func (m *TagSpecifier_FixedValue) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x1a
	i++
	i = encodeVarintStats(dAtA, i, uint64(len(m.FixedValue)))
	i += copy(dAtA[i:], m.FixedValue)
	return i, nil
}
func (m *StatsdSink) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StatsdSink) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.StatsdSpecifier != nil {
		nn4, err := m.StatsdSpecifier.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn4
	}
	if len(m.Prefix) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintStats(dAtA, i, uint64(len(m.Prefix)))
		i += copy(dAtA[i:], m.Prefix)
	}
	return i, nil
}

func (m *StatsdSink_Address) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Address != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.Address.Size()))
		n5, err := m.Address.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	return i, nil
}
func (m *StatsdSink_TcpClusterName) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x12
	i++
	i = encodeVarintStats(dAtA, i, uint64(len(m.TcpClusterName)))
	i += copy(dAtA[i:], m.TcpClusterName)
	return i, nil
}
func (m *DogStatsdSink) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DogStatsdSink) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.DogStatsdSpecifier != nil {
		nn6, err := m.DogStatsdSpecifier.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn6
	}
	return i, nil
}

func (m *DogStatsdSink_Address) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Address != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStats(dAtA, i, uint64(m.Address.Size()))
		n7, err := m.Address.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	return i, nil
}
func encodeVarintStats(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *StatsSink) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovStats(uint64(l))
	}
	if m.Config != nil {
		l = m.Config.Size()
		n += 1 + l + sovStats(uint64(l))
	}
	return n
}

func (m *StatsConfig) Size() (n int) {
	var l int
	_ = l
	if len(m.StatsTags) > 0 {
		for _, e := range m.StatsTags {
			l = e.Size()
			n += 1 + l + sovStats(uint64(l))
		}
	}
	if m.UseAllDefaultTags != nil {
		l = m.UseAllDefaultTags.Size()
		n += 1 + l + sovStats(uint64(l))
	}
	return n
}

func (m *TagSpecifier) Size() (n int) {
	var l int
	_ = l
	l = len(m.TagName)
	if l > 0 {
		n += 1 + l + sovStats(uint64(l))
	}
	if m.TagValue != nil {
		n += m.TagValue.Size()
	}
	return n
}

func (m *TagSpecifier_Regex) Size() (n int) {
	var l int
	_ = l
	l = len(m.Regex)
	n += 1 + l + sovStats(uint64(l))
	return n
}
func (m *TagSpecifier_FixedValue) Size() (n int) {
	var l int
	_ = l
	l = len(m.FixedValue)
	n += 1 + l + sovStats(uint64(l))
	return n
}
func (m *StatsdSink) Size() (n int) {
	var l int
	_ = l
	if m.StatsdSpecifier != nil {
		n += m.StatsdSpecifier.Size()
	}
	l = len(m.Prefix)
	if l > 0 {
		n += 1 + l + sovStats(uint64(l))
	}
	return n
}

func (m *StatsdSink_Address) Size() (n int) {
	var l int
	_ = l
	if m.Address != nil {
		l = m.Address.Size()
		n += 1 + l + sovStats(uint64(l))
	}
	return n
}
func (m *StatsdSink_TcpClusterName) Size() (n int) {
	var l int
	_ = l
	l = len(m.TcpClusterName)
	n += 1 + l + sovStats(uint64(l))
	return n
}
func (m *DogStatsdSink) Size() (n int) {
	var l int
	_ = l
	if m.DogStatsdSpecifier != nil {
		n += m.DogStatsdSpecifier.Size()
	}
	return n
}

func (m *DogStatsdSink_Address) Size() (n int) {
	var l int
	_ = l
	if m.Address != nil {
		l = m.Address.Size()
		n += 1 + l + sovStats(uint64(l))
	}
	return n
}

func sovStats(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozStats(x uint64) (n int) {
	return sovStats(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *StatsSink) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StatsSink: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StatsSink: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Config", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Config == nil {
				m.Config = &google_protobuf.Struct{}
			}
			if err := m.Config.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StatsConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StatsConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StatsConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StatsTags", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StatsTags = append(m.StatsTags, &TagSpecifier{})
			if err := m.StatsTags[len(m.StatsTags)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UseAllDefaultTags", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UseAllDefaultTags == nil {
				m.UseAllDefaultTags = &google_protobuf1.BoolValue{}
			}
			if err := m.UseAllDefaultTags.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TagSpecifier) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TagSpecifier: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TagSpecifier: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TagName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TagName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Regex", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TagValue = &TagSpecifier_Regex{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FixedValue", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TagValue = &TagSpecifier_FixedValue{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StatsdSink) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StatsdSink: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StatsdSink: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &envoy_api_v2_core2.Address{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.StatsdSpecifier = &StatsdSink_Address{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TcpClusterName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StatsdSpecifier = &StatsdSink_TcpClusterName{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Prefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Prefix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DogStatsdSink) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DogStatsdSink: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DogStatsdSink: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStats
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &envoy_api_v2_core2.Address{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.DogStatsdSpecifier = &DogStatsdSink_Address{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipStats(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowStats
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowStats
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowStats
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthStats
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowStats
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipStats(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthStats = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowStats   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("envoy/config/metrics/v2/stats.proto", fileDescriptorStats) }

var fileDescriptorStats = []byte{
	// 485 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x52, 0x41, 0x6f, 0xd3, 0x30,
	0x18, 0x9d, 0xdb, 0xad, 0x5b, 0xbe, 0x00, 0x2a, 0xd1, 0x44, 0xbb, 0x0a, 0x4a, 0x09, 0x42, 0xaa,
	0x38, 0x38, 0x52, 0x90, 0xb8, 0x2f, 0xeb, 0x61, 0x02, 0x09, 0xa1, 0x74, 0xe2, 0xc0, 0x25, 0xf2,
	0x12, 0xc7, 0xb2, 0xf0, 0xea, 0x60, 0x3b, 0xa1, 0xfc, 0x1b, 0x24, 0xfe, 0x04, 0x47, 0x8e, 0x1c,
	0xf9, 0x09, 0xa8, 0x37, 0xfe, 0x05, 0x8a, 0x9d, 0xa0, 0x09, 0xb4, 0xd3, 0x6e, 0xfe, 0xf2, 0xde,
	0xfb, 0xde, 0xf3, 0x73, 0xe0, 0x29, 0xdd, 0x34, 0xf2, 0x73, 0x94, 0xcb, 0x4d, 0xc9, 0x59, 0x74,
	0x45, 0x8d, 0xe2, 0xb9, 0x8e, 0x9a, 0x38, 0xd2, 0x86, 0x18, 0x8d, 0x2b, 0x25, 0x8d, 0x0c, 0x26,
	0x96, 0x84, 0x1d, 0x09, 0x77, 0x24, 0xdc, 0xc4, 0xb3, 0xc7, 0x4e, 0x4d, 0x2a, 0xde, 0x4a, 0x72,
	0xa9, 0x68, 0x44, 0x8a, 0x42, 0x51, 0xdd, 0x29, 0x67, 0x0f, 0x99, 0x94, 0x4c, 0xd0, 0xc8, 0x4e,
	0x97, 0x75, 0x19, 0x69, 0xa3, 0xea, 0xdc, 0x74, 0xe8, 0xfc, 0x5f, 0xf4, 0x93, 0x22, 0x55, 0x45,
	0x55, 0xaf, 0x9e, 0x34, 0x44, 0xf0, 0x82, 0x18, 0x1a, 0xf5, 0x07, 0x07, 0x84, 0x6f, 0xc1, 0x5b,
	0xb7, 0xf9, 0xd6, 0x7c, 0xf3, 0x21, 0x08, 0x60, 0x7f, 0x43, 0xae, 0xe8, 0x14, 0x2d, 0xd0, 0xd2,
	0x4b, 0xed, 0x39, 0x88, 0x60, 0xe4, 0xd2, 0x4e, 0x07, 0x0b, 0xb4, 0xf4, 0xe3, 0x09, 0x76, 0x56,
	0xb8, 0xb7, 0xc2, 0x6b, 0x1b, 0x24, 0xed, 0x68, 0xe1, 0x17, 0x04, 0xbe, 0x5d, 0x79, 0x66, 0xe7,
	0x60, 0x05, 0x60, 0x1b, 0xc8, 0x0c, 0x61, 0x7a, 0x8a, 0x16, 0xc3, 0xa5, 0x1f, 0x3f, 0xc3, 0x37,
	0xf4, 0x80, 0x2f, 0x08, 0x5b, 0x57, 0x34, 0xe7, 0x25, 0xa7, 0x2a, 0xf5, 0xac, 0xf0, 0x82, 0x30,
	0x1d, 0xbc, 0x86, 0xe3, 0x5a, 0xd3, 0x8c, 0x08, 0x91, 0x15, 0xb4, 0x24, 0xb5, 0x30, 0x6e, 0x9f,
	0x0b, 0x35, 0xfb, 0x2f, 0x54, 0x22, 0xa5, 0x78, 0x47, 0x44, 0x4d, 0xd3, 0xfb, 0xb5, 0xa6, 0xa7,
	0x42, 0xac, 0x9c, 0xaa, 0x5d, 0x16, 0x7e, 0x84, 0x3b, 0xd7, 0x7d, 0x82, 0x13, 0x38, 0x32, 0x84,
	0x65, 0xd7, 0xee, 0x7e, 0x68, 0x08, 0x7b, 0xd3, 0x5e, 0xff, 0x01, 0x1c, 0x28, 0xca, 0xe8, 0xd6,
	0x1a, 0x79, 0xe7, 0x7b, 0xa9, 0x1b, 0x83, 0x27, 0xe0, 0x97, 0x7c, 0x4b, 0x8b, 0xac, 0x69, 0x4d,
	0xa6, 0xc3, 0x0e, 0x05, 0xfb, 0xd1, 0x1a, 0x27, 0x3e, 0x78, 0xed, 0x56, 0x4b, 0x08, 0xbf, 0x22,
	0x00, 0xdb, 0x4a, 0x61, 0x9b, 0x7e, 0x09, 0x87, 0xdd, 0xf3, 0x5a, 0xc3, 0xf6, 0x06, 0xae, 0x11,
	0x52, 0xf1, 0xb6, 0x86, 0xf6, 0x07, 0xc0, 0xa7, 0x8e, 0x71, 0xbe, 0x97, 0xf6, 0xe4, 0xe0, 0x39,
	0x8c, 0x4d, 0x5e, 0x65, 0xb9, 0xa8, 0xb5, 0xa1, 0xca, 0x25, 0xee, 0x93, 0xdd, 0x33, 0x79, 0x75,
	0xe6, 0x80, 0x2e, 0xfa, 0xa8, 0x52, 0xb4, 0xe4, 0x5b, 0x97, 0x2e, 0xed, 0xa6, 0xe4, 0x04, 0xc6,
	0xb6, 0xd7, 0x22, 0xd3, 0x7f, 0x1b, 0x38, 0xf8, 0xf6, 0xfb, 0xfb, 0x10, 0x85, 0x02, 0xee, 0xae,
	0x24, 0xbb, 0x7d, 0xce, 0xe4, 0x11, 0x1c, 0x17, 0x92, 0x65, 0x37, 0xf8, 0xbc, 0xda, 0x3f, 0x1a,
	0x8c, 0x87, 0xc9, 0xf8, 0xc7, 0x6e, 0x8e, 0x7e, 0xee, 0xe6, 0xe8, 0xd7, 0x6e, 0x8e, 0xde, 0x0f,
	0x9a, 0xf8, 0x72, 0x64, 0xdf, 0xef, 0xc5, 0x9f, 0x00, 0x00, 0x00, 0xff, 0xff, 0xeb, 0x57, 0x53,
	0x55, 0x4c, 0x03, 0x00, 0x00,
}
