// Code generated by protoc-gen-validate
// source: envoy/config/filter/http/jwt_authn/v2alpha/config.proto
// DO NOT EDIT!!!

package envoy_config_filter_http_jwt_authn_v2alpha

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"strings"
	"time"
	"unicode/utf8"

	"github.com/gogo/protobuf/types"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = types.DynamicAny{}
)

// Validate checks the field values on JwtRule with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *JwtRule) Validate() error {
	if m == nil {
		return nil
	}

	if len(m.GetIssuer()) < 1 {
		return JwtRuleValidationError{
			Field:  "Issuer",
			Reason: "value length must be at least 1 bytes",
		}
	}

	// no validation rules for Forward

	for idx, item := range m.GetFromHeaders() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return JwtRuleValidationError{
					Field:  fmt.Sprintf("FromHeaders[%v]", idx),
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	}

	// no validation rules for ForwardPayloadHeader

	switch m.JwksSourceSpecifier.(type) {

	case *JwtRule_RemoteJwks:

		if v, ok := interface{}(m.GetRemoteJwks()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return JwtRuleValidationError{
					Field:  "RemoteJwks",
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	case *JwtRule_LocalJwks:

		if v, ok := interface{}(m.GetLocalJwks()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return JwtRuleValidationError{
					Field:  "LocalJwks",
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	default:
		return JwtRuleValidationError{
			Field:  "JwksSourceSpecifier",
			Reason: "value is required",
		}

	}

	return nil
}

// JwtRuleValidationError is the validation error returned by JwtRule.Validate
// if the designated constraints aren't met.
type JwtRuleValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e JwtRuleValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sJwtRule.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = JwtRuleValidationError{}

// Validate checks the field values on RemoteJwks with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *RemoteJwks) Validate() error {
	if m == nil {
		return nil
	}

	if v, ok := interface{}(m.GetHttpUri()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RemoteJwksValidationError{
				Field:  "HttpUri",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetCacheDuration()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RemoteJwksValidationError{
				Field:  "CacheDuration",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	return nil
}

// RemoteJwksValidationError is the validation error returned by
// RemoteJwks.Validate if the designated constraints aren't met.
type RemoteJwksValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e RemoteJwksValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRemoteJwks.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = RemoteJwksValidationError{}

// Validate checks the field values on JwtHeader with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *JwtHeader) Validate() error {
	if m == nil {
		return nil
	}

	if len(m.GetName()) < 1 {
		return JwtHeaderValidationError{
			Field:  "Name",
			Reason: "value length must be at least 1 bytes",
		}
	}

	// no validation rules for ValuePrefix

	return nil
}

// JwtHeaderValidationError is the validation error returned by
// JwtHeader.Validate if the designated constraints aren't met.
type JwtHeaderValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e JwtHeaderValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sJwtHeader.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = JwtHeaderValidationError{}

// Validate checks the field values on JwtAuthentication with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *JwtAuthentication) Validate() error {
	if m == nil {
		return nil
	}

	for idx, item := range m.GetRules() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return JwtAuthenticationValidationError{
					Field:  fmt.Sprintf("Rules[%v]", idx),
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	}

	// no validation rules for AllowMissingOrFailed

	for idx, item := range m.GetBypass() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return JwtAuthenticationValidationError{
					Field:  fmt.Sprintf("Bypass[%v]", idx),
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	}

	return nil
}

// JwtAuthenticationValidationError is the validation error returned by
// JwtAuthentication.Validate if the designated constraints aren't met.
type JwtAuthenticationValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e JwtAuthenticationValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sJwtAuthentication.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = JwtAuthenticationValidationError{}
