// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: envoy/config/filter/http/jwt_authn/v2alpha/config.proto

/*
	Package envoy_config_filter_http_jwt_authn_v2alpha is a generated protocol buffer package.

	It is generated from these files:
		envoy/config/filter/http/jwt_authn/v2alpha/config.proto

	It has these top-level messages:
		JwtRule
		RemoteJwks
		JwtHeader
		JwtAuthentication
*/
package envoy_config_filter_http_jwt_authn_v2alpha

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import envoy_api_v2_core "github.com/envoyproxy/go-control-plane/envoy/api/v2/core"
import envoy_api_v2_core1 "github.com/envoyproxy/go-control-plane/envoy/api/v2/core"
import envoy_api_v2_route "github.com/envoyproxy/go-control-plane/envoy/api/v2/route"
import google_protobuf3 "github.com/gogo/protobuf/types"
import _ "github.com/lyft/protoc-gen-validate/validate"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// This message specifies how a JSON Web Token (JWT) can be verified. JWT format is defined
// `here <https://tools.ietf.org/html/rfc7519>`_. Please see `OAuth2.0
//  <https://tools.ietf.org/html/rfc6749>`_ and `OIDC1.0  <http://openid.net/connect>`_ for
// the authentication flow.
//
// Example:
//
// .. code-block:: yaml
//
//     issuer: https://example.com
//     audiences:
//     - bookstore_android.apps.googleusercontent.com
//       bookstore_web.apps.googleusercontent.com
//     remote_jwks:
//     - http_uri:
//       - uri: https://example.com/.well-known/jwks.json
//         cluster: example_jwks_cluster
//       cache_duration:
//       - seconds: 300
//
// [#not-implemented-hide:]
type JwtRule struct {
	// Identifies the principal that issued the JWT. See `here
	//  <https://tools.ietf.org/html/rfc7519#section-4.1.1>`_. Usually a URL or an email address.
	//
	// Example: https://securetoken.google.com
	// Example: 1234567-compute@developer.gserviceaccount.com
	//
	Issuer string `protobuf:"bytes,1,opt,name=issuer,proto3" json:"issuer,omitempty"`
	// The list of JWT `audiences <https://tools.ietf.org/html/rfc7519#section-4.1.3>`_. that are
	// allowed to access. A JWT containing any of these audiences will be accepted. If not specified,
	// will not check audiences in the token.
	//
	// Example:
	//
	// .. code-block:: yaml
	//
	//     audiences:
	//     - bookstore_android.apps.googleusercontent.com
	//       bookstore_web.apps.googleusercontent.com
	//
	Audiences []string `protobuf:"bytes,2,rep,name=audiences" json:"audiences,omitempty"`
	// `JSON Web Key Set <https://tools.ietf.org/html/rfc7517#appendix-A>`_ is needed. to validate
	// signature of the JWT. This field specifies where to fetch JWKS.
	//
	// Types that are valid to be assigned to JwksSourceSpecifier:
	//	*JwtRule_RemoteJwks
	//	*JwtRule_LocalJwks
	JwksSourceSpecifier isJwtRule_JwksSourceSpecifier `protobuf_oneof:"jwks_source_specifier"`
	// If false, the JWT is removed in the request after a success verification. If true, the JWT is
	// not removed in the request. Default value is false.
	Forward bool `protobuf:"varint,5,opt,name=forward,proto3" json:"forward,omitempty"`
	// Specify the HTTP headers to extract JWT token. For examples, following config:
	//
	// .. code-block:: yaml
	//
	//   from_headers:
	//   - name: x-goog-iap-jwt-assertion
	//
	// can be used to extract token from header::
	//
	//   x-goog-iap-jwt-assertion: <JWT>.
	//
	FromHeaders []*JwtHeader `protobuf:"bytes,6,rep,name=from_headers,json=fromHeaders" json:"from_headers,omitempty"`
	// JWT is sent in a query parameter. `jwt_params` represents the query parameter names.
	//
	// For example, if config is:
	//
	// .. code-block:: yaml
	//
	//   from_params:
	//   - jwt_token
	//
	// The JWT format in query parameter is::
	//
	//    /path?jwt_token=<JWT>
	//
	FromParams []string `protobuf:"bytes,7,rep,name=from_params,json=fromParams" json:"from_params,omitempty"`
	// This field specifies the header name to forward a successfully verified JWT payload to the
	// backend. The forwarded data is::
	//
	//    base64_encoded(jwt_payload_in_JSON)
	//
	// If it is not specified, the payload will not be forwarded.
	// Multiple JWTs in a request from different issuers will be supported. Multiple JWTs from the
	// same issuer will not be supported. Each issuer can config this `forward_payload_header`. If
	// multiple JWTs from different issuers want to forward their payloads, their
	// `forward_payload_header` should be different.
	ForwardPayloadHeader string `protobuf:"bytes,8,opt,name=forward_payload_header,json=forwardPayloadHeader,proto3" json:"forward_payload_header,omitempty"`
}

func (m *JwtRule) Reset()                    { *m = JwtRule{} }
func (m *JwtRule) String() string            { return proto.CompactTextString(m) }
func (*JwtRule) ProtoMessage()               {}
func (*JwtRule) Descriptor() ([]byte, []int) { return fileDescriptorConfig, []int{0} }

type isJwtRule_JwksSourceSpecifier interface {
	isJwtRule_JwksSourceSpecifier()
	MarshalTo([]byte) (int, error)
	Size() int
}

type JwtRule_RemoteJwks struct {
	RemoteJwks *RemoteJwks `protobuf:"bytes,3,opt,name=remote_jwks,json=remoteJwks,oneof"`
}
type JwtRule_LocalJwks struct {
	LocalJwks *envoy_api_v2_core.DataSource `protobuf:"bytes,4,opt,name=local_jwks,json=localJwks,oneof"`
}

func (*JwtRule_RemoteJwks) isJwtRule_JwksSourceSpecifier() {}
func (*JwtRule_LocalJwks) isJwtRule_JwksSourceSpecifier()  {}

func (m *JwtRule) GetJwksSourceSpecifier() isJwtRule_JwksSourceSpecifier {
	if m != nil {
		return m.JwksSourceSpecifier
	}
	return nil
}

func (m *JwtRule) GetIssuer() string {
	if m != nil {
		return m.Issuer
	}
	return ""
}

func (m *JwtRule) GetAudiences() []string {
	if m != nil {
		return m.Audiences
	}
	return nil
}

func (m *JwtRule) GetRemoteJwks() *RemoteJwks {
	if x, ok := m.GetJwksSourceSpecifier().(*JwtRule_RemoteJwks); ok {
		return x.RemoteJwks
	}
	return nil
}

func (m *JwtRule) GetLocalJwks() *envoy_api_v2_core.DataSource {
	if x, ok := m.GetJwksSourceSpecifier().(*JwtRule_LocalJwks); ok {
		return x.LocalJwks
	}
	return nil
}

func (m *JwtRule) GetForward() bool {
	if m != nil {
		return m.Forward
	}
	return false
}

func (m *JwtRule) GetFromHeaders() []*JwtHeader {
	if m != nil {
		return m.FromHeaders
	}
	return nil
}

func (m *JwtRule) GetFromParams() []string {
	if m != nil {
		return m.FromParams
	}
	return nil
}

func (m *JwtRule) GetForwardPayloadHeader() string {
	if m != nil {
		return m.ForwardPayloadHeader
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*JwtRule) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _JwtRule_OneofMarshaler, _JwtRule_OneofUnmarshaler, _JwtRule_OneofSizer, []interface{}{
		(*JwtRule_RemoteJwks)(nil),
		(*JwtRule_LocalJwks)(nil),
	}
}

func _JwtRule_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*JwtRule)
	// jwks_source_specifier
	switch x := m.JwksSourceSpecifier.(type) {
	case *JwtRule_RemoteJwks:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RemoteJwks); err != nil {
			return err
		}
	case *JwtRule_LocalJwks:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.LocalJwks); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("JwtRule.JwksSourceSpecifier has unexpected type %T", x)
	}
	return nil
}

func _JwtRule_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*JwtRule)
	switch tag {
	case 3: // jwks_source_specifier.remote_jwks
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RemoteJwks)
		err := b.DecodeMessage(msg)
		m.JwksSourceSpecifier = &JwtRule_RemoteJwks{msg}
		return true, err
	case 4: // jwks_source_specifier.local_jwks
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(envoy_api_v2_core.DataSource)
		err := b.DecodeMessage(msg)
		m.JwksSourceSpecifier = &JwtRule_LocalJwks{msg}
		return true, err
	default:
		return false, nil
	}
}

func _JwtRule_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*JwtRule)
	// jwks_source_specifier
	switch x := m.JwksSourceSpecifier.(type) {
	case *JwtRule_RemoteJwks:
		s := proto.Size(x.RemoteJwks)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *JwtRule_LocalJwks:
		s := proto.Size(x.LocalJwks)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// This message specifies how to fetch JWKS from remote and how to cache it.
type RemoteJwks struct {
	// The HTTP URI to fetch the JWKS. For example:
	//
	// .. code-block:: yaml
	//
	//    http_uri:
	//    - uri: https://www.googleapis.com/oauth2/v1/certs
	//      cluster: jwt.www.googleapis.com|443
	//
	HttpUri *envoy_api_v2_core1.HttpUri `protobuf:"bytes,1,opt,name=http_uri,json=httpUri" json:"http_uri,omitempty"`
	// Duration after which the cached JWKS should be expired. If not specified, default cache
	// duration is 5 minutes.
	CacheDuration *google_protobuf3.Duration `protobuf:"bytes,2,opt,name=cache_duration,json=cacheDuration" json:"cache_duration,omitempty"`
}

func (m *RemoteJwks) Reset()                    { *m = RemoteJwks{} }
func (m *RemoteJwks) String() string            { return proto.CompactTextString(m) }
func (*RemoteJwks) ProtoMessage()               {}
func (*RemoteJwks) Descriptor() ([]byte, []int) { return fileDescriptorConfig, []int{1} }

func (m *RemoteJwks) GetHttpUri() *envoy_api_v2_core1.HttpUri {
	if m != nil {
		return m.HttpUri
	}
	return nil
}

func (m *RemoteJwks) GetCacheDuration() *google_protobuf3.Duration {
	if m != nil {
		return m.CacheDuration
	}
	return nil
}

// This message specifies a header location to extract JWT token.
type JwtHeader struct {
	// The HTTP header name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The value prefix. The value format is "value_prefix<token>"
	// For example, for "Authorization: Bearer <token>", value_prefix="Bearer " with a space at the
	// end.
	ValuePrefix string `protobuf:"bytes,2,opt,name=value_prefix,json=valuePrefix,proto3" json:"value_prefix,omitempty"`
}

func (m *JwtHeader) Reset()                    { *m = JwtHeader{} }
func (m *JwtHeader) String() string            { return proto.CompactTextString(m) }
func (*JwtHeader) ProtoMessage()               {}
func (*JwtHeader) Descriptor() ([]byte, []int) { return fileDescriptorConfig, []int{2} }

func (m *JwtHeader) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *JwtHeader) GetValuePrefix() string {
	if m != nil {
		return m.ValuePrefix
	}
	return ""
}

// This is the Envoy HTTP filter config for JWT authentication.
// [#not-implemented-hide:]
type JwtAuthentication struct {
	// List of JWT rules to valide.
	Rules []*JwtRule `protobuf:"bytes,1,rep,name=rules" json:"rules,omitempty"`
	// If true, the request is allowed if JWT is missing or JWT verification fails.
	// Default is false, a request without JWT or failed JWT verification is not allowed.
	AllowMissingOrFailed bool `protobuf:"varint,2,opt,name=allow_missing_or_failed,json=allowMissingOrFailed,proto3" json:"allow_missing_or_failed,omitempty"`
	// This field lists the patterns allowed to bypass JWT verification. This only applies when
	// `allow_missing_or_failed_jwt` is false. Under this config, if a request doesn't have JWT, it
	// will be rejected. But some requests still needed to be forwarded without JWT, such as OPTIONS
	// for CORS and some health checking paths.
	//
	// Examples: bypass all CORS options requests
	//
	// .. code-block:: yaml
	//
	//   bypass:
	//   - headers:
	//     - name: :method
	//       value: OPTIONS
	//   - headers:
	//     - name: :path
	//       regex_match: /.*
	//
	// Examples: bypass /healthz check
	//
	// .. code-block:: yaml
	//
	//   bypass:
	//   - headers:
	//     - name: :method
	//       value: GET
	//   - headers:
	//     - name: :path
	//       exact_match: /healthz
	//
	Bypass []*envoy_api_v2_route.RouteMatch `protobuf:"bytes,3,rep,name=bypass" json:"bypass,omitempty"`
}

func (m *JwtAuthentication) Reset()                    { *m = JwtAuthentication{} }
func (m *JwtAuthentication) String() string            { return proto.CompactTextString(m) }
func (*JwtAuthentication) ProtoMessage()               {}
func (*JwtAuthentication) Descriptor() ([]byte, []int) { return fileDescriptorConfig, []int{3} }

func (m *JwtAuthentication) GetRules() []*JwtRule {
	if m != nil {
		return m.Rules
	}
	return nil
}

func (m *JwtAuthentication) GetAllowMissingOrFailed() bool {
	if m != nil {
		return m.AllowMissingOrFailed
	}
	return false
}

func (m *JwtAuthentication) GetBypass() []*envoy_api_v2_route.RouteMatch {
	if m != nil {
		return m.Bypass
	}
	return nil
}

func init() {
	proto.RegisterType((*JwtRule)(nil), "envoy.config.filter.http.jwt_authn.v2alpha.JwtRule")
	proto.RegisterType((*RemoteJwks)(nil), "envoy.config.filter.http.jwt_authn.v2alpha.RemoteJwks")
	proto.RegisterType((*JwtHeader)(nil), "envoy.config.filter.http.jwt_authn.v2alpha.JwtHeader")
	proto.RegisterType((*JwtAuthentication)(nil), "envoy.config.filter.http.jwt_authn.v2alpha.JwtAuthentication")
}
func (m *JwtRule) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *JwtRule) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Issuer) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.Issuer)))
		i += copy(dAtA[i:], m.Issuer)
	}
	if len(m.Audiences) > 0 {
		for _, s := range m.Audiences {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.JwksSourceSpecifier != nil {
		nn1, err := m.JwksSourceSpecifier.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn1
	}
	if m.Forward {
		dAtA[i] = 0x28
		i++
		if m.Forward {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.FromHeaders) > 0 {
		for _, msg := range m.FromHeaders {
			dAtA[i] = 0x32
			i++
			i = encodeVarintConfig(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.FromParams) > 0 {
		for _, s := range m.FromParams {
			dAtA[i] = 0x3a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.ForwardPayloadHeader) > 0 {
		dAtA[i] = 0x42
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.ForwardPayloadHeader)))
		i += copy(dAtA[i:], m.ForwardPayloadHeader)
	}
	return i, nil
}

func (m *JwtRule_RemoteJwks) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.RemoteJwks != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.RemoteJwks.Size()))
		n2, err := m.RemoteJwks.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	return i, nil
}
func (m *JwtRule_LocalJwks) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.LocalJwks != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.LocalJwks.Size()))
		n3, err := m.LocalJwks.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	return i, nil
}
func (m *RemoteJwks) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RemoteJwks) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.HttpUri != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.HttpUri.Size()))
		n4, err := m.HttpUri.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.CacheDuration != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.CacheDuration.Size()))
		n5, err := m.CacheDuration.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	return i, nil
}

func (m *JwtHeader) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *JwtHeader) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.ValuePrefix) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.ValuePrefix)))
		i += copy(dAtA[i:], m.ValuePrefix)
	}
	return i, nil
}

func (m *JwtAuthentication) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *JwtAuthentication) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Rules) > 0 {
		for _, msg := range m.Rules {
			dAtA[i] = 0xa
			i++
			i = encodeVarintConfig(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.AllowMissingOrFailed {
		dAtA[i] = 0x10
		i++
		if m.AllowMissingOrFailed {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.Bypass) > 0 {
		for _, msg := range m.Bypass {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintConfig(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func encodeVarintConfig(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *JwtRule) Size() (n int) {
	var l int
	_ = l
	l = len(m.Issuer)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if len(m.Audiences) > 0 {
		for _, s := range m.Audiences {
			l = len(s)
			n += 1 + l + sovConfig(uint64(l))
		}
	}
	if m.JwksSourceSpecifier != nil {
		n += m.JwksSourceSpecifier.Size()
	}
	if m.Forward {
		n += 2
	}
	if len(m.FromHeaders) > 0 {
		for _, e := range m.FromHeaders {
			l = e.Size()
			n += 1 + l + sovConfig(uint64(l))
		}
	}
	if len(m.FromParams) > 0 {
		for _, s := range m.FromParams {
			l = len(s)
			n += 1 + l + sovConfig(uint64(l))
		}
	}
	l = len(m.ForwardPayloadHeader)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	return n
}

func (m *JwtRule_RemoteJwks) Size() (n int) {
	var l int
	_ = l
	if m.RemoteJwks != nil {
		l = m.RemoteJwks.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	return n
}
func (m *JwtRule_LocalJwks) Size() (n int) {
	var l int
	_ = l
	if m.LocalJwks != nil {
		l = m.LocalJwks.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	return n
}
func (m *RemoteJwks) Size() (n int) {
	var l int
	_ = l
	if m.HttpUri != nil {
		l = m.HttpUri.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.CacheDuration != nil {
		l = m.CacheDuration.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	return n
}

func (m *JwtHeader) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.ValuePrefix)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	return n
}

func (m *JwtAuthentication) Size() (n int) {
	var l int
	_ = l
	if len(m.Rules) > 0 {
		for _, e := range m.Rules {
			l = e.Size()
			n += 1 + l + sovConfig(uint64(l))
		}
	}
	if m.AllowMissingOrFailed {
		n += 2
	}
	if len(m.Bypass) > 0 {
		for _, e := range m.Bypass {
			l = e.Size()
			n += 1 + l + sovConfig(uint64(l))
		}
	}
	return n
}

func sovConfig(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozConfig(x uint64) (n int) {
	return sovConfig(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *JwtRule) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: JwtRule: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: JwtRule: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Issuer", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Issuer = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Audiences", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Audiences = append(m.Audiences, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RemoteJwks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &RemoteJwks{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.JwksSourceSpecifier = &JwtRule_RemoteJwks{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocalJwks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &envoy_api_v2_core.DataSource{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.JwksSourceSpecifier = &JwtRule_LocalJwks{v}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Forward", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Forward = bool(v != 0)
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FromHeaders", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FromHeaders = append(m.FromHeaders, &JwtHeader{})
			if err := m.FromHeaders[len(m.FromHeaders)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FromParams", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FromParams = append(m.FromParams, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForwardPayloadHeader", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ForwardPayloadHeader = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RemoteJwks) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RemoteJwks: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RemoteJwks: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpUri", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HttpUri == nil {
				m.HttpUri = &envoy_api_v2_core1.HttpUri{}
			}
			if err := m.HttpUri.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CacheDuration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CacheDuration == nil {
				m.CacheDuration = &google_protobuf3.Duration{}
			}
			if err := m.CacheDuration.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *JwtHeader) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: JwtHeader: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: JwtHeader: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValuePrefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ValuePrefix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *JwtAuthentication) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: JwtAuthentication: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: JwtAuthentication: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rules", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Rules = append(m.Rules, &JwtRule{})
			if err := m.Rules[len(m.Rules)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AllowMissingOrFailed", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.AllowMissingOrFailed = bool(v != 0)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bypass", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Bypass = append(m.Bypass, &envoy_api_v2_route.RouteMatch{})
			if err := m.Bypass[len(m.Bypass)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipConfig(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthConfig
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowConfig
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipConfig(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthConfig = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowConfig   = fmt.Errorf("proto: integer overflow")
)

func init() {
	proto.RegisterFile("envoy/config/filter/http/jwt_authn/v2alpha/config.proto", fileDescriptorConfig)
}

var fileDescriptorConfig = []byte{
	// 641 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x53, 0xc1, 0x6e, 0xd3, 0x40,
	0x10, 0xad, 0x9b, 0x36, 0x89, 0x37, 0x05, 0x89, 0x55, 0xa1, 0xa6, 0x6a, 0x83, 0x9b, 0x53, 0xc4,
	0xc1, 0x96, 0x52, 0x5a, 0x6e, 0x08, 0xaa, 0x0a, 0x85, 0x48, 0x15, 0xd5, 0x22, 0x24, 0x38, 0x59,
	0x13, 0x7b, 0x1d, 0x6f, 0xeb, 0x78, 0xad, 0xdd, 0x75, 0x4c, 0x3f, 0x80, 0x7f, 0x42, 0x9c, 0x7a,
	0xe4, 0x82, 0xd4, 0x4f, 0x40, 0xbd, 0xf5, 0x2f, 0x90, 0x77, 0xed, 0x54, 0x55, 0x39, 0xd0, 0xcb,
	0x6a, 0x67, 0xde, 0xbc, 0xb7, 0xe3, 0x37, 0x63, 0xf4, 0x9a, 0x66, 0x0b, 0x7e, 0xe1, 0x87, 0x3c,
	0x8b, 0xd9, 0xcc, 0x8f, 0x59, 0xaa, 0xa8, 0xf0, 0x13, 0xa5, 0x72, 0xff, 0xac, 0x54, 0x01, 0x14,
	0x2a, 0xc9, 0xfc, 0xc5, 0x08, 0xd2, 0x3c, 0x81, 0xba, 0xc8, 0xcb, 0x05, 0x57, 0x1c, 0xbf, 0xd4,
	0x44, 0xaf, 0xce, 0x19, 0xa2, 0x57, 0x11, 0xbd, 0x25, 0xd1, 0xab, 0x89, 0xdb, 0x3b, 0xe6, 0x11,
	0xc8, 0x99, 0xbf, 0x18, 0xf9, 0x21, 0x17, 0xd4, 0x9f, 0x82, 0xa4, 0x46, 0x69, 0xdb, 0xbd, 0x8f,
	0x56, 0x3a, 0x41, 0x21, 0x58, 0x5d, 0xd1, 0xbf, 0x53, 0x21, 0x78, 0xa1, 0xa8, 0x39, 0x1b, 0x7c,
	0xc6, 0xf9, 0x2c, 0xa5, 0xbe, 0x8e, 0xa6, 0x45, 0xec, 0x47, 0x85, 0x00, 0xc5, 0x78, 0x56, 0xe3,
	0x5b, 0x0b, 0x48, 0x59, 0x04, 0x8a, 0xfa, 0xcd, 0xc5, 0x00, 0x83, 0xab, 0x16, 0xea, 0x4c, 0x4a,
	0x45, 0x8a, 0x94, 0xe2, 0x3d, 0xd4, 0x66, 0x52, 0x16, 0x54, 0x38, 0x96, 0x6b, 0x0d, 0xed, 0x23,
	0xfb, 0xe7, 0xcd, 0x65, 0x6b, 0x4d, 0xac, 0xba, 0x16, 0xa9, 0x01, 0xbc, 0x83, 0x6c, 0x28, 0x22,
	0x46, 0xb3, 0x90, 0x4a, 0x67, 0xd5, 0x6d, 0x0d, 0x6d, 0x72, 0x9b, 0xc0, 0x5f, 0x51, 0x4f, 0xd0,
	0x39, 0x57, 0x34, 0x38, 0x2b, 0xcf, 0xa5, 0xd3, 0x72, 0xad, 0x61, 0x6f, 0x74, 0xe8, 0xfd, 0xbf,
	0x4f, 0x1e, 0xd1, 0xf4, 0x49, 0x79, 0x2e, 0xc7, 0x2b, 0x04, 0x89, 0x65, 0x84, 0xdf, 0x20, 0x94,
	0xf2, 0x10, 0x52, 0xa3, 0xbc, 0xa6, 0x95, 0x77, 0x6b, 0x65, 0xc8, 0x99, 0xb7, 0x18, 0x79, 0x95,
	0x6f, 0xde, 0x31, 0x28, 0xf8, 0xc4, 0x0b, 0x11, 0xd2, 0xf1, 0x0a, 0xb1, 0x35, 0x45, 0xf3, 0x1d,
	0xd4, 0x89, 0xb9, 0x28, 0x41, 0x44, 0xce, 0xba, 0x6b, 0x0d, 0xbb, 0xa4, 0x09, 0xf1, 0x17, 0xb4,
	0x11, 0x0b, 0x3e, 0x0f, 0x12, 0x0a, 0x11, 0x15, 0xd2, 0x69, 0xbb, 0xad, 0x61, 0x6f, 0x74, 0xf0,
	0x90, 0xae, 0x27, 0xa5, 0x1a, 0x6b, 0x36, 0xe9, 0x55, 0x52, 0xe6, 0x2e, 0xf1, 0x0b, 0xa4, 0xc3,
	0x20, 0x07, 0x01, 0x73, 0xe9, 0x74, 0xb4, 0x5d, 0xa8, 0x4a, 0x9d, 0xea, 0x0c, 0x7e, 0x85, 0x9e,
	0xd5, 0x5d, 0x04, 0x39, 0x5c, 0xa4, 0x1c, 0xa2, 0xba, 0x0b, 0xa7, 0x5b, 0x0d, 0x80, 0x6c, 0xd6,
	0xe8, 0xa9, 0x01, 0x8d, 0xee, 0x51, 0x1f, 0x3d, 0xad, 0x4c, 0x08, 0xa4, 0xfe, 0xcc, 0x40, 0xe6,
	0x34, 0x64, 0x31, 0xa3, 0x02, 0xaf, 0xff, 0xb8, 0xb9, 0x6c, 0x59, 0x83, 0xef, 0x16, 0x42, 0xb7,
	0x3e, 0xe2, 0x03, 0xd4, 0x6d, 0x96, 0x49, 0xcf, 0xb5, 0x37, 0xda, 0xfe, 0x87, 0x6f, 0x63, 0xa5,
	0xf2, 0xcf, 0x82, 0x91, 0x4e, 0x62, 0x2e, 0xf8, 0x2d, 0x7a, 0x1c, 0x42, 0x98, 0xd0, 0xa0, 0xd9,
	0x24, 0x67, 0x55, 0x93, 0x9f, 0x7b, 0x66, 0xd5, 0xbc, 0x66, 0xd5, 0xbc, 0xe3, 0xba, 0x80, 0x3c,
	0xd2, 0x84, 0x26, 0x1c, 0x9c, 0x20, 0x7b, 0x69, 0x0c, 0xde, 0x45, 0x6b, 0x19, 0xcc, 0xe9, 0xfd,
	0xcd, 0xd2, 0x69, 0xbc, 0x87, 0x36, 0x16, 0x90, 0x16, 0x34, 0xc8, 0x05, 0x8d, 0xd9, 0x37, 0xfd,
	0x96, 0x4d, 0x7a, 0x3a, 0x77, 0xaa, 0x53, 0x83, 0xdf, 0x16, 0x7a, 0x32, 0x29, 0xd5, 0xbb, 0x42,
	0x25, 0x34, 0x53, 0x2c, 0xd4, 0x8f, 0xe0, 0x0f, 0x68, 0x5d, 0x14, 0x29, 0x95, 0x8e, 0xa5, 0xc7,
	0xb6, 0xff, 0xc0, 0xb1, 0x55, 0x7b, 0x4f, 0x8c, 0x02, 0x3e, 0x40, 0x5b, 0x90, 0xa6, 0xbc, 0x0c,
	0xe6, 0x4c, 0x4a, 0x96, 0xcd, 0x02, 0x2e, 0x82, 0x18, 0x58, 0x4a, 0x23, 0xdd, 0x4e, 0x97, 0x6c,
	0x6a, 0xf8, 0xc4, 0xa0, 0x1f, 0xc5, 0x7b, 0x8d, 0xe1, 0x43, 0xd4, 0x9e, 0x5e, 0xe4, 0x20, 0xab,
	0x7d, 0xaf, 0x5a, 0xe8, 0xdf, 0x75, 0xd7, 0xfc, 0xa5, 0xa4, 0x3a, 0x4f, 0x40, 0x85, 0x09, 0xa9,
	0xab, 0x8f, 0x36, 0x7e, 0x5d, 0xf7, 0xad, 0xab, 0xeb, 0xbe, 0xf5, 0xe7, 0xba, 0x6f, 0x4d, 0xdb,
	0xda, 0xce, 0xfd, 0xbf, 0x01, 0x00, 0x00, 0xff, 0xff, 0x9e, 0xa4, 0x21, 0xaf, 0x8e, 0x04, 0x00,
	0x00,
}
