// Code generated by protoc-gen-validate
// source: envoy/config/filter/accesslog/v2/accesslog.proto
// DO NOT EDIT!!!

package v2

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"strings"
	"time"
	"unicode/utf8"

	"github.com/gogo/protobuf/types"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = types.DynamicAny{}
)

// Validate checks the field values on AccessLogCommon with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *AccessLogCommon) Validate() error {
	if m == nil {
		return nil
	}

	if m.GetSampleRate() > 1 {
		return AccessLogCommonValidationError{
			Field:  "SampleRate",
			Reason: "value must be less than or equal to 1",
		}
	}

	if v, ok := interface{}(m.GetDownstreamRemoteAddress()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AccessLogCommonValidationError{
				Field:  "DownstreamRemoteAddress",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetDownstreamLocalAddress()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AccessLogCommonValidationError{
				Field:  "DownstreamLocalAddress",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetTlsProperties()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AccessLogCommonValidationError{
				Field:  "TlsProperties",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetStartTime()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AccessLogCommonValidationError{
				Field:  "StartTime",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetTimeToLastRxByte()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AccessLogCommonValidationError{
				Field:  "TimeToLastRxByte",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetTimeToFirstUpstreamTxByte()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AccessLogCommonValidationError{
				Field:  "TimeToFirstUpstreamTxByte",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetTimeToLastUpstreamTxByte()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AccessLogCommonValidationError{
				Field:  "TimeToLastUpstreamTxByte",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetTimeToFirstUpstreamRxByte()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AccessLogCommonValidationError{
				Field:  "TimeToFirstUpstreamRxByte",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetTimeToLastUpstreamRxByte()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AccessLogCommonValidationError{
				Field:  "TimeToLastUpstreamRxByte",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetTimeToFirstDownstreamTxByte()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AccessLogCommonValidationError{
				Field:  "TimeToFirstDownstreamTxByte",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetTimeToLastDownstreamTxByte()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AccessLogCommonValidationError{
				Field:  "TimeToLastDownstreamTxByte",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetUpstreamRemoteAddress()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AccessLogCommonValidationError{
				Field:  "UpstreamRemoteAddress",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetUpstreamLocalAddress()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AccessLogCommonValidationError{
				Field:  "UpstreamLocalAddress",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	// no validation rules for UpstreamCluster

	if v, ok := interface{}(m.GetResponseFlags()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AccessLogCommonValidationError{
				Field:  "ResponseFlags",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetMetadata()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AccessLogCommonValidationError{
				Field:  "Metadata",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	return nil
}

// AccessLogCommonValidationError is the validation error returned by
// AccessLogCommon.Validate if the designated constraints aren't met.
type AccessLogCommonValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e AccessLogCommonValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAccessLogCommon.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = AccessLogCommonValidationError{}

// Validate checks the field values on ResponseFlags with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *ResponseFlags) Validate() error {
	if m == nil {
		return nil
	}

	// no validation rules for FailedLocalHealthcheck

	// no validation rules for NoHealthyUpstream

	// no validation rules for UpstreamRequestTimeout

	// no validation rules for LocalReset

	// no validation rules for UpstreamRemoteReset

	// no validation rules for UpstreamConnectionFailure

	// no validation rules for UpstreamConnectionTermination

	// no validation rules for UpstreamOverflow

	// no validation rules for NoRouteFound

	// no validation rules for DelayInjected

	// no validation rules for FaultInjected

	// no validation rules for RateLimited

	if v, ok := interface{}(m.GetUnauthorizedDetails()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ResponseFlagsValidationError{
				Field:  "UnauthorizedDetails",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	return nil
}

// ResponseFlagsValidationError is the validation error returned by
// ResponseFlags.Validate if the designated constraints aren't met.
type ResponseFlagsValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e ResponseFlagsValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sResponseFlags.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = ResponseFlagsValidationError{}

// Validate checks the field values on TLSProperties with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *TLSProperties) Validate() error {
	if m == nil {
		return nil
	}

	// no validation rules for TlsVersion

	if v, ok := interface{}(m.GetTlsCipherSuite()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return TLSPropertiesValidationError{
				Field:  "TlsCipherSuite",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	// no validation rules for TlsSniHostname

	return nil
}

// TLSPropertiesValidationError is the validation error returned by
// TLSProperties.Validate if the designated constraints aren't met.
type TLSPropertiesValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e TLSPropertiesValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTLSProperties.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = TLSPropertiesValidationError{}

// Validate checks the field values on TCPAccessLogEntry with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *TCPAccessLogEntry) Validate() error {
	if m == nil {
		return nil
	}

	if v, ok := interface{}(m.GetCommonProperties()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return TCPAccessLogEntryValidationError{
				Field:  "CommonProperties",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	return nil
}

// TCPAccessLogEntryValidationError is the validation error returned by
// TCPAccessLogEntry.Validate if the designated constraints aren't met.
type TCPAccessLogEntryValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e TCPAccessLogEntryValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTCPAccessLogEntry.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = TCPAccessLogEntryValidationError{}

// Validate checks the field values on HTTPRequestProperties with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *HTTPRequestProperties) Validate() error {
	if m == nil {
		return nil
	}

	// no validation rules for RequestMethod

	// no validation rules for Scheme

	// no validation rules for Authority

	if v, ok := interface{}(m.GetPort()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HTTPRequestPropertiesValidationError{
				Field:  "Port",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	// no validation rules for Path

	// no validation rules for UserAgent

	// no validation rules for Referer

	// no validation rules for ForwardedFor

	// no validation rules for RequestId

	// no validation rules for OriginalPath

	// no validation rules for RequestHeadersBytes

	// no validation rules for RequestBodyBytes

	// no validation rules for RequestHeaders

	return nil
}

// HTTPRequestPropertiesValidationError is the validation error returned by
// HTTPRequestProperties.Validate if the designated constraints aren't met.
type HTTPRequestPropertiesValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e HTTPRequestPropertiesValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHTTPRequestProperties.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = HTTPRequestPropertiesValidationError{}

// Validate checks the field values on HTTPResponseProperties with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *HTTPResponseProperties) Validate() error {
	if m == nil {
		return nil
	}

	if v, ok := interface{}(m.GetResponseCode()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HTTPResponsePropertiesValidationError{
				Field:  "ResponseCode",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	// no validation rules for ResponseHeadersBytes

	// no validation rules for ResponseBodyBytes

	// no validation rules for ResponseHeaders

	return nil
}

// HTTPResponsePropertiesValidationError is the validation error returned by
// HTTPResponseProperties.Validate if the designated constraints aren't met.
type HTTPResponsePropertiesValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e HTTPResponsePropertiesValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHTTPResponseProperties.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = HTTPResponsePropertiesValidationError{}

// Validate checks the field values on HTTPAccessLogEntry with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *HTTPAccessLogEntry) Validate() error {
	if m == nil {
		return nil
	}

	if v, ok := interface{}(m.GetCommonProperties()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HTTPAccessLogEntryValidationError{
				Field:  "CommonProperties",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	// no validation rules for ProtocolVersion

	if v, ok := interface{}(m.GetRequest()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HTTPAccessLogEntryValidationError{
				Field:  "Request",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetResponse()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HTTPAccessLogEntryValidationError{
				Field:  "Response",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	return nil
}

// HTTPAccessLogEntryValidationError is the validation error returned by
// HTTPAccessLogEntry.Validate if the designated constraints aren't met.
type HTTPAccessLogEntryValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e HTTPAccessLogEntryValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHTTPAccessLogEntry.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = HTTPAccessLogEntryValidationError{}

// Validate checks the field values on AccessLog with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *AccessLog) Validate() error {
	if m == nil {
		return nil
	}

	// no validation rules for Name

	if v, ok := interface{}(m.GetFilter()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AccessLogValidationError{
				Field:  "Filter",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AccessLogValidationError{
				Field:  "Config",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	return nil
}

// AccessLogValidationError is the validation error returned by
// AccessLog.Validate if the designated constraints aren't met.
type AccessLogValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e AccessLogValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAccessLog.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = AccessLogValidationError{}

// Validate checks the field values on AccessLogFilter with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *AccessLogFilter) Validate() error {
	if m == nil {
		return nil
	}

	switch m.FilterSpecifier.(type) {

	case *AccessLogFilter_StatusCodeFilter:

		if v, ok := interface{}(m.GetStatusCodeFilter()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return AccessLogFilterValidationError{
					Field:  "StatusCodeFilter",
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	case *AccessLogFilter_DurationFilter:

		if v, ok := interface{}(m.GetDurationFilter()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return AccessLogFilterValidationError{
					Field:  "DurationFilter",
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	case *AccessLogFilter_NotHealthCheckFilter:

		if v, ok := interface{}(m.GetNotHealthCheckFilter()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return AccessLogFilterValidationError{
					Field:  "NotHealthCheckFilter",
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	case *AccessLogFilter_TraceableFilter:

		if v, ok := interface{}(m.GetTraceableFilter()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return AccessLogFilterValidationError{
					Field:  "TraceableFilter",
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	case *AccessLogFilter_RuntimeFilter:

		if v, ok := interface{}(m.GetRuntimeFilter()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return AccessLogFilterValidationError{
					Field:  "RuntimeFilter",
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	case *AccessLogFilter_AndFilter:

		if v, ok := interface{}(m.GetAndFilter()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return AccessLogFilterValidationError{
					Field:  "AndFilter",
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	case *AccessLogFilter_OrFilter:

		if v, ok := interface{}(m.GetOrFilter()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return AccessLogFilterValidationError{
					Field:  "OrFilter",
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	case *AccessLogFilter_HeaderFilter:

		if v, ok := interface{}(m.GetHeaderFilter()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return AccessLogFilterValidationError{
					Field:  "HeaderFilter",
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	default:
		return AccessLogFilterValidationError{
			Field:  "FilterSpecifier",
			Reason: "value is required",
		}

	}

	return nil
}

// AccessLogFilterValidationError is the validation error returned by
// AccessLogFilter.Validate if the designated constraints aren't met.
type AccessLogFilterValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e AccessLogFilterValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAccessLogFilter.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = AccessLogFilterValidationError{}

// Validate checks the field values on ComparisonFilter with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *ComparisonFilter) Validate() error {
	if m == nil {
		return nil
	}

	if _, ok := ComparisonFilter_Op_name[int32(m.GetOp())]; !ok {
		return ComparisonFilterValidationError{
			Field:  "Op",
			Reason: "value must be one of the defined enum values",
		}
	}

	if v, ok := interface{}(m.GetValue()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ComparisonFilterValidationError{
				Field:  "Value",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	return nil
}

// ComparisonFilterValidationError is the validation error returned by
// ComparisonFilter.Validate if the designated constraints aren't met.
type ComparisonFilterValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e ComparisonFilterValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sComparisonFilter.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = ComparisonFilterValidationError{}

// Validate checks the field values on StatusCodeFilter with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *StatusCodeFilter) Validate() error {
	if m == nil {
		return nil
	}

	if m.GetComparison() == nil {
		return StatusCodeFilterValidationError{
			Field:  "Comparison",
			Reason: "value is required",
		}
	}

	if v, ok := interface{}(m.GetComparison()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return StatusCodeFilterValidationError{
				Field:  "Comparison",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	return nil
}

// StatusCodeFilterValidationError is the validation error returned by
// StatusCodeFilter.Validate if the designated constraints aren't met.
type StatusCodeFilterValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e StatusCodeFilterValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sStatusCodeFilter.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = StatusCodeFilterValidationError{}

// Validate checks the field values on DurationFilter with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *DurationFilter) Validate() error {
	if m == nil {
		return nil
	}

	if m.GetComparison() == nil {
		return DurationFilterValidationError{
			Field:  "Comparison",
			Reason: "value is required",
		}
	}

	if v, ok := interface{}(m.GetComparison()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return DurationFilterValidationError{
				Field:  "Comparison",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	return nil
}

// DurationFilterValidationError is the validation error returned by
// DurationFilter.Validate if the designated constraints aren't met.
type DurationFilterValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e DurationFilterValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDurationFilter.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = DurationFilterValidationError{}

// Validate checks the field values on NotHealthCheckFilter with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *NotHealthCheckFilter) Validate() error {
	if m == nil {
		return nil
	}

	return nil
}

// NotHealthCheckFilterValidationError is the validation error returned by
// NotHealthCheckFilter.Validate if the designated constraints aren't met.
type NotHealthCheckFilterValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e NotHealthCheckFilterValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sNotHealthCheckFilter.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = NotHealthCheckFilterValidationError{}

// Validate checks the field values on TraceableFilter with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *TraceableFilter) Validate() error {
	if m == nil {
		return nil
	}

	return nil
}

// TraceableFilterValidationError is the validation error returned by
// TraceableFilter.Validate if the designated constraints aren't met.
type TraceableFilterValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e TraceableFilterValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTraceableFilter.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = TraceableFilterValidationError{}

// Validate checks the field values on RuntimeFilter with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *RuntimeFilter) Validate() error {
	if m == nil {
		return nil
	}

	if len(m.GetRuntimeKey()) < 1 {
		return RuntimeFilterValidationError{
			Field:  "RuntimeKey",
			Reason: "value length must be at least 1 bytes",
		}
	}

	if v, ok := interface{}(m.GetPercentSampled()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RuntimeFilterValidationError{
				Field:  "PercentSampled",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	// no validation rules for UseIndependentRandomness

	return nil
}

// RuntimeFilterValidationError is the validation error returned by
// RuntimeFilter.Validate if the designated constraints aren't met.
type RuntimeFilterValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e RuntimeFilterValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRuntimeFilter.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = RuntimeFilterValidationError{}

// Validate checks the field values on AndFilter with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *AndFilter) Validate() error {
	if m == nil {
		return nil
	}

	if len(m.GetFilters()) < 2 {
		return AndFilterValidationError{
			Field:  "Filters",
			Reason: "value must contain at least 2 item(s)",
		}
	}

	for idx, item := range m.GetFilters() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return AndFilterValidationError{
					Field:  fmt.Sprintf("Filters[%v]", idx),
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	}

	return nil
}

// AndFilterValidationError is the validation error returned by
// AndFilter.Validate if the designated constraints aren't met.
type AndFilterValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e AndFilterValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAndFilter.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = AndFilterValidationError{}

// Validate checks the field values on OrFilter with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *OrFilter) Validate() error {
	if m == nil {
		return nil
	}

	if len(m.GetFilters()) < 2 {
		return OrFilterValidationError{
			Field:  "Filters",
			Reason: "value must contain at least 2 item(s)",
		}
	}

	for idx, item := range m.GetFilters() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return OrFilterValidationError{
					Field:  fmt.Sprintf("Filters[%v]", idx),
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	}

	return nil
}

// OrFilterValidationError is the validation error returned by
// OrFilter.Validate if the designated constraints aren't met.
type OrFilterValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e OrFilterValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sOrFilter.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = OrFilterValidationError{}

// Validate checks the field values on HeaderFilter with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *HeaderFilter) Validate() error {
	if m == nil {
		return nil
	}

	if m.GetHeader() == nil {
		return HeaderFilterValidationError{
			Field:  "Header",
			Reason: "value is required",
		}
	}

	if v, ok := interface{}(m.GetHeader()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HeaderFilterValidationError{
				Field:  "Header",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	return nil
}

// HeaderFilterValidationError is the validation error returned by
// HeaderFilter.Validate if the designated constraints aren't met.
type HeaderFilterValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e HeaderFilterValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHeaderFilter.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = HeaderFilterValidationError{}

// Validate checks the field values on FileAccessLog with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *FileAccessLog) Validate() error {
	if m == nil {
		return nil
	}

	if len(m.GetPath()) < 1 {
		return FileAccessLogValidationError{
			Field:  "Path",
			Reason: "value length must be at least 1 bytes",
		}
	}

	// no validation rules for Format

	return nil
}

// FileAccessLogValidationError is the validation error returned by
// FileAccessLog.Validate if the designated constraints aren't met.
type FileAccessLogValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e FileAccessLogValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sFileAccessLog.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = FileAccessLogValidationError{}

// Validate checks the field values on ResponseFlags_Unauthorized with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *ResponseFlags_Unauthorized) Validate() error {
	if m == nil {
		return nil
	}

	// no validation rules for Reason

	return nil
}

// ResponseFlags_UnauthorizedValidationError is the validation error returned
// by ResponseFlags_Unauthorized.Validate if the designated constraints aren't met.
type ResponseFlags_UnauthorizedValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e ResponseFlags_UnauthorizedValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sResponseFlags_Unauthorized.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = ResponseFlags_UnauthorizedValidationError{}
