// Code generated by protoc-gen-validate
// source: envoy/api/v2/route/route.proto
// DO NOT EDIT!!!

package route

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"strings"
	"time"
	"unicode/utf8"

	"github.com/gogo/protobuf/types"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = types.DynamicAny{}
)

// Validate checks the field values on VirtualHost with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *VirtualHost) Validate() error {
	if m == nil {
		return nil
	}

	if len(m.GetName()) < 1 {
		return VirtualHostValidationError{
			Field:  "Name",
			Reason: "value length must be at least 1 bytes",
		}
	}

	if len(m.GetDomains()) < 1 {
		return VirtualHostValidationError{
			Field:  "Domains",
			Reason: "value must contain at least 1 item(s)",
		}
	}

	for idx, item := range m.GetRoutes() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return VirtualHostValidationError{
					Field:  fmt.Sprintf("Routes[%v]", idx),
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	}

	// no validation rules for RequireTls

	for idx, item := range m.GetVirtualClusters() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return VirtualHostValidationError{
					Field:  fmt.Sprintf("VirtualClusters[%v]", idx),
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetRateLimits() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return VirtualHostValidationError{
					Field:  fmt.Sprintf("RateLimits[%v]", idx),
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetRequestHeadersToAdd() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return VirtualHostValidationError{
					Field:  fmt.Sprintf("RequestHeadersToAdd[%v]", idx),
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetResponseHeadersToAdd() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return VirtualHostValidationError{
					Field:  fmt.Sprintf("ResponseHeadersToAdd[%v]", idx),
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	}

	if v, ok := interface{}(m.GetCors()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return VirtualHostValidationError{
				Field:  "Cors",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetAuth()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return VirtualHostValidationError{
				Field:  "Auth",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	// no validation rules for PerFilterConfig

	return nil
}

// VirtualHostValidationError is the validation error returned by
// VirtualHost.Validate if the designated constraints aren't met.
type VirtualHostValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e VirtualHostValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sVirtualHost.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = VirtualHostValidationError{}

// Validate checks the field values on Route with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *Route) Validate() error {
	if m == nil {
		return nil
	}

	if v, ok := interface{}(m.GetMatch()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteValidationError{
				Field:  "Match",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetMetadata()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteValidationError{
				Field:  "Metadata",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetDecorator()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteValidationError{
				Field:  "Decorator",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetAuth()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteValidationError{
				Field:  "Auth",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	// no validation rules for PerFilterConfig

	switch m.Action.(type) {

	case *Route_Route:

		if v, ok := interface{}(m.GetRoute()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteValidationError{
					Field:  "Route",
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	case *Route_Redirect:

		if v, ok := interface{}(m.GetRedirect()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteValidationError{
					Field:  "Redirect",
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	case *Route_DirectResponse:

		if v, ok := interface{}(m.GetDirectResponse()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteValidationError{
					Field:  "DirectResponse",
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	default:
		return RouteValidationError{
			Field:  "Action",
			Reason: "value is required",
		}

	}

	return nil
}

// RouteValidationError is the validation error returned by Route.Validate if
// the designated constraints aren't met.
type RouteValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e RouteValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRoute.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = RouteValidationError{}

// Validate checks the field values on WeightedCluster with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *WeightedCluster) Validate() error {
	if m == nil {
		return nil
	}

	if len(m.GetClusters()) < 1 {
		return WeightedClusterValidationError{
			Field:  "Clusters",
			Reason: "value must contain at least 1 item(s)",
		}
	}

	for idx, item := range m.GetClusters() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return WeightedClusterValidationError{
					Field:  fmt.Sprintf("Clusters[%v]", idx),
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	}

	if wrapper := m.GetTotalWeight(); wrapper != nil {

		if wrapper.GetValue() < 1 {
			return WeightedClusterValidationError{
				Field:  "TotalWeight",
				Reason: "value must be greater than or equal to 1",
			}
		}

	}

	// no validation rules for RuntimeKeyPrefix

	return nil
}

// WeightedClusterValidationError is the validation error returned by
// WeightedCluster.Validate if the designated constraints aren't met.
type WeightedClusterValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e WeightedClusterValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sWeightedCluster.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = WeightedClusterValidationError{}

// Validate checks the field values on RouteMatch with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *RouteMatch) Validate() error {
	if m == nil {
		return nil
	}

	if v, ok := interface{}(m.GetCaseSensitive()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteMatchValidationError{
				Field:  "CaseSensitive",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetRuntime()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteMatchValidationError{
				Field:  "Runtime",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	for idx, item := range m.GetHeaders() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteMatchValidationError{
					Field:  fmt.Sprintf("Headers[%v]", idx),
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetQueryParameters() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteMatchValidationError{
					Field:  fmt.Sprintf("QueryParameters[%v]", idx),
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	}

	switch m.PathSpecifier.(type) {

	case *RouteMatch_Prefix:
		// no validation rules for Prefix

	case *RouteMatch_Path:
		// no validation rules for Path

	case *RouteMatch_Regex:
		// no validation rules for Regex

	default:
		return RouteMatchValidationError{
			Field:  "PathSpecifier",
			Reason: "value is required",
		}

	}

	return nil
}

// RouteMatchValidationError is the validation error returned by
// RouteMatch.Validate if the designated constraints aren't met.
type RouteMatchValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e RouteMatchValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRouteMatch.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = RouteMatchValidationError{}

// Validate checks the field values on CorsPolicy with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *CorsPolicy) Validate() error {
	if m == nil {
		return nil
	}

	// no validation rules for AllowMethods

	// no validation rules for AllowHeaders

	// no validation rules for ExposeHeaders

	// no validation rules for MaxAge

	if v, ok := interface{}(m.GetAllowCredentials()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return CorsPolicyValidationError{
				Field:  "AllowCredentials",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetEnabled()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return CorsPolicyValidationError{
				Field:  "Enabled",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	return nil
}

// CorsPolicyValidationError is the validation error returned by
// CorsPolicy.Validate if the designated constraints aren't met.
type CorsPolicyValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e CorsPolicyValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCorsPolicy.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = CorsPolicyValidationError{}

// Validate checks the field values on RouteAction with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *RouteAction) Validate() error {
	if m == nil {
		return nil
	}

	if _, ok := RouteAction_ClusterNotFoundResponseCode_name[int32(m.GetClusterNotFoundResponseCode())]; !ok {
		return RouteActionValidationError{
			Field:  "ClusterNotFoundResponseCode",
			Reason: "value must be one of the defined enum values",
		}
	}

	if v, ok := interface{}(m.GetMetadataMatch()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteActionValidationError{
				Field:  "MetadataMatch",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	// no validation rules for PrefixRewrite

	if v, ok := interface{}(m.GetTimeout()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteActionValidationError{
				Field:  "Timeout",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetRetryPolicy()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteActionValidationError{
				Field:  "RetryPolicy",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetRequestMirrorPolicy()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteActionValidationError{
				Field:  "RequestMirrorPolicy",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	// no validation rules for Priority

	for idx, item := range m.GetRequestHeadersToAdd() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteActionValidationError{
					Field:  fmt.Sprintf("RequestHeadersToAdd[%v]", idx),
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetResponseHeadersToAdd() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteActionValidationError{
					Field:  fmt.Sprintf("ResponseHeadersToAdd[%v]", idx),
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetRateLimits() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteActionValidationError{
					Field:  fmt.Sprintf("RateLimits[%v]", idx),
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	}

	if v, ok := interface{}(m.GetIncludeVhRateLimits()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteActionValidationError{
				Field:  "IncludeVhRateLimits",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	for idx, item := range m.GetHashPolicy() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteActionValidationError{
					Field:  fmt.Sprintf("HashPolicy[%v]", idx),
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	}

	if v, ok := interface{}(m.GetUseWebsocket()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteActionValidationError{
				Field:  "UseWebsocket",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetCors()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteActionValidationError{
				Field:  "Cors",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	switch m.ClusterSpecifier.(type) {

	case *RouteAction_Cluster:
		// no validation rules for Cluster

	case *RouteAction_ClusterHeader:
		// no validation rules for ClusterHeader

	case *RouteAction_WeightedClusters:

		if v, ok := interface{}(m.GetWeightedClusters()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteActionValidationError{
					Field:  "WeightedClusters",
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	default:
		return RouteActionValidationError{
			Field:  "ClusterSpecifier",
			Reason: "value is required",
		}

	}

	switch m.HostRewriteSpecifier.(type) {

	case *RouteAction_HostRewrite:
		// no validation rules for HostRewrite

	case *RouteAction_AutoHostRewrite:

		if v, ok := interface{}(m.GetAutoHostRewrite()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteActionValidationError{
					Field:  "AutoHostRewrite",
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	}

	return nil
}

// RouteActionValidationError is the validation error returned by
// RouteAction.Validate if the designated constraints aren't met.
type RouteActionValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e RouteActionValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRouteAction.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = RouteActionValidationError{}

// Validate checks the field values on RedirectAction with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *RedirectAction) Validate() error {
	if m == nil {
		return nil
	}

	// no validation rules for HostRedirect

	if _, ok := RedirectAction_RedirectResponseCode_name[int32(m.GetResponseCode())]; !ok {
		return RedirectActionValidationError{
			Field:  "ResponseCode",
			Reason: "value must be one of the defined enum values",
		}
	}

	// no validation rules for HttpsRedirect

	// no validation rules for StripQuery

	switch m.PathRewriteSpecifier.(type) {

	case *RedirectAction_PathRedirect:
		// no validation rules for PathRedirect

	case *RedirectAction_PrefixRewrite:
		// no validation rules for PrefixRewrite

	}

	return nil
}

// RedirectActionValidationError is the validation error returned by
// RedirectAction.Validate if the designated constraints aren't met.
type RedirectActionValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e RedirectActionValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRedirectAction.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = RedirectActionValidationError{}

// Validate checks the field values on DirectResponseAction with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *DirectResponseAction) Validate() error {
	if m == nil {
		return nil
	}

	if val := m.GetStatus(); val < 100 || val >= 600 {
		return DirectResponseActionValidationError{
			Field:  "Status",
			Reason: "value must be inside range [100, 600)",
		}
	}

	if v, ok := interface{}(m.GetBody()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return DirectResponseActionValidationError{
				Field:  "Body",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	return nil
}

// DirectResponseActionValidationError is the validation error returned by
// DirectResponseAction.Validate if the designated constraints aren't met.
type DirectResponseActionValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e DirectResponseActionValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDirectResponseAction.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = DirectResponseActionValidationError{}

// Validate checks the field values on Decorator with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *Decorator) Validate() error {
	if m == nil {
		return nil
	}

	if len(m.GetOperation()) < 1 {
		return DecoratorValidationError{
			Field:  "Operation",
			Reason: "value length must be at least 1 bytes",
		}
	}

	return nil
}

// DecoratorValidationError is the validation error returned by
// Decorator.Validate if the designated constraints aren't met.
type DecoratorValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e DecoratorValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDecorator.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = DecoratorValidationError{}

// Validate checks the field values on VirtualCluster with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *VirtualCluster) Validate() error {
	if m == nil {
		return nil
	}

	if len(m.GetPattern()) < 1 {
		return VirtualClusterValidationError{
			Field:  "Pattern",
			Reason: "value length must be at least 1 bytes",
		}
	}

	if len(m.GetName()) < 1 {
		return VirtualClusterValidationError{
			Field:  "Name",
			Reason: "value length must be at least 1 bytes",
		}
	}

	// no validation rules for Method

	return nil
}

// VirtualClusterValidationError is the validation error returned by
// VirtualCluster.Validate if the designated constraints aren't met.
type VirtualClusterValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e VirtualClusterValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sVirtualCluster.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = VirtualClusterValidationError{}

// Validate checks the field values on RateLimit with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *RateLimit) Validate() error {
	if m == nil {
		return nil
	}

	if wrapper := m.GetStage(); wrapper != nil {

		if wrapper.GetValue() > 10 {
			return RateLimitValidationError{
				Field:  "Stage",
				Reason: "value must be less than or equal to 10",
			}
		}

	}

	// no validation rules for DisableKey

	if len(m.GetActions()) < 1 {
		return RateLimitValidationError{
			Field:  "Actions",
			Reason: "value must contain at least 1 item(s)",
		}
	}

	for idx, item := range m.GetActions() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RateLimitValidationError{
					Field:  fmt.Sprintf("Actions[%v]", idx),
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	}

	return nil
}

// RateLimitValidationError is the validation error returned by
// RateLimit.Validate if the designated constraints aren't met.
type RateLimitValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e RateLimitValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRateLimit.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = RateLimitValidationError{}

// Validate checks the field values on HeaderMatcher with the rules defined in
// the proto definition for this message. If any rules are violated, an error
// is returned.
func (m *HeaderMatcher) Validate() error {
	if m == nil {
		return nil
	}

	if len(m.GetName()) < 1 {
		return HeaderMatcherValidationError{
			Field:  "Name",
			Reason: "value length must be at least 1 bytes",
		}
	}

	// no validation rules for Value

	if v, ok := interface{}(m.GetRegex()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HeaderMatcherValidationError{
				Field:  "Regex",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	switch m.HeaderMatchSpecifier.(type) {

	case *HeaderMatcher_ExactMatch:
		// no validation rules for ExactMatch

	case *HeaderMatcher_RegexMatch:
		// no validation rules for RegexMatch

	case *HeaderMatcher_RangeMatch:

		if v, ok := interface{}(m.GetRangeMatch()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return HeaderMatcherValidationError{
					Field:  "RangeMatch",
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	}

	return nil
}

// HeaderMatcherValidationError is the validation error returned by
// HeaderMatcher.Validate if the designated constraints aren't met.
type HeaderMatcherValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e HeaderMatcherValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHeaderMatcher.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = HeaderMatcherValidationError{}

// Validate checks the field values on QueryParameterMatcher with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *QueryParameterMatcher) Validate() error {
	if m == nil {
		return nil
	}

	if len(m.GetName()) < 1 {
		return QueryParameterMatcherValidationError{
			Field:  "Name",
			Reason: "value length must be at least 1 bytes",
		}
	}

	// no validation rules for Value

	if v, ok := interface{}(m.GetRegex()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return QueryParameterMatcherValidationError{
				Field:  "Regex",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	return nil
}

// QueryParameterMatcherValidationError is the validation error returned by
// QueryParameterMatcher.Validate if the designated constraints aren't met.
type QueryParameterMatcherValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e QueryParameterMatcherValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sQueryParameterMatcher.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = QueryParameterMatcherValidationError{}

// Validate checks the field values on WeightedCluster_ClusterWeight with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *WeightedCluster_ClusterWeight) Validate() error {
	if m == nil {
		return nil
	}

	if len(m.GetName()) < 1 {
		return WeightedCluster_ClusterWeightValidationError{
			Field:  "Name",
			Reason: "value length must be at least 1 bytes",
		}
	}

	if v, ok := interface{}(m.GetWeight()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return WeightedCluster_ClusterWeightValidationError{
				Field:  "Weight",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetMetadataMatch()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return WeightedCluster_ClusterWeightValidationError{
				Field:  "MetadataMatch",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	for idx, item := range m.GetRequestHeadersToAdd() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return WeightedCluster_ClusterWeightValidationError{
					Field:  fmt.Sprintf("RequestHeadersToAdd[%v]", idx),
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetResponseHeadersToAdd() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return WeightedCluster_ClusterWeightValidationError{
					Field:  fmt.Sprintf("ResponseHeadersToAdd[%v]", idx),
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	}

	// no validation rules for PerFilterConfig

	return nil
}

// WeightedCluster_ClusterWeightValidationError is the validation error
// returned by WeightedCluster_ClusterWeight.Validate if the designated
// constraints aren't met.
type WeightedCluster_ClusterWeightValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e WeightedCluster_ClusterWeightValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sWeightedCluster_ClusterWeight.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = WeightedCluster_ClusterWeightValidationError{}

// Validate checks the field values on RouteAction_RetryPolicy with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *RouteAction_RetryPolicy) Validate() error {
	if m == nil {
		return nil
	}

	// no validation rules for RetryOn

	if v, ok := interface{}(m.GetNumRetries()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteAction_RetryPolicyValidationError{
				Field:  "NumRetries",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if v, ok := interface{}(m.GetPerTryTimeout()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteAction_RetryPolicyValidationError{
				Field:  "PerTryTimeout",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	return nil
}

// RouteAction_RetryPolicyValidationError is the validation error returned by
// RouteAction_RetryPolicy.Validate if the designated constraints aren't met.
type RouteAction_RetryPolicyValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e RouteAction_RetryPolicyValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRouteAction_RetryPolicy.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = RouteAction_RetryPolicyValidationError{}

// Validate checks the field values on RouteAction_RequestMirrorPolicy with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *RouteAction_RequestMirrorPolicy) Validate() error {
	if m == nil {
		return nil
	}

	if len(m.GetCluster()) < 1 {
		return RouteAction_RequestMirrorPolicyValidationError{
			Field:  "Cluster",
			Reason: "value length must be at least 1 bytes",
		}
	}

	// no validation rules for RuntimeKey

	return nil
}

// RouteAction_RequestMirrorPolicyValidationError is the validation error
// returned by RouteAction_RequestMirrorPolicy.Validate if the designated
// constraints aren't met.
type RouteAction_RequestMirrorPolicyValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e RouteAction_RequestMirrorPolicyValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRouteAction_RequestMirrorPolicy.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = RouteAction_RequestMirrorPolicyValidationError{}

// Validate checks the field values on RouteAction_HashPolicy with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *RouteAction_HashPolicy) Validate() error {
	if m == nil {
		return nil
	}

	switch m.PolicySpecifier.(type) {

	case *RouteAction_HashPolicy_Header_:

		if v, ok := interface{}(m.GetHeader()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteAction_HashPolicyValidationError{
					Field:  "Header",
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	case *RouteAction_HashPolicy_Cookie_:

		if v, ok := interface{}(m.GetCookie()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteAction_HashPolicyValidationError{
					Field:  "Cookie",
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	case *RouteAction_HashPolicy_ConnectionProperties_:

		if v, ok := interface{}(m.GetConnectionProperties()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RouteAction_HashPolicyValidationError{
					Field:  "ConnectionProperties",
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	default:
		return RouteAction_HashPolicyValidationError{
			Field:  "PolicySpecifier",
			Reason: "value is required",
		}

	}

	return nil
}

// RouteAction_HashPolicyValidationError is the validation error returned by
// RouteAction_HashPolicy.Validate if the designated constraints aren't met.
type RouteAction_HashPolicyValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e RouteAction_HashPolicyValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRouteAction_HashPolicy.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = RouteAction_HashPolicyValidationError{}

// Validate checks the field values on RouteAction_HashPolicy_Header with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *RouteAction_HashPolicy_Header) Validate() error {
	if m == nil {
		return nil
	}

	if len(m.GetHeaderName()) < 1 {
		return RouteAction_HashPolicy_HeaderValidationError{
			Field:  "HeaderName",
			Reason: "value length must be at least 1 bytes",
		}
	}

	return nil
}

// RouteAction_HashPolicy_HeaderValidationError is the validation error
// returned by RouteAction_HashPolicy_Header.Validate if the designated
// constraints aren't met.
type RouteAction_HashPolicy_HeaderValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e RouteAction_HashPolicy_HeaderValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRouteAction_HashPolicy_Header.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = RouteAction_HashPolicy_HeaderValidationError{}

// Validate checks the field values on RouteAction_HashPolicy_Cookie with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *RouteAction_HashPolicy_Cookie) Validate() error {
	if m == nil {
		return nil
	}

	if len(m.GetName()) < 1 {
		return RouteAction_HashPolicy_CookieValidationError{
			Field:  "Name",
			Reason: "value length must be at least 1 bytes",
		}
	}

	if v, ok := interface{}(m.GetTtl()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RouteAction_HashPolicy_CookieValidationError{
				Field:  "Ttl",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	return nil
}

// RouteAction_HashPolicy_CookieValidationError is the validation error
// returned by RouteAction_HashPolicy_Cookie.Validate if the designated
// constraints aren't met.
type RouteAction_HashPolicy_CookieValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e RouteAction_HashPolicy_CookieValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRouteAction_HashPolicy_Cookie.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = RouteAction_HashPolicy_CookieValidationError{}

// Validate checks the field values on
// RouteAction_HashPolicy_ConnectionProperties with the rules defined in the
// proto definition for this message. If any rules are violated, an error is returned.
func (m *RouteAction_HashPolicy_ConnectionProperties) Validate() error {
	if m == nil {
		return nil
	}

	// no validation rules for SourceIp

	return nil
}

// RouteAction_HashPolicy_ConnectionPropertiesValidationError is the validation
// error returned by RouteAction_HashPolicy_ConnectionProperties.Validate if
// the designated constraints aren't met.
type RouteAction_HashPolicy_ConnectionPropertiesValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e RouteAction_HashPolicy_ConnectionPropertiesValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRouteAction_HashPolicy_ConnectionProperties.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = RouteAction_HashPolicy_ConnectionPropertiesValidationError{}

// Validate checks the field values on RateLimit_Action with the rules defined
// in the proto definition for this message. If any rules are violated, an
// error is returned.
func (m *RateLimit_Action) Validate() error {
	if m == nil {
		return nil
	}

	switch m.ActionSpecifier.(type) {

	case *RateLimit_Action_SourceCluster_:

		if v, ok := interface{}(m.GetSourceCluster()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RateLimit_ActionValidationError{
					Field:  "SourceCluster",
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	case *RateLimit_Action_DestinationCluster_:

		if v, ok := interface{}(m.GetDestinationCluster()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RateLimit_ActionValidationError{
					Field:  "DestinationCluster",
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	case *RateLimit_Action_RequestHeaders_:

		if v, ok := interface{}(m.GetRequestHeaders()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RateLimit_ActionValidationError{
					Field:  "RequestHeaders",
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	case *RateLimit_Action_RemoteAddress_:

		if v, ok := interface{}(m.GetRemoteAddress()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RateLimit_ActionValidationError{
					Field:  "RemoteAddress",
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	case *RateLimit_Action_GenericKey_:

		if v, ok := interface{}(m.GetGenericKey()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RateLimit_ActionValidationError{
					Field:  "GenericKey",
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	case *RateLimit_Action_HeaderValueMatch_:

		if v, ok := interface{}(m.GetHeaderValueMatch()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RateLimit_ActionValidationError{
					Field:  "HeaderValueMatch",
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	default:
		return RateLimit_ActionValidationError{
			Field:  "ActionSpecifier",
			Reason: "value is required",
		}

	}

	return nil
}

// RateLimit_ActionValidationError is the validation error returned by
// RateLimit_Action.Validate if the designated constraints aren't met.
type RateLimit_ActionValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e RateLimit_ActionValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRateLimit_Action.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = RateLimit_ActionValidationError{}

// Validate checks the field values on RateLimit_Action_SourceCluster with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *RateLimit_Action_SourceCluster) Validate() error {
	if m == nil {
		return nil
	}

	return nil
}

// RateLimit_Action_SourceClusterValidationError is the validation error
// returned by RateLimit_Action_SourceCluster.Validate if the designated
// constraints aren't met.
type RateLimit_Action_SourceClusterValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e RateLimit_Action_SourceClusterValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRateLimit_Action_SourceCluster.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = RateLimit_Action_SourceClusterValidationError{}

// Validate checks the field values on RateLimit_Action_DestinationCluster with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *RateLimit_Action_DestinationCluster) Validate() error {
	if m == nil {
		return nil
	}

	return nil
}

// RateLimit_Action_DestinationClusterValidationError is the validation error
// returned by RateLimit_Action_DestinationCluster.Validate if the designated
// constraints aren't met.
type RateLimit_Action_DestinationClusterValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e RateLimit_Action_DestinationClusterValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRateLimit_Action_DestinationCluster.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = RateLimit_Action_DestinationClusterValidationError{}

// Validate checks the field values on RateLimit_Action_RequestHeaders with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *RateLimit_Action_RequestHeaders) Validate() error {
	if m == nil {
		return nil
	}

	if len(m.GetHeaderName()) < 1 {
		return RateLimit_Action_RequestHeadersValidationError{
			Field:  "HeaderName",
			Reason: "value length must be at least 1 bytes",
		}
	}

	if len(m.GetDescriptorKey()) < 1 {
		return RateLimit_Action_RequestHeadersValidationError{
			Field:  "DescriptorKey",
			Reason: "value length must be at least 1 bytes",
		}
	}

	return nil
}

// RateLimit_Action_RequestHeadersValidationError is the validation error
// returned by RateLimit_Action_RequestHeaders.Validate if the designated
// constraints aren't met.
type RateLimit_Action_RequestHeadersValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e RateLimit_Action_RequestHeadersValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRateLimit_Action_RequestHeaders.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = RateLimit_Action_RequestHeadersValidationError{}

// Validate checks the field values on RateLimit_Action_RemoteAddress with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *RateLimit_Action_RemoteAddress) Validate() error {
	if m == nil {
		return nil
	}

	return nil
}

// RateLimit_Action_RemoteAddressValidationError is the validation error
// returned by RateLimit_Action_RemoteAddress.Validate if the designated
// constraints aren't met.
type RateLimit_Action_RemoteAddressValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e RateLimit_Action_RemoteAddressValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRateLimit_Action_RemoteAddress.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = RateLimit_Action_RemoteAddressValidationError{}

// Validate checks the field values on RateLimit_Action_GenericKey with the
// rules defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *RateLimit_Action_GenericKey) Validate() error {
	if m == nil {
		return nil
	}

	if len(m.GetDescriptorValue()) < 1 {
		return RateLimit_Action_GenericKeyValidationError{
			Field:  "DescriptorValue",
			Reason: "value length must be at least 1 bytes",
		}
	}

	return nil
}

// RateLimit_Action_GenericKeyValidationError is the validation error returned
// by RateLimit_Action_GenericKey.Validate if the designated constraints
// aren't met.
type RateLimit_Action_GenericKeyValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e RateLimit_Action_GenericKeyValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRateLimit_Action_GenericKey.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = RateLimit_Action_GenericKeyValidationError{}

// Validate checks the field values on RateLimit_Action_HeaderValueMatch with
// the rules defined in the proto definition for this message. If any rules
// are violated, an error is returned.
func (m *RateLimit_Action_HeaderValueMatch) Validate() error {
	if m == nil {
		return nil
	}

	if len(m.GetDescriptorValue()) < 1 {
		return RateLimit_Action_HeaderValueMatchValidationError{
			Field:  "DescriptorValue",
			Reason: "value length must be at least 1 bytes",
		}
	}

	if v, ok := interface{}(m.GetExpectMatch()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RateLimit_Action_HeaderValueMatchValidationError{
				Field:  "ExpectMatch",
				Reason: "embedded message failed validation",
				Cause:  err,
			}
		}
	}

	if len(m.GetHeaders()) < 1 {
		return RateLimit_Action_HeaderValueMatchValidationError{
			Field:  "Headers",
			Reason: "value must contain at least 1 item(s)",
		}
	}

	for idx, item := range m.GetHeaders() {
		_, _ = idx, item

		if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RateLimit_Action_HeaderValueMatchValidationError{
					Field:  fmt.Sprintf("Headers[%v]", idx),
					Reason: "embedded message failed validation",
					Cause:  err,
				}
			}
		}

	}

	return nil
}

// RateLimit_Action_HeaderValueMatchValidationError is the validation error
// returned by RateLimit_Action_HeaderValueMatch.Validate if the designated
// constraints aren't met.
type RateLimit_Action_HeaderValueMatchValidationError struct {
	Field  string
	Reason string
	Cause  error
	Key    bool
}

// Error satisfies the builtin error interface
func (e RateLimit_Action_HeaderValueMatchValidationError) Error() string {
	cause := ""
	if e.Cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.Cause)
	}

	key := ""
	if e.Key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRateLimit_Action_HeaderValueMatch.%s: %s%s",
		key,
		e.Field,
		e.Reason,
		cause)
}

var _ error = RateLimit_Action_HeaderValueMatchValidationError{}
