// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: envoy/api/v2/listener/listener.proto

/*
	Package listener is a generated protocol buffer package.

	It is generated from these files:
		envoy/api/v2/listener/listener.proto

	It has these top-level messages:
		Filter
		FilterChainMatch
		FilterChain
		ListenerFilter
*/
package listener

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import envoy_api_v2_core "github.com/envoyproxy/go-control-plane/envoy/api/v2/core"
import envoy_api_v2_auth "github.com/envoyproxy/go-control-plane/envoy/api/v2/auth"
import envoy_api_v2_core1 "github.com/envoyproxy/go-control-plane/envoy/api/v2/core"
import google_protobuf4 "github.com/gogo/protobuf/types"
import google_protobuf "github.com/gogo/protobuf/types"
import _ "github.com/lyft/protoc-gen-validate/validate"
import _ "github.com/gogo/protobuf/gogoproto"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type Filter struct {
	// The name of the filter to instantiate. The name must match a supported
	// filter. The built-in filters are:
	//
	// [#comment:TODO(mattklein123): Auto generate the following list]
	// * :ref:`envoy.client_ssl_auth<config_network_filters_client_ssl_auth>`
	// * :ref:`envoy.echo <config_network_filters_echo>`
	// * :ref:`envoy.http_connection_manager <config_http_conn_man>`
	// * :ref:`envoy.mongo_proxy <config_network_filters_mongo_proxy>`
	// * :ref:`envoy.ratelimit <config_network_filters_rate_limit>`
	// * :ref:`envoy.redis_proxy <config_network_filters_redis_proxy>`
	// * :ref:`envoy.tcp_proxy <config_network_filters_tcp_proxy>`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Filter specific configuration which depends on the filter being
	// instantiated. See the supported filters for further documentation.
	Config *google_protobuf4.Struct `protobuf:"bytes,2,opt,name=config" json:"config,omitempty"`
	// [#not-implemented-hide:]
	DeprecatedV1 *Filter_DeprecatedV1 `protobuf:"bytes,3,opt,name=deprecated_v1,json=deprecatedV1" json:"deprecated_v1,omitempty"`
}

func (m *Filter) Reset()                    { *m = Filter{} }
func (m *Filter) String() string            { return proto.CompactTextString(m) }
func (*Filter) ProtoMessage()               {}
func (*Filter) Descriptor() ([]byte, []int) { return fileDescriptorListener, []int{0} }

func (m *Filter) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Filter) GetConfig() *google_protobuf4.Struct {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *Filter) GetDeprecatedV1() *Filter_DeprecatedV1 {
	if m != nil {
		return m.DeprecatedV1
	}
	return nil
}

// [#not-implemented-hide:]
type Filter_DeprecatedV1 struct {
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
}

func (m *Filter_DeprecatedV1) Reset()                    { *m = Filter_DeprecatedV1{} }
func (m *Filter_DeprecatedV1) String() string            { return proto.CompactTextString(m) }
func (*Filter_DeprecatedV1) ProtoMessage()               {}
func (*Filter_DeprecatedV1) Descriptor() ([]byte, []int) { return fileDescriptorListener, []int{0, 0} }

func (m *Filter_DeprecatedV1) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

// Specifies the match criteria for selecting a specific filter chain for a
// listener.
type FilterChainMatch struct {
	// If non-empty, the SNI domains to consider. May contain a wildcard prefix,
	// e.g. ``*.example.com``.
	//
	// .. attention::
	//
	//   See the :ref:`FAQ entry <faq_how_to_setup_sni>` on how to configure SNI for more
	//   information.
	SniDomains []string `protobuf:"bytes,1,rep,name=sni_domains,json=sniDomains" json:"sni_domains,omitempty"`
	// If non-empty, an IP address and prefix length to match addresses when the
	// listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
	// [#not-implemented-hide:]
	PrefixRanges []*envoy_api_v2_core.CidrRange `protobuf:"bytes,3,rep,name=prefix_ranges,json=prefixRanges" json:"prefix_ranges,omitempty"`
	// If non-empty, an IP address and suffix length to match addresses when the
	// listener is bound to 0.0.0.0/:: or when use_original_dst is specified.
	// [#not-implemented-hide:]
	AddressSuffix string `protobuf:"bytes,4,opt,name=address_suffix,json=addressSuffix,proto3" json:"address_suffix,omitempty"`
	// [#not-implemented-hide:]
	SuffixLen *google_protobuf.UInt32Value `protobuf:"bytes,5,opt,name=suffix_len,json=suffixLen" json:"suffix_len,omitempty"`
	// The criteria is satisfied if the source IP address of the downstream
	// connection is contained in at least one of the specified subnets. If the
	// parameter is not specified or the list is empty, the source IP address is
	// ignored.
	// [#not-implemented-hide:]
	SourcePrefixRanges []*envoy_api_v2_core.CidrRange `protobuf:"bytes,6,rep,name=source_prefix_ranges,json=sourcePrefixRanges" json:"source_prefix_ranges,omitempty"`
	// The criteria is satisfied if the source port of the downstream connection
	// is contained in at least one of the specified ports. If the parameter is
	// not specified, the source port is ignored.
	// [#not-implemented-hide:]
	SourcePorts []*google_protobuf.UInt32Value `protobuf:"bytes,7,rep,name=source_ports,json=sourcePorts" json:"source_ports,omitempty"`
	// Optional destination port to consider when use_original_dst is set on the
	// listener in determining a filter chain match.
	// [#not-implemented-hide:]
	DestinationPort *google_protobuf.UInt32Value `protobuf:"bytes,8,opt,name=destination_port,json=destinationPort" json:"destination_port,omitempty"`
}

func (m *FilterChainMatch) Reset()                    { *m = FilterChainMatch{} }
func (m *FilterChainMatch) String() string            { return proto.CompactTextString(m) }
func (*FilterChainMatch) ProtoMessage()               {}
func (*FilterChainMatch) Descriptor() ([]byte, []int) { return fileDescriptorListener, []int{1} }

func (m *FilterChainMatch) GetSniDomains() []string {
	if m != nil {
		return m.SniDomains
	}
	return nil
}

func (m *FilterChainMatch) GetPrefixRanges() []*envoy_api_v2_core.CidrRange {
	if m != nil {
		return m.PrefixRanges
	}
	return nil
}

func (m *FilterChainMatch) GetAddressSuffix() string {
	if m != nil {
		return m.AddressSuffix
	}
	return ""
}

func (m *FilterChainMatch) GetSuffixLen() *google_protobuf.UInt32Value {
	if m != nil {
		return m.SuffixLen
	}
	return nil
}

func (m *FilterChainMatch) GetSourcePrefixRanges() []*envoy_api_v2_core.CidrRange {
	if m != nil {
		return m.SourcePrefixRanges
	}
	return nil
}

func (m *FilterChainMatch) GetSourcePorts() []*google_protobuf.UInt32Value {
	if m != nil {
		return m.SourcePorts
	}
	return nil
}

func (m *FilterChainMatch) GetDestinationPort() *google_protobuf.UInt32Value {
	if m != nil {
		return m.DestinationPort
	}
	return nil
}

// A filter chain wraps a set of match criteria, an option TLS context, a set of filters, and
// various other parameters.
type FilterChain struct {
	// The criteria to use when matching a connection to this filter chain.
	FilterChainMatch *FilterChainMatch `protobuf:"bytes,1,opt,name=filter_chain_match,json=filterChainMatch" json:"filter_chain_match,omitempty"`
	// The TLS context for this filter chain.
	TlsContext *envoy_api_v2_auth.DownstreamTlsContext `protobuf:"bytes,2,opt,name=tls_context,json=tlsContext" json:"tls_context,omitempty"`
	// A list of individual network filters that make up the filter chain for
	// connections established with the listener. Order matters as the filters are
	// processed sequentially as connection events happen. Note: If the filter
	// list is empty, the connection will close by default.
	Filters []Filter `protobuf:"bytes,3,rep,name=filters" json:"filters"`
	// Whether the listener should expect a PROXY protocol V1 header on new
	// connections. If this option is enabled, the listener will assume that that
	// remote address of the connection is the one specified in the header. Some
	// load balancers including the AWS ELB support this option. If the option is
	// absent or set to false, Envoy will use the physical peer address of the
	// connection as the remote address.
	UseProxyProto *google_protobuf.BoolValue `protobuf:"bytes,4,opt,name=use_proxy_proto,json=useProxyProto" json:"use_proxy_proto,omitempty"`
	// [#not-implemented-hide:] filter chain metadata.
	Metadata *envoy_api_v2_core1.Metadata `protobuf:"bytes,5,opt,name=metadata" json:"metadata,omitempty"`
	// See :ref:`base.TransportSocket<envoy_api_msg_core.TransportSocket>` description.
	TransportSocket *envoy_api_v2_core1.TransportSocket `protobuf:"bytes,6,opt,name=transport_socket,json=transportSocket" json:"transport_socket,omitempty"`
}

func (m *FilterChain) Reset()                    { *m = FilterChain{} }
func (m *FilterChain) String() string            { return proto.CompactTextString(m) }
func (*FilterChain) ProtoMessage()               {}
func (*FilterChain) Descriptor() ([]byte, []int) { return fileDescriptorListener, []int{2} }

func (m *FilterChain) GetFilterChainMatch() *FilterChainMatch {
	if m != nil {
		return m.FilterChainMatch
	}
	return nil
}

func (m *FilterChain) GetTlsContext() *envoy_api_v2_auth.DownstreamTlsContext {
	if m != nil {
		return m.TlsContext
	}
	return nil
}

func (m *FilterChain) GetFilters() []Filter {
	if m != nil {
		return m.Filters
	}
	return nil
}

func (m *FilterChain) GetUseProxyProto() *google_protobuf.BoolValue {
	if m != nil {
		return m.UseProxyProto
	}
	return nil
}

func (m *FilterChain) GetMetadata() *envoy_api_v2_core1.Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *FilterChain) GetTransportSocket() *envoy_api_v2_core1.TransportSocket {
	if m != nil {
		return m.TransportSocket
	}
	return nil
}

type ListenerFilter struct {
	// The name of the filter to instantiate. The name must match a supported
	// filter. The built-in filters are:
	//
	// [#comment:TODO(mattklein123): Auto generate the following list]
	// * :ref:`envoy.listener.original_dst <config_listener_filters_original_dst>`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Filter specific configuration which depends on the filter being
	// instantiated. See the supported filters for further documentation.
	Config *google_protobuf4.Struct `protobuf:"bytes,2,opt,name=config" json:"config,omitempty"`
}

func (m *ListenerFilter) Reset()                    { *m = ListenerFilter{} }
func (m *ListenerFilter) String() string            { return proto.CompactTextString(m) }
func (*ListenerFilter) ProtoMessage()               {}
func (*ListenerFilter) Descriptor() ([]byte, []int) { return fileDescriptorListener, []int{3} }

func (m *ListenerFilter) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ListenerFilter) GetConfig() *google_protobuf4.Struct {
	if m != nil {
		return m.Config
	}
	return nil
}

func init() {
	proto.RegisterType((*Filter)(nil), "envoy.api.v2.listener.Filter")
	proto.RegisterType((*Filter_DeprecatedV1)(nil), "envoy.api.v2.listener.Filter.DeprecatedV1")
	proto.RegisterType((*FilterChainMatch)(nil), "envoy.api.v2.listener.FilterChainMatch")
	proto.RegisterType((*FilterChain)(nil), "envoy.api.v2.listener.FilterChain")
	proto.RegisterType((*ListenerFilter)(nil), "envoy.api.v2.listener.ListenerFilter")
}
func (this *Filter) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Filter)
	if !ok {
		that2, ok := that.(Filter)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if !this.Config.Equal(that1.Config) {
		return false
	}
	if !this.DeprecatedV1.Equal(that1.DeprecatedV1) {
		return false
	}
	return true
}
func (this *Filter_DeprecatedV1) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Filter_DeprecatedV1)
	if !ok {
		that2, ok := that.(Filter_DeprecatedV1)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	return true
}
func (this *FilterChainMatch) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*FilterChainMatch)
	if !ok {
		that2, ok := that.(FilterChainMatch)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.SniDomains) != len(that1.SniDomains) {
		return false
	}
	for i := range this.SniDomains {
		if this.SniDomains[i] != that1.SniDomains[i] {
			return false
		}
	}
	if len(this.PrefixRanges) != len(that1.PrefixRanges) {
		return false
	}
	for i := range this.PrefixRanges {
		if !this.PrefixRanges[i].Equal(that1.PrefixRanges[i]) {
			return false
		}
	}
	if this.AddressSuffix != that1.AddressSuffix {
		return false
	}
	if !this.SuffixLen.Equal(that1.SuffixLen) {
		return false
	}
	if len(this.SourcePrefixRanges) != len(that1.SourcePrefixRanges) {
		return false
	}
	for i := range this.SourcePrefixRanges {
		if !this.SourcePrefixRanges[i].Equal(that1.SourcePrefixRanges[i]) {
			return false
		}
	}
	if len(this.SourcePorts) != len(that1.SourcePorts) {
		return false
	}
	for i := range this.SourcePorts {
		if !this.SourcePorts[i].Equal(that1.SourcePorts[i]) {
			return false
		}
	}
	if !this.DestinationPort.Equal(that1.DestinationPort) {
		return false
	}
	return true
}
func (this *FilterChain) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*FilterChain)
	if !ok {
		that2, ok := that.(FilterChain)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.FilterChainMatch.Equal(that1.FilterChainMatch) {
		return false
	}
	if !this.TlsContext.Equal(that1.TlsContext) {
		return false
	}
	if len(this.Filters) != len(that1.Filters) {
		return false
	}
	for i := range this.Filters {
		if !this.Filters[i].Equal(&that1.Filters[i]) {
			return false
		}
	}
	if !this.UseProxyProto.Equal(that1.UseProxyProto) {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if !this.TransportSocket.Equal(that1.TransportSocket) {
		return false
	}
	return true
}
func (this *ListenerFilter) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ListenerFilter)
	if !ok {
		that2, ok := that.(ListenerFilter)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if !this.Config.Equal(that1.Config) {
		return false
	}
	return true
}
func (m *Filter) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Filter) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintListener(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.Config != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintListener(dAtA, i, uint64(m.Config.Size()))
		n1, err := m.Config.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.DeprecatedV1 != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintListener(dAtA, i, uint64(m.DeprecatedV1.Size()))
		n2, err := m.DeprecatedV1.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	return i, nil
}

func (m *Filter_DeprecatedV1) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Filter_DeprecatedV1) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Type) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintListener(dAtA, i, uint64(len(m.Type)))
		i += copy(dAtA[i:], m.Type)
	}
	return i, nil
}

func (m *FilterChainMatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FilterChainMatch) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.SniDomains) > 0 {
		for _, s := range m.SniDomains {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.PrefixRanges) > 0 {
		for _, msg := range m.PrefixRanges {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintListener(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.AddressSuffix) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintListener(dAtA, i, uint64(len(m.AddressSuffix)))
		i += copy(dAtA[i:], m.AddressSuffix)
	}
	if m.SuffixLen != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintListener(dAtA, i, uint64(m.SuffixLen.Size()))
		n3, err := m.SuffixLen.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if len(m.SourcePrefixRanges) > 0 {
		for _, msg := range m.SourcePrefixRanges {
			dAtA[i] = 0x32
			i++
			i = encodeVarintListener(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.SourcePorts) > 0 {
		for _, msg := range m.SourcePorts {
			dAtA[i] = 0x3a
			i++
			i = encodeVarintListener(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.DestinationPort != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintListener(dAtA, i, uint64(m.DestinationPort.Size()))
		n4, err := m.DestinationPort.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	return i, nil
}

func (m *FilterChain) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FilterChain) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.FilterChainMatch != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintListener(dAtA, i, uint64(m.FilterChainMatch.Size()))
		n5, err := m.FilterChainMatch.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.TlsContext != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintListener(dAtA, i, uint64(m.TlsContext.Size()))
		n6, err := m.TlsContext.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if len(m.Filters) > 0 {
		for _, msg := range m.Filters {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintListener(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.UseProxyProto != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintListener(dAtA, i, uint64(m.UseProxyProto.Size()))
		n7, err := m.UseProxyProto.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.Metadata != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintListener(dAtA, i, uint64(m.Metadata.Size()))
		n8, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.TransportSocket != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintListener(dAtA, i, uint64(m.TransportSocket.Size()))
		n9, err := m.TransportSocket.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	return i, nil
}

func (m *ListenerFilter) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListenerFilter) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintListener(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.Config != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintListener(dAtA, i, uint64(m.Config.Size()))
		n10, err := m.Config.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	return i, nil
}

func encodeVarintListener(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Filter) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovListener(uint64(l))
	}
	if m.Config != nil {
		l = m.Config.Size()
		n += 1 + l + sovListener(uint64(l))
	}
	if m.DeprecatedV1 != nil {
		l = m.DeprecatedV1.Size()
		n += 1 + l + sovListener(uint64(l))
	}
	return n
}

func (m *Filter_DeprecatedV1) Size() (n int) {
	var l int
	_ = l
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovListener(uint64(l))
	}
	return n
}

func (m *FilterChainMatch) Size() (n int) {
	var l int
	_ = l
	if len(m.SniDomains) > 0 {
		for _, s := range m.SniDomains {
			l = len(s)
			n += 1 + l + sovListener(uint64(l))
		}
	}
	if len(m.PrefixRanges) > 0 {
		for _, e := range m.PrefixRanges {
			l = e.Size()
			n += 1 + l + sovListener(uint64(l))
		}
	}
	l = len(m.AddressSuffix)
	if l > 0 {
		n += 1 + l + sovListener(uint64(l))
	}
	if m.SuffixLen != nil {
		l = m.SuffixLen.Size()
		n += 1 + l + sovListener(uint64(l))
	}
	if len(m.SourcePrefixRanges) > 0 {
		for _, e := range m.SourcePrefixRanges {
			l = e.Size()
			n += 1 + l + sovListener(uint64(l))
		}
	}
	if len(m.SourcePorts) > 0 {
		for _, e := range m.SourcePorts {
			l = e.Size()
			n += 1 + l + sovListener(uint64(l))
		}
	}
	if m.DestinationPort != nil {
		l = m.DestinationPort.Size()
		n += 1 + l + sovListener(uint64(l))
	}
	return n
}

func (m *FilterChain) Size() (n int) {
	var l int
	_ = l
	if m.FilterChainMatch != nil {
		l = m.FilterChainMatch.Size()
		n += 1 + l + sovListener(uint64(l))
	}
	if m.TlsContext != nil {
		l = m.TlsContext.Size()
		n += 1 + l + sovListener(uint64(l))
	}
	if len(m.Filters) > 0 {
		for _, e := range m.Filters {
			l = e.Size()
			n += 1 + l + sovListener(uint64(l))
		}
	}
	if m.UseProxyProto != nil {
		l = m.UseProxyProto.Size()
		n += 1 + l + sovListener(uint64(l))
	}
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovListener(uint64(l))
	}
	if m.TransportSocket != nil {
		l = m.TransportSocket.Size()
		n += 1 + l + sovListener(uint64(l))
	}
	return n
}

func (m *ListenerFilter) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovListener(uint64(l))
	}
	if m.Config != nil {
		l = m.Config.Size()
		n += 1 + l + sovListener(uint64(l))
	}
	return n
}

func sovListener(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozListener(x uint64) (n int) {
	return sovListener(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Filter) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowListener
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Filter: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Filter: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowListener
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthListener
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Config", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowListener
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthListener
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Config == nil {
				m.Config = &google_protobuf4.Struct{}
			}
			if err := m.Config.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeprecatedV1", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowListener
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthListener
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeprecatedV1 == nil {
				m.DeprecatedV1 = &Filter_DeprecatedV1{}
			}
			if err := m.DeprecatedV1.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipListener(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthListener
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Filter_DeprecatedV1) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowListener
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeprecatedV1: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeprecatedV1: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowListener
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthListener
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipListener(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthListener
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FilterChainMatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowListener
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FilterChainMatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FilterChainMatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SniDomains", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowListener
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthListener
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SniDomains = append(m.SniDomains, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrefixRanges", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowListener
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthListener
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PrefixRanges = append(m.PrefixRanges, &envoy_api_v2_core.CidrRange{})
			if err := m.PrefixRanges[len(m.PrefixRanges)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AddressSuffix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowListener
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthListener
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AddressSuffix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SuffixLen", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowListener
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthListener
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SuffixLen == nil {
				m.SuffixLen = &google_protobuf.UInt32Value{}
			}
			if err := m.SuffixLen.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourcePrefixRanges", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowListener
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthListener
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourcePrefixRanges = append(m.SourcePrefixRanges, &envoy_api_v2_core.CidrRange{})
			if err := m.SourcePrefixRanges[len(m.SourcePrefixRanges)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourcePorts", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowListener
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthListener
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourcePorts = append(m.SourcePorts, &google_protobuf.UInt32Value{})
			if err := m.SourcePorts[len(m.SourcePorts)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationPort", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowListener
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthListener
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DestinationPort == nil {
				m.DestinationPort = &google_protobuf.UInt32Value{}
			}
			if err := m.DestinationPort.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipListener(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthListener
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FilterChain) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowListener
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FilterChain: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FilterChain: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FilterChainMatch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowListener
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthListener
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FilterChainMatch == nil {
				m.FilterChainMatch = &FilterChainMatch{}
			}
			if err := m.FilterChainMatch.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TlsContext", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowListener
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthListener
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TlsContext == nil {
				m.TlsContext = &envoy_api_v2_auth.DownstreamTlsContext{}
			}
			if err := m.TlsContext.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Filters", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowListener
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthListener
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Filters = append(m.Filters, Filter{})
			if err := m.Filters[len(m.Filters)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UseProxyProto", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowListener
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthListener
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UseProxyProto == nil {
				m.UseProxyProto = &google_protobuf.BoolValue{}
			}
			if err := m.UseProxyProto.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowListener
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthListener
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &envoy_api_v2_core1.Metadata{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TransportSocket", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowListener
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthListener
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TransportSocket == nil {
				m.TransportSocket = &envoy_api_v2_core1.TransportSocket{}
			}
			if err := m.TransportSocket.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipListener(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthListener
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListenerFilter) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowListener
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListenerFilter: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListenerFilter: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowListener
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthListener
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Config", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowListener
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthListener
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Config == nil {
				m.Config = &google_protobuf4.Struct{}
			}
			if err := m.Config.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipListener(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthListener
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipListener(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowListener
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowListener
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowListener
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthListener
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowListener
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipListener(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthListener = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowListener   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("envoy/api/v2/listener/listener.proto", fileDescriptorListener) }

var fileDescriptorListener = []byte{
	// 696 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x54, 0xcb, 0x6e, 0xd3, 0x40,
	0x14, 0xc5, 0x4d, 0x48, 0x9b, 0x71, 0xd2, 0x46, 0xa3, 0xa2, 0x5a, 0xa1, 0x4d, 0xa3, 0x08, 0x44,
	0xc4, 0xc2, 0x56, 0xd3, 0x05, 0x0b, 0x84, 0x10, 0x69, 0xc5, 0x43, 0x6a, 0x51, 0xe5, 0xb4, 0x5d,
	0xb0, 0x31, 0x53, 0xfb, 0x26, 0x1d, 0xe1, 0xcc, 0x58, 0x33, 0xe3, 0x34, 0xfd, 0x23, 0x3e, 0x80,
	0x0d, 0xac, 0x58, 0x76, 0x09, 0x3f, 0x80, 0x50, 0x76, 0xfc, 0x05, 0xf2, 0xd8, 0x0e, 0x49, 0x1b,
	0x55, 0xdd, 0xb0, 0xbb, 0x8f, 0x73, 0x4e, 0x8e, 0xef, 0xbd, 0x19, 0xf4, 0x08, 0xd8, 0x88, 0x5f,
	0x3a, 0x24, 0xa2, 0xce, 0xa8, 0xe3, 0x84, 0x54, 0x2a, 0x60, 0x20, 0xa6, 0x81, 0x1d, 0x09, 0xae,
	0x38, 0x7e, 0xa0, 0x51, 0x36, 0x89, 0xa8, 0x3d, 0xea, 0xd8, 0x79, 0xb3, 0xbe, 0x3d, 0x47, 0xf6,
	0xb9, 0x00, 0x87, 0x04, 0x81, 0x00, 0x29, 0x53, 0x5e, 0x7d, 0x73, 0x0e, 0x40, 0x62, 0x75, 0xee,
	0xf8, 0x20, 0xd4, 0xc2, 0xae, 0xa6, 0x9f, 0x11, 0x09, 0x79, 0x77, 0xc0, 0xf9, 0x20, 0x04, 0x47,
	0x67, 0x67, 0x71, 0xdf, 0x91, 0x4a, 0xc4, 0x7e, 0xce, 0x6d, 0x5c, 0xef, 0x5e, 0x08, 0x12, 0x45,
	0x20, 0xf2, 0x5f, 0xde, 0x18, 0x91, 0x90, 0x06, 0x44, 0x81, 0x93, 0x07, 0x59, 0x63, 0x7d, 0xc0,
	0x07, 0x5c, 0x87, 0x4e, 0x12, 0xa5, 0xd5, 0xd6, 0x4f, 0x03, 0x95, 0x5e, 0xd3, 0x50, 0x81, 0xc0,
	0x5b, 0xa8, 0xc8, 0xc8, 0x10, 0x2c, 0xa3, 0x69, 0xb4, 0xcb, 0xdd, 0xf2, 0xb7, 0x3f, 0xdf, 0x0b,
	0x45, 0xb1, 0xd4, 0x34, 0x5c, 0x5d, 0xc6, 0x0e, 0x2a, 0xf9, 0x9c, 0xf5, 0xe9, 0xc0, 0x5a, 0x6a,
	0x1a, 0x6d, 0xb3, 0xb3, 0x61, 0xa7, 0x4e, 0xec, 0xdc, 0x89, 0xdd, 0xd3, 0x3e, 0xdd, 0x0c, 0x86,
	0x7b, 0xa8, 0x1a, 0x40, 0x24, 0xc0, 0x27, 0x0a, 0x02, 0x6f, 0xb4, 0x63, 0x15, 0x34, 0xef, 0xa9,
	0xbd, 0x70, 0xa6, 0x76, 0xea, 0xc2, 0xde, 0x9f, 0x52, 0x4e, 0x77, 0xba, 0x4b, 0x96, 0xe1, 0x56,
	0x82, 0x99, 0x4a, 0xbd, 0x85, 0x2a, 0xb3, 0x08, 0x8c, 0x51, 0x51, 0x5d, 0x46, 0x99, 0x69, 0x57,
	0xc7, 0xad, 0x2f, 0x05, 0x54, 0x4b, 0xd5, 0xf6, 0xce, 0x09, 0x65, 0x87, 0x44, 0xf9, 0xe7, 0x78,
	0x1b, 0x99, 0x92, 0x51, 0x2f, 0xe0, 0x43, 0x42, 0x99, 0xb4, 0x8c, 0x66, 0xa1, 0x5d, 0x76, 0x91,
	0x64, 0x74, 0x3f, 0xad, 0xe0, 0x57, 0xa8, 0x1a, 0x09, 0xe8, 0xd3, 0xb1, 0x27, 0x08, 0x1b, 0x80,
	0xb4, 0x0a, 0xcd, 0x42, 0xdb, 0xec, 0x6c, 0xce, 0xdb, 0x4d, 0x96, 0x65, 0xef, 0xd1, 0x40, 0xb8,
	0x09, 0xc8, 0xad, 0xa4, 0x14, 0x9d, 0x48, 0xfc, 0x18, 0xad, 0x66, 0x67, 0xe0, 0xc9, 0xb8, 0xdf,
	0xa7, 0x63, 0xab, 0xa8, 0x6d, 0x55, 0xb3, 0x6a, 0x4f, 0x17, 0xf1, 0x73, 0x84, 0xd2, 0xb6, 0x17,
	0x02, 0xb3, 0xee, 0xeb, 0xa9, 0x6c, 0xde, 0x98, 0xe6, 0xc9, 0x3b, 0xa6, 0x76, 0x3b, 0xa7, 0x24,
	0x8c, 0xc1, 0x2d, 0xa7, 0xf8, 0x03, 0x60, 0xf8, 0x3d, 0x5a, 0x97, 0x3c, 0x16, 0x3e, 0x78, 0xf3,
	0x6e, 0x4b, 0x77, 0x70, 0x8b, 0x53, 0xe6, 0xd1, 0xac, 0xe7, 0x97, 0xa8, 0x92, 0xeb, 0x71, 0xa1,
	0xa4, 0xb5, 0x9c, 0xe9, 0xdc, 0x66, 0xc7, 0xcc, 0x74, 0x12, 0x02, 0x7e, 0x83, 0x6a, 0x01, 0x48,
	0x45, 0x19, 0x51, 0x94, 0x33, 0xad, 0x62, 0xad, 0xdc, 0xe1, 0x9b, 0xd6, 0x66, 0x58, 0x89, 0x52,
	0xeb, 0x6b, 0x01, 0x99, 0x33, 0x6b, 0xc3, 0x27, 0x08, 0xf7, 0x75, 0xea, 0xf9, 0x49, 0xee, 0x0d,
	0x93, 0x3d, 0xea, 0x45, 0x9b, 0x9d, 0x27, 0xb7, 0x1e, 0xd1, 0xbf, 0xb5, 0xbb, 0xb5, 0xfe, 0xf5,
	0x43, 0x78, 0x8b, 0x4c, 0x15, 0x4a, 0xcf, 0xe7, 0x4c, 0xc1, 0x58, 0x65, 0xc7, 0x7c, 0x4d, 0x2f,
	0xf9, 0xc3, 0xda, 0xfb, 0xfc, 0x82, 0x49, 0x25, 0x80, 0x0c, 0x8f, 0x43, 0xb9, 0x97, 0xc2, 0x5d,
	0xa4, 0xa6, 0x31, 0x7e, 0x81, 0x96, 0x53, 0xf5, 0xfc, 0x56, 0xb6, 0x6e, 0x75, 0xd5, 0x2d, 0x5e,
	0xfd, 0xda, 0xbe, 0xe7, 0xe6, 0x1c, 0xdc, 0x45, 0x6b, 0xb1, 0x4c, 0xd6, 0xc8, 0xc7, 0x97, 0x9e,
	0x1e, 0x91, 0x3e, 0x17, 0xb3, 0x53, 0xbf, 0x31, 0xb7, 0x2e, 0xe7, 0x61, 0x3a, 0xb5, 0x6a, 0x2c,
	0xe1, 0x28, 0x61, 0x1c, 0xe9, 0xf7, 0xe9, 0x19, 0x5a, 0x19, 0x82, 0x22, 0x01, 0x51, 0x24, 0x3b,
	0xa4, 0x87, 0x0b, 0x2e, 0xe0, 0x30, 0x83, 0xb8, 0x53, 0x30, 0x3e, 0x44, 0x35, 0x25, 0x08, 0x93,
	0xc9, 0xba, 0x3c, 0xc9, 0xfd, 0x4f, 0xa0, 0xac, 0x92, 0x16, 0x68, 0x2d, 0x10, 0x38, 0xce, 0xa1,
	0x3d, 0x8d, 0x74, 0xd7, 0xd4, 0x7c, 0xa1, 0xf5, 0x11, 0xad, 0x1e, 0x64, 0x5f, 0xfb, 0x7f, 0x5e,
	0x93, 0x6e, 0xfd, 0xf3, 0xa4, 0x61, 0x5c, 0x4d, 0x1a, 0xc6, 0x8f, 0x49, 0xc3, 0xf8, 0x3d, 0x69,
	0x18, 0x1f, 0x56, 0xf2, 0xf9, 0x9e, 0x95, 0x34, 0x69, 0xf7, 0x6f, 0x00, 0x00, 0x00, 0xff, 0xff,
	0x25, 0xa1, 0xac, 0xc1, 0xd4, 0x05, 0x00, 0x00,
}
