// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: envoy/api/v2/core/base.proto

package core

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf4 "github.com/gogo/protobuf/types"
import google_protobuf "github.com/gogo/protobuf/types"
import _ "github.com/lyft/protoc-gen-validate/validate"
import _ "github.com/gogo/protobuf/gogoproto"

import bytes "bytes"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Envoy supports :ref:`upstream priority routing
// <arch_overview_http_routing_priority>` both at the route and the virtual
// cluster level. The current priority implementation uses different connection
// pool and circuit breaking settings for each priority level. This means that
// even for HTTP/2 requests, two physical connections will be used to an
// upstream host. In the future Envoy will likely support true HTTP/2 priority
// over a single upstream connection.
type RoutingPriority int32

const (
	RoutingPriority_DEFAULT RoutingPriority = 0
	RoutingPriority_HIGH    RoutingPriority = 1
)

var RoutingPriority_name = map[int32]string{
	0: "DEFAULT",
	1: "HIGH",
}
var RoutingPriority_value = map[string]int32{
	"DEFAULT": 0,
	"HIGH":    1,
}

func (x RoutingPriority) String() string {
	return proto.EnumName(RoutingPriority_name, int32(x))
}
func (RoutingPriority) EnumDescriptor() ([]byte, []int) { return fileDescriptorBase, []int{0} }

// HTTP request method.
type RequestMethod int32

const (
	METHOD_UNSPECIFIED RequestMethod = 0
	GET                RequestMethod = 1
	HEAD               RequestMethod = 2
	POST               RequestMethod = 3
	PUT                RequestMethod = 4
	DELETE             RequestMethod = 5
	CONNECT            RequestMethod = 6
	OPTIONS            RequestMethod = 7
	TRACE              RequestMethod = 8
)

var RequestMethod_name = map[int32]string{
	0: "METHOD_UNSPECIFIED",
	1: "GET",
	2: "HEAD",
	3: "POST",
	4: "PUT",
	5: "DELETE",
	6: "CONNECT",
	7: "OPTIONS",
	8: "TRACE",
}
var RequestMethod_value = map[string]int32{
	"METHOD_UNSPECIFIED": 0,
	"GET":                1,
	"HEAD":               2,
	"POST":               3,
	"PUT":                4,
	"DELETE":             5,
	"CONNECT":            6,
	"OPTIONS":            7,
	"TRACE":              8,
}

func (x RequestMethod) String() string {
	return proto.EnumName(RequestMethod_name, int32(x))
}
func (RequestMethod) EnumDescriptor() ([]byte, []int) { return fileDescriptorBase, []int{1} }

// Identifies location of where either Envoy runs or where upstream hosts run.
type Locality struct {
	// Region this :ref:`zone <envoy_api_field_core.Locality.zone>` belongs to.
	Region string `protobuf:"bytes,1,opt,name=region,proto3" json:"region,omitempty"`
	// Defines the local service zone where Envoy is running. Though optional, it
	// should be set if discovery service routing is used and the discovery
	// service exposes :ref:`zone data <config_cluster_manager_sds_api_host_az>`,
	// either in this message or via :option:`--service-zone`. The meaning of zone
	// is context dependent, e.g. `Availability Zone (AZ)
	// <https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html>`_
	// on AWS, `Zone <https://cloud.google.com/compute/docs/regions-zones/>`_ on
	// GCP, etc.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// When used for locality of upstream hosts, this field further splits zone
	// into smaller chunks of sub-zones so they can be load balanced
	// independently.
	SubZone string `protobuf:"bytes,3,opt,name=sub_zone,json=subZone,proto3" json:"sub_zone,omitempty"`
}

func (m *Locality) Reset()                    { *m = Locality{} }
func (m *Locality) String() string            { return proto.CompactTextString(m) }
func (*Locality) ProtoMessage()               {}
func (*Locality) Descriptor() ([]byte, []int) { return fileDescriptorBase, []int{0} }

func (m *Locality) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *Locality) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *Locality) GetSubZone() string {
	if m != nil {
		return m.SubZone
	}
	return ""
}

// Identifies a specific Envoy instance. The node identifier is presented to the
// management server, which may use this identifier to distinguish per Envoy
// configuration for serving.
type Node struct {
	// An opaque node identifier for the Envoy node. This also provides the local
	// service node name. It should be set if any of the following features are
	// used: :ref:`statsd <arch_overview_statistics>`, :ref:`CDS
	// <config_cluster_manager_cds>`, and :ref:`HTTP tracing
	// <arch_overview_tracing>`, either in this message or via
	// :option:`--service-node`.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Defines the local service cluster name where Envoy is running. Though
	// optional, it should be set if any of the following features are used:
	// :ref:`statsd <arch_overview_statistics>`, :ref:`health check cluster
	// verification <config_cluster_manager_cluster_hc_service_name>`,
	// :ref:`runtime override directory <config_runtime_override_subdirectory>`,
	// :ref:`user agent addition <config_http_conn_man_add_user_agent>`,
	// :ref:`HTTP global rate limiting <config_http_filters_rate_limit>`,
	// :ref:`CDS <config_cluster_manager_cds>`, and :ref:`HTTP tracing
	// <arch_overview_tracing>`, either in this message or via
	// :option:`--service-cluster`.
	Cluster string `protobuf:"bytes,2,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// Opaque metadata extending the node identifier. Envoy will pass this
	// directly to the management server.
	Metadata *google_protobuf4.Struct `protobuf:"bytes,3,opt,name=metadata" json:"metadata,omitempty"`
	// Locality specifying where the Envoy instance is running.
	Locality *Locality `protobuf:"bytes,4,opt,name=locality" json:"locality,omitempty"`
	// This is motivated by informing a management server during canary which
	// version of Envoy is being tested in a heterogeneous fleet. This will be set
	// by Envoy in management server RPCs.
	BuildVersion string `protobuf:"bytes,5,opt,name=build_version,json=buildVersion,proto3" json:"build_version,omitempty"`
}

func (m *Node) Reset()                    { *m = Node{} }
func (m *Node) String() string            { return proto.CompactTextString(m) }
func (*Node) ProtoMessage()               {}
func (*Node) Descriptor() ([]byte, []int) { return fileDescriptorBase, []int{1} }

func (m *Node) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Node) GetCluster() string {
	if m != nil {
		return m.Cluster
	}
	return ""
}

func (m *Node) GetMetadata() *google_protobuf4.Struct {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Node) GetLocality() *Locality {
	if m != nil {
		return m.Locality
	}
	return nil
}

func (m *Node) GetBuildVersion() string {
	if m != nil {
		return m.BuildVersion
	}
	return ""
}

// Metadata provides additional inputs to filters based on matched listeners,
// filter chains, routes and endpoints. It is structured as a map from filter
// name (in reverse DNS format) to metadata specific to the filter. Metadata
// key-values for a filter are merged as connection and request handling occurs,
// with later values for the same key overriding earlier values.
//
// An example use of metadata is providing additional values to
// http_connection_manager in the envoy.http_connection_manager.access_log
// namespace.
//
// For load balancing, Metadata provides a means to subset cluster endpoints.
// Endpoints have a Metadata object associated and routes contain a Metadata
// object to match against. There are some well defined metadata used today for
// this purpose:
//
// * ``{"envoy.lb": {"canary": <bool> }}`` This indicates the canary status of an
//   endpoint and is also used during header processing
//   (x-envoy-upstream-canary) and for stats purposes.
type Metadata struct {
	// Key is the reverse DNS filter name, e.g. com.acme.widget. The envoy.*
	// namespace is reserved for Envoy's built-in filters.
	FilterMetadata map[string]*google_protobuf4.Struct `protobuf:"bytes,1,rep,name=filter_metadata,json=filterMetadata" json:"filter_metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *Metadata) Reset()                    { *m = Metadata{} }
func (m *Metadata) String() string            { return proto.CompactTextString(m) }
func (*Metadata) ProtoMessage()               {}
func (*Metadata) Descriptor() ([]byte, []int) { return fileDescriptorBase, []int{2} }

func (m *Metadata) GetFilterMetadata() map[string]*google_protobuf4.Struct {
	if m != nil {
		return m.FilterMetadata
	}
	return nil
}

// Runtime derived uint32 with a default when not specified.
type RuntimeUInt32 struct {
	// Default value if runtime value is not available.
	DefaultValue uint32 `protobuf:"varint,2,opt,name=default_value,json=defaultValue,proto3" json:"default_value,omitempty"`
	// Runtime key to get value for comparison. This value is used if defined.
	RuntimeKey string `protobuf:"bytes,3,opt,name=runtime_key,json=runtimeKey,proto3" json:"runtime_key,omitempty"`
}

func (m *RuntimeUInt32) Reset()                    { *m = RuntimeUInt32{} }
func (m *RuntimeUInt32) String() string            { return proto.CompactTextString(m) }
func (*RuntimeUInt32) ProtoMessage()               {}
func (*RuntimeUInt32) Descriptor() ([]byte, []int) { return fileDescriptorBase, []int{3} }

func (m *RuntimeUInt32) GetDefaultValue() uint32 {
	if m != nil {
		return m.DefaultValue
	}
	return 0
}

func (m *RuntimeUInt32) GetRuntimeKey() string {
	if m != nil {
		return m.RuntimeKey
	}
	return ""
}

// Header name/value pair.
type HeaderValue struct {
	// Header name.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Header value.
	//
	// The same :ref:`format specifier <config_access_log_format>` as used for
	// :ref:`HTTP access logging <config_access_log>` applies here, however
	// unknown header values are replaced with the empty string instead of `-`.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *HeaderValue) Reset()                    { *m = HeaderValue{} }
func (m *HeaderValue) String() string            { return proto.CompactTextString(m) }
func (*HeaderValue) ProtoMessage()               {}
func (*HeaderValue) Descriptor() ([]byte, []int) { return fileDescriptorBase, []int{4} }

func (m *HeaderValue) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *HeaderValue) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// Header name/value pair plus option to control append behavior.
type HeaderValueOption struct {
	// Header name/value pair that this option applies to.
	Header *HeaderValue `protobuf:"bytes,1,opt,name=header" json:"header,omitempty"`
	// Should the value be appended? If true (default), the value is appended to
	// existing values.
	Append *google_protobuf.BoolValue `protobuf:"bytes,2,opt,name=append" json:"append,omitempty"`
}

func (m *HeaderValueOption) Reset()                    { *m = HeaderValueOption{} }
func (m *HeaderValueOption) String() string            { return proto.CompactTextString(m) }
func (*HeaderValueOption) ProtoMessage()               {}
func (*HeaderValueOption) Descriptor() ([]byte, []int) { return fileDescriptorBase, []int{5} }

func (m *HeaderValueOption) GetHeader() *HeaderValue {
	if m != nil {
		return m.Header
	}
	return nil
}

func (m *HeaderValueOption) GetAppend() *google_protobuf.BoolValue {
	if m != nil {
		return m.Append
	}
	return nil
}

// Data source consisting of either a file or an inline value.
type DataSource struct {
	// Types that are valid to be assigned to Specifier:
	//	*DataSource_Filename
	//	*DataSource_InlineBytes
	//	*DataSource_InlineString
	Specifier isDataSource_Specifier `protobuf_oneof:"specifier"`
}

func (m *DataSource) Reset()                    { *m = DataSource{} }
func (m *DataSource) String() string            { return proto.CompactTextString(m) }
func (*DataSource) ProtoMessage()               {}
func (*DataSource) Descriptor() ([]byte, []int) { return fileDescriptorBase, []int{6} }

type isDataSource_Specifier interface {
	isDataSource_Specifier()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type DataSource_Filename struct {
	Filename string `protobuf:"bytes,1,opt,name=filename,proto3,oneof"`
}
type DataSource_InlineBytes struct {
	InlineBytes []byte `protobuf:"bytes,2,opt,name=inline_bytes,json=inlineBytes,proto3,oneof"`
}
type DataSource_InlineString struct {
	InlineString string `protobuf:"bytes,3,opt,name=inline_string,json=inlineString,proto3,oneof"`
}

func (*DataSource_Filename) isDataSource_Specifier()     {}
func (*DataSource_InlineBytes) isDataSource_Specifier()  {}
func (*DataSource_InlineString) isDataSource_Specifier() {}

func (m *DataSource) GetSpecifier() isDataSource_Specifier {
	if m != nil {
		return m.Specifier
	}
	return nil
}

func (m *DataSource) GetFilename() string {
	if x, ok := m.GetSpecifier().(*DataSource_Filename); ok {
		return x.Filename
	}
	return ""
}

func (m *DataSource) GetInlineBytes() []byte {
	if x, ok := m.GetSpecifier().(*DataSource_InlineBytes); ok {
		return x.InlineBytes
	}
	return nil
}

func (m *DataSource) GetInlineString() string {
	if x, ok := m.GetSpecifier().(*DataSource_InlineString); ok {
		return x.InlineString
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*DataSource) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _DataSource_OneofMarshaler, _DataSource_OneofUnmarshaler, _DataSource_OneofSizer, []interface{}{
		(*DataSource_Filename)(nil),
		(*DataSource_InlineBytes)(nil),
		(*DataSource_InlineString)(nil),
	}
}

func _DataSource_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*DataSource)
	// specifier
	switch x := m.Specifier.(type) {
	case *DataSource_Filename:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Filename)
	case *DataSource_InlineBytes:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		_ = b.EncodeRawBytes(x.InlineBytes)
	case *DataSource_InlineString:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.InlineString)
	case nil:
	default:
		return fmt.Errorf("DataSource.Specifier has unexpected type %T", x)
	}
	return nil
}

func _DataSource_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*DataSource)
	switch tag {
	case 1: // specifier.filename
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Specifier = &DataSource_Filename{x}
		return true, err
	case 2: // specifier.inline_bytes
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Specifier = &DataSource_InlineBytes{x}
		return true, err
	case 3: // specifier.inline_string
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Specifier = &DataSource_InlineString{x}
		return true, err
	default:
		return false, nil
	}
}

func _DataSource_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*DataSource)
	// specifier
	switch x := m.Specifier.(type) {
	case *DataSource_Filename:
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Filename)))
		n += len(x.Filename)
	case *DataSource_InlineBytes:
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.InlineBytes)))
		n += len(x.InlineBytes)
	case *DataSource_InlineString:
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.InlineString)))
		n += len(x.InlineString)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Configuration for transport socket in :ref:`listeners <config_listeners>` and
// :ref:`clusters <config_cluster_manager_cluster>`. If the configuration is
// empty, a default transport socket implementation and configuration will be
// chosen based on the platform and existence of tls_context.
type TransportSocket struct {
	// The name of the transport socket to instantiate. The name must match a supported transport
	// socket implementation.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Implementation specific configuration which depends on the implementation being instantiated.
	// See the supported transport socket implementations for further documentation.
	Config *google_protobuf4.Struct `protobuf:"bytes,2,opt,name=config" json:"config,omitempty"`
}

func (m *TransportSocket) Reset()                    { *m = TransportSocket{} }
func (m *TransportSocket) String() string            { return proto.CompactTextString(m) }
func (*TransportSocket) ProtoMessage()               {}
func (*TransportSocket) Descriptor() ([]byte, []int) { return fileDescriptorBase, []int{7} }

func (m *TransportSocket) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *TransportSocket) GetConfig() *google_protobuf4.Struct {
	if m != nil {
		return m.Config
	}
	return nil
}

func init() {
	proto.RegisterType((*Locality)(nil), "envoy.api.v2.core.Locality")
	proto.RegisterType((*Node)(nil), "envoy.api.v2.core.Node")
	proto.RegisterType((*Metadata)(nil), "envoy.api.v2.core.Metadata")
	proto.RegisterType((*RuntimeUInt32)(nil), "envoy.api.v2.core.RuntimeUInt32")
	proto.RegisterType((*HeaderValue)(nil), "envoy.api.v2.core.HeaderValue")
	proto.RegisterType((*HeaderValueOption)(nil), "envoy.api.v2.core.HeaderValueOption")
	proto.RegisterType((*DataSource)(nil), "envoy.api.v2.core.DataSource")
	proto.RegisterType((*TransportSocket)(nil), "envoy.api.v2.core.TransportSocket")
	proto.RegisterEnum("envoy.api.v2.core.RoutingPriority", RoutingPriority_name, RoutingPriority_value)
	proto.RegisterEnum("envoy.api.v2.core.RequestMethod", RequestMethod_name, RequestMethod_value)
}
func (this *Locality) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Locality)
	if !ok {
		that2, ok := that.(Locality)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Region != that1.Region {
		return false
	}
	if this.Zone != that1.Zone {
		return false
	}
	if this.SubZone != that1.SubZone {
		return false
	}
	return true
}
func (this *Node) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Node)
	if !ok {
		that2, ok := that.(Node)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Id != that1.Id {
		return false
	}
	if this.Cluster != that1.Cluster {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if !this.Locality.Equal(that1.Locality) {
		return false
	}
	if this.BuildVersion != that1.BuildVersion {
		return false
	}
	return true
}
func (this *Metadata) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Metadata)
	if !ok {
		that2, ok := that.(Metadata)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.FilterMetadata) != len(that1.FilterMetadata) {
		return false
	}
	for i := range this.FilterMetadata {
		if !this.FilterMetadata[i].Equal(that1.FilterMetadata[i]) {
			return false
		}
	}
	return true
}
func (this *RuntimeUInt32) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RuntimeUInt32)
	if !ok {
		that2, ok := that.(RuntimeUInt32)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.DefaultValue != that1.DefaultValue {
		return false
	}
	if this.RuntimeKey != that1.RuntimeKey {
		return false
	}
	return true
}
func (this *HeaderValue) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*HeaderValue)
	if !ok {
		that2, ok := that.(HeaderValue)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Key != that1.Key {
		return false
	}
	if this.Value != that1.Value {
		return false
	}
	return true
}
func (this *HeaderValueOption) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*HeaderValueOption)
	if !ok {
		that2, ok := that.(HeaderValueOption)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Header.Equal(that1.Header) {
		return false
	}
	if !this.Append.Equal(that1.Append) {
		return false
	}
	return true
}
func (this *DataSource) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*DataSource)
	if !ok {
		that2, ok := that.(DataSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if that1.Specifier == nil {
		if this.Specifier != nil {
			return false
		}
	} else if this.Specifier == nil {
		return false
	} else if !this.Specifier.Equal(that1.Specifier) {
		return false
	}
	return true
}
func (this *DataSource_Filename) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*DataSource_Filename)
	if !ok {
		that2, ok := that.(DataSource_Filename)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Filename != that1.Filename {
		return false
	}
	return true
}
func (this *DataSource_InlineBytes) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*DataSource_InlineBytes)
	if !ok {
		that2, ok := that.(DataSource_InlineBytes)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.InlineBytes, that1.InlineBytes) {
		return false
	}
	return true
}
func (this *DataSource_InlineString) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*DataSource_InlineString)
	if !ok {
		that2, ok := that.(DataSource_InlineString)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.InlineString != that1.InlineString {
		return false
	}
	return true
}
func (this *TransportSocket) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*TransportSocket)
	if !ok {
		that2, ok := that.(TransportSocket)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if !this.Config.Equal(that1.Config) {
		return false
	}
	return true
}
func (m *Locality) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Locality) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Region) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBase(dAtA, i, uint64(len(m.Region)))
		i += copy(dAtA[i:], m.Region)
	}
	if len(m.Zone) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBase(dAtA, i, uint64(len(m.Zone)))
		i += copy(dAtA[i:], m.Zone)
	}
	if len(m.SubZone) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBase(dAtA, i, uint64(len(m.SubZone)))
		i += copy(dAtA[i:], m.SubZone)
	}
	return i, nil
}

func (m *Node) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Node) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Id) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBase(dAtA, i, uint64(len(m.Id)))
		i += copy(dAtA[i:], m.Id)
	}
	if len(m.Cluster) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBase(dAtA, i, uint64(len(m.Cluster)))
		i += copy(dAtA[i:], m.Cluster)
	}
	if m.Metadata != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBase(dAtA, i, uint64(m.Metadata.Size()))
		n1, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.Locality != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintBase(dAtA, i, uint64(m.Locality.Size()))
		n2, err := m.Locality.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if len(m.BuildVersion) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintBase(dAtA, i, uint64(len(m.BuildVersion)))
		i += copy(dAtA[i:], m.BuildVersion)
	}
	return i, nil
}

func (m *Metadata) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Metadata) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.FilterMetadata) > 0 {
		for k, _ := range m.FilterMetadata {
			dAtA[i] = 0xa
			i++
			v := m.FilterMetadata[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovBase(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovBase(uint64(len(k))) + msgSize
			i = encodeVarintBase(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintBase(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintBase(dAtA, i, uint64(v.Size()))
				n3, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n3
			}
		}
	}
	return i, nil
}

func (m *RuntimeUInt32) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RuntimeUInt32) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.DefaultValue != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintBase(dAtA, i, uint64(m.DefaultValue))
	}
	if len(m.RuntimeKey) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintBase(dAtA, i, uint64(len(m.RuntimeKey)))
		i += copy(dAtA[i:], m.RuntimeKey)
	}
	return i, nil
}

func (m *HeaderValue) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HeaderValue) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Key) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBase(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	if len(m.Value) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBase(dAtA, i, uint64(len(m.Value)))
		i += copy(dAtA[i:], m.Value)
	}
	return i, nil
}

func (m *HeaderValueOption) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HeaderValueOption) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Header != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBase(dAtA, i, uint64(m.Header.Size()))
		n4, err := m.Header.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.Append != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBase(dAtA, i, uint64(m.Append.Size()))
		n5, err := m.Append.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	return i, nil
}

func (m *DataSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DataSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Specifier != nil {
		nn6, err := m.Specifier.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn6
	}
	return i, nil
}

func (m *DataSource_Filename) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0xa
	i++
	i = encodeVarintBase(dAtA, i, uint64(len(m.Filename)))
	i += copy(dAtA[i:], m.Filename)
	return i, nil
}
func (m *DataSource_InlineBytes) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.InlineBytes != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBase(dAtA, i, uint64(len(m.InlineBytes)))
		i += copy(dAtA[i:], m.InlineBytes)
	}
	return i, nil
}
func (m *DataSource_InlineString) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x1a
	i++
	i = encodeVarintBase(dAtA, i, uint64(len(m.InlineString)))
	i += copy(dAtA[i:], m.InlineString)
	return i, nil
}
func (m *TransportSocket) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TransportSocket) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintBase(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.Config != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBase(dAtA, i, uint64(m.Config.Size()))
		n7, err := m.Config.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	return i, nil
}

func encodeVarintBase(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Locality) Size() (n int) {
	var l int
	_ = l
	l = len(m.Region)
	if l > 0 {
		n += 1 + l + sovBase(uint64(l))
	}
	l = len(m.Zone)
	if l > 0 {
		n += 1 + l + sovBase(uint64(l))
	}
	l = len(m.SubZone)
	if l > 0 {
		n += 1 + l + sovBase(uint64(l))
	}
	return n
}

func (m *Node) Size() (n int) {
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovBase(uint64(l))
	}
	l = len(m.Cluster)
	if l > 0 {
		n += 1 + l + sovBase(uint64(l))
	}
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 1 + l + sovBase(uint64(l))
	}
	if m.Locality != nil {
		l = m.Locality.Size()
		n += 1 + l + sovBase(uint64(l))
	}
	l = len(m.BuildVersion)
	if l > 0 {
		n += 1 + l + sovBase(uint64(l))
	}
	return n
}

func (m *Metadata) Size() (n int) {
	var l int
	_ = l
	if len(m.FilterMetadata) > 0 {
		for k, v := range m.FilterMetadata {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovBase(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovBase(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovBase(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *RuntimeUInt32) Size() (n int) {
	var l int
	_ = l
	if m.DefaultValue != 0 {
		n += 1 + sovBase(uint64(m.DefaultValue))
	}
	l = len(m.RuntimeKey)
	if l > 0 {
		n += 1 + l + sovBase(uint64(l))
	}
	return n
}

func (m *HeaderValue) Size() (n int) {
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovBase(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovBase(uint64(l))
	}
	return n
}

func (m *HeaderValueOption) Size() (n int) {
	var l int
	_ = l
	if m.Header != nil {
		l = m.Header.Size()
		n += 1 + l + sovBase(uint64(l))
	}
	if m.Append != nil {
		l = m.Append.Size()
		n += 1 + l + sovBase(uint64(l))
	}
	return n
}

func (m *DataSource) Size() (n int) {
	var l int
	_ = l
	if m.Specifier != nil {
		n += m.Specifier.Size()
	}
	return n
}

func (m *DataSource_Filename) Size() (n int) {
	var l int
	_ = l
	l = len(m.Filename)
	n += 1 + l + sovBase(uint64(l))
	return n
}
func (m *DataSource_InlineBytes) Size() (n int) {
	var l int
	_ = l
	if m.InlineBytes != nil {
		l = len(m.InlineBytes)
		n += 1 + l + sovBase(uint64(l))
	}
	return n
}
func (m *DataSource_InlineString) Size() (n int) {
	var l int
	_ = l
	l = len(m.InlineString)
	n += 1 + l + sovBase(uint64(l))
	return n
}
func (m *TransportSocket) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovBase(uint64(l))
	}
	if m.Config != nil {
		l = m.Config.Size()
		n += 1 + l + sovBase(uint64(l))
	}
	return n
}

func sovBase(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozBase(x uint64) (n int) {
	return sovBase(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Locality) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBase
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Locality: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Locality: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Region", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBase
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Region = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Zone", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBase
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Zone = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubZone", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBase
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SubZone = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBase(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBase
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Node) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBase
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Node: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Node: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBase
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cluster", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBase
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Cluster = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBase
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &google_protobuf4.Struct{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Locality", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBase
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Locality == nil {
				m.Locality = &Locality{}
			}
			if err := m.Locality.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BuildVersion", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBase
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BuildVersion = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBase(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBase
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Metadata) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBase
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Metadata: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Metadata: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FilterMetadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBase
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FilterMetadata == nil {
				m.FilterMetadata = make(map[string]*google_protobuf4.Struct)
			}
			var mapkey string
			var mapvalue *google_protobuf4.Struct
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowBase
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowBase
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthBase
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowBase
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthBase
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthBase
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &google_protobuf4.Struct{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipBase(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthBase
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.FilterMetadata[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBase(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBase
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RuntimeUInt32) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBase
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RuntimeUInt32: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RuntimeUInt32: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DefaultValue", wireType)
			}
			m.DefaultValue = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DefaultValue |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RuntimeKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBase
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RuntimeKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBase(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBase
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HeaderValue) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBase
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HeaderValue: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HeaderValue: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBase
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBase
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBase(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBase
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HeaderValueOption) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBase
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HeaderValueOption: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HeaderValueOption: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Header", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBase
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Header == nil {
				m.Header = &HeaderValue{}
			}
			if err := m.Header.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Append", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBase
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Append == nil {
				m.Append = &google_protobuf.BoolValue{}
			}
			if err := m.Append.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBase(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBase
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DataSource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBase
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DataSource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DataSource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Filename", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBase
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Specifier = &DataSource_Filename{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InlineBytes", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBase
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := make([]byte, postIndex-iNdEx)
			copy(v, dAtA[iNdEx:postIndex])
			m.Specifier = &DataSource_InlineBytes{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InlineString", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBase
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Specifier = &DataSource_InlineString{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBase(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBase
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TransportSocket) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBase
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TransportSocket: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TransportSocket: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBase
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Config", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBase
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Config == nil {
				m.Config = &google_protobuf4.Struct{}
			}
			if err := m.Config.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBase(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBase
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipBase(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowBase
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowBase
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowBase
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthBase
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowBase
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipBase(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthBase = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowBase   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("envoy/api/v2/core/base.proto", fileDescriptorBase) }

var fileDescriptorBase = []byte{
	// 803 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x84, 0x53, 0x4f, 0x6f, 0xe3, 0x44,
	0x14, 0xcf, 0x24, 0xce, 0xbf, 0x97, 0x66, 0xeb, 0x1d, 0x56, 0xdd, 0x12, 0x96, 0xa8, 0x0a, 0x07,
	0xaa, 0x4a, 0xd8, 0x28, 0x15, 0x7f, 0xc4, 0xad, 0x69, 0xdc, 0x4d, 0x44, 0x9b, 0x04, 0xc7, 0x5d,
	0xa1, 0x5e, 0xc2, 0x24, 0x9e, 0x64, 0x47, 0xeb, 0x7a, 0xc2, 0x78, 0x1c, 0x94, 0xbd, 0x70, 0xe1,
	0xc0, 0xf7, 0xe0, 0x82, 0xc4, 0x17, 0x40, 0x9c, 0x2a, 0x71, 0xe1, 0xc8, 0x47, 0x40, 0xbd, 0xed,
	0xb7, 0x40, 0x33, 0x9e, 0x94, 0x42, 0x23, 0xf6, 0xf6, 0xe6, 0xf7, 0xe7, 0xcd, 0xef, 0x3d, 0x8f,
	0xe1, 0x19, 0x8d, 0x57, 0x7c, 0xed, 0x92, 0x25, 0x73, 0x57, 0x6d, 0x77, 0xc6, 0x05, 0x75, 0xa7,
	0x24, 0xa1, 0xce, 0x52, 0x70, 0xc9, 0xf1, 0x63, 0xcd, 0x3a, 0x64, 0xc9, 0x9c, 0x55, 0xdb, 0x51,
	0x6c, 0xe3, 0xd9, 0x82, 0xf3, 0x45, 0x44, 0x5d, 0x2d, 0x98, 0xa6, 0x73, 0x37, 0x91, 0x22, 0x9d,
	0xc9, 0xcc, 0xd0, 0x68, 0xfe, 0x97, 0xfd, 0x4e, 0x90, 0xe5, 0x92, 0x8a, 0xc4, 0xf0, 0x4f, 0x57,
	0x24, 0x62, 0x21, 0x91, 0xd4, 0xdd, 0x14, 0x86, 0x78, 0xb2, 0xe0, 0x0b, 0xae, 0x4b, 0x57, 0x55,
	0x19, 0xda, 0xfa, 0x0a, 0x2a, 0xe7, 0x7c, 0x46, 0x22, 0x26, 0xd7, 0x78, 0x0f, 0x4a, 0x82, 0x2e,
	0x18, 0x8f, 0xf7, 0xd1, 0x01, 0x3a, 0xac, 0xfa, 0xe6, 0x84, 0x31, 0x58, 0xaf, 0x79, 0x4c, 0xf7,
	0xf3, 0x1a, 0xd5, 0x35, 0x7e, 0x17, 0x2a, 0x49, 0x3a, 0x9d, 0x68, 0xbc, 0xa0, 0xf1, 0x72, 0x92,
	0x4e, 0xaf, 0x78, 0x4c, 0x5b, 0xbf, 0x23, 0xb0, 0x06, 0x3c, 0xa4, 0xf8, 0x11, 0xe4, 0x59, 0x68,
	0x7a, 0xe5, 0x59, 0x88, 0xf7, 0xa1, 0x3c, 0x8b, 0xd2, 0x44, 0x52, 0x61, 0x5a, 0x6d, 0x8e, 0xf8,
	0x18, 0x2a, 0xd7, 0x54, 0x92, 0x90, 0x48, 0xa2, 0xbb, 0xd5, 0xda, 0x4f, 0x9d, 0x6c, 0x4e, 0x67,
	0x33, 0xa7, 0x33, 0xd6, 0x5b, 0xf0, 0xef, 0x84, 0xf8, 0x33, 0xa8, 0x44, 0x26, 0xfa, 0xbe, 0xa5,
	0x4d, 0xef, 0x39, 0x0f, 0xb6, 0xe9, 0x6c, 0xa6, 0xf3, 0xef, 0xc4, 0xf8, 0x03, 0xa8, 0x4f, 0x53,
	0x16, 0x85, 0x93, 0x15, 0x15, 0x89, 0x1a, 0xb7, 0xa8, 0xd3, 0xec, 0x68, 0xf0, 0x45, 0x86, 0xb5,
	0x6e, 0x10, 0x54, 0x2e, 0x36, 0x57, 0x7d, 0x0d, 0xbb, 0x73, 0x16, 0x49, 0x2a, 0x26, 0x77, 0x31,
	0xd1, 0x41, 0xe1, 0xb0, 0xd6, 0x76, 0xb7, 0xdc, 0xb8, 0x71, 0x39, 0x67, 0xda, 0xb2, 0x39, 0x7a,
	0xb1, 0x14, 0x6b, 0xff, 0xd1, 0xfc, 0x5f, 0x60, 0xe3, 0x0a, 0xde, 0xd9, 0x22, 0xc3, 0x36, 0x14,
	0x5e, 0xd1, 0xb5, 0xd9, 0x9d, 0x2a, 0xf1, 0x47, 0x50, 0x5c, 0x91, 0x28, 0xcd, 0xbe, 0xc2, 0xff,
	0xec, 0x27, 0x53, 0x7d, 0x91, 0xff, 0x1c, 0xb5, 0xbe, 0x81, 0xba, 0x9f, 0xc6, 0x92, 0x5d, 0xd3,
	0xcb, 0x7e, 0x2c, 0x8f, 0xdb, 0x6a, 0xf0, 0x90, 0xce, 0x49, 0x1a, 0xc9, 0xc9, 0x3f, 0xbd, 0xea,
	0xfe, 0x8e, 0x01, 0x5f, 0x28, 0x0c, 0x1f, 0x41, 0x4d, 0x64, 0xae, 0x89, 0x8a, 0xa0, 0x3f, 0x6e,
	0xa7, 0xfa, 0xdb, 0x9b, 0x9b, 0x82, 0x25, 0xf2, 0x07, 0xc8, 0x07, 0xc3, 0x7e, 0x49, 0xd7, 0xad,
	0x4f, 0xa0, 0xd6, 0xa3, 0x24, 0xa4, 0x22, 0xb3, 0x3e, 0x4c, 0xfd, 0xe4, 0x7e, 0xea, 0xaa, 0x09,
	0xd7, 0xfa, 0x1e, 0x1e, 0xdf, 0xb3, 0x0d, 0x97, 0x52, 0xbd, 0xb2, 0x4f, 0xa1, 0xf4, 0x52, 0x83,
	0xda, 0x5f, 0x6b, 0x37, 0xb7, 0xac, 0xf6, 0x9e, 0xcb, 0x37, 0x6a, 0xdc, 0x86, 0x92, 0xfa, 0x01,
	0xe2, 0xd0, 0x6c, 0xa6, 0xf1, 0x60, 0x33, 0x1d, 0xce, 0x23, 0xe3, 0xc9, 0x94, 0xad, 0x5f, 0x10,
	0x40, 0x97, 0x48, 0x32, 0xe6, 0xa9, 0x98, 0x51, 0xfc, 0x21, 0x54, 0xe6, 0x2c, 0xa2, 0x31, 0xb9,
	0xa6, 0x59, 0xf8, 0x7b, 0xf3, 0xf6, 0x72, 0xfe, 0x1d, 0x89, 0x1d, 0xd8, 0x61, 0x71, 0xc4, 0x62,
	0x3a, 0x99, 0xae, 0x25, 0x4d, 0xf4, 0x8d, 0x3b, 0x46, 0xfc, 0x3a, 0x6f, 0x2b, 0x71, 0x2d, 0x13,
	0x74, 0x14, 0x8f, 0x3f, 0x86, 0xba, 0xd1, 0x27, 0x52, 0xb0, 0x78, 0xf1, 0x60, 0x9b, 0xbd, 0x9c,
	0x6f, 0x3a, 0x8e, 0xb5, 0xa0, 0x83, 0xa1, 0x9a, 0x2c, 0xe9, 0x8c, 0xcd, 0x19, 0x15, 0xb8, 0xf8,
	0xeb, 0x9b, 0x9b, 0x02, 0x6a, 0x11, 0xd8, 0x0d, 0x04, 0x89, 0x93, 0x25, 0x17, 0x72, 0xcc, 0x67,
	0xaf, 0xa8, 0xc4, 0xef, 0x83, 0xb5, 0x35, 0xad, 0xaf, 0x61, 0xec, 0x42, 0x69, 0xc6, 0xe3, 0x39,
	0x5b, 0xbc, 0xed, 0xb5, 0x18, 0xd9, 0xd1, 0x21, 0xec, 0xfa, 0x3c, 0x95, 0x2c, 0x5e, 0x8c, 0x04,
	0xe3, 0x42, 0xfd, 0x25, 0x35, 0x28, 0x77, 0xbd, 0xb3, 0x93, 0xcb, 0xf3, 0xc0, 0xce, 0xe1, 0x0a,
	0x58, 0xbd, 0xfe, 0xf3, 0x9e, 0x8d, 0x8e, 0x7e, 0x40, 0x50, 0xf7, 0xe9, 0xb7, 0x29, 0x4d, 0xe4,
	0x05, 0x95, 0x2f, 0x79, 0x88, 0xf7, 0x00, 0x5f, 0x78, 0x41, 0x6f, 0xd8, 0x9d, 0x5c, 0x0e, 0xc6,
	0x23, 0xef, 0xb4, 0x7f, 0xd6, 0xf7, 0xba, 0x76, 0x0e, 0x97, 0xa1, 0xf0, 0xdc, 0x0b, 0x6c, 0xa4,
	0xcd, 0xde, 0x49, 0xd7, 0xce, 0xab, 0x6a, 0x34, 0x1c, 0x07, 0x76, 0x41, 0x91, 0xa3, 0xcb, 0xc0,
	0xb6, 0x30, 0x40, 0xa9, 0xeb, 0x9d, 0x7b, 0x81, 0x67, 0x17, 0xd5, 0x95, 0xa7, 0xc3, 0xc1, 0xc0,
	0x3b, 0x0d, 0xec, 0x92, 0x3a, 0x0c, 0x47, 0x41, 0x7f, 0x38, 0x18, 0xdb, 0x65, 0x5c, 0x85, 0x62,
	0xe0, 0x9f, 0x9c, 0x7a, 0x76, 0xa5, 0x61, 0xfd, 0xf8, 0x53, 0x33, 0xd7, 0xd9, 0xfb, 0xf9, 0xb6,
	0x89, 0xfe, 0xb8, 0x6d, 0xa2, 0x3f, 0x6f, 0x9b, 0xe8, 0xaf, 0xdb, 0x26, 0xba, 0xb2, 0xd4, 0x0b,
	0x99, 0x96, 0xf4, 0x84, 0xc7, 0x7f, 0x07, 0x00, 0x00, 0xff, 0xff, 0x62, 0xde, 0x55, 0x90, 0x76,
	0x05, 0x00, 0x00,
}
