// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: envoy/api/v2/core/address.proto

/*
	Package core is a generated protocol buffer package.

	It is generated from these files:
		envoy/api/v2/core/address.proto
		envoy/api/v2/core/base.proto
		envoy/api/v2/core/config_source.proto
		envoy/api/v2/core/grpc_service.proto
		envoy/api/v2/core/health_check.proto
		envoy/api/v2/core/http_uri.proto
		envoy/api/v2/core/protocol.proto

	It has these top-level messages:
		Pipe
		SocketAddress
		BindConfig
		Address
		CidrRange
		Locality
		Node
		Metadata
		RuntimeUInt32
		HeaderValue
		HeaderValueOption
		DataSource
		TransportSocket
		ApiConfigSource
		AggregatedConfigSource
		ConfigSource
		GrpcService
		HealthCheck
		HttpUri
		TcpProtocolOptions
		HttpProtocolOptions
		Http1ProtocolOptions
		Http2ProtocolOptions
		GrpcProtocolOptions
*/
package core

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf "github.com/gogo/protobuf/types"
import _ "github.com/lyft/protoc-gen-validate/validate"
import _ "github.com/gogo/protobuf/gogoproto"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type SocketAddress_Protocol int32

const (
	TCP SocketAddress_Protocol = 0
	// [#not-implemented-hide:]
	UDP SocketAddress_Protocol = 1
)

var SocketAddress_Protocol_name = map[int32]string{
	0: "TCP",
	1: "UDP",
}
var SocketAddress_Protocol_value = map[string]int32{
	"TCP": 0,
	"UDP": 1,
}

func (x SocketAddress_Protocol) String() string {
	return proto.EnumName(SocketAddress_Protocol_name, int32(x))
}
func (SocketAddress_Protocol) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorAddress, []int{1, 0}
}

type Pipe struct {
	// Unix Domain Socket path. On Linux, paths starting with '@' will use the
	// abstract namespace. The starting '@' is replaced by a null byte by Envoy.
	// Paths starting with '@' will result in an error in environments other than
	// Linux.
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
}

func (m *Pipe) Reset()                    { *m = Pipe{} }
func (m *Pipe) String() string            { return proto.CompactTextString(m) }
func (*Pipe) ProtoMessage()               {}
func (*Pipe) Descriptor() ([]byte, []int) { return fileDescriptorAddress, []int{0} }

func (m *Pipe) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

type SocketAddress struct {
	Protocol SocketAddress_Protocol `protobuf:"varint,1,opt,name=protocol,proto3,enum=envoy.api.v2.core.SocketAddress_Protocol" json:"protocol,omitempty"`
	// The address for this socket. :ref:`Listeners <config_listeners>` will bind
	// to the address or outbound connections will be made. An empty address is
	// not allowed, specify ``0.0.0.0`` or ``::`` to bind any. It's still possible to
	// distinguish on an address via the prefix/suffix matching in
	// FilterChainMatch after connection. For :ref:`clusters
	// <config_cluster_manager_cluster>`, an address may be either an IP or
	// hostname to be resolved via DNS. If it is a hostname, :ref:`resolver_name
	// <envoy_api_field_core.SocketAddress.resolver_name>` should be set unless default
	// (i.e. DNS) resolution is expected.
	Address string `protobuf:"bytes,2,opt,name=address,proto3" json:"address,omitempty"`
	// Types that are valid to be assigned to PortSpecifier:
	//	*SocketAddress_PortValue
	//	*SocketAddress_NamedPort
	PortSpecifier isSocketAddress_PortSpecifier `protobuf_oneof:"port_specifier"`
	// The name of the resolver. This must have been registered with Envoy. If this is
	// empty, a context dependent default applies. If address is a hostname this
	// should be set for resolution other than DNS. If the address is a concrete
	// IP address, no resolution will occur.
	ResolverName string `protobuf:"bytes,5,opt,name=resolver_name,json=resolverName,proto3" json:"resolver_name,omitempty"`
	// When binding to an IPv6 address above, this enables `IPv4 compatibity
	// <https://tools.ietf.org/html/rfc3493#page-11>`_. Binding to ``::`` will
	// allow both IPv4 and IPv6 connections, with peer IPv4 addresses mapped into
	// IPv6 space as ``::FFFF:<IPv4-address>``.
	Ipv4Compat bool `protobuf:"varint,6,opt,name=ipv4_compat,json=ipv4Compat,proto3" json:"ipv4_compat,omitempty"`
}

func (m *SocketAddress) Reset()                    { *m = SocketAddress{} }
func (m *SocketAddress) String() string            { return proto.CompactTextString(m) }
func (*SocketAddress) ProtoMessage()               {}
func (*SocketAddress) Descriptor() ([]byte, []int) { return fileDescriptorAddress, []int{1} }

type isSocketAddress_PortSpecifier interface {
	isSocketAddress_PortSpecifier()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type SocketAddress_PortValue struct {
	PortValue uint32 `protobuf:"varint,3,opt,name=port_value,json=portValue,proto3,oneof"`
}
type SocketAddress_NamedPort struct {
	NamedPort string `protobuf:"bytes,4,opt,name=named_port,json=namedPort,proto3,oneof"`
}

func (*SocketAddress_PortValue) isSocketAddress_PortSpecifier() {}
func (*SocketAddress_NamedPort) isSocketAddress_PortSpecifier() {}

func (m *SocketAddress) GetPortSpecifier() isSocketAddress_PortSpecifier {
	if m != nil {
		return m.PortSpecifier
	}
	return nil
}

func (m *SocketAddress) GetProtocol() SocketAddress_Protocol {
	if m != nil {
		return m.Protocol
	}
	return TCP
}

func (m *SocketAddress) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

func (m *SocketAddress) GetPortValue() uint32 {
	if x, ok := m.GetPortSpecifier().(*SocketAddress_PortValue); ok {
		return x.PortValue
	}
	return 0
}

func (m *SocketAddress) GetNamedPort() string {
	if x, ok := m.GetPortSpecifier().(*SocketAddress_NamedPort); ok {
		return x.NamedPort
	}
	return ""
}

func (m *SocketAddress) GetResolverName() string {
	if m != nil {
		return m.ResolverName
	}
	return ""
}

func (m *SocketAddress) GetIpv4Compat() bool {
	if m != nil {
		return m.Ipv4Compat
	}
	return false
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*SocketAddress) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _SocketAddress_OneofMarshaler, _SocketAddress_OneofUnmarshaler, _SocketAddress_OneofSizer, []interface{}{
		(*SocketAddress_PortValue)(nil),
		(*SocketAddress_NamedPort)(nil),
	}
}

func _SocketAddress_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*SocketAddress)
	// port_specifier
	switch x := m.PortSpecifier.(type) {
	case *SocketAddress_PortValue:
		_ = b.EncodeVarint(3<<3 | proto.WireVarint)
		_ = b.EncodeVarint(uint64(x.PortValue))
	case *SocketAddress_NamedPort:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.NamedPort)
	case nil:
	default:
		return fmt.Errorf("SocketAddress.PortSpecifier has unexpected type %T", x)
	}
	return nil
}

func _SocketAddress_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*SocketAddress)
	switch tag {
	case 3: // port_specifier.port_value
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.PortSpecifier = &SocketAddress_PortValue{uint32(x)}
		return true, err
	case 4: // port_specifier.named_port
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.PortSpecifier = &SocketAddress_NamedPort{x}
		return true, err
	default:
		return false, nil
	}
}

func _SocketAddress_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*SocketAddress)
	// port_specifier
	switch x := m.PortSpecifier.(type) {
	case *SocketAddress_PortValue:
		n += proto.SizeVarint(3<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.PortValue))
	case *SocketAddress_NamedPort:
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.NamedPort)))
		n += len(x.NamedPort)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type BindConfig struct {
	// The address to bind to when creating a socket.
	SourceAddress SocketAddress `protobuf:"bytes,1,opt,name=source_address,json=sourceAddress" json:"source_address"`
	// Whether to set the *IP_FREEBIND* option when creating the socket. When this
	// flag is set to true, allows the :ref:`source_address
	// <envoy_api_field_UpstreamBindConfig.source_address>` to be an IP address
	// that is not configured on the system running Envoy. When this flag is set
	// to false, the option *IP_FREEBIND* is disabled on the socket. When this
	// flag is not set (default), the socket is not modified, i.e. the option is
	// neither enabled nor disabled.
	Freebind *google_protobuf.BoolValue `protobuf:"bytes,2,opt,name=freebind" json:"freebind,omitempty"`
}

func (m *BindConfig) Reset()                    { *m = BindConfig{} }
func (m *BindConfig) String() string            { return proto.CompactTextString(m) }
func (*BindConfig) ProtoMessage()               {}
func (*BindConfig) Descriptor() ([]byte, []int) { return fileDescriptorAddress, []int{2} }

func (m *BindConfig) GetSourceAddress() SocketAddress {
	if m != nil {
		return m.SourceAddress
	}
	return SocketAddress{}
}

func (m *BindConfig) GetFreebind() *google_protobuf.BoolValue {
	if m != nil {
		return m.Freebind
	}
	return nil
}

// Addresses specify either a logical or physical address and port, which are
// used to tell Envoy where to bind/listen, connect to upstream and find
// management servers.
type Address struct {
	// Types that are valid to be assigned to Address:
	//	*Address_SocketAddress
	//	*Address_Pipe
	Address isAddress_Address `protobuf_oneof:"address"`
}

func (m *Address) Reset()                    { *m = Address{} }
func (m *Address) String() string            { return proto.CompactTextString(m) }
func (*Address) ProtoMessage()               {}
func (*Address) Descriptor() ([]byte, []int) { return fileDescriptorAddress, []int{3} }

type isAddress_Address interface {
	isAddress_Address()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type Address_SocketAddress struct {
	SocketAddress *SocketAddress `protobuf:"bytes,1,opt,name=socket_address,json=socketAddress,oneof"`
}
type Address_Pipe struct {
	Pipe *Pipe `protobuf:"bytes,2,opt,name=pipe,oneof"`
}

func (*Address_SocketAddress) isAddress_Address() {}
func (*Address_Pipe) isAddress_Address()          {}

func (m *Address) GetAddress() isAddress_Address {
	if m != nil {
		return m.Address
	}
	return nil
}

func (m *Address) GetSocketAddress() *SocketAddress {
	if x, ok := m.GetAddress().(*Address_SocketAddress); ok {
		return x.SocketAddress
	}
	return nil
}

func (m *Address) GetPipe() *Pipe {
	if x, ok := m.GetAddress().(*Address_Pipe); ok {
		return x.Pipe
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Address) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Address_OneofMarshaler, _Address_OneofUnmarshaler, _Address_OneofSizer, []interface{}{
		(*Address_SocketAddress)(nil),
		(*Address_Pipe)(nil),
	}
}

func _Address_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Address)
	// address
	switch x := m.Address.(type) {
	case *Address_SocketAddress:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SocketAddress); err != nil {
			return err
		}
	case *Address_Pipe:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Pipe); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Address.Address has unexpected type %T", x)
	}
	return nil
}

func _Address_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Address)
	switch tag {
	case 1: // address.socket_address
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SocketAddress)
		err := b.DecodeMessage(msg)
		m.Address = &Address_SocketAddress{msg}
		return true, err
	case 2: // address.pipe
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Pipe)
		err := b.DecodeMessage(msg)
		m.Address = &Address_Pipe{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Address_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Address)
	// address
	switch x := m.Address.(type) {
	case *Address_SocketAddress:
		s := proto.Size(x.SocketAddress)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Address_Pipe:
		s := proto.Size(x.Pipe)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// CidrRange specifies an IP Address and a prefix length to construct
// the subnet mask for a `CIDR <https://tools.ietf.org/html/rfc4632>`_ range.
type CidrRange struct {
	// IPv4 or IPv6 address, e.g. ``192.0.0.0`` or ``2001:db8::``.
	AddressPrefix string `protobuf:"bytes,1,opt,name=address_prefix,json=addressPrefix,proto3" json:"address_prefix,omitempty"`
	// Length of prefix, e.g. 0, 32.
	PrefixLen *google_protobuf.UInt32Value `protobuf:"bytes,2,opt,name=prefix_len,json=prefixLen" json:"prefix_len,omitempty"`
}

func (m *CidrRange) Reset()                    { *m = CidrRange{} }
func (m *CidrRange) String() string            { return proto.CompactTextString(m) }
func (*CidrRange) ProtoMessage()               {}
func (*CidrRange) Descriptor() ([]byte, []int) { return fileDescriptorAddress, []int{4} }

func (m *CidrRange) GetAddressPrefix() string {
	if m != nil {
		return m.AddressPrefix
	}
	return ""
}

func (m *CidrRange) GetPrefixLen() *google_protobuf.UInt32Value {
	if m != nil {
		return m.PrefixLen
	}
	return nil
}

func init() {
	proto.RegisterType((*Pipe)(nil), "envoy.api.v2.core.Pipe")
	proto.RegisterType((*SocketAddress)(nil), "envoy.api.v2.core.SocketAddress")
	proto.RegisterType((*BindConfig)(nil), "envoy.api.v2.core.BindConfig")
	proto.RegisterType((*Address)(nil), "envoy.api.v2.core.Address")
	proto.RegisterType((*CidrRange)(nil), "envoy.api.v2.core.CidrRange")
	proto.RegisterEnum("envoy.api.v2.core.SocketAddress_Protocol", SocketAddress_Protocol_name, SocketAddress_Protocol_value)
}
func (this *Pipe) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Pipe)
	if !ok {
		that2, ok := that.(Pipe)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	return true
}
func (this *SocketAddress) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*SocketAddress)
	if !ok {
		that2, ok := that.(SocketAddress)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Protocol != that1.Protocol {
		return false
	}
	if this.Address != that1.Address {
		return false
	}
	if that1.PortSpecifier == nil {
		if this.PortSpecifier != nil {
			return false
		}
	} else if this.PortSpecifier == nil {
		return false
	} else if !this.PortSpecifier.Equal(that1.PortSpecifier) {
		return false
	}
	if this.ResolverName != that1.ResolverName {
		return false
	}
	if this.Ipv4Compat != that1.Ipv4Compat {
		return false
	}
	return true
}
func (this *SocketAddress_PortValue) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*SocketAddress_PortValue)
	if !ok {
		that2, ok := that.(SocketAddress_PortValue)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.PortValue != that1.PortValue {
		return false
	}
	return true
}
func (this *SocketAddress_NamedPort) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*SocketAddress_NamedPort)
	if !ok {
		that2, ok := that.(SocketAddress_NamedPort)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.NamedPort != that1.NamedPort {
		return false
	}
	return true
}
func (this *BindConfig) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*BindConfig)
	if !ok {
		that2, ok := that.(BindConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.SourceAddress.Equal(&that1.SourceAddress) {
		return false
	}
	if !this.Freebind.Equal(that1.Freebind) {
		return false
	}
	return true
}
func (this *Address) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Address)
	if !ok {
		that2, ok := that.(Address)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if that1.Address == nil {
		if this.Address != nil {
			return false
		}
	} else if this.Address == nil {
		return false
	} else if !this.Address.Equal(that1.Address) {
		return false
	}
	return true
}
func (this *Address_SocketAddress) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Address_SocketAddress)
	if !ok {
		that2, ok := that.(Address_SocketAddress)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.SocketAddress.Equal(that1.SocketAddress) {
		return false
	}
	return true
}
func (this *Address_Pipe) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Address_Pipe)
	if !ok {
		that2, ok := that.(Address_Pipe)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.Pipe.Equal(that1.Pipe) {
		return false
	}
	return true
}
func (this *CidrRange) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*CidrRange)
	if !ok {
		that2, ok := that.(CidrRange)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.AddressPrefix != that1.AddressPrefix {
		return false
	}
	if !this.PrefixLen.Equal(that1.PrefixLen) {
		return false
	}
	return true
}
func (m *Pipe) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Pipe) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Path) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAddress(dAtA, i, uint64(len(m.Path)))
		i += copy(dAtA[i:], m.Path)
	}
	return i, nil
}

func (m *SocketAddress) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SocketAddress) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Protocol != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintAddress(dAtA, i, uint64(m.Protocol))
	}
	if len(m.Address) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAddress(dAtA, i, uint64(len(m.Address)))
		i += copy(dAtA[i:], m.Address)
	}
	if m.PortSpecifier != nil {
		nn1, err := m.PortSpecifier.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn1
	}
	if len(m.ResolverName) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintAddress(dAtA, i, uint64(len(m.ResolverName)))
		i += copy(dAtA[i:], m.ResolverName)
	}
	if m.Ipv4Compat {
		dAtA[i] = 0x30
		i++
		if m.Ipv4Compat {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *SocketAddress_PortValue) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x18
	i++
	i = encodeVarintAddress(dAtA, i, uint64(m.PortValue))
	return i, nil
}
func (m *SocketAddress_NamedPort) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x22
	i++
	i = encodeVarintAddress(dAtA, i, uint64(len(m.NamedPort)))
	i += copy(dAtA[i:], m.NamedPort)
	return i, nil
}
func (m *BindConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BindConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintAddress(dAtA, i, uint64(m.SourceAddress.Size()))
	n2, err := m.SourceAddress.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	if m.Freebind != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAddress(dAtA, i, uint64(m.Freebind.Size()))
		n3, err := m.Freebind.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	return i, nil
}

func (m *Address) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Address) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Address != nil {
		nn4, err := m.Address.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn4
	}
	return i, nil
}

func (m *Address_SocketAddress) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.SocketAddress != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAddress(dAtA, i, uint64(m.SocketAddress.Size()))
		n5, err := m.SocketAddress.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	return i, nil
}
func (m *Address_Pipe) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Pipe != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAddress(dAtA, i, uint64(m.Pipe.Size()))
		n6, err := m.Pipe.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	return i, nil
}
func (m *CidrRange) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CidrRange) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.AddressPrefix) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintAddress(dAtA, i, uint64(len(m.AddressPrefix)))
		i += copy(dAtA[i:], m.AddressPrefix)
	}
	if m.PrefixLen != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintAddress(dAtA, i, uint64(m.PrefixLen.Size()))
		n7, err := m.PrefixLen.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	return i, nil
}

func encodeVarintAddress(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Pipe) Size() (n int) {
	var l int
	_ = l
	l = len(m.Path)
	if l > 0 {
		n += 1 + l + sovAddress(uint64(l))
	}
	return n
}

func (m *SocketAddress) Size() (n int) {
	var l int
	_ = l
	if m.Protocol != 0 {
		n += 1 + sovAddress(uint64(m.Protocol))
	}
	l = len(m.Address)
	if l > 0 {
		n += 1 + l + sovAddress(uint64(l))
	}
	if m.PortSpecifier != nil {
		n += m.PortSpecifier.Size()
	}
	l = len(m.ResolverName)
	if l > 0 {
		n += 1 + l + sovAddress(uint64(l))
	}
	if m.Ipv4Compat {
		n += 2
	}
	return n
}

func (m *SocketAddress_PortValue) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovAddress(uint64(m.PortValue))
	return n
}
func (m *SocketAddress_NamedPort) Size() (n int) {
	var l int
	_ = l
	l = len(m.NamedPort)
	n += 1 + l + sovAddress(uint64(l))
	return n
}
func (m *BindConfig) Size() (n int) {
	var l int
	_ = l
	l = m.SourceAddress.Size()
	n += 1 + l + sovAddress(uint64(l))
	if m.Freebind != nil {
		l = m.Freebind.Size()
		n += 1 + l + sovAddress(uint64(l))
	}
	return n
}

func (m *Address) Size() (n int) {
	var l int
	_ = l
	if m.Address != nil {
		n += m.Address.Size()
	}
	return n
}

func (m *Address_SocketAddress) Size() (n int) {
	var l int
	_ = l
	if m.SocketAddress != nil {
		l = m.SocketAddress.Size()
		n += 1 + l + sovAddress(uint64(l))
	}
	return n
}
func (m *Address_Pipe) Size() (n int) {
	var l int
	_ = l
	if m.Pipe != nil {
		l = m.Pipe.Size()
		n += 1 + l + sovAddress(uint64(l))
	}
	return n
}
func (m *CidrRange) Size() (n int) {
	var l int
	_ = l
	l = len(m.AddressPrefix)
	if l > 0 {
		n += 1 + l + sovAddress(uint64(l))
	}
	if m.PrefixLen != nil {
		l = m.PrefixLen.Size()
		n += 1 + l + sovAddress(uint64(l))
	}
	return n
}

func sovAddress(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozAddress(x uint64) (n int) {
	return sovAddress(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Pipe) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAddress
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Pipe: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Pipe: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAddress
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAddress
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAddress(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAddress
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SocketAddress) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAddress
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SocketAddress: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SocketAddress: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Protocol", wireType)
			}
			m.Protocol = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAddress
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Protocol |= (SocketAddress_Protocol(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAddress
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAddress
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Address = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PortValue", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAddress
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.PortSpecifier = &SocketAddress_PortValue{v}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamedPort", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAddress
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAddress
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PortSpecifier = &SocketAddress_NamedPort{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResolverName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAddress
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAddress
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResolverName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ipv4Compat", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAddress
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Ipv4Compat = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipAddress(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAddress
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BindConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAddress
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BindConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BindConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceAddress", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAddress
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAddress
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.SourceAddress.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Freebind", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAddress
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAddress
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Freebind == nil {
				m.Freebind = &google_protobuf.BoolValue{}
			}
			if err := m.Freebind.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAddress(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAddress
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Address) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAddress
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Address: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Address: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SocketAddress", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAddress
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAddress
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &SocketAddress{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Address = &Address_SocketAddress{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Pipe", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAddress
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAddress
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Pipe{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Address = &Address_Pipe{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAddress(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAddress
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CidrRange) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAddress
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CidrRange: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CidrRange: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AddressPrefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAddress
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAddress
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AddressPrefix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrefixLen", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAddress
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAddress
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PrefixLen == nil {
				m.PrefixLen = &google_protobuf.UInt32Value{}
			}
			if err := m.PrefixLen.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAddress(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAddress
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipAddress(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowAddress
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAddress
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAddress
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthAddress
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowAddress
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipAddress(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthAddress = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowAddress   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("envoy/api/v2/core/address.proto", fileDescriptorAddress) }

var fileDescriptorAddress = []byte{
	// 571 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x52, 0xc1, 0x8b, 0xd3, 0x4e,
	0x18, 0xcd, 0xb4, 0xd9, 0xdd, 0xf6, 0xdb, 0x5f, 0x4b, 0x7f, 0x41, 0xd8, 0x50, 0x34, 0x5b, 0xb2,
	0x08, 0xab, 0x60, 0x22, 0x59, 0xf1, 0x6e, 0x2a, 0xd8, 0x05, 0x91, 0x18, 0x5d, 0x3d, 0x86, 0x69,
	0x32, 0x8d, 0x83, 0x69, 0x66, 0x98, 0xa6, 0x51, 0x6f, 0xe2, 0x41, 0xc4, 0xbb, 0x47, 0x4f, 0x5e,
	0xfc, 0x13, 0xc4, 0xd3, 0x1e, 0xf7, 0xe0, 0xc1, 0xbf, 0x40, 0xa4, 0xb7, 0xfd, 0x2f, 0x64, 0x26,
	0x49, 0x51, 0x2b, 0x88, 0xb7, 0x8f, 0xf7, 0xbd, 0xef, 0xe5, 0xcd, 0xcb, 0x83, 0x7d, 0x92, 0x97,
	0xec, 0x85, 0x8b, 0x39, 0x75, 0x4b, 0xcf, 0x8d, 0x99, 0x20, 0x2e, 0x4e, 0x12, 0x41, 0x16, 0x0b,
	0x87, 0x0b, 0x56, 0x30, 0xe3, 0x7f, 0x45, 0x70, 0x30, 0xa7, 0x4e, 0xe9, 0x39, 0x92, 0x30, 0xb4,
	0x52, 0xc6, 0xd2, 0x8c, 0xb8, 0x8a, 0x30, 0x5d, 0xce, 0xdc, 0x67, 0x02, 0x73, 0x4e, 0x44, 0x7d,
	0x32, 0xdc, 0x2b, 0x71, 0x46, 0x13, 0x5c, 0x10, 0xb7, 0x19, 0xea, 0xc5, 0x85, 0x94, 0xa5, 0x4c,
	0x8d, 0xae, 0x9c, 0x2a, 0xd4, 0xbe, 0x0c, 0x7a, 0x40, 0x39, 0x31, 0x2e, 0x81, 0xce, 0x71, 0xf1,
	0xc4, 0x44, 0x23, 0x74, 0xd8, 0xf5, 0xbb, 0x9f, 0xcf, 0x4f, 0xdb, 0xba, 0x68, 0x8d, 0x50, 0xa8,
	0x60, 0xfb, 0x4b, 0x0b, 0x7a, 0x0f, 0x58, 0xfc, 0x94, 0x14, 0xb7, 0x2a, 0x83, 0xc6, 0x7d, 0xe8,
	0x28, 0x85, 0x98, 0x65, 0xea, 0xa8, 0xef, 0x5d, 0x71, 0x36, 0xdc, 0x3a, 0xbf, 0xdc, 0x38, 0x41,
	0x7d, 0xe0, 0x83, 0xd4, 0xdf, 0x7a, 0x85, 0x5a, 0x03, 0x14, 0xae, 0x65, 0x8c, 0x03, 0xd8, 0xa9,
	0x9f, 0x6f, 0xb6, 0x7e, 0xb7, 0xd1, 0x6c, 0x8c, 0x7d, 0x00, 0xce, 0x44, 0x11, 0x95, 0x38, 0x5b,
	0x12, 0xb3, 0x3d, 0x42, 0x87, 0xbd, 0x89, 0x16, 0x76, 0x25, 0xf6, 0x48, 0x42, 0x92, 0x90, 0xe3,
	0x39, 0x49, 0x22, 0x09, 0x99, 0xba, 0x14, 0x92, 0x04, 0x85, 0x05, 0x4c, 0x14, 0xc6, 0x01, 0xf4,
	0x04, 0x59, 0xb0, 0xac, 0x24, 0x22, 0x92, 0xa8, 0xb9, 0x25, 0x39, 0xe1, 0x7f, 0x0d, 0x78, 0x0f,
	0xcf, 0xa5, 0xca, 0x2e, 0xe5, 0xe5, 0x8d, 0x28, 0x66, 0x73, 0x8e, 0x0b, 0x73, 0x7b, 0x84, 0x0e,
	0x3b, 0x21, 0x48, 0x68, 0xac, 0x10, 0xdb, 0x86, 0x4e, 0xf3, 0x1c, 0x63, 0x07, 0xda, 0x0f, 0xc7,
	0xc1, 0x40, 0x93, 0xc3, 0xc9, 0xed, 0x60, 0x80, 0x86, 0xfa, 0x9b, 0x0f, 0x96, 0xe6, 0xef, 0x41,
	0x5f, 0x79, 0x5d, 0x70, 0x12, 0xd3, 0x19, 0x25, 0xc2, 0xd8, 0xfa, 0x74, 0x7e, 0xda, 0x46, 0xf6,
	0x7b, 0x04, 0xe0, 0xd3, 0x3c, 0x19, 0xb3, 0x7c, 0x46, 0x53, 0xe3, 0x31, 0xf4, 0x17, 0x6c, 0x29,
	0x62, 0x12, 0x35, 0xef, 0x97, 0x89, 0xee, 0x7a, 0xa3, 0xbf, 0x25, 0xea, 0xf7, 0xcf, 0xbe, 0xed,
	0x6b, 0x2a, 0xcc, 0xb7, 0x2a, 0xcc, 0x5e, 0xa5, 0xd3, 0xfc, 0xa4, 0x9b, 0xd0, 0x99, 0x09, 0x42,
	0xa6, 0x34, 0x4f, 0x54, 0xa4, 0xbb, 0xde, 0xd0, 0xa9, 0xfa, 0xe3, 0x34, 0xfd, 0x71, 0x7c, 0xc6,
	0x32, 0x95, 0x5c, 0xb8, 0xe6, 0xda, 0xef, 0x10, 0xec, 0x34, 0x1a, 0xc7, 0xd2, 0x9c, 0xfc, 0xe6,
	0xbf, 0x9a, 0x9b, 0x68, 0xd2, 0xce, 0xcf, 0x9d, 0xb9, 0x06, 0x3a, 0xa7, 0x9c, 0xd4, 0x56, 0xf6,
	0xfe, 0x20, 0x20, 0xbb, 0x38, 0xd1, 0x42, 0x45, 0xf3, 0x07, 0xeb, 0x3e, 0x34, 0xb9, 0xbd, 0x46,
	0xd0, 0x1d, 0xd3, 0x44, 0x84, 0x38, 0x4f, 0x89, 0x71, 0x1d, 0xfa, 0xf5, 0x3e, 0xe2, 0x82, 0xcc,
	0xe8, 0xf3, 0xcd, 0xf6, 0xf6, 0x6a, 0x42, 0xa0, 0xf6, 0xc6, 0x1d, 0x80, 0x8a, 0x19, 0x65, 0x24,
	0xaf, 0x6d, 0x5c, 0xdc, 0x48, 0xe4, 0xe4, 0x38, 0x2f, 0x8e, 0x3c, 0x95, 0x49, 0xdd, 0xd4, 0xab,
	0x6d, 0xf3, 0x25, 0x0a, 0xbb, 0xd5, 0xed, 0x5d, 0x92, 0xfb, 0x83, 0x8f, 0x2b, 0x0b, 0x9d, 0xad,
	0x2c, 0xf4, 0x75, 0x65, 0xa1, 0xef, 0x2b, 0x0b, 0x4d, 0xb7, 0xd5, 0xf9, 0xd1, 0x8f, 0x00, 0x00,
	0x00, 0xff, 0xff, 0x60, 0x2d, 0x0c, 0xc4, 0xd4, 0x03, 0x00, 0x00,
}
