// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: envoy/api/v2/cds.proto

/*
	Package v2 is a generated protocol buffer package.

	It is generated from these files:
		envoy/api/v2/cds.proto
		envoy/api/v2/discovery.proto
		envoy/api/v2/eds.proto
		envoy/api/v2/lds.proto
		envoy/api/v2/rds.proto

	It has these top-level messages:
		Cluster
		UpstreamBindConfig
		DiscoveryRequest
		DiscoveryResponse
		ClusterLoadAssignment
		Listener
		RouteConfiguration
*/
package v2

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import envoy_api_v2_core "github.com/envoyproxy/go-control-plane/envoy/api/v2/core"
import envoy_api_v2_auth "github.com/envoyproxy/go-control-plane/envoy/api/v2/auth"
import envoy_api_v2_core1 "github.com/envoyproxy/go-control-plane/envoy/api/v2/core"
import envoy_api_v2_core3 "github.com/envoyproxy/go-control-plane/envoy/api/v2/core"
import envoy_api_v2_core4 "github.com/envoyproxy/go-control-plane/envoy/api/v2/core"
import envoy_api_v2_core5 "github.com/envoyproxy/go-control-plane/envoy/api/v2/core"
import envoy_api_v2_cluster "github.com/envoyproxy/go-control-plane/envoy/api/v2/cluster"
import envoy_api_v2_cluster1 "github.com/envoyproxy/go-control-plane/envoy/api/v2/cluster"
import envoy_type "github.com/envoyproxy/go-control-plane/envoy/type"
import _ "github.com/gogo/googleapis/google/api"
import _ "github.com/gogo/protobuf/types"
import google_protobuf4 "github.com/gogo/protobuf/types"
import google_protobuf "github.com/gogo/protobuf/types"
import _ "github.com/lyft/protoc-gen-validate/validate"
import _ "github.com/gogo/protobuf/gogoproto"

import time "time"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

import github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Refer to :ref:`service discovery type <arch_overview_service_discovery_types>`
// for an explanation on each type.
type Cluster_DiscoveryType int32

const (
	// Refer to the :ref:`static discovery type<arch_overview_service_discovery_types_static>`
	// for an explanation.
	Cluster_STATIC Cluster_DiscoveryType = 0
	// Refer to the :ref:`strict DNS discovery
	// type<arch_overview_service_discovery_types_strict_dns>`
	// for an explanation.
	Cluster_STRICT_DNS Cluster_DiscoveryType = 1
	// Refer to the :ref:`logical DNS discovery
	// type<arch_overview_service_discovery_types_logical_dns>`
	// for an explanation.
	Cluster_LOGICAL_DNS Cluster_DiscoveryType = 2
	// Refer to the :ref:`service discovery type<arch_overview_service_discovery_types_sds>`
	// for an explanation.
	Cluster_EDS Cluster_DiscoveryType = 3
	// Refer to the :ref:`original destination discovery
	// type<arch_overview_service_discovery_types_original_destination>`
	// for an explanation.
	Cluster_ORIGINAL_DST Cluster_DiscoveryType = 4
)

var Cluster_DiscoveryType_name = map[int32]string{
	0: "STATIC",
	1: "STRICT_DNS",
	2: "LOGICAL_DNS",
	3: "EDS",
	4: "ORIGINAL_DST",
}
var Cluster_DiscoveryType_value = map[string]int32{
	"STATIC":       0,
	"STRICT_DNS":   1,
	"LOGICAL_DNS":  2,
	"EDS":          3,
	"ORIGINAL_DST": 4,
}

func (x Cluster_DiscoveryType) String() string {
	return proto.EnumName(Cluster_DiscoveryType_name, int32(x))
}
func (Cluster_DiscoveryType) EnumDescriptor() ([]byte, []int) { return fileDescriptorCds, []int{0, 0} }

// Refer to :ref:`load balancer type <arch_overview_load_balancing_types>` architecture
// overview section for information on each type.
type Cluster_LbPolicy int32

const (
	// Refer to the :ref:`round robin load balancing
	// policy<arch_overview_load_balancing_types_round_robin>`
	// for an explanation.
	Cluster_ROUND_ROBIN Cluster_LbPolicy = 0
	// Refer to the :ref:`least request load balancing
	// policy<arch_overview_load_balancing_types_least_request>`
	// for an explanation.
	Cluster_LEAST_REQUEST Cluster_LbPolicy = 1
	// Refer to the :ref:`ring hash load balancing
	// policy<arch_overview_load_balancing_types_ring_hash>`
	// for an explanation.
	Cluster_RING_HASH Cluster_LbPolicy = 2
	// Refer to the :ref:`random load balancing
	// policy<arch_overview_load_balancing_types_random>`
	// for an explanation.
	Cluster_RANDOM Cluster_LbPolicy = 3
	// Refer to the :ref:`original destination load balancing
	// policy<arch_overview_load_balancing_types_original_destination>`
	// for an explanation.
	Cluster_ORIGINAL_DST_LB Cluster_LbPolicy = 4
	// Refer to the :ref:`Maglev load balancing policy<arch_overview_load_balancing_types_maglev>`
	// for an explanation.
	Cluster_MAGLEV Cluster_LbPolicy = 5
)

var Cluster_LbPolicy_name = map[int32]string{
	0: "ROUND_ROBIN",
	1: "LEAST_REQUEST",
	2: "RING_HASH",
	3: "RANDOM",
	4: "ORIGINAL_DST_LB",
	5: "MAGLEV",
}
var Cluster_LbPolicy_value = map[string]int32{
	"ROUND_ROBIN":     0,
	"LEAST_REQUEST":   1,
	"RING_HASH":       2,
	"RANDOM":          3,
	"ORIGINAL_DST_LB": 4,
	"MAGLEV":          5,
}

func (x Cluster_LbPolicy) String() string {
	return proto.EnumName(Cluster_LbPolicy_name, int32(x))
}
func (Cluster_LbPolicy) EnumDescriptor() ([]byte, []int) { return fileDescriptorCds, []int{0, 1} }

// When V4_ONLY is selected, the DNS resolver will only perform a lookup for
// addresses in the IPv4 family. If V6_ONLY is selected, the DNS resolver will
// only perform a lookup for addresses in the IPv6 family. If AUTO is
// specified, the DNS resolver will first perform a lookup for addresses in
// the IPv6 family and fallback to a lookup for addresses in the IPv4 family.
// For cluster types other than
// :ref:`STRICT_DNS<envoy_api_enum_value_Cluster.DiscoveryType.STRICT_DNS>` and
// :ref:`LOGICAL_DNS<envoy_api_enum_value_Cluster.DiscoveryType.LOGICAL_DNS>`,
// this setting is
// ignored.
type Cluster_DnsLookupFamily int32

const (
	Cluster_AUTO    Cluster_DnsLookupFamily = 0
	Cluster_V4_ONLY Cluster_DnsLookupFamily = 1
	Cluster_V6_ONLY Cluster_DnsLookupFamily = 2
)

var Cluster_DnsLookupFamily_name = map[int32]string{
	0: "AUTO",
	1: "V4_ONLY",
	2: "V6_ONLY",
}
var Cluster_DnsLookupFamily_value = map[string]int32{
	"AUTO":    0,
	"V4_ONLY": 1,
	"V6_ONLY": 2,
}

func (x Cluster_DnsLookupFamily) String() string {
	return proto.EnumName(Cluster_DnsLookupFamily_name, int32(x))
}
func (Cluster_DnsLookupFamily) EnumDescriptor() ([]byte, []int) { return fileDescriptorCds, []int{0, 2} }

type Cluster_ClusterProtocolSelection int32

const (
	// Cluster can only operate on one of the possible upstream protocols (HTTP1.1, HTTP2).
	// If :ref:`http2_protocol_options <envoy_api_field_Cluster.http2_protocol_options>` are
	// present, HTTP2 will be used, otherwise HTTP1.1 will be used.
	Cluster_USE_CONFIGURED_PROTOCOL Cluster_ClusterProtocolSelection = 0
	// Use HTTP1.1 or HTTP2, depending on which one is used on the downstream connection.
	Cluster_USE_DOWNSTREAM_PROTOCOL Cluster_ClusterProtocolSelection = 1
)

var Cluster_ClusterProtocolSelection_name = map[int32]string{
	0: "USE_CONFIGURED_PROTOCOL",
	1: "USE_DOWNSTREAM_PROTOCOL",
}
var Cluster_ClusterProtocolSelection_value = map[string]int32{
	"USE_CONFIGURED_PROTOCOL": 0,
	"USE_DOWNSTREAM_PROTOCOL": 1,
}

func (x Cluster_ClusterProtocolSelection) String() string {
	return proto.EnumName(Cluster_ClusterProtocolSelection_name, int32(x))
}
func (Cluster_ClusterProtocolSelection) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorCds, []int{0, 3}
}

// If NO_FALLBACK is selected, a result
// equivalent to no healthy hosts is reported. If ANY_ENDPOINT is selected,
// any cluster endpoint may be returned (subject to policy, health checks,
// etc). If DEFAULT_SUBSET is selected, load balancing is performed over the
// endpoints matching the values from the default_subset field.
type Cluster_LbSubsetConfig_LbSubsetFallbackPolicy int32

const (
	Cluster_LbSubsetConfig_NO_FALLBACK    Cluster_LbSubsetConfig_LbSubsetFallbackPolicy = 0
	Cluster_LbSubsetConfig_ANY_ENDPOINT   Cluster_LbSubsetConfig_LbSubsetFallbackPolicy = 1
	Cluster_LbSubsetConfig_DEFAULT_SUBSET Cluster_LbSubsetConfig_LbSubsetFallbackPolicy = 2
)

var Cluster_LbSubsetConfig_LbSubsetFallbackPolicy_name = map[int32]string{
	0: "NO_FALLBACK",
	1: "ANY_ENDPOINT",
	2: "DEFAULT_SUBSET",
}
var Cluster_LbSubsetConfig_LbSubsetFallbackPolicy_value = map[string]int32{
	"NO_FALLBACK":    0,
	"ANY_ENDPOINT":   1,
	"DEFAULT_SUBSET": 2,
}

func (x Cluster_LbSubsetConfig_LbSubsetFallbackPolicy) String() string {
	return proto.EnumName(Cluster_LbSubsetConfig_LbSubsetFallbackPolicy_name, int32(x))
}
func (Cluster_LbSubsetConfig_LbSubsetFallbackPolicy) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorCds, []int{0, 1, 0}
}

// Configuration for a single upstream cluster.
// [#comment:next free field: 30]
type Cluster struct {
	// Supplies the name of the cluster which must be unique across all clusters.
	// The cluster name is used when emitting
	// :ref:`statistics <config_cluster_manager_cluster_stats>` if :ref:`alt_stat_name
	// <envoy_api_field_Cluster.alt_stat_name>` is not provided.
	// Any ``:`` in the cluster name will be converted to ``_`` when emitting statistics.
	// By default, the maximum length of a cluster name is limited to 60
	// characters. This limit can be increased by setting the
	// :option:`--max-obj-name-len` command line argument to the desired value.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// An optional alternative to the cluster name to be used while emitting stats.
	// Any ``:`` in the name will be converted to ``_`` when emitting statistics. This should not be
	// confused with :ref:`Router Filter Header
	// <config_http_filters_router_x-envoy-upstream-alt-stat-name>`.
	AltStatName string `protobuf:"bytes,28,opt,name=alt_stat_name,json=altStatName,proto3" json:"alt_stat_name,omitempty"`
	// The :ref:`service discovery type <arch_overview_service_discovery_types>`
	// to use for resolving the cluster.
	Type Cluster_DiscoveryType `protobuf:"varint,2,opt,name=type,proto3,enum=envoy.api.v2.Cluster_DiscoveryType" json:"type,omitempty"`
	// Configuration to use for EDS updates for the Cluster.
	EdsClusterConfig *Cluster_EdsClusterConfig `protobuf:"bytes,3,opt,name=eds_cluster_config,json=edsClusterConfig" json:"eds_cluster_config,omitempty"`
	// The timeout for new network connections to hosts in the cluster.
	ConnectTimeout time.Duration `protobuf:"bytes,4,opt,name=connect_timeout,json=connectTimeout,stdduration" json:"connect_timeout"`
	// Soft limit on size of the cluster’s connections read and write buffers. If
	// unspecified, an implementation defined default is applied (1MiB).
	PerConnectionBufferLimitBytes *google_protobuf.UInt32Value `protobuf:"bytes,5,opt,name=per_connection_buffer_limit_bytes,json=perConnectionBufferLimitBytes" json:"per_connection_buffer_limit_bytes,omitempty"`
	// The :ref:`load balancer type <arch_overview_load_balancing_types>` to use
	// when picking a host in the cluster.
	LbPolicy Cluster_LbPolicy `protobuf:"varint,6,opt,name=lb_policy,json=lbPolicy,proto3,enum=envoy.api.v2.Cluster_LbPolicy" json:"lb_policy,omitempty"`
	// If the service discovery type is
	// :ref:`STATIC<envoy_api_enum_value_Cluster.DiscoveryType.STATIC>`,
	// :ref:`STRICT_DNS<envoy_api_enum_value_Cluster.DiscoveryType.STRICT_DNS>`
	// or :ref:`LOGICAL_DNS<envoy_api_enum_value_Cluster.DiscoveryType.LOGICAL_DNS>`,
	// then hosts is required.
	Hosts []*envoy_api_v2_core.Address `protobuf:"bytes,7,rep,name=hosts" json:"hosts,omitempty"`
	// Optional :ref:`active health checking <arch_overview_health_checking>`
	// configuration for the cluster. If no
	// configuration is specified no health checking will be done and all cluster
	// members will be considered healthy at all times.
	HealthChecks []*envoy_api_v2_core4.HealthCheck `protobuf:"bytes,8,rep,name=health_checks,json=healthChecks" json:"health_checks,omitempty"`
	// Optional maximum requests for a single upstream connection. This parameter
	// is respected by both the HTTP/1.1 and HTTP/2 connection pool
	// implementations. If not specified, there is no limit. Setting this
	// parameter to 1 will effectively disable keep alive.
	MaxRequestsPerConnection *google_protobuf.UInt32Value `protobuf:"bytes,9,opt,name=max_requests_per_connection,json=maxRequestsPerConnection" json:"max_requests_per_connection,omitempty"`
	// Optional :ref:`circuit breaking <arch_overview_circuit_break>` for the cluster.
	CircuitBreakers *envoy_api_v2_cluster.CircuitBreakers `protobuf:"bytes,10,opt,name=circuit_breakers,json=circuitBreakers" json:"circuit_breakers,omitempty"`
	// The TLS configuration for connections to the upstream cluster. If no TLS
	// configuration is specified, TLS will not be used for new connections.
	//
	// .. attention::
	//
	//   Server certificate verification is not enabled by default. Configure
	//   :ref:`trusted_ca<envoy_api_field_auth.CertificateValidationContext.trusted_ca>` to enable
	//   verification.
	TlsContext *envoy_api_v2_auth.UpstreamTlsContext `protobuf:"bytes,11,opt,name=tls_context,json=tlsContext" json:"tls_context,omitempty"`
	// Additional options when handling HTTP requests. These options will be applicable to both
	// HTTP1 and HTTP2 requests.
	CommonHttpProtocolOptions *envoy_api_v2_core5.HttpProtocolOptions `protobuf:"bytes,29,opt,name=common_http_protocol_options,json=commonHttpProtocolOptions" json:"common_http_protocol_options,omitempty"`
	// Additional options when handling HTTP1 requests.
	HttpProtocolOptions *envoy_api_v2_core5.Http1ProtocolOptions `protobuf:"bytes,13,opt,name=http_protocol_options,json=httpProtocolOptions" json:"http_protocol_options,omitempty"`
	// Even if default HTTP2 protocol options are desired, this field must be
	// set so that Envoy will assume that the upstream supports HTTP/2 when
	// making new HTTP connection pool connections. Currently, Envoy only
	// supports prior knowledge for upstream connections. Even if TLS is used
	// with ALPN, `http2_protocol_options` must be specified. As an aside this allows HTTP/2
	// connections to happen over plain text.
	Http2ProtocolOptions *envoy_api_v2_core5.Http2ProtocolOptions `protobuf:"bytes,14,opt,name=http2_protocol_options,json=http2ProtocolOptions" json:"http2_protocol_options,omitempty"`
	// If the DNS refresh rate is specified and the cluster type is either
	// :ref:`STRICT_DNS<envoy_api_enum_value_Cluster.DiscoveryType.STRICT_DNS>`,
	// or :ref:`LOGICAL_DNS<envoy_api_enum_value_Cluster.DiscoveryType.LOGICAL_DNS>`,
	// this value is used as the cluster’s DNS refresh
	// rate. If this setting is not specified, the value defaults to 5000. For
	// cluster types other than
	// :ref:`STRICT_DNS<envoy_api_enum_value_Cluster.DiscoveryType.STRICT_DNS>`
	// and :ref:`LOGICAL_DNS<envoy_api_enum_value_Cluster.DiscoveryType.LOGICAL_DNS>`
	// this setting is ignored.
	DnsRefreshRate *time.Duration `protobuf:"bytes,16,opt,name=dns_refresh_rate,json=dnsRefreshRate,stdduration" json:"dns_refresh_rate,omitempty"`
	// The DNS IP address resolution policy. If this setting is not specified, the
	// value defaults to
	// :ref:`AUTO<envoy_api_enum_value_Cluster.DnsLookupFamily.AUTO>`.
	DnsLookupFamily Cluster_DnsLookupFamily `protobuf:"varint,17,opt,name=dns_lookup_family,json=dnsLookupFamily,proto3,enum=envoy.api.v2.Cluster_DnsLookupFamily" json:"dns_lookup_family,omitempty"`
	// If DNS resolvers are specified and the cluster type is either
	// :ref:`STRICT_DNS<envoy_api_enum_value_Cluster.DiscoveryType.STRICT_DNS>`,
	// or :ref:`LOGICAL_DNS<envoy_api_enum_value_Cluster.DiscoveryType.LOGICAL_DNS>`,
	// this value is used to specify the cluster’s dns resolvers.
	// If this setting is not specified, the value defaults to the default
	// resolver, which uses /etc/resolv.conf for configuration. For cluster types
	// other than
	// :ref:`STRICT_DNS<envoy_api_enum_value_Cluster.DiscoveryType.STRICT_DNS>`
	// and :ref:`LOGICAL_DNS<envoy_api_enum_value_Cluster.DiscoveryType.LOGICAL_DNS>`
	// this setting is ignored.
	DnsResolvers []*envoy_api_v2_core.Address `protobuf:"bytes,18,rep,name=dns_resolvers,json=dnsResolvers" json:"dns_resolvers,omitempty"`
	// If specified, outlier detection will be enabled for this upstream cluster.
	// Each of the configuration values can be overridden via
	// :ref:`runtime values <config_cluster_manager_cluster_runtime_outlier_detection>`.
	OutlierDetection *envoy_api_v2_cluster1.OutlierDetection `protobuf:"bytes,19,opt,name=outlier_detection,json=outlierDetection" json:"outlier_detection,omitempty"`
	// The interval for removing stale hosts from a cluster type
	// :ref:`ORIGINAL_DST<envoy_api_enum_value_Cluster.DiscoveryType.ORIGINAL_DST>`.
	// Hosts are considered stale if they have not been used
	// as upstream destinations during this interval. New hosts are added
	// to original destination clusters on demand as new connections are
	// redirected to Envoy, causing the number of hosts in the cluster to
	// grow over time. Hosts that are not stale (they are actively used as
	// destinations) are kept in the cluster, which allows connections to
	// them remain open, saving the latency that would otherwise be spent
	// on opening new connections. If this setting is not specified, the
	// value defaults to 5000ms. For cluster types other than
	// :ref:`ORIGINAL_DST<envoy_api_enum_value_Cluster.DiscoveryType.ORIGINAL_DST>`
	// this setting is ignored.
	CleanupInterval *time.Duration `protobuf:"bytes,20,opt,name=cleanup_interval,json=cleanupInterval,stdduration" json:"cleanup_interval,omitempty"`
	// Optional configuration used to bind newly established upstream connections.
	// This overrides any bind_config specified in the bootstrap proto.
	// If the address and port are empty, no bind will be performed.
	UpstreamBindConfig *envoy_api_v2_core.BindConfig `protobuf:"bytes,21,opt,name=upstream_bind_config,json=upstreamBindConfig" json:"upstream_bind_config,omitempty"`
	// Configuration for load balancing subsetting.
	LbSubsetConfig *Cluster_LbSubsetConfig `protobuf:"bytes,22,opt,name=lb_subset_config,json=lbSubsetConfig" json:"lb_subset_config,omitempty"`
	// Optional configuration for the load balancing algorithm selected by
	// LbPolicy. Currently only
	// :ref:`RING_HASH<envoy_api_enum_value_Cluster.LbPolicy.RING_HASH>`
	// has additional configuration options.
	// Specifying ring_hash_lb_config without setting the LbPolicy to
	// :ref:`RING_HASH<envoy_api_enum_value_Cluster.LbPolicy.RING_HASH>`
	// will generate an error at runtime.
	//
	// Types that are valid to be assigned to LbConfig:
	//	*Cluster_RingHashLbConfig_
	LbConfig isCluster_LbConfig `protobuf_oneof:"lb_config"`
	// Common configuration for all load balancer implementations.
	CommonLbConfig *Cluster_CommonLbConfig `protobuf:"bytes,27,opt,name=common_lb_config,json=commonLbConfig" json:"common_lb_config,omitempty"`
	// Optional custom transport socket implementation to use for upstream connections.
	TransportSocket *envoy_api_v2_core1.TransportSocket `protobuf:"bytes,24,opt,name=transport_socket,json=transportSocket" json:"transport_socket,omitempty"`
	// The Metadata field can be used to provide additional information about the
	// cluster. It can be used for stats, logging, and varying filter behavior.
	// Fields should use reverse DNS notation to denote which entity within Envoy
	// will need the information. For instance, if the metadata is intended for
	// the Router filter, the filter name should be specified as *envoy.router*.
	Metadata *envoy_api_v2_core1.Metadata `protobuf:"bytes,25,opt,name=metadata" json:"metadata,omitempty"`
	// Determines how Envoy selects the protocol used to speak to upstream hosts.
	ProtocolSelection Cluster_ClusterProtocolSelection `protobuf:"varint,26,opt,name=protocol_selection,json=protocolSelection,proto3,enum=envoy.api.v2.Cluster_ClusterProtocolSelection" json:"protocol_selection,omitempty"`
}

func (m *Cluster) Reset()                    { *m = Cluster{} }
func (m *Cluster) String() string            { return proto.CompactTextString(m) }
func (*Cluster) ProtoMessage()               {}
func (*Cluster) Descriptor() ([]byte, []int) { return fileDescriptorCds, []int{0} }

type isCluster_LbConfig interface {
	isCluster_LbConfig()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type Cluster_RingHashLbConfig_ struct {
	RingHashLbConfig *Cluster_RingHashLbConfig `protobuf:"bytes,23,opt,name=ring_hash_lb_config,json=ringHashLbConfig,oneof"`
}

func (*Cluster_RingHashLbConfig_) isCluster_LbConfig() {}

func (m *Cluster) GetLbConfig() isCluster_LbConfig {
	if m != nil {
		return m.LbConfig
	}
	return nil
}

func (m *Cluster) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Cluster) GetAltStatName() string {
	if m != nil {
		return m.AltStatName
	}
	return ""
}

func (m *Cluster) GetType() Cluster_DiscoveryType {
	if m != nil {
		return m.Type
	}
	return Cluster_STATIC
}

func (m *Cluster) GetEdsClusterConfig() *Cluster_EdsClusterConfig {
	if m != nil {
		return m.EdsClusterConfig
	}
	return nil
}

func (m *Cluster) GetConnectTimeout() time.Duration {
	if m != nil {
		return m.ConnectTimeout
	}
	return 0
}

func (m *Cluster) GetPerConnectionBufferLimitBytes() *google_protobuf.UInt32Value {
	if m != nil {
		return m.PerConnectionBufferLimitBytes
	}
	return nil
}

func (m *Cluster) GetLbPolicy() Cluster_LbPolicy {
	if m != nil {
		return m.LbPolicy
	}
	return Cluster_ROUND_ROBIN
}

func (m *Cluster) GetHosts() []*envoy_api_v2_core.Address {
	if m != nil {
		return m.Hosts
	}
	return nil
}

func (m *Cluster) GetHealthChecks() []*envoy_api_v2_core4.HealthCheck {
	if m != nil {
		return m.HealthChecks
	}
	return nil
}

func (m *Cluster) GetMaxRequestsPerConnection() *google_protobuf.UInt32Value {
	if m != nil {
		return m.MaxRequestsPerConnection
	}
	return nil
}

func (m *Cluster) GetCircuitBreakers() *envoy_api_v2_cluster.CircuitBreakers {
	if m != nil {
		return m.CircuitBreakers
	}
	return nil
}

func (m *Cluster) GetTlsContext() *envoy_api_v2_auth.UpstreamTlsContext {
	if m != nil {
		return m.TlsContext
	}
	return nil
}

func (m *Cluster) GetCommonHttpProtocolOptions() *envoy_api_v2_core5.HttpProtocolOptions {
	if m != nil {
		return m.CommonHttpProtocolOptions
	}
	return nil
}

func (m *Cluster) GetHttpProtocolOptions() *envoy_api_v2_core5.Http1ProtocolOptions {
	if m != nil {
		return m.HttpProtocolOptions
	}
	return nil
}

func (m *Cluster) GetHttp2ProtocolOptions() *envoy_api_v2_core5.Http2ProtocolOptions {
	if m != nil {
		return m.Http2ProtocolOptions
	}
	return nil
}

func (m *Cluster) GetDnsRefreshRate() *time.Duration {
	if m != nil {
		return m.DnsRefreshRate
	}
	return nil
}

func (m *Cluster) GetDnsLookupFamily() Cluster_DnsLookupFamily {
	if m != nil {
		return m.DnsLookupFamily
	}
	return Cluster_AUTO
}

func (m *Cluster) GetDnsResolvers() []*envoy_api_v2_core.Address {
	if m != nil {
		return m.DnsResolvers
	}
	return nil
}

func (m *Cluster) GetOutlierDetection() *envoy_api_v2_cluster1.OutlierDetection {
	if m != nil {
		return m.OutlierDetection
	}
	return nil
}

func (m *Cluster) GetCleanupInterval() *time.Duration {
	if m != nil {
		return m.CleanupInterval
	}
	return nil
}

func (m *Cluster) GetUpstreamBindConfig() *envoy_api_v2_core.BindConfig {
	if m != nil {
		return m.UpstreamBindConfig
	}
	return nil
}

func (m *Cluster) GetLbSubsetConfig() *Cluster_LbSubsetConfig {
	if m != nil {
		return m.LbSubsetConfig
	}
	return nil
}

func (m *Cluster) GetRingHashLbConfig() *Cluster_RingHashLbConfig {
	if x, ok := m.GetLbConfig().(*Cluster_RingHashLbConfig_); ok {
		return x.RingHashLbConfig
	}
	return nil
}

func (m *Cluster) GetCommonLbConfig() *Cluster_CommonLbConfig {
	if m != nil {
		return m.CommonLbConfig
	}
	return nil
}

func (m *Cluster) GetTransportSocket() *envoy_api_v2_core1.TransportSocket {
	if m != nil {
		return m.TransportSocket
	}
	return nil
}

func (m *Cluster) GetMetadata() *envoy_api_v2_core1.Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *Cluster) GetProtocolSelection() Cluster_ClusterProtocolSelection {
	if m != nil {
		return m.ProtocolSelection
	}
	return Cluster_USE_CONFIGURED_PROTOCOL
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Cluster) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Cluster_OneofMarshaler, _Cluster_OneofUnmarshaler, _Cluster_OneofSizer, []interface{}{
		(*Cluster_RingHashLbConfig_)(nil),
	}
}

func _Cluster_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Cluster)
	// lb_config
	switch x := m.LbConfig.(type) {
	case *Cluster_RingHashLbConfig_:
		_ = b.EncodeVarint(23<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RingHashLbConfig); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Cluster.LbConfig has unexpected type %T", x)
	}
	return nil
}

func _Cluster_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Cluster)
	switch tag {
	case 23: // lb_config.ring_hash_lb_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Cluster_RingHashLbConfig)
		err := b.DecodeMessage(msg)
		m.LbConfig = &Cluster_RingHashLbConfig_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Cluster_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Cluster)
	// lb_config
	switch x := m.LbConfig.(type) {
	case *Cluster_RingHashLbConfig_:
		s := proto.Size(x.RingHashLbConfig)
		n += proto.SizeVarint(23<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Only valid when discovery type is EDS.
type Cluster_EdsClusterConfig struct {
	// Configuration for the source of EDS updates for this Cluster.
	EdsConfig *envoy_api_v2_core3.ConfigSource `protobuf:"bytes,1,opt,name=eds_config,json=edsConfig" json:"eds_config,omitempty"`
	// Optional alternative to cluster name to present to EDS. This does not
	// have the same restrictions as cluster name, i.e. it may be arbitrary
	// length.
	ServiceName string `protobuf:"bytes,2,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
}

func (m *Cluster_EdsClusterConfig) Reset()                    { *m = Cluster_EdsClusterConfig{} }
func (m *Cluster_EdsClusterConfig) String() string            { return proto.CompactTextString(m) }
func (*Cluster_EdsClusterConfig) ProtoMessage()               {}
func (*Cluster_EdsClusterConfig) Descriptor() ([]byte, []int) { return fileDescriptorCds, []int{0, 0} }

func (m *Cluster_EdsClusterConfig) GetEdsConfig() *envoy_api_v2_core3.ConfigSource {
	if m != nil {
		return m.EdsConfig
	}
	return nil
}

func (m *Cluster_EdsClusterConfig) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

// Optionally divide the endpoints in this cluster into subsets defined by
// endpoint metadata and selected by route and weighted cluster metadata.
type Cluster_LbSubsetConfig struct {
	// The behavior used when no endpoint subset matches the selected route's
	// metadata. The value defaults to
	// :ref:`NO_FALLBACK<envoy_api_enum_value_Cluster.LbSubsetConfig.LbSubsetFallbackPolicy.NO_FALLBACK>`.
	FallbackPolicy Cluster_LbSubsetConfig_LbSubsetFallbackPolicy `protobuf:"varint,1,opt,name=fallback_policy,json=fallbackPolicy,proto3,enum=envoy.api.v2.Cluster_LbSubsetConfig_LbSubsetFallbackPolicy" json:"fallback_policy,omitempty"`
	// Specifies the default subset of endpoints used during fallback if
	// fallback_policy is
	// :ref:`DEFAULT_SUBSET<envoy_api_enum_value_Cluster.LbSubsetConfig.LbSubsetFallbackPolicy.DEFAULT_SUBSET>`.
	// Each field in default_subset is
	// compared to the matching LbEndpoint.Metadata under the *envoy.lb*
	// namespace. It is valid for no hosts to match, in which case the behavior
	// is the same as a fallback_policy of
	// :ref:`NO_FALLBACK<envoy_api_enum_value_Cluster.LbSubsetConfig.LbSubsetFallbackPolicy.NO_FALLBACK>`.
	DefaultSubset *google_protobuf4.Struct `protobuf:"bytes,2,opt,name=default_subset,json=defaultSubset" json:"default_subset,omitempty"`
	// For each entry, LbEndpoint.Metadata's
	// *envoy.lb* namespace is traversed and a subset is created for each unique
	// combination of key and value. For example:
	//
	// .. code-block:: json
	//
	//   { "subset_selectors": [
	//       { "keys": [ "version" ] },
	//       { "keys": [ "stage", "hardware_type" ] }
	//   ]}
	//
	// A subset is matched when the metadata from the selected route and
	// weighted cluster contains the same keys and values as the subset's
	// metadata. The same host may appear in multiple subsets.
	SubsetSelectors []*Cluster_LbSubsetConfig_LbSubsetSelector `protobuf:"bytes,3,rep,name=subset_selectors,json=subsetSelectors" json:"subset_selectors,omitempty"`
}

func (m *Cluster_LbSubsetConfig) Reset()                    { *m = Cluster_LbSubsetConfig{} }
func (m *Cluster_LbSubsetConfig) String() string            { return proto.CompactTextString(m) }
func (*Cluster_LbSubsetConfig) ProtoMessage()               {}
func (*Cluster_LbSubsetConfig) Descriptor() ([]byte, []int) { return fileDescriptorCds, []int{0, 1} }

func (m *Cluster_LbSubsetConfig) GetFallbackPolicy() Cluster_LbSubsetConfig_LbSubsetFallbackPolicy {
	if m != nil {
		return m.FallbackPolicy
	}
	return Cluster_LbSubsetConfig_NO_FALLBACK
}

func (m *Cluster_LbSubsetConfig) GetDefaultSubset() *google_protobuf4.Struct {
	if m != nil {
		return m.DefaultSubset
	}
	return nil
}

func (m *Cluster_LbSubsetConfig) GetSubsetSelectors() []*Cluster_LbSubsetConfig_LbSubsetSelector {
	if m != nil {
		return m.SubsetSelectors
	}
	return nil
}

// Specifications for subsets.
type Cluster_LbSubsetConfig_LbSubsetSelector struct {
	// List of keys to match with the weighted cluster metadata.
	Keys []string `protobuf:"bytes,1,rep,name=keys" json:"keys,omitempty"`
}

func (m *Cluster_LbSubsetConfig_LbSubsetSelector) Reset() {
	*m = Cluster_LbSubsetConfig_LbSubsetSelector{}
}
func (m *Cluster_LbSubsetConfig_LbSubsetSelector) String() string { return proto.CompactTextString(m) }
func (*Cluster_LbSubsetConfig_LbSubsetSelector) ProtoMessage()    {}
func (*Cluster_LbSubsetConfig_LbSubsetSelector) Descriptor() ([]byte, []int) {
	return fileDescriptorCds, []int{0, 1, 0}
}

func (m *Cluster_LbSubsetConfig_LbSubsetSelector) GetKeys() []string {
	if m != nil {
		return m.Keys
	}
	return nil
}

// Specific configuration for the :ref:`RingHash<arch_overview_load_balancing_types_ring_hash>`
// load balancing policy.
type Cluster_RingHashLbConfig struct {
	// Minimum hash ring size, i.e. total virtual nodes. A larger size
	// will provide better request distribution since each host in the
	// cluster will have more virtual nodes. Defaults to 1024. In the case
	// that total number of hosts is greater than the minimum, each host will
	// be allocated a single virtual node.
	MinimumRingSize *google_protobuf.UInt64Value `protobuf:"bytes,1,opt,name=minimum_ring_size,json=minimumRingSize" json:"minimum_ring_size,omitempty"`
	// Deprecated settings from v1 config.
	// [#not-implemented-hide:] Hide from docs.
	DeprecatedV1 *Cluster_RingHashLbConfig_DeprecatedV1 `protobuf:"bytes,2,opt,name=deprecated_v1,json=deprecatedV1" json:"deprecated_v1,omitempty"`
}

func (m *Cluster_RingHashLbConfig) Reset()                    { *m = Cluster_RingHashLbConfig{} }
func (m *Cluster_RingHashLbConfig) String() string            { return proto.CompactTextString(m) }
func (*Cluster_RingHashLbConfig) ProtoMessage()               {}
func (*Cluster_RingHashLbConfig) Descriptor() ([]byte, []int) { return fileDescriptorCds, []int{0, 2} }

func (m *Cluster_RingHashLbConfig) GetMinimumRingSize() *google_protobuf.UInt64Value {
	if m != nil {
		return m.MinimumRingSize
	}
	return nil
}

func (m *Cluster_RingHashLbConfig) GetDeprecatedV1() *Cluster_RingHashLbConfig_DeprecatedV1 {
	if m != nil {
		return m.DeprecatedV1
	}
	return nil
}

// [#not-implemented-hide:] Hide from docs.
type Cluster_RingHashLbConfig_DeprecatedV1 struct {
	// Defaults to true, meaning that std::hash is used to hash hosts onto
	// the ketama ring. std::hash can vary by platform. For this reason,
	// Envoy will eventually use `xxHash <https://github.com/Cyan4973/xxHash>`_
	// by default. This field exists for
	// migration purposes and will eventually be deprecated. Set it to false
	// to use `xxHash <https://github.com/Cyan4973/xxHash>`_ now.
	UseStdHash *google_protobuf.BoolValue `protobuf:"bytes,1,opt,name=use_std_hash,json=useStdHash" json:"use_std_hash,omitempty"`
}

func (m *Cluster_RingHashLbConfig_DeprecatedV1) Reset()         { *m = Cluster_RingHashLbConfig_DeprecatedV1{} }
func (m *Cluster_RingHashLbConfig_DeprecatedV1) String() string { return proto.CompactTextString(m) }
func (*Cluster_RingHashLbConfig_DeprecatedV1) ProtoMessage()    {}
func (*Cluster_RingHashLbConfig_DeprecatedV1) Descriptor() ([]byte, []int) {
	return fileDescriptorCds, []int{0, 2, 0}
}

func (m *Cluster_RingHashLbConfig_DeprecatedV1) GetUseStdHash() *google_protobuf.BoolValue {
	if m != nil {
		return m.UseStdHash
	}
	return nil
}

// Common configuration for all load balancer implementations.
type Cluster_CommonLbConfig struct {
	// Configures the :ref:`healthy panic threshold <arch_overview_load_balancing_panic_threshold>`.
	// If not specified, the default is 50%.
	//
	// .. note::
	//   The specified percent will be truncated to the nearest 1%.
	HealthyPanicThreshold *envoy_type.Percent `protobuf:"bytes,1,opt,name=healthy_panic_threshold,json=healthyPanicThreshold" json:"healthy_panic_threshold,omitempty"`
	// Types that are valid to be assigned to LocalityConfigSpecifier:
	//	*Cluster_CommonLbConfig_ZoneAwareLbConfig_
	//	*Cluster_CommonLbConfig_LocalityWeightedLbConfig_
	LocalityConfigSpecifier isCluster_CommonLbConfig_LocalityConfigSpecifier `protobuf_oneof:"locality_config_specifier"`
}

func (m *Cluster_CommonLbConfig) Reset()                    { *m = Cluster_CommonLbConfig{} }
func (m *Cluster_CommonLbConfig) String() string            { return proto.CompactTextString(m) }
func (*Cluster_CommonLbConfig) ProtoMessage()               {}
func (*Cluster_CommonLbConfig) Descriptor() ([]byte, []int) { return fileDescriptorCds, []int{0, 3} }

type isCluster_CommonLbConfig_LocalityConfigSpecifier interface {
	isCluster_CommonLbConfig_LocalityConfigSpecifier()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type Cluster_CommonLbConfig_ZoneAwareLbConfig_ struct {
	ZoneAwareLbConfig *Cluster_CommonLbConfig_ZoneAwareLbConfig `protobuf:"bytes,2,opt,name=zone_aware_lb_config,json=zoneAwareLbConfig,oneof"`
}
type Cluster_CommonLbConfig_LocalityWeightedLbConfig_ struct {
	LocalityWeightedLbConfig *Cluster_CommonLbConfig_LocalityWeightedLbConfig `protobuf:"bytes,3,opt,name=locality_weighted_lb_config,json=localityWeightedLbConfig,oneof"`
}

func (*Cluster_CommonLbConfig_ZoneAwareLbConfig_) isCluster_CommonLbConfig_LocalityConfigSpecifier() {}
func (*Cluster_CommonLbConfig_LocalityWeightedLbConfig_) isCluster_CommonLbConfig_LocalityConfigSpecifier() {
}

func (m *Cluster_CommonLbConfig) GetLocalityConfigSpecifier() isCluster_CommonLbConfig_LocalityConfigSpecifier {
	if m != nil {
		return m.LocalityConfigSpecifier
	}
	return nil
}

func (m *Cluster_CommonLbConfig) GetHealthyPanicThreshold() *envoy_type.Percent {
	if m != nil {
		return m.HealthyPanicThreshold
	}
	return nil
}

func (m *Cluster_CommonLbConfig) GetZoneAwareLbConfig() *Cluster_CommonLbConfig_ZoneAwareLbConfig {
	if x, ok := m.GetLocalityConfigSpecifier().(*Cluster_CommonLbConfig_ZoneAwareLbConfig_); ok {
		return x.ZoneAwareLbConfig
	}
	return nil
}

func (m *Cluster_CommonLbConfig) GetLocalityWeightedLbConfig() *Cluster_CommonLbConfig_LocalityWeightedLbConfig {
	if x, ok := m.GetLocalityConfigSpecifier().(*Cluster_CommonLbConfig_LocalityWeightedLbConfig_); ok {
		return x.LocalityWeightedLbConfig
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Cluster_CommonLbConfig) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Cluster_CommonLbConfig_OneofMarshaler, _Cluster_CommonLbConfig_OneofUnmarshaler, _Cluster_CommonLbConfig_OneofSizer, []interface{}{
		(*Cluster_CommonLbConfig_ZoneAwareLbConfig_)(nil),
		(*Cluster_CommonLbConfig_LocalityWeightedLbConfig_)(nil),
	}
}

func _Cluster_CommonLbConfig_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Cluster_CommonLbConfig)
	// locality_config_specifier
	switch x := m.LocalityConfigSpecifier.(type) {
	case *Cluster_CommonLbConfig_ZoneAwareLbConfig_:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ZoneAwareLbConfig); err != nil {
			return err
		}
	case *Cluster_CommonLbConfig_LocalityWeightedLbConfig_:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.LocalityWeightedLbConfig); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Cluster_CommonLbConfig.LocalityConfigSpecifier has unexpected type %T", x)
	}
	return nil
}

func _Cluster_CommonLbConfig_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Cluster_CommonLbConfig)
	switch tag {
	case 2: // locality_config_specifier.zone_aware_lb_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Cluster_CommonLbConfig_ZoneAwareLbConfig)
		err := b.DecodeMessage(msg)
		m.LocalityConfigSpecifier = &Cluster_CommonLbConfig_ZoneAwareLbConfig_{msg}
		return true, err
	case 3: // locality_config_specifier.locality_weighted_lb_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Cluster_CommonLbConfig_LocalityWeightedLbConfig)
		err := b.DecodeMessage(msg)
		m.LocalityConfigSpecifier = &Cluster_CommonLbConfig_LocalityWeightedLbConfig_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Cluster_CommonLbConfig_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Cluster_CommonLbConfig)
	// locality_config_specifier
	switch x := m.LocalityConfigSpecifier.(type) {
	case *Cluster_CommonLbConfig_ZoneAwareLbConfig_:
		s := proto.Size(x.ZoneAwareLbConfig)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Cluster_CommonLbConfig_LocalityWeightedLbConfig_:
		s := proto.Size(x.LocalityWeightedLbConfig)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Configuration for :ref:`zone aware routing
// <arch_overview_load_balancing_zone_aware_routing>`.
// [#not-implemented-hide:]
type Cluster_CommonLbConfig_ZoneAwareLbConfig struct {
	// [#not-implemented-hide:]
	// Configures percentage of requests that will be considered for zone aware routing
	// if zone aware routing is configured. If not specified, the default is 100%.
	// * :ref:`runtime values <config_cluster_manager_cluster_runtime_zone_routing>`.
	// * :ref:`Zone aware routing support <arch_overview_load_balancing_zone_aware_routing>`.
	RoutingEnabled *envoy_type.Percent `protobuf:"bytes,1,opt,name=routing_enabled,json=routingEnabled" json:"routing_enabled,omitempty"`
	// [#not-implemented-hide:]
	// Configures minimum upstream cluster size required for zone aware routing
	// If upstream cluster size is less than specified, zone aware routing is not performed
	// even if zone aware routing is configured. If not specified, the default is 6.
	// * :ref:`runtime values <config_cluster_manager_cluster_runtime_zone_routing>`.
	// * :ref:`Zone aware routing support <arch_overview_load_balancing_zone_aware_routing>`.
	MinClusterSize *google_protobuf.UInt64Value `protobuf:"bytes,2,opt,name=min_cluster_size,json=minClusterSize" json:"min_cluster_size,omitempty"`
}

func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig) Reset() {
	*m = Cluster_CommonLbConfig_ZoneAwareLbConfig{}
}
func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig) String() string { return proto.CompactTextString(m) }
func (*Cluster_CommonLbConfig_ZoneAwareLbConfig) ProtoMessage()    {}
func (*Cluster_CommonLbConfig_ZoneAwareLbConfig) Descriptor() ([]byte, []int) {
	return fileDescriptorCds, []int{0, 3, 0}
}

func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig) GetRoutingEnabled() *envoy_type.Percent {
	if m != nil {
		return m.RoutingEnabled
	}
	return nil
}

func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig) GetMinClusterSize() *google_protobuf.UInt64Value {
	if m != nil {
		return m.MinClusterSize
	}
	return nil
}

// Configuration for :ref:`locality weighted load balancing
// <arch_overview_load_balancing_locality_weighted_lb>`
type Cluster_CommonLbConfig_LocalityWeightedLbConfig struct {
}

func (m *Cluster_CommonLbConfig_LocalityWeightedLbConfig) Reset() {
	*m = Cluster_CommonLbConfig_LocalityWeightedLbConfig{}
}
func (m *Cluster_CommonLbConfig_LocalityWeightedLbConfig) String() string {
	return proto.CompactTextString(m)
}
func (*Cluster_CommonLbConfig_LocalityWeightedLbConfig) ProtoMessage() {}
func (*Cluster_CommonLbConfig_LocalityWeightedLbConfig) Descriptor() ([]byte, []int) {
	return fileDescriptorCds, []int{0, 3, 1}
}

// An extensible structure containing the address Envoy should bind to when
// establishing upstream connections.
type UpstreamBindConfig struct {
	// The address Envoy should bind to when establishing upstream connections.
	SourceAddress *envoy_api_v2_core.Address `protobuf:"bytes,1,opt,name=source_address,json=sourceAddress" json:"source_address,omitempty"`
}

func (m *UpstreamBindConfig) Reset()                    { *m = UpstreamBindConfig{} }
func (m *UpstreamBindConfig) String() string            { return proto.CompactTextString(m) }
func (*UpstreamBindConfig) ProtoMessage()               {}
func (*UpstreamBindConfig) Descriptor() ([]byte, []int) { return fileDescriptorCds, []int{1} }

func (m *UpstreamBindConfig) GetSourceAddress() *envoy_api_v2_core.Address {
	if m != nil {
		return m.SourceAddress
	}
	return nil
}

func init() {
	proto.RegisterType((*Cluster)(nil), "envoy.api.v2.Cluster")
	proto.RegisterType((*Cluster_EdsClusterConfig)(nil), "envoy.api.v2.Cluster.EdsClusterConfig")
	proto.RegisterType((*Cluster_LbSubsetConfig)(nil), "envoy.api.v2.Cluster.LbSubsetConfig")
	proto.RegisterType((*Cluster_LbSubsetConfig_LbSubsetSelector)(nil), "envoy.api.v2.Cluster.LbSubsetConfig.LbSubsetSelector")
	proto.RegisterType((*Cluster_RingHashLbConfig)(nil), "envoy.api.v2.Cluster.RingHashLbConfig")
	proto.RegisterType((*Cluster_RingHashLbConfig_DeprecatedV1)(nil), "envoy.api.v2.Cluster.RingHashLbConfig.DeprecatedV1")
	proto.RegisterType((*Cluster_CommonLbConfig)(nil), "envoy.api.v2.Cluster.CommonLbConfig")
	proto.RegisterType((*Cluster_CommonLbConfig_ZoneAwareLbConfig)(nil), "envoy.api.v2.Cluster.CommonLbConfig.ZoneAwareLbConfig")
	proto.RegisterType((*Cluster_CommonLbConfig_LocalityWeightedLbConfig)(nil), "envoy.api.v2.Cluster.CommonLbConfig.LocalityWeightedLbConfig")
	proto.RegisterType((*UpstreamBindConfig)(nil), "envoy.api.v2.UpstreamBindConfig")
	proto.RegisterEnum("envoy.api.v2.Cluster_DiscoveryType", Cluster_DiscoveryType_name, Cluster_DiscoveryType_value)
	proto.RegisterEnum("envoy.api.v2.Cluster_LbPolicy", Cluster_LbPolicy_name, Cluster_LbPolicy_value)
	proto.RegisterEnum("envoy.api.v2.Cluster_DnsLookupFamily", Cluster_DnsLookupFamily_name, Cluster_DnsLookupFamily_value)
	proto.RegisterEnum("envoy.api.v2.Cluster_ClusterProtocolSelection", Cluster_ClusterProtocolSelection_name, Cluster_ClusterProtocolSelection_value)
	proto.RegisterEnum("envoy.api.v2.Cluster_LbSubsetConfig_LbSubsetFallbackPolicy", Cluster_LbSubsetConfig_LbSubsetFallbackPolicy_name, Cluster_LbSubsetConfig_LbSubsetFallbackPolicy_value)
}
func (this *Cluster) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Cluster)
	if !ok {
		that2, ok := that.(Cluster)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if this.AltStatName != that1.AltStatName {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if !this.EdsClusterConfig.Equal(that1.EdsClusterConfig) {
		return false
	}
	if this.ConnectTimeout != that1.ConnectTimeout {
		return false
	}
	if !this.PerConnectionBufferLimitBytes.Equal(that1.PerConnectionBufferLimitBytes) {
		return false
	}
	if this.LbPolicy != that1.LbPolicy {
		return false
	}
	if len(this.Hosts) != len(that1.Hosts) {
		return false
	}
	for i := range this.Hosts {
		if !this.Hosts[i].Equal(that1.Hosts[i]) {
			return false
		}
	}
	if len(this.HealthChecks) != len(that1.HealthChecks) {
		return false
	}
	for i := range this.HealthChecks {
		if !this.HealthChecks[i].Equal(that1.HealthChecks[i]) {
			return false
		}
	}
	if !this.MaxRequestsPerConnection.Equal(that1.MaxRequestsPerConnection) {
		return false
	}
	if !this.CircuitBreakers.Equal(that1.CircuitBreakers) {
		return false
	}
	if !this.TlsContext.Equal(that1.TlsContext) {
		return false
	}
	if !this.CommonHttpProtocolOptions.Equal(that1.CommonHttpProtocolOptions) {
		return false
	}
	if !this.HttpProtocolOptions.Equal(that1.HttpProtocolOptions) {
		return false
	}
	if !this.Http2ProtocolOptions.Equal(that1.Http2ProtocolOptions) {
		return false
	}
	if this.DnsRefreshRate != nil && that1.DnsRefreshRate != nil {
		if *this.DnsRefreshRate != *that1.DnsRefreshRate {
			return false
		}
	} else if this.DnsRefreshRate != nil {
		return false
	} else if that1.DnsRefreshRate != nil {
		return false
	}
	if this.DnsLookupFamily != that1.DnsLookupFamily {
		return false
	}
	if len(this.DnsResolvers) != len(that1.DnsResolvers) {
		return false
	}
	for i := range this.DnsResolvers {
		if !this.DnsResolvers[i].Equal(that1.DnsResolvers[i]) {
			return false
		}
	}
	if !this.OutlierDetection.Equal(that1.OutlierDetection) {
		return false
	}
	if this.CleanupInterval != nil && that1.CleanupInterval != nil {
		if *this.CleanupInterval != *that1.CleanupInterval {
			return false
		}
	} else if this.CleanupInterval != nil {
		return false
	} else if that1.CleanupInterval != nil {
		return false
	}
	if !this.UpstreamBindConfig.Equal(that1.UpstreamBindConfig) {
		return false
	}
	if !this.LbSubsetConfig.Equal(that1.LbSubsetConfig) {
		return false
	}
	if that1.LbConfig == nil {
		if this.LbConfig != nil {
			return false
		}
	} else if this.LbConfig == nil {
		return false
	} else if !this.LbConfig.Equal(that1.LbConfig) {
		return false
	}
	if !this.CommonLbConfig.Equal(that1.CommonLbConfig) {
		return false
	}
	if !this.TransportSocket.Equal(that1.TransportSocket) {
		return false
	}
	if !this.Metadata.Equal(that1.Metadata) {
		return false
	}
	if this.ProtocolSelection != that1.ProtocolSelection {
		return false
	}
	return true
}
func (this *Cluster_RingHashLbConfig_) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Cluster_RingHashLbConfig_)
	if !ok {
		that2, ok := that.(Cluster_RingHashLbConfig_)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.RingHashLbConfig.Equal(that1.RingHashLbConfig) {
		return false
	}
	return true
}
func (this *Cluster_EdsClusterConfig) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Cluster_EdsClusterConfig)
	if !ok {
		that2, ok := that.(Cluster_EdsClusterConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.EdsConfig.Equal(that1.EdsConfig) {
		return false
	}
	if this.ServiceName != that1.ServiceName {
		return false
	}
	return true
}
func (this *Cluster_LbSubsetConfig) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Cluster_LbSubsetConfig)
	if !ok {
		that2, ok := that.(Cluster_LbSubsetConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.FallbackPolicy != that1.FallbackPolicy {
		return false
	}
	if !this.DefaultSubset.Equal(that1.DefaultSubset) {
		return false
	}
	if len(this.SubsetSelectors) != len(that1.SubsetSelectors) {
		return false
	}
	for i := range this.SubsetSelectors {
		if !this.SubsetSelectors[i].Equal(that1.SubsetSelectors[i]) {
			return false
		}
	}
	return true
}
func (this *Cluster_LbSubsetConfig_LbSubsetSelector) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Cluster_LbSubsetConfig_LbSubsetSelector)
	if !ok {
		that2, ok := that.(Cluster_LbSubsetConfig_LbSubsetSelector)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Keys) != len(that1.Keys) {
		return false
	}
	for i := range this.Keys {
		if this.Keys[i] != that1.Keys[i] {
			return false
		}
	}
	return true
}
func (this *Cluster_RingHashLbConfig) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Cluster_RingHashLbConfig)
	if !ok {
		that2, ok := that.(Cluster_RingHashLbConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.MinimumRingSize.Equal(that1.MinimumRingSize) {
		return false
	}
	if !this.DeprecatedV1.Equal(that1.DeprecatedV1) {
		return false
	}
	return true
}
func (this *Cluster_RingHashLbConfig_DeprecatedV1) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Cluster_RingHashLbConfig_DeprecatedV1)
	if !ok {
		that2, ok := that.(Cluster_RingHashLbConfig_DeprecatedV1)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.UseStdHash.Equal(that1.UseStdHash) {
		return false
	}
	return true
}
func (this *Cluster_CommonLbConfig) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Cluster_CommonLbConfig)
	if !ok {
		that2, ok := that.(Cluster_CommonLbConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.HealthyPanicThreshold.Equal(that1.HealthyPanicThreshold) {
		return false
	}
	if that1.LocalityConfigSpecifier == nil {
		if this.LocalityConfigSpecifier != nil {
			return false
		}
	} else if this.LocalityConfigSpecifier == nil {
		return false
	} else if !this.LocalityConfigSpecifier.Equal(that1.LocalityConfigSpecifier) {
		return false
	}
	return true
}
func (this *Cluster_CommonLbConfig_ZoneAwareLbConfig_) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Cluster_CommonLbConfig_ZoneAwareLbConfig_)
	if !ok {
		that2, ok := that.(Cluster_CommonLbConfig_ZoneAwareLbConfig_)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.ZoneAwareLbConfig.Equal(that1.ZoneAwareLbConfig) {
		return false
	}
	return true
}
func (this *Cluster_CommonLbConfig_LocalityWeightedLbConfig_) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Cluster_CommonLbConfig_LocalityWeightedLbConfig_)
	if !ok {
		that2, ok := that.(Cluster_CommonLbConfig_LocalityWeightedLbConfig_)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.LocalityWeightedLbConfig.Equal(that1.LocalityWeightedLbConfig) {
		return false
	}
	return true
}
func (this *Cluster_CommonLbConfig_ZoneAwareLbConfig) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Cluster_CommonLbConfig_ZoneAwareLbConfig)
	if !ok {
		that2, ok := that.(Cluster_CommonLbConfig_ZoneAwareLbConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.RoutingEnabled.Equal(that1.RoutingEnabled) {
		return false
	}
	if !this.MinClusterSize.Equal(that1.MinClusterSize) {
		return false
	}
	return true
}
func (this *Cluster_CommonLbConfig_LocalityWeightedLbConfig) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Cluster_CommonLbConfig_LocalityWeightedLbConfig)
	if !ok {
		that2, ok := that.(Cluster_CommonLbConfig_LocalityWeightedLbConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	return true
}
func (this *UpstreamBindConfig) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*UpstreamBindConfig)
	if !ok {
		that2, ok := that.(UpstreamBindConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.SourceAddress.Equal(that1.SourceAddress) {
		return false
	}
	return true
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for ClusterDiscoveryService service

type ClusterDiscoveryServiceClient interface {
	StreamClusters(ctx context.Context, opts ...grpc.CallOption) (ClusterDiscoveryService_StreamClustersClient, error)
	FetchClusters(ctx context.Context, in *DiscoveryRequest, opts ...grpc.CallOption) (*DiscoveryResponse, error)
}

type clusterDiscoveryServiceClient struct {
	cc *grpc.ClientConn
}

func NewClusterDiscoveryServiceClient(cc *grpc.ClientConn) ClusterDiscoveryServiceClient {
	return &clusterDiscoveryServiceClient{cc}
}

func (c *clusterDiscoveryServiceClient) StreamClusters(ctx context.Context, opts ...grpc.CallOption) (ClusterDiscoveryService_StreamClustersClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_ClusterDiscoveryService_serviceDesc.Streams[0], c.cc, "/envoy.api.v2.ClusterDiscoveryService/StreamClusters", opts...)
	if err != nil {
		return nil, err
	}
	x := &clusterDiscoveryServiceStreamClustersClient{stream}
	return x, nil
}

type ClusterDiscoveryService_StreamClustersClient interface {
	Send(*DiscoveryRequest) error
	Recv() (*DiscoveryResponse, error)
	grpc.ClientStream
}

type clusterDiscoveryServiceStreamClustersClient struct {
	grpc.ClientStream
}

func (x *clusterDiscoveryServiceStreamClustersClient) Send(m *DiscoveryRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *clusterDiscoveryServiceStreamClustersClient) Recv() (*DiscoveryResponse, error) {
	m := new(DiscoveryResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *clusterDiscoveryServiceClient) FetchClusters(ctx context.Context, in *DiscoveryRequest, opts ...grpc.CallOption) (*DiscoveryResponse, error) {
	out := new(DiscoveryResponse)
	err := grpc.Invoke(ctx, "/envoy.api.v2.ClusterDiscoveryService/FetchClusters", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for ClusterDiscoveryService service

type ClusterDiscoveryServiceServer interface {
	StreamClusters(ClusterDiscoveryService_StreamClustersServer) error
	FetchClusters(context.Context, *DiscoveryRequest) (*DiscoveryResponse, error)
}

func RegisterClusterDiscoveryServiceServer(s *grpc.Server, srv ClusterDiscoveryServiceServer) {
	s.RegisterService(&_ClusterDiscoveryService_serviceDesc, srv)
}

func _ClusterDiscoveryService_StreamClusters_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(ClusterDiscoveryServiceServer).StreamClusters(&clusterDiscoveryServiceStreamClustersServer{stream})
}

type ClusterDiscoveryService_StreamClustersServer interface {
	Send(*DiscoveryResponse) error
	Recv() (*DiscoveryRequest, error)
	grpc.ServerStream
}

type clusterDiscoveryServiceStreamClustersServer struct {
	grpc.ServerStream
}

func (x *clusterDiscoveryServiceStreamClustersServer) Send(m *DiscoveryResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *clusterDiscoveryServiceStreamClustersServer) Recv() (*DiscoveryRequest, error) {
	m := new(DiscoveryRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _ClusterDiscoveryService_FetchClusters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DiscoveryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ClusterDiscoveryServiceServer).FetchClusters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/envoy.api.v2.ClusterDiscoveryService/FetchClusters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ClusterDiscoveryServiceServer).FetchClusters(ctx, req.(*DiscoveryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ClusterDiscoveryService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "envoy.api.v2.ClusterDiscoveryService",
	HandlerType: (*ClusterDiscoveryServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "FetchClusters",
			Handler:    _ClusterDiscoveryService_FetchClusters_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamClusters",
			Handler:       _ClusterDiscoveryService_StreamClusters_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "envoy/api/v2/cds.proto",
}

func (m *Cluster) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Cluster) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCds(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if m.Type != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.Type))
	}
	if m.EdsClusterConfig != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.EdsClusterConfig.Size()))
		n1, err := m.EdsClusterConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	dAtA[i] = 0x22
	i++
	i = encodeVarintCds(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(m.ConnectTimeout)))
	n2, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(m.ConnectTimeout, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	if m.PerConnectionBufferLimitBytes != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.PerConnectionBufferLimitBytes.Size()))
		n3, err := m.PerConnectionBufferLimitBytes.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.LbPolicy != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.LbPolicy))
	}
	if len(m.Hosts) > 0 {
		for _, msg := range m.Hosts {
			dAtA[i] = 0x3a
			i++
			i = encodeVarintCds(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.HealthChecks) > 0 {
		for _, msg := range m.HealthChecks {
			dAtA[i] = 0x42
			i++
			i = encodeVarintCds(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.MaxRequestsPerConnection != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.MaxRequestsPerConnection.Size()))
		n4, err := m.MaxRequestsPerConnection.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.CircuitBreakers != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.CircuitBreakers.Size()))
		n5, err := m.CircuitBreakers.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.TlsContext != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.TlsContext.Size()))
		n6, err := m.TlsContext.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.HttpProtocolOptions != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.HttpProtocolOptions.Size()))
		n7, err := m.HttpProtocolOptions.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.Http2ProtocolOptions != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.Http2ProtocolOptions.Size()))
		n8, err := m.Http2ProtocolOptions.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.DnsRefreshRate != nil {
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintCds(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(*m.DnsRefreshRate)))
		n9, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.DnsRefreshRate, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if m.DnsLookupFamily != 0 {
		dAtA[i] = 0x88
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.DnsLookupFamily))
	}
	if len(m.DnsResolvers) > 0 {
		for _, msg := range m.DnsResolvers {
			dAtA[i] = 0x92
			i++
			dAtA[i] = 0x1
			i++
			i = encodeVarintCds(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.OutlierDetection != nil {
		dAtA[i] = 0x9a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.OutlierDetection.Size()))
		n10, err := m.OutlierDetection.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	if m.CleanupInterval != nil {
		dAtA[i] = 0xa2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintCds(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(*m.CleanupInterval)))
		n11, err := github_com_gogo_protobuf_types.StdDurationMarshalTo(*m.CleanupInterval, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	if m.UpstreamBindConfig != nil {
		dAtA[i] = 0xaa
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.UpstreamBindConfig.Size()))
		n12, err := m.UpstreamBindConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	if m.LbSubsetConfig != nil {
		dAtA[i] = 0xb2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.LbSubsetConfig.Size()))
		n13, err := m.LbSubsetConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	if m.LbConfig != nil {
		nn14, err := m.LbConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn14
	}
	if m.TransportSocket != nil {
		dAtA[i] = 0xc2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.TransportSocket.Size()))
		n15, err := m.TransportSocket.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	if m.Metadata != nil {
		dAtA[i] = 0xca
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.Metadata.Size()))
		n16, err := m.Metadata.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	if m.ProtocolSelection != 0 {
		dAtA[i] = 0xd0
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.ProtocolSelection))
	}
	if m.CommonLbConfig != nil {
		dAtA[i] = 0xda
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.CommonLbConfig.Size()))
		n17, err := m.CommonLbConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n17
	}
	if len(m.AltStatName) > 0 {
		dAtA[i] = 0xe2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintCds(dAtA, i, uint64(len(m.AltStatName)))
		i += copy(dAtA[i:], m.AltStatName)
	}
	if m.CommonHttpProtocolOptions != nil {
		dAtA[i] = 0xea
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.CommonHttpProtocolOptions.Size()))
		n18, err := m.CommonHttpProtocolOptions.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n18
	}
	return i, nil
}

func (m *Cluster_RingHashLbConfig_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.RingHashLbConfig != nil {
		dAtA[i] = 0xba
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.RingHashLbConfig.Size()))
		n19, err := m.RingHashLbConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n19
	}
	return i, nil
}
func (m *Cluster_EdsClusterConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Cluster_EdsClusterConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.EdsConfig != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.EdsConfig.Size()))
		n20, err := m.EdsConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n20
	}
	if len(m.ServiceName) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCds(dAtA, i, uint64(len(m.ServiceName)))
		i += copy(dAtA[i:], m.ServiceName)
	}
	return i, nil
}

func (m *Cluster_LbSubsetConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Cluster_LbSubsetConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.FallbackPolicy != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.FallbackPolicy))
	}
	if m.DefaultSubset != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.DefaultSubset.Size()))
		n21, err := m.DefaultSubset.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n21
	}
	if len(m.SubsetSelectors) > 0 {
		for _, msg := range m.SubsetSelectors {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintCds(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Cluster_LbSubsetConfig_LbSubsetSelector) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Cluster_LbSubsetConfig_LbSubsetSelector) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Keys) > 0 {
		for _, s := range m.Keys {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	return i, nil
}

func (m *Cluster_RingHashLbConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Cluster_RingHashLbConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.MinimumRingSize != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.MinimumRingSize.Size()))
		n22, err := m.MinimumRingSize.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n22
	}
	if m.DeprecatedV1 != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.DeprecatedV1.Size()))
		n23, err := m.DeprecatedV1.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n23
	}
	return i, nil
}

func (m *Cluster_RingHashLbConfig_DeprecatedV1) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Cluster_RingHashLbConfig_DeprecatedV1) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.UseStdHash != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.UseStdHash.Size()))
		n24, err := m.UseStdHash.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n24
	}
	return i, nil
}

func (m *Cluster_CommonLbConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Cluster_CommonLbConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.HealthyPanicThreshold != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.HealthyPanicThreshold.Size()))
		n25, err := m.HealthyPanicThreshold.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n25
	}
	if m.LocalityConfigSpecifier != nil {
		nn26, err := m.LocalityConfigSpecifier.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn26
	}
	return i, nil
}

func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ZoneAwareLbConfig != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.ZoneAwareLbConfig.Size()))
		n27, err := m.ZoneAwareLbConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n27
	}
	return i, nil
}
func (m *Cluster_CommonLbConfig_LocalityWeightedLbConfig_) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.LocalityWeightedLbConfig != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.LocalityWeightedLbConfig.Size()))
		n28, err := m.LocalityWeightedLbConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n28
	}
	return i, nil
}
func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RoutingEnabled != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.RoutingEnabled.Size()))
		n29, err := m.RoutingEnabled.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n29
	}
	if m.MinClusterSize != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.MinClusterSize.Size()))
		n30, err := m.MinClusterSize.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n30
	}
	return i, nil
}

func (m *Cluster_CommonLbConfig_LocalityWeightedLbConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Cluster_CommonLbConfig_LocalityWeightedLbConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *UpstreamBindConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpstreamBindConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.SourceAddress != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCds(dAtA, i, uint64(m.SourceAddress.Size()))
		n31, err := m.SourceAddress.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n31
	}
	return i, nil
}

func encodeVarintCds(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Cluster) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovCds(uint64(l))
	}
	if m.Type != 0 {
		n += 1 + sovCds(uint64(m.Type))
	}
	if m.EdsClusterConfig != nil {
		l = m.EdsClusterConfig.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	l = github_com_gogo_protobuf_types.SizeOfStdDuration(m.ConnectTimeout)
	n += 1 + l + sovCds(uint64(l))
	if m.PerConnectionBufferLimitBytes != nil {
		l = m.PerConnectionBufferLimitBytes.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if m.LbPolicy != 0 {
		n += 1 + sovCds(uint64(m.LbPolicy))
	}
	if len(m.Hosts) > 0 {
		for _, e := range m.Hosts {
			l = e.Size()
			n += 1 + l + sovCds(uint64(l))
		}
	}
	if len(m.HealthChecks) > 0 {
		for _, e := range m.HealthChecks {
			l = e.Size()
			n += 1 + l + sovCds(uint64(l))
		}
	}
	if m.MaxRequestsPerConnection != nil {
		l = m.MaxRequestsPerConnection.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if m.CircuitBreakers != nil {
		l = m.CircuitBreakers.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if m.TlsContext != nil {
		l = m.TlsContext.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if m.HttpProtocolOptions != nil {
		l = m.HttpProtocolOptions.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if m.Http2ProtocolOptions != nil {
		l = m.Http2ProtocolOptions.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if m.DnsRefreshRate != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.DnsRefreshRate)
		n += 2 + l + sovCds(uint64(l))
	}
	if m.DnsLookupFamily != 0 {
		n += 2 + sovCds(uint64(m.DnsLookupFamily))
	}
	if len(m.DnsResolvers) > 0 {
		for _, e := range m.DnsResolvers {
			l = e.Size()
			n += 2 + l + sovCds(uint64(l))
		}
	}
	if m.OutlierDetection != nil {
		l = m.OutlierDetection.Size()
		n += 2 + l + sovCds(uint64(l))
	}
	if m.CleanupInterval != nil {
		l = github_com_gogo_protobuf_types.SizeOfStdDuration(*m.CleanupInterval)
		n += 2 + l + sovCds(uint64(l))
	}
	if m.UpstreamBindConfig != nil {
		l = m.UpstreamBindConfig.Size()
		n += 2 + l + sovCds(uint64(l))
	}
	if m.LbSubsetConfig != nil {
		l = m.LbSubsetConfig.Size()
		n += 2 + l + sovCds(uint64(l))
	}
	if m.LbConfig != nil {
		n += m.LbConfig.Size()
	}
	if m.TransportSocket != nil {
		l = m.TransportSocket.Size()
		n += 2 + l + sovCds(uint64(l))
	}
	if m.Metadata != nil {
		l = m.Metadata.Size()
		n += 2 + l + sovCds(uint64(l))
	}
	if m.ProtocolSelection != 0 {
		n += 2 + sovCds(uint64(m.ProtocolSelection))
	}
	if m.CommonLbConfig != nil {
		l = m.CommonLbConfig.Size()
		n += 2 + l + sovCds(uint64(l))
	}
	l = len(m.AltStatName)
	if l > 0 {
		n += 2 + l + sovCds(uint64(l))
	}
	if m.CommonHttpProtocolOptions != nil {
		l = m.CommonHttpProtocolOptions.Size()
		n += 2 + l + sovCds(uint64(l))
	}
	return n
}

func (m *Cluster_RingHashLbConfig_) Size() (n int) {
	var l int
	_ = l
	if m.RingHashLbConfig != nil {
		l = m.RingHashLbConfig.Size()
		n += 2 + l + sovCds(uint64(l))
	}
	return n
}
func (m *Cluster_EdsClusterConfig) Size() (n int) {
	var l int
	_ = l
	if m.EdsConfig != nil {
		l = m.EdsConfig.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	l = len(m.ServiceName)
	if l > 0 {
		n += 1 + l + sovCds(uint64(l))
	}
	return n
}

func (m *Cluster_LbSubsetConfig) Size() (n int) {
	var l int
	_ = l
	if m.FallbackPolicy != 0 {
		n += 1 + sovCds(uint64(m.FallbackPolicy))
	}
	if m.DefaultSubset != nil {
		l = m.DefaultSubset.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if len(m.SubsetSelectors) > 0 {
		for _, e := range m.SubsetSelectors {
			l = e.Size()
			n += 1 + l + sovCds(uint64(l))
		}
	}
	return n
}

func (m *Cluster_LbSubsetConfig_LbSubsetSelector) Size() (n int) {
	var l int
	_ = l
	if len(m.Keys) > 0 {
		for _, s := range m.Keys {
			l = len(s)
			n += 1 + l + sovCds(uint64(l))
		}
	}
	return n
}

func (m *Cluster_RingHashLbConfig) Size() (n int) {
	var l int
	_ = l
	if m.MinimumRingSize != nil {
		l = m.MinimumRingSize.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if m.DeprecatedV1 != nil {
		l = m.DeprecatedV1.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	return n
}

func (m *Cluster_RingHashLbConfig_DeprecatedV1) Size() (n int) {
	var l int
	_ = l
	if m.UseStdHash != nil {
		l = m.UseStdHash.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	return n
}

func (m *Cluster_CommonLbConfig) Size() (n int) {
	var l int
	_ = l
	if m.HealthyPanicThreshold != nil {
		l = m.HealthyPanicThreshold.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if m.LocalityConfigSpecifier != nil {
		n += m.LocalityConfigSpecifier.Size()
	}
	return n
}

func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig_) Size() (n int) {
	var l int
	_ = l
	if m.ZoneAwareLbConfig != nil {
		l = m.ZoneAwareLbConfig.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	return n
}
func (m *Cluster_CommonLbConfig_LocalityWeightedLbConfig_) Size() (n int) {
	var l int
	_ = l
	if m.LocalityWeightedLbConfig != nil {
		l = m.LocalityWeightedLbConfig.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	return n
}
func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig) Size() (n int) {
	var l int
	_ = l
	if m.RoutingEnabled != nil {
		l = m.RoutingEnabled.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	if m.MinClusterSize != nil {
		l = m.MinClusterSize.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	return n
}

func (m *Cluster_CommonLbConfig_LocalityWeightedLbConfig) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *UpstreamBindConfig) Size() (n int) {
	var l int
	_ = l
	if m.SourceAddress != nil {
		l = m.SourceAddress.Size()
		n += 1 + l + sovCds(uint64(l))
	}
	return n
}

func sovCds(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozCds(x uint64) (n int) {
	return sovCds(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Cluster) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Cluster: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Cluster: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (Cluster_DiscoveryType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EdsClusterConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EdsClusterConfig == nil {
				m.EdsClusterConfig = &Cluster_EdsClusterConfig{}
			}
			if err := m.EdsClusterConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnectTimeout", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(&m.ConnectTimeout, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PerConnectionBufferLimitBytes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PerConnectionBufferLimitBytes == nil {
				m.PerConnectionBufferLimitBytes = &google_protobuf.UInt32Value{}
			}
			if err := m.PerConnectionBufferLimitBytes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LbPolicy", wireType)
			}
			m.LbPolicy = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LbPolicy |= (Cluster_LbPolicy(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hosts", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Hosts = append(m.Hosts, &envoy_api_v2_core.Address{})
			if err := m.Hosts[len(m.Hosts)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HealthChecks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HealthChecks = append(m.HealthChecks, &envoy_api_v2_core4.HealthCheck{})
			if err := m.HealthChecks[len(m.HealthChecks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxRequestsPerConnection", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MaxRequestsPerConnection == nil {
				m.MaxRequestsPerConnection = &google_protobuf.UInt32Value{}
			}
			if err := m.MaxRequestsPerConnection.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CircuitBreakers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CircuitBreakers == nil {
				m.CircuitBreakers = &envoy_api_v2_cluster.CircuitBreakers{}
			}
			if err := m.CircuitBreakers.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TlsContext", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TlsContext == nil {
				m.TlsContext = &envoy_api_v2_auth.UpstreamTlsContext{}
			}
			if err := m.TlsContext.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpProtocolOptions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HttpProtocolOptions == nil {
				m.HttpProtocolOptions = &envoy_api_v2_core5.Http1ProtocolOptions{}
			}
			if err := m.HttpProtocolOptions.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Http2ProtocolOptions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Http2ProtocolOptions == nil {
				m.Http2ProtocolOptions = &envoy_api_v2_core5.Http2ProtocolOptions{}
			}
			if err := m.Http2ProtocolOptions.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsRefreshRate", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DnsRefreshRate == nil {
				m.DnsRefreshRate = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.DnsRefreshRate, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 17:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsLookupFamily", wireType)
			}
			m.DnsLookupFamily = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DnsLookupFamily |= (Cluster_DnsLookupFamily(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 18:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DnsResolvers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DnsResolvers = append(m.DnsResolvers, &envoy_api_v2_core.Address{})
			if err := m.DnsResolvers[len(m.DnsResolvers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 19:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OutlierDetection", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.OutlierDetection == nil {
				m.OutlierDetection = &envoy_api_v2_cluster1.OutlierDetection{}
			}
			if err := m.OutlierDetection.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CleanupInterval", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CleanupInterval == nil {
				m.CleanupInterval = new(time.Duration)
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(m.CleanupInterval, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpstreamBindConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UpstreamBindConfig == nil {
				m.UpstreamBindConfig = &envoy_api_v2_core.BindConfig{}
			}
			if err := m.UpstreamBindConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 22:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LbSubsetConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LbSubsetConfig == nil {
				m.LbSubsetConfig = &Cluster_LbSubsetConfig{}
			}
			if err := m.LbSubsetConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 23:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RingHashLbConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Cluster_RingHashLbConfig{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.LbConfig = &Cluster_RingHashLbConfig_{v}
			iNdEx = postIndex
		case 24:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TransportSocket", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TransportSocket == nil {
				m.TransportSocket = &envoy_api_v2_core1.TransportSocket{}
			}
			if err := m.TransportSocket.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 25:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metadata", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Metadata == nil {
				m.Metadata = &envoy_api_v2_core1.Metadata{}
			}
			if err := m.Metadata.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 26:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProtocolSelection", wireType)
			}
			m.ProtocolSelection = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ProtocolSelection |= (Cluster_ClusterProtocolSelection(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 27:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CommonLbConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CommonLbConfig == nil {
				m.CommonLbConfig = &Cluster_CommonLbConfig{}
			}
			if err := m.CommonLbConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 28:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AltStatName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AltStatName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 29:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CommonHttpProtocolOptions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CommonHttpProtocolOptions == nil {
				m.CommonHttpProtocolOptions = &envoy_api_v2_core5.HttpProtocolOptions{}
			}
			if err := m.CommonHttpProtocolOptions.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Cluster_EdsClusterConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EdsClusterConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EdsClusterConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EdsConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EdsConfig == nil {
				m.EdsConfig = &envoy_api_v2_core3.ConfigSource{}
			}
			if err := m.EdsConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServiceName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ServiceName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Cluster_LbSubsetConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LbSubsetConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LbSubsetConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FallbackPolicy", wireType)
			}
			m.FallbackPolicy = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FallbackPolicy |= (Cluster_LbSubsetConfig_LbSubsetFallbackPolicy(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DefaultSubset", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DefaultSubset == nil {
				m.DefaultSubset = &google_protobuf4.Struct{}
			}
			if err := m.DefaultSubset.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubsetSelectors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SubsetSelectors = append(m.SubsetSelectors, &Cluster_LbSubsetConfig_LbSubsetSelector{})
			if err := m.SubsetSelectors[len(m.SubsetSelectors)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Cluster_LbSubsetConfig_LbSubsetSelector) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LbSubsetSelector: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LbSubsetSelector: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Keys", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Keys = append(m.Keys, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Cluster_RingHashLbConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RingHashLbConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RingHashLbConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinimumRingSize", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MinimumRingSize == nil {
				m.MinimumRingSize = &google_protobuf.UInt64Value{}
			}
			if err := m.MinimumRingSize.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeprecatedV1", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeprecatedV1 == nil {
				m.DeprecatedV1 = &Cluster_RingHashLbConfig_DeprecatedV1{}
			}
			if err := m.DeprecatedV1.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Cluster_RingHashLbConfig_DeprecatedV1) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeprecatedV1: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeprecatedV1: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UseStdHash", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UseStdHash == nil {
				m.UseStdHash = &google_protobuf.BoolValue{}
			}
			if err := m.UseStdHash.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Cluster_CommonLbConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommonLbConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommonLbConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HealthyPanicThreshold", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HealthyPanicThreshold == nil {
				m.HealthyPanicThreshold = &envoy_type.Percent{}
			}
			if err := m.HealthyPanicThreshold.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ZoneAwareLbConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Cluster_CommonLbConfig_ZoneAwareLbConfig{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.LocalityConfigSpecifier = &Cluster_CommonLbConfig_ZoneAwareLbConfig_{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocalityWeightedLbConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Cluster_CommonLbConfig_LocalityWeightedLbConfig{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.LocalityConfigSpecifier = &Cluster_CommonLbConfig_LocalityWeightedLbConfig_{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ZoneAwareLbConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ZoneAwareLbConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RoutingEnabled", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RoutingEnabled == nil {
				m.RoutingEnabled = &envoy_type.Percent{}
			}
			if err := m.RoutingEnabled.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinClusterSize", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MinClusterSize == nil {
				m.MinClusterSize = &google_protobuf.UInt64Value{}
			}
			if err := m.MinClusterSize.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Cluster_CommonLbConfig_LocalityWeightedLbConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LocalityWeightedLbConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LocalityWeightedLbConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipCds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpstreamBindConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCds
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpstreamBindConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpstreamBindConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceAddress", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCds
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCds
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SourceAddress == nil {
				m.SourceAddress = &envoy_api_v2_core.Address{}
			}
			if err := m.SourceAddress.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCds(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCds
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipCds(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowCds
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCds
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCds
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthCds
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowCds
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipCds(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthCds = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowCds   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("envoy/api/v2/cds.proto", fileDescriptorCds) }

var fileDescriptorCds = []byte{
	// 1959 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x58, 0x4f, 0x6f, 0xdb, 0xc8,
	0x15, 0x37, 0x65, 0x25, 0xb1, 0x9f, 0x2d, 0x89, 0x1e, 0x27, 0x31, 0x23, 0x27, 0x8e, 0xa3, 0x6e,
	0xb6, 0x46, 0x50, 0xc8, 0x1b, 0x67, 0x37, 0x05, 0xb6, 0xdb, 0x2d, 0xf4, 0xcf, 0xb6, 0x76, 0x15,
	0xc9, 0x25, 0xe9, 0x18, 0xdb, 0x6d, 0x30, 0x1d, 0x91, 0x23, 0x8b, 0x35, 0x45, 0xb2, 0x9c, 0xa1,
	0x13, 0xe7, 0x50, 0xa0, 0x7b, 0xda, 0x7b, 0x2f, 0xed, 0x61, 0xef, 0x45, 0x3f, 0x42, 0x4f, 0x3d,
	0xee, 0xb1, 0x40, 0xef, 0x6d, 0x11, 0x14, 0x28, 0xfa, 0x2d, 0x0a, 0x0e, 0x87, 0x8a, 0xfe, 0xd0,
	0x59, 0x2f, 0xd0, 0x93, 0x38, 0xef, 0xfd, 0xde, 0x6f, 0xe6, 0xbd, 0x79, 0xef, 0xcd, 0x8c, 0xe0,
	0x36, 0xf5, 0xce, 0xfd, 0x8b, 0x5d, 0x12, 0x38, 0xbb, 0xe7, 0x7b, 0xbb, 0x96, 0xcd, 0xaa, 0x41,
	0xe8, 0x73, 0x1f, 0xad, 0x0a, 0x79, 0x95, 0x04, 0x4e, 0xf5, 0x7c, 0xaf, 0x7c, 0x7f, 0x1a, 0xe5,
	0x87, 0x74, 0x97, 0xd8, 0x76, 0x48, 0x99, 0x84, 0x97, 0xef, 0x4e, 0x01, 0x48, 0xc4, 0x87, 0xbb,
	0x16, 0x0d, 0x79, 0xa6, 0x56, 0x98, 0xf7, 0x09, 0xa3, 0x52, 0xfb, 0x70, 0x5e, 0x6b, 0xf9, 0xde,
	0xc0, 0x39, 0xc5, 0xcc, 0x8f, 0x42, 0x8b, 0x66, 0x92, 0xd8, 0x0e, 0xb3, 0xfc, 0x73, 0x1a, 0x5e,
	0x48, 0xed, 0x7b, 0xf3, 0x24, 0x43, 0x4a, 0x5c, 0x3e, 0xc4, 0xd6, 0x90, 0x5a, 0x67, 0x12, 0xb5,
	0x3d, 0x8f, 0x12, 0x0a, 0xcb, 0x77, 0x25, 0xe2, 0xd1, 0x34, 0xc2, 0x8d, 0x18, 0xa7, 0xe1, 0xae,
	0xe5, 0x84, 0x56, 0xe4, 0x70, 0xdc, 0x0f, 0x29, 0x39, 0xa3, 0xa1, 0xc4, 0xfe, 0x28, 0x13, 0xeb,
	0x47, 0xdc, 0x75, 0x68, 0x88, 0x6d, 0xca, 0xa9, 0xc5, 0x1d, 0xdf, 0x93, 0x68, 0x2d, 0x41, 0xf3,
	0x8b, 0x80, 0xee, 0x06, 0x34, 0xb4, 0xa8, 0x37, 0x0e, 0xcf, 0xa9, 0xef, 0x9f, 0xba, 0x54, 0x10,
	0x11, 0xcf, 0xf3, 0x39, 0x89, 0xcd, 0xd2, 0xd0, 0x6e, 0x49, 0xad, 0x18, 0xf5, 0xa3, 0xc1, 0xae,
	0x1d, 0x85, 0x64, 0x82, 0xf7, 0xee, 0xac, 0x9e, 0xf1, 0x30, 0xb2, 0xf8, 0x65, 0xd6, 0x2f, 0x43,
	0x12, 0x04, 0x34, 0x4c, 0xd9, 0x37, 0xce, 0x89, 0xeb, 0xd8, 0x84, 0xd3, 0xdd, 0xf4, 0x43, 0x2a,
	0x6e, 0x9e, 0xfa, 0xa7, 0xbe, 0xf8, 0xdc, 0x8d, 0xbf, 0x12, 0x69, 0xe5, 0x77, 0x5b, 0x70, 0xa3,
	0x91, 0x38, 0x8a, 0xee, 0x41, 0xde, 0x23, 0x23, 0xaa, 0x29, 0xdb, 0xca, 0xce, 0x72, 0x7d, 0xf9,
	0x2f, 0xff, 0xfd, 0xeb, 0x62, 0x3e, 0xcc, 0x6d, 0x2b, 0xba, 0x10, 0xa3, 0x06, 0xe4, 0x63, 0x5f,
	0xb5, 0xdc, 0xb6, 0xb2, 0x53, 0xdc, 0xfb, 0x41, 0x75, 0x32, 0xa1, 0xaa, 0x92, 0xa3, 0xda, 0x4c,
	0xb7, 0xd1, 0xbc, 0x08, 0x68, 0x1d, 0x62, 0x8e, 0x6b, 0x5f, 0x29, 0x39, 0x55, 0xd1, 0x85, 0x31,
	0x32, 0x01, 0x51, 0x9b, 0x61, 0x19, 0x5b, 0x9c, 0xe4, 0x85, 0xb6, 0xb8, 0xad, 0xec, 0xac, 0xec,
	0xbd, 0x9f, 0x4d, 0xd9, 0xb2, 0x99, 0xfc, 0x6c, 0x08, 0xb4, 0xae, 0xd2, 0x19, 0x09, 0x7a, 0x0e,
	0x25, 0xcb, 0xf7, 0x3c, 0x6a, 0x71, 0xcc, 0x9d, 0x11, 0xf5, 0x23, 0xae, 0xe5, 0x05, 0xe5, 0x9d,
	0x6a, 0x12, 0xae, 0x6a, 0x1a, 0xae, 0x6a, 0x53, 0x06, 0xbb, 0x8e, 0xbe, 0xfd, 0xc7, 0xfd, 0x85,
	0x3f, 0xfc, 0xf3, 0xbe, 0x22, 0xd6, 0xf8, 0x67, 0x25, 0xf7, 0x68, 0x41, 0x2f, 0x4a, 0x16, 0x33,
	0x21, 0x41, 0x03, 0x78, 0x10, 0x24, 0xab, 0xf4, 0x92, 0xad, 0xc7, 0xfd, 0x68, 0x30, 0xa0, 0x21,
	0x76, 0x9d, 0x51, 0x9c, 0x3d, 0x17, 0x9c, 0x32, 0xed, 0x9a, 0x98, 0xe9, 0xee, 0xdc, 0x4c, 0xc7,
	0x6d, 0x8f, 0x3f, 0xd9, 0x7b, 0x4e, 0xdc, 0x88, 0xea, 0xf7, 0x02, 0xb1, 0x56, 0xc9, 0x52, 0x17,
	0x24, 0x9d, 0x98, 0xa3, 0x1e, 0x53, 0xa0, 0x03, 0x58, 0x76, 0xfb, 0x38, 0xf0, 0x5d, 0xc7, 0xba,
	0xd0, 0xae, 0x8b, 0xf8, 0x6e, 0x65, 0x07, 0xa3, 0xd3, 0x3f, 0x12, 0xa8, 0xa9, 0xd0, 0x2e, 0xb9,
	0x52, 0x8a, 0x3e, 0x80, 0x6b, 0x43, 0x9f, 0x71, 0xa6, 0xdd, 0xd8, 0x5e, 0xdc, 0x59, 0xd9, 0x2b,
	0x4f, 0x93, 0xc4, 0xf5, 0x51, 0xad, 0x25, 0x75, 0xae, 0x27, 0x40, 0xd4, 0x80, 0xc2, 0x64, 0x5d,
	0x31, 0x6d, 0x49, 0x58, 0x6e, 0x65, 0x58, 0x1e, 0x0a, 0x5c, 0x23, 0x86, 0xe9, 0xab, 0xc3, 0xb7,
	0x03, 0x86, 0xbe, 0x84, 0xcd, 0x11, 0x79, 0x85, 0x43, 0xfa, 0x9b, 0x88, 0x32, 0xce, 0xf0, 0x74,
	0xd0, 0xb4, 0xe5, 0x2b, 0x44, 0x48, 0x1b, 0x91, 0x57, 0xba, 0xb4, 0x3f, 0x9a, 0x0c, 0x16, 0x3a,
	0x02, 0x75, 0xa6, 0x5c, 0x99, 0x06, 0x82, 0xf1, 0xe1, 0xcc, 0x22, 0x65, 0x8c, 0x1a, 0x09, 0xba,
	0x2e, 0xc1, 0x7a, 0xc9, 0x9a, 0x16, 0xa0, 0x7d, 0x58, 0xe1, 0x2e, 0x8b, 0x57, 0xc8, 0xe9, 0x2b,
	0xae, 0xad, 0x64, 0x91, 0xc5, 0x2d, 0xaf, 0x7a, 0x1c, 0x30, 0x1e, 0x52, 0x32, 0x32, 0x5d, 0xd6,
	0x48, 0xc0, 0x3a, 0xf0, 0xf1, 0x37, 0xfa, 0x12, 0x6e, 0x0d, 0x39, 0x0f, 0x70, 0xda, 0x72, 0xb0,
	0x1f, 0x88, 0x42, 0xd7, 0x0a, 0x82, 0xf1, 0x87, 0x59, 0x31, 0xe4, 0x3c, 0x78, 0x7c, 0x24, 0xf1,
	0xbd, 0x04, 0xae, 0xaf, 0xc7, 0x2c, 0x33, 0x42, 0xf4, 0x02, 0x6e, 0xc7, 0xe2, 0xbd, 0x79, 0xf6,
	0xe2, 0x3b, 0xd9, 0xf7, 0x66, 0xd9, 0x6f, 0x0e, 0x33, 0xa4, 0xc8, 0x00, 0xd5, 0xf6, 0x18, 0x0e,
	0xe9, 0x20, 0xa4, 0x6c, 0x88, 0x43, 0xc2, 0xa9, 0xa6, 0x7e, 0x57, 0xcd, 0x14, 0x67, 0xeb, 0xc5,
	0xf6, 0x98, 0x9e, 0x30, 0xe8, 0x84, 0x53, 0xf4, 0x02, 0xd6, 0x62, 0x52, 0xd7, 0xf7, 0xcf, 0xa2,
	0x00, 0x0f, 0xc8, 0xc8, 0x71, 0x2f, 0xb4, 0x35, 0x91, 0xcf, 0x0f, 0x2f, 0xe9, 0x17, 0x1e, 0xeb,
	0x08, 0xf4, 0xbe, 0x00, 0x4f, 0xa5, 0x75, 0xc9, 0x9e, 0x56, 0xa2, 0x9f, 0x41, 0x21, 0x59, 0x33,
	0xf3, 0xdd, 0xf3, 0x38, 0x0d, 0xd0, 0x77, 0x66, 0xf9, 0xaa, 0x58, 0xa1, 0xc4, 0x23, 0x03, 0xd6,
	0xe6, 0xba, 0xb9, 0xb6, 0x9e, 0xd5, 0x7c, 0xd2, 0x5c, 0xea, 0x25, 0xf0, 0x66, 0x8a, 0xd6, 0x55,
	0x7f, 0x46, 0x82, 0x4c, 0x50, 0x2d, 0x97, 0x12, 0x2f, 0x0a, 0xb0, 0xe3, 0x71, 0x1a, 0x9e, 0x13,
	0x57, 0xbb, 0xf9, 0x7d, 0x23, 0x59, 0x92, 0x14, 0x6d, 0xc9, 0x80, 0x7a, 0x70, 0x33, 0x92, 0xd9,
	0x87, 0xfb, 0x8e, 0x67, 0xa7, 0xad, 0xf2, 0x96, 0x60, 0xbe, 0x97, 0xe1, 0x72, 0xdd, 0xf1, 0x6c,
	0xd9, 0x21, 0x51, 0x6a, 0xfa, 0x56, 0x86, 0xba, 0xa0, 0xba, 0x7d, 0xcc, 0xa2, 0x3e, 0xa3, 0x3c,
	0x25, 0xbb, 0x2d, 0xc8, 0xde, 0xbb, 0xac, 0xd5, 0x18, 0x02, 0x2c, 0x39, 0x8b, 0xee, 0xd4, 0x18,
	0x9d, 0xc0, 0x7a, 0xe8, 0x78, 0xa7, 0x78, 0x48, 0xd8, 0x10, 0xbb, 0xfd, 0x94, 0x72, 0xe3, 0x5d,
	0xad, 0x5c, 0x77, 0xbc, 0xd3, 0x43, 0xc2, 0x86, 0x9d, 0x7e, 0x42, 0x72, 0xb8, 0xa0, 0xab, 0xe1,
	0x8c, 0x0c, 0x3d, 0x03, 0x95, 0x87, 0xc4, 0x63, 0x81, 0x1f, 0x72, 0xcc, 0x7c, 0xeb, 0x8c, 0x72,
	0x4d, 0x13, 0xac, 0x95, 0x0c, 0xaf, 0xcd, 0x14, 0x6a, 0x08, 0xa4, 0x5e, 0xe2, 0xd3, 0x02, 0xf4,
	0x63, 0x58, 0x1a, 0x51, 0x4e, 0x6c, 0xc2, 0x89, 0x76, 0x47, 0xd0, 0x6c, 0x66, 0xd0, 0x3c, 0x93,
	0x10, 0x7d, 0x0c, 0x46, 0x2f, 0x00, 0x8d, 0x4b, 0x8f, 0x51, 0x57, 0x66, 0x4b, 0x59, 0x64, 0x73,
	0x35, 0xdb, 0x3f, 0xf9, 0x9b, 0xd6, 0x9a, 0x91, 0x5a, 0xe9, 0x6b, 0xc1, 0xac, 0x28, 0xde, 0x0f,
	0xcb, 0x1f, 0x8d, 0x7c, 0x6f, 0x22, 0x78, 0x9b, 0xef, 0xda, 0x8f, 0x86, 0x40, 0xa7, 0x61, 0x8a,
	0xcf, 0xaa, 0xc9, 0x31, 0xaa, 0x40, 0x81, 0xb8, 0x1c, 0x33, 0x4e, 0x38, 0x16, 0xc7, 0xf8, 0xdd,
	0xf8, 0x18, 0xd7, 0x57, 0x88, 0xcb, 0x0d, 0x4e, 0x78, 0x37, 0x3e, 0xc2, 0x4f, 0xe1, 0xae, 0x9c,
	0x33, 0xbb, 0x6f, 0xdd, 0xcb, 0x2c, 0x85, 0xb4, 0xb3, 0xcc, 0x36, 0x96, 0x3b, 0x09, 0x57, 0x86,
	0xaa, 0x1c, 0x81, 0x3a, 0x7b, 0x6c, 0xa3, 0x4f, 0x01, 0xc4, 0xd1, 0x9f, 0xb8, 0xaa, 0x88, 0xa9,
	0xee, 0x67, 0x4c, 0x95, 0xc0, 0x0d, 0x71, 0x55, 0xd4, 0x97, 0xe3, 0xb3, 0x3e, 0xb1, 0x7f, 0x00,
	0xab, 0x8c, 0x86, 0xe7, 0x8e, 0x45, 0x13, 0xff, 0x72, 0x89, 0x7f, 0x52, 0x16, 0xfb, 0x57, 0xfe,
	0x66, 0x11, 0x8a, 0xd3, 0x69, 0x8b, 0x02, 0x28, 0x0d, 0x88, 0xeb, 0xf6, 0x89, 0x75, 0x96, 0x1e,
	0xb0, 0x8a, 0xd8, 0xc2, 0x9f, 0x5c, 0x25, 0xeb, 0xc7, 0xc3, 0x7d, 0xc9, 0x91, 0x71, 0xfa, 0x16,
	0x07, 0x53, 0x3a, 0xf4, 0x29, 0x14, 0x6d, 0x3a, 0x20, 0x51, 0xbc, 0x19, 0xc2, 0x56, 0xac, 0x74,
	0x65, 0x6f, 0x63, 0xae, 0x1b, 0x18, 0xe2, 0x62, 0xa7, 0x17, 0x24, 0x3c, 0x99, 0x09, 0xfd, 0x0a,
	0x54, 0x59, 0xa5, 0x49, 0xd6, 0xf9, 0x21, 0xd3, 0x16, 0x45, 0xa3, 0xfb, 0xe8, 0x7b, 0x2d, 0xd9,
	0x90, 0xd6, 0x7a, 0x89, 0x4d, 0x8d, 0x59, 0xf9, 0x7d, 0x50, 0x67, 0x41, 0x08, 0x41, 0xfe, 0x8c,
	0x5e, 0x30, 0x4d, 0xd9, 0x5e, 0xdc, 0x59, 0xd6, 0xc5, 0x77, 0xa5, 0x07, 0xb7, 0xb3, 0xfd, 0x47,
	0x25, 0x58, 0xe9, 0xf6, 0xf0, 0x7e, 0xad, 0xd3, 0xa9, 0xd7, 0x1a, 0x9f, 0xab, 0x0b, 0x48, 0x85,
	0xd5, 0x5a, 0xf7, 0x0b, 0xdc, 0xea, 0x36, 0x8f, 0x7a, 0xed, 0xae, 0xa9, 0x2a, 0x08, 0x41, 0xb1,
	0xd9, 0xda, 0xaf, 0x1d, 0x77, 0x4c, 0x6c, 0x1c, 0xd7, 0x8d, 0x96, 0xa9, 0xe6, 0xca, 0x5f, 0xe7,
	0x40, 0x9d, 0xed, 0x01, 0xe8, 0x10, 0xd6, 0x46, 0x8e, 0xe7, 0x8c, 0xa2, 0x11, 0x16, 0x0d, 0x85,
	0x39, 0xaf, 0xa9, 0x4c, 0x8f, 0xec, 0x2b, 0xc3, 0xd3, 0x0f, 0x93, 0x2b, 0x43, 0x49, 0x9a, 0xc5,
	0x8c, 0x86, 0xf3, 0x9a, 0xa2, 0x5f, 0x42, 0xc1, 0xa6, 0x41, 0x48, 0x2d, 0xc2, 0xa9, 0x8d, 0xcf,
	0x1f, 0xcb, 0xc0, 0x3f, 0xb9, 0x5a, 0x33, 0xaa, 0x36, 0xc7, 0xb6, 0xcf, 0x1f, 0xd7, 0x73, 0x9a,
	0xa2, 0xaf, 0xda, 0x13, 0x92, 0x72, 0x07, 0x56, 0x27, 0x11, 0xe8, 0x13, 0x58, 0x8d, 0x18, 0xc5,
	0x8c, 0xdb, 0xa2, 0x07, 0xca, 0x25, 0x97, 0xe7, 0x96, 0x5c, 0xf7, 0x7d, 0x37, 0x59, 0x30, 0x44,
	0x8c, 0x1a, 0xdc, 0x8e, 0x27, 0x2d, 0x7f, 0x93, 0x87, 0xe2, 0x74, 0x45, 0xa3, 0xcf, 0x61, 0x23,
	0xb9, 0x55, 0x5d, 0xe0, 0x80, 0x78, 0x8e, 0x85, 0xf9, 0x30, 0x3e, 0x59, 0x7d, 0xd7, 0x96, 0xdc,
	0xeb, 0xd2, 0x91, 0xf8, 0x26, 0x5d, 0x3d, 0x4a, 0x9e, 0x1c, 0xfa, 0x2d, 0x69, 0x73, 0x14, 0x9b,
	0x98, 0xa9, 0x05, 0x72, 0xe0, 0xe6, 0x6b, 0xdf, 0xa3, 0x98, 0xbc, 0x24, 0x21, 0x9d, 0x68, 0x31,
	0x49, 0x48, 0x9e, 0x5e, 0xa5, 0xc5, 0x54, 0x7f, 0xe1, 0x7b, 0xb4, 0x16, 0xdb, 0x4f, 0xf4, 0xeb,
	0xb5, 0xd7, 0xb3, 0x42, 0xf4, 0x5b, 0xd8, 0x74, 0x7d, 0x8b, 0xb8, 0x0e, 0xbf, 0xc0, 0x2f, 0xa9,
	0x73, 0x3a, 0x8c, 0xa3, 0xff, 0x76, 0xc6, 0xe4, 0x72, 0xff, 0xd3, 0x2b, 0xcd, 0xd8, 0x91, 0x3c,
	0x27, 0x92, 0x66, 0x62, 0x62, 0xcd, 0xbd, 0x44, 0x57, 0xfe, 0xa3, 0x02, 0x6b, 0x73, 0x4b, 0x45,
	0x9f, 0x40, 0x29, 0xf4, 0x23, 0x1e, 0x67, 0x14, 0xf5, 0x48, 0xdf, 0xa5, 0xef, 0x8c, 0x62, 0x51,
	0x62, 0x5b, 0x09, 0x14, 0xed, 0x83, 0x3a, 0x72, 0xbc, 0xf1, 0x3b, 0x45, 0xe4, 0x64, 0xee, 0x0a,
	0x39, 0x59, 0x1c, 0x39, 0x9e, 0xf4, 0x2d, 0x4e, 0xc9, 0x72, 0x19, 0xb4, 0xcb, 0x7c, 0xaa, 0x6f,
	0xc2, 0x9d, 0x71, 0xdc, 0xd2, 0x07, 0x72, 0x40, 0x2d, 0x67, 0xe0, 0xd0, 0xb0, 0x72, 0x02, 0x85,
	0xa9, 0xb7, 0x14, 0x02, 0xb8, 0x6e, 0x98, 0x35, 0xb3, 0xdd, 0x50, 0x17, 0x50, 0x11, 0xc0, 0x30,
	0xf5, 0x76, 0xc3, 0xc4, 0xcd, 0xae, 0xa1, 0x2a, 0x71, 0x39, 0x76, 0x7a, 0x07, 0xed, 0x46, 0xad,
	0x23, 0x04, 0x39, 0x74, 0x03, 0x16, 0x5b, 0x4d, 0x43, 0x5d, 0x8c, 0xeb, 0xb2, 0xa7, 0xb7, 0x0f,
	0xda, 0xdd, 0x58, 0x65, 0x98, 0x6a, 0xbe, 0xf2, 0x6b, 0x58, 0x4a, 0x1f, 0x11, 0xb1, 0x9d, 0xde,
	0x3b, 0xee, 0x36, 0xb1, 0xde, 0xab, 0xb7, 0xbb, 0xea, 0x02, 0x5a, 0x83, 0x42, 0xa7, 0x55, 0x33,
	0x4c, 0xac, 0xb7, 0x7e, 0x7e, 0xdc, 0x32, 0xe2, 0x3a, 0x2e, 0xc0, 0xb2, 0xde, 0xee, 0x1e, 0xe0,
	0xc3, 0x9a, 0x71, 0xa8, 0xe6, 0xe2, 0x65, 0xe8, 0xb5, 0x6e, 0xb3, 0xf7, 0x4c, 0x5d, 0x44, 0xeb,
	0x50, 0x9a, 0x24, 0xc7, 0x9d, 0xba, 0x9a, 0x8f, 0x01, 0xcf, 0x6a, 0x07, 0x9d, 0xd6, 0x73, 0xf5,
	0x5a, 0xe5, 0x23, 0x28, 0xcd, 0x5c, 0xf0, 0xd0, 0x12, 0xe4, 0x6b, 0xc7, 0x66, 0x4f, 0x5d, 0x40,
	0x2b, 0x70, 0xe3, 0xf9, 0x87, 0xb8, 0xd7, 0xed, 0x7c, 0xa1, 0x2a, 0x62, 0xf0, 0x34, 0x19, 0xe4,
	0x2a, 0x26, 0x68, 0x97, 0x9d, 0xa4, 0x68, 0x13, 0x36, 0x8e, 0x8d, 0x16, 0x6e, 0xf4, 0xba, 0xfb,
	0xed, 0x83, 0x63, 0xbd, 0xd5, 0xc4, 0x47, 0x7a, 0xcf, 0xec, 0x35, 0x7a, 0x1d, 0x75, 0x21, 0x55,
	0x36, 0x7b, 0x27, 0x5d, 0xc3, 0xd4, 0x5b, 0xb5, 0x67, 0x6f, 0x95, 0x4a, 0x7d, 0x45, 0x3c, 0xb2,
	0x92, 0x40, 0x7f, 0x96, 0x5f, 0x5a, 0x55, 0x0b, 0x9f, 0xe5, 0x97, 0x4a, 0xaa, 0x5a, 0x39, 0x01,
	0x74, 0x3c, 0x7f, 0x5f, 0xaa, 0x41, 0x31, 0xf9, 0xbb, 0x02, 0xcb, 0x7f, 0x46, 0xc6, 0x05, 0x7e,
	0xf9, 0x6d, 0xb3, 0x90, 0x58, 0xc8, 0xe1, 0xde, 0x7f, 0x14, 0xd8, 0x90, 0x8e, 0x8c, 0xf7, 0xd2,
	0x48, 0x8e, 0x2b, 0x74, 0x02, 0x45, 0x43, 0x4c, 0x29, 0x01, 0x0c, 0xcd, 0x3c, 0xb9, 0xc6, 0x16,
	0xf2, 0x55, 0x54, 0xbe, 0x7f, 0xa9, 0x9e, 0x05, 0xbe, 0xc7, 0x68, 0x65, 0x61, 0x47, 0xf9, 0x40,
	0x41, 0x0c, 0x0a, 0xfb, 0x94, 0x5b, 0xc3, 0xff, 0x1f, 0xef, 0x83, 0xaf, 0xfe, 0xfe, 0xef, 0xdf,
	0xe7, 0x36, 0x2b, 0xb7, 0xa7, 0xfe, 0xa7, 0xf9, 0x58, 0xd6, 0x06, 0xfb, 0x58, 0x79, 0x54, 0x5f,
	0xff, 0xd3, 0x9b, 0x2d, 0xe5, 0xdb, 0x37, 0x5b, 0xca, 0xdf, 0xde, 0x6c, 0x29, 0xff, 0x7a, 0xb3,
	0xa5, 0x7c, 0xad, 0x28, 0xfd, 0xeb, 0xa2, 0x42, 0x9e, 0xfc, 0x2f, 0x00, 0x00, 0xff, 0xff, 0x9f,
	0xca, 0x29, 0x6d, 0x93, 0x12, 0x00, 0x00,
}
