// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: mixer/adapter/prometheus/config/config.proto

/*
	Package config is a generated protocol buffer package.

	The `prometheus` adapter collects Istio metrics and makes them available to
	[Prometheus](https://prometheus.io).

	It is generated from these files:
		mixer/adapter/prometheus/config/config.proto

	It has these top-level messages:
		Params
*/
package config

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"

import strconv "strconv"

import encoding_binary "encoding/binary"

import strings "strings"
import reflect "reflect"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Describes what kind of metric this is.
type Params_MetricInfo_Kind int32

const (
	UNSPECIFIED  Params_MetricInfo_Kind = 0
	GAUGE        Params_MetricInfo_Kind = 1
	COUNTER      Params_MetricInfo_Kind = 2
	DISTRIBUTION Params_MetricInfo_Kind = 3
)

var Params_MetricInfo_Kind_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "GAUGE",
	2: "COUNTER",
	3: "DISTRIBUTION",
}
var Params_MetricInfo_Kind_value = map[string]int32{
	"UNSPECIFIED":  0,
	"GAUGE":        1,
	"COUNTER":      2,
	"DISTRIBUTION": 3,
}

func (Params_MetricInfo_Kind) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorConfig, []int{0, 0, 0}
}

// Configuration format for the `prometheus` adapter.
type Params struct {
	// The set of metrics to represent in Prometheus. If a metric is defined in Istio but doesn't have a corresponding
	// shape here, it will not be populated at runtime.
	Metrics []*Params_MetricInfo `protobuf:"bytes,1,rep,name=metrics" json:"metrics,omitempty"`
}

func (m *Params) Reset()                    { *m = Params{} }
func (*Params) ProtoMessage()               {}
func (*Params) Descriptor() ([]byte, []int) { return fileDescriptorConfig, []int{0} }

// Describes how a metric should be represented in Prometheus.
type Params_MetricInfo struct {
	// Optional. The namespace is used as a prefix on the metric names.
	// An example: for a metric named "request_count" with a namespace of "istio",
	// the full metric name becomes "istio_request_count".
	// NOTE: The specificed namespace should be a prometheus-safe name. If not, the adapter
	// will attempt to convert the namespace to a prometheus-safe name.
	// NOTE: Changing the value for this will potentially impact downstream integrations
	// and should be used with caution.
	// Default value: "istio".
	Namespace string `protobuf:"bytes,7,opt,name=namespace,proto3" json:"namespace,omitempty"`
	// Recommended. The name is used to register the prometheus metric.
	// It must be unique across all prometheus metrics as prometheus does not allow duplicate names.
	// If name is not specified a sanitized version of instance_name is used.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The name is the fully qualified name of the Istio metric instance
	// that this MetricInfo processes.
	InstanceName string `protobuf:"bytes,2,opt,name=instance_name,json=instanceName,proto3" json:"instance_name,omitempty"`
	// Optional. A human readable description of this metric.
	Description string                 `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	Kind        Params_MetricInfo_Kind `protobuf:"varint,4,opt,name=kind,proto3,enum=adapter.prometheus.config.Params_MetricInfo_Kind" json:"kind,omitempty"`
	// For metrics with a metric kind of DISTRIBUTION, this provides a mechanism
	// for configuring the buckets that will be used to store the aggregated values.
	// This field must be provided for metrics declared to be of type DISTRIBUTION.
	// This field will be ignored for non-distribution metric kinds.
	Buckets *Params_MetricInfo_BucketsDefinition `protobuf:"bytes,5,opt,name=buckets" json:"buckets,omitempty"`
	// The names of labels to use: these need to match the dimensions of the Istio metric.
	// TODO: see if we can remove this and rely on only the dimensions in the future.
	LabelNames []string `protobuf:"bytes,6,rep,name=label_names,json=labelNames" json:"label_names,omitempty"`
}

func (m *Params_MetricInfo) Reset()                    { *m = Params_MetricInfo{} }
func (*Params_MetricInfo) ProtoMessage()               {}
func (*Params_MetricInfo) Descriptor() ([]byte, []int) { return fileDescriptorConfig, []int{0, 0} }

// Describes buckets for DISTRIBUTION kind metrics.
type Params_MetricInfo_BucketsDefinition struct {
	// Exactly one of these three fields must be set.
	//
	// Types that are valid to be assigned to Definition:
	//	*Params_MetricInfo_BucketsDefinition_LinearBuckets
	//	*Params_MetricInfo_BucketsDefinition_ExponentialBuckets
	//	*Params_MetricInfo_BucketsDefinition_ExplicitBuckets
	Definition isParams_MetricInfo_BucketsDefinition_Definition `protobuf_oneof:"definition"`
}

func (m *Params_MetricInfo_BucketsDefinition) Reset()      { *m = Params_MetricInfo_BucketsDefinition{} }
func (*Params_MetricInfo_BucketsDefinition) ProtoMessage() {}
func (*Params_MetricInfo_BucketsDefinition) Descriptor() ([]byte, []int) {
	return fileDescriptorConfig, []int{0, 0, 0}
}

type isParams_MetricInfo_BucketsDefinition_Definition interface {
	isParams_MetricInfo_BucketsDefinition_Definition()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Params_MetricInfo_BucketsDefinition_LinearBuckets struct {
	LinearBuckets *Params_MetricInfo_BucketsDefinition_Linear `protobuf:"bytes,1,opt,name=linear_buckets,json=linearBuckets,oneof"`
}
type Params_MetricInfo_BucketsDefinition_ExponentialBuckets struct {
	ExponentialBuckets *Params_MetricInfo_BucketsDefinition_Exponential `protobuf:"bytes,2,opt,name=exponential_buckets,json=exponentialBuckets,oneof"`
}
type Params_MetricInfo_BucketsDefinition_ExplicitBuckets struct {
	ExplicitBuckets *Params_MetricInfo_BucketsDefinition_Explicit `protobuf:"bytes,3,opt,name=explicit_buckets,json=explicitBuckets,oneof"`
}

func (*Params_MetricInfo_BucketsDefinition_LinearBuckets) isParams_MetricInfo_BucketsDefinition_Definition() {
}
func (*Params_MetricInfo_BucketsDefinition_ExponentialBuckets) isParams_MetricInfo_BucketsDefinition_Definition() {
}
func (*Params_MetricInfo_BucketsDefinition_ExplicitBuckets) isParams_MetricInfo_BucketsDefinition_Definition() {
}

func (m *Params_MetricInfo_BucketsDefinition) GetDefinition() isParams_MetricInfo_BucketsDefinition_Definition {
	if m != nil {
		return m.Definition
	}
	return nil
}

func (m *Params_MetricInfo_BucketsDefinition) GetLinearBuckets() *Params_MetricInfo_BucketsDefinition_Linear {
	if x, ok := m.GetDefinition().(*Params_MetricInfo_BucketsDefinition_LinearBuckets); ok {
		return x.LinearBuckets
	}
	return nil
}

func (m *Params_MetricInfo_BucketsDefinition) GetExponentialBuckets() *Params_MetricInfo_BucketsDefinition_Exponential {
	if x, ok := m.GetDefinition().(*Params_MetricInfo_BucketsDefinition_ExponentialBuckets); ok {
		return x.ExponentialBuckets
	}
	return nil
}

func (m *Params_MetricInfo_BucketsDefinition) GetExplicitBuckets() *Params_MetricInfo_BucketsDefinition_Explicit {
	if x, ok := m.GetDefinition().(*Params_MetricInfo_BucketsDefinition_ExplicitBuckets); ok {
		return x.ExplicitBuckets
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Params_MetricInfo_BucketsDefinition) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Params_MetricInfo_BucketsDefinition_OneofMarshaler, _Params_MetricInfo_BucketsDefinition_OneofUnmarshaler, _Params_MetricInfo_BucketsDefinition_OneofSizer, []interface{}{
		(*Params_MetricInfo_BucketsDefinition_LinearBuckets)(nil),
		(*Params_MetricInfo_BucketsDefinition_ExponentialBuckets)(nil),
		(*Params_MetricInfo_BucketsDefinition_ExplicitBuckets)(nil),
	}
}

func _Params_MetricInfo_BucketsDefinition_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Params_MetricInfo_BucketsDefinition)
	// definition
	switch x := m.Definition.(type) {
	case *Params_MetricInfo_BucketsDefinition_LinearBuckets:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.LinearBuckets); err != nil {
			return err
		}
	case *Params_MetricInfo_BucketsDefinition_ExponentialBuckets:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ExponentialBuckets); err != nil {
			return err
		}
	case *Params_MetricInfo_BucketsDefinition_ExplicitBuckets:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ExplicitBuckets); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Params_MetricInfo_BucketsDefinition.Definition has unexpected type %T", x)
	}
	return nil
}

func _Params_MetricInfo_BucketsDefinition_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Params_MetricInfo_BucketsDefinition)
	switch tag {
	case 1: // definition.linear_buckets
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Params_MetricInfo_BucketsDefinition_Linear)
		err := b.DecodeMessage(msg)
		m.Definition = &Params_MetricInfo_BucketsDefinition_LinearBuckets{msg}
		return true, err
	case 2: // definition.exponential_buckets
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Params_MetricInfo_BucketsDefinition_Exponential)
		err := b.DecodeMessage(msg)
		m.Definition = &Params_MetricInfo_BucketsDefinition_ExponentialBuckets{msg}
		return true, err
	case 3: // definition.explicit_buckets
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Params_MetricInfo_BucketsDefinition_Explicit)
		err := b.DecodeMessage(msg)
		m.Definition = &Params_MetricInfo_BucketsDefinition_ExplicitBuckets{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Params_MetricInfo_BucketsDefinition_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Params_MetricInfo_BucketsDefinition)
	// definition
	switch x := m.Definition.(type) {
	case *Params_MetricInfo_BucketsDefinition_LinearBuckets:
		s := proto.Size(x.LinearBuckets)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Params_MetricInfo_BucketsDefinition_ExponentialBuckets:
		s := proto.Size(x.ExponentialBuckets)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Params_MetricInfo_BucketsDefinition_ExplicitBuckets:
		s := proto.Size(x.ExplicitBuckets)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Specifies a linear sequence of buckets that all have the same width
// (except overflow and underflow). Each bucket represents a constant
// absolute uncertainty on the specific value in the bucket.
//
// There are `num_finite_buckets + 2` (= `N`) buckets. The two additional
// buckets are the underflow and overflow buckets.
//
// Bucket `i` has the following boundaries:
//
// * Upper bound (`0 <= i < N-1`): `offset + (width * i)`
// * Lower bound (`1 <= i < N`): `offset + (width * (i - 1))`
type Params_MetricInfo_BucketsDefinition_Linear struct {
	// Must be greater than 0.
	NumFiniteBuckets int32 `protobuf:"varint,1,opt,name=num_finite_buckets,json=numFiniteBuckets,proto3" json:"num_finite_buckets,omitempty"`
	// Must be greater than 0.
	Width float64 `protobuf:"fixed64,2,opt,name=width,proto3" json:"width,omitempty"`
	// Lower bound of the first bucket.
	Offset float64 `protobuf:"fixed64,3,opt,name=offset,proto3" json:"offset,omitempty"`
}

func (m *Params_MetricInfo_BucketsDefinition_Linear) Reset() {
	*m = Params_MetricInfo_BucketsDefinition_Linear{}
}
func (*Params_MetricInfo_BucketsDefinition_Linear) ProtoMessage() {}
func (*Params_MetricInfo_BucketsDefinition_Linear) Descriptor() ([]byte, []int) {
	return fileDescriptorConfig, []int{0, 0, 0, 0}
}

// Specifies an exponential sequence of buckets that have a width that is
// proportional to the value of the lower bound. Each bucket represents a
// constant relative uncertainty on a specific value in the bucket.
//
// There are `num_finite_buckets + 2` (= `N`) buckets. The two additional
// buckets are the underflow and overflow buckets.
//
// Bucket `i` has the following boundaries:
//
// * Upper bound (0 <= i < N-1): `scale * (growth_factor ^ i)`
// * Lower bound (1 <= i < N): `scale * (growth_factor ^ (i - 1))`
type Params_MetricInfo_BucketsDefinition_Exponential struct {
	// Must be greater than 0.
	NumFiniteBuckets int32 `protobuf:"varint,1,opt,name=num_finite_buckets,json=numFiniteBuckets,proto3" json:"num_finite_buckets,omitempty"`
	// Must be greater than 1.
	GrowthFactor float64 `protobuf:"fixed64,2,opt,name=growth_factor,json=growthFactor,proto3" json:"growth_factor,omitempty"`
	// Must be greater than 0.
	Scale float64 `protobuf:"fixed64,3,opt,name=scale,proto3" json:"scale,omitempty"`
}

func (m *Params_MetricInfo_BucketsDefinition_Exponential) Reset() {
	*m = Params_MetricInfo_BucketsDefinition_Exponential{}
}
func (*Params_MetricInfo_BucketsDefinition_Exponential) ProtoMessage() {}
func (*Params_MetricInfo_BucketsDefinition_Exponential) Descriptor() ([]byte, []int) {
	return fileDescriptorConfig, []int{0, 0, 0, 1}
}

// Specifies a set of buckets with arbitrary widths.
//
// There are `size(bounds) + 1` (= `N`) buckets. Bucket `i` has the following
// boundaries:
//
// * Upper bound (`0 <= i < N-1`): `bounds[i]`
// * Lower bound (`1 <= i < N`): `bounds[i - 1]`
//
// The `bounds` field must contain at least one element. If `bounds` has
// only one element, then there are no finite buckets, and that single
// element is the common boundary of the overflow and underflow buckets.
type Params_MetricInfo_BucketsDefinition_Explicit struct {
	// The values must be monotonically increasing.
	Bounds []float64 `protobuf:"fixed64,1,rep,packed,name=bounds" json:"bounds,omitempty"`
}

func (m *Params_MetricInfo_BucketsDefinition_Explicit) Reset() {
	*m = Params_MetricInfo_BucketsDefinition_Explicit{}
}
func (*Params_MetricInfo_BucketsDefinition_Explicit) ProtoMessage() {}
func (*Params_MetricInfo_BucketsDefinition_Explicit) Descriptor() ([]byte, []int) {
	return fileDescriptorConfig, []int{0, 0, 0, 2}
}

func init() {
	proto.RegisterType((*Params)(nil), "adapter.prometheus.config.Params")
	proto.RegisterType((*Params_MetricInfo)(nil), "adapter.prometheus.config.Params.MetricInfo")
	proto.RegisterType((*Params_MetricInfo_BucketsDefinition)(nil), "adapter.prometheus.config.Params.MetricInfo.BucketsDefinition")
	proto.RegisterType((*Params_MetricInfo_BucketsDefinition_Linear)(nil), "adapter.prometheus.config.Params.MetricInfo.BucketsDefinition.Linear")
	proto.RegisterType((*Params_MetricInfo_BucketsDefinition_Exponential)(nil), "adapter.prometheus.config.Params.MetricInfo.BucketsDefinition.Exponential")
	proto.RegisterType((*Params_MetricInfo_BucketsDefinition_Explicit)(nil), "adapter.prometheus.config.Params.MetricInfo.BucketsDefinition.Explicit")
	proto.RegisterEnum("adapter.prometheus.config.Params_MetricInfo_Kind", Params_MetricInfo_Kind_name, Params_MetricInfo_Kind_value)
}
func (x Params_MetricInfo_Kind) String() string {
	s, ok := Params_MetricInfo_Kind_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (m *Params) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Params) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Metrics) > 0 {
		for _, msg := range m.Metrics {
			dAtA[i] = 0xa
			i++
			i = encodeVarintConfig(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Params_MetricInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Params_MetricInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.InstanceName) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.InstanceName)))
		i += copy(dAtA[i:], m.InstanceName)
	}
	if len(m.Description) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.Description)))
		i += copy(dAtA[i:], m.Description)
	}
	if m.Kind != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.Kind))
	}
	if m.Buckets != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.Buckets.Size()))
		n1, err := m.Buckets.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if len(m.LabelNames) > 0 {
		for _, s := range m.LabelNames {
			dAtA[i] = 0x32
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.Namespace) > 0 {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.Namespace)))
		i += copy(dAtA[i:], m.Namespace)
	}
	return i, nil
}

func (m *Params_MetricInfo_BucketsDefinition) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Params_MetricInfo_BucketsDefinition) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Definition != nil {
		nn2, err := m.Definition.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn2
	}
	return i, nil
}

func (m *Params_MetricInfo_BucketsDefinition_LinearBuckets) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.LinearBuckets != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.LinearBuckets.Size()))
		n3, err := m.LinearBuckets.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	return i, nil
}
func (m *Params_MetricInfo_BucketsDefinition_ExponentialBuckets) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ExponentialBuckets != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.ExponentialBuckets.Size()))
		n4, err := m.ExponentialBuckets.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	return i, nil
}
func (m *Params_MetricInfo_BucketsDefinition_ExplicitBuckets) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ExplicitBuckets != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.ExplicitBuckets.Size()))
		n5, err := m.ExplicitBuckets.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	return i, nil
}
func (m *Params_MetricInfo_BucketsDefinition_Linear) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Params_MetricInfo_BucketsDefinition_Linear) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.NumFiniteBuckets != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.NumFiniteBuckets))
	}
	if m.Width != 0 {
		dAtA[i] = 0x11
		i++
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Width))))
		i += 8
	}
	if m.Offset != 0 {
		dAtA[i] = 0x19
		i++
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Offset))))
		i += 8
	}
	return i, nil
}

func (m *Params_MetricInfo_BucketsDefinition_Exponential) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Params_MetricInfo_BucketsDefinition_Exponential) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.NumFiniteBuckets != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.NumFiniteBuckets))
	}
	if m.GrowthFactor != 0 {
		dAtA[i] = 0x11
		i++
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.GrowthFactor))))
		i += 8
	}
	if m.Scale != 0 {
		dAtA[i] = 0x19
		i++
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Scale))))
		i += 8
	}
	return i, nil
}

func (m *Params_MetricInfo_BucketsDefinition_Explicit) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Params_MetricInfo_BucketsDefinition_Explicit) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Bounds) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.Bounds)*8))
		for _, num := range m.Bounds {
			f6 := math.Float64bits(float64(num))
			encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(f6))
			i += 8
		}
	}
	return i, nil
}

func encodeVarintConfig(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Params) Size() (n int) {
	var l int
	_ = l
	if len(m.Metrics) > 0 {
		for _, e := range m.Metrics {
			l = e.Size()
			n += 1 + l + sovConfig(uint64(l))
		}
	}
	return n
}

func (m *Params_MetricInfo) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.InstanceName)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.Kind != 0 {
		n += 1 + sovConfig(uint64(m.Kind))
	}
	if m.Buckets != nil {
		l = m.Buckets.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	if len(m.LabelNames) > 0 {
		for _, s := range m.LabelNames {
			l = len(s)
			n += 1 + l + sovConfig(uint64(l))
		}
	}
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	return n
}

func (m *Params_MetricInfo_BucketsDefinition) Size() (n int) {
	var l int
	_ = l
	if m.Definition != nil {
		n += m.Definition.Size()
	}
	return n
}

func (m *Params_MetricInfo_BucketsDefinition_LinearBuckets) Size() (n int) {
	var l int
	_ = l
	if m.LinearBuckets != nil {
		l = m.LinearBuckets.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	return n
}
func (m *Params_MetricInfo_BucketsDefinition_ExponentialBuckets) Size() (n int) {
	var l int
	_ = l
	if m.ExponentialBuckets != nil {
		l = m.ExponentialBuckets.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	return n
}
func (m *Params_MetricInfo_BucketsDefinition_ExplicitBuckets) Size() (n int) {
	var l int
	_ = l
	if m.ExplicitBuckets != nil {
		l = m.ExplicitBuckets.Size()
		n += 1 + l + sovConfig(uint64(l))
	}
	return n
}
func (m *Params_MetricInfo_BucketsDefinition_Linear) Size() (n int) {
	var l int
	_ = l
	if m.NumFiniteBuckets != 0 {
		n += 1 + sovConfig(uint64(m.NumFiniteBuckets))
	}
	if m.Width != 0 {
		n += 9
	}
	if m.Offset != 0 {
		n += 9
	}
	return n
}

func (m *Params_MetricInfo_BucketsDefinition_Exponential) Size() (n int) {
	var l int
	_ = l
	if m.NumFiniteBuckets != 0 {
		n += 1 + sovConfig(uint64(m.NumFiniteBuckets))
	}
	if m.GrowthFactor != 0 {
		n += 9
	}
	if m.Scale != 0 {
		n += 9
	}
	return n
}

func (m *Params_MetricInfo_BucketsDefinition_Explicit) Size() (n int) {
	var l int
	_ = l
	if len(m.Bounds) > 0 {
		n += 1 + sovConfig(uint64(len(m.Bounds)*8)) + len(m.Bounds)*8
	}
	return n
}

func sovConfig(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozConfig(x uint64) (n int) {
	return sovConfig(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *Params) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params{`,
		`Metrics:` + strings.Replace(fmt.Sprintf("%v", this.Metrics), "Params_MetricInfo", "Params_MetricInfo", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Params_MetricInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params_MetricInfo{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`InstanceName:` + fmt.Sprintf("%v", this.InstanceName) + `,`,
		`Description:` + fmt.Sprintf("%v", this.Description) + `,`,
		`Kind:` + fmt.Sprintf("%v", this.Kind) + `,`,
		`Buckets:` + strings.Replace(fmt.Sprintf("%v", this.Buckets), "Params_MetricInfo_BucketsDefinition", "Params_MetricInfo_BucketsDefinition", 1) + `,`,
		`LabelNames:` + fmt.Sprintf("%v", this.LabelNames) + `,`,
		`Namespace:` + fmt.Sprintf("%v", this.Namespace) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Params_MetricInfo_BucketsDefinition) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params_MetricInfo_BucketsDefinition{`,
		`Definition:` + fmt.Sprintf("%v", this.Definition) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Params_MetricInfo_BucketsDefinition_LinearBuckets) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params_MetricInfo_BucketsDefinition_LinearBuckets{`,
		`LinearBuckets:` + strings.Replace(fmt.Sprintf("%v", this.LinearBuckets), "Params_MetricInfo_BucketsDefinition_Linear", "Params_MetricInfo_BucketsDefinition_Linear", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Params_MetricInfo_BucketsDefinition_ExponentialBuckets) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params_MetricInfo_BucketsDefinition_ExponentialBuckets{`,
		`ExponentialBuckets:` + strings.Replace(fmt.Sprintf("%v", this.ExponentialBuckets), "Params_MetricInfo_BucketsDefinition_Exponential", "Params_MetricInfo_BucketsDefinition_Exponential", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Params_MetricInfo_BucketsDefinition_ExplicitBuckets) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params_MetricInfo_BucketsDefinition_ExplicitBuckets{`,
		`ExplicitBuckets:` + strings.Replace(fmt.Sprintf("%v", this.ExplicitBuckets), "Params_MetricInfo_BucketsDefinition_Explicit", "Params_MetricInfo_BucketsDefinition_Explicit", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Params_MetricInfo_BucketsDefinition_Linear) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params_MetricInfo_BucketsDefinition_Linear{`,
		`NumFiniteBuckets:` + fmt.Sprintf("%v", this.NumFiniteBuckets) + `,`,
		`Width:` + fmt.Sprintf("%v", this.Width) + `,`,
		`Offset:` + fmt.Sprintf("%v", this.Offset) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Params_MetricInfo_BucketsDefinition_Exponential) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params_MetricInfo_BucketsDefinition_Exponential{`,
		`NumFiniteBuckets:` + fmt.Sprintf("%v", this.NumFiniteBuckets) + `,`,
		`GrowthFactor:` + fmt.Sprintf("%v", this.GrowthFactor) + `,`,
		`Scale:` + fmt.Sprintf("%v", this.Scale) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Params_MetricInfo_BucketsDefinition_Explicit) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params_MetricInfo_BucketsDefinition_Explicit{`,
		`Bounds:` + fmt.Sprintf("%v", this.Bounds) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringConfig(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *Params) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Params: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Params: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Metrics", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Metrics = append(m.Metrics, &Params_MetricInfo{})
			if err := m.Metrics[len(m.Metrics)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Params_MetricInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MetricInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MetricInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InstanceName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.InstanceName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			m.Kind = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Kind |= (Params_MetricInfo_Kind(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Buckets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Buckets == nil {
				m.Buckets = &Params_MetricInfo_BucketsDefinition{}
			}
			if err := m.Buckets.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LabelNames", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LabelNames = append(m.LabelNames, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Params_MetricInfo_BucketsDefinition) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BucketsDefinition: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BucketsDefinition: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LinearBuckets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Params_MetricInfo_BucketsDefinition_Linear{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Definition = &Params_MetricInfo_BucketsDefinition_LinearBuckets{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExponentialBuckets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Params_MetricInfo_BucketsDefinition_Exponential{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Definition = &Params_MetricInfo_BucketsDefinition_ExponentialBuckets{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExplicitBuckets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Params_MetricInfo_BucketsDefinition_Explicit{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Definition = &Params_MetricInfo_BucketsDefinition_ExplicitBuckets{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Params_MetricInfo_BucketsDefinition_Linear) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Linear: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Linear: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumFiniteBuckets", wireType)
			}
			m.NumFiniteBuckets = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumFiniteBuckets |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Width", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Width = float64(math.Float64frombits(v))
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Offset", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Offset = float64(math.Float64frombits(v))
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Params_MetricInfo_BucketsDefinition_Exponential) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Exponential: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Exponential: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumFiniteBuckets", wireType)
			}
			m.NumFiniteBuckets = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumFiniteBuckets |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field GrowthFactor", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.GrowthFactor = float64(math.Float64frombits(v))
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scale", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Scale = float64(math.Float64frombits(v))
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Params_MetricInfo_BucketsDefinition_Explicit) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Explicit: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Explicit: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 1 {
				var v uint64
				if (iNdEx + 8) > l {
					return io.ErrUnexpectedEOF
				}
				v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
				iNdEx += 8
				v2 := float64(math.Float64frombits(v))
				m.Bounds = append(m.Bounds, v2)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowConfig
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthConfig
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint64
					if (iNdEx + 8) > l {
						return io.ErrUnexpectedEOF
					}
					v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
					iNdEx += 8
					v2 := float64(math.Float64frombits(v))
					m.Bounds = append(m.Bounds, v2)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Bounds", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipConfig(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthConfig
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowConfig
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipConfig(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthConfig = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowConfig   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("mixer/adapter/prometheus/config/config.proto", fileDescriptorConfig) }

var fileDescriptorConfig = []byte{
	// 624 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x54, 0x3f, 0x4f, 0xdb, 0x40,
	0x14, 0xf7, 0x91, 0x7f, 0xe4, 0x25, 0x80, 0x7b, 0x45, 0x95, 0x1b, 0x55, 0x6e, 0x04, 0x4b, 0x06,
	0xe4, 0xa8, 0x74, 0xe9, 0x54, 0x89, 0x80, 0x03, 0xe9, 0x9f, 0x80, 0x0e, 0x22, 0x55, 0x5d, 0x22,
	0xc7, 0xbe, 0x84, 0x13, 0xf1, 0x9d, 0x65, 0x5f, 0x0a, 0x4b, 0xa5, 0x8e, 0x1d, 0xbb, 0xf4, 0x3b,
	0xf4, 0xa3, 0x30, 0x32, 0x76, 0x6c, 0xdc, 0x85, 0x91, 0x8f, 0x50, 0xf9, 0x6c, 0x13, 0xaa, 0xaa,
	0x03, 0x62, 0x8a, 0xdf, 0x7b, 0xbf, 0x7f, 0xef, 0x45, 0x36, 0x6c, 0xf9, 0xec, 0x82, 0x86, 0x6d,
	0xc7, 0x73, 0x02, 0x49, 0xc3, 0x76, 0x10, 0x0a, 0x9f, 0xca, 0x53, 0x3a, 0x8b, 0xda, 0xae, 0xe0,
	0x63, 0x36, 0xc9, 0x7e, 0xac, 0x20, 0x14, 0x52, 0xe0, 0xa7, 0x19, 0xce, 0x5a, 0xe0, 0xac, 0x14,
	0xd0, 0x58, 0x9f, 0x88, 0x89, 0x50, 0xa8, 0x76, 0xf2, 0x94, 0x12, 0x36, 0xae, 0x97, 0xa1, 0x7c,
	0xe4, 0x84, 0x8e, 0x1f, 0xe1, 0x2e, 0x54, 0x7c, 0x2a, 0x43, 0xe6, 0x46, 0x06, 0x6a, 0x16, 0x5a,
	0xb5, 0xed, 0x2d, 0xeb, 0xbf, 0x6a, 0x56, 0xca, 0xb1, 0xde, 0x2b, 0x42, 0x8f, 0x8f, 0x05, 0xc9,
	0xc9, 0x8d, 0xef, 0xcb, 0x00, 0x8b, 0x3e, 0xc6, 0x50, 0xe4, 0x8e, 0x4f, 0x0d, 0xd4, 0x44, 0xad,
	0x2a, 0x51, 0xcf, 0x78, 0x13, 0x56, 0x18, 0x8f, 0xa4, 0xc3, 0x5d, 0x3a, 0x54, 0xc3, 0x25, 0x35,
	0xac, 0xe7, 0xcd, 0x7e, 0x02, 0x6a, 0x42, 0xcd, 0xa3, 0x91, 0x1b, 0xb2, 0x40, 0x32, 0xc1, 0x8d,
	0x82, 0x82, 0xdc, 0x6d, 0x61, 0x1b, 0x8a, 0x67, 0x8c, 0x7b, 0x46, 0xb1, 0x89, 0x5a, 0xab, 0xdb,
	0x2f, 0xee, 0x13, 0xd7, 0x7a, 0xcb, 0xb8, 0x47, 0x14, 0x1d, 0x7f, 0x80, 0xca, 0x68, 0xe6, 0x9e,
	0x51, 0x19, 0x19, 0xa5, 0x26, 0x6a, 0xd5, 0xb6, 0x5f, 0xdf, 0x4b, 0xa9, 0x93, 0x72, 0xf7, 0xe8,
	0x98, 0x71, 0x96, 0xe4, 0x22, 0xb9, 0x1c, 0x7e, 0x0e, 0xb5, 0xa9, 0x33, 0xa2, 0x53, 0xb5, 0x64,
	0x64, 0x94, 0x9b, 0x85, 0x56, 0x95, 0x80, 0x6a, 0x25, 0x2b, 0x46, 0xf8, 0x19, 0x54, 0xd5, 0x28,
	0x70, 0x5c, 0x6a, 0x54, 0xd4, 0x86, 0x8b, 0x46, 0xe3, 0x6b, 0x09, 0x1e, 0xfd, 0xa3, 0x8e, 0x39,
	0xac, 0x4e, 0x19, 0xa7, 0x4e, 0x38, 0xcc, 0x53, 0x23, 0x95, 0xda, 0x7e, 0x58, 0x6a, 0xeb, 0x9d,
	0x12, 0x3d, 0xd0, 0xc8, 0x4a, 0x2a, 0x9f, 0x21, 0xf0, 0x67, 0x78, 0x4c, 0x2f, 0x02, 0xc1, 0x29,
	0x97, 0xcc, 0x99, 0xde, 0x9a, 0x2e, 0x29, 0xd3, 0x37, 0x0f, 0x34, 0xb5, 0x17, 0xca, 0x07, 0x1a,
	0xc1, 0x77, 0x8c, 0x72, 0x7b, 0x09, 0x3a, 0xbd, 0x08, 0xa6, 0xcc, 0x65, 0xf2, 0xd6, 0xbb, 0xa0,
	0xbc, 0xf7, 0x1f, 0xee, 0xad, 0x64, 0x0f, 0x34, 0xb2, 0x96, 0x5b, 0x64, 0xa8, 0x86, 0x07, 0xe5,
	0xf4, 0x1e, 0x78, 0x0b, 0x30, 0x9f, 0xf9, 0x43, 0xc5, 0xa2, 0x7f, 0x9d, 0xbc, 0x44, 0x74, 0x3e,
	0xf3, 0xbb, 0x6a, 0x90, 0xa7, 0x5d, 0x87, 0xd2, 0x39, 0xf3, 0xe4, 0xa9, 0x3a, 0x0f, 0x22, 0x69,
	0x81, 0x9f, 0x40, 0x59, 0x8c, 0xc7, 0x11, 0x95, 0x2a, 0x39, 0x22, 0x59, 0xd5, 0xf8, 0x04, 0xb5,
	0x3b, 0x07, 0xb8, 0xa7, 0xd5, 0x26, 0xac, 0x4c, 0x42, 0x71, 0x2e, 0x4f, 0x87, 0x63, 0xc7, 0x95,
	0x22, 0xcc, 0x2c, 0xeb, 0x69, 0xb3, 0xab, 0x7a, 0x49, 0x9e, 0xc8, 0x75, 0xa6, 0x34, 0x33, 0x4e,
	0x8b, 0xc6, 0x06, 0x2c, 0xe7, 0xcb, 0x27, 0xd9, 0x46, 0x62, 0xc6, 0xbd, 0xf4, 0xad, 0x47, 0x24,
	0xab, 0x3a, 0x75, 0x00, 0xef, 0xf6, 0x56, 0x1b, 0x3b, 0x50, 0x4c, 0xde, 0x18, 0xbc, 0x06, 0xb5,
	0x41, 0xff, 0xf8, 0xc8, 0xde, 0xed, 0x75, 0x7b, 0xf6, 0x9e, 0xae, 0xe1, 0x2a, 0x94, 0xf6, 0x77,
	0x06, 0xfb, 0xb6, 0x8e, 0x70, 0x0d, 0x2a, 0xbb, 0x87, 0x83, 0xfe, 0x89, 0x4d, 0xf4, 0x25, 0xac,
	0x43, 0x7d, 0xaf, 0x77, 0x7c, 0x42, 0x7a, 0x9d, 0xc1, 0x49, 0xef, 0xb0, 0xaf, 0x17, 0x3a, 0xaf,
	0x2e, 0xe7, 0xa6, 0x76, 0x35, 0x37, 0xb5, 0x9f, 0x73, 0x53, 0xbb, 0x99, 0x9b, 0xda, 0x97, 0xd8,
	0x44, 0x3f, 0x62, 0x53, 0xbb, 0x8c, 0x4d, 0x74, 0x15, 0x9b, 0xe8, 0x57, 0x6c, 0xa2, 0xeb, 0xd8,
	0xd4, 0x6e, 0x62, 0x13, 0x7d, 0xfb, 0x6d, 0x6a, 0x1f, 0xcb, 0xe9, 0x9f, 0x39, 0x2a, 0xab, 0x6f,
	0xd5, 0xcb, 0x3f, 0x01, 0x00, 0x00, 0xff, 0xff, 0x78, 0x51, 0xcf, 0x2b, 0x0c, 0x05, 0x00, 0x00,
}
