// Copyright 2017 Istio Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This file was generated by github.com/nelsam/hel.  Do not
// edit this code by hand unless you *really* know what you're
// doing.  Expect any changes made manually to be overwritten
// the next time hel regenerates this file.

package cloudfoundry_test

import (
	"time"

	"code.cloudfoundry.org/copilot/api"
	"golang.org/x/net/context"
	"google.golang.org/grpc"
)

type mockCopilotClient struct {
	HealthCalled chan bool
	HealthInput  struct {
		Ctx  chan context.Context
		In   chan *api.HealthRequest
		Opts chan []grpc.CallOption
	}
	HealthOutput struct {
		Ret0 chan *api.HealthResponse
		Ret1 chan error
	}
	RoutesCalled chan bool
	RoutesInput  struct {
		Ctx  chan context.Context
		In   chan *api.RoutesRequest
		Opts chan []grpc.CallOption
	}
	RoutesOutput struct {
		Ret0 chan *api.RoutesResponse
		Ret1 chan error
	}
}

func newMockCopilotClient() *mockCopilotClient {
	m := &mockCopilotClient{}
	m.HealthCalled = make(chan bool, 100)
	m.HealthInput.Ctx = make(chan context.Context, 100)
	m.HealthInput.In = make(chan *api.HealthRequest, 100)
	m.HealthInput.Opts = make(chan []grpc.CallOption, 100)
	m.HealthOutput.Ret0 = make(chan *api.HealthResponse, 100)
	m.HealthOutput.Ret1 = make(chan error, 100)
	m.RoutesCalled = make(chan bool, 100)
	m.RoutesInput.Ctx = make(chan context.Context, 100)
	m.RoutesInput.In = make(chan *api.RoutesRequest, 100)
	m.RoutesInput.Opts = make(chan []grpc.CallOption, 100)
	m.RoutesOutput.Ret0 = make(chan *api.RoutesResponse, 100)
	m.RoutesOutput.Ret1 = make(chan error, 100)
	return m
}
func (m *mockCopilotClient) Health(ctx context.Context, in *api.HealthRequest, opts ...grpc.CallOption) (*api.HealthResponse, error) {
	m.HealthCalled <- true
	m.HealthInput.Ctx <- ctx
	m.HealthInput.In <- in
	m.HealthInput.Opts <- opts
	return <-m.HealthOutput.Ret0, <-m.HealthOutput.Ret1
}
func (m *mockCopilotClient) Routes(ctx context.Context, in *api.RoutesRequest, opts ...grpc.CallOption) (*api.RoutesResponse, error) {
	m.RoutesCalled <- true
	m.RoutesInput.Ctx <- ctx
	m.RoutesInput.In <- in
	m.RoutesInput.Opts <- opts
	return <-m.RoutesOutput.Ret0, <-m.RoutesOutput.Ret1
}

type mockContext struct {
	DeadlineCalled chan bool
	DeadlineOutput struct {
		Deadline chan time.Time
		Ok       chan bool
	}
	DoneCalled chan bool
	DoneOutput struct {
		Ret0 chan (<-chan struct{})
	}
	ErrCalled chan bool
	ErrOutput struct {
		Ret0 chan error
	}
	ValueCalled chan bool
	ValueInput  struct {
		Key chan interface{}
	}
	ValueOutput struct {
		Ret0 chan interface{}
	}
}

func newMockContext() *mockContext {
	m := &mockContext{}
	m.DeadlineCalled = make(chan bool, 100)
	m.DeadlineOutput.Deadline = make(chan time.Time, 100)
	m.DeadlineOutput.Ok = make(chan bool, 100)
	m.DoneCalled = make(chan bool, 100)
	m.DoneOutput.Ret0 = make(chan (<-chan struct{}), 100)
	m.ErrCalled = make(chan bool, 100)
	m.ErrOutput.Ret0 = make(chan error, 100)
	m.ValueCalled = make(chan bool, 100)
	m.ValueInput.Key = make(chan interface{}, 100)
	m.ValueOutput.Ret0 = make(chan interface{}, 100)
	return m
}
func (m *mockContext) Deadline() (deadline time.Time, ok bool) {
	m.DeadlineCalled <- true
	return <-m.DeadlineOutput.Deadline, <-m.DeadlineOutput.Ok
}
func (m *mockContext) Done() <-chan struct{} {
	m.DoneCalled <- true
	return <-m.DoneOutput.Ret0
}
func (m *mockContext) Err() error {
	m.ErrCalled <- true
	return <-m.ErrOutput.Ret0
}
func (m *mockContext) Value(key interface{}) interface{} {
	m.ValueCalled <- true
	m.ValueInput.Key <- key
	return <-m.ValueOutput.Ret0
}
